/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.marshal;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyData;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Error;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.encoding.MarshalEncoding;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.runtime.marshal.CoreObjectType;
import org.jruby.runtime.marshal.DataType;
import org.jruby.util.ByteList;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.collections.HashMapInt;
import org.jruby.util.io.RubyOutputStream;

public class MarshalDumper {
    private static final ByteList HASH_BYTELIST = new ByteList("Hash".getBytes(StandardCharsets.US_ASCII), false);
    private final int depthLimit;
    private int depth = 0;
    private final HashMapInt<IRubyObject> linkCache = new HashMapInt(true);
    private HashMapInt<RubySymbol> symbolCache;
    IRubyObject currentValue;
    boolean doVariables;
    int variableCount;

    public MarshalDumper(int depthLimit) {
        this.depthLimit = depthLimit >= 0 ? depthLimit : Integer.MAX_VALUE;
    }

    public void start(RubyOutputStream out) {
        out.write(4);
        out.write(8);
    }

    public void dumpObject(ThreadContext context, RubyOutputStream out, IRubyObject value2) {
        ++this.depth;
        if (this.depth > this.depthLimit) {
            throw Error.argumentError(context, "exceed depth limit");
        }
        this.writeAndRegister(context, out, value2);
        --this.depth;
    }

    public void registerLinkTarget(IRubyObject newObject2) {
        if (MarshalDumper.shouldBeRegistered(newObject2)) {
            this.register(newObject2);
        }
    }

    private static boolean shouldBeRegistered(IRubyObject value2) {
        RubyFixnum fixnum;
        return !(value2.isNil() || value2 instanceof RubyBoolean || value2 instanceof RubyFixnum && MarshalDumper.isMarshalFixnum(fixnum = (RubyFixnum)value2));
    }

    private static boolean isMarshalFixnum(RubyFixnum fixnum) {
        long value2 = fixnum.getValue();
        return value2 <= 0x3FFFFFFFL && value2 >= -1073741824L;
    }

    private void writeAndRegisterSymbol(RubyOutputStream out, RubySymbol sym) {
        if (this.isSymbolRegistered(sym)) {
            this.writeSymbolLink(out, this, sym);
        } else {
            this.registerSymbol(sym);
            this.dumpSymbol(out, sym.getBytes());
        }
    }

    private void writeAndRegister(ThreadContext context, RubyOutputStream out, IRubyObject value2) {
        if (!(value2 instanceof RubySymbol) && this.isRegistered(value2)) {
            this.writeLink(out, this, value2);
        } else {
            RubyBasicObject.getMetaClass(value2).smartDump(context, out, this, value2);
        }
    }

    public void writeDirectly(ThreadContext context, RubyOutputStream out, IRubyObject value2) {
        CoreObjectType coreObjectType;
        ClassIndex nativeClassIndex;
        if (!(value2 instanceof CoreObjectType) || (nativeClassIndex = (coreObjectType = (CoreObjectType)((Object)value2)).getNativeClassIndex()) == ClassIndex.OBJECT || nativeClassIndex == ClassIndex.BASICOBJECT) {
            this.writeObjectData(context, out, value2);
        } else {
            boolean shouldMarshalRuby2Keywords;
            RubyHash hash2;
            MarshalEncoding marshalEncoding;
            boolean shouldMarshalEncoding = value2 instanceof MarshalEncoding && (marshalEncoding = (MarshalEncoding)((Object)value2)).shouldMarshalEncoding();
            RubyHash keywordsHash = value2 instanceof RubyHash && (hash2 = (RubyHash)value2).isRuby2KeywordHash() ? hash2 : null;
            boolean bl = shouldMarshalRuby2Keywords = keywordsHash != null;
            if (!(shouldMarshalEncoding || shouldMarshalRuby2Keywords || !value2.isImmediate() && value2.hasVariables() && nativeClassIndex != ClassIndex.CLASS && nativeClassIndex != ClassIndex.MODULE)) {
                this.dumpBaseObject(context, out, value2, nativeClassIndex);
            } else {
                Map<String, VariableAccessor> ivarAccessors = this.checkVariables(value2, shouldMarshalEncoding, shouldMarshalRuby2Keywords);
                int size2 = this.variableCount;
                this.clearVariableState();
                if (this.doVariables) {
                    out.write(73);
                    this.dumpBaseObject(context, out, value2, nativeClassIndex);
                    if (shouldMarshalEncoding) {
                        this.writeInt(out, size2 + 1);
                        this.writeEncoding(context, out, ((MarshalEncoding)((Object)value2)).getMarshalEncoding());
                    } else if (shouldMarshalRuby2Keywords) {
                        this.writeInt(out, size2 + 1);
                        RubySymbol.SymbolTable symbolTable = context.runtime.getSymbolTable();
                        this.writeAndRegisterSymbol(out, symbolTable.getRuby2KeywordsHashSymbolK());
                        this.writeObjectData(context, out, Convert.asBoolean(context, keywordsHash.isRuby2KeywordHash()));
                    } else {
                        this.writeInt(out, size2);
                    }
                    ivarAccessors.forEach(new VariableDumper(context, out, value2));
                } else {
                    this.dumpBaseObject(context, out, value2, nativeClassIndex);
                }
            }
        }
    }

    private void clearVariableState() {
        this.currentValue = null;
    }

    private Map<String, VariableAccessor> checkVariables(IRubyObject value2, boolean shouldMarshalEncoding, boolean shouldMarshalRuby2Keywords) {
        this.currentValue = value2;
        this.doVariables = shouldMarshalEncoding | shouldMarshalRuby2Keywords;
        this.variableCount = 0;
        Map<String, VariableAccessor> ivarAccessors = RubyBasicObject.getMetaClass(value2).getVariableAccessorsForRead();
        ivarAccessors.forEach(this::checkVariablesForMarshal);
        return ivarAccessors;
    }

    private void dumpBaseObject(ThreadContext context, RubyOutputStream out, IRubyObject value2, ClassIndex nativeClassIndex) {
        this.dumpType(context, out, value2, nativeClassIndex);
        this.writeObjectData(context, out, value2);
    }

    private void dumpType(ThreadContext context, RubyOutputStream out, IRubyObject value2, ClassIndex nativeClassIndex) {
        RubyClass type2;
        RubyClass meta = RubyBasicObject.getMetaClass(value2);
        switch (nativeClassIndex) {
            case STRING: 
            case REGEXP: 
            case ARRAY: 
            case HASH: {
                RubyClass rubyClass = this.dumpExtended(context, out, meta);
                break;
            }
            default: {
                RubyClass rubyClass = type2 = meta;
            }
        }
        if (nativeClassIndex != meta.getClassIndex() && nativeClassIndex != ClassIndex.STRUCT && nativeClassIndex != ClassIndex.DATA && nativeClassIndex != ClassIndex.FIXNUM && nativeClassIndex != ClassIndex.BIGNUM) {
            this.writeUserClass(context, out, type2);
        }
    }

    public static RubySymbol getPathFromClass(ThreadContext context, RubyModule clazz) {
        RubyModule real2;
        Ruby runtime2 = context.runtime;
        RubySymbol pathSym = clazz.symbolName(context);
        if (pathSym == null) {
            String type2 = clazz.isClass() ? "class" : "module";
            throw Error.typeError(context, RubyStringBuilder.str(runtime2, "can't dump anonymous " + type2 + " ", RubyStringBuilder.types(runtime2, clazz)));
        }
        String path2 = pathSym.idString();
        RubyModule rubyModule = real2 = clazz.isModule() ? clazz : ((RubyClass)clazz).getRealClass();
        if (runtime2.getClassFromPath(path2) != real2) {
            throw Error.typeError(context, RubyStringBuilder.str(runtime2, RubyStringBuilder.types(runtime2, clazz), " can't be referred"));
        }
        return pathSym;
    }

    private void writeObjectData(ThreadContext context, RubyOutputStream out, IRubyObject value2) {
        if (value2 instanceof CoreObjectType) {
            if (value2 instanceof DataType) {
                Ruby runtime2 = context.runtime;
                throw Error.typeError(context, RubyStringBuilder.str(runtime2, "no _dump_data is defined for class ", RubyStringBuilder.types(runtime2, (RubyModule)RubyBasicObject.getMetaClass(value2))));
            }
            ClassIndex nativeClassIndex = ((CoreObjectType)((Object)value2)).getNativeClassIndex();
            switch (nativeClassIndex) {
                case ARRAY: {
                    out.write(91);
                    RubyArray.marshalTo(context, out, (RubyArray)value2, this);
                    return;
                }
                case FALSE: {
                    out.write(70);
                    return;
                }
                case FIXNUM: {
                    RubyFixnum fixnum = (RubyFixnum)value2;
                    if (MarshalDumper.isMarshalFixnum(fixnum)) {
                        out.write(105);
                        this.writeInt(out, fixnum.asInt(context));
                        return;
                    }
                    value2 = RubyBignum.newBignum(context.runtime, fixnum.getValue());
                }
                case BIGNUM: {
                    out.write(108);
                    RubyBignum.marshalTo(context, out, (RubyBignum)value2, this);
                    return;
                }
                case CLASS: {
                    if (((RubyClass)value2).isSingleton()) {
                        throw Error.typeError(context, "singleton class can't be dumped");
                    }
                    out.write(99);
                    RubyClass.marshalTo(context, out, (RubyClass)value2, this);
                    return;
                }
                case FLOAT: {
                    out.write(102);
                    RubyFloat.marshalTo(context, out, (RubyFloat)value2, this);
                    return;
                }
                case HASH: {
                    RubyHash hash2 = (RubyHash)value2;
                    if (hash2.isComparedByIdentity()) {
                        out.write(67);
                        this.dumpSymbol(out, HASH_BYTELIST);
                    }
                    if (hash2.getIfNone() == RubyBasicObject.UNDEF) {
                        out.write(123);
                    } else {
                        if (hash2.hasDefaultProc()) {
                            throw Error.typeError(context, "can't dump hash with default proc");
                        }
                        out.write(125);
                    }
                    RubyHash.marshalTo(context, out, hash2, this);
                    return;
                }
                case MODULE: {
                    out.write(109);
                    RubyModule.marshalTo(context, out, (RubyModule)value2, this);
                    return;
                }
                case NIL: {
                    out.write(48);
                    return;
                }
                case OBJECT: 
                case BASICOBJECT: {
                    RubyClass type2 = RubyBasicObject.getMetaClass(value2);
                    if (type2.isKindOfModule(context.runtime.getData())) {
                        RubyData.marshalTo(context, out, value2, this);
                        return;
                    }
                    this.dumpDefaultObjectHeader(context, out, type2);
                    type2.getRealClass().marshal(context, out, value2, this);
                    return;
                }
                case REGEXP: {
                    out.write(47);
                    RubyRegexp.marshalTo(context, (RubyRegexp)value2, this, out);
                    return;
                }
                case STRING: {
                    this.registerLinkTarget(value2);
                    out.write(34);
                    this.writeString(out, value2.convertToString().getByteList());
                    return;
                }
                case STRUCT: {
                    RubyStruct.marshalTo(context, out, (RubyStruct)value2, this);
                    return;
                }
                case SYMBOL: {
                    this.writeAndRegisterSymbol(out, (RubySymbol)value2);
                    return;
                }
                case TRUE: {
                    out.write(84);
                    return;
                }
            }
            Ruby runtime3 = context.runtime;
            throw Error.typeError(context, RubyStringBuilder.str(runtime3, "can't dump ", RubyStringBuilder.types(runtime3, (RubyModule)RubyBasicObject.getMetaClass(value2))));
        }
        RubyClass metaClass = RubyBasicObject.getMetaClass(value2);
        this.dumpDefaultObjectHeader(context, out, metaClass);
        metaClass.getRealClass().marshal(context, out, value2, this);
    }

    public void userNewMarshal(ThreadContext context, RubyOutputStream out, IRubyObject value2, CacheEntry entry) {
        this.userNewCommon(context, out, value2, entry);
    }

    public void userNewMarshal(ThreadContext context, RubyOutputStream out, IRubyObject value2) {
        this.userNewCommon(context, out, value2, null);
    }

    private void userNewCommon(ThreadContext context, RubyOutputStream out, IRubyObject value2, CacheEntry entry) {
        IRubyObject marshaled;
        this.registerLinkTarget(value2);
        out.write(85);
        RubyClass klass = RubyBasicObject.getMetaClass(value2);
        this.writeAndRegisterSymbol(out, Convert.asSymbol(context, klass.getRealClass().getName(context)));
        IRubyObject iRubyObject = marshaled = entry != null ? entry.method.call(context, value2, entry.sourceModule, "marshal_dump") : value2.callMethod(context, "marshal_dump");
        if (RubyBasicObject.getMetaClass(marshaled) == klass) {
            throw Error.runtimeError(context, "marshal_dump returned same class instance");
        }
        this.dumpObject(context, out, marshaled);
    }

    public void userMarshal(ThreadContext context, RubyOutputStream out, IRubyObject value2, CacheEntry entry) {
        this.userCommon(context, out, value2, entry);
    }

    public void userMarshal(ThreadContext context, RubyOutputStream out, IRubyObject value2) {
        this.userCommon(context, out, value2, null);
    }

    private void userCommon(ThreadContext context, RubyOutputStream out, IRubyObject value2, CacheEntry cacheEntry) {
        RubyFixnum depthLimitFixnum = Convert.asFixnum(context, this.depthLimit);
        RubyClass klass = RubyBasicObject.getMetaClass(value2);
        IRubyObject dumpResult = cacheEntry != null ? cacheEntry.method.call(context, value2, cacheEntry.sourceModule, "_dump", depthLimitFixnum) : value2.callMethod(context, "_dump", depthLimitFixnum);
        RubyString marshaled = Convert.castAsString(context, dumpResult);
        if (marshaled.hasVariables()) {
            Map<String, VariableAccessor> ivarAccessors = this.countVariables(marshaled);
            int size2 = this.variableCount;
            this.clearVariableState();
            if (size2 > 0) {
                out.write(73);
                this.dumpUserdefBase(context, out, klass, marshaled);
                this.writeInt(out, size2);
                ivarAccessors.forEach(new VariableDumper(context, out, marshaled));
            } else {
                this.dumpUserdefBase(context, out, klass, marshaled);
            }
        } else {
            this.dumpUserdefBase(context, out, klass, marshaled);
        }
        this.registerLinkTarget(value2);
    }

    private void dumpUserdefBase(ThreadContext context, RubyOutputStream out, RubyClass klass, RubyString marshaled) {
        out.write(117);
        this.writeAndRegisterSymbol(out, Convert.asSymbol(context, klass.getRealClass().getName(context)));
        this.writeString(out, marshaled.getByteList());
    }

    public void writeUserClass(ThreadContext context, RubyOutputStream out, RubyClass type2) {
        out.write(67);
        if (type2.getName(context).charAt(0) == '#') {
            Ruby runtime2 = context.runtime;
            throw Error.typeError(context, RubyStringBuilder.str(runtime2, "can't dump anonymous class ", RubyStringBuilder.types(runtime2, (RubyModule)type2)));
        }
        this.writeAndRegisterSymbol(out, Convert.asSymbol(context, type2.getName(context)));
    }

    public void dumpVariables(ThreadContext context, RubyOutputStream out, IRubyObject value2) {
        this.dumpVariables(context, out, value2, 0);
    }

    public void dumpVariables(ThreadContext context, RubyOutputStream out, IRubyObject value2, int extraSize) {
        Map<String, VariableAccessor> ivarAccessors = this.countVariables(value2, extraSize);
        int size2 = this.variableCount;
        this.clearVariableState();
        this.writeInt(out, size2);
        ivarAccessors.forEach(new VariableDumper(context, out, value2));
    }

    private Map<String, VariableAccessor> countVariables(IRubyObject value2) {
        return this.countVariables(value2, 0);
    }

    private Map<String, VariableAccessor> countVariables(IRubyObject value2, int extraSize) {
        this.currentValue = value2;
        this.variableCount = extraSize;
        Map<String, VariableAccessor> ivarAccessors = RubyBasicObject.getMetaClass(value2).getVariableAccessorsForRead();
        ivarAccessors.forEach(this::countVariablesForMarshal);
        return ivarAccessors;
    }

    public <T extends IRubyObject> void dumpVariables(ThreadContext context, RubyOutputStream out, T value2, int extraSize, VariableSupplier<T> extra) {
        this.dumpVariables(context, out, value2, extraSize);
        extra.forEach(this, context, out, value2, (m, c, o, name2, v) -> MarshalDumper.dumpVariable(c, o, m, name2, v));
    }

    private static void dumpVariable(ThreadContext context, RubyOutputStream out, MarshalDumper marshal, String name2, Object value2) {
        if (value2 instanceof IRubyObject) {
            marshal.writeAndRegisterSymbol(out, Convert.asSymbol(context, name2));
            marshal.dumpObject(context, out, (IRubyObject)value2);
        }
    }

    public void writeEncoding(ThreadContext context, RubyOutputStream out, Encoding encoding2) {
        RubySymbol.SymbolTable symbolTable = context.runtime.getSymbolTable();
        if (encoding2 == null || encoding2 == USASCIIEncoding.INSTANCE) {
            this.writeAndRegisterSymbol(out, symbolTable.getEncodingSymbolE());
            this.writeObjectData(context, out, context.fals);
        } else if (encoding2 == UTF8Encoding.INSTANCE) {
            this.writeAndRegisterSymbol(out, symbolTable.getEncodingSymbolE());
            this.writeObjectData(context, out, context.tru);
        } else {
            this.writeAndRegisterSymbol(out, symbolTable.getEncodingSymbol());
            RubyString encodingString = new RubyString(context.runtime, Access.stringClass(context), encoding2.getName());
            this.writeObjectData(context, out, encodingString);
        }
    }

    private boolean hasSingletonMethods(RubyClass type2) {
        for (DynamicMethod method2 : type2.getMethods().values()) {
            if (!method2.isImplementedBy(type2)) continue;
            return true;
        }
        return false;
    }

    private RubyClass dumpExtended(ThreadContext context, RubyOutputStream out, RubyClass type2) {
        if (type2.isSingleton()) {
            if (this.hasSingletonMethods(type2) || type2.hasVariables()) {
                throw Error.typeError(context, "singleton can't be dumped");
            }
            type2 = type2.getSuperClass();
        }
        while (type2.isIncluded()) {
            out.write(101);
            this.writeAndRegisterSymbol(out, Convert.asSymbol(context, type2.getOrigin().getName(context)));
            type2 = type2.getSuperClass();
        }
        return type2;
    }

    public void dumpDefaultObjectHeader(ThreadContext context, RubyOutputStream out, RubyClass type2) {
        this.dumpDefaultObjectHeader(context, out, 'o', type2);
    }

    public void dumpDefaultObjectHeader(ThreadContext context, RubyOutputStream out, char tp, RubyClass type2) {
        this.dumpExtended(context, out, type2);
        out.write(tp);
        this.writeAndRegisterSymbol(out, MarshalDumper.getPathFromClass(context, type2.getRealClass()));
    }

    public void writeString(RubyOutputStream out, String value2) {
        this.writeInt(out, value2.length());
        out.write(RubyString.stringToBytes(value2));
    }

    public void writeString(RubyOutputStream out, ByteList value2) {
        int len = value2.length();
        this.writeInt(out, len);
        out.write(value2.getUnsafeBytes(), value2.begin(), len);
    }

    public void dumpSymbol(RubyOutputStream out, ByteList value2) {
        out.write(58);
        int len = value2.length();
        this.writeInt(out, len);
        out.write(value2.getUnsafeBytes(), value2.begin(), len);
    }

    public void writeInt(RubyOutputStream out, int value2) {
        if (value2 == 0) {
            out.write(0);
        } else if (0 < value2 && value2 < 123) {
            out.write(value2 + 5);
        } else if (-124 < value2 && value2 < 0) {
            out.write(value2 - 5 & 0xFF);
        } else {
            int i2;
            byte[] buf = new byte[4];
            for (i2 = 0; i2 < buf.length; ++i2) {
                buf[i2] = (byte)(value2 & 0xFF);
                if ((value2 >>= 8) == 0 || value2 == -1) break;
            }
            int len = i2 + 1;
            int b2 = value2 < 0 ? -len : len;
            out.write(b2);
            out.write(buf, 0, i2 + 1);
        }
    }

    public void writeByte(RubyOutputStream out, int value2) {
        out.write(value2);
    }

    private void checkVariablesForMarshal(String name2, VariableAccessor accessor) {
        Object varValue = accessor.get(this.currentValue);
        if (!(varValue instanceof Serializable)) {
            return;
        }
        this.doVariables = true;
        ++this.variableCount;
    }

    private void countVariablesForMarshal(String name2, VariableAccessor accessor) {
        Object varValue = accessor.get(this.currentValue);
        if (!(varValue instanceof Serializable)) {
            return;
        }
        ++this.variableCount;
    }

    private HashMapInt<RubySymbol> getSymbolCache() {
        HashMapInt<RubySymbol> symbolCache = this.symbolCache;
        if (symbolCache == null) {
            this.symbolCache = symbolCache = new HashMapInt(true);
        }
        return symbolCache;
    }

    private boolean isRegistered(IRubyObject value2) {
        assert (!(value2 instanceof RubySymbol)) : "Use isSymbolRegistered for symbol links";
        return this.linkCache.containsKey(value2);
    }

    private boolean isSymbolRegistered(RubySymbol sym) {
        return this.getSymbolCache().containsKey(sym);
    }

    private void register(IRubyObject value2) {
        assert (!(value2 instanceof RubySymbol)) : "Use registeredSymbolIndex for symbols";
        this.linkCache.put(value2, this.linkCache.size());
    }

    private void registerSymbol(RubySymbol sym) {
        this.getSymbolCache().put(sym, this.getSymbolCache().size());
    }

    private void writeLink(RubyOutputStream out, MarshalDumper output, IRubyObject value2) {
        assert (!(value2 instanceof RubySymbol)) : "Use writeSymbolLink for symbols";
        out.write(64);
        output.writeInt(out, this.registeredIndex(value2));
    }

    private void writeSymbolLink(RubyOutputStream out, MarshalDumper output, RubySymbol sym) {
        out.write(59);
        output.writeInt(out, this.registeredSymbolIndex(sym));
    }

    private int registeredIndex(IRubyObject value2) {
        return this.linkCache.get(value2);
    }

    private int registeredSymbolIndex(RubySymbol sym) {
        return this.getSymbolCache().get(sym);
    }

    private class VariableDumper
    implements BiConsumer<String, VariableAccessor> {
        private final ThreadContext context;
        private final RubyOutputStream out;
        private final IRubyObject value;

        public VariableDumper(ThreadContext context, RubyOutputStream out, IRubyObject value2) {
            this.context = context;
            this.out = out;
            this.value = value2;
        }

        @Override
        public void accept(String name2, VariableAccessor accessor) {
            Object varValue = accessor.get(this.value);
            if (!(varValue instanceof Serializable)) {
                return;
            }
            MarshalDumper.dumpVariable(this.context, this.out, MarshalDumper.this, name2, varValue);
        }
    }

    public static interface VariableReceiver {
        public void receive(MarshalDumper var1, ThreadContext var2, RubyOutputStream var3, String var4, IRubyObject var5);
    }

    public static interface VariableSupplier<T> {
        public void forEach(MarshalDumper var1, ThreadContext var2, RubyOutputStream var3, T var4, VariableReceiver var5);
    }
}

