/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.jruby.RubyThread;
import org.jruby.internal.runtime.ThreadLike;
import org.jruby.runtime.backtrace.BacktraceData;

public class AdoptedNativeThread
implements ThreadLike {
    private final Reference<Thread> nativeThread;
    public final RubyThread rubyThread;

    public AdoptedNativeThread(RubyThread rubyThread, Thread nativeThread) {
        this.rubyThread = rubyThread;
        this.nativeThread = new WeakReference<Thread>(nativeThread);
    }

    @Override
    public void interrupt() {
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            thread2.interrupt();
        }
    }

    @Override
    public boolean isAlive() {
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            return thread2.isAlive();
        }
        return false;
    }

    @Override
    public void join() throws InterruptedException {
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            thread2.join();
        }
    }

    @Override
    public void join(long timeoutMillis) throws InterruptedException {
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            thread2.join(timeoutMillis);
        }
    }

    @Override
    public int getPriority() {
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            return thread2.getPriority();
        }
        return 0;
    }

    @Override
    public void setPriority(int priority2) {
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            thread2.setPriority(priority2);
        }
    }

    @Override
    public boolean isCurrent() {
        return this.getThread() == Thread.currentThread();
    }

    @Override
    public boolean isInterrupted() {
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            return thread2.isInterrupted();
        }
        return false;
    }

    final Thread getThread() {
        return this.nativeThread.get();
    }

    public String toString() {
        return String.valueOf(this.getThread());
    }

    @Override
    public Thread nativeThread() {
        return this.nativeThread.get();
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        Thread thread2 = this.nativeThread();
        if (thread2 == null) {
            return BacktraceData.EMPTY_STACK_TRACE;
        }
        return thread2.getStackTrace();
    }

    @Override
    public void setRubyName(String id) {
        try {
            Thread thread2 = this.getThread();
            if (thread2 != null) {
                thread2.setName(id);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    @Deprecated(since="9.2.0.0")
    public String getRubyName() {
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            return thread2.getName();
        }
        return null;
    }

    @Override
    public String getReportName() {
        String nativeName = "";
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            nativeName = thread2.getName();
        }
        return nativeName.equals("") ? "(unnamed)" : nativeName;
    }
}

