/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jruby.ast.NilImplicitNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;

public class ListNode
extends Node
implements Iterable<Node> {
    private static final Node[] EMPTY = new Node[0];
    private static final int INITIAL_SIZE = 4;
    private Node[] list = EMPTY;
    private int size = 0;
    private Node single;

    public ListNode(int line, Node firstNode) {
        super(line, firstNode != null && firstNode.containsVariableAssignment);
        this.single = firstNode;
        this.size = 1;
    }

    public ListNode(int line) {
        super(line, false);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.LISTNODE;
    }

    private Node[] growList(int mustBeDelta) {
        int newSize = this.list.length * 2;
        if (this.size + mustBeDelta >= newSize) {
            newSize = (int)((double)(this.size + mustBeDelta) * 1.5);
        }
        Node[] newList = new Node[newSize];
        System.arraycopy(this.list, 0, newList, 0, this.size);
        this.list = newList;
        return newList;
    }

    protected void addInternal(Node node) {
        Node single = this.single;
        if (single != null) {
            this.addToSingle(this.single, node);
            return;
        }
        if (this.size >= this.list.length) {
            this.growList(1);
        }
        this.list[this.size++] = node;
    }

    protected void addAllInternal(ListNode other) {
        Node otherSingle;
        if (other.size == 0) {
            return;
        }
        Node single = this.single;
        Node[] list2 = single != null ? this.arrayifySingle(single) : this.list;
        if (this.size + other.size() >= list2.length) {
            list2 = this.growList(other.size);
        }
        if ((otherSingle = other.single) != null) {
            list2[this.size++] = otherSingle;
            return;
        }
        System.arraycopy(other.list, 0, list2, this.size, other.size);
        this.size += other.size;
    }

    private void addToSingle(Node single, Node node) {
        this.arrayifySingle((Node)single)[this.size++] = node;
    }

    private Node[] arrayifySingle(Node single) {
        Node[] list2 = new Node[4];
        list2[0] = single;
        this.list = list2;
        this.single = null;
        return list2;
    }

    public ListNode add(Node node) {
        if (node == null || node == NilImplicitNode.NIL) {
            this.addInternal(NilImplicitNode.NIL);
            return this;
        }
        if (node.containsVariableAssignment()) {
            this.containsVariableAssignment = true;
        }
        this.addInternal(node);
        return this;
    }

    public int size() {
        return this.size;
    }

    public ListNode addAll(ListNode other) {
        if (other != null && other.size() > 0) {
            if (other.containsVariableAssignment()) {
                this.containsVariableAssignment = true;
            }
            this.addAllInternal(other);
        }
        return this;
    }

    public ListNode addAll(Node[] other, int index2, int length2) {
        Node single = this.single;
        if (single != null) {
            this.list = new Node[length2 + 1];
            this.list[0] = single;
            this.single = null;
            System.arraycopy(other, index2, this.list, 1, length2);
        }
        if (this.size + length2 < this.list.length) {
            this.growList(length2);
        }
        for (int i2 = 0; i2 < length2; ++i2) {
            this.addInternal(other[index2 + i2]);
        }
        return this;
    }

    public ListNode addAll(Node other) {
        return this.add(other);
    }

    public Node getLast() {
        int size2 = this.size;
        if (size2 == 0) {
            return null;
        }
        return this.get(size2 - 1);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Node[] children() {
        Node single = this.single;
        if (single != null) {
            return new Node[]{single};
        }
        Node[] properList = new Node[this.size];
        System.arraycopy(this.list, 0, properList, 0, this.size);
        return properList;
    }

    @Override
    @Deprecated(since="9.0.0.0")
    public List<Node> childNodes() {
        Node single = this.single;
        if (single != null) {
            return Collections.singletonList(single);
        }
        return Arrays.asList(this.children());
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visitListNode(this);
    }

    public Node get(int idx) {
        Node single = this.single;
        if (idx == 0 && single != null) {
            return single;
        }
        return this.list[idx];
    }

    @Override
    public Iterator<Node> iterator() {
        return new Iterator<Node>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < ListNode.this.list.length;
            }

            @Override
            public Node next() {
                if (this.i >= ListNode.this.list.length) {
                    throw new IndexOutOfBoundsException(String.valueOf(this.i));
                }
                return ListNode.this.list[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }
}

