/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFile;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Warn;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.Unrescuable;
import org.jruby.ext.rbconfig.RbConfigLibrary;
import org.jruby.platform.Platform;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.BasicLibraryService;
import org.jruby.runtime.load.ExternalScript;
import org.jruby.runtime.load.JarredScript;
import org.jruby.runtime.load.JavaCompiledScript;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LibrarySearcher;
import org.jruby.runtime.load.LoadServiceResource;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.URLUtil;
import org.jruby.util.collections.StringArraySet;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class LoadService {
    static final Logger LOG = LoggerFactory.getLogger(LoadService.class);
    private final LoadTimer loadTimer;
    @Deprecated(since="10.0.3.0")
    protected static final Pattern sourcePattern = Pattern.compile("\\.(?:rb)$");
    @Deprecated(since="10.0.3.0")
    protected static final Pattern extensionPattern = Pattern.compile("\\.(?:so|o|jar)$");
    protected RubyArray loadPath;
    protected StringArraySet loadedFeatures;
    @Deprecated(since="10.0.3.0")
    protected final Map<String, JarFile> jarFiles = new HashMap<String, JarFile>(0);
    protected final Ruby runtime;
    protected LibrarySearcher librarySearcher;
    protected String mainScript;
    protected String mainScriptPath;
    private final ThreadLocal<RubyModule> wrapperSelf = new ThreadLocal();
    final RequireLocks requireLocks = new RequireLocks();
    private static final Pattern URI_PATTERN = Pattern.compile("([a-z]+?://.*)$");

    public LoadService(Ruby runtime2) {
        this.runtime = runtime2;
        this.loadTimer = RubyInstanceConfig.DEBUG_LOAD_TIMINGS ? new TracingLoadTimer() : new LoadTimer();
    }

    public void init(List<String> prependDirectories) {
        ThreadContext context = this.runtime.getCurrentContext();
        this.loadPath = Create.newArray(context);
        this.loadPath.getMetaClass().defineMethods(context, LoadPathMethods.class);
        String jrubyHome = this.runtime.getJRubyHome();
        this.loadedFeatures = new StringArraySet(this.runtime);
        this.librarySearcher = new LibrarySearcher(this);
        this.addPaths(prependDirectories);
        RubyHash env = (RubyHash)Access.objectClass(context).getConstant(context, "ENV");
        RubyString env_rubylib = Create.newString(context, "RUBYLIB");
        if (env.has_key_p(context, env_rubylib).isTrue()) {
            String rubylib = env.op_aref(context, env_rubylib).toString();
            String[] paths = rubylib.split(File.pathSeparator);
            this.addPaths(paths);
        }
        try {
            if (jrubyHome != null) {
                String rubygemsDir;
                this.addPath(RbConfigLibrary.getSiteDir(this.runtime));
                if (!RbConfigLibrary.isSiteVendorSame(this.runtime).booleanValue()) {
                    this.addPath(RbConfigLibrary.getVendorDir(this.runtime));
                }
                if ((rubygemsDir = RbConfigLibrary.getRubygemsDir(this.runtime)) != null) {
                    this.addPath(rubygemsDir);
                }
                this.addPath(RbConfigLibrary.getRubyLibDir(this.runtime));
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.addPaths(this.runtime.getInstanceConfig().getExtraLoadPaths());
    }

    public void addPaths(List<String> additionalDirectories) {
        for (String dir : additionalDirectories) {
            this.addPath(dir);
        }
    }

    public void addPaths(String ... additionalDirectories) {
        for (String dir : additionalDirectories) {
            this.addPath(dir);
        }
    }

    public void provide(String name2) {
        this.librarySearcher.provideFeature(this.runtime.newString(name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPath(String path2) {
        RubyArray loadPath;
        if (path2 == null || path2.isEmpty()) {
            return;
        }
        RubyArray rubyArray = loadPath = this.loadPath;
        synchronized (rubyArray) {
            RubyString pathToAdd = this.runtime.newString(path2.replace('\\', '/'));
            ThreadContext context = this.runtime.getCurrentContext();
            if (loadPath.includes(context, pathToAdd)) {
                return;
            }
            loadPath.append(context, pathToAdd);
        }
    }

    public RubyModule getWrapperSelf() {
        return this.wrapperSelf.get();
    }

    public void load(String file2, IRubyObject wrapWith) {
        if (wrapWith == null || !wrapWith.isTrue()) {
            this.load(file2, false);
            return;
        }
        if (wrapWith instanceof RubyModule) {
            this.wrapperSelf.set((RubyModule)wrapWith);
            try {
                this.load(file2, true);
            }
            finally {
                this.wrapperSelf.remove();
            }
        } else {
            this.load(file2, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String file2, boolean wrap2) {
        long startTime = this.loadTimer.startLoad(file2);
        int currentLine = this.runtime.getCurrentLine();
        try {
            if (!this.runtime.getProfile().allowLoad(file2)) {
                throw LoadService.loadFailed(this.runtime, file2);
            }
            LibrarySearcher.FoundLibrary library2 = this.librarySearcher.findLibraryForLoad(file2);
            if (library2 == null) {
                FileResource fileResource = JRubyFile.createResourceAsFile(this.runtime, file2);
                if (!fileResource.exists()) {
                    throw LoadService.loadFailed(this.runtime, file2);
                }
                library2 = new LibrarySearcher.FoundLibrary(file2, file2, LibrarySearcher.ResourceLibrary.create(file2, file2, fileResource));
            }
            try {
                library2.load(this.runtime, wrap2);
            }
            catch (IOException ex) {
                throw this.runtime.newIOErrorFromException(ex);
            }
        }
        finally {
            this.runtime.setCurrentLine(currentLine);
            this.loadTimer.endLoad(file2, startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromClassLoader(ClassLoader classLoader, String file2, boolean wrap2) {
        long startTime = this.loadTimer.startLoad("classloader:" + file2);
        int currentLine = this.runtime.getCurrentLine();
        try {
            String[] fileHolder = new String[]{file2};
            LibrarySearcher.getSuffixTypeForLoad(fileHolder);
            String baseName = fileHolder[0];
            LoadServiceResource resource = this.getClassPathResource(classLoader, file2);
            if (resource == null) {
                throw LoadService.loadFailed(this.runtime, file2);
            }
            String loadName = this.resolveLoadName(resource, file2);
            LibrarySearcher.FoundLibrary library2 = new LibrarySearcher.FoundLibrary(baseName, loadName, this.createLibrary(baseName, loadName, resource));
            try {
                library2.load(this.runtime, wrap2);
            }
            catch (IOException e) {
                throw this.runtime.newIOErrorFromException(e);
            }
        }
        finally {
            this.runtime.setCurrentLine(currentLine);
            this.loadTimer.endLoad("classloader:" + file2, startTime);
        }
    }

    public boolean require(String requireName) {
        return this.smartLoadInternal(requireName, true) == RequireState.LOADED;
    }

    public boolean autoloadRequire(RubyString requireName) {
        return this.runtime.getTopSelf().callMethod(this.runtime.getCurrentContext(), "require", requireName).isTrue();
    }

    protected void warnCircularRequire(String requireName) {
        ThreadContext context = this.runtime.getCurrentContext();
        StringBuilder sb = new StringBuilder("loading in progress, circular require considered harmful - " + requireName);
        sb.append("\n");
        context.renderCurrentBacktrace(sb);
        Warn.warn(context, sb.toString());
    }

    private RequireState smartLoadInternal(String file2, boolean circularRequireWarning) {
        this.checkEmptyLoad(file2);
        if (!this.runtime.getProfile().allowRequire(file2)) {
            throw LoadService.loadFailed(this.runtime, file2);
        }
        LibrarySearcher.FoundLibrary[] libraryHolder = new LibrarySearcher.FoundLibrary[]{null};
        char found = this.searchForRequire(file2, libraryHolder);
        if (found == '\u0000') {
            throw LoadService.loadFailed(this.runtime, file2);
        }
        LibrarySearcher.FoundLibrary library2 = libraryHolder[0];
        if (library2 == null) {
            return RequireState.ALREADY_LOADED;
        }
        String loadName = library2.getLoadName();
        return this.requireLocks.lock(loadName, circularRequireWarning, RequireState.ALREADY_LOADED, name2 -> {
            if (this.librarySearcher.getLoadedFeature((String)name2) != null) {
                return RequireState.ALREADY_LOADED;
            }
            if (name2.length() == 0) {
                this.provide((String)name2);
                return RequireState.LOADED;
            }
            long startTime = this.loadTimer.startLoad((String)name2);
            try {
                this.tryLoadingLibraryOrScript(this.runtime, library2, library2.getSearchName());
                this.provide((String)name2);
                RequireState requireState = RequireState.LOADED;
                return requireState;
            }
            finally {
                this.loadTimer.endLoad((String)name2, startTime);
            }
        });
    }

    public static void reflectedLoad(Ruby runtime2, String libraryName, String className, ClassLoader classLoader, boolean wrap2) {
        block6: {
            try {
                Object libObject;
                if (classLoader == null && Ruby.isSecurityRestricted()) {
                    classLoader = runtime2.getInstanceConfig().getLoader();
                }
                if ((libObject = classLoader.loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0])) instanceof Library) {
                    Library library2 = (Library)libObject;
                    library2.load(runtime2, false);
                    break block6;
                }
                if (libObject instanceof BasicLibraryService) {
                    BasicLibraryService service = (BasicLibraryService)libObject;
                    service.basicLoad(runtime2);
                    break block6;
                }
                throw runtime2.newLoadError("library '" + libraryName + "' is not of type Library or BasicLibraryService", libraryName);
            }
            catch (RaiseException re) {
                throw re;
            }
            catch (Throwable e) {
                LoadService.debugLoadException(runtime2, e);
                throw runtime2.newLoadError("library '" + libraryName + "' could not be loaded: " + String.valueOf(e), libraryName);
            }
        }
    }

    private static void debugLoadException(Ruby runtime2, Throwable ex) {
        if (runtime2.isDebug()) {
            ex.printStackTrace(runtime2.getErr());
        }
    }

    public IRubyObject getLoadPath() {
        return this.loadPath;
    }

    public IRubyObject getLoadedFeatures() {
        return this.loadedFeatures;
    }

    protected boolean isJarfileLibrary(Library library2, String file2) {
        return library2 instanceof JarredScript && file2.endsWith(".jar");
    }

    protected boolean tryLoadingLibraryOrScript(Ruby runtime2, Library library2, String searchFile) {
        try {
            library2.load(runtime2, false);
            return true;
        }
        catch (RaiseException ex) {
            if (ex instanceof Unrescuable || !this.isJarfileLibrary(library2, searchFile)) {
                throw ex;
            }
            return true;
        }
        catch (JumpException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw runtime2.newIOErrorFromException(ex);
        }
        catch (Throwable ex) {
            if (ex instanceof Unrescuable || !this.isJarfileLibrary(library2, searchFile)) {
                Helpers.throwException(ex);
            }
            return true;
        }
    }

    protected void checkEmptyLoad(String file2) throws RaiseException {
        if (file2.isEmpty()) {
            throw LoadService.loadFailed(this.runtime, file2);
        }
    }

    protected final void debugLogTry(String what, String msg) {
        if (RubyInstanceConfig.DEBUG_LOAD_SERVICE) {
            LOG.info("trying {}: {}", what, msg);
        }
    }

    protected final void debugLogFound(LoadServiceResource resource) {
        if (RubyInstanceConfig.DEBUG_LOAD_SERVICE) {
            String resourceUrl;
            try {
                resourceUrl = resource.getURL().toString();
            }
            catch (IOException e) {
                resourceUrl = e.getMessage();
            }
            LOG.info("found: {}", resourceUrl);
        }
    }

    protected final void debugLogFound(String what, String msg) {
        if (RubyInstanceConfig.DEBUG_LOAD_SERVICE) {
            LOG.info("found {}: {}", what, msg);
        }
    }

    public char searchForRequire(String file2, LibrarySearcher.FoundLibrary[] path2) {
        return this.librarySearcher.findLibraryForRequire(file2, path2);
    }

    protected LibrarySearcher.FoundLibrary searchForLoad(String file2) {
        return this.librarySearcher.findLibraryForLoad(file2);
    }

    public boolean featureAlreadyLoaded(String feature) {
        return this.librarySearcher.featureAlreadyLoaded(feature, null);
    }

    public boolean featureAlreadyLoaded(String feature, String[] loading) {
        return this.librarySearcher.featureAlreadyLoaded(feature, loading);
    }

    protected LibrarySearcher.FoundLibrary findLibraryWithClassloaders(String baseName, SuffixType suffixType) {
        for (LibrarySearcher.Suffix suffix : suffixType.getSuffixSet()) {
            String file2 = baseName + String.valueOf((Object)suffix);
            LoadServiceResource resource = this.findFileInClasspath(file2);
            if (resource == null) continue;
            String loadName = this.resolveLoadName(resource, file2);
            return new LibrarySearcher.FoundLibrary(baseName, loadName, this.createLibrary(baseName, loadName, resource));
        }
        return null;
    }

    protected Library createLibrary(String baseName, String loadName, LoadServiceResource resource) {
        if (resource == null) {
            return null;
        }
        String file2 = resource.getName();
        String location = loadName;
        if (file2.endsWith(".so") || file2.endsWith(".dll") || file2.endsWith(".bundle")) {
            throw this.runtime.newLoadError("C extensions are not supported, can't load '" + resource.getName() + "'", resource.getName());
        }
        if (file2.endsWith(".jar")) {
            return new JarredScript(resource, baseName);
        }
        if (file2.endsWith(".class")) {
            return new JavaCompiledScript(resource);
        }
        return new ExternalScript(resource, location);
    }

    static RaiseException loadFailed(Ruby runtime2, String name2) {
        return runtime2.newLoadError("cannot load such file -- " + name2, name2);
    }

    protected String getLoadPathEntry(IRubyObject entry) {
        return RubyFile.get_path(this.runtime.getCurrentContext(), entry).asJavaString();
    }

    protected LoadServiceResource findFileInClasspath(String name2) {
        ClassLoader classLoader = this.runtime.getJRubyClassLoader();
        if (Ruby.isSecurityRestricted() && classLoader == null) {
            classLoader = this.runtime.getInstanceConfig().getLoader();
        }
        if (name2.startsWith("classpath:/")) {
            LoadServiceResource foundResource = this.getClassPathResource(classLoader, name2);
            if (foundResource != null) {
                return foundResource;
            }
        } else if (name2.startsWith("classpath:")) {
            name2 = name2.substring("classpath:".length());
        }
        for (int i2 = 0; i2 < this.loadPath.size(); ++i2) {
            String entry = this.getLoadPathEntry((IRubyObject)this.loadPath.eltInternal(i2));
            if (entry.length() == 0 || entry.charAt(0) == '/' || entry.length() > 1 && entry.charAt(1) == ':') continue;
            if (entry.startsWith("classpath:/")) {
                entry = entry.substring("classpath:/".length());
            } else if (entry.startsWith("classpath:")) {
                entry = entry.substring("classpath:".length());
            }
            String entryName = name2.startsWith(entry) ? name2.substring(entry.length()) : name2;
            LoadServiceResource foundResource = this.getClassPathResource(classLoader, entry + "/" + entryName);
            if (foundResource == null) continue;
            return foundResource;
        }
        if (name2.charAt(0) == '/' || name2.length() > 1 && name2.charAt(1) == ':') {
            return null;
        }
        LoadServiceResource foundResource = this.getClassPathResource(classLoader, name2);
        if (foundResource != null) {
            return foundResource;
        }
        return null;
    }

    protected static boolean isRequireable(URL loc) {
        if (loc != null) {
            if (loc.getProtocol().equals("file") && new File(URLUtil.getPath(loc)).isDirectory()) {
                return false;
            }
            try {
                loc.openConnection();
                return true;
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return false;
    }

    public LoadServiceResource getClassPathResource(ClassLoader classLoader, String name2) {
        URL loc;
        boolean isClasspathScheme = false;
        if (name2.startsWith("classpath:/")) {
            isClasspathScheme = true;
            name2 = name2.substring("classpath:/".length());
        } else if (name2.startsWith("classpath:")) {
            isClasspathScheme = true;
            name2 = name2.substring("classpath:".length());
        } else if (name2.startsWith("file:") && name2.indexOf("!/") != -1) {
            name2 = name2.substring(name2.indexOf("!/") + 2);
        }
        Matcher m = URI_PATTERN.matcher(name2);
        if (m.matches()) {
            this.debugLogTry("fileInClassloader", m.group(1));
            try {
                loc = new URL(m.group(1).replaceAll("([^:])//", "$1/"));
                loc.openStream();
            }
            catch (IOException e) {
                loc = null;
            }
        } else {
            this.debugLogTry("fileInClasspath", name2);
            try {
                loc = classLoader.getResource(name2);
            }
            catch (IllegalArgumentException e) {
                loc = null;
            }
        }
        if (loc != null) {
            String path2 = LoadService.classpathFilenameFromURL(name2, loc, isClasspathScheme);
            LoadServiceResource foundResource = new LoadServiceResource(loc, path2);
            this.debugLogFound(foundResource);
            return foundResource;
        }
        return null;
    }

    public static String classpathFilenameFromURL(String name2, URL loc, boolean isClasspathScheme) {
        Object path2 = "classpath:/" + name2;
        if (!isClasspathScheme && (loc.getProtocol().equals("jar") || loc.getProtocol().equals("file")) && LoadService.isRequireable(loc)) {
            path2 = URLUtil.getPath(loc);
            if (Platform.IS_WINDOWS && loc.getProtocol().equals("file")) {
                path2 = new File((String)path2).getPath();
            }
        }
        return path2;
    }

    protected String resolveLoadName(LoadServiceResource foundResource, String previousPath) {
        String path2 = foundResource.getAbsolutePath();
        if (Platform.IS_WINDOWS) {
            path2 = path2.replace('\\', '/');
        }
        return path2;
    }

    public String getMainScript() {
        return this.mainScript;
    }

    public String getMainScriptPath() {
        return this.mainScriptPath;
    }

    public void setMainScript(String filename2, String cwd) {
        this.mainScript = filename2;
        File mainFile = new File(filename2);
        if (!mainFile.isAbsolute()) {
            mainFile = new File(cwd, filename2);
        }
        this.mainScriptPath = mainFile.exists() ? mainFile.getAbsolutePath() : filename2;
    }

    public String getPathForLocation(String filename2) {
        if (filename2.equals(this.mainScript)) {
            return this.mainScriptPath;
        }
        return filename2;
    }

    public void tearDown() {
        this.loadedFeatures.clear();
        this.librarySearcher.tearDown();
    }

    final class RequireLocks {
        final ConcurrentHashMap<String, RequireLock> pool = new ConcurrentHashMap(8, 0.75f, 2);

        private RequireLocks() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RequireState lock(String path2, boolean circularRequireWarning, RequireState defaultResult, Function<String, RequireState> ifLocked) {
            RequireLock lock2;
            ThreadContext currentContext = LoadService.this.runtime.getCurrentContext();
            RubyThread thread2 = currentContext.getThread();
            do {
                if ((lock2 = this.pool.get(path2)) == null) {
                    RequireLock newLock = new RequireLock();
                    lock2 = this.pool.computeIfAbsent(path2, name2 -> {
                        thread2.lock(newLock);
                        return newLock;
                    });
                    RequireState state2 = null;
                    if (lock2 == newLock) {
                        try {
                            RequireState requireState = state2 = this.executeAndClearLock(path2, ifLocked, thread2, lock2);
                            return requireState;
                        }
                        finally {
                            if (state2 == null) {
                                this.pool.remove(path2);
                            }
                        }
                    }
                }
                if (lock2.isHeldByCurrentThread()) {
                    if (circularRequireWarning && LoadService.this.runtime.isVerbose()) {
                        LoadService.this.warnCircularRequire(path2);
                    }
                    return null;
                }
                while (true) {
                    try {
                        thread2.lockInterruptibly(lock2);
                    }
                    catch (InterruptedException ie) {
                        currentContext.pollThreadEvents();
                        continue;
                    }
                    break;
                }
                thread2.unlock(lock2);
            } while (!lock2.destroyed);
            return defaultResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RequireState executeAndClearLock(String path2, Function<String, RequireState> ifLocked, RubyThread thread2, RequireLock lock2) {
            boolean destroyLock = false;
            try {
                RequireState state2 = ifLocked.apply(path2);
                destroyLock = true;
                RequireState requireState = state2;
                return requireState;
            }
            finally {
                if (destroyLock) {
                    lock2.destroyed = true;
                    this.pool.remove(path2);
                }
                thread2.unlock(lock2);
            }
        }

        final class RequireLock
        extends ReentrantLock {
            volatile boolean destroyed;

            RequireLock() {
            }
        }
    }

    private static final class TracingLoadTimer
    extends LoadTimer {
        private final AtomicInteger indent = new AtomicInteger(0);

        private TracingLoadTimer() {
        }

        private StringBuilder getIndentString() {
            int i2 = this.indent.get();
            StringBuilder buf = new StringBuilder(i2 * 2);
            for (int j = 0; j < i2; ++j) {
                buf.append(' ').append(' ');
            }
            return buf;
        }

        @Override
        public long startLoad(String file2) {
            this.indent.incrementAndGet();
            LOG.info("{}-> {}", this.getIndentString(), file2);
            return System.currentTimeMillis();
        }

        @Override
        public void endLoad(String file2, long startTime) {
            LOG.info("{}<- {} - {}ms", this.getIndentString(), file2, System.currentTimeMillis() - startTime);
            this.indent.decrementAndGet();
        }
    }

    private static class LoadTimer {
        private LoadTimer() {
        }

        public long startLoad(String file2) {
            return 0L;
        }

        public void endLoad(String file2, long startTime) {
        }
    }

    public static class LoadPathMethods {
        @JRubyMethod
        public static IRubyObject resolve_feature_path(ThreadContext context, IRubyObject self2, IRubyObject pathArg) {
            RubyString name2;
            RubySymbol ext2;
            RubyString path2 = RubyFile.get_path(context, pathArg);
            LibrarySearcher.FoundLibrary[] libraryHolder = new LibrarySearcher.FoundLibrary[]{null};
            char extension = Access.loadService(context).searchForRequire(path2.toString(), libraryHolder);
            if (extension == '\u0000') {
                return context.nil;
            }
            switch (extension) {
                case 'r': {
                    RubySymbol rubySymbol = Convert.asSymbol(context, "rb");
                    break;
                }
                case 's': {
                    RubySymbol rubySymbol = Convert.asSymbol(context, "so");
                    break;
                }
                default: {
                    RubySymbol rubySymbol = ext2 = Convert.asSymbol(context, "unknown");
                }
            }
            if (libraryHolder[0] == null) {
                ext2 = Convert.asSymbol(context, "so");
                name2 = path2;
            } else {
                name2 = Create.newString(context, libraryHolder[0].getLoadName());
            }
            return Create.newArray(context, (IRubyObject)ext2, (IRubyObject)name2);
        }
    }

    public static enum SuffixType {
        Source(LibrarySearcher.Suffix.SOURCES),
        Extension(LibrarySearcher.Suffix.EXTENSIONS),
        Both(LibrarySearcher.Suffix.ALL),
        Neither(EnumSet.noneOf(LibrarySearcher.Suffix.class));

        public final EnumSet<LibrarySearcher.Suffix> suffixes;
        @Deprecated(since="9.3.0.0")
        public static final String[] sourceSuffixes;
        @Deprecated(since="9.3.0.0")
        public static final String[] extensionSuffixes;

        private SuffixType(EnumSet suffixes) {
            this.suffixes = suffixes;
        }

        public EnumSet<LibrarySearcher.Suffix> getSuffixSet() {
            return this.suffixes;
        }

        @Deprecated(since="9.3.0.0")
        public String[] getSuffixes() {
            return (String[])this.suffixes.stream().map(suffix -> suffix.name()).toArray(String[]::new);
        }

        static {
            sourceSuffixes = (String[])LibrarySearcher.Suffix.SOURCES.stream().map(suffix -> suffix.name()).toArray(String[]::new);
            extensionSuffixes = (String[])LibrarySearcher.Suffix.EXTENSIONS.stream().map(suffix -> suffix.name()).toArray(String[]::new);
        }
    }

    private static enum RequireState {
        LOADED,
        ALREADY_LOADED,
        CIRCULAR;

    }
}

