/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.Member;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.api.Access;
import org.jruby.api.Error;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.Unrescuable;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.binding.AssignedName;
import org.jruby.javasupport.ext.JavaExtensions;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.util.ObjectProxyCache;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Loader;
import org.jruby.util.collections.ClassValue;

public abstract class JavaSupport {
    protected final Ruby runtime;
    @Deprecated(since="9.4.3.0")
    private final ClassValue<JavaClass> javaClassCache;
    private final ClassValue<RubyModule> proxyClassCache;
    private final Map<Class, UnfinishedProxy> unfinishedProxies;
    private final ObjectProxyCache<IRubyObject, RubyClass> objectProxyCache = new ObjectProxyCache<IRubyObject, RubyClass>(this, ObjectProxyCache.ReferenceType.WEAK){

        @Override
        public IRubyObject allocateProxy(Object javaObject, RubyClass clazz) {
            return Java.allocateProxy(javaObject, clazz);
        }
    };
    private RubyModule javaModule;
    private RubyModule javaUtilitiesModule;
    private RubyModule javaArrayUtilitiesModule;
    private RubyClass javaObjectClass;
    @Deprecated(since="9.4.3.0")
    private Object objectJavaClass;
    private RubyClass javaClassClass;
    private RubyClass javaPackageClass;
    private RubyClass javaArrayClass;
    private RubyClass javaProxyClass;
    private RubyClass arrayJavaProxyCreatorClass;
    private RubyClass javaFieldClass;
    private RubyClass javaMethodClass;
    private RubyClass javaConstructorClass;
    private RubyModule javaInterfaceTemplate;
    private RubyClass arrayProxyClass;
    private RubyClass concreteProxyClass;
    private RubyClass mapJavaProxy;
    private RubyClass javaProxyConstructorClass;

    public JavaSupport(Ruby runtime2) {
        this.runtime = runtime2;
        this.javaClassCache = ClassValue.newInstance(klass -> new JavaClass(runtime2, this.getJavaClassClass(), klass));
        this.proxyClassCache = ClassValue.newInstance(this::computeProxyClass);
        this.unfinishedProxies = new ConcurrentHashMap<Class, UnfinishedProxy>(8, 0.75f, 1);
    }

    private synchronized RubyModule computeProxyClass(Class<?> klass) {
        RubyModule proxyKlass = Java.createProxyClassForClass(this.runtime, klass);
        JavaExtensions.define(this.runtime, klass, proxyKlass);
        return proxyKlass;
    }

    @Deprecated(since="9.4.0.0")
    public Class loadJavaClassVerbose(String className) {
        ThreadContext context = this.runtime.getCurrentContext();
        try {
            return this.loadJavaClass(className);
        }
        catch (ClassNotFoundException ex) {
            throw Java.initCause(Error.nameError(context, "cannot load Java class " + className, className, ex), ex);
        }
        catch (ExceptionInInitializerError ex) {
            throw Java.initCause(Error.nameError(context, "cannot initialize Java class " + className, className, ex), ex);
        }
        catch (LinkageError ex) {
            throw Java.initCause(Error.nameError(context, "cannot link Java class " + className + ", probable missing dependency: " + ex.getLocalizedMessage(), className, ex), ex);
        }
        catch (SecurityException ex) {
            if (this.runtime.isVerbose()) {
                ex.printStackTrace(this.runtime.getErrorStream());
            }
            throw Java.initCause(this.runtime.newSecurityError(ex.getLocalizedMessage()), ex);
        }
    }

    @Deprecated(since="9.4.0.0")
    public Class loadJavaClassQuiet(String className) {
        try {
            return this.loadJavaClass(className);
        }
        catch (ClassNotFoundException ex) {
            throw Java.initCause(this.runtime.newNameError("cannot load Java class " + className, className, (Throwable)ex, false), ex);
        }
        catch (ExceptionInInitializerError ex) {
            throw Java.initCause(this.runtime.newNameError("cannot initialize Java class " + className, className, (Throwable)ex, false), ex);
        }
        catch (LinkageError ex) {
            throw Java.initCause(this.runtime.newNameError("cannot link Java class " + className, className, (Throwable)ex, false), ex);
        }
        catch (SecurityException ex) {
            throw Java.initCause(this.runtime.newSecurityError(ex.getLocalizedMessage()), ex);
        }
    }

    public void handleNativeException(Throwable exception2, Member target2) {
        if (exception2 instanceof RaiseException) {
            throw (RaiseException)exception2;
        }
        if (exception2 instanceof Unrescuable) {
            if (exception2 instanceof java.lang.Error) {
                throw (java.lang.Error)exception2;
            }
            if (exception2 instanceof RuntimeException) {
                throw (RuntimeException)exception2;
            }
        }
        Helpers.throwException(exception2);
    }

    @Deprecated(since="10.0.0.0")
    public RubyModule getJavaModule() {
        return this.getJavaModule(this.runtime.getCurrentContext());
    }

    public RubyModule getJavaModule(ThreadContext context) {
        RubyModule module = this.javaModule;
        return module != null ? module : (this.javaModule = Access.getModule(context, "Java"));
    }

    @Deprecated(since="10.0.0.0")
    public RubyModule getJavaUtilitiesModule() {
        RubyModule module = this.javaUtilitiesModule;
        if (module != null) {
            return module;
        }
        this.javaUtilitiesModule = Access.getModule(this.runtime.getCurrentContext(), "JavaUtilities");
        return this.javaUtilitiesModule;
    }

    @Deprecated(since="10.0.0.0")
    public RubyModule getJavaArrayUtilitiesModule() {
        RubyModule module = this.javaArrayUtilitiesModule;
        if (module != null) {
            return module;
        }
        this.javaArrayUtilitiesModule = Access.getModule(this.runtime.getCurrentContext(), "JavaArrayUtilities");
        return this.javaArrayUtilitiesModule;
    }

    @Deprecated(since="9.4-")
    public RubyClass getJavaObjectClass() {
        RubyClass clazz = this.javaObjectClass;
        if (clazz != null) {
            return clazz;
        }
        ThreadContext context = this.runtime.getCurrentContext();
        this.javaObjectClass = this.getJavaModule(context).getClass(context, "JavaObject");
        return this.javaObjectClass;
    }

    public RubyClass getJavaProxyConstructorClass() {
        RubyClass clazz = this.javaProxyConstructorClass;
        if (clazz != null) {
            return clazz;
        }
        ThreadContext context = this.runtime.getCurrentContext();
        this.javaProxyConstructorClass = this.getJavaModule(context).getClass(context, "JavaProxyConstructor");
        return this.javaProxyConstructorClass;
    }

    @Deprecated(since="9.4.0.0")
    public JavaClass getObjectJavaClass() {
        Object clazz = this.objectJavaClass;
        if (clazz != null) {
            return (JavaClass)clazz;
        }
        JavaClass javaClass = JavaClass.get(this.runtime, Object.class);
        this.objectJavaClass = javaClass;
        return javaClass;
    }

    @Deprecated(since="9.1.0.0")
    public void setObjectJavaClass(JavaClass objectJavaClass) {
    }

    @Deprecated(since="9.4.0.0")
    public RubyClass getJavaArrayClass() {
        RubyClass clazz = this.javaArrayClass;
        if (clazz != null) {
            return clazz;
        }
        ThreadContext context = this.runtime.getCurrentContext();
        this.javaArrayClass = this.getJavaModule(context).getClass(context, "JavaArray");
        return this.javaArrayClass;
    }

    @Deprecated(since="9.4.0.0")
    public RubyClass getJavaClassClass() {
        RubyClass clazz = this.javaClassClass;
        if (clazz != null) {
            return clazz;
        }
        ThreadContext context = this.runtime.getCurrentContext();
        this.javaClassClass = this.getJavaModule(context).getClass(context, "JavaClass");
        return this.javaClassClass;
    }

    public RubyClass getJavaPackageClass() {
        return this.javaPackageClass;
    }

    public void setJavaPackageClass(RubyClass javaPackageClass) {
        this.javaPackageClass = javaPackageClass;
    }

    public RubyModule getJavaInterfaceTemplate() {
        RubyModule module = this.javaInterfaceTemplate;
        if (module != null) {
            return module;
        }
        this.javaInterfaceTemplate = Access.getModule(this.runtime.getCurrentContext(), "JavaInterfaceTemplate");
        return this.javaInterfaceTemplate;
    }

    @Deprecated(since="9.3.0.0")
    public RubyModule getPackageModuleTemplate() {
        return null;
    }

    public RubyClass getJavaProxyClass() {
        RubyClass clazz = this.javaProxyClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaProxyClass = Access.getClass(this.runtime.getCurrentContext(), "JavaProxy");
        return this.javaProxyClass;
    }

    public RubyClass getArrayJavaProxyCreatorClass() {
        RubyClass clazz = this.arrayJavaProxyCreatorClass;
        if (clazz != null) {
            return clazz;
        }
        this.arrayJavaProxyCreatorClass = Access.getClass(this.runtime.getCurrentContext(), "ArrayJavaProxyCreator");
        return this.arrayJavaProxyCreatorClass;
    }

    public RubyClass getConcreteProxyClass() {
        RubyClass clazz = this.concreteProxyClass;
        if (clazz != null) {
            return clazz;
        }
        this.concreteProxyClass = Access.getClass(this.runtime.getCurrentContext(), "ConcreteJavaProxy");
        return this.concreteProxyClass;
    }

    public RubyClass getMapJavaProxyClass() {
        RubyClass clazz = this.mapJavaProxy;
        if (clazz != null) {
            return clazz;
        }
        this.mapJavaProxy = Access.getClass(this.runtime.getCurrentContext(), "MapJavaProxy");
        return this.mapJavaProxy;
    }

    public RubyClass getArrayProxyClass() {
        RubyClass clazz = this.arrayProxyClass;
        if (clazz != null) {
            return clazz;
        }
        this.arrayProxyClass = Access.getClass(this.runtime.getCurrentContext(), "ArrayJavaProxy");
        return this.arrayProxyClass;
    }

    @Deprecated(since="9.4.0.0")
    public RubyClass getJavaFieldClass() {
        RubyClass clazz = this.javaFieldClass;
        if (clazz != null) {
            return clazz;
        }
        ThreadContext context = this.runtime.getCurrentContext();
        this.javaFieldClass = this.getJavaModule(context).getClass(context, "JavaField");
        return this.javaFieldClass;
    }

    @Deprecated(since="9.4.0.0")
    public RubyClass getJavaMethodClass() {
        RubyClass clazz = this.javaMethodClass;
        if (clazz != null) {
            return clazz;
        }
        ThreadContext context = this.runtime.getCurrentContext();
        this.javaMethodClass = this.getJavaModule(context).getClass(context, "JavaMethod");
        return this.javaMethodClass;
    }

    @Deprecated(since="9.4.0.0")
    public RubyClass getJavaConstructorClass() {
        RubyClass clazz = this.javaConstructorClass;
        if (clazz != null) {
            return clazz;
        }
        ThreadContext context = this.runtime.getCurrentContext();
        this.javaConstructorClass = this.getJavaModule(context).getClass(context, "JavaConstructor");
        return this.javaConstructorClass;
    }

    public Class<?> loadJavaClass(String className) throws ClassNotFoundException {
        return this.loadJavaClass(className, true);
    }

    public Class<?> loadJavaClass(String className, boolean initialize2) throws ClassNotFoundException {
        Class<?> primitiveClass = JavaUtil.getPrimitiveClass(className);
        if (primitiveClass == null) {
            if (!Ruby.isSecurityRestricted()) {
                for (Loader loader : this.runtime.getInstanceConfig().getExtraLoaders()) {
                    try {
                        return loader.loadClass(className);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
                return Class.forName(className, initialize2, this.runtime.getJRubyClassLoader());
            }
            return Class.forName(className, initialize2, JavaSupport.class.getClassLoader());
        }
        return primitiveClass;
    }

    public ObjectProxyCache<IRubyObject, RubyClass> getObjectProxyCache() {
        return this.objectProxyCache;
    }

    abstract ClassValue<Map<String, AssignedName>> getStaticAssignedNames();

    abstract ClassValue<Map<String, AssignedName>> getInstanceAssignedNames();

    @Deprecated(since="9.4.3.0")
    public abstract Map<String, JavaClass> getNameClassMap();

    @Deprecated(since="9.1.0.0")
    public abstract Map<Set<?>, JavaProxyClass> getJavaProxyClassCache();

    @Deprecated(since="9.4.0.0")
    public JavaClass getJavaClassFromCache(Class clazz) {
        return this.javaClassCache.get(clazz);
    }

    final void beginProxy(Class clazz, RubyModule proxy2) {
        UnfinishedProxy up = new UnfinishedProxy(proxy2);
        up.lock();
        this.unfinishedProxies.put(clazz, up);
    }

    final void endProxy(Class clazz) {
        UnfinishedProxy up = this.unfinishedProxies.remove(clazz);
        up.unlock();
    }

    final RubyModule getUnfinishedProxy(Class clazz) {
        UnfinishedProxy up = this.unfinishedProxies.get(clazz);
        if (up != null && up.isHeldByCurrentThread()) {
            return up.proxy;
        }
        return null;
    }

    RubyModule getProxyClassFromCache(Class clazz) {
        return this.proxyClassCache.get(clazz);
    }

    static final class UnfinishedProxy
    extends ReentrantLock {
        final RubyModule proxy;

        UnfinishedProxy(RubyModule proxy2) {
            this.proxy = proxy2;
        }
    }
}

