/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.dataflow.analyses;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jruby.ir.dataflow.DataFlowProblem;
import org.jruby.ir.dataflow.analyses.DefinedVariableNode;
import org.jruby.ir.interpreter.FullInterpreterContext;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.representations.BasicBlock;

public class DefinedVariablesProblem
extends DataFlowProblem<DefinedVariablesProblem, DefinedVariableNode> {
    public static final String NAME = "Defined Variables Analysis";
    private final HashMap<Variable, Integer> dfVarMap = new HashMap();
    private final HashMap<Integer, Variable> varDfVarMap = new HashMap();
    private final HashSet<Variable> vars = new HashSet();

    public DefinedVariablesProblem(FullInterpreterContext fic) {
        super(DataFlowProblem.DF_Direction.FORWARD);
        this.setup(fic);
    }

    public Integer getDFVar(Variable v) {
        return this.dfVarMap.get(v);
    }

    public boolean dfVarExists(Variable v) {
        return this.getDFVar(v) != null;
    }

    public Variable getVariable(int id) {
        return this.varDfVarMap.get(id);
    }

    @Override
    public DefinedVariableNode buildFlowGraphNode(BasicBlock bb) {
        return new DefinedVariableNode(this, bb);
    }

    public void addDFVar(Variable v) {
        Integer dfv = this.addDataFlowVar();
        this.dfVarMap.put(v, dfv);
        this.varDfVarMap.put(dfv, v);
        this.vars.add(v);
    }

    public Set<Variable> findUndefinedVars() {
        HashSet<Variable> undefinedVars = new HashSet<Variable>();
        for (DefinedVariableNode n : this.flowGraphNodes) {
            n.identifyInits(undefinedVars);
        }
        return undefinedVars;
    }

    public Set<Variable> getAllVars() {
        return this.dfVarMap.keySet();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

