/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.Ruby;
import org.jruby.RubyThread;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.fiber.ThreadFiber;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ThreadService
extends ThreadLocal<SoftReference<ThreadContext>> {
    private final Ruby runtime;
    private ThreadContext mainContext;
    private final ThreadGroup rubyThreadGroup;
    private final Map<Thread, RubyThread> rubyThreadMap;
    private final ReentrantLock criticalLock = new ReentrantLock();
    private final AtomicLong threadCount = new AtomicLong(0L);

    public ThreadService(Ruby runtime2) {
        ThreadGroup rubyThreadGroup;
        this.runtime = runtime2;
        try {
            rubyThreadGroup = new ThreadGroup("Ruby Threads#" + runtime2.hashCode());
        }
        catch (SecurityException e) {
            rubyThreadGroup = Thread.currentThread().getThreadGroup();
        }
        this.rubyThreadGroup = rubyThreadGroup;
        this.rubyThreadMap = Collections.synchronizedMap(new WeakHashMap());
    }

    public void teardown() {
        RubyThread current2 = ThreadService.getCurrentContext(this).getThread();
        for (RubyThread rth : this.getActiveRubyThreads()) {
            if (rth == current2 || rth.isAdopted()) continue;
            try {
                rth.kill();
                rth.join(this.mainContext);
            }
            catch (RaiseException raiseException) {
                // empty catch block
            }
        }
        this.mainContext = null;
        this.rubyThreadMap.clear();
    }

    public void initMainThread() {
        this.mainContext = ThreadContext.newContext(this.runtime);
        this.set(new SoftReference<ThreadContext>(this.mainContext));
    }

    public final ThreadContext getCurrentContext() {
        return ThreadService.getCurrentContext(this);
    }

    public static ThreadContext getCurrentContext(ThreadService service) {
        ThreadContext context = ThreadService.adoptLoop(service);
        if (context == null) {
            return ThreadService.getCurrentContext(service);
        }
        return context;
    }

    private static ThreadContext adoptLoop(ThreadService service) {
        SoftReference ref = (SoftReference)service.get();
        if (ref == null) {
            return ThreadService.contextFromAdopt(service);
        }
        ThreadContext context = (ThreadContext)ref.get();
        if (context == null) {
            service.remove();
        }
        return context;
    }

    private static ThreadContext contextFromAdopt(ThreadService service) {
        return service.adoptCurrentThread().getContext();
    }

    private RubyThread adoptCurrentThread() {
        return RubyThread.adopt(this.runtime, this, Thread.currentThread());
    }

    public ThreadContext registerNewThread(RubyThread thread2) {
        assert (thread2.getContext() == null);
        ThreadContext context = ThreadContext.newContext(this.runtime);
        context.setThread(thread2);
        ThreadFiber.initRootFiber(context, thread2);
        this.set(new SoftReference<ThreadContext>(context));
        return context;
    }

    public RubyThread getMainThread() {
        return this.mainContext.getThread();
    }

    public void setMainThread(Thread thread2, RubyThread rubyThread) {
        this.mainContext.setThread(rubyThread);
        this.rubyThreadMap.put(thread2, rubyThread);
    }

    public RubyThread[] getActiveRubyThreads() {
        ArrayList rtList = new ArrayList(this.rubyThreadMap.size());
        this.rubyThreadMap.forEach((th, rth) -> {
            if (th == null) {
                return;
            }
            if (!th.isAlive()) {
                return;
            }
            rtList.add(rth);
        });
        return rtList.toArray(new RubyThread[rtList.size()]);
    }

    public void associateThread(Thread thread2, RubyThread rubyThread) {
        this.rubyThreadMap.put(thread2, rubyThread);
    }

    public void unregisterThread(RubyThread thread2) {
        this.unregisterThreadImpl(thread2.getContext(), thread2.getNativeThread());
    }

    public void unregisterCurrentThread(ThreadContext context) {
        this.unregisterThreadImpl(context, Thread.currentThread());
    }

    private void unregisterThreadImpl(ThreadContext context, Thread nativeThread) {
        SoftReference ref;
        this.rubyThreadMap.remove(nativeThread);
        if (context != null) {
            RubyThread thread2 = context.getThread();
            context.setThread(null);
            if (thread2 != null) {
                thread2.clearContext();
            }
        }
        if ((ref = (SoftReference)this.get()) != null) {
            ref.clear();
        }
        this.remove();
    }

    @Deprecated(since="9.2.6.0")
    public void disposeCurrentThread() {
        this.unregisterCurrentThread(this.getCurrentContext());
    }

    public long incrementAndGetThreadCount() {
        return this.threadCount.incrementAndGet();
    }

    @Deprecated(since="9.1.15.0")
    public Map<Object, RubyThread> getRubyThreadMap() {
        return this.rubyThreadMap;
    }

    @Deprecated(since="9.0.0.0")
    public void deliverEvent(RubyThread sender, RubyThread target2, Event event2) {
    }

    @Deprecated(since="9.1.15.0")
    public ThreadGroup getRubyThreadGroup() {
        return this.rubyThreadGroup;
    }

    @Deprecated(since="9.1.15.0")
    public ThreadContext getThreadContextForThread(RubyThread thread2) {
        return thread2.getContext();
    }

    @Deprecated(since="9.1.15.0")
    public synchronized void dissociateThread(Object thread2) {
        this.rubyThreadMap.remove(thread2);
    }

    @Deprecated(since="9.1.15.0")
    public final void setCurrentContext(ThreadContext context) {
        this.set(new SoftReference<ThreadContext>(context));
    }

    @Deprecated(since="9.1.15.0")
    public boolean getPolling() {
        return this.rubyThreadMap.size() > 1;
    }

    @Deprecated(since="9.2.1.0")
    public void setCritical(boolean critical) {
        if (critical && !this.criticalLock.isHeldByCurrentThread()) {
            this.acquireCritical();
        } else if (!critical && this.criticalLock.isHeldByCurrentThread()) {
            this.releaseCritical();
        }
    }

    @Deprecated(since="9.2.1.0")
    private void acquireCritical() {
        this.criticalLock.lock();
    }

    @Deprecated(since="9.2.1.0")
    private void releaseCritical() {
        this.criticalLock.unlock();
    }

    @Deprecated(since="9.2.1.0")
    public boolean getCritical() {
        return this.criticalLock.isHeldByCurrentThread();
    }

    @Deprecated(since="9.0.0.0")
    public static class Event {
        public final String description;
        public final Type type;
        public final IRubyObject exception;

        public Event(String description, Type type2) {
            this(description, type2, null);
        }

        public Event(String description, Type type2, IRubyObject exception2) {
            this.description = description;
            this.type = type2;
            this.exception = exception2;
        }

        public String toString() {
            switch (this.type.ordinal()) {
                case 0: {
                    return this.description;
                }
                case 1: {
                    return this.description + ": " + String.valueOf(this.exception.getMetaClass().getRealClass());
                }
                case 2: {
                    return this.description;
                }
            }
            return "";
        }

        @Deprecated(since="9.0.0.0")
        public static Event kill(RubyThread sender, RubyThread target2, Type type2) {
            return new Event(sender.toString() + " sent KILL to " + String.valueOf(target2), type2);
        }

        @Deprecated(since="9.0.0.0")
        public static Event raise(RubyThread sender, RubyThread target2, Type type2, IRubyObject exception2) {
            return new Event(sender.toString() + " sent KILL to " + String.valueOf(target2), type2, exception2);
        }

        @Deprecated(since="9.0.0.0")
        public static Event wakeup(RubyThread sender, RubyThread target2, Type type2) {
            return new Event(sender.toString() + " sent KILL to " + String.valueOf(target2), type2);
        }

        public static enum Type {
            KILL,
            RAISE,
            WAKEUP;

        }
    }
}

