/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jruby.EvalType;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.api.Convert;
import org.jruby.api.Error;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.runtime.marshal.DataType;
import org.jruby.util.cli.Options;

@JRubyClass(name={"Object"}, include={"Kernel"})
public class RubyObject
extends RubyBasicObject {
    public static final ObjectAllocator OBJECT_ALLOCATOR = RubyObject::new;
    public static final ObjectAllocator IVAR_INSPECTING_OBJECT_ALLOCATOR = new ObjectAllocator(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            ObjectAllocator allocator = klass.getAllocator();
            if (allocator == this) {
                Set<String> foundVariables = klass.discoverInstanceVariables();
                RubyClass rubyClass = klass.getRealClass();
                synchronized (rubyClass) {
                    allocator = klass.getAllocator();
                    if (allocator == this) {
                        if (Options.DUMP_INSTANCE_VARS.load().booleanValue()) {
                            System.err.println(String.valueOf(klass) + ";" + String.valueOf(foundVariables));
                        }
                        allocator = runtime2.getObjectSpecializer().specializeForVariables(klass, foundVariables);
                        klass.metaClass.invalidateCacheDescendants(runtime2.getCurrentContext());
                    }
                }
            }
            return allocator.allocate(runtime2, klass);
        }
    };
    public static final ObjectAllocator REIFYING_OBJECT_ALLOCATOR = RubyObject::reifyAndAllocate;

    public RubyObject(Ruby runtime2, RubyClass metaClass) {
        super(runtime2, metaClass);
    }

    public RubyObject(RubyClass metaClass) {
        super(metaClass);
    }

    @Deprecated(since="1.7.0")
    protected RubyObject(Ruby runtime2, RubyClass metaClass, boolean useObjectSpace, boolean canBeTainted) {
        super(runtime2, metaClass, useObjectSpace, canBeTainted);
    }

    protected RubyObject(Ruby runtime2, RubyClass metaClass, boolean useObjectSpace) {
        super(runtime2, metaClass, useObjectSpace);
    }

    private static IRubyObject reifyAndAllocate(Ruby runtime2, RubyClass klass) {
        klass.reifyWithAncestors();
        return klass.allocate(runtime2.getCurrentContext());
    }

    public static void finishObjectClass(RubyClass Object2) {
        ((RubyModule)Object2.reifiedClass(RubyObject.class)).classIndex(ClassIndex.OBJECT);
    }

    public void attachToObjectSpace() {
        this.getRuntime().getObjectSpace().add(this);
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.OBJECT;
    }

    @Deprecated(since="10.0.0.0")
    public static void puts(Object obj) {
        System.out.println(obj.toString());
    }

    @Override
    public boolean equals(Object other) {
        return other == this || other instanceof IRubyObject && Helpers.invokedynamic(this.metaClass.runtime.getCurrentContext(), (IRubyObject)this, MethodNames.OP_EQUAL, (IRubyObject)other).isTrue();
    }

    public RubyString toRubyString(ThreadContext context) {
        return RubyObject.sites((ThreadContext)context).to_s.call(context, this, this).convertToString();
    }

    public String toString() {
        return this.toRubyString(this.metaClass.runtime.getCurrentContext()).getUnicodeValue();
    }

    public final void callInit(IRubyObject[] args2, Block block) {
        ThreadContext context = this.metaClass.runtime.getCurrentContext();
        this.metaClass.getBaseCallSite(0).call(context, (IRubyObject)this, (IRubyObject)this, args2, block);
    }

    public final void callInit(Block block) {
        ThreadContext context = this.metaClass.runtime.getCurrentContext();
        this.metaClass.getBaseCallSite(0).call(context, (IRubyObject)this, (IRubyObject)this, block);
    }

    public final void callInit(IRubyObject arg0, Block block) {
        ThreadContext context = this.metaClass.runtime.getCurrentContext();
        this.metaClass.getBaseCallSite(0).call(context, (IRubyObject)this, (IRubyObject)this, arg0, block);
    }

    public final void callInit(IRubyObject arg0, IRubyObject arg1, Block block) {
        ThreadContext context = this.metaClass.runtime.getCurrentContext();
        this.metaClass.getBaseCallSite(0).call(context, (IRubyObject)this, (IRubyObject)this, arg0, arg1, block);
    }

    public final void callInit(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        ThreadContext context = this.metaClass.runtime.getCurrentContext();
        this.metaClass.getBaseCallSite(0).call(context, (IRubyObject)this, (IRubyObject)this, arg0, arg1, arg2, block);
    }

    public final void callInit(ThreadContext context, IRubyObject[] args2, Block block) {
        this.metaClass.getBaseCallSite(0).call(context, (IRubyObject)this, (IRubyObject)this, args2, block);
    }

    public final void callInit(ThreadContext context, Block block) {
        this.metaClass.getBaseCallSite(0).call(context, (IRubyObject)this, (IRubyObject)this, block);
    }

    public final void callInit(ThreadContext context, IRubyObject arg0, Block block) {
        this.metaClass.getBaseCallSite(0).call(context, (IRubyObject)this, (IRubyObject)this, arg0, block);
    }

    public final void callInit(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        this.metaClass.getBaseCallSite(0).call(context, (IRubyObject)this, (IRubyObject)this, arg0, arg1, block);
    }

    public final void callInit(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        this.metaClass.getBaseCallSite(0).call(context, (IRubyObject)this, (IRubyObject)this, arg0, arg1, arg2, block);
    }

    @Deprecated(since="1.1.6")
    public final IRubyObject convertToType(RubyClass target2, int convertMethodIndex) {
        throw new RuntimeException("Not supported; use the String versions");
    }

    @Deprecated(since="1.1.2")
    public IRubyObject specificEval(ThreadContext context, RubyModule mod, IRubyObject[] args2, Block block, EvalType evalType) {
        int line;
        Object file2;
        RubyString str;
        RubyString evalStr;
        if (block.isGiven()) {
            if (args2.length > 0) {
                throw Error.argumentError(context, args2.length, 0);
            }
            return this.yieldUnder(context, mod, block, evalType);
        }
        if (args2.length == 0) {
            throw Error.argumentError(context, "block not supplied");
        }
        if (args2.length > 3) {
            String lastFuncName = context.getFrameName();
            throw Error.argumentError(context, "wrong number of arguments: " + lastFuncName + "(src) or " + lastFuncName + "{..}");
        }
        IRubyObject iRubyObject = args2[0];
        RubyString rubyString = evalStr = iRubyObject instanceof RubyString ? (str = (RubyString)iRubyObject) : args2[0].convertToString();
        if (args2.length > 1) {
            file2 = args2[1].convertToString().asJavaString();
            line = args2.length > 2 ? Convert.toInt(context, args2[2]) - 1 : 0;
        } else {
            file2 = "(eval at " + context.getSingleBacktrace().getFileAndLine() + ")";
            line = 0;
        }
        return this.evalUnder(context, mod, evalStr, (String)file2, line, evalType);
    }

    @Override
    public IRubyObject op_eqq(ThreadContext context, IRubyObject other) {
        return Convert.asBoolean(context, RubyObject.equalInternal(context, this, other));
    }

    public static boolean equalInternal(ThreadContext context, IRubyObject a, IRubyObject b2) {
        if (a == b2) {
            return true;
        }
        if (a instanceof RubySymbol) {
            return false;
        }
        return RubyObject.fastNumEqualInternal(context, a, b2);
    }

    private static boolean fastNumEqualInternal(ThreadContext context, IRubyObject a, IRubyObject b2) {
        if (a instanceof RubyFixnum) {
            if (b2 instanceof RubyFixnum) {
                if (!context.sites.Fixnum.op_eqq.isBuiltin(a)) {
                    return context.sites.Fixnum.op_eqq.call(context, a, a, b2).isTrue();
                }
                return ((RubyFixnum)a).fastEqual((RubyFixnum)b2);
            }
        } else if (a instanceof RubyFloat && b2 instanceof RubyFloat) {
            if (!context.sites.Float.op_equal.isBuiltin(a)) {
                return context.sites.Float.op_equal.call(context, a, a, b2).isTrue();
            }
            return ((RubyFloat)a).fastEqual((RubyFloat)b2);
        }
        return Helpers.invokedynamic(context, a, MethodNames.OP_EQUAL, b2).isTrue();
    }

    protected static boolean eqlInternal(ThreadContext context, IRubyObject a, IRubyObject b2) {
        if (a == b2) {
            return true;
        }
        if (a instanceof RubySymbol) {
            return false;
        }
        if (a instanceof RubyNumeric) {
            if (a.getClass() != b2.getClass()) {
                return false;
            }
            return RubyObject.fastNumEqualInternal(context, a, b2);
        }
        return Helpers.invokedynamic(context, a, MethodNames.EQL, b2).isTrue();
    }

    @Override
    public int hashCode() {
        int n;
        ThreadContext context = this.getRuntime().getCurrentContext();
        IRubyObject hashValue = Helpers.invokedynamic(context, (IRubyObject)this, MethodNames.HASH);
        if (hashValue instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)hashValue;
            n = (int)fixnum.getValue();
        } else {
            n = RubyObject.nonFixnumHashCode(context, hashValue);
        }
        return n;
    }

    public static RubyString inspect(ThreadContext context, IRubyObject object) {
        return (RubyString)RubyObject.rbInspect(context, object);
    }

    public static IRubyObject dig(ThreadContext context, IRubyObject obj, IRubyObject[] args2, int idx) {
        if (obj.isNil()) {
            return context.nil;
        }
        JavaSites.ObjectSites sites = RubyObject.sites(context);
        while (idx < args2.length && !obj.isNil()) {
            IRubyObject arg2 = args2[idx];
            if (RubyObject.isArrayDig(obj, sites)) {
                obj = ((RubyArray)obj).dig(context, arg2);
            } else if (RubyObject.isHashDig(obj, sites)) {
                obj = ((RubyHash)obj).dig(context, arg2);
            } else if (RubyObject.isStructDig(obj, sites)) {
                obj = ((RubyStruct)obj).dig(context, arg2);
            } else {
                if (sites.respond_to_dig.respondsTo(context, obj, obj, true)) {
                    int len = args2.length - idx;
                    switch (len) {
                        case 1: {
                            return sites.dig_misc.call(context, obj, obj, args2[idx]);
                        }
                        case 2: {
                            return sites.dig_misc.call(context, obj, obj, args2[idx], args2[idx + 1]);
                        }
                        case 3: {
                            return sites.dig_misc.call(context, obj, obj, args2[idx], args2[idx + 1], args2[idx + 2]);
                        }
                    }
                    IRubyObject[] rest = new IRubyObject[len];
                    System.arraycopy(args2, idx, rest, 0, len);
                    return sites.dig_misc.call(context, obj, obj, rest);
                }
                throw Error.typeError(context, "", obj, " does not have #dig method");
            }
            ++idx;
        }
        return obj;
    }

    public static IRubyObject dig1(ThreadContext context, IRubyObject obj, IRubyObject arg1) {
        if (obj.isNil()) {
            return context.nil;
        }
        JavaSites.ObjectSites sites = RubyObject.sites(context);
        if (RubyObject.isArrayDig(obj, sites)) {
            return ((RubyArray)obj).dig(context, arg1);
        }
        if (RubyObject.isHashDig(obj, sites)) {
            return ((RubyHash)obj).dig(context, arg1);
        }
        if (RubyObject.isStructDig(obj, sites)) {
            return ((RubyStruct)obj).dig(context, arg1);
        }
        if (!sites.respond_to_dig.respondsTo(context, obj, obj, true)) {
            throw Error.typeError(context, "", obj, " does not have #dig method");
        }
        return sites.dig_misc.call(context, obj, obj, arg1);
    }

    public static IRubyObject dig2(ThreadContext context, IRubyObject obj, IRubyObject arg1, IRubyObject arg2) {
        if (obj.isNil()) {
            return context.nil;
        }
        JavaSites.ObjectSites sites = RubyObject.sites(context);
        if (RubyObject.isArrayDig(obj, sites)) {
            return ((RubyArray)obj).dig(context, arg1, arg2);
        }
        if (RubyObject.isHashDig(obj, sites)) {
            return ((RubyHash)obj).dig(context, arg1, arg2);
        }
        if (RubyObject.isStructDig(obj, sites)) {
            return ((RubyStruct)obj).dig(context, arg1, arg2);
        }
        if (!sites.respond_to_dig.respondsTo(context, obj, obj, true)) {
            throw Error.typeError(context, "", obj, " does not have #dig method");
        }
        return sites.dig_misc.call(context, obj, obj, arg1, arg2);
    }

    private static boolean isStructDig(IRubyObject obj, JavaSites.ObjectSites sites) {
        return obj instanceof RubyStruct && sites.dig_struct.isBuiltin(obj.getMetaClass());
    }

    private static boolean isHashDig(IRubyObject obj, JavaSites.ObjectSites sites) {
        return obj instanceof RubyHash && sites.dig_hash.isBuiltin(obj.getMetaClass());
    }

    private static boolean isArrayDig(IRubyObject obj, JavaSites.ObjectSites sites) {
        return obj instanceof RubyArray && sites.dig_array.isBuiltin(obj.getMetaClass());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        ObjectOutputter outputter = new ObjectOutputter(out);
        this.forEachInstanceVariable(outputter);
        outputter.writeCount();
        this.forEachInstanceVariable(outputter);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int ivarCount = in.readInt();
        for (int i2 = 0; i2 < ivarCount; ++i2) {
            this.setInstanceVariable((String)in.readObject(), (IRubyObject)in.readObject());
        }
    }

    private static JavaSites.ObjectSites sites(ThreadContext context) {
        return context.sites.Object;
    }

    private static class ObjectOutputter
    implements BiConsumer<String, IRubyObject> {
        final ObjectOutputStream out;
        int count = 0;
        boolean counting = true;

        ObjectOutputter(ObjectOutputStream out) {
            this.out = out;
        }

        @Override
        public void accept(String name2, IRubyObject value2) {
            if (this.counting) {
                ++this.count;
            } else {
                try {
                    this.out.writeObject(name2);
                    this.out.writeObject(value2);
                }
                catch (IOException ioe) {
                    Helpers.throwException(ioe);
                }
            }
        }

        public void writeCount() {
            try {
                this.out.writeInt(this.count);
                this.counting = false;
            }
            catch (IOException ioe) {
                Helpers.throwException(ioe);
            }
        }
    }

    public static class Data
    extends RubyObject
    implements DataType {
        public Data(Ruby runtime2, RubyClass metaClass, Object data2) {
            super(runtime2, metaClass);
            this.dataWrapStruct(data2);
        }

        public Data(RubyClass metaClass, Object data2) {
            super(metaClass);
            this.dataWrapStruct(data2);
        }
    }
}

