/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jruby.RubySymbol;
import org.jruby.api.Error;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.builder.IRBuilder;
import org.jruby.ir.builder.LazyMethodDefinition;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.GetFieldInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpTargetInstr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.instructions.PutFieldInstr;
import org.jruby.ir.interpreter.ExitableInterpreterContext;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.ivars.MethodData;
import org.jruby.util.ByteList;

public class IRMethod
extends IRScope {
    public final boolean isInstanceMethod;
    protected ArgumentDescriptor[] argDesc = ArgumentDescriptor.EMPTY_ARRAY;
    private volatile LazyMethodDefinition defNode;
    private volatile ExitableInterpreterContext interpreterContextForJavaConstructor;

    public IRMethod(IRManager manager, IRScope lexicalParent, LazyMethodDefinition defn, ByteList name2, boolean isInstanceMethod, int lineNumber, StaticScope staticScope, int coverageMode) {
        super(manager, lexicalParent, name2, lineNumber, staticScope, coverageMode);
        this.defNode = defn;
        this.isInstanceMethod = isInstanceMethod;
        if (staticScope != null) {
            staticScope.setIRScope(this);
        }
    }

    @Override
    public boolean hasBeenBuilt() {
        return this.defNode == null;
    }

    public MethodData getMethodData() {
        List<String> ivarNames;
        LazyMethodDefinition def = this.defNode;
        if (def != null) {
            ivarNames = def.getMethodData();
        } else {
            ivarNames = new ArrayList<String>();
            InterpreterContext context = this.lazilyAcquireInterpreterContext();
            block4: for (Instr i2 : context.getInstructions()) {
                switch (i2.getOperation()) {
                    case GET_FIELD: {
                        ivarNames.add(((GetFieldInstr)i2).getId());
                        continue block4;
                    }
                    case PUT_FIELD: {
                        ivarNames.add(((PutFieldInstr)i2).getId());
                    }
                }
            }
        }
        return new MethodData(this.getId(), this.getFile(), ivarNames);
    }

    @Override
    public InterpreterContext builtInterpreterContext() {
        return this.lazilyAcquireInterpreterContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExitableInterpreterContext builtInterpreterContextForJavaConstructor() {
        ExitableInterpreterContext interpreterContextForJavaConstructor = this.interpreterContextForJavaConstructor;
        if (interpreterContextForJavaConstructor == null) {
            IRMethod iRMethod = this;
            synchronized (iRMethod) {
                interpreterContextForJavaConstructor = this.interpreterContextForJavaConstructor;
                if (interpreterContextForJavaConstructor == null) {
                    this.interpreterContextForJavaConstructor = interpreterContextForJavaConstructor = this.builtInterpreterContextForJavaConstructorImpl();
                }
            }
        }
        return interpreterContextForJavaConstructor == ExitableInterpreterContext.NULL ? null : interpreterContextForJavaConstructor;
    }

    private synchronized ExitableInterpreterContext builtInterpreterContextForJavaConstructorImpl() {
        InterpreterContext interpreterContext = this.builtInterpreterContext();
        if (this.usesSuper()) {
            int ipc = 0;
            int superIPC = -1;
            CallBase superCall = null;
            HashMap<Label, Integer> labels = new HashMap<Label, Integer>();
            ArrayList<Label> earlyJumps = new ArrayList<Label>();
            ThreadContext context = this.getManager().getRuntime().getCurrentContext();
            for (Instr instr : interpreterContext.getInstructions()) {
                if (instr instanceof CallBase && ((CallBase)instr).getCallType() == CallType.SUPER) {
                    if (superCall != null) {
                        throw Error.runtimeError(context, "Found multiple supers in Java-calling constructor. See https://github.com/jruby/jruby/wiki/CallingJavaFromJRuby#subclassing-a-java-class");
                    }
                    superCall = (CallBase)instr;
                    superIPC = ipc;
                } else if (instr instanceof JumpTargetInstr) {
                    label = ((JumpTargetInstr)((Object)instr)).getJumpTarget();
                    Integer labelIPC = (Integer)labels.get(label);
                    if (superIPC != -1) {
                        if (labelIPC != null && labelIPC < superIPC) {
                            throw Error.runtimeError(context, "Backward control flow found around Java-calling super. See https://github.com/jruby/jruby/wiki/CallingJavaFromJRuby#subclassing-a-java-class");
                        }
                    } else if (labelIPC == null) {
                        earlyJumps.add(label);
                    }
                } else if (instr instanceof LabelInstr) {
                    label = ((LabelInstr)instr).getLabel();
                    labels.put(label, ipc);
                    if (superIPC == -1 && earlyJumps.contains(label)) {
                        earlyJumps.remove(label);
                    }
                }
                ++ipc;
            }
            if (!earlyJumps.isEmpty()) {
                throw Error.runtimeError(context, "Forward control flow found around Java-calling super. See https://github.com/jruby/jruby/wiki/CallingJavaFromJRuby#subclassing-a-java-class");
            }
            if (superIPC != -1) {
                return new ExitableInterpreterContext(interpreterContext, superCall, superIPC);
            }
        }
        return ExitableInterpreterContext.NULL;
    }

    @Deprecated(since="9.3.11.0")
    public ExitableInterpreterContext builtInterperterContextForJavaConstructor() {
        return this.builtInterpreterContextForJavaConstructor();
    }

    public final InterpreterContext lazilyAcquireInterpreterContext() {
        if (!this.hasBeenBuilt()) {
            this.buildMethodImpl();
        }
        return this.interpreterContext;
    }

    private synchronized void buildMethodImpl() {
        if (this.hasBeenBuilt()) {
            return;
        }
        IRBuilder builder = this.defNode.getBuilder(this.getManager(), this);
        builder.executesOnce = false;
        builder.defineMethodInner(this.defNode, this.getLexicalParent(), this.getCoverageMode());
        this.defNode = null;
    }

    @Override
    public BasicBlock[] prepareForCompilation() {
        this.buildMethodImpl();
        return super.prepareForCompilation();
    }

    @Override
    public IRScopeType getScopeType() {
        return this.isInstanceMethod ? IRScopeType.INSTANCE_METHOD : IRScopeType.CLASS_METHOD;
    }

    @Override
    protected LocalVariable findExistingLocalVariable(RubySymbol name2, int scopeDepth) {
        return (LocalVariable)this.localVars.get(name2);
    }

    @Override
    public LocalVariable getLocalVariable(RubySymbol name2, int scopeDepth) {
        LocalVariable lvar = this.findExistingLocalVariable(name2, scopeDepth);
        if (lvar == null) {
            lvar = this.getNewLocalVariable(name2, scopeDepth);
        }
        return lvar;
    }

    public ArgumentDescriptor[] getArgumentDescriptors() {
        return this.argDesc;
    }

    public void setArgumentDescriptors(ArgumentDescriptor[] argDesc) {
        this.argDesc = argDesc;
    }
}

