/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jnr.enxio.channels.NativeDeviceChannel;
import jnr.posix.POSIX;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArgsFile;
import org.jruby.RubyArray;
import org.jruby.RubyBinding;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyMatchData;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.api.Warn;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.ir.Tuple;
import org.jruby.platform.Platform;
import org.jruby.runtime.Block;
import org.jruby.runtime.Constants;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.ReadonlyGlobalVariable;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.ByteListHelper;
import org.jruby.util.KCode;
import org.jruby.util.OSEnvironment;
import org.jruby.util.RegexpOptions;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.cli.Options;
import org.jruby.util.cli.OutputStrings;
import org.jruby.util.io.ChannelHelper;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.io.FilenoUtil;
import org.jruby.util.io.STDIO;

public class RubyGlobal {
    public static final List<String> UNCACHED_GLOBALS = Collections.unmodifiableList(Arrays.asList("$.", "$INPUT_LINE_NUMBER", "$FILENAME"));

    public static void initARGV(Ruby runtime2) {
        ThreadContext context = runtime2.getCurrentContext();
        RubyClass objectClass = Access.objectClass(context);
        String[] argv2 = Access.instanceConfig(context).getArgv();
        RubyArray<?> argvArray = Create.allocArray(context, argv2.length);
        for (String arg2 : argv2) {
            argvArray.append(context, RubyString.newInternalFromJavaExternal(runtime2, arg2));
        }
        if (objectClass.getConstantNoConstMissing(context, "ARGV") != null) {
            ((RubyArray)objectClass.getConstant(context, "ARGV")).replace(context, argvArray);
        } else {
            objectClass.setConstantQuiet(context, "ARGV", argvArray);
            Access.globalVariables(context).define("$*", new ValueAccessor(argvArray), GlobalVariable.Scope.GLOBAL);
        }
    }

    @Deprecated(since="10.0.0.0")
    public static void createGlobals(Ruby runtime2) {
        ThreadContext context = runtime2.getCurrentContext();
        RubyGlobal.createGlobalsAndENV(context, Access.globalVariables(context), Access.instanceConfig(context));
    }

    public static RubyHash createGlobalsAndENV(ThreadContext context, GlobalVariables globals, RubyInstanceConfig instanceConfig) {
        Ruby runtime2 = context.runtime;
        RubyClass Object2 = Access.objectClass(context);
        RubyBinding topLevelBinding = runtime2.newBinding();
        runtime2.setTopLevelBinding(topLevelBinding);
        Object2.defineConstant(context, "TOPLEVEL_BINDING", topLevelBinding);
        RubyGlobal.initARGV(runtime2);
        RubyGlobal.defineArgv0Global(context, globals, instanceConfig.displayedFileName());
        RubyString release = RubyString.newFString(runtime2, "2025-11-26");
        RubyString platform = RubyString.newFString(runtime2, "java");
        RubyString engine = RubyString.newFString(runtime2, "jruby");
        RubyString version = RubyString.newFString(runtime2, "3.4.5");
        RubyFixnum patchlevel = Convert.asFixnum(context, 0);
        Object2.defineConstant(context, "RUBY_VERSION", version);
        Object2.defineConstant(context, "RUBY_PATCHLEVEL", patchlevel);
        Object2.defineConstant(context, "RUBY_RELEASE_DATE", release);
        Object2.defineConstant(context, "RUBY_PLATFORM", platform);
        RubyString description = RubyString.newFString(runtime2, OutputStrings.getVersionString());
        Object2.defineConstant(context, "RUBY_DESCRIPTION", description);
        RubyString copyright = RubyString.newFString(runtime2, OutputStrings.getCopyrightString());
        Object2.defineConstant(context, "RUBY_COPYRIGHT", copyright);
        Object2.defineConstant(context, "RELEASE_DATE", release);
        Object2.defineConstant(context, "PLATFORM", platform);
        RubyString jrubyVersion = RubyString.newFString(runtime2, "10.0.3.0-SNAPSHOT");
        RubyString jrubyRevision = RubyString.newFString(runtime2, Constants.REVISION);
        Object2.defineConstant(context, "JRUBY_VERSION", jrubyVersion);
        Object2.defineConstant(context, "JRUBY_REVISION", jrubyRevision);
        Object2.defineConstant(context, "RUBY_REVISION", RubyString.newFString(runtime2, Constants.REVISION));
        Object2.defineConstant(context, "RUBY_ENGINE", engine);
        Object2.defineConstant(context, "RUBY_ENGINE_VERSION", jrubyVersion);
        RubyInstanceConfig.Verbosity verbosity = instanceConfig.getVerbosity();
        runtime2.defineVariable(new WarningGlobalVariable(context, "$-W", verbosity), GlobalVariable.Scope.GLOBAL);
        RubyString defaultRS = RubyString.newFString(runtime2, instanceConfig.getRecordSeparator());
        StringGlobalVariable rs = new StringGlobalVariable(runtime2, "$/", defaultRS);
        runtime2.defineVariable(rs, GlobalVariable.Scope.GLOBAL);
        runtime2.setRecordSeparatorVar(rs);
        globals.setDefaultSeparator(defaultRS);
        runtime2.defineVariable(new StringGlobalVariable(runtime2, "$\\", context.nil), GlobalVariable.Scope.GLOBAL);
        runtime2.defineVariable(new DeprecatedStringGlobalVariable(runtime2, "$,", context.nil), GlobalVariable.Scope.GLOBAL);
        runtime2.defineVariable(new LineNumberGlobalVariable(runtime2, "$."), GlobalVariable.Scope.GLOBAL);
        runtime2.defineVariable(new LastlineGlobalVariable(runtime2, "$_"), GlobalVariable.Scope.FRAME);
        runtime2.defineVariable(new LastExitStatusVariable(runtime2, "$?"), GlobalVariable.Scope.THREAD);
        runtime2.defineVariable(new ErrorInfoGlobalVariable(runtime2, "$!", context.nil), GlobalVariable.Scope.THREAD);
        runtime2.defineVariable(new NonEffectiveGlobalVariable(runtime2, "$=", context.fals), GlobalVariable.Scope.GLOBAL);
        if (instanceConfig.getInputFieldSeparator() == null) {
            runtime2.defineVariable(new DeprecatedStringOrRegexpGlobalVariable(runtime2, "$;", context.nil), GlobalVariable.Scope.GLOBAL);
        } else {
            runtime2.defineVariable(new DeprecatedStringOrRegexpGlobalVariable(runtime2, "$;", RubyRegexp.newRegexp(runtime2, instanceConfig.getInputFieldSeparator(), new RegexpOptions())), GlobalVariable.Scope.GLOBAL);
        }
        RubyInstanceConfig.Verbosity verbose = instanceConfig.getVerbosity();
        IRubyObject verboseValue = verbose == RubyInstanceConfig.Verbosity.NIL ? context.nil : (verbose == RubyInstanceConfig.Verbosity.TRUE ? context.tru : context.fals);
        runtime2.setVerbose(verboseValue);
        runtime2.defineVariable(new VerboseGlobalVariable(runtime2, "$VERBOSE"), GlobalVariable.Scope.GLOBAL);
        runtime2.defineVariable(new VerboseGlobalVariable(runtime2, "$-v"), GlobalVariable.Scope.GLOBAL);
        runtime2.defineVariable(new VerboseGlobalVariable(runtime2, "$-w"), GlobalVariable.Scope.GLOBAL);
        runtime2.setDebug(runtime2.newBoolean(instanceConfig.isDebug()));
        runtime2.defineVariable(new DebugGlobalVariable(runtime2, "$DEBUG"), GlobalVariable.Scope.GLOBAL);
        runtime2.defineVariable(new DebugGlobalVariable(runtime2, "$-d"), GlobalVariable.Scope.GLOBAL);
        runtime2.defineVariable(new BacktraceGlobalVariable(runtime2, "$@"), GlobalVariable.Scope.THREAD);
        RubyGlobal.initSTDIO(runtime2, globals);
        runtime2.defineVariable(new LoadedFeatures(runtime2, "$\""), GlobalVariable.Scope.GLOBAL);
        runtime2.defineVariable(new LoadedFeatures(runtime2, "$LOADED_FEATURES"), GlobalVariable.Scope.GLOBAL);
        runtime2.defineVariable(new LoadPath(runtime2, "$:"), GlobalVariable.Scope.GLOBAL);
        runtime2.defineVariable(new LoadPath(runtime2, "$-I"), GlobalVariable.Scope.GLOBAL);
        runtime2.defineVariable(new LoadPath(runtime2, "$LOAD_PATH"), GlobalVariable.Scope.GLOBAL);
        runtime2.defineVariable(new MatchMatchGlobalVariable(runtime2, "$&"), GlobalVariable.Scope.FRAME);
        runtime2.defineVariable(new PreMatchGlobalVariable(runtime2, "$`"), GlobalVariable.Scope.FRAME);
        runtime2.defineVariable(new PostMatchGlobalVariable(runtime2, "$'"), GlobalVariable.Scope.FRAME);
        runtime2.defineVariable(new LastMatchGlobalVariable(runtime2, "$+"), GlobalVariable.Scope.FRAME);
        runtime2.defineVariable(new BackRefGlobalVariable(runtime2, "$~"), GlobalVariable.Scope.FRAME);
        globals.defineReadonly("$$", new PidAccessor(runtime2), GlobalVariable.Scope.GLOBAL);
        RubyHash env = RubyGlobal.defineGlobalEnvConstants(context);
        if (globals.get("$*").isNil()) {
            globals.defineReadonly("$*", new ValueAccessor(Create.newArray(context)), GlobalVariable.Scope.GLOBAL);
        }
        globals.defineReadonly("$-p", new ValueAccessor(Convert.asBoolean(context, instanceConfig.isAssumePrinting())), GlobalVariable.Scope.GLOBAL);
        globals.defineReadonly("$-a", new ValueAccessor(Convert.asBoolean(context, instanceConfig.isSplit())), GlobalVariable.Scope.GLOBAL);
        globals.defineReadonly("$-l", new ValueAccessor(Convert.asBoolean(context, instanceConfig.isProcessLineEnds())), GlobalVariable.Scope.GLOBAL);
        RubyArgsFile.initArgsFile(context, Access.enumerableModule(context), globals);
        String inplace = instanceConfig.getInPlaceBackupExtension();
        runtime2.defineVariable(new ArgfGlobalVariable(runtime2, "$-i", inplace != null ? Create.newString(context, inplace) : context.nil), GlobalVariable.Scope.GLOBAL);
        globals.alias("$-0", "$/");
        globals.alias("$ERROR_INFO", "$!");
        globals.alias("$ERROR_POSITION", "$@");
        globals.alias("$FS", "$;");
        globals.alias("$FIELD_SEPARATOR", "$;");
        globals.alias("$OFS", "$,");
        globals.alias("$OUTPUT_FIELD_SEPARATOR", "$,");
        globals.alias("$RS", "$/");
        globals.alias("$INPUT_RECORD_SEPARATOR", "$/");
        globals.alias("$ORS", "$\\");
        globals.alias("$OUTPUT_RECORD_SEPARATOR", "$\\");
        globals.alias("$NR", "$.");
        globals.alias("$INPUT_LINE_NUMBER", "$.");
        globals.alias("$LAST_READ_LINE", "$_");
        globals.alias("$DEFAULT_OUTPUT", "$>");
        globals.alias("$DEFAULT_INPUT", "$<");
        globals.alias("$PID", "$$");
        globals.alias("$PROCESS_ID", "$$");
        globals.alias("$CHILD_STATUS", "$?");
        globals.alias("$LAST_MATCH_INFO", "$~");
        globals.alias("$IGNORECASE", "$=");
        globals.alias("$ARGV", "$*");
        globals.alias("$MATCH", "$&");
        globals.alias("$PREMATCH", "$`");
        globals.alias("$POSTMATCH", "$'");
        globals.alias("$LAST_PAREN_MATCH", "$+");
        return env;
    }

    static void defineArgv0Global(final ThreadContext context, GlobalVariables globals, final String scriptName) {
        IAccessor d = new IAccessor(){
            RubyString value;
            {
                this.value = Create.newFrozenString(context, scriptName);
            }

            @Override
            public IRubyObject getValue() {
                return this.value;
            }

            @Override
            public IRubyObject setValue(IRubyObject newValue) {
                RubyString stringValue = newValue.convertToString();
                if (!stringValue.isFrozen()) {
                    stringValue = stringValue.newFrozen();
                }
                this.value = stringValue;
                return stringValue;
            }
        };
        globals.define("$PROGRAM_NAME", d, GlobalVariable.Scope.GLOBAL);
        globals.define("$0", d, GlobalVariable.Scope.GLOBAL);
    }

    public static void initSTDIO(Ruby runtime2, GlobalVariables globals) {
        RubyIO stderr;
        RubyIO stdout;
        RubyIO stdin;
        ThreadContext context = runtime2.getCurrentContext();
        RubyClass Object2 = Access.objectClass(context);
        if (!Platform.IS_WINDOWS && runtime2.getPosix().isNative() && runtime2.getInstanceConfig().isHardExit() && Options.NATIVE_STDIO.load().booleanValue()) {
            stdin = RubyIO.prepStdio(runtime2, runtime2.getIn(), (Channel)new NativeDeviceChannel(0), 1, runtime2.getIO(), "<STDIN>");
            stdout = RubyIO.prepStdio(runtime2, runtime2.getOut(), (Channel)new NativeDeviceChannel(1), 2, runtime2.getIO(), "<STDOUT>");
            stderr = RubyIO.prepStdio(runtime2, runtime2.getErr(), (Channel)new NativeDeviceChannel(2), 10, runtime2.getIO(), "<STDERR>");
        } else {
            stdin = RubyIO.prepStdio(runtime2, runtime2.getIn(), RubyGlobal.prepareStdioChannel(runtime2, STDIO.IN, runtime2.getIn()), 1, runtime2.getIO(), "<STDIN>");
            stdout = RubyIO.prepStdio(runtime2, runtime2.getOut(), RubyGlobal.prepareStdioChannel(runtime2, STDIO.OUT, runtime2.getOut()), 2, runtime2.getIO(), "<STDOUT>");
            stderr = RubyIO.prepStdio(runtime2, runtime2.getErr(), RubyGlobal.prepareStdioChannel(runtime2, STDIO.ERR, runtime2.getErr()), 10, runtime2.getIO(), "<STDERR>");
        }
        RubyClass object = runtime2.getObject();
        if (object.getConstantFromNoConstMissing(context, "STDIN") == null) {
            runtime2.defineVariable(new InputGlobalVariable(runtime2, "$stdin", stdin), GlobalVariable.Scope.GLOBAL);
            runtime2.defineVariable(new OutputGlobalVariable(runtime2, "$stdout", stdout), GlobalVariable.Scope.GLOBAL);
            globals.alias("$>", "$stdout");
            runtime2.defineVariable(new OutputGlobalVariable(runtime2, "$stderr", stderr), GlobalVariable.Scope.GLOBAL);
            Object2.defineConstant(context, "STDIN", stdin);
            Object2.defineConstant(context, "STDOUT", stdout);
            Object2.defineConstant(context, "STDERR", stderr);
            runtime2.setOriginalStderr(stderr);
        } else {
            ((RubyIO)object.getConstant(context, "STDIN")).getOpenFile().setFD(stdin.getOpenFile().fd());
            ((RubyIO)object.getConstant(context, "STDOUT")).getOpenFile().setFD(stdout.getOpenFile().fd());
            ((RubyIO)object.getConstant(context, "STDERR")).getOpenFile().setFD(stderr.getOpenFile().fd());
        }
    }

    private static Channel prepareStdioChannel(Ruby runtime2, STDIO stdio, Object stream) {
        if (runtime2.getPosix().isNative() && stdio.isJVMDefault(stream) && !Platform.IS_WINDOWS) {
            OutputStream unwrappedStream;
            int fileno2 = -1;
            if (stream instanceof Channel) {
                Channel channel = (Channel)stream;
                fileno2 = FilenoUtil.filenoFrom(channel);
            } else if (stream instanceof InputStream) {
                InputStream unwrappedStream2 = ChannelHelper.unwrapFilterInputStream((InputStream)stream);
                if (unwrappedStream2 instanceof FileInputStream) {
                    fileno2 = FilenoUtil.filenoFrom(((FileInputStream)unwrappedStream2).getChannel());
                }
            } else if (stream instanceof OutputStream && (unwrappedStream = ChannelHelper.unwrapFilterOutputStream((OutputStream)stream)) instanceof FileOutputStream) {
                fileno2 = FilenoUtil.filenoFrom(((FileOutputStream)unwrappedStream).getChannel());
            }
            if (fileno2 >= 0) {
                return new NativeDeviceChannel(fileno2);
            }
        }
        switch (stdio) {
            case IN: {
                return Channels.newChannel((InputStream)stream);
            }
            case OUT: 
            case ERR: {
                return Channels.newChannel((OutputStream)stream);
            }
        }
        throw new RuntimeException("invalid stdio: " + String.valueOf((Object)stdio));
    }

    private static int unwrapDripStream(Object stream) {
        if (stream.getClass().getName().startsWith("org.flatland.drip.Switchable")) {
            try {
                FileDescriptor fd = (FileDescriptor)stream.getClass().getMethod("getFD", new Class[0]).invoke(stream, new Object[0]);
                return FilenoUtil.filenoFrom(fd);
            }
            catch (NoSuchMethodException nsme) {
                nsme.printStackTrace(System.err);
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace(System.err);
            }
            catch (InvocationTargetException ite) {
                ite.printStackTrace(System.err);
            }
        }
        return -1;
    }

    private static RubyHash defineGlobalEnvConstants(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        RubyClass Object2 = Access.objectClass(context);
        Map<RubyString, RubyString> environmentVariableMap = OSEnvironment.environmentVariableMap(runtime2);
        RubyInstanceConfig instanceConfig = Access.instanceConfig(context);
        CaseInsensitiveStringOnlyRubyHash env = new CaseInsensitiveStringOnlyRubyHash(runtime2, environmentVariableMap, context.nil, instanceConfig.isNativeEnabled() && instanceConfig.isUpdateNativeENVEnabled());
        env.singletonClass(context).defineMethods(context, CaseInsensitiveStringOnlyRubyHash.class);
        Object2.defineConstant(context, "ENV", env);
        Map<RubyString, RubyString> systemPropertiesMap = OSEnvironment.systemPropertiesMap(runtime2);
        ReadOnlySystemPropertiesHash envJava = new ReadOnlySystemPropertiesHash(runtime2, systemPropertiesMap, context.nil);
        envJava.setFrozen(true);
        Object2.defineConstant(context, "ENV_JAVA", envJava);
        return env;
    }

    private static void warnDeprecatedGlobal(ThreadContext context, String name2) {
        Warn.warnDeprecated(context, "'" + name2 + "' is deprecated");
    }

    private static class WarningGlobalVariable
    extends ReadonlyGlobalVariable {
        public WarningGlobalVariable(ThreadContext context, String name2, RubyInstanceConfig.Verbosity verbosity) {
            super(context.runtime, name2, verbosity == RubyInstanceConfig.Verbosity.NIL ? Convert.asFixnum(context, 0) : (verbosity == RubyInstanceConfig.Verbosity.FALSE ? Convert.asFixnum(context, 1) : (verbosity == RubyInstanceConfig.Verbosity.TRUE ? Convert.asFixnum(context, 2) : context.nil)));
        }
    }

    public static class StringGlobalVariable
    extends GlobalVariable {
        public StringGlobalVariable(Ruby runtime2, String name2, IRubyObject value2) {
            super(runtime2, name2, value2);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            if (!value2.isNil() && !(value2 instanceof RubyString)) {
                throw Error.typeError(value2.getRuntime().getCurrentContext(), "value of " + this.name() + " must be String");
            }
            return super.set(value2);
        }
    }

    public static class DeprecatedStringGlobalVariable
    extends StringGlobalVariable {
        public DeprecatedStringGlobalVariable(Ruby runtime2, String name2, IRubyObject value2) {
            super(runtime2, name2, value2);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            IRubyObject result2 = super.set(value2);
            if (!value2.isNil()) {
                RubyGlobal.warnDeprecatedGlobal(this.runtime.getCurrentContext(), this.name);
            }
            return result2;
        }
    }

    private static class LineNumberGlobalVariable
    extends GlobalVariable {
        public LineNumberGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, null);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            int line = Convert.toInt(this.runtime.getCurrentContext(), value2);
            this.runtime.setCurrentLine(line);
            return value2;
        }

        @Override
        public IRubyObject get() {
            return this.runtime.newFixnum(this.runtime.getCurrentLine());
        }
    }

    private static class LastlineGlobalVariable
    extends GlobalVariable {
        public LastlineGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, null);
        }

        @Override
        public IRubyObject get() {
            return this.runtime.getCurrentContext().getLastLine();
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            return this.runtime.getCurrentContext().setLastLine(value2);
        }
    }

    private static class LastExitStatusVariable
    extends GlobalVariable {
        public LastExitStatusVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, runtime2.getNil());
        }

        @Override
        public IRubyObject get() {
            ThreadContext context = this.runtime.getCurrentContext();
            IRubyObject lastExitStatus = context.getLastExitStatus();
            return lastExitStatus == null ? context.nil : lastExitStatus;
        }

        @Override
        public IRubyObject set(IRubyObject lastExitStatus) {
            throw Error.nameError(this.runtime.getCurrentContext(), "$? is a read-only variable", "$?");
        }
    }

    private static class ErrorInfoGlobalVariable
    extends ReadonlyGlobalVariable {
        public ErrorInfoGlobalVariable(Ruby runtime2, String name2, IRubyObject value2) {
            super(runtime2, name2, null);
            runtime2.getCurrentContext().setErrorInfo(value2);
        }

        @Override
        public IRubyObject get() {
            return this.runtime.getCurrentContext().getErrorInfo();
        }
    }

    private static class NonEffectiveGlobalVariable
    extends GlobalVariable {
        public NonEffectiveGlobalVariable(Ruby runtime2, String name2, IRubyObject value2) {
            super(runtime2, name2, value2);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            Warn.warnDeprecated(this.runtime.getCurrentContext(), "warning: variable " + this.name + " is no longer effective; ignored");
            return value2;
        }

        @Override
        public IRubyObject get() {
            Warn.warnDeprecated(this.runtime.getCurrentContext(), "warning: variable " + this.name + " is no longer effective");
            return this.value;
        }
    }

    public static class DeprecatedStringOrRegexpGlobalVariable
    extends StringOrRegexpGlobalVariable {
        public DeprecatedStringOrRegexpGlobalVariable(Ruby runtime2, String name2, IRubyObject value2) {
            super(runtime2, name2, value2);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            IRubyObject result2 = super.set(value2);
            if (!result2.isNil()) {
                RubyGlobal.warnDeprecatedGlobal(this.runtime.getCurrentContext(), this.name);
            }
            return result2;
        }
    }

    private static class VerboseGlobalVariable
    extends GlobalVariable {
        public VerboseGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, null);
        }

        @Override
        public IRubyObject get() {
            return this.runtime.getVerbose();
        }

        @Override
        public IRubyObject set(IRubyObject newValue) {
            this.runtime.setVerbose(newValue.isNil() ? null : Boolean.valueOf(newValue.isTrue()));
            return newValue;
        }
    }

    private static class DebugGlobalVariable
    extends GlobalVariable {
        public DebugGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, null);
        }

        @Override
        public IRubyObject get() {
            return this.runtime.getDebug();
        }

        @Override
        public IRubyObject set(IRubyObject newValue) {
            this.runtime.setDebug(newValue.isTrue());
            return newValue;
        }
    }

    private static class BacktraceGlobalVariable
    extends GlobalVariable {
        public BacktraceGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, null);
        }

        @Override
        public IRubyObject get() {
            ThreadContext context = this.runtime.getCurrentContext();
            IRubyObject errorInfo = Access.globalVariables(context).get("$!");
            IRubyObject backtrace2 = errorInfo.isNil() ? context.nil : errorInfo.callMethod(context, "backtrace");
            return backtrace2 instanceof RubyArray ? backtrace2 : context.nil;
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            ThreadContext context = this.runtime.getCurrentContext();
            if (Access.globalVariables(context).get("$!").isNil()) {
                throw Error.argumentError(context, "$! not set");
            }
            Access.globalVariables(context).get("$!").callMethod(context, "set_backtrace", value2);
            return value2;
        }
    }

    private static class LoadedFeatures
    extends ReadonlyGlobalVariable {
        public LoadedFeatures(Ruby runtime2, String name2) {
            super(runtime2, name2, null);
        }

        @Override
        public IRubyObject get() {
            return this.runtime.getLoadService().getLoadedFeatures();
        }
    }

    private static class LoadPath
    extends ReadonlyGlobalVariable {
        public LoadPath(Ruby runtime2, String name2) {
            super(runtime2, name2, null);
        }

        @Override
        public IRubyObject get() {
            return this.runtime.getLoadService().getLoadPath();
        }
    }

    private static class MatchMatchGlobalVariable
    extends GlobalVariable {
        public MatchMatchGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, runtime2.getNil());
        }

        @Override
        public IRubyObject get() {
            ThreadContext context = this.runtime.getCurrentContext();
            return RubyRegexp.last_match(context, context.getBackRef());
        }
    }

    private static class PreMatchGlobalVariable
    extends GlobalVariable {
        public PreMatchGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, runtime2.getNil());
        }

        @Override
        public IRubyObject get() {
            ThreadContext context = this.runtime.getCurrentContext();
            return RubyRegexp.match_pre(context, context.getBackRef());
        }
    }

    private static class PostMatchGlobalVariable
    extends GlobalVariable {
        public PostMatchGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, runtime2.getNil());
        }

        @Override
        public IRubyObject get() {
            ThreadContext context = this.runtime.getCurrentContext();
            return RubyRegexp.match_post(context, context.getBackRef());
        }
    }

    private static class LastMatchGlobalVariable
    extends GlobalVariable {
        public LastMatchGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, runtime2.getNil());
        }

        @Override
        public IRubyObject get() {
            ThreadContext context = this.runtime.getCurrentContext();
            return RubyRegexp.match_last(context, context.getBackRef());
        }
    }

    private static class BackRefGlobalVariable
    extends GlobalVariable {
        public BackRefGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, runtime2.getNil());
        }

        @Override
        public IRubyObject get() {
            return this.runtime.getCurrentContext().getBackRef();
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            ThreadContext context = this.runtime.getCurrentContext();
            if (value2.isNil()) {
                context.clearBackRef();
            } else if (value2 instanceof RubyMatchData) {
                RubyMatchData match2 = (RubyMatchData)value2;
                context.setBackRef(match2);
            } else {
                throw Error.typeError(context, value2, "MatchData");
            }
            return value2;
        }
    }

    private static final class PidAccessor
    implements IAccessor {
        private final Ruby runtime;
        private volatile IRubyObject pid = null;

        public PidAccessor(Ruby runtime2) {
            this.runtime = runtime2;
        }

        @Override
        public IRubyObject getValue() {
            return this.pid != null ? this.pid : (this.pid = this.runtime.newFixnum(this.runtime.getPosix().getpid()));
        }

        @Override
        public IRubyObject setValue(IRubyObject newValue) {
            throw Error.runtimeError(this.runtime.getCurrentContext(), "cannot assign to $$");
        }
    }

    public static class ArgfGlobalVariable
    extends GlobalVariable {
        public ArgfGlobalVariable(Ruby runtime2, String name2, IRubyObject value2) {
            super(runtime2, name2, value2);
            this.set(value2);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            ThreadContext context = this.runtime.getCurrentContext();
            RubyArgsFile.inplace_mode_set(context, Access.argsFile(context), value2);
            if (value2.isNil() || !value2.isTrue()) {
                Access.instanceConfig(context).setInPlaceBackupExtension(null);
            }
            return super.set(value2);
        }
    }

    public static class InputGlobalVariable
    extends GlobalVariable {
        public InputGlobalVariable(Ruby runtime2, String name2, IRubyObject value2) {
            super(runtime2, name2, value2);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            if (value2 == this.get()) {
                return value2;
            }
            return super.set(value2);
        }
    }

    public static class OutputGlobalVariable
    extends GlobalVariable {
        public OutputGlobalVariable(Ruby runtime2, String name2, IRubyObject value2) {
            super(runtime2, name2, value2);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            if (value2 == this.get()) {
                return value2;
            }
            if (!value2.respondsTo("write") && !value2.respondsToMissing("write")) {
                throw Error.typeError(value2.getRuntime().getCurrentContext(), this.name() + " must have write method, ", value2, " given");
            }
            return super.set(value2);
        }
    }

    public static class CaseInsensitiveStringOnlyRubyHash
    extends StringOnlyRubyHash {
        private static final byte[] HASHROCKET_WITH_SPACES = " => ".getBytes(StandardCharsets.UTF_8);
        private static final ByteList ENV = new ByteList(new byte[]{69, 78, 86}, USASCIIEncoding.INSTANCE, false);
        private static final RubyHash.VisitorWithState<RubyArray<?>> EachVisitor = new RubyHash.VisitorWithState<RubyArray<?>>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, RubyArray<?> ary) {
                ary.append(context, StringOnlyRubyHash.newString(context, key2));
                ary.append(context, StringOnlyRubyHash.newName(context, key2, value2));
            }
        };
        private static final RubyHash.VisitorWithState<RubyArray> StoreKeyVisitor = new RubyHash.VisitorWithState<RubyArray>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, RubyArray keys2) {
                keys2.storeInternal(context, index2, StringOnlyRubyHash.newString(context, key2));
            }
        };
        private static final RubyHash.VisitorWithState<Tuple<Set, RubyHash>> ReplaceVisitor = new RubyHash.VisitorWithState<Tuple<Set, RubyHash>>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Tuple<Set, RubyHash> tuple) {
                ((Set)tuple.a).remove(key2);
                ((RubyHash)tuple.b).op_aset(context, key2, value2);
            }
        };

        public CaseInsensitiveStringOnlyRubyHash(Ruby runtime2, Map<RubyString, RubyString> valueMap, IRubyObject defaultValue, boolean updateRealENV) {
            super(runtime2, valueMap, defaultValue, updateRealENV);
        }

        @Override
        protected final boolean isCaseSensitive() {
            return false;
        }

        @Override
        @JRubyMethod(name={"[]"})
        public IRubyObject op_aref(ThreadContext context, IRubyObject arg2) {
            RubyString key2 = arg2.convertToString();
            IRubyObject value2 = this.internalGet(key2);
            EnvStringValidation.ensureValidEnvString(context, key2, "key");
            if (value2 == null) {
                return context.nil;
            }
            RubyString string2 = (RubyString)CaseInsensitiveStringOnlyRubyHash.newName(context, key2, value2);
            string2.freeze(context);
            return string2;
        }

        @Override
        @JRubyMethod
        public IRubyObject freeze(ThreadContext context) {
            throw Error.typeError(context, "cannot freeze ENV");
        }

        @Override
        @JRubyMethod(name={"assoc"})
        public IRubyObject assoc(ThreadContext context, IRubyObject obj) {
            RubyString expected = CaseInsensitiveStringOnlyRubyHash.verifyStringLike(context, obj).convertToString();
            EnvStringValidation.ensureValidEnvString(context, obj, "value");
            return super.assoc(context, expected);
        }

        @Override
        @JRubyMethod(name={"fetch"}, required=1, optional=2)
        public IRubyObject fetch(ThreadContext context, IRubyObject[] args2, Block block) {
            EnvStringValidation.ensureValidEnvString(context, args2[0], "key");
            return switch (args2.length) {
                case 1 -> super.fetch(context, args2[0], block);
                case 2 -> super.fetch(context, args2[0], args2[1], block);
                default -> null;
            };
        }

        @Override
        @JRubyMethod(name={"fetch"}, required=1)
        public IRubyObject fetch(ThreadContext context, IRubyObject key2, Block block) {
            EnvStringValidation.ensureValidEnvString(context, key2, "key");
            return super.fetch(context, CaseInsensitiveStringOnlyRubyHash.verifyStringLike(context, key2.convertToString()), block);
        }

        @Override
        @JRubyMethod
        public IRubyObject delete(ThreadContext context, IRubyObject key2, Block block) {
            EnvStringValidation.ensureValidEnvString(context, key2, "key");
            return super.delete(context, CaseInsensitiveStringOnlyRubyHash.verifyStringLike(context, key2), block);
        }

        @Override
        @JRubyMethod(name={"each", "each_pair"})
        public IRubyObject each(ThreadContext context, Block block) {
            if (!block.isGiven()) {
                return super.each(context, block);
            }
            RubyArray ary = new RubyArray(context.runtime, this.size());
            this.visitAll(context, EachVisitor, ary);
            ary.eachSlice(context, 2, block);
            return this;
        }

        @Override
        @JRubyMethod(name={"rassoc"})
        public IRubyObject rassoc(ThreadContext context, IRubyObject obj) {
            if (!CaseInsensitiveStringOnlyRubyHash.isStringLike(obj)) {
                return context.nil;
            }
            return super.rassoc(context, obj.convertToString());
        }

        @Override
        @JRubyMethod(name={"has_key?", "key?", "include?", "member?"})
        public RubyBoolean has_key_p(ThreadContext context, IRubyObject key2) {
            IRubyObject expected = CaseInsensitiveStringOnlyRubyHash.verifyStringLike(context, key2);
            EnvStringValidation.ensureValidEnvString(context, key2, "key");
            return this.internalGetEntry(expected) == NO_ENTRY ? context.fals : context.tru;
        }

        @JRubyMethod(name={"has_value?", "value?"})
        public IRubyObject has_value_pp(ThreadContext context, IRubyObject expected) {
            if (!CaseInsensitiveStringOnlyRubyHash.isStringLike(expected)) {
                return context.nil;
            }
            EnvStringValidation.ensureValidEnvString(context, expected, "value");
            return super.has_value_p(context, expected.convertToString());
        }

        @Deprecated(since="10.0.0.0")
        public IRubyObject index(ThreadContext context, IRubyObject expected) {
            Warn.warn(context, "ENV#index is deprecated; use ENV#key");
            return this.key(context, expected);
        }

        @Override
        @JRubyMethod(name={"keys"})
        public RubyArray keys(ThreadContext context) {
            try {
                RubyArray keys2 = RubyArray.newBlankArrayInternal(context.runtime, this.size());
                this.visitAll(context, StoreKeyVisitor, keys2);
                return keys2;
            }
            catch (NegativeArraySizeException nase) {
                throw this.concurrentModification();
            }
        }

        @Override
        @JRubyMethod
        public IRubyObject key(ThreadContext context, IRubyObject expected) {
            return super.key(context, CaseInsensitiveStringOnlyRubyHash.verifyStringLike(context, expected));
        }

        @JRubyMethod(name={"rehash"})
        public IRubyObject rehash1(ThreadContext context) {
            super.rehash(context);
            return context.nil;
        }

        @Override
        @JRubyMethod(name={"replace"})
        public RubyHash replace(ThreadContext context, IRubyObject other) {
            this.modify();
            RubyHash otherHash = other.convertToHash();
            if (this == otherHash) {
                return this;
            }
            HashSet keys2 = new HashSet(this.directKeySet());
            Tuple tuple = new Tuple(keys2, this);
            if (!this.isComparedByIdentity() && otherHash.isComparedByIdentity()) {
                this.setComparedByIdentity(true);
            }
            otherHash.visitAll(context, ReplaceVisitor, tuple);
            for (Object key2 : keys2) {
                this.internalDelete((IRubyObject)key2);
            }
            return this;
        }

        @Override
        @JRubyMethod(name={"shift"})
        public IRubyObject shift(ThreadContext context) {
            IRubyObject value2 = super.shift(context);
            if (value2.isNil()) {
                return value2;
            }
            RubyArray pair = (RubyArray)value2;
            Object key2 = pair.eltInternal(0);
            pair.eltInternalSet(0, CaseInsensitiveStringOnlyRubyHash.newString(context, key2));
            pair.eltInternalSet(1, CaseInsensitiveStringOnlyRubyHash.newName(context, key2, pair.eltInternal(1)));
            return pair;
        }

        @Override
        @JRubyMethod(name={"to_s"})
        public RubyString to_s(ThreadContext context) {
            return Create.newSharedString(context, ENV);
        }

        @Deprecated(since="9.3.0.0")
        public RubyHash to_h() {
            return this.to_h(this.getCurrentContext(), Block.NULL_BLOCK);
        }

        @Override
        @JRubyMethod
        public RubyHash to_h(ThreadContext context, Block block) {
            RubyHash h = this.to_hash(context);
            return block.isGiven() ? h.to_h_block(context, block) : h;
        }

        @Override
        @JRubyMethod(name={"clone"})
        public IRubyObject rbClone(ThreadContext context) {
            throw Error.typeError(context, "Cannot clone ENV, use ENV.to_h to get a copy of ENV as a hash");
        }

        @Override
        @JRubyMethod(name={"clone"})
        public IRubyObject rbClone(ThreadContext context, IRubyObject _opts) {
            IRubyObject opts = ArgsUtil.getOptionsArg(context.runtime, _opts, true);
            if (opts.isNil()) {
                throw Error.argumentError(context, 1, 0);
            }
            IRubyObject freeze2 = ArgsUtil.getFreezeOpt(context, opts);
            if (freeze2 != null && freeze2.isTrue()) {
                throw Error.typeError(context, "Cannot clone ENV");
            }
            return this.rbClone(context);
        }

        @Override
        @JRubyMethod
        public IRubyObject dup(ThreadContext context) {
            throw Error.typeError(context, "Cannot dup ENV, use ENV.to_h to get a copy of ENV as a hash");
        }

        private final RaiseException concurrentModification() {
            return this.metaClass.runtime.newConcurrencyError("Detected invalid hash contents due to unsynchronized modifications with concurrent users");
        }

        @Override
        protected void replaceWith(ThreadContext context, RubyHash otherHash) {
            this.replaceExternally(context, otherHash);
        }

        @Override
        protected void appendAssociation(boolean keyIsSymbol, ByteList bytes2) {
            if (keyIsSymbol) {
                bytes2.append(58);
            } else {
                bytes2.append(HASHROCKET_WITH_SPACES);
            }
        }
    }

    private static class ReadOnlySystemPropertiesHash
    extends StringOnlyRubyHash {
        public ReadOnlySystemPropertiesHash(Ruby runtime2, Map<RubyString, RubyString> valueMap, IRubyObject defaultValue, boolean updateRealENV) {
            super(runtime2, valueMap, defaultValue, updateRealENV);
        }

        public ReadOnlySystemPropertiesHash(Ruby runtime2, Map<RubyString, RubyString> valueMap, IRubyObject defaultValue) {
            this(runtime2, valueMap, defaultValue, false);
        }

        @Override
        public void modify() {
            if (this.isFrozen()) {
                throw Error.typeError(this.getRuntime().getCurrentContext(), "ENV_JAVA is not writable until you require 'java'");
            }
        }
    }

    private static class EnvStringValidation {
        private EnvStringValidation() {
        }

        public static void ensureValidEnvString(ThreadContext context, IRubyObject str, String type2) {
            RubyString value2 = str.asString();
            if (!value2.getByteList().getEncoding().isAsciiCompatible()) {
                throw Error.argumentError(context, "bad environment variable " + type2 + ": ASCII incompatible encoding: " + value2.getByteList().getEncoding().toString());
            }
            if (value2.toString().contains("\u0000")) {
                throw Error.argumentError(context, "bad environment variable " + type2 + ": contains null byte");
            }
        }
    }

    public static class KCodeGlobalVariable
    extends GlobalVariable {
        public KCodeGlobalVariable(Ruby runtime2, String name2, IRubyObject value2) {
            super(runtime2, name2, value2);
        }

        @Override
        public IRubyObject get() {
            String kcode = this.runtime.getKCode().getKCode();
            return kcode == null ? this.runtime.getNil() : this.runtime.newString(kcode);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            this.runtime.setKCode(KCode.create(value2.convertToString().toString()));
            return value2;
        }
    }

    public static class StringOrRegexpGlobalVariable
    extends GlobalVariable {
        public StringOrRegexpGlobalVariable(Ruby runtime2, String name2, IRubyObject value2) {
            super(runtime2, name2, value2);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            if (!(value2.isNil() || value2 instanceof RubyString || value2 instanceof RubyRegexp)) {
                throw Error.typeError(value2.getRuntime().getCurrentContext(), "value of " + this.name() + " must be String or Regexp");
            }
            return super.set(value2);
        }
    }

    public static class StringOnlyRubyHash
    extends RubyHash {
        private final boolean updateRealENV;

        public StringOnlyRubyHash(Ruby runtime2, Map<RubyString, RubyString> valueMap, IRubyObject defaultValue, boolean updateRealENV) {
            super(runtime2, valueMap, defaultValue);
            this.updateRealENV = updateRealENV;
        }

        protected boolean isCaseSensitive() {
            return true;
        }

        public StringOnlyRubyHash(Ruby runtime2, Map<RubyString, RubyString> valueMap, IRubyObject defaultValue) {
            this(runtime2, valueMap, defaultValue, false);
        }

        @Override
        public RubyHash to_hash(ThreadContext context) {
            RubyHash hash2 = Create.newHash(context);
            hash2.replace(context, this);
            return hash2;
        }

        @Override
        protected IRubyObject internalGet(IRubyObject key2) {
            if (this.size == 0) {
                return null;
            }
            if (!this.isCaseSensitive()) {
                key2 = this.getCorrectKey(key2.convertToString());
            }
            return super.internalGet(key2);
        }

        @Override
        public IRubyObject op_aset(ThreadContext context, IRubyObject key2, IRubyObject value2) {
            return this.case_aware_op_aset(context, key2, value2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private IRubyObject case_aware_op_aset(ThreadContext context, IRubyObject key2, IRubyObject value2) {
            RubyString keyAsStr = StringOnlyRubyHash.verifyValidKey(context, StringOnlyRubyHash.verifyStringLike(context, key2).convertToString(), value2);
            if (!this.isCaseSensitive()) {
                keyAsStr = this.getCorrectKey(keyAsStr);
                key2 = keyAsStr;
            }
            if (value2 == context.nil) {
                return super.delete(context, key2, Block.NULL_BLOCK);
            }
            IRubyObject valueAsStr = StringOnlyRubyHash.newName(context, keyAsStr, StringOnlyRubyHash.verifyStringLike(context, value2).convertToString());
            if (this.updateRealENV) {
                POSIX posix = context.runtime.getPosix();
                String keyAsJava = keyAsStr.asJavaString();
                if (valueAsStr == context.nil) {
                    Class<Object> clazz = Object.class;
                    // MONITORENTER : java.lang.Object.class
                    posix.unsetenv(keyAsJava);
                    // MONITOREXIT : clazz
                } else {
                    EnvStringValidation.ensureValidEnvString(context, value2, "value");
                    EnvStringValidation.ensureValidEnvString(context, key2, "key");
                    String valueAsJava = valueAsStr.asJavaString();
                    Class<Object> clazz = Object.class;
                    // MONITORENTER : java.lang.Object.class
                    posix.setenv(keyAsJava, valueAsJava, 1);
                    // MONITOREXIT : clazz
                }
            }
            super.op_aset(context, keyAsStr, valueAsStr);
            return value2;
        }

        protected static IRubyObject verifyStringLike(ThreadContext context, IRubyObject test2) {
            IRubyObject string2 = test2.checkStringType();
            if (string2.isNil()) {
                throw Error.typeError(context, "no implicit conversion of ", test2, " into String");
            }
            return string2;
        }

        private static RubyString verifyValidKey(ThreadContext context, RubyString key2, IRubyObject value2) {
            int length2;
            if (value2.isNil()) {
                return key2;
            }
            ByteList bytes2 = key2.getByteList();
            int e = ByteListHelper.eachCodePointWhile(context.runtime, bytes2, 0, (index2, codepoint, enc) -> codepoint != 61);
            if (e != (length2 = bytes2.length()) || length2 == 0) {
                throw context.runtime.newErrnoEINVALError(RubyStringBuilder.str(context.runtime, "setenv(", key2, ")"));
            }
            return key2;
        }

        protected static boolean isStringLike(IRubyObject obj) {
            return obj instanceof RubyString || obj.respondsTo("to_str");
        }

        protected RubyString getCorrectKey(RubyString key2) {
            RubyString actualKey = key2;
            if (Platform.IS_WINDOWS) {
                ThreadContext context = this.getRuntime().getCurrentContext();
                RubyArray keys2 = super.keys(context);
                for (int i2 = 0; i2 < keys2.size(); ++i2) {
                    RubyString candidateKey = keys2.eltInternal(i2).convertToString();
                    if (!StringOnlyRubyHash.equalIgnoreCase(context, candidateKey, key2)) continue;
                    actualKey = candidateKey;
                    break;
                }
            }
            return actualKey;
        }

        protected static IRubyObject newName(ThreadContext context, IRubyObject key2, IRubyObject valueArg) {
            return valueArg.isNil() ? context.nil : StringOnlyRubyHash.newString(context, (RubyString)valueArg);
        }

        protected static IRubyObject newString(ThreadContext context, RubyString value2, Encoding encoding2) {
            RubyString result2 = EncodingUtils.newExternalStringWithEncoding(context.runtime, value2.getByteList().dup(), encoding2);
            result2.setFrozen(true);
            return result2;
        }

        protected static IRubyObject newString(ThreadContext context, RubyString value2) {
            return StringOnlyRubyHash.newString(context, value2, Access.encodingService(context).getEnvEncoding());
        }

        protected static IRubyObject newString(ThreadContext context, IRubyObject obj) {
            return obj.isNil() ? context.nil : StringOnlyRubyHash.newString(context, (RubyString)obj);
        }

        private static boolean equalIgnoreCase(ThreadContext context, RubyString str1, RubyString str2) {
            return ((RubyFixnum)str1.casecmp(context, str2)).isZero(context);
        }
    }
}

