/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.math.BigInteger;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.NumericNode;
import org.jruby.ast.SideEffectFree;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.runtime.builtin.IRubyObject;

public class BignumNode
extends NumericNode
implements SideEffectFree {
    private BigInteger value;

    public BignumNode(int line, BigInteger value2) {
        super(line);
        this.value = value2;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.BIGNUMNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitBignumNode(this);
    }

    @Override
    public NumericNode negate() {
        return new BignumNode(this.getLine(), this.value.negate());
    }

    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public void setValue(BigInteger value2) {
        this.value = value2;
    }

    @Override
    public IRubyObject literalValue(Ruby runtime2) {
        return RubyBignum.newBignum(runtime2, this.value);
    }
}

