/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.util.Collection;
import java.util.Collections;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.ivars.MethodData;
import org.jruby.runtime.ivars.VariableAccessor;

public class AttrReaderMethod
extends JavaMethod.JavaMethodZero {
    private MethodData methodData;
    private VariableAccessor accessor = VariableAccessor.DUMMY_ACCESSOR;

    public AttrReaderMethod(RubyModule implementationClass, Visibility visibility, String variableName) {
        super(implementationClass, visibility, variableName);
    }

    public AttrReaderMethod(RubyModule implementationClass, Visibility visibility, VariableAccessor accessor) {
        super(implementationClass, visibility, accessor.getName());
        this.accessor = accessor;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
        ThreadContext.resetCallInfo(context);
        IRubyObject variable = (IRubyObject)this.verifyAccessor(self2.getMetaClass().getRealClass()).get(self2);
        return variable == null ? context.nil : variable;
    }

    public String getVariableName() {
        return this.name;
    }

    private VariableAccessor verifyAccessor(RubyClass cls) {
        VariableAccessor localAccessor = this.accessor;
        if (localAccessor.getClassId() != cls.id) {
            this.accessor = localAccessor = cls.getVariableAccessorForRead(this.name);
        }
        return localAccessor;
    }

    @Override
    public MethodData getMethodData() {
        if (this.methodData == null) {
            this.methodData = new MethodData(this.name, "dummyfile", Collections.singletonList(this.name));
        }
        return this.methodData;
    }

    @Override
    public Collection<String> getInstanceVariableNames() {
        return Collections.singletonList(this.name);
    }

    @Deprecated(since="9.0.3.0")
    public AttrReaderMethod(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfiguration, String variableName) {
        this(implementationClass, visibility, variableName);
    }
}

