/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import jnr.posix.POSIX;
import org.jcodings.Encoding;
import org.jcodings.IntHolder;
import org.jcodings.exception.EncodingException;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF16BEEncoding;
import org.jcodings.specific.UTF16LEEncoding;
import org.jcodings.specific.UTF32BEEncoding;
import org.jcodings.specific.UTF32LEEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.unicode.UnicodeEncoding;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.jruby.Appendable;
import org.jruby.ObjectFlags;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyComplex;
import org.jruby.RubyEncoding;
import org.jruby.RubyEnumerable;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyRational;
import org.jruby.RubyRegexp;
import org.jruby.RubySymbol;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.api.JRubyAPI;
import org.jruby.api.Warn;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.platform.Platform;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock19;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.runtime.encoding.MarshalEncoding;
import org.jruby.runtime.marshal.MarshalLoader;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.CodeRangeSupport;
import org.jruby.util.CodeRangeable;
import org.jruby.util.ConvertBytes;
import org.jruby.util.Numeric;
import org.jruby.util.Pack;
import org.jruby.util.PerlHash;
import org.jruby.util.RegexpOptions;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.SipHashInline;
import org.jruby.util.Sprintf;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.io.RubyInputStream;

@JRubyClass(name={"String"}, include={"Enumerable", "Comparable"})
public class RubyString
extends RubyObject
implements CharSequence,
EncodingCapable,
MarshalEncoding,
CodeRangeable,
Appendable {
    static final ASCIIEncoding ASCII = ASCIIEncoding.INSTANCE;
    static final UTF8Encoding UTF8 = UTF8Encoding.INSTANCE;
    private static final int SHARE_LEVEL_NONE = 0;
    private static final int SHARE_LEVEL_BUFFER = 1;
    private static final int SHARE_LEVEL_BYTELIST = 2;
    private static final byte[] SCRUB_REPL_UTF8 = new byte[]{-17, -65, -67};
    private static final byte[] SCRUB_REPL_ASCII = new byte[]{63};
    private static final byte[] SCRUB_REPL_UTF16BE = new byte[]{-1, -3};
    private static final byte[] SCRUB_REPL_UTF16LE = new byte[]{-3, -1};
    private static final byte[] SCRUB_REPL_UTF32BE = new byte[]{0, 0, -1, -3};
    private static final byte[] SCRUB_REPL_UTF32LE = new byte[]{-3, -1, 0, 0};
    private static final byte[] FORCE_ENCODING_BYTES = ".force_encoding(\"".getBytes();
    private static final int STRING_MINIMUM_SIZE = 4;
    public static RubyString[] NULL_ARRAY = new RubyString[0];
    protected volatile int shareLevel = 0;
    private ByteList value;
    private static final ByteList EMPTY_ASCII8BIT_BYTELIST = new ByteList(ByteList.NULL_ARRAY, (Encoding)ASCIIEncoding.INSTANCE);
    private static final ByteList EMPTY_USASCII_BYTELIST = new ByteList(ByteList.NULL_ARRAY, (Encoding)USASCIIEncoding.INSTANCE);
    private static EmptyByteListHolder[] EMPTY_BYTELISTS = new EmptyByteListHolder[4];
    private static final byte[] hexdigit = "0123456789abcdef0123456789ABCDEF".getBytes();
    private static final Regex REPL_MOCK_REGEX = new Regex(new String(""));
    private static final ByteList SPACE_BYTELIST = RubyInteger.singleCharByteList((byte)32);
    private static final ByteList GRAPHEME_CLUSTER_PATTERN = new ByteList(new byte[]{92, 88}, false);
    private static final ByteList UNDERSCORE = new ByteList(new byte[]{95}, false);

    public static RubyClass createStringClass(ThreadContext context, RubyClass Object2, RubyModule Comparable2) {
        return (RubyClass)((RubyModule)((RubyModule)((RubyModule)((RubyModule)Define.defineClass(context, "String", Object2, RubyString::newAllocatedString).reifiedClass(RubyString.class)).kindOf(new RubyModule.JavaClassKindOf(RubyString.class))).classIndex(ClassIndex.STRING)).include(context, Comparable2)).defineMethods(context, RubyString.class);
    }

    @Override
    public Encoding getEncoding() {
        return this.value.getEncoding();
    }

    @Override
    public void setEncoding(Encoding encoding2) {
        if (encoding2 != this.value.getEncoding()) {
            if (this.shareLevel == 2) {
                this.modify();
            } else {
                this.modifyCheck();
            }
            this.value.setEncoding(encoding2);
        }
    }

    @Override
    public boolean shouldMarshalEncoding() {
        return this.getEncoding() != ASCIIEncoding.INSTANCE;
    }

    @Override
    public Encoding getMarshalEncoding() {
        return this.getEncoding();
    }

    public void associateEncoding(Encoding enc) {
        StringSupport.associateEncoding(this, enc);
    }

    public final void setEncodingAndCodeRange(Encoding enc, int cr) {
        this.value.setEncoding(enc);
        this.setCodeRange(cr);
    }

    @Deprecated(since="10.0.0.0")
    public final Encoding toEncoding(Ruby runtime2) {
        return Access.encodingService(this.getCurrentContext()).findEncoding(this);
    }

    @Override
    public final int getCodeRange() {
        return this.flags & 0x30;
    }

    @Override
    public final void setCodeRange(int codeRange) {
        this.clearCodeRange();
        this.flags |= codeRange & 0x30;
    }

    @Override
    public final void clearCodeRange() {
        this.flags &= 0xFFFFFFCF;
    }

    @Override
    public final void keepCodeRange() {
        if (this.getCodeRange() == 48) {
            this.clearCodeRange();
        }
    }

    public final boolean isCodeRangeAsciiOnly() {
        return CodeRangeSupport.isCodeRangeAsciiOnly(this);
    }

    public final boolean isAsciiOnly() {
        return StringSupport.isAsciiOnly(this);
    }

    @Override
    public final boolean isCodeRangeValid() {
        return (this.flags & 0x30) == 32;
    }

    public final boolean isCodeRangeBroken() {
        return (this.flags & 0x30) == 48;
    }

    public final boolean isBrokenString() {
        return this.scanForCodeRange() == 48;
    }

    private void copyCodeRangeForSubstr(RubyString from, Encoding enc) {
        if (this.value.getRealSize() == 0) {
            this.setCodeRange(!enc.isAsciiCompatible() ? 32 : 16);
        } else {
            int fromCr = from.getCodeRange();
            if (fromCr == 16) {
                this.setCodeRange(fromCr);
            } else {
                this.setCodeRange(0);
            }
        }
    }

    @Override
    public final int scanForCodeRange() {
        int cr = this.getCodeRange();
        if (cr == 0) {
            cr = RubyString.scanForCodeRange(this.value);
            this.setCodeRange(cr);
        }
        return cr;
    }

    public static int scanForCodeRange(ByteList bytes2) {
        Encoding enc = bytes2.getEncoding();
        if (enc.minLength() > 1 && enc.isDummy() && EncodingUtils.getActualEncoding(enc, bytes2).minLength() == 1) {
            return 48;
        }
        return StringSupport.codeRangeScan(enc, bytes2);
    }

    final boolean singleByteOptimizable() {
        return StringSupport.isSingleByteOptimizable(this, EncodingUtils.STR_ENC_GET(this));
    }

    final boolean singleByteOptimizable(Encoding enc) {
        return StringSupport.isSingleByteOptimizable(this, enc);
    }

    final Encoding isCompatibleWith(EncodingCapable other) {
        Encoding enc2;
        if (other instanceof RubyString) {
            RubyString otherStr = (RubyString)other;
            return this.checkEncoding(otherStr);
        }
        Encoding enc1 = this.value.getEncoding();
        if (enc1 == (enc2 = other.getEncoding())) {
            return enc1;
        }
        if (this.value.getRealSize() == 0) {
            return enc2;
        }
        if (!enc1.isAsciiCompatible() || !enc2.isAsciiCompatible()) {
            return null;
        }
        if (enc2 instanceof USASCIIEncoding) {
            return enc1;
        }
        if (this.scanForCodeRange() == 16) {
            return enc2;
        }
        return null;
    }

    public final Encoding checkEncoding(RubyString other) {
        return this.checkEncoding((CodeRangeable)other);
    }

    @Deprecated(since="10.0.0.0")
    final Encoding checkEncoding(EncodingCapable other) {
        ThreadContext context = ((RubyBasicObject)((Object)other)).getCurrentContext();
        Encoding enc = this.isCompatibleWith(other);
        if (enc == null) {
            throw context.runtime.newEncodingCompatibilityError("incompatible character encodings: " + String.valueOf(this.value.getEncoding()) + " and " + String.valueOf(other.getEncoding()));
        }
        return enc;
    }

    @Override
    public final Encoding checkEncoding(CodeRangeable other) {
        Encoding enc = StringSupport.areCompatible(this, other);
        if (enc == null) {
            throw this.getRuntime().newEncodingCompatibilityError("incompatible character encodings: " + String.valueOf(this.value.getEncoding()) + " and " + String.valueOf(other.getByteList().getEncoding()));
        }
        return enc;
    }

    public static Encoding checkEncoding(Ruby runtime2, ByteList str1, ByteList str2) {
        Encoding enc = StringSupport.areCompatible(str1, str2);
        if (enc == null) {
            throw runtime2.newEncodingCompatibilityError("incompatible character encodings: " + String.valueOf(str1.getEncoding()) + " and " + String.valueOf(str2.getEncoding()));
        }
        return enc;
    }

    private Encoding checkDummyEncoding() {
        Encoding enc = this.value.getEncoding();
        if (enc.isDummy()) {
            throw this.getRuntime().newEncodingCompatibilityError("incompatible encoding with this operation: " + String.valueOf(enc));
        }
        return enc;
    }

    public final int strLength() {
        return StringSupport.strLengthFromRubyString(this);
    }

    final int strLength(ByteList bytes2, Encoding enc) {
        return StringSupport.strLengthFromRubyString(this, bytes2, enc);
    }

    final int subLength(int pos2) {
        if (pos2 < 0 || this.singleByteOptimizable()) {
            return pos2;
        }
        return StringSupport.strLength(this.value.getEncoding(), this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + pos2);
    }

    @Override
    public final boolean eql(IRubyObject other) {
        RubyClass meta = this.metaClass;
        if (meta != meta.runtime.getString() || meta != other.getMetaClass()) {
            return super.eql(other);
        }
        return this.eqlAndComparable(other);
    }

    @Deprecated(since="10.0.0.0")
    private boolean eql19(IRubyObject other) {
        return this.eqlAndComparable(other);
    }

    private boolean eqlAndComparable(IRubyObject other) {
        RubyString otherString = (RubyString)other;
        return StringSupport.areComparable(this, otherString) && this.value.equal(otherString.value);
    }

    public boolean hasNul() {
        ByteList bytes2 = this.getByteList();
        return Helpers.memchr(bytes2.unsafeBytes(), bytes2.begin(), 0, bytes2.realSize()) != -1;
    }

    public void verifyAsciiCompatible() {
        if (!this.getEncoding().isAsciiCompatible()) {
            throw this.getRuntime().newEncodingCompatibilityError("ASCII incompatible encoding: " + String.valueOf(this.getEncoding()));
        }
    }

    public RubyString(Ruby runtime2, RubyClass rubyClass) {
        this(runtime2, rubyClass, ByteList.NULL_ARRAY);
    }

    public RubyString(Ruby runtime2, RubyClass rubyClass, CharSequence value2) {
        this(runtime2, rubyClass, value2, (Encoding)UTF8);
    }

    public RubyString(Ruby runtime2, RubyClass rubyClass, CharSequence value2, Encoding enc) {
        super(runtime2, rubyClass);
        assert (value2 != null);
        assert (enc != null);
        this.value = RubyString.encodeBytelist(value2, enc);
    }

    private RubyString(Ruby runtime2, RubyClass rubyClass, String value2, Encoding enc) {
        super(runtime2, rubyClass);
        assert (value2 != null);
        assert (enc != null);
        this.value = RubyString.encodeBytelist(value2, enc);
    }

    private RubyString(Ruby runtime2, RubyClass rubyClass, String value2, Encoding enc, boolean objectspace) {
        super(runtime2, rubyClass, objectspace);
        assert (value2 != null);
        assert (enc != null);
        this.value = RubyString.encodeBytelist(value2, enc);
    }

    public RubyString(Ruby runtime2, RubyClass rubyClass, byte[] value2) {
        super(runtime2, rubyClass);
        assert (value2 != null);
        this.value = new ByteList(value2);
    }

    public RubyString(Ruby runtime2, RubyClass rubyClass, ByteList value2) {
        super(runtime2, rubyClass);
        assert (value2 != null);
        this.value = value2;
    }

    public RubyString(Ruby runtime2, RubyClass rubyClass, ByteList value2, boolean objectSpace) {
        super(runtime2, rubyClass, objectSpace);
        assert (value2 != null);
        this.value = value2;
    }

    public RubyString(Ruby runtime2, RubyClass rubyClass, ByteList value2, Encoding encoding2, boolean objectSpace) {
        this(runtime2, rubyClass, value2, objectSpace);
        value2.setEncoding(encoding2);
    }

    protected RubyString(Ruby runtime2, RubyClass rubyClass, ByteList value2, Encoding enc, int cr) {
        this(runtime2, rubyClass, value2);
        this.flags |= cr;
        value2.setEncoding(enc);
    }

    protected RubyString(Ruby runtime2, RubyClass rubyClass, ByteList value2, Encoding enc) {
        this(runtime2, rubyClass, value2);
        value2.setEncoding(enc);
    }

    protected RubyString(Ruby runtime2, RubyClass rubyClass, ByteList value2, int cr) {
        this(runtime2, rubyClass, value2);
        this.flags |= cr;
    }

    protected RubyString(Ruby runtime2, RubyClass rubyClass, ByteList value2, int cr, boolean objectspace) {
        this(runtime2, rubyClass, value2, objectspace);
        this.flags |= cr;
    }

    @Deprecated(since="1.1.6")
    public RubyString newString(CharSequence s2) {
        return new RubyString(this.getRuntime(), this.getType(), s2);
    }

    @Deprecated(since="1.1.6")
    public RubyString newString(ByteList s2) {
        return new RubyString(this.getRuntime(), this.getMetaClass(), s2);
    }

    @Deprecated(since="1.1.2")
    public static RubyString newString(Ruby runtime2, RubyClass clazz, CharSequence str) {
        return new RubyString(runtime2, clazz, str);
    }

    public static RubyString newStringLight(Ruby runtime2, ByteList bytes2) {
        return new RubyString(runtime2, runtime2.getString(), bytes2, false);
    }

    public static RubyString newStringLight(Ruby runtime2, int size2) {
        RubyString.checkNegativeSize(runtime2, size2);
        return new RubyString(runtime2, runtime2.getString(), new ByteList(size2), false);
    }

    public static RubyString newStringLight(Ruby runtime2, int size2, Encoding encoding2) {
        RubyString.checkNegativeSize(runtime2, size2);
        return new RubyString(runtime2, runtime2.getString(), new ByteList(size2), encoding2, false);
    }

    private static void checkNegativeSize(Ruby runtime2, int size2) {
        if (size2 < 0) {
            throw runtime2.newArgumentError("negative string size (or size too big)");
        }
    }

    public static RubyString newString(Ruby runtime2, CharSequence str) {
        return new RubyString(runtime2, runtime2.getString(), str, (Encoding)UTF8);
    }

    public static RubyString newString(Ruby runtime2, CharSequence str, Encoding encoding2) {
        return new RubyString(runtime2, runtime2.getString(), str, encoding2);
    }

    public static RubyString newString(Ruby runtime2, String str) {
        return new RubyString(runtime2, runtime2.getString(), str, (Encoding)UTF8);
    }

    public static RubyString newString(Ruby runtime2, String str, Encoding encoding2) {
        return new RubyString(runtime2, runtime2.getString(), str, encoding2);
    }

    public static RubyString newBinaryString(Ruby runtime2, String str) {
        return new RubyString(runtime2, runtime2.getString(), new ByteList(ByteList.plain(str), ASCIIEncoding.INSTANCE, false));
    }

    public static RubyString newBinaryString(Ruby runtime2, ByteList str) {
        return new RubyString(runtime2, runtime2.getString(), str, (Encoding)ASCIIEncoding.INSTANCE, false);
    }

    public static RubyString newUSASCIIString(Ruby runtime2, String str) {
        return new RubyString(runtime2, runtime2.getString(), str, (Encoding)USASCIIEncoding.INSTANCE);
    }

    public static RubyString newString(Ruby runtime2, byte[] bytes2) {
        return new RubyString(runtime2, runtime2.getString(), bytes2);
    }

    public static RubyString newString(Ruby runtime2, byte[] bytes2, int start2, int length2) {
        return RubyString.newString(runtime2, bytes2, start2, length2, ASCIIEncoding.INSTANCE);
    }

    public static RubyString newString(Ruby runtime2, byte[] bytes2, int start2, int length2, Encoding encoding2) {
        byte[] copy2 = new byte[length2];
        System.arraycopy(bytes2, start2, copy2, 0, length2);
        return new RubyString(runtime2, runtime2.getString(), new ByteList(copy2, encoding2, false));
    }

    public static RubyString newStringNoCopy(Ruby runtime2, byte[] bytes2, int start2, int length2, Encoding encoding2) {
        return new RubyString(runtime2, runtime2.getString(), new ByteList(bytes2, start2, length2, encoding2, false));
    }

    public static RubyString newString(Ruby runtime2, ByteList bytes2) {
        return new RubyString(runtime2, runtime2.getString(), bytes2);
    }

    public static RubyString newString(Ruby runtime2, ByteList bytes2, int coderange) {
        return new RubyString(runtime2, runtime2.getString(), bytes2, coderange);
    }

    public static RubyString newChilledString(Ruby runtime2, ByteList bytes2, int coderange, String file2, int line) {
        if (runtime2.getInstanceConfig().isDebuggingFrozenStringLiteral()) {
            return new DebugChilledString(runtime2, runtime2.getString(), bytes2, coderange, file2, line + 1);
        }
        return RubyString.newStringShared(runtime2, bytes2, coderange).chill();
    }

    public static RubyString newString(Ruby runtime2, ByteList bytes2, Encoding encoding2) {
        return new RubyString(runtime2, runtime2.getString(), bytes2, encoding2);
    }

    static RubyString newString(Ruby runtime2, byte b2) {
        return new RubyString(runtime2, runtime2.getString(), RubyInteger.singleCharByteList(b2));
    }

    public static RubyString newUnicodeString(Ruby runtime2, String str) {
        return runtime2.getDefaultInternalEncoding() == UTF16BEEncoding.INSTANCE ? RubyString.newUTF16String(runtime2, str) : RubyString.newUTF8String(runtime2, str);
    }

    public static RubyString newUTF8String(Ruby runtime2, String str) {
        return new RubyString(runtime2, runtime2.getString(), RubyEncoding.doEncodeUTF8(str));
    }

    public static RubyString newUTF16String(Ruby runtime2, String str) {
        return new RubyString(runtime2, runtime2.getString(), RubyEncoding.doEncodeUTF16(str));
    }

    public static RubyString newUnicodeString(Ruby runtime2, CharSequence str) {
        return runtime2.getDefaultInternalEncoding() == UTF16BEEncoding.INSTANCE ? RubyString.newUTF16String(runtime2, str) : RubyString.newUTF8String(runtime2, str);
    }

    public static RubyString newUTF8String(Ruby runtime2, CharSequence str) {
        return new RubyString(runtime2, runtime2.getString(), RubyEncoding.doEncodeUTF8(str));
    }

    public static RubyString newUTF16String(Ruby runtime2, CharSequence str) {
        return new RubyString(runtime2, runtime2.getString(), RubyEncoding.doEncodeUTF16(str));
    }

    public static RubyString newInternalFromJavaExternal(Ruby runtime2, String str) {
        Encoding internal = runtime2.getDefaultInternalEncoding();
        Charset rubyInt = null;
        if (internal != null) {
            rubyInt = EncodingUtils.charsetForEncoding(internal);
        }
        if (rubyInt == null) {
            Encoding javaExtEncoding = runtime2.getEncodingService().getJavaDefault();
            return RubyString.newString(runtime2, new ByteList(str.getBytes(), javaExtEncoding));
        }
        return RubyString.newString(runtime2, new ByteList(RubyEncoding.encode(str, rubyInt), internal));
    }

    @Deprecated(since="9.3.0.0")
    public static RubyString newExternalStringWithEncoding(Ruby runtime2, String string2, Encoding encoding2) {
        return EncodingUtils.newExternalStringWithEncoding(runtime2, string2, encoding2);
    }

    public static RubyString newStringShared(Ruby runtime2, RubyString orig) {
        orig.shareLevel = 2;
        RubyString str = new RubyString(runtime2, runtime2.getString(), orig.value);
        str.shareLevel = 2;
        return str;
    }

    public static RubyString newStringShared(Ruby runtime2, ByteList bytes2) {
        return RubyString.newStringShared(runtime2, runtime2.getString(), bytes2);
    }

    public static RubyString newStringShared(Ruby runtime2, ByteList bytes2, Encoding encoding2) {
        return RubyString.newStringShared(runtime2, runtime2.getString(), bytes2, encoding2);
    }

    public static RubyString newStringShared(Ruby runtime2, ByteList bytes2, int codeRange) {
        RubyString str = new RubyString(runtime2, runtime2.getString(), bytes2, codeRange);
        str.shareLevel = 2;
        return str;
    }

    public static RubyString newStringShared(Ruby runtime2, RubyClass clazz, ByteList bytes2) {
        RubyString str = new RubyString(runtime2, clazz, bytes2);
        str.shareLevel = 2;
        return str;
    }

    public static RubyString newStringShared(Ruby runtime2, RubyClass clazz, ByteList bytes2, Encoding encoding2) {
        if (bytes2.getEncoding() == encoding2) {
            return RubyString.newStringShared(runtime2, clazz, bytes2);
        }
        RubyString str = new RubyString(runtime2, clazz, bytes2.makeShared(bytes2.getBegin(), bytes2.getRealSize()), encoding2);
        str.shareLevel = 1;
        return str;
    }

    private static RubyString newStringShared(Ruby runtime2, ByteList bytes2, Encoding encoding2, int cr) {
        RubyString str = RubyString.newStringShared(runtime2, runtime2.getString(), bytes2, encoding2);
        str.flags |= cr;
        return str;
    }

    @Deprecated(since="10.0.0.0")
    public static RubyString newStringShared(Ruby runtime2, byte[] bytes2) {
        return RubyString.newStringShared(runtime2, bytes2, 0, bytes2.length, ASCIIEncoding.INSTANCE);
    }

    @Deprecated(since="10.0.0.0")
    public static RubyString newStringShared(Ruby runtime2, byte[] bytes2, Encoding encoding2) {
        return RubyString.newStringShared(runtime2, bytes2, 0, bytes2.length, encoding2);
    }

    @Deprecated(since="10.0.0.0")
    public static RubyString newStringShared(Ruby runtime2, byte[] bytes2, int start2, int length2) {
        return RubyString.newStringShared(runtime2, bytes2, start2, length2, ASCIIEncoding.INSTANCE);
    }

    public static RubyString newStringShared(Ruby runtime2, byte[] bytes2, int start2, int length2, Encoding encoding2) {
        ByteList byteList = new ByteList(bytes2, start2, length2, encoding2, false);
        RubyString str = new RubyString(runtime2, runtime2.getString(), byteList);
        str.shareLevel = 1;
        return str;
    }

    public static RubyString newEmptyString(Ruby runtime2) {
        return RubyString.newEmptyString(runtime2, runtime2.getString());
    }

    public static RubyString newEmptyBinaryString(Ruby runtime2) {
        return RubyString.newAllocatedString(runtime2, runtime2.getString());
    }

    public static RubyString newAllocatedString(Ruby runtime2, RubyClass metaClass) {
        RubyString empty = new RubyString(runtime2, metaClass, EMPTY_ASCII8BIT_BYTELIST);
        empty.shareLevel = 2;
        return empty;
    }

    public static RubyString newEmptyString(Ruby runtime2, RubyClass metaClass) {
        RubyString empty = new RubyString(runtime2, metaClass, EMPTY_USASCII_BYTELIST);
        empty.shareLevel = 2;
        return empty;
    }

    public static RubyString newStringNoCopy(Ruby runtime2, ByteList bytes2) {
        return RubyString.newStringNoCopy(runtime2, runtime2.getString(), bytes2);
    }

    public static RubyString newStringNoCopy(Ruby runtime2, RubyClass clazz, ByteList bytes2) {
        return new RubyString(runtime2, clazz, bytes2);
    }

    public static RubyString newStringNoCopy(Ruby runtime2, byte[] bytes2, int start2, int length2) {
        return RubyString.newStringNoCopy(runtime2, new ByteList(bytes2, start2, length2, false));
    }

    public static RubyString newStringNoCopy(Ruby runtime2, byte[] bytes2) {
        return RubyString.newStringNoCopy(runtime2, new ByteList(bytes2, false));
    }

    public final boolean independent() {
        return this.shareLevel == 0;
    }

    public final RubyString makeIndependent() {
        RubyClass klass = this.metaClass;
        RubyString str = this.strDup(klass.runtime, klass);
        str.modify();
        str.setFrozen(true);
        return str;
    }

    public final RubyString makeIndependent(int length2) {
        RubyClass klass = this.metaClass;
        RubyString str = this.strDup(klass.runtime, klass);
        str.modify(length2);
        str.setFrozen(true);
        return str;
    }

    public RubyString export(ThreadContext context) {
        if (Platform.IS_WINDOWS) {
            return EncodingUtils.strConvEncOpts(context, this, null, (Encoding)UTF8Encoding.INSTANCE, 0, context.nil);
        }
        return this;
    }

    public int capacity() {
        return this.value.getUnsafeBytes().length - this.value.begin();
    }

    public static EmptyByteListHolder getEmptyByteList(Encoding enc) {
        EmptyByteListHolder bytes2;
        EmptyByteListHolder[] emptyBytelists;
        int index2;
        if (enc == null) {
            enc = ASCIIEncoding.INSTANCE;
        }
        if ((index2 = enc.getIndex()) < (emptyBytelists = EMPTY_BYTELISTS).length && (bytes2 = emptyBytelists[index2]) != null) {
            return bytes2;
        }
        return RubyString.prepareEmptyByteList(enc);
    }

    private static EmptyByteListHolder prepareEmptyByteList(Encoding enc) {
        EmptyByteListHolder[] emptyBytelists;
        int index2;
        if (enc == null) {
            enc = ASCIIEncoding.INSTANCE;
        }
        if ((index2 = enc.getIndex()) >= (emptyBytelists = EMPTY_BYTELISTS).length) {
            EMPTY_BYTELISTS = emptyBytelists = Arrays.copyOfRange(emptyBytelists, 0, index2 + 4);
        }
        emptyBytelists[index2] = new EmptyByteListHolder(enc);
        return emptyBytelists[index2];
    }

    public static RubyString newEmptyString(Ruby runtime2, RubyClass metaClass, Encoding enc) {
        EmptyByteListHolder holder = RubyString.getEmptyByteList(enc);
        RubyString empty = new RubyString(runtime2, metaClass, holder.bytes, holder.cr);
        empty.shareLevel = 2;
        return empty;
    }

    public static RubyString newEmptyString(Ruby runtime2, Encoding enc) {
        return RubyString.newEmptyString(runtime2, runtime2.getString(), enc);
    }

    public static RubyString newStringNoCopy(Ruby runtime2, RubyClass clazz, ByteList bytes2, Encoding enc, int cr) {
        return new RubyString(runtime2, clazz, bytes2, enc, cr);
    }

    public static RubyString newStringNoCopy(Ruby runtime2, ByteList bytes2, Encoding enc, int cr) {
        return RubyString.newStringNoCopy(runtime2, runtime2.getString(), bytes2, enc, cr);
    }

    public static RubyString newUsAsciiStringNoCopy(Ruby runtime2, ByteList bytes2) {
        return RubyString.newStringNoCopy(runtime2, bytes2, USASCIIEncoding.INSTANCE, 16);
    }

    public static RubyString newUsAsciiStringShared(Ruby runtime2, ByteList bytes2) {
        RubyString str = RubyString.newUsAsciiStringNoCopy(runtime2, bytes2);
        str.shareLevel = 2;
        return str;
    }

    public static RubyString newUsAsciiStringShared(Ruby runtime2, byte[] bytes2, int start2, int length2) {
        RubyString str = RubyString.newUsAsciiStringNoCopy(runtime2, new ByteList(bytes2, start2, length2, false));
        str.shareLevel = 1;
        return str;
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.STRING;
    }

    @Override
    public Class getJavaClass() {
        return String.class;
    }

    @Override
    public RubyString convertToString() {
        return this;
    }

    @Override
    public String toString() {
        return this.decodeString();
    }

    public String decodeString() {
        return Helpers.decodeByteList(this.getRuntime(), this.value);
    }

    @Override
    public IRubyObject dup() {
        RubyClass mc = this.metaClass.getRealClass();
        if (mc.getClassIndex() != ClassIndex.STRING) {
            return super.dup();
        }
        return this.strDup(mc.getClassRuntime(), mc.getRealClass());
    }

    public IRubyObject dupFrozen() {
        RubyString dup2 = (RubyString)this.dup();
        dup2.setFrozen(true);
        return dup2;
    }

    @Override
    @JRubyMethod
    public IRubyObject dup(ThreadContext context) {
        return this.isBare(context) ? this.strDup(context.runtime) : super.dup(context);
    }

    public final RubyString strDup(Ruby runtime2) {
        return this.strDup(runtime2, this.metaClass.getRealClass());
    }

    public final RubyString strDup(Ruby runtime2, RubyClass clazz) {
        this.shareLevel = 2;
        RubyString dup2 = new RubyString(runtime2, clazz, this.value);
        dup2.shareLevel = 2;
        dup2.flags |= this.flags & 0x30;
        return dup2;
    }

    public final RubyString dupAsChilled(Ruby runtime2, RubyClass clazz, String file2, int line) {
        if (runtime2.getInstanceConfig().isDebuggingFrozenStringLiteral()) {
            this.shareLevel = 2;
            DebugChilledString dup2 = new DebugChilledString(runtime2, clazz, this.value, this.getCodeRange(), file2, line + 1 + 1);
            dup2.flags |= this.flags & 0x30;
            return dup2;
        }
        return this.strDup(runtime2, clazz).chill();
    }

    public FString dupAsFString(Ruby runtime2) {
        this.shareLevel = 2;
        FString dup2 = new FString(runtime2, this.value, this.getCodeRange());
        dup2.shareLevel = 2;
        dup2.flags |= ObjectFlags.FSTRING | FROZEN_F | this.flags & 0x30;
        return dup2;
    }

    public final RubyString makeSharedString(Ruby runtime2, int index2, int len) {
        return this.makeShared(runtime2, runtime2.getString(), this.value, index2, len);
    }

    public final RubyString makeShared(Ruby runtime2, int index2, int len) {
        return this.makeShared(runtime2, this.getType(), this.value, index2, len);
    }

    public final RubyString makeShared(Ruby runtime2, RubyClass meta, int index2, int len) {
        RubyString shared;
        if (len == 0) {
            shared = RubyString.newEmptyString(runtime2, meta);
        } else if (len == 1) {
            shared = RubyString.newStringShared(runtime2, meta, RubyInteger.singleCharByteList(this.value.getUnsafeBytes()[this.value.getBegin() + index2]));
        } else {
            if (this.shareLevel == 0) {
                this.shareLevel = 1;
            }
            shared = new RubyString(runtime2, meta, this.value.makeShared(index2, len));
            shared.shareLevel = 1;
        }
        return shared;
    }

    private RubyString makeShared(Ruby runtime2, ByteList value2, int index2, int len) {
        return this.makeShared(runtime2, this.getType(), value2, index2, len);
    }

    private RubyString makeShared(Ruby runtime2, RubyClass meta, ByteList value2, int index2, int len) {
        RubyString shared;
        Encoding enc = value2.getEncoding();
        if (len == 0) {
            shared = RubyString.newEmptyString(runtime2, meta, enc);
        } else if (len == 1) {
            shared = RubyInteger.singleCharString(runtime2, (byte)value2.get(index2), meta, enc);
        } else {
            if (this.shareLevel == 0) {
                this.shareLevel = 1;
            }
            shared = new RubyString(runtime2, meta, value2.makeShared(index2, len));
            shared.shareLevel = 1;
        }
        shared.copyCodeRangeForSubstr(this, enc);
        return shared;
    }

    public final void setByteListShared() {
        if (this.shareLevel != 2) {
            this.shareLevel = 2;
        }
    }

    final void setBufferShared() {
        if (this.shareLevel == 0) {
            this.shareLevel = 1;
        }
    }

    public final void modifyCheck() {
        this.frozenCheck();
    }

    public void modifyCheck(byte[] b2, int len) {
        if (this.value.getUnsafeBytes() != b2 || this.value.getRealSize() != len) {
            throw this.getRuntime().newRuntimeError("string modified");
        }
    }

    private void modifyCheck(byte[] b2, int len, Encoding enc) {
        if (this.value.getUnsafeBytes() != b2 || this.value.getRealSize() != len || this.value.getEncoding() != enc) {
            throw this.getRuntime().newRuntimeError("string modified");
        }
    }

    protected void frozenCheck() {
        if (this.isChilled()) {
            this.mutateChilledString();
        } else if (this.isFrozen()) {
            throw this.getRuntime().newFrozenError("String", this);
        }
    }

    @Override
    public void checkFrozen() {
        this.frozenCheck();
    }

    @Override
    public final void ensureInstanceVariablesSettable() {
        this.frozenCheck();
    }

    protected void mutateChilledString() {
        int savedFlags = this.flags;
        this.flags &= ~(ObjectFlags.CHILLED_LITERAL_F | ObjectFlags.CHILLED_SYMBOL_TO_S_F);
        if ((savedFlags & ObjectFlags.CHILLED_LITERAL_F) != 0) {
            this.getRuntime().getWarnings().warnDeprecated("literal string will be frozen in the future");
        } else if ((savedFlags & ObjectFlags.CHILLED_SYMBOL_TO_S_F) != 0) {
            this.getRuntime().getWarnings().warnDeprecated("string returned by :" + String.valueOf(this.value) + ".to_s will be frozen in the future");
        }
    }

    protected boolean isChilled() {
        return (this.flags & (ObjectFlags.CHILLED_LITERAL_F | ObjectFlags.CHILLED_SYMBOL_TO_S_F)) != 0;
    }

    protected boolean isChilledLiteral() {
        return (this.flags & ObjectFlags.CHILLED_LITERAL_F) != 0;
    }

    @Override
    public final void modify() {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.dup();
            } else {
                this.value.unshare();
            }
            this.shareLevel = 0;
        }
        this.value.invalidate();
    }

    @Deprecated(since="10.0.0.0")
    public final void modify19() {
        this.modifyAndClearCodeRange();
    }

    public final void modifyAndClearCodeRange() {
        this.modify();
        this.clearCodeRange();
    }

    @Override
    public void modifyAndKeepCodeRange() {
        this.modify();
        this.keepCodeRange();
    }

    @Override
    public final void modify(int length2) {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.dup(length2);
            } else {
                this.value.unshare(length2);
            }
            this.shareLevel = 0;
        } else {
            this.value.ensure(length2);
        }
        this.value.invalidate();
    }

    public final void modifyExpand(int length2) {
        this.modify(length2);
        this.clearCodeRange();
    }

    public void ensureAvailable(ThreadContext context, int extraLength) {
        int realSize = this.value.getRealSize();
        if (realSize > Integer.MAX_VALUE - extraLength) {
            throw Error.argumentError(context, "string sizes too big");
        }
        this.modifyExpand(realSize + extraLength);
    }

    public void setReadLength(int length2) {
        if (this.size() != length2) {
            this.modify();
            this.value.setRealSize(length2);
        }
    }

    public static RubyString newFString(Ruby runtime2, String content) {
        return runtime2.freezeAndDedupString(new FString(runtime2, content));
    }

    public RubyString newFrozen() {
        if (this.isFrozen()) {
            return this;
        }
        RubyString str = this.strDup(this.metaClass.runtime);
        str.setCodeRange(this.getCodeRange());
        str.setFrozen(true);
        return str;
    }

    public static RubyString newDebugFrozenString(Ruby runtime2, RubyClass rubyClass, ByteList value2, int cr, String file2, int line) {
        return new DebugFrozenString(runtime2, rubyClass, value2, cr, file2, line);
    }

    public static RubyString newDebugChilledString(Ruby runtime2, RubyClass rubyClass, ByteList value2, int cr, String file2, int line) {
        return new DebugChilledString(runtime2, rubyClass, value2, cr, file2, line);
    }

    public final void resize(int size2) {
        int len = this.value.length();
        if (len > size2) {
            this.modify(size2);
            this.value.setRealSize(size2);
        } else if (len < size2) {
            this.modify(size2);
            this.value.length(size2);
        }
    }

    public final void view(ByteList bytes2) {
        this.modifyCheck();
        this.value = bytes2;
        this.shareLevel = 0;
    }

    private void view(byte[] bytes2, boolean copy2) {
        this.modifyCheck();
        this.value = new ByteList(bytes2, copy2);
        this.shareLevel = 0;
        this.value.invalidate();
    }

    private void view(int index2, int len) {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.makeShared(index2, len);
                this.shareLevel = 1;
            } else {
                this.value.view(index2, len);
            }
        } else {
            this.value.view(index2, len);
            this.shareLevel = 1;
        }
        this.value.invalidate();
    }

    public static String bytesToString(byte[] bytes2, int beg, int len) {
        return new String(ByteList.plain(bytes2, beg, len));
    }

    public static String byteListToString(ByteList bytes2) {
        return RubyString.bytesToString(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
    }

    public static String bytesToString(byte[] bytes2) {
        return RubyString.bytesToString(bytes2, 0, bytes2.length);
    }

    public static byte[] stringToBytes(String string2) {
        return ByteList.plain(string2);
    }

    @Override
    public RubyString asString() {
        return this;
    }

    @Override
    public IRubyObject checkStringType() {
        return this;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject try_convert(ThreadContext context, IRubyObject recv2, IRubyObject str) {
        return str.checkStringType();
    }

    @Override
    @JRubyMethod(name={"to_s", "to_str"})
    public RubyString to_s(ThreadContext context) {
        return this.metaClass.getRealClass() != Access.stringClass(context) ? Create.dupString(context, this) : this;
    }

    @Override
    public final int compareTo(IRubyObject other) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        return Convert.toInt(context, this.op_cmp(context, other));
    }

    @Override
    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            RubyString otherStr = (RubyString)other;
            return Convert.asFixnum(context, this.op_cmp(otherStr));
        }
        JavaSites.CheckedSites sites = RubyString.sites((ThreadContext)context).to_str_checked;
        if (sites.respond_to_X.respondsTo(context, this, other)) {
            IRubyObject tmp = TypeConverter.checkStringType(context, sites, other);
            if (tmp instanceof RubyString) {
                RubyString otherStr = (RubyString)tmp;
                return Convert.asFixnum(context, this.op_cmp(otherStr));
            }
            return context.nil;
        }
        return RubyComparable.invcmp(context, RubyString.sites((ThreadContext)context).recursive_cmp, this, other);
    }

    @Override
    @JRubyMethod(name={"==", "==="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        RubyString otherStr;
        if (this == other) {
            return context.tru;
        }
        return other instanceof RubyString ? Convert.asBoolean(context, StringSupport.areComparable(this, otherStr = (RubyString)other) && this.value.equal(otherStr.value)) : this.op_equalCommon(context, other);
    }

    private IRubyObject op_equalCommon(ThreadContext context, IRubyObject other) {
        if (!RubyString.sites((ThreadContext)context).respond_to_to_str.respondsTo(context, this, other)) {
            return context.fals;
        }
        return Convert.asBoolean(context, RubyString.sites((ThreadContext)context).equals.call(context, (IRubyObject)this, other, (IRubyObject)this).isTrue());
    }

    @JRubyMethod(name={"-@", "dedup"})
    public final IRubyObject minus_at(ThreadContext context) {
        return context.runtime.freezeAndDedupString(this);
    }

    @Deprecated(since="10.0.0.0")
    public final IRubyObject plus_at() {
        return this.plus_at(this.getCurrentContext());
    }

    @JRubyMethod(name={"+@"})
    public final IRubyObject plus_at(ThreadContext context) {
        return this.isFrozen() | this.isChilled() ? this.dup() : this;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject op_plus19(ThreadContext context, IRubyObject arg2) {
        return this.op_plus(context, arg2);
    }

    @JRubyMethod(name={"+"})
    public IRubyObject op_plus(ThreadContext context, IRubyObject arg2) {
        RubyString str = arg2.convertToString();
        Encoding enc = this.checkEncoding(str);
        long len = (long)this.value.getRealSize() + (long)str.value.getRealSize();
        if (len > Integer.MAX_VALUE) {
            throw Error.argumentError(context, "argument too big");
        }
        RubyString resultStr = RubyString.newStringNoCopy(context.runtime, StringSupport.addByteLists(this.value, str.value), enc, CodeRangeSupport.codeRangeAnd(this.getCodeRange(), str.getCodeRange()));
        return resultStr;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject op_mul19(ThreadContext context, IRubyObject other) {
        return this.op_mul(context, other);
    }

    @JRubyMethod(name={"*"})
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        RubyString result2 = this.multiplyByteList(context, other);
        result2.value.setEncoding(this.value.getEncoding());
        result2.copyCodeRangeForSubstr(this, this.value.getEncoding());
        return result2;
    }

    private RubyString multiplyByteList(ThreadContext context, IRubyObject arg2) {
        long longLen = Convert.toLong(context, arg2);
        if (longLen < 0L) {
            throw Error.argumentError(context, "negative argument");
        }
        if (this.isEmpty()) {
            return (RubyString)this.dup();
        }
        int len = Helpers.multiplyBufferLength(context, this.value.getRealSize(), Convert.checkInt(context, longLen));
        ByteList bytes2 = new ByteList(len);
        if (len > 0) {
            int n;
            bytes2.setRealSize(len);
            System.arraycopy(this.value.getUnsafeBytes(), this.value.getBegin(), bytes2.getUnsafeBytes(), 0, n);
            for (n = this.value.getRealSize(); n <= len >> 1; n <<= 1) {
                System.arraycopy(bytes2.getUnsafeBytes(), 0, bytes2.getUnsafeBytes(), n, n);
            }
            System.arraycopy(bytes2.getUnsafeBytes(), 0, bytes2.getUnsafeBytes(), n, len - n);
        }
        return Create.newString(context, bytes2);
    }

    @JRubyMethod(name={"%"})
    public RubyString op_format(ThreadContext context, IRubyObject arg2) {
        IRubyObject tmp;
        if (arg2 instanceof RubyHash) {
            tmp = arg2;
        } else {
            tmp = arg2.checkArrayType();
            if (tmp.isNil()) {
                tmp = arg2;
            }
        }
        ByteList out = new ByteList(this.value.getRealSize());
        out.setEncoding(this.value.getEncoding());
        Sprintf.sprintf1_9(out, Locale.US, this.value, tmp);
        return Create.newString(context, out);
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        return Convert.asFixnum(context, this.strHashCode(context.runtime));
    }

    @Override
    public int hashCode() {
        return this.strHashCode(this.getRuntime());
    }

    public int strHashCode(Ruby runtime2) {
        ByteList value2 = this.value;
        Encoding enc = value2.getEncoding();
        long hash2 = runtime2.isSiphashEnabled() ? SipHashInline.hash24(runtime2.getHashSeedK0(), runtime2.getHashSeedK1(), value2.getUnsafeBytes(), value2.getBegin(), value2.getRealSize()) : PerlHash.hash(runtime2.getHashSeedK0(), value2.getUnsafeBytes(), value2.getBegin(), value2.getRealSize());
        return (int)(hash2 ^= (long)(enc.isAsciiCompatible() && this.scanForCodeRange() == 16 ? 0 : enc.getIndex()));
    }

    public int unseededStrHashCode(Ruby runtime2) {
        ByteList value2 = this.value;
        Encoding enc = value2.getEncoding();
        long hash2 = runtime2.isSiphashEnabled() ? SipHashInline.hash24(0L, 0L, value2.getUnsafeBytes(), value2.getBegin(), value2.getRealSize()) : PerlHash.hash(0L, value2.getUnsafeBytes(), value2.getBegin(), value2.getRealSize());
        return (int)(hash2 ^= (long)(enc.isAsciiCompatible() && this.scanForCodeRange() == 16 ? 0 : enc.getIndex()));
    }

    @Override
    public boolean equals(Object other) {
        RubyString otherStr;
        if (this == other) {
            return true;
        }
        return other instanceof RubyString && this.equals(otherStr = (RubyString)other);
    }

    final boolean equals(RubyString other) {
        return other.value.equal(this.value);
    }

    public static RubyString objAsString(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubyString) {
            RubyString str = (RubyString)obj;
            return str;
        }
        IRubyObject str = RubyString.sites((ThreadContext)context).to_s.call(context, obj, obj);
        if (!(str instanceof RubyString)) {
            return Convert.anyToString(context, obj);
        }
        return (RubyString)str;
    }

    public final int op_cmp(RubyString other) {
        int ret = this.value.cmp(other.value);
        if (ret == 0 && !StringSupport.areComparable(this, other)) {
            return this.value.getEncoding().getIndex() > other.value.getEncoding().getIndex() ? 1 : -1;
        }
        return ret;
    }

    @Override
    public String asJavaString() {
        return this.toString();
    }

    public IRubyObject doClone() {
        return RubyString.newString(this.getRuntime(), this.value.dup());
    }

    public final RubyString cat(byte[] str) {
        this.modify(this.value.getRealSize() + str.length);
        System.arraycopy(str, 0, this.value.getUnsafeBytes(), this.value.getBegin() + this.value.getRealSize(), str.length);
        this.value.setRealSize(this.value.getRealSize() + str.length);
        return this;
    }

    public final RubyString cat(byte[] str, int beg, int len) {
        this.modify(this.value.getRealSize() + len);
        if (len == 0) {
            return this;
        }
        System.arraycopy(str, beg, this.value.getUnsafeBytes(), this.value.getBegin() + this.value.getRealSize(), len);
        this.value.setRealSize(this.value.getRealSize() + len);
        return this;
    }

    @Deprecated(since="10.0.0.0")
    public final RubyString cat19(RubyString str2) {
        return this.catWithCodeRange(str2);
    }

    public final RubyString catWithCodeRange(RubyString str2) {
        ByteList other = str2.getByteList();
        int str2_cr = this.catWithCodeRange(other, str2.getCodeRange());
        str2.setCodeRange(str2_cr);
        return this;
    }

    public final RubyString cat(ByteList other, int codeRange) {
        this.catWithCodeRange(other, codeRange);
        return this;
    }

    @Deprecated(since="10.0.0.0")
    public final int cat19(ByteList other, int codeRange) {
        return this.catWithCodeRange(other, codeRange);
    }

    public final int catWithCodeRange(ByteList other, int codeRange) {
        return EncodingUtils.encCrStrBufCat(this.metaClass.runtime, this, other, other.getEncoding(), codeRange);
    }

    public final RubyString catStringUnsafe(String str) {
        ByteList other = RubyString.encodeBytelist(str, this.getEncoding());
        this.catWithCodeRange(other, 0);
        return this;
    }

    public final RubyString catString(String str) {
        ByteList other;
        this.catWithCodeRange(other, (other = RubyString.encodeBytelist(str, (Encoding)UTF8)).realSize() == str.length() ? 16 : 32);
        return this;
    }

    public final RubyString cat(RubyString str) {
        return this.cat(str.getByteList());
    }

    public final RubyString cat(ByteList str) {
        this.modify(this.value.getRealSize() + str.getRealSize());
        System.arraycopy(str.getUnsafeBytes(), str.getBegin(), this.value.getUnsafeBytes(), this.value.getBegin() + this.value.getRealSize(), str.getRealSize());
        this.value.setRealSize(this.value.getRealSize() + str.getRealSize());
        return this;
    }

    public final RubyString cat(byte ch) {
        this.modify(this.value.getRealSize() + 1);
        this.value.getUnsafeBytes()[this.value.getBegin() + this.value.getRealSize()] = ch;
        this.value.setRealSize(this.value.getRealSize() + 1);
        return this;
    }

    public final RubyString cat(int ch) {
        return this.cat((byte)ch);
    }

    public final RubyString cat(int code, Encoding enc) {
        int n = StringSupport.codeLength(enc, code);
        this.modify(this.value.getRealSize() + n);
        enc.codeToMbc(code, this.value.getUnsafeBytes(), this.value.getBegin() + this.value.getRealSize());
        this.value.setRealSize(this.value.getRealSize() + n);
        return this;
    }

    public final int cat(byte[] bytes2, int p2, int len, Encoding enc) {
        return EncodingUtils.encCrStrBufCat(this.getRuntime(), this, new ByteList(bytes2, p2, len), enc, 0);
    }

    public final RubyString catAscii(byte[] bytes2, int ptr, int ptrLen) {
        Encoding enc = this.value.getEncoding();
        if (enc.isAsciiCompatible()) {
            EncodingUtils.encCrStrBufCat(this.getRuntime(), this, new ByteList(bytes2, ptr, ptrLen), enc, 16);
        } else {
            byte[] buf = new byte[enc.maxLength()];
            int end2 = ptr + ptrLen;
            while (ptr < end2) {
                byte c = bytes2[ptr];
                int len = StringSupport.codeLength(enc, c);
                EncodingUtils.encMbcput(c, buf, 0, enc);
                EncodingUtils.encCrStrBufCat(this.getRuntime(), this, buf, 0, len, enc, 32);
                ++ptr;
            }
        }
        return this;
    }

    @Deprecated(since="10.0.0.0")
    public RubyString replace19(IRubyObject other) {
        return this.replace(this.getCurrentContext(), other);
    }

    @Override
    @Deprecated(since="10.0.0.0")
    public RubyString initialize_copy(IRubyObject other) {
        return this.initialize_copy(this.getCurrentContext(), other);
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public RubyString initialize_copy(ThreadContext context, IRubyObject other) {
        return this.replace(context, other);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject replace(IRubyObject other) {
        return this.replace(this.getCurrentContext(), other);
    }

    @JRubyMethod(name={"replace"})
    public RubyString replace(ThreadContext context, IRubyObject other) {
        this.modifyCheck();
        if (this == other) {
            return this;
        }
        this.setCodeRange(this.replaceCommon(other).getCodeRange());
        return this;
    }

    private RubyString replaceCommon(IRubyObject other) {
        this.modifyCheck();
        RubyString otherStr = other.convertToString();
        this.shareLevel = 2;
        otherStr.shareLevel = 2;
        this.value = otherStr.value;
        return otherStr;
    }

    @Deprecated(since="10.0.0.0")
    public RubyString clear() {
        return this.clear(this.getCurrentContext());
    }

    @JRubyMethod
    public RubyString clear(ThreadContext context) {
        this.modifyCheck();
        Encoding enc = this.value.getEncoding();
        EmptyByteListHolder holder = RubyString.getEmptyByteList(enc);
        this.value = holder.bytes;
        this.shareLevel = 2;
        this.setCodeRange(holder.cr);
        return this;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject reverse19(ThreadContext context) {
        return this.reverse(context);
    }

    @JRubyMethod(name={"reverse"})
    public IRubyObject reverse(ThreadContext context) {
        RubyString str = Create.dupString(context, this);
        str.reverse_bang(context);
        return str;
    }

    @Deprecated(since="10.0.0.0")
    public RubyString reverse_bang19(ThreadContext context) {
        return this.reverse_bang(context);
    }

    @JRubyMethod(name={"reverse!"})
    public RubyString reverse_bang(ThreadContext context) {
        this.modifyCheck();
        if (this.value.getRealSize() > 1) {
            int p2;
            this.modifyAndKeepCodeRange();
            byte[] bytes2 = this.value.getUnsafeBytes();
            int len = this.value.getRealSize();
            int end2 = p2 + len;
            int op = len;
            int cr = this.getCodeRange();
            Encoding enc = this.value.getEncoding();
            if (this.singleByteOptimizable()) {
                for (int i2 = 0; i2 < len >> 1; ++i2) {
                    byte b2 = bytes2[p2 + i2];
                    bytes2[p2 + i2] = bytes2[p2 + len - i2 - 1];
                    bytes2[p2 + len - i2 - 1] = b2;
                }
            } else if (cr == 32) {
                int cl;
                byte[] obytes = new byte[len];
                for (p2 = this.value.getBegin(); p2 < end2; p2 += cl) {
                    cl = StringSupport.encFastMBCLen(bytes2, p2, end2, enc);
                    System.arraycopy(bytes2, p2, obytes, op -= cl, cl);
                }
                this.value.setUnsafeBytes(obytes);
                this.value.setBegin(0);
            } else {
                byte[] obytes = new byte[len];
                int n = cr = enc.isAsciiCompatible() ? 16 : 32;
                while (p2 < end2) {
                    int cl = StringSupport.length(enc, bytes2, p2, end2);
                    if (cl > 1 || (bytes2[p2] & 0x80) != 0) {
                        cr = 0;
                    }
                    System.arraycopy(bytes2, p2, obytes, op -= cl, cl);
                    p2 += cl;
                }
                this.value.setUnsafeBytes(obytes);
                this.value.setBegin(0);
            }
            this.setCodeRange(cr);
        }
        return this;
    }

    public static RubyString newInstance(IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyString newString = RubyString.newStringShared(recv2.getRuntime(), ByteList.EMPTY_BYTELIST);
        newString.setMetaClass((RubyClass)recv2);
        newString.callInit(args2, block);
        return newString;
    }

    @Override
    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0) {
        IRubyObject tmp = ArgsUtil.getOptionsArg(context, arg0);
        return tmp.isNil() ? this.initialize(context, arg0, null) : this.initialize(context, null, (RubyHash)tmp);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0, IRubyObject opts) {
        IRubyObject tmp = ArgsUtil.getOptionsArg(context, opts);
        if (tmp.isNil()) {
            throw Error.argumentError(context, 2, 1);
        }
        return this.initialize(context, arg0, (RubyHash)tmp);
    }

    private IRubyObject initialize(ThreadContext context, IRubyObject arg0, RubyHash opts) {
        if (arg0 != null) {
            this.replace(context, arg0);
        }
        if (opts != null) {
            IRubyObject encoding2 = opts.fastARef(Convert.asSymbol(context, "encoding"));
            IRubyObject capacity = opts.fastARef(Convert.asSymbol(context, "capacity"));
            if (capacity != null && !capacity.isNil()) {
                int capa = Convert.toInt(context, capacity);
                if (capa < 4) {
                    capa = 4;
                }
                this.modify(capa);
            }
            if (encoding2 != null && !encoding2.isNil()) {
                this.modify();
                this.setEncodingAndCodeRange(Access.encodingService(context).getEncodingFromObject(encoding2), 0);
            }
        }
        return this;
    }

    @JRubyMethod(name={"casecmp"})
    public IRubyObject casecmp(ThreadContext context, IRubyObject other) {
        IRubyObject tmp = other.checkStringType();
        if (tmp.isNil()) {
            return context.nil;
        }
        RubyString otherStr = (RubyString)tmp;
        Encoding enc = StringSupport.areCompatible(this, (CodeRangeable)otherStr);
        if (enc == null) {
            return context.nil;
        }
        return Convert.asFixnum(context, this.singleByteOptimizable() && otherStr.singleByteOptimizable() ? this.value.caseInsensitiveCmp(otherStr.value) : StringSupport.multiByteCasecmp(enc, this.value, otherStr.value));
    }

    @JRubyMethod(name={"casecmp?"})
    public IRubyObject casecmp_p(ThreadContext context, IRubyObject other) {
        IRubyObject tmp = other.checkStringType();
        if (tmp.isNil()) {
            return context.nil;
        }
        RubyString otherStr = (RubyString)tmp;
        Encoding enc = StringSupport.areCompatible(this, (CodeRangeable)otherStr);
        if (enc == null) {
            return context.nil;
        }
        int flags2 = 524288;
        RubyString down = Create.dupString(context, this);
        down.downcase_bang(context, flags2);
        RubyString otherDown = Create.dupString(context, otherStr);
        otherDown.downcase_bang(context, flags2);
        return Convert.asBoolean(context, down.equals(otherDown));
    }

    @Override
    @JRubyMethod(name={"=~"}, writes={FrameField.BACKREF})
    public IRubyObject op_match(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyRegexp) {
            RubyRegexp otherRegexp = (RubyRegexp)other;
            return otherRegexp.op_match(context, this);
        }
        if (other instanceof RubyString) {
            throw Error.typeError(context, "type mismatch: String given");
        }
        return RubyString.sites((ThreadContext)context).op_match.call(context, other, other, (IRubyObject)this);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject match19(ThreadContext context, IRubyObject pattern) {
        return this.match(context, pattern, Block.NULL_BLOCK);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject match19(ThreadContext context, IRubyObject pattern, IRubyObject pos2, Block block) {
        return this.match(context, pattern, pos2, block);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject match19(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.match(context, args2, block);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject match(ThreadContext context, IRubyObject pattern) {
        return this.match(context, pattern, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"match"}, writes={FrameField.BACKREF})
    public IRubyObject match(ThreadContext context, IRubyObject pattern, Block block) {
        RubyRegexp coercedPattern = RubyString.getPattern(context, pattern);
        IRubyObject result2 = RubyString.sites((ThreadContext)context).match.call(context, (IRubyObject)coercedPattern, (IRubyObject)coercedPattern, (IRubyObject)this);
        return block.isGiven() && result2 != context.nil ? block.yield(context, result2) : result2;
    }

    @JRubyMethod(name={"match"}, writes={FrameField.BACKREF})
    public IRubyObject match(ThreadContext context, IRubyObject pattern, IRubyObject pos2, Block block) {
        RubyRegexp coercedPattern = RubyString.getPattern(context, pattern);
        IRubyObject result2 = RubyString.sites((ThreadContext)context).match.call(context, (IRubyObject)coercedPattern, (IRubyObject)coercedPattern, (IRubyObject)this, pos2);
        return block.isGiven() && result2 != context.nil ? block.yield(context, result2) : result2;
    }

    @JRubyMethod(name={"match"}, required=1, rest=true, checkArity=false)
    public IRubyObject match(ThreadContext context, IRubyObject[] args2, Block block) {
        if (args2.length < 1) {
            Arity.checkArgumentCount(context, args2, 1, -1);
        }
        RubyRegexp pattern = RubyString.getPattern(context, args2[0]);
        args2[0] = this;
        IRubyObject result2 = RubyString.sites((ThreadContext)context).match.call(context, (IRubyObject)pattern, (IRubyObject)pattern, args2);
        return block.isGiven() && result2 != context.nil ? block.yield(context, result2) : result2;
    }

    @JRubyMethod(name={"match?"})
    public IRubyObject match_p(ThreadContext context, IRubyObject pattern) {
        return RubyString.getPattern(context, pattern).matchP(context, this, 0);
    }

    @JRubyMethod(name={"match?"})
    public IRubyObject match_p(ThreadContext context, IRubyObject pattern, IRubyObject pos2) {
        return RubyString.getPattern(context, pattern).matchP(context, this, Convert.toInt(context, pos2));
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject op_ge19(ThreadContext context, IRubyObject other) {
        return this.op_ge(context, other);
    }

    /*
     * Enabled aggressive block sorting
     */
    @JRubyMethod(name={">="})
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        RubyBoolean rubyBoolean;
        if (other instanceof RubyString) {
            RubyString otherStr = (RubyString)other;
            if (this.cmpIsBuiltin(context)) {
                rubyBoolean = Convert.asBoolean(context, this.op_cmp(otherStr) >= 0);
                return rubyBoolean;
            }
        }
        rubyBoolean = RubyComparable.op_ge(context, this, other);
        return rubyBoolean;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject op_gt19(ThreadContext context, IRubyObject other) {
        return this.op_gt(context, other);
    }

    /*
     * Enabled aggressive block sorting
     */
    @JRubyMethod(name={">"})
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        RubyBoolean rubyBoolean;
        if (other instanceof RubyString) {
            RubyString otherStr = (RubyString)other;
            if (this.cmpIsBuiltin(context)) {
                rubyBoolean = Convert.asBoolean(context, this.op_cmp(otherStr) > 0);
                return rubyBoolean;
            }
        }
        rubyBoolean = RubyComparable.op_gt(context, this, other);
        return rubyBoolean;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject op_le19(ThreadContext context, IRubyObject other) {
        return this.op_le(context, other);
    }

    /*
     * Enabled aggressive block sorting
     */
    @JRubyMethod(name={"<="})
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        RubyBoolean rubyBoolean;
        if (other instanceof RubyString) {
            RubyString otherStr = (RubyString)other;
            if (this.cmpIsBuiltin(context)) {
                rubyBoolean = Convert.asBoolean(context, this.op_cmp(otherStr) <= 0);
                return rubyBoolean;
            }
        }
        rubyBoolean = RubyComparable.op_le(context, this, other);
        return rubyBoolean;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject op_lt19(ThreadContext context, IRubyObject other) {
        return this.op_lt(context, other);
    }

    /*
     * Enabled aggressive block sorting
     */
    @JRubyMethod(name={"<"})
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        RubyBoolean rubyBoolean;
        if (other instanceof RubyString) {
            RubyString otherStr = (RubyString)other;
            if (this.cmpIsBuiltin(context)) {
                rubyBoolean = Convert.asBoolean(context, this.op_cmp(otherStr) < 0);
                return rubyBoolean;
            }
        }
        rubyBoolean = RubyComparable.op_lt(context, RubyString.sites((ThreadContext)context).cmp, this, other);
        return rubyBoolean;
    }

    private boolean cmpIsBuiltin(ThreadContext context) {
        return RubyString.sites((ThreadContext)context).cmp.isBuiltin(this);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject str_eql_p19(ThreadContext context, IRubyObject other) {
        return this.str_eql_p(context, other);
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject str_eql_p(ThreadContext context, IRubyObject other) {
        RubyString otherStr;
        return Convert.asBoolean(context, other instanceof RubyString && StringSupport.areComparable(this, otherStr = (RubyString)other) && this.value.equal(otherStr.value));
    }

    private int caseMap(ThreadContext context, int flags2, Encoding enc) {
        IntHolder flagsP = new IntHolder();
        flagsP.value = flags2;
        if ((flags2 & 0x400000) != 0) {
            StringSupport.asciiOnlyCaseMap(context, this.value, flagsP);
        } else {
            this.value = StringSupport.caseMap(context, this.value, flagsP, enc);
        }
        return flagsP.value;
    }

    @JRubyMethod(name={"upcase"})
    public RubyString upcase(ThreadContext context) {
        RubyString str = Create.dupString(context, this);
        str.upcase_bang(context);
        return str;
    }

    @JRubyMethod(name={"upcase"})
    public RubyString upcase(ThreadContext context, IRubyObject arg2) {
        RubyString str = Create.dupString(context, this);
        str.upcase_bang(context, arg2);
        return str;
    }

    @JRubyMethod(name={"upcase"})
    public RubyString upcase(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        RubyString str = Create.dupString(context, this);
        str.upcase_bang(context, arg0, arg1);
        return str;
    }

    @JRubyMethod(name={"upcase!"})
    public IRubyObject upcase_bang(ThreadContext context) {
        return this.upcase_bang(context, 8192);
    }

    @JRubyMethod(name={"upcase!"})
    public IRubyObject upcase_bang(ThreadContext context, IRubyObject arg2) {
        return this.upcase_bang(context, StringSupport.checkCaseMapOptions(context, arg2, 8192));
    }

    @JRubyMethod(name={"upcase!"})
    public IRubyObject upcase_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.upcase_bang(context, StringSupport.checkCaseMapOptions(context, arg0, arg1, 8192));
    }

    private IRubyObject upcase_bang(ThreadContext context, int flags2) {
        this.modifyAndKeepCodeRange();
        Encoding enc = this.checkDummyEncoding();
        if ((flags2 & 0x400000) != 0 && (enc.isUTF8() || enc.maxLength() == 1) || (flags2 & 0x100000) == 0 && this.getCodeRange() == 16) {
            int s2;
            int end2 = s2 + this.value.getRealSize();
            byte[] bytes2 = this.value.getUnsafeBytes();
            for (s2 = this.value.getBegin(); s2 < end2; ++s2) {
                int c = bytes2[s2] & 0xFF;
                if (!Encoding.isAscii(c) || 97 > c || c > 122) continue;
                bytes2[s2] = (byte)(65 + (c - 97));
                flags2 |= 0x40000;
            }
        } else if (((flags2 = this.caseMap(context, flags2, enc)) & 0x40000) != 0) {
            this.clearCodeRange();
        }
        return (flags2 & 0x40000) != 0 ? this : context.nil;
    }

    @JRubyMethod(name={"downcase"})
    public RubyString downcase(ThreadContext context) {
        RubyString str = Create.dupString(context, this);
        str.downcase_bang(context);
        return str;
    }

    @JRubyMethod(name={"downcase"})
    public RubyString downcase(ThreadContext context, IRubyObject arg2) {
        RubyString str = Create.dupString(context, this);
        str.downcase_bang(context, arg2);
        return str;
    }

    @JRubyMethod(name={"downcase"})
    public RubyString downcase(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        RubyString str = Create.dupString(context, this);
        str.downcase_bang(context, arg0, arg1);
        return str;
    }

    @JRubyMethod(name={"downcase!"})
    public IRubyObject downcase_bang(ThreadContext context) {
        return this.downcase_bang(context, 16384);
    }

    @JRubyMethod(name={"downcase!"})
    public IRubyObject downcase_bang(ThreadContext context, IRubyObject arg2) {
        return this.downcase_bang(context, StringSupport.checkCaseMapOptions(context, arg2, 16384));
    }

    @JRubyMethod(name={"downcase!"})
    public IRubyObject downcase_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.downcase_bang(context, StringSupport.checkCaseMapOptions(context, arg0, arg1, 16384));
    }

    private IRubyObject downcase_bang(ThreadContext context, int flags2) {
        this.modifyAndKeepCodeRange();
        Encoding enc = this.checkDummyEncoding();
        if ((flags2 & 0x400000) != 0 && (enc.isUTF8() || enc.maxLength() == 1) || (flags2 & 0x100000) == 0 && this.getCodeRange() == 16) {
            int s2;
            int end2 = s2 + this.value.getRealSize();
            byte[] bytes2 = this.value.getUnsafeBytes();
            for (s2 = this.value.getBegin(); s2 < end2; ++s2) {
                int c = bytes2[s2] & 0xFF;
                if (!Encoding.isAscii(c) || 65 > c || c > 90) continue;
                bytes2[s2] = (byte)(97 + (c - 65));
                flags2 |= 0x40000;
            }
        } else if (((flags2 = this.caseMap(context, flags2, enc)) & 0x40000) != 0) {
            this.clearCodeRange();
        }
        return (flags2 & 0x40000) != 0 ? this : context.nil;
    }

    @JRubyMethod(name={"swapcase"})
    public RubyString swapcase(ThreadContext context) {
        RubyString str = Create.dupString(context, this);
        str.swapcase_bang(context);
        return str;
    }

    @JRubyMethod(name={"swapcase"})
    public RubyString swapcase(ThreadContext context, IRubyObject arg2) {
        RubyString str = Create.dupString(context, this);
        str.swapcase_bang(context, arg2);
        return str;
    }

    @JRubyMethod(name={"swapcase"})
    public RubyString swapcase(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        RubyString str = Create.dupString(context, this);
        str.swapcase_bang(context, arg0, arg1);
        return str;
    }

    @JRubyMethod(name={"swapcase!"})
    public IRubyObject swapcase_bang(ThreadContext context) {
        return this.swapcase_bang(context, 24576);
    }

    @JRubyMethod(name={"swapcase!"})
    public IRubyObject swapcase_bang(ThreadContext context, IRubyObject arg2) {
        return this.swapcase_bang(context, StringSupport.checkCaseMapOptions(context, arg2, 24576));
    }

    @JRubyMethod(name={"swapcase!"})
    public IRubyObject swapcase_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.swapcase_bang(context, StringSupport.checkCaseMapOptions(context, arg0, arg1, 24576));
    }

    private IRubyObject swapcase_bang(ThreadContext context, int flags2) {
        this.modifyAndKeepCodeRange();
        flags2 = this.caseMap(context, flags2, this.checkDummyEncoding());
        if ((flags2 & 0x40000) != 0) {
            this.clearCodeRange();
            return this;
        }
        return context.nil;
    }

    @JRubyMethod(name={"capitalize"})
    public RubyString capitalize(ThreadContext context) {
        RubyString str = Create.dupString(context, this);
        str.capitalize_bang(context);
        return str;
    }

    @JRubyMethod(name={"capitalize"})
    public RubyString capitalize(ThreadContext context, IRubyObject arg2) {
        RubyString str = Create.dupString(context, this);
        str.capitalize_bang(context, arg2);
        return str;
    }

    @JRubyMethod(name={"capitalize"})
    public RubyString capitalize(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        RubyString str = Create.dupString(context, this);
        str.capitalize_bang(context, arg0, arg1);
        return str;
    }

    @JRubyMethod(name={"capitalize!"})
    public IRubyObject capitalize_bang(ThreadContext context) {
        return this.capitalize_bang(context, 40960);
    }

    @JRubyMethod(name={"capitalize!"})
    public IRubyObject capitalize_bang(ThreadContext context, IRubyObject arg2) {
        return this.capitalize_bang(context, StringSupport.checkCaseMapOptions(context, arg2, 40960));
    }

    @JRubyMethod(name={"capitalize!"})
    public IRubyObject capitalize_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.capitalize_bang(context, StringSupport.checkCaseMapOptions(context, arg0, arg1, 40960));
    }

    private IRubyObject capitalize_bang(ThreadContext context, int flags2) {
        this.modifyAndKeepCodeRange();
        Encoding enc = this.checkDummyEncoding();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return context.nil;
        }
        if (((flags2 = this.caseMap(context, flags2, enc)) & 0x40000) != 0) {
            this.clearCodeRange();
            return this;
        }
        return context.nil;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject dump() {
        return this.dump(this.getCurrentContext());
    }

    @JRubyMethod(name={"dump"})
    public IRubyObject dump(ThreadContext context) {
        ByteList outBytes = StringSupport.dumpCommon(context.runtime, this.value);
        RubyString result2 = Create.newString(context, outBytes);
        Encoding enc = this.value.getEncoding();
        if (!enc.isAsciiCompatible()) {
            result2.cat(".force_encoding(\"".getBytes());
            result2.cat(enc.getName());
            result2.cat((byte)34).cat((byte)41);
            enc = ASCII;
        }
        result2.associateEncoding(enc);
        result2.setCodeRange(16);
        return result2;
    }

    @JRubyMethod(name={"undump"})
    public IRubyObject undump(ThreadContext context) {
        RubyString str = this;
        ByteList strByteList = str.value;
        byte[] sBytes = strByteList.unsafeBytes();
        int[] s2 = new int[]{strByteList.begin()};
        int sLen = strByteList.realSize();
        int s_end = s2[0] + strByteList.realSize();
        Encoding[] enc = new Encoding[]{str.getEncoding()};
        RubyString undumped = RubyString.newString(context.runtime, sBytes, s2[0], 0, enc[0]);
        boolean[] utf8 = new boolean[]{false};
        boolean[] binary = new boolean[]{false};
        this.verifyAsciiCompatible();
        this.scanForCodeRange();
        if (!this.isAsciiOnly()) {
            throw Error.runtimeError(context, "non-ASCII character detected");
        }
        if (this.hasNul()) {
            throw Error.runtimeError(context, "string contains null byte");
        }
        if (sLen < 2) {
            return RubyString.invalidFormat(context);
        }
        if (sBytes[s2[0]] != 34) {
            return RubyString.invalidFormat(context);
        }
        s2[0] = s2[0] + 1;
        while (true) {
            if (s2[0] >= s_end) {
                throw Error.runtimeError(context, "unterminated dumped string");
            }
            if (sBytes[s2[0]] == 34) {
                s2[0] = s2[0] + 1;
                if (s2[0] == s_end) break;
                if (utf8[0]) {
                    throw Error.runtimeError(context, "dumped string contained Unicode escape but used force_encoding");
                }
                int size2 = FORCE_ENCODING_BYTES.length;
                if (s_end - s2[0] <= size2) {
                    return RubyString.invalidFormat(context);
                }
                if (ByteList.memcmp(sBytes, s2[0], FORCE_ENCODING_BYTES, 0, size2) != 0) {
                    return RubyString.invalidFormat(context);
                }
                s2[0] = s2[0] + size2;
                int encname = s2[0];
                s2[0] = Helpers.memchr(sBytes, s2[0], 34, s_end - s2[0]);
                size2 = s2[0] - encname;
                if (s2[0] == -1) {
                    return RubyString.invalidFormat(context);
                }
                if (s_end - s2[0] != 2) {
                    return RubyString.invalidFormat(context);
                }
                if (sBytes[s2[0]] != 34 || sBytes[s2[0] + 1] != 41) {
                    return RubyString.invalidFormat(context);
                }
                Encoding enc2 = Access.encodingService(context).findEncodingNoError(new ByteList(sBytes, encname, size2));
                if (enc2 == null) {
                    throw Error.runtimeError(context, "dumped string has unknown encoding name");
                }
                undumped.setEncoding(enc2);
                break;
            }
            if (sBytes[s2[0]] == 92) {
                s2[0] = s2[0] + 1;
                if (s2[0] >= s_end) {
                    throw Error.runtimeError(context, "invalid escape");
                }
                undumped.undumpAfterBackslash(context, sBytes, s2, s_end, enc, utf8, binary);
                continue;
            }
            int n = s2[0];
            s2[0] = n + 1;
            undumped.cat(sBytes, n, 1);
        }
        return undumped;
    }

    private static IRubyObject invalidFormat(ThreadContext context) {
        throw Error.runtimeError(context, "invalid dumped string; not wrapped with '\"' nor '\"...\".force_encoding(\"...\")' form");
    }

    private void undumpAfterBackslash(ThreadContext context, byte[] ssBytes, int[] ss, int s_end, Encoding[] penc, boolean[] utf8, boolean[] binary) {
        int s2 = ss[0];
        int[] hexlen = new int[]{0};
        byte[] buf = new byte[6];
        UTF8Encoding encUtf8 = null;
        block0 : switch (ssBytes[s2]) {
            case 34: 
            case 35: 
            case 92: {
                this.cat(ssBytes, s2, 1);
                break;
            }
            case 97: 
            case 98: 
            case 101: 
            case 102: 
            case 110: 
            case 114: 
            case 116: 
            case 118: {
                buf[0] = RubyString.unescapeAscii(ssBytes[s2]);
                this.cat(buf, 0, 1);
                ++s2;
                break;
            }
            case 117: {
                if (binary[0]) {
                    throw Error.runtimeError(context, "hex escape and Unicode escape are mixed");
                }
                utf8[0] = true;
                if (++s2 >= s_end) {
                    throw Error.runtimeError(context, "invalid Unicode escape");
                }
                if (encUtf8 == null) {
                    encUtf8 = UTF8Encoding.INSTANCE;
                }
                if (penc[0] != encUtf8) {
                    penc[0] = encUtf8;
                    this.setEncoding(encUtf8);
                }
                if (ssBytes[s2] == 123) {
                    ++s2;
                    while (true) {
                        if (s2 >= s_end) {
                            throw Error.runtimeError(context, "unterminated Unicode escape");
                        }
                        if (ssBytes[s2] == 125) {
                            ++s2;
                            break block0;
                        }
                        if (Character.isSpaceChar(ssBytes[s2])) {
                            ++s2;
                            continue;
                        }
                        long c = RubyString.scanHex(ssBytes, s2, s_end - s2, hexlen);
                        if (hexlen[0] == 0 || hexlen[0] > 6) {
                            throw Error.runtimeError(context, "invalid Unicode escape");
                        }
                        if (c > 0x10FFFFL) {
                            throw Error.runtimeError(context, "invalid Unicode codepoint (too large)");
                        }
                        if (55296L <= c && c <= 57343L) {
                            throw Error.runtimeError(context, "invalid Unicode codepoint");
                        }
                        int codelen = EncodingUtils.encMbcput((int)c, buf, 0, penc[0]);
                        this.cat(buf, 0, codelen);
                        s2 += hexlen[0];
                    }
                }
                long c = RubyString.scanHex(ssBytes, s2, 4, hexlen);
                if (hexlen[0] != 4) {
                    throw Error.runtimeError(context, "invalid Unicode escape");
                }
                if (55296L <= c && c <= 57343L) {
                    throw Error.runtimeError(context, "invalid Unicode codepoint");
                }
                int codelen = EncodingUtils.encMbcput((int)c, buf, 0, penc[0]);
                this.cat(buf, 0, codelen);
                s2 += hexlen[0];
                break;
            }
            case 120: {
                if (utf8[0]) {
                    throw Error.runtimeError(context, "hex escape and Unicode escape are mixed");
                }
                binary[0] = true;
                if (++s2 >= s_end) {
                    throw Error.runtimeError(context, "invalid hex escape");
                }
                buf[0] = (byte)RubyString.scanHex(ssBytes, s2, 2, hexlen);
                if (hexlen[0] != 2) {
                    throw Error.runtimeError(context, "invalid hex escape");
                }
                this.cat(buf, 0, 1);
                s2 += hexlen[0];
                break;
            }
            default: {
                this.cat(ssBytes, s2 - 1, 2);
                ++s2;
            }
        }
        ss[0] = ++s2;
    }

    private static long scanHex(byte[] bytes2, int start2, int len, int[] retlen) {
        int tmp;
        int s2;
        long retval = 0L;
        for (s2 = start2; len-- > 0 && s2 < bytes2.length && (tmp = Helpers.memchr(hexdigit, 0, (int)bytes2[s2], hexdigit.length)) != -1; ++s2) {
            retval <<= 4;
            retval |= (long)(tmp & 0xF);
        }
        retlen[0] = s2 - start2;
        return retval;
    }

    private static byte unescapeAscii(byte c) {
        switch (c) {
            case 110: {
                return 10;
            }
            case 114: {
                return 13;
            }
            case 116: {
                return 9;
            }
            case 102: {
                return 12;
            }
            case 118: {
                return 11;
            }
            case 98: {
                return 8;
            }
            case 97: {
                return 7;
            }
            case 101: {
                return 27;
            }
        }
        return -1;
    }

    @JRubyMethod(name={"insert"})
    public IRubyObject insert(ThreadContext context, IRubyObject indexArg, IRubyObject arg2) {
        RubyString str = arg2.convertToString();
        int index2 = Convert.toInt(context, indexArg);
        if (index2 == -1) {
            this.modifyCheck();
            return this.catWithCodeRange(str);
        }
        if (index2 < 0) {
            ++index2;
        }
        StringSupport.strUpdate(context, index2, 0, this, str);
        return this;
    }

    private int checkIndexForRef(ThreadContext context, int beg, int len) {
        if (beg >= len) {
            this.raiseIndexOutOfString(context, beg);
        }
        if (beg < 0) {
            if (-beg > len) {
                this.raiseIndexOutOfString(context, beg);
            }
            beg += len;
        }
        return beg;
    }

    private int checkLength(ThreadContext context, int len) {
        if (len < 0) {
            throw Error.indexError(context, "negative length " + len);
        }
        return len;
    }

    private void raiseIndexOutOfString(ThreadContext context, int index2) {
        throw Error.indexError(context, "index " + index2 + " out of string");
    }

    @Override
    @Deprecated(since="10.0.0.0")
    public RubyString inspect() {
        return (RubyString)super.inspect();
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        return RubyString.inspect(context, this.value);
    }

    final RubyString inspect(Ruby runtime2) {
        return RubyString.inspect(runtime2.getCurrentContext(), this.value);
    }

    public static IRubyObject rbStrEscape(ThreadContext context, RubyString str) {
        Encoding enc = str.getEncoding();
        ByteList strBL = str.getByteList();
        byte[] pBytes = strBL.unsafeBytes();
        int p2 = strBL.begin();
        int pend = p2 + strBL.realSize();
        int prev = p2;
        RubyString result2 = Create.newEmptyString(context);
        boolean unicode_p = enc.isUnicode();
        boolean asciicompat = enc.isAsciiCompatible();
        while (p2 < pend) {
            int n = enc.length(pBytes, p2, pend);
            if (!StringSupport.MBCLEN_CHARFOUND_P(n)) {
                if (p2 > prev) {
                    result2.cat(pBytes, prev, p2 - prev);
                }
                if (pend < p2 + (n = enc.minLength())) {
                    n = pend - p2;
                }
                while (n-- > 0) {
                    result2.modify();
                    Sprintf.sprintf(context.runtime, result2.getByteList(), (CharSequence)"\\x%02X", pBytes[p2] & 0xFF);
                    prev = ++p2;
                }
                continue;
            }
            n = StringSupport.MBCLEN_CHARFOUND_LEN(n);
            int c = enc.mbcToCode(pBytes, p2, pend);
            p2 += n;
            int cc = switch (c) {
                case 10 -> 110;
                case 13 -> 114;
                case 9 -> 116;
                case 12 -> 102;
                case 11 -> 118;
                case 8 -> 98;
                case 7 -> 97;
                case 27 -> 101;
                default -> 0;
            };
            if (cc != 0) {
                if (p2 - n > prev) {
                    result2.cat(pBytes, prev, p2 - n - prev);
                }
                result2.cat(92);
                result2.cat((byte)cc);
                prev = p2;
                continue;
            }
            if (asciicompat && Encoding.isAscii(c) && c < 127 && c > 31) continue;
            if (p2 - n > prev) {
                result2.cat(pBytes, prev, p2 - n - prev);
            }
            result2.modify();
            Sprintf.sprintf(context.runtime, result2.getByteList(), (CharSequence)StringSupport.escapedCharFormat(c, unicode_p), (long)c & 0xFFFFFFFFL);
            prev = p2;
        }
        if (p2 > prev) {
            result2.cat(pBytes, prev, p2 - prev);
        }
        result2.setEncodingAndCodeRange(USASCIIEncoding.INSTANCE, 16);
        return result2;
    }

    @Deprecated(since="10.0.0.0")
    public static RubyString inspect(Ruby runtime2, ByteList byteList) {
        return RubyString.inspect(runtime2.getCurrentContext(), byteList);
    }

    public static RubyString inspect(ThreadContext context, ByteList byteList) {
        Encoding enc = byteList.getEncoding();
        byte[] bytes2 = byteList.getUnsafeBytes();
        int p2 = byteList.getBegin();
        int end2 = p2 + byteList.getRealSize();
        RubyString result2 = Create.newString(context, new ByteList(end2 - p2));
        Encoding resultEnc = context.runtime.getDefaultInternalEncoding();
        boolean isUnicode = enc.isUnicode();
        boolean asciiCompat = enc.isAsciiCompatible();
        if (resultEnc == null) {
            resultEnc = context.runtime.getDefaultExternalEncoding();
        }
        if (!resultEnc.isAsciiCompatible()) {
            resultEnc = USASCIIEncoding.INSTANCE;
        }
        result2.associateEncoding(resultEnc);
        result2.cat(34);
        int prev = p2;
        Encoding actEnc = EncodingUtils.getActualEncoding(enc, byteList);
        if (actEnc != enc) {
            enc = actEnc;
            if (isUnicode) {
                isUnicode = enc instanceof UnicodeEncoding;
            }
        }
        while (p2 < end2) {
            int cc;
            int n = StringSupport.preciseLength(enc, bytes2, p2, end2);
            if (!StringSupport.MBCLEN_CHARFOUND_P(n)) {
                if (p2 > prev) {
                    result2.cat(bytes2, prev, p2 - prev);
                }
                if (end2 < p2 + (n = enc.minLength())) {
                    n = end2 - p2;
                }
                while (n-- > 0) {
                    result2.modifyExpand(result2.size() + 4);
                    Sprintf.sprintf(context.runtime, result2.getByteList(), (CharSequence)"\\x%02X", bytes2[p2] & 0xFF);
                    prev = ++p2;
                }
                continue;
            }
            n = StringSupport.MBCLEN_CHARFOUND_LEN(n);
            int c = enc.mbcToCode(bytes2, p2, end2);
            if ((asciiCompat || isUnicode) && (c == 34 || c == 92 || c == 35 && (p2 += n) < end2 && StringSupport.MBCLEN_CHARFOUND_P(StringSupport.preciseLength(enc, bytes2, p2, end2)) && ((cc = StringSupport.codePoint(context, enc, bytes2, p2, end2)) == 36 || cc == 64 || cc == 123))) {
                if (p2 - n > prev) {
                    result2.cat(bytes2, prev, p2 - n - prev);
                }
                result2.cat(92);
                if (asciiCompat || enc == resultEnc) {
                    prev = p2 - n;
                    continue;
                }
            }
            switch (c) {
                case 10: {
                    cc = 110;
                    break;
                }
                case 13: {
                    cc = 114;
                    break;
                }
                case 9: {
                    cc = 116;
                    break;
                }
                case 12: {
                    cc = 102;
                    break;
                }
                case 11: {
                    cc = 118;
                    break;
                }
                case 8: {
                    cc = 98;
                    break;
                }
                case 7: {
                    cc = 97;
                    break;
                }
                case 27: {
                    cc = 101;
                    break;
                }
                default: {
                    cc = 0;
                }
            }
            if (cc != 0) {
                if (p2 - n > prev) {
                    result2.cat(bytes2, prev, p2 - n - prev);
                }
                result2.cat(92);
                result2.cat(cc);
                prev = p2;
                continue;
            }
            if (enc == resultEnc && enc.isPrint(c) || asciiCompat && c < 128 && c > 0 && enc.isPrint(c)) continue;
            if (p2 - n > prev) {
                result2.cat(bytes2, prev, p2 - n - prev);
            }
            Sprintf.sprintf(context.runtime, result2.getByteList(), (CharSequence)StringSupport.escapedCharFormat(c, isUnicode), (long)c & 0xFFFFFFFFL);
            prev = p2;
        }
        if (p2 > prev) {
            result2.cat(bytes2, prev, p2 - prev);
        }
        result2.cat(34);
        return result2;
    }

    public int size() {
        return this.value.getRealSize();
    }

    @JRubyMethod(name={"length", "size"})
    public RubyFixnum rubyLength(ThreadContext context) {
        return Convert.asFixnum(context, this.strLength());
    }

    @JRubyMethod(name={"bytesize"})
    public RubyFixnum bytesize(ThreadContext context) {
        return Convert.asFixnum(context, this.value.getRealSize());
    }

    @Deprecated(since="10.0.0.0")
    public RubyFixnum bytesize() {
        return this.bytesize(this.getCurrentContext());
    }

    @Override
    public int length() {
        return this.strLength();
    }

    @Override
    public char charAt(int offset2) {
        int length2 = this.value.getRealSize();
        if (length2 < 1) {
            throw new StringIndexOutOfBoundsException(offset2);
        }
        Encoding enc = this.value.getEncoding();
        if (this.singleByteOptimizable(enc)) {
            if (offset2 >= length2 || offset2 < 0) {
                throw new StringIndexOutOfBoundsException(offset2);
            }
            return (char)this.value.get(offset2);
        }
        return this.multibyteCharAt(enc, offset2, length2);
    }

    @Override
    public CharSequence subSequence(int start2, int end2) {
        IRubyObject subStr = this.substrEnc(this.getRuntime().getCurrentContext(), start2, end2 - start2);
        if (subStr.isNil()) {
            throw new StringIndexOutOfBoundsException("String index out of range: <" + start2 + ", " + end2 + ")");
        }
        return (RubyString)subStr;
    }

    private static IRubyObject byteSize(ThreadContext context, RubyString recv2, IRubyObject[] args2) {
        return recv2.bytesize(context);
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p(ThreadContext context) {
        return Convert.asBoolean(context, this.isEmpty());
    }

    @Override
    @JRubyAPI
    public boolean isEmpty() {
        return this.value.length() == 0;
    }

    @Override
    public void appendIntoString(RubyString target2) {
        target2.catWithCodeRange(this.getByteList(), this.getCodeRange());
    }

    public RubyString append(IRubyObject other, Function<IRubyObject, RubyString> convert2) {
        if (other instanceof Appendable) {
            Appendable appendable = (Appendable)((Object)other);
            appendable.appendIntoString(this);
        } else {
            this.catWithCodeRange(convert2.apply(other));
        }
        return this;
    }

    public RubyString append(IRubyObject other) {
        return this.append(other, o -> o.convertToString());
    }

    public RubyString append(RubyString other) {
        return this.catWithCodeRange(other);
    }

    @Deprecated(since="9.4.4.0")
    public RubyString append19(IRubyObject other) {
        return this.append(other);
    }

    public RubyString appendAsDynamicString(IRubyObject other) {
        return this.append(other, o -> o.asString());
    }

    public RubyString appendAsStringOrAny(IRubyObject other) {
        return this.append(other, o -> (RubyString)o.anyToString());
    }

    final RubyString append19(RubyString other) {
        this.modifyCheck();
        return this.catWithCodeRange(other);
    }

    @JRubyMethod(name={"<<"})
    public RubyString concatSingle(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            RubyString otherStr = (RubyString)other;
            return this.append(otherStr);
        }
        if (other instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)other;
            if (fixnum.value < 0L) {
                throw Error.rangeError(context, fixnum.value + " out of char range");
            }
            return this.concatNumeric(context, (int)(fixnum.value & 0xFFFFFFFFFFFFFFFFL));
        }
        if (other instanceof RubyBignum) {
            RubyBignum bignum = (RubyBignum)other;
            if (bignum.signum(context) < 0) {
                throw Error.rangeError(context, "negative string size (or size too big)");
            }
            return this.concatNumeric(context, bignum.asInt(context));
        }
        if (other instanceof RubyFloat) {
            RubyFloat flote = (RubyFloat)other;
            this.modifyCheck();
            return this.catWithCodeRange((RubyString)flote.to_s(context));
        }
        if (other instanceof RubySymbol) {
            throw Error.typeError(context, "can't convert Symbol into String");
        }
        return this.append(other.convertToString());
    }

    @JRubyMethod(name={"concat"})
    public RubyString concat(ThreadContext context, IRubyObject obj) {
        return this.concatSingle(context, obj);
    }

    @JRubyMethod(name={"concat"}, rest=true)
    public RubyString concat(ThreadContext context, IRubyObject[] objs) {
        this.modifyCheck();
        if (objs.length > 0) {
            RubyString tmp = RubyString.newStringLight(context.runtime, objs.length, this.getEncoding());
            for (IRubyObject obj : objs) {
                tmp.concatSingle(context, obj);
            }
            this.catWithCodeRange(tmp);
        }
        return this;
    }

    public RubyString concat(IRubyObject other) {
        return this.concat(this.metaClass.runtime.getCurrentContext(), other);
    }

    private RubyString concatNumeric(ThreadContext context, int c) {
        int cl;
        Encoding enc = this.value.getEncoding();
        try {
            cl = StringSupport.codeLength(enc, c);
            if (cl <= 0) {
                throw Error.rangeError(context, c + " out of char range or invalid code point");
            }
            this.modifyExpand(this.value.getRealSize() + cl);
            if (enc == USASCIIEncoding.INSTANCE) {
                if (c > 255) {
                    throw Error.rangeError(context, c + " out of char range");
                }
                if (c > 121) {
                    this.value.setEncoding(ASCIIEncoding.INSTANCE);
                    enc = this.value.getEncoding();
                }
            }
            enc.codeToMbc(c, this.value.getUnsafeBytes(), this.value.getBegin() + this.value.getRealSize());
        }
        catch (EncodingException e) {
            throw Error.rangeError(context, c + " out of char range");
        }
        this.value.setRealSize(this.value.getRealSize() + cl);
        return this;
    }

    @JRubyMethod
    public IRubyObject prepend(ThreadContext context, IRubyObject other) {
        RubyString rubyString = other.convertToString();
        return this.replace(context, rubyString.op_plus(context, this));
    }

    @JRubyMethod(rest=true)
    public IRubyObject prepend(ThreadContext context, IRubyObject[] objs) {
        this.modifyCheck();
        if (objs.length > 0) {
            RubyString tmp = RubyString.newStringLight(context.runtime, objs.length, this.getEncoding());
            for (IRubyObject obj : objs) {
                tmp.concat(context, obj);
            }
            StringSupport.strUpdate(context, 0, 0, this, tmp);
        }
        return this;
    }

    public final RubyString prepend(byte ch) {
        this.modify(this.value.getRealSize() + 1);
        int beg = this.value.getBegin();
        if (beg > 0) {
            this.value.getUnsafeBytes()[beg - 1] = ch;
            this.value.setBegin(beg - 1);
            return this;
        }
        this.value.prepend(ch);
        return this;
    }

    public final RubyString prepend(int ch) {
        return this.prepend((byte)ch);
    }

    @JRubyMethod(name={"crypt"})
    public RubyString crypt(ThreadContext context, IRubyObject other) {
        Encoding ascii8bit = Access.encodingService(context).getAscii8bitEncoding();
        RubyString otherStr = Create.dupString(context, other.convertToString());
        otherStr.modify();
        otherStr.associateEncoding(ascii8bit);
        ByteList otherBL = otherStr.getByteList();
        if (otherBL.length() < 2) {
            throw Error.argumentError(context, "salt too short (need >=2 bytes)");
        }
        POSIX posix = context.runtime.getPosix();
        byte[] keyBytes = Arrays.copyOfRange(this.value.unsafeBytes(), this.value.begin(), this.value.begin() + this.value.realSize());
        byte[] saltBytes = Arrays.copyOfRange(otherBL.unsafeBytes(), otherBL.begin(), otherBL.begin() + otherBL.realSize());
        if (saltBytes[0] == 0 || saltBytes[1] == 0) {
            throw Error.argumentError(context, "salt too short (need >=2 bytes)");
        }
        byte[] cryptedString = posix.crypt(keyBytes, saltBytes);
        if (cryptedString == null) {
            throw context.runtime.newErrnoFromInt(posix.errno());
        }
        RubyString result2 = RubyString.newStringNoCopy(context.runtime, cryptedString, 0, cryptedString.length - 1);
        result2.associateEncoding(ascii8bit);
        return result2;
    }

    public static RubyString stringValue(IRubyObject object) {
        return (RubyString)(object instanceof RubyString ? object : object.convertToString());
    }

    @JRubyMethod(name={"sub"}, writes={FrameField.BACKREF})
    public IRubyObject sub(ThreadContext context, IRubyObject arg0, Block block) {
        RubyString str = Create.dupString(context, this);
        str.sub_bang(context, arg0, block);
        return str;
    }

    @JRubyMethod(name={"sub"}, writes={FrameField.BACKREF})
    public IRubyObject sub(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyString str = Create.dupString(context, this);
        str.sub_bang(context, arg0, arg1, block);
        return str;
    }

    @JRubyMethod(name={"sub!"}, writes={FrameField.BACKREF})
    public IRubyObject sub_bang(ThreadContext context, IRubyObject arg0, Block block) {
        this.frozenCheck();
        if (!block.isGiven()) {
            throw Error.argumentError(context, 1, 2);
        }
        return this.subBangIter(context, arg0, null, block);
    }

    @JRubyMethod(name={"sub!"}, writes={FrameField.BACKREF})
    public IRubyObject sub_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        IRubyObject hash2 = TypeConverter.convertToTypeWithCheck(context, arg1, Access.hashClass(context), RubyString.sites((ThreadContext)context).to_hash_checked);
        this.frozenCheck();
        return hash2 == context.nil ? this.subBangNoIter(context, arg0, arg1.convertToString()) : this.subBangIter(context, arg0, (RubyHash)hash2, block);
    }

    private IRubyObject subBangIter(ThreadContext context, IRubyObject arg0, RubyHash hash2, Block block) {
        IRubyObject iRubyObject;
        if (arg0 instanceof RubyRegexp) {
            RubyRegexp regexp2 = (RubyRegexp)arg0;
            iRubyObject = this.subBangIter(context, regexp2, hash2, block);
        } else {
            iRubyObject = this.subBangIter(context, RubyString.getStringForPattern(context, arg0), hash2, block);
        }
        return iRubyObject;
    }

    private IRubyObject subBangIter(ThreadContext context, RubyString pattern, RubyHash hash2, Block block) {
        int len = this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        Encoding enc = this.value.getEncoding();
        int mBeg = StringSupport.index(this.getByteList(), pattern.getByteList(), 0, this.checkEncoding(pattern));
        if (mBeg > -1) {
            int mLen = pattern.size();
            int mEnd = mBeg + mLen;
            RubyMatchData match2 = new RubyMatchData(context.runtime);
            match2.initMatchData(this, mBeg, pattern);
            context.setBackRef(match2);
            RubyString subStr = this.makeShared(context.runtime, mBeg, mLen);
            RubyString repl = hash2 == null ? RubyString.objAsString(context, block.yield(context, subStr)) : RubyString.objAsString(context, hash2.op_aref(context, subStr));
            this.modifyCheck(bytes2, len, enc);
            return this.subBangCommon(context, mBeg, mEnd, repl, repl.flags);
        }
        return context.clearBackRef();
    }

    private IRubyObject subBangIter(ThreadContext context, RubyRegexp regexp2, RubyHash hash2, Block block) {
        Regex pattern = regexp2.getPattern(context);
        Regex prepared = regexp2.preparePattern(context, this);
        int begin2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int range = begin2 + len;
        byte[] bytes2 = this.value.getUnsafeBytes();
        Encoding enc = this.value.getEncoding();
        Matcher matcher = prepared.matcher(bytes2, begin2, range);
        if (RubyRegexp.matcherSearch(context, matcher, begin2, range, 0) >= 0) {
            RubyString repl;
            int tuFlags;
            RubyMatchData match2 = RubyRegexp.createMatchData(context, this, matcher, pattern);
            match2.regexp = regexp2;
            context.setBackRef(match2);
            int mBeg = matcher.getBegin();
            int mEnd = matcher.getEnd();
            RubyString subStr = this.makeShared(context.runtime, mBeg, mEnd - mBeg);
            if (hash2 == null) {
                tuFlags = 0;
                repl = RubyString.objAsString(context, block.yield(context, subStr));
            } else {
                tuFlags = hash2.flags;
                repl = RubyString.objAsString(context, hash2.op_aref(context, subStr));
            }
            this.modifyCheck(bytes2, len, enc);
            return this.subBangCommon(context, mBeg, mEnd, repl, tuFlags | repl.flags);
        }
        return context.clearBackRef();
    }

    private IRubyObject subBangNoIter(ThreadContext context, IRubyObject arg0, RubyString repl) {
        if (arg0 instanceof RubyRegexp) {
            RubyRegexp regexp2 = (RubyRegexp)arg0;
            return this.subBangNoIter(context, regexp2, repl);
        }
        return this.subBangNoIter(context, RubyString.getStringForPattern(context, arg0), repl);
    }

    private IRubyObject subBangNoIter(ThreadContext context, RubyString pattern, RubyString repl) {
        int mBeg = StringSupport.index(this.getByteList(), pattern.getByteList(), 0, this.checkEncoding(pattern));
        if (mBeg > -1) {
            int mEnd = mBeg + pattern.size();
            RubyMatchData match2 = new RubyMatchData(context.runtime);
            match2.initMatchData(this, mBeg, pattern);
            context.setBackRef(match2);
            repl = RubyRegexp.regsub(context, repl, this, REPL_MOCK_REGEX, null, mBeg, mEnd);
            return this.subBangCommon(context, mBeg, mEnd, repl, repl.flags);
        }
        return context.clearBackRef();
    }

    private IRubyObject subBangNoIter(ThreadContext context, RubyRegexp regexp2, RubyString repl) {
        RubyMatchData match2 = this.subBangMatch(context, regexp2, repl);
        if (match2 != null) {
            repl = RubyRegexp.regsub(context, repl, this, regexp2.pattern, match2.regs, match2.begin, match2.end);
            context.setBackRef(match2);
            return this.subBangCommon(context, match2.begin, match2.end, repl, repl.flags);
        }
        return context.clearBackRef();
    }

    public final IRubyObject subBangFast(ThreadContext context, RubyRegexp regexp2, RubyString repl) {
        RubyMatchData match2 = this.subBangMatch(context, regexp2, repl);
        if (match2 != null) {
            repl = RubyRegexp.regsub(context, repl, this, regexp2.pattern, match2.regs, match2.begin, match2.end);
            this.subBangCommon(context, match2.begin, match2.end, repl, repl.flags);
            return match2;
        }
        return context.nil;
    }

    private RubyMatchData subBangMatch(ThreadContext context, RubyRegexp regexp2, RubyString repl) {
        Regex pattern = regexp2.getPattern(context);
        Regex prepared = regexp2.preparePattern(context, this);
        int begin2 = this.value.getBegin();
        int range = begin2 + this.value.getRealSize();
        Matcher matcher = prepared.matcher(this.value.getUnsafeBytes(), begin2, range);
        if (RubyRegexp.matcherSearch(context, matcher, begin2, range, 0) >= 0) {
            RubyMatchData match2 = RubyRegexp.createMatchData(context, this, matcher, pattern);
            match2.regexp = regexp2;
            return match2;
        }
        return null;
    }

    private RubyString subBangCommon(ThreadContext context, int beg, int end2, RubyString repl, int tuFlags) {
        int plen;
        ByteList replValue;
        int replSize;
        Encoding enc = StringSupport.areCompatible(this, (CodeRangeable)repl);
        if (enc == null) {
            enc = this.subBangVerifyEncoding(context, repl, beg, end2);
        }
        if ((replSize = (replValue = repl.value).getRealSize()) > (plen = end2 - beg)) {
            this.modifyExpand(this.value.getRealSize() + replSize - plen);
        } else {
            this.modifyAndClearCodeRange();
        }
        ByteList value2 = this.value;
        int size2 = value2.getRealSize();
        this.associateEncoding(enc);
        int cr = this.getCodeRange();
        if (cr > 0 && cr < 48) {
            int cr2 = repl.getCodeRange();
            cr = cr2 == 48 || cr == 32 && cr2 == 16 ? 0 : cr2;
        }
        if (replSize != plen) {
            int src = value2.getBegin() + beg + plen;
            int dst = value2.getBegin() + beg + replSize;
            System.arraycopy(value2.getUnsafeBytes(), src, value2.getUnsafeBytes(), dst, size2 - beg - plen);
        }
        System.arraycopy(replValue.getUnsafeBytes(), replValue.getBegin(), value2.getUnsafeBytes(), value2.getBegin() + beg, replSize);
        value2.setRealSize(size2 + replSize - plen);
        this.setCodeRange(cr);
        return this;
    }

    private Encoding subBangVerifyEncoding(ThreadContext context, RubyString repl, int beg, int end2) {
        ByteList value2 = this.value;
        byte[] bytes2 = value2.getUnsafeBytes();
        int p2 = value2.getBegin();
        int len = value2.getRealSize();
        Encoding strEnc = value2.getEncoding();
        if (StringSupport.codeRangeScan(strEnc, bytes2, p2, beg) != 16 || StringSupport.codeRangeScan(strEnc, bytes2, p2 + end2, len - end2) != 16) {
            throw context.runtime.newEncodingCompatibilityError("incompatible character encodings " + String.valueOf(strEnc) + " and " + String.valueOf(repl.value.getEncoding()));
        }
        return repl.value.getEncoding();
    }

    @JRubyMethod(name={"gsub"}, writes={FrameField.BACKREF})
    public IRubyObject gsub(ThreadContext context, IRubyObject arg0, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "gsub", arg0);
        }
        return this.gsubCommon(context, block, null, null, arg0, false, 0);
    }

    @JRubyMethod(name={"gsub"}, writes={FrameField.BACKREF})
    public IRubyObject gsub(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.gsubImpl(context, arg0, arg1, block, false);
    }

    @JRubyMethod(name={"gsub!"}, writes={FrameField.BACKREF})
    public IRubyObject gsub_bang(ThreadContext context, IRubyObject arg0, Block block) {
        this.checkFrozen();
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "gsub!", arg0);
        }
        return this.gsubCommon(context, block, null, null, arg0, true, 0);
    }

    @JRubyMethod(name={"gsub!"}, writes={FrameField.BACKREF})
    public IRubyObject gsub_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        this.checkFrozen();
        return this.gsubImpl(context, arg0, arg1, block, true);
    }

    private IRubyObject gsubImpl(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block, boolean bang) {
        int tuFlags;
        RubyString str;
        RubyHash hash2;
        IRubyObject tryHash = TypeConverter.convertToTypeWithCheck(context, arg1, Access.hashClass(context), RubyString.sites((ThreadContext)context).to_hash_checked);
        if (tryHash == context.nil) {
            hash2 = null;
            str = arg1.convertToString();
            tuFlags = str.flags;
        } else {
            hash2 = (RubyHash)tryHash;
            str = null;
            tuFlags = hash2.flags;
        }
        return this.gsubCommon(context, block, str, hash2, arg0, bang, tuFlags);
    }

    public RubyString gsubFast(ThreadContext context, RubyRegexp regexp2, RubyString repl, Block block) {
        return (RubyString)this.gsubCommon(context, block, repl, null, regexp2, false, repl.flags, false);
    }

    private IRubyObject gsubCommon(ThreadContext context, Block block, RubyString repl, RubyHash hash2, IRubyObject arg0, boolean bang, int tuFlags) {
        return this.gsubCommon(context, block, repl, hash2, arg0, bang, tuFlags, true);
    }

    private IRubyObject gsubCommon(ThreadContext context, Block block, RubyString repl, RubyHash hash2, IRubyObject arg0, boolean bang, int tuFlags, boolean useBackref) {
        if (arg0 instanceof RubyRegexp) {
            RubyRegexp regexp2 = (RubyRegexp)arg0;
            return this.gsubCommon(context, block, repl, hash2, regexp2, bang, tuFlags, useBackref);
        }
        return this.gsubCommon(context, block, repl, hash2, RubyString.getStringForPattern(context, arg0), bang, tuFlags, useBackref);
    }

    private IRubyObject gsubCommon(ThreadContext context, Block block, RubyString repl, RubyHash hash2, RubyString pattern, boolean bang, int tuFlags, boolean useBackref) {
        int begz;
        byte[] spBytes = this.value.getUnsafeBytes();
        int spBeg = this.value.getBegin();
        int spLen = this.value.getRealSize();
        int patternLen = pattern.size();
        Encoding patternEnc = this.checkEncoding(pattern);
        int beg = StringSupport.index(this.getByteList(), pattern.getByteList(), 0, patternEnc);
        if (beg < 0) {
            if (useBackref) {
                context.clearBackRef();
            }
            return bang ? context.nil : Create.dupString(context, this);
        }
        int offset2 = 0;
        int cp = spBeg;
        RubyString dest = Create.newString(context, new ByteList(spLen + 30));
        Encoding str_enc = this.value.getEncoding();
        dest.setEncoding(str_enc);
        dest.setCodeRange(str_enc.isAsciiCompatible() ? 16 : 32);
        RubyMatchData match2 = null;
        do {
            RubyString val;
            begz = beg;
            int endz = beg + patternLen;
            if (repl != null) {
                val = RubyRegexp.regsub(context, repl, this, REPL_MOCK_REGEX, null, begz, endz);
            } else {
                if (hash2 != null) {
                    val = RubyString.objAsString(context, hash2.op_aref(context, pattern));
                } else {
                    match2 = new RubyMatchData(context.runtime);
                    match2.initMatchData(this, begz, pattern);
                    if (useBackref) {
                        context.setBackRef(match2);
                    }
                    val = RubyString.objAsString(context, block.yield(context, Create.dupString(context, pattern)));
                }
                this.modifyCheck(spBytes, spLen, str_enc);
                if (bang) {
                    this.frozenCheck();
                }
            }
            tuFlags |= val.flags;
            int len = begz - offset2;
            if (len != 0) {
                dest.cat(spBytes, cp, len, str_enc);
            }
            dest.catWithCodeRange(val);
            offset2 = endz;
            if (begz == endz) {
                if (spLen <= endz) break;
                len = StringSupport.encFastMBCLen(spBytes, spBeg + endz, spBeg + spLen, str_enc);
                dest.cat(spBytes, spBeg + endz, len, str_enc);
                offset2 = endz + len;
            }
            cp = spBeg + offset2;
        } while (offset2 <= spLen && (beg = StringSupport.index(this.getByteList(), pattern.getByteList(), offset2, patternEnc)) >= 0);
        if (spLen > offset2) {
            dest.cat(spBytes, cp, spLen - offset2, str_enc);
        }
        if (useBackref) {
            if (match2 != null) {
                context.setBackRef(match2);
            } else {
                match2 = new RubyMatchData(context.runtime);
                match2.initMatchData(this, begz, pattern);
                context.setBackRef(match2);
            }
        }
        if (bang) {
            this.view(dest.value);
            this.setCodeRange(dest.getCodeRange());
            return this;
        }
        return dest;
    }

    private IRubyObject gsubCommon(ThreadContext context, Block block, RubyString repl, RubyHash hash2, RubyRegexp regexp2, boolean bang, int tuFlags, boolean useBackref) {
        int spLen;
        int spBeg;
        byte[] spBytes;
        Regex pattern = regexp2.getPattern(context);
        Regex prepared = regexp2.preparePattern(context, this);
        Matcher matcher = prepared.matcher(spBytes = this.value.getUnsafeBytes(), spBeg = this.value.getBegin(), spBeg + (spLen = this.value.getRealSize()));
        int beg = RubyRegexp.matcherSearch(context, matcher, spBeg, spBeg + spLen, 0);
        if (beg < 0) {
            if (useBackref) {
                context.clearBackRef();
            }
            return bang ? context.nil : Create.dupString(context, this);
        }
        int offset2 = 0;
        int cp = spBeg;
        RubyString dest = Create.newString(context, new ByteList(spLen + 30));
        Encoding str_enc = this.value.getEncoding();
        dest.setEncoding(str_enc);
        dest.setCodeRange(str_enc.isAsciiCompatible() ? 16 : 32);
        RubyMatchData match2 = null;
        do {
            RubyString val;
            int begz = matcher.getBegin();
            int endz = matcher.getEnd();
            if (repl != null) {
                val = RubyRegexp.regsub(context, repl, this, pattern, matcher);
            } else {
                RubyString substr = this.makeSharedString(context.runtime, begz, endz - begz);
                if (hash2 != null) {
                    val = RubyString.objAsString(context, hash2.op_aref(context, substr));
                } else {
                    match2 = RubyRegexp.createMatchData(context, this, matcher, pattern);
                    match2.regexp = regexp2;
                    if (useBackref) {
                        context.setBackRef(match2);
                    }
                    val = RubyString.objAsString(context, block.yield(context, substr));
                }
                this.modifyCheck(spBytes, spLen, str_enc);
                if (bang) {
                    this.frozenCheck();
                }
            }
            tuFlags |= val.flags;
            int len = begz - offset2;
            if (len != 0) {
                dest.cat(spBytes, cp, len, str_enc);
            }
            dest.catWithCodeRange(val);
            offset2 = endz;
            if (begz == endz) {
                if (spLen <= endz) break;
                len = StringSupport.encFastMBCLen(spBytes, spBeg + endz, spBeg + spLen, str_enc);
                dest.cat(spBytes, spBeg + endz, len, str_enc);
                offset2 = endz + len;
            }
            cp = spBeg + offset2;
        } while (offset2 <= spLen && (beg = RubyRegexp.matcherSearch(context, matcher, cp, spBeg + spLen, 0)) >= 0);
        if (spLen > offset2) {
            dest.cat(spBytes, cp, spLen - offset2, str_enc);
        }
        if (useBackref) {
            if (match2 != null) {
                context.setBackRef(match2);
            } else {
                match2 = RubyRegexp.createMatchData(context, this, matcher, pattern);
                match2.regexp = regexp2;
                context.setBackRef(match2);
            }
        }
        if (bang) {
            this.view(dest.value);
            this.setCodeRange(dest.getCodeRange());
            return this;
        }
        return dest;
    }

    @JRubyMethod(name={"index"}, writes={FrameField.BACKREF})
    public IRubyObject index(ThreadContext context, IRubyObject arg0) {
        return this.indexCommon(context, arg0, 0);
    }

    @JRubyMethod(name={"index"}, writes={FrameField.BACKREF})
    public IRubyObject index(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int pos2 = Convert.toInt(context, arg1);
        if (pos2 < 0 && (pos2 += this.strLength()) < 0) {
            if (arg0 instanceof RubyRegexp) {
                context.clearBackRef();
            }
            return context.nil;
        }
        return this.indexCommon(context, arg0, pos2);
    }

    @JRubyMethod(writes={FrameField.BACKREF})
    public IRubyObject byteindex(ThreadContext context, IRubyObject arg0) {
        return this.byteIndexCommon(context, arg0, 0);
    }

    @JRubyMethod(writes={FrameField.BACKREF})
    public IRubyObject byteindex(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int pos2 = Convert.toInt(context, arg1);
        if (pos2 < 0 && (pos2 += this.value.realSize()) < 0) {
            if (arg0 instanceof RubyRegexp) {
                context.clearBackRef();
            }
            return context.nil;
        }
        return this.byteIndexCommon(context, arg0, pos2);
    }

    private IRubyObject indexCommon(ThreadContext context, IRubyObject sub3, int pos2) {
        if (sub3 instanceof RubyRegexp) {
            RubyRegexp regexp2 = (RubyRegexp)sub3;
            if (pos2 > this.strLength()) {
                context.clearBackRef();
                return context.nil;
            }
            pos2 = this.singleByteOptimizable() ? pos2 : StringSupport.nth(regexp2.checkEncoding(context, this), this.value, pos2) - this.value.getBegin();
            pos2 = regexp2.adjustStartPos(context, this, pos2, false);
            if ((pos2 = regexp2.search(context, this, pos2, false)) >= 0) {
                pos2 = this.subLength(context.getLocalMatch().begin(0));
            }
        } else {
            RubyString str = sub3.convertToString();
            pos2 = StringSupport.index(this, str, pos2, this.checkEncoding(str));
            pos2 = this.subLength(pos2);
        }
        return pos2 < 0 ? context.nil : Convert.asFixnum(context, pos2);
    }

    private IRubyObject byteIndexCommon(ThreadContext context, IRubyObject sub3, int pos2) {
        int len = this.value.realSize();
        if (pos2 < 0 || pos2 > len) {
            if (sub3 instanceof RubyRegexp) {
                context.clearBackRef();
            }
            return context.nil;
        }
        this.ensureBytePosition(context, pos2);
        if (sub3 instanceof RubyRegexp) {
            RubyRegexp regexp2 = (RubyRegexp)sub3;
            if (pos2 > len) {
                return context.nil;
            }
            if ((pos2 = regexp2.search(context, this, pos2, false)) >= 0) {
                pos2 = context.getLocalMatch().begin(0);
            }
        } else {
            RubyString str = sub3.convertToString();
            pos2 = StringSupport.byteindex(this, str, pos2, this.checkEncoding(str));
        }
        return pos2 < 0 ? context.nil : Convert.asFixnum(context, pos2);
    }

    private int strseqIndex(RubyString sub3, int offset2, boolean inBytes) {
        int pos2;
        int slen;
        boolean single_byte = this.singleByteOptimizable();
        Encoding enc = this.checkEncoding(sub3);
        if (sub3.isCodeRangeBroken()) {
            return -1;
        }
        int len = inBytes || single_byte ? this.value.realSize() : this.strLength();
        int n = slen = inBytes ? sub3.value.realSize() : sub3.strLength();
        if (offset2 < 0 && (offset2 += len) < 0) {
            return -1;
        }
        if (len - offset2 < slen) {
            return -1;
        }
        byte[] sBytes = this.value.unsafeBytes();
        int s2 = this.value.begin();
        int e = s2 + this.value.realSize();
        if (offset2 != 0) {
            if (!inBytes) {
                offset2 = StringSupport.offset(enc, sBytes, s2, e, offset2, single_byte);
            }
            s2 += offset2;
        }
        if (slen == 0) {
            return offset2;
        }
        byte[] sptrBytes = sub3.value.unsafeBytes();
        int sptr = sub3.value.begin();
        slen = sub3.value.realSize();
        len = this.value.realSize() - offset2;
        while (true) {
            if ((pos2 = StringSupport.memsearch(sptrBytes, sptr, slen, sBytes, s2, len, enc)) < 0) {
                return pos2;
            }
            int t = enc.rightAdjustCharHead(sBytes, s2, s2 + pos2, e);
            if (t == s2 + pos2) break;
            if ((len -= t - s2) <= 0) {
                return -1;
            }
            offset2 += t - s2;
            s2 = t;
        }
        return pos2 + offset2;
    }

    @JRubyMethod(name={"rindex"}, writes={FrameField.BACKREF})
    public IRubyObject rindex(ThreadContext context, IRubyObject arg0) {
        return this.rindexCommon(context, arg0, this.strLength());
    }

    @JRubyMethod(name={"rindex"}, writes={FrameField.BACKREF})
    public IRubyObject rindex(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int pos2 = Convert.toInt(context, arg1);
        int length2 = this.strLength();
        if (pos2 < 0 && (pos2 += length2) < 0) {
            if (arg0 instanceof RubyRegexp) {
                context.clearBackRef();
            }
            return context.nil;
        }
        if (pos2 > length2) {
            pos2 = length2;
        }
        return this.rindexCommon(context, arg0, pos2);
    }

    @JRubyMethod(writes={FrameField.BACKREF})
    public IRubyObject byterindex(ThreadContext context, IRubyObject arg0) {
        return this.byterindexCommon(context, arg0, this.value.realSize());
    }

    @JRubyMethod(writes={FrameField.BACKREF})
    public IRubyObject byterindex(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int pos2 = Convert.toInt(context, arg1);
        int length2 = this.value.realSize();
        if (pos2 < 0 && (pos2 += length2) < 0) {
            if (arg0 instanceof RubyRegexp) {
                context.clearBackRef();
            }
            return context.nil;
        }
        if (pos2 > length2) {
            pos2 = length2;
        }
        this.ensureBytePosition(context, pos2);
        return this.byterindexCommon(context, arg0, pos2);
    }

    private IRubyObject byterindexCommon(ThreadContext context, IRubyObject sub3, int pos2) {
        if (sub3 instanceof RubyRegexp) {
            RubyRegexp regexp2 = (RubyRegexp)sub3;
            if (pos2 > this.value.realSize()) {
                return context.nil;
            }
            if ((pos2 = regexp2.search(context, this, pos2, true)) >= 0) {
                pos2 = context.getLocalMatch().begin(0);
            }
        } else {
            RubyString str = sub3.convertToString();
            Encoding enc = this.checkEncoding(str);
            pos2 = StringSupport.byterindex(this.value, pos2, str, enc);
        }
        return pos2 < 0 ? context.nil : Convert.asFixnum(context, pos2);
    }

    private IRubyObject rindexCommon(ThreadContext context, IRubyObject sub3, int pos2) {
        if (sub3 instanceof RubyRegexp) {
            RubyRegexp regexp2 = (RubyRegexp)sub3;
            pos2 = StringSupport.offset(this.value.getEncoding(), this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + this.value.getRealSize(), pos2, this.singleByteOptimizable());
            if ((pos2 = regexp2.search(context, this, pos2, true)) >= 0) {
                pos2 = this.subLength(context.getLocalMatch().begin(0));
            }
        } else {
            RubyString str = sub3.convertToString();
            Encoding enc = this.checkEncoding(str);
            pos2 = StringSupport.rindex(this.value, StringSupport.strLengthFromRubyString(this, enc), StringSupport.strLengthFromRubyString(str, enc), pos2, str, enc);
        }
        return pos2 < 0 ? context.nil : Convert.asFixnum(context, pos2);
    }

    @Deprecated(since="9.4-")
    public final IRubyObject substr(int beg, int len) {
        return this.substr(this.getCurrentContext(), beg, len);
    }

    @Deprecated(since="10.0.0.0")
    public final IRubyObject substr(Ruby runtime2, int beg, int len) {
        return this.substr(this.getCurrentContext(), beg, len);
    }

    public final IRubyObject substr(ThreadContext context, int beg, int len) {
        int length2 = this.value.length();
        if (len < 0 || beg > length2) {
            return context.nil;
        }
        if (beg < 0 && (beg += length2) < 0) {
            return context.nil;
        }
        int end2 = Math.min(length2, beg + len);
        return this.makeSharedString(context.runtime, beg, end2 - beg);
    }

    private IRubyObject byteSubstr(ThreadContext context, long beg, long len) {
        int length2 = this.value.length();
        if (len < 0L || beg > (long)length2) {
            return context.nil;
        }
        if (beg < 0L && (beg += (long)length2) < 0L) {
            return context.nil;
        }
        if (beg + len > (long)length2) {
            len = (long)length2 - beg;
        }
        if (len <= 0L) {
            len = 0L;
        }
        return this.makeSharedString(context.runtime, (int)beg, (int)len);
    }

    private IRubyObject byteARef(ThreadContext context, IRubyObject idx) {
        int index2;
        if (idx instanceof RubyRange) {
            RubyRange range = (RubyRange)idx;
            int[] begLen = range.begLenInt(context, this.getByteList().length(), 0);
            return begLen == null ? context.nil : this.byteSubstr(context, begLen[0], begLen[1]);
        }
        if (idx instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)idx;
            long i2 = fixnum.value;
            if (i2 > Long.MAX_VALUE || i2 < Long.MIN_VALUE) {
                return context.nil;
            }
            index2 = (int)i2;
        } else {
            JavaSites.StringSites sites = RubyString.sites(context);
            if (RubyRange.isRangeLike(context, idx, sites.respond_to_begin, sites.respond_to_end)) {
                RubyRange range = RubyRange.rangeFromRangeLike(context, idx, sites.begin, sites.end, sites.exclude_end);
                int[] begLen = range.begLenInt(context, this.getByteList().length(), 0);
                return begLen == null ? context.nil : this.byteSubstr(context, begLen[0], begLen[1]);
            }
            index2 = Convert.toInt(context, idx);
        }
        IRubyObject obj = this.byteSubstr(context, index2, 1L);
        if (obj.isNil() || ((RubyString)obj).getByteList().length() == 0) {
            return context.nil;
        }
        return obj;
    }

    @Deprecated(since="10.0.0.0")
    public final IRubyObject substr19(Ruby runtime2, int beg, int len) {
        return this.substrEnc(this.getCurrentContext(), beg, len);
    }

    @Deprecated(since="10.0.0.0")
    public final IRubyObject substrEnc(Ruby runtime2, int beg, int len) {
        return this.substrEnc(this.getCurrentContext(), beg, len);
    }

    public final IRubyObject substrEnc(ThreadContext context, int beg, int len) {
        Encoding enc;
        if (len < 0) {
            return context.nil;
        }
        int length2 = this.value.getRealSize();
        if (length2 == 0) {
            len = 0;
        }
        if (this.singleByteOptimizable(enc = this.value.getEncoding())) {
            if (beg > length2) {
                return context.nil;
            }
            if (beg < 0 && (beg += length2) < 0) {
                return context.nil;
            }
            if (beg + len > length2) {
                len = length2 - beg;
            }
            if (len <= 0) {
                beg = 0;
                len = 0;
            }
            return this.makeSharedString(context.runtime, beg, len);
        }
        if (beg + len > length2) {
            len = length2 - beg;
        }
        return this.multibyteSubstr(context.runtime, enc, len, beg, length2);
    }

    private IRubyObject multibyteSubstr(Ruby runtime2, Encoding enc, int len, int beg, int length2) {
        int p2;
        int s2 = this.value.getBegin();
        int end2 = s2 + length2;
        byte[] bytes2 = this.value.getUnsafeBytes();
        if (beg < 0) {
            if (len > -beg) {
                len = -beg;
            }
            if (-beg * enc.maxLength() < length2 >>> 3) {
                beg = -beg;
                int e = end2;
                while (beg-- > len && (e = enc.prevCharHead(bytes2, s2, e, e)) != -1) {
                }
                int p3 = e;
                if (p3 == -1) {
                    return runtime2.getNil();
                }
                while (len-- > 0 && (p3 = enc.prevCharHead(bytes2, s2, p3, e)) != -1) {
                }
                if (p3 == -1) {
                    return runtime2.getNil();
                }
                return this.makeSharedString(runtime2, p3 - s2, e - p3);
            }
            if ((beg += StringSupport.strLengthFromRubyString(this, enc)) < 0) {
                return runtime2.getNil();
            }
        } else if (beg > 0 && beg > StringSupport.strLengthFromRubyString(this, enc)) {
            return runtime2.getNil();
        }
        if (len == 0) {
            p2 = 0;
        } else if (this.isCodeRangeValid() && enc.isUTF8()) {
            p2 = StringSupport.utf8Nth(bytes2, s2, end2, beg);
            len = StringSupport.utf8Offset(bytes2, p2, end2, len);
        } else if (enc.isFixedWidth()) {
            int w = enc.maxLength();
            p2 = s2 + beg * w;
            if (p2 > end2) {
                p2 = end2;
                len = 0;
            } else {
                len = len * w > end2 - p2 ? end2 - p2 : (len *= w);
            }
        } else {
            p2 = StringSupport.nth(enc, bytes2, s2, end2, beg);
            len = p2 == end2 ? 0 : StringSupport.offset(enc, bytes2, p2, end2, len);
        }
        return this.makeSharedString(runtime2, p2 - s2, len);
    }

    private char multibyteCharAt(Encoding enc, int beg, int length2) {
        int w;
        int p2;
        int s2 = this.value.getBegin();
        int end2 = s2 + length2;
        byte[] bytes2 = this.value.getUnsafeBytes();
        if (beg > 0 && beg > StringSupport.strLengthFromRubyString(this, enc)) {
            throw new StringIndexOutOfBoundsException(beg);
        }
        if (this.isCodeRangeValid() && enc.isUTF8()) {
            p2 = StringSupport.utf8Nth(bytes2, s2, end2, beg);
        } else if (enc.isFixedWidth() ? (p2 = s2 + beg * (w = enc.maxLength())) > end2 || w > end2 - p2 : (p2 = StringSupport.nth(enc, bytes2, s2, end2, beg)) == end2) {
            throw new StringIndexOutOfBoundsException(beg);
        }
        int codepoint = enc.mbcToCode(bytes2, p2, end2);
        if (Character.isBmpCodePoint(codepoint)) {
            return (char)codepoint;
        }
        return Character.highSurrogate(codepoint);
    }

    private IRubyObject replaceInternal(int beg, int len, RubyString repl) {
        StringSupport.replaceInternal(beg, len, this, repl);
        return this;
    }

    @Deprecated(since="10.0.0.0")
    private void replaceInternal19(Ruby runtime2, int beg, int len, RubyString repl) {
        StringSupport.strUpdate(this.getCurrentContext(), beg, len, this, repl);
    }

    @JRubyMethod(name={"[]", "slice"}, writes={FrameField.BACKREF})
    public IRubyObject op_aref(ThreadContext context, IRubyObject arg2) {
        if (arg2 instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)arg2;
            return this.op_aref(context, fixnum.asInt(context));
        }
        if (arg2 instanceof RubyRegexp) {
            RubyRegexp regexp2 = (RubyRegexp)arg2;
            return this.subpat(context, regexp2);
        }
        if (arg2 instanceof RubyString) {
            RubyString str = (RubyString)arg2;
            return StringSupport.index(this, str, 0, this.checkEncoding(str)) != -1 ? Create.dupString(context, str) : context.nil;
        }
        if (arg2 instanceof RubyRange) {
            RubyRange range = (RubyRange)arg2;
            int[] begLen = range.begLenInt(context, this.strLength(), 0);
            return begLen == null ? context.nil : this.substrEnc(context, begLen[0], begLen[1]);
        }
        JavaSites.StringSites sites = RubyString.sites(context);
        if (RubyRange.isRangeLike(context, arg2, sites.respond_to_begin, sites.respond_to_end)) {
            int len = this.strLength();
            RubyRange range = RubyRange.rangeFromRangeLike(context, arg2, sites.begin, sites.end, sites.exclude_end);
            int[] begLen = range.begLenInt(context, len, 0);
            return begLen == null ? context.nil : this.substrEnc(context, begLen[0], begLen[1]);
        }
        return this.op_aref(context, Convert.toInt(context, arg2));
    }

    @JRubyMethod(name={"[]", "slice"}, writes={FrameField.BACKREF})
    public IRubyObject op_aref(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        IRubyObject iRubyObject;
        if (arg1 instanceof RubyRegexp) {
            RubyRegexp regexp2 = (RubyRegexp)arg1;
            iRubyObject = this.subpat(context, regexp2, arg2);
        } else {
            iRubyObject = this.substrEnc(context, Convert.toInt(context, arg1), Convert.toInt(context, arg2));
        }
        return iRubyObject;
    }

    @JRubyMethod
    public IRubyObject byteslice(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        return this.byteSubstr(context, Convert.toLong(context, arg1), Convert.toLong(context, arg2));
    }

    @JRubyMethod
    public IRubyObject byteslice(ThreadContext context, IRubyObject arg2) {
        return this.byteARef(context, arg2);
    }

    @JRubyMethod(required=2, optional=3, checkArity=false)
    public IRubyObject bytesplice(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 2: {
                return this.bytesplice(context, args2[0], args2[1]);
            }
            case 3: {
                return this.bytesplice(context, args2[0], args2[1], args2[2]);
            }
            case 5: {
                break;
            }
            default: {
                throw Error.argumentError(context, "wrong number of arguments (given " + args2.length + ", expected 2, 3, or 5)");
            }
        }
        int[] beglen = new int[]{Convert.toInt(context, args2[0]), Convert.toInt(context, args2[1])};
        RubyString val = args2[2].convertToString();
        int[] vbegvlen = new int[]{Convert.toInt(context, args2[3]), Convert.toInt(context, args2[4])};
        this.checkBegLen(context, beglen);
        val.checkBegLen(context, vbegvlen);
        return this.bytespliceCommon(val, beglen[0], beglen[1], vbegvlen[0], vbegvlen[1]);
    }

    @JRubyMethod
    public IRubyObject bytesplice(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int[] beglen = new int[2];
        if (!RubyRange.rangeBeginLength(context, arg0, this.value.realSize(), beglen, 2).isTrue()) {
            throw Error.typeError(context, arg0, "Range");
        }
        this.checkBegLen(context, beglen);
        RubyString val = arg1.convertToString();
        int vbeg = 0;
        int vlen = val.getByteList().realSize();
        val.checkBegLenPositions(context, vbeg, vlen);
        return this.bytespliceCommon(val, beglen[0], beglen[1], vbeg, vlen);
    }

    @JRubyMethod
    public IRubyObject bytesplice(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return arg0 instanceof RubyInteger ? this.bytespliceOffsets(context, arg0, arg1, arg2) : this.bytespliceRange(context, arg0, arg1, arg2);
    }

    private RubyString bytespliceOffsets(ThreadContext context, IRubyObject index2, IRubyObject length2, IRubyObject str) {
        int[] beglen = new int[]{Convert.toInt(context, index2), Convert.toInt(context, length2)};
        this.checkBegLen(context, beglen);
        RubyString val = str.convertToString();
        int vbeg = 0;
        int vlen = val.getByteList().realSize();
        val.checkBegLenPositions(context, vbeg, vlen);
        return this.bytespliceCommon(val, beglen[0], beglen[1], vbeg, vlen);
    }

    private RubyString bytespliceRange(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        int[] beglen = new int[2];
        if (!RubyRange.rangeBeginLength(context, arg0, this.value.realSize(), beglen, 2).isTrue()) {
            throw Error.typeError(context, arg0, Access.rangeClass(context));
        }
        this.checkBegLen(context, beglen);
        RubyString val = arg1.convertToString();
        int[] vbegvlen = new int[2];
        if (!RubyRange.rangeBeginLength(context, arg2, val.getByteList().realSize(), vbegvlen, 2).isTrue()) {
            throw Error.typeError(context, arg2, Access.rangeClass(context));
        }
        val.checkBegLen(context, vbegvlen);
        return this.bytespliceCommon(val, beglen[0], beglen[1], vbegvlen[0], vbegvlen[1]);
    }

    private RubyString bytespliceCommon(RubyString val, int beg, int len, int vbeg, int vlen) {
        Encoding enc = this.checkEncoding(val);
        this.modifyAndKeepCodeRange();
        this.strUpdate1(beg, len, val, vbeg, vlen);
        this.setEncoding(enc);
        int cr = this.coderangeAnd(this.getCodeRange(), val.getCodeRange());
        if (cr != 48) {
            this.setCodeRange(cr);
        }
        return this;
    }

    int coderangeAnd(int a, int b2) {
        if (a == 16) {
            return b2;
        }
        if (a != 32) {
            return 0;
        }
        if (b2 == 16) {
            return 32;
        }
        return b2;
    }

    private void checkBegLen(ThreadContext context, int[] beglen) {
        int beg;
        int len = this.checkLength(context, beglen[1]);
        int slen = this.size();
        if (slen < (beg = beglen[0]) || beg < 0 && beg + slen < 0) {
            throw Error.indexError(context, "index " + beg + " out of string");
        }
        if (beg < 0) {
            beglen[0] = beg += slen;
        }
        assert (beg >= 0);
        assert (beg <= slen);
        if (len > slen - beg) {
            beglen[1] = len = slen - beg;
        }
        this.checkBegLenPositions(context, beg, len);
    }

    private void checkBegLenPositions(ThreadContext context, int beg, int len) {
        int end2 = beg + len;
        this.ensureBytePosition(context, beg);
        this.ensureBytePosition(context, end2);
    }

    private void ensureBytePosition(ThreadContext context, int pos2) {
        int e;
        int p2;
        int s2;
        ByteList byteList = this.getByteList();
        byte[] bytes2 = byteList.unsafeBytes();
        if (!RubyString.atCharBoundary(bytes2, s2 = byteList.begin(), p2 = s2 + pos2, e = s2 + byteList.realSize(), this.getEncoding())) {
            throw Error.indexError(context, "offset " + pos2 + " does not land on character boundary");
        }
    }

    public static boolean atCharBoundary(byte[] bytes2, int s2, int p2, int e, Encoding enc) {
        return p2 == bytes2.length || enc.leftAdjustCharHead(bytes2, s2, p2, e) == p2;
    }

    private void strUpdate1(int beg, int len, RubyString val, int vbeg, int vlen) {
        int cr;
        if (beg == 0 && vlen == 0) {
            this.dropBytes(len);
            return;
        }
        this.modifyAndKeepCodeRange();
        ByteList byteList = this.value;
        byte[] sbytes = byteList.unsafeBytes();
        int sptr = this.value.begin();
        int slen = this.value.realSize();
        if (len < vlen) {
            byteList.ensure(slen + vlen - len);
            sbytes = byteList.unsafeBytes();
        }
        int n = cr = this.isCodeRangeAsciiOnly() ? val.getCodeRange() : 0;
        if (vlen != len) {
            System.arraycopy(sbytes, sptr + beg + len, sbytes, sptr + beg + vlen, slen - (beg + len));
        }
        if (vlen < beg && len < 0) {
            Arrays.fill(sbytes, sptr + slen, sptr + slen + -len, (byte)0);
        }
        if (vlen > 0) {
            ByteList valByteList = val.getByteList();
            System.arraycopy(valByteList.unsafeBytes(), valByteList.begin() + vbeg, sbytes, sptr + beg, vlen);
        }
        byteList.realSize(slen += vlen - len);
        this.setCodeRange(cr);
    }

    private IRubyObject op_aref(ThreadContext context, int idx) {
        IRubyObject str = this.substrEnc(context, idx, 1);
        return !str.isNil() && ((RubyString)str).value.getRealSize() == 0 ? context.nil : str;
    }

    private int subpatSetCheck(ThreadContext context, int nth, Region regs) {
        int numRegs;
        int n = numRegs = regs == null ? 1 : regs.getNumRegs();
        if (nth < numRegs) {
            if (nth >= 0) {
                return nth;
            }
            if (-nth < numRegs) {
                return nth + numRegs;
            }
        }
        throw Error.indexError(context, "index " + nth + " out of regexp");
    }

    private void subpatSet(ThreadContext context, RubyRegexp regexp2, IRubyObject backref, IRubyObject repl) {
        int end2;
        int start2;
        int nth;
        int result2 = regexp2.searchString(context, this, 0, false);
        if (result2 < 0) {
            throw Error.indexError(context, "regexp not matched");
        }
        RubyMatchData match2 = context.getLocalMatch();
        int n = nth = backref == null ? 0 : this.subpatSetCheck(context, match2.backrefNumber(context, backref), match2.regs);
        if (match2.regs == null) {
            start2 = match2.begin;
            end2 = match2.end;
        } else {
            start2 = match2.regs.getBeg(nth);
            end2 = match2.regs.getEnd(nth);
        }
        if (start2 == -1) {
            throw Error.indexError(context, "regexp group " + nth + " not matched");
        }
        RubyString replStr = repl.convertToString();
        Encoding enc = this.checkEncoding(replStr);
        this.replaceInternal(start2, end2 - start2, replStr);
        this.associateEncoding(enc);
        context.setBackRef(match2);
    }

    private IRubyObject subpat(ThreadContext context, RubyRegexp regex, IRubyObject backref) {
        int result2 = regex.searchString(context, this, 0, false);
        if (result2 >= 0) {
            RubyMatchData match2 = context.getLocalMatch();
            context.setBackRef(match2);
            return RubyRegexp.nth_match(context, match2.backrefNumber(context, backref), match2);
        }
        context.clearBackRef();
        return context.nil;
    }

    private IRubyObject subpat(ThreadContext context, RubyRegexp regex) {
        int result2 = regex.searchString(context, this, 0, false);
        if (result2 >= 0) {
            RubyMatchData match2 = context.getLocalMatch();
            context.setBackRef(match2);
            return RubyRegexp.nth_match(context, 0, match2);
        }
        context.clearBackRef();
        return context.nil;
    }

    @JRubyMethod(name={"[]="}, writes={FrameField.BACKREF})
    public IRubyObject op_aset(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        if (arg0 instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)arg0;
            return this.op_aset(context, fixnum.asInt(context), arg1);
        }
        if (arg0 instanceof RubyRegexp) {
            RubyRegexp regexp2 = (RubyRegexp)arg0;
            this.subpatSet(context, regexp2, null, arg1);
            return arg1;
        }
        if (arg0 instanceof RubyString) {
            RubyString orig = (RubyString)arg0;
            int beg = StringSupport.index(this, orig, 0, this.checkEncoding(orig));
            if (beg < 0) {
                throw Error.indexError(context, "string not matched");
            }
            beg = this.subLength(beg);
            int len = orig.strLength();
            StringSupport.strUpdate(context, beg, len, this, arg1.convertToString());
            return arg1;
        }
        if (arg0 instanceof RubyRange) {
            RubyRange range = (RubyRange)arg0;
            int[] begLen = range.begLenInt(context, this.strLength(), 2);
            StringSupport.strUpdate(context, begLen[0], begLen[1], this, arg1.convertToString());
            return arg1;
        }
        JavaSites.StringSites sites = RubyString.sites(context);
        if (RubyRange.isRangeLike(context, arg0, sites.respond_to_begin, sites.respond_to_end)) {
            RubyRange rng = RubyRange.rangeFromRangeLike(context, arg0, sites.begin, sites.end, sites.exclude_end);
            int[] begLen = rng.begLenInt(context, this.strLength(), 2);
            StringSupport.strUpdate(context, begLen[0], begLen[1], this, arg1.convertToString());
            return arg1;
        }
        return this.op_aset(context, Convert.toInt(context, arg0), arg1);
    }

    private IRubyObject op_aset(ThreadContext context, int idx, IRubyObject arg1) {
        StringSupport.strUpdate(context, idx, 1, this, arg1.convertToString());
        return arg1;
    }

    @JRubyMethod(name={"[]="}, writes={FrameField.BACKREF})
    public IRubyObject op_aset(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        if (arg0 instanceof RubyRegexp) {
            RubyRegexp regexp2 = (RubyRegexp)arg0;
            this.subpatSet(context, regexp2, arg1, arg2);
        } else {
            int beg = Convert.toInt(context, arg0);
            int len = this.checkLength(context, Convert.toInt(context, arg1));
            StringSupport.strUpdate(context, beg, len, this, arg2.convertToString());
        }
        return arg2;
    }

    @JRubyMethod(name={"slice!"}, writes={FrameField.BACKREF})
    public IRubyObject slice_bang(ThreadContext context, IRubyObject arg0) {
        IRubyObject result2 = this.op_aref(context, arg0);
        if (result2.isNil()) {
            this.modifyCheck();
        } else {
            this.op_aset(context, arg0, (IRubyObject)Create.newEmptyString(context));
        }
        return result2;
    }

    @JRubyMethod(name={"slice!"}, writes={FrameField.BACKREF})
    public IRubyObject slice_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject result2 = this.op_aref(context, arg0, arg1);
        if (result2.isNil()) {
            this.modifyCheck();
        } else {
            this.op_aset(context, arg0, arg1, Create.newEmptyString(context));
        }
        return result2;
    }

    @JRubyMethod(name={"succ", "next"})
    public IRubyObject succ(ThreadContext context) {
        return this.value.getRealSize() > 0 ? Create.newString(context, StringSupport.succCommon(context, this.value)) : Create.newEmptyString(context, this.value.getEncoding());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject succ_bang() {
        return this.succ_bang(this.getCurrentContext());
    }

    @JRubyMethod(name={"succ!", "next!"})
    public IRubyObject succ_bang(ThreadContext context) {
        this.modifyCheck();
        if (this.value.getRealSize() > 0) {
            this.value = StringSupport.succCommon(context, this.value);
            this.shareLevel = 0;
        }
        return this;
    }

    @JRubyMethod(name={"upto"})
    public final IRubyObject upto(ThreadContext context, IRubyObject end2, Block block) {
        return block.isGiven() ? this.uptoCommon(context, end2, false, block) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "upto", end2);
    }

    @JRubyMethod(name={"upto"})
    public final IRubyObject upto(ThreadContext context, IRubyObject end2, IRubyObject excl, Block block) {
        return block.isGiven() ? this.uptoCommon(context, end2, excl.isTrue(), block) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "upto", end2, excl);
    }

    final IRubyObject uptoCommon(ThreadContext context, IRubyObject arg2, boolean excl, Block block) {
        if (arg2 instanceof RubySymbol) {
            throw Error.typeError(context, "can't convert Symbol into String");
        }
        return this.uptoCommon(context, arg2.convertToString(), excl, block, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    final IRubyObject uptoCommon(ThreadContext context, RubyString end2, boolean excl, Block block, boolean asSymbol) {
        byte[] bytes2;
        int send2;
        int s2;
        boolean isAscii;
        Encoding enc = this.checkEncoding(end2);
        boolean bl = isAscii = this.scanForCodeRange() == 16 && end2.scanForCodeRange() == 16;
        if (this.value.getRealSize() != 1 || end2.value.getRealSize() != 1 || !isAscii) {
            if (!isAscii) return this.uptoCommonNoDigits(context, end2, excl, block, asSymbol);
            if (!ASCII.isDigit(this.value.getUnsafeBytes()[this.value.getBegin()])) return this.uptoCommonNoDigits(context, end2, excl, block, asSymbol);
            if (!ASCII.isDigit(end2.value.getUnsafeBytes()[end2.value.getBegin()])) return this.uptoCommonNoDigits(context, end2, excl, block, asSymbol);
            send2 = s2 + this.value.getRealSize();
            bytes2 = this.value.getUnsafeBytes();
        } else {
            byte e;
            byte c = this.value.getUnsafeBytes()[this.value.getBegin()];
            if (c > (e = end2.value.getUnsafeBytes()[end2.value.getBegin()])) return this;
            if (excl && c == e) {
                return this;
            }
            while (true) {
                ByteList s3 = RubyInteger.singleCharByteList(c);
                block.yield(context, asSymbol ? Convert.asSymbol(context, s3) : RubyString.newStringShared(context.runtime, s3, enc, 16));
                if (!excl && c == e) {
                    return this;
                }
                c = (byte)(c + 1);
                if (excl && c == e) {
                    return this;
                }
                context.pollThreadEvents();
            }
        }
        for (s2 = this.value.getBegin(); s2 < send2; ++s2) {
            if (!ASCII.isDigit(bytes2[s2] & 0xFF)) {
                return this.uptoCommonNoDigits(context, end2, excl, block, asSymbol);
            }
            context.pollThreadEvents();
        }
        send2 = s2 + end2.value.getRealSize();
        bytes2 = end2.value.getUnsafeBytes();
        for (s2 = end2.value.getBegin(); s2 < send2; ++s2) {
            if (!ASCII.isDigit(bytes2[s2] & 0xFF)) {
                return this.uptoCommonNoDigits(context, end2, excl, block, asSymbol);
            }
            context.pollThreadEvents();
        }
        IRubyObject b2 = this.stringToInum(10);
        IRubyObject e = end2.stringToInum(10);
        RubyArray<?> argsArr = Create.newArray(context, (IRubyObject)Convert.asFixnum(context, this.value.length()), context.nil);
        if (b2 instanceof RubyFixnum) {
            RubyFixnum bb = (RubyFixnum)b2;
            if (!(e instanceof RubyFixnum)) {
            } else {
                RubyFixnum ee = (RubyFixnum)e;
                long bl2 = bb.getValue();
                long el = ee.getValue();
                while (bl2 <= el) {
                    if (excl && bl2 == el) {
                        return this;
                    }
                    argsArr.eltSetOk(1, Convert.asFixnum(context, bl2));
                    ByteList to = new ByteList(this.value.length() + 5);
                    Sprintf.sprintf(to, (CharSequence)"%.*d", argsArr);
                    RubyString str = RubyString.newStringNoCopy(context.runtime, to, USASCIIEncoding.INSTANCE, 16);
                    block.yield(context, asSymbol ? Convert.asSymbol(context, str.toString()) : str);
                    ++bl2;
                    context.pollThreadEvents();
                }
                return this;
            }
        }
        JavaSites.StringSites sites = RubyString.sites(context);
        CallSite op = excl ? sites.op_lt : sites.op_le;
        while (op.call(context, b2, b2, e).isTrue()) {
            argsArr.eltSetOk(1, b2);
            ByteList to = new ByteList(this.value.length() + 5);
            Sprintf.sprintf(to, (CharSequence)"%.*d", argsArr);
            RubyString str = RubyString.newStringNoCopy(context.runtime, to, USASCIIEncoding.INSTANCE, 16);
            block.yield(context, asSymbol ? Convert.asSymbol(context, str.toString()) : str);
            b2 = sites.succ.call(context, b2, b2);
            context.pollThreadEvents();
        }
        return this;
    }

    private IRubyObject uptoCommonNoDigits(ThreadContext context, RubyString end2, boolean excl, Block block, boolean asSymbol) {
        int n = this.op_cmp(end2);
        if (n > 0 || excl && n == 0) {
            return this;
        }
        JavaSites.StringSites sites = RubyString.sites(context);
        CallSite succ2 = sites.succ;
        IRubyObject afterEnd = succ2.call(context, end2, end2);
        RubyString current2 = Create.dupString(context, this);
        while (!current2.op_equal(context, afterEnd).isTrue()) {
            IRubyObject next2 = null;
            if (excl || !current2.op_equal(context, end2).isTrue()) {
                next2 = succ2.call(context, current2, current2);
            }
            block.yield(context, asSymbol ? Convert.asSymbol(context, current2.toString()) : current2);
            if (next2 == null) break;
            current2 = next2.convertToString();
            if (excl && current2.op_equal(context, end2).isTrue() || current2.getByteList().length() > end2.getByteList().length() || current2.getByteList().isEmpty()) break;
            context.pollThreadEvents();
        }
        return this;
    }

    final IRubyObject uptoEndless(ThreadContext context, Block block) {
        JavaSites.StringSites sites = RubyString.sites(context);
        CallSite succ2 = sites.succ;
        boolean isAscii = this.scanForCodeRange() == 16;
        RubyString current2 = Create.dupString(context, this);
        if (isAscii && ASCII.isDigit(this.value.getUnsafeBytes()[this.value.getBegin()])) {
            IRubyObject b2 = this.stringToInum(10);
            RubyArray<?> argsArr = Create.newArray(context, (IRubyObject)Convert.asFixnum(context, this.value.length()), context.nil);
            if (b2 instanceof RubyFixnum) {
                ByteList to;
                long bl;
                RubyFixnum bb = (RubyFixnum)b2;
                for (bl = bb.getValue(); bl < Long.MAX_VALUE; ++bl) {
                    argsArr.eltSetOk(1, Convert.asFixnum(context, bl));
                    to = new ByteList(this.value.length() + 5);
                    Sprintf.sprintf(to, (CharSequence)"%.*d", argsArr);
                    current2 = RubyString.newStringNoCopy(context.runtime, to, USASCIIEncoding.INSTANCE, 16);
                    block.yield(context, current2);
                    context.pollThreadEvents();
                }
                argsArr.eltSetOk(1, Convert.asFixnum(context, bl));
                to = new ByteList(this.value.length() + 5);
                Sprintf.sprintf(to, (CharSequence)"%.*d", argsArr);
                current2 = RubyString.newStringNoCopy(context.runtime, to, USASCIIEncoding.INSTANCE, 16);
            }
        }
        while (true) {
            IRubyObject next2 = succ2.call(context, current2, current2);
            block.yield(context, current2);
            if (next2 == null || (current2 = next2.convertToString()).getByteList().isEmpty()) break;
            context.pollThreadEvents();
        }
        return this;
    }

    @JRubyMethod(name={"include?"})
    public RubyBoolean include_p(ThreadContext context, IRubyObject obj) {
        RubyString coerced = obj.convertToString();
        return Convert.asBoolean(context, StringSupport.index(this, coerced, 0, this.checkEncoding(coerced)) != -1);
    }

    @JRubyMethod
    public IRubyObject chr(ThreadContext context) {
        return this.substrEnc(context, 0, 1);
    }

    @JRubyMethod
    public IRubyObject getbyte(ThreadContext context, IRubyObject index2) {
        int i2 = Convert.toInt(context, index2);
        if (i2 < 0) {
            i2 += this.value.getRealSize();
        }
        if (i2 < 0 || i2 >= this.value.getRealSize()) {
            return context.nil;
        }
        return Convert.asFixnum(context, this.value.getUnsafeBytes()[this.value.getBegin() + i2] & 0xFF);
    }

    @JRubyMethod
    public IRubyObject setbyte(ThreadContext context, IRubyObject index2, IRubyObject val) {
        int i2 = Convert.toInt(context, index2);
        int normalizedIndex = this.checkIndexForRef(context, i2, this.value.getRealSize());
        RubyInteger v = val.convertToInteger();
        IRubyObject w = v.modulo(context, 256L);
        int b2 = Convert.toInt(context, w) & 0xFF;
        this.modifyAndClearCodeRange();
        this.value.getUnsafeBytes()[normalizedIndex] = (byte)b2;
        return val;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject to_i() {
        return this.to_i(this.getCurrentContext());
    }

    @JRubyMethod(name={"to_i"})
    public IRubyObject to_i(ThreadContext context) {
        return this.stringToInum(10);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject to_i(IRubyObject arg0) {
        return this.to_i(this.getCurrentContext(), arg0);
    }

    @JRubyMethod(name={"to_i"})
    public IRubyObject to_i(ThreadContext context, IRubyObject arg0) {
        int base = Convert.toInt(context, arg0);
        if (base < 0) {
            throw Error.argumentError(context, "illegal radix " + base);
        }
        return this.stringToInum(base);
    }

    public IRubyObject stringToInum(int base, boolean badcheck) {
        ByteList str = this.value;
        if (!str.getEncoding().isAsciiCompatible()) {
            throw this.getRuntime().newEncodingCompatibilityError("ASCII incompatible encoding: " + String.valueOf(str.getEncoding()));
        }
        return ConvertBytes.byteListToInum(this.getRuntime(), str, base, badcheck);
    }

    public final IRubyObject stringToInum(int base) {
        return this.stringToInum(base, false);
    }

    @JRubyMethod(name={"oct"})
    public IRubyObject oct(ThreadContext context) {
        return this.stringToInum(-8, false);
    }

    @JRubyMethod(name={"hex"})
    public IRubyObject hex(ThreadContext context) {
        return this.stringToInum(16, false);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject to_f() {
        return this.to_f(this.getCurrentContext());
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f(ThreadContext context) {
        return RubyNumeric.str2fnum(context.runtime, this, false);
    }

    private void populateCapturesForSplit(ThreadContext context, RubyArray result2, RubyMatchData match2) {
        for (int i2 = 1; i2 < match2.numRegs(); ++i2) {
            int beg = match2.begin(i2);
            if (beg == -1) continue;
            result2.append(context, this.makeSharedString(context.runtime, beg, match2.end(i2) - beg));
        }
    }

    public RubyArray split(ThreadContext context) {
        return this.split(context, context.nil);
    }

    public RubyArray split(ThreadContext context, IRubyObject arg0) {
        return this.splitCommon(context, arg0, 0);
    }

    @JRubyMethod(name={"split"})
    public IRubyObject splitWithBlock(ThreadContext context, Block block) {
        return this.splitWithBlock(context, context.nil, block);
    }

    @JRubyMethod(name={"split"})
    public IRubyObject splitWithBlock(ThreadContext context, IRubyObject arg0, Block block) {
        RubyArray array2 = this.split(context, arg0);
        if (!block.isGiven()) {
            return array2;
        }
        for (int i2 = 0; i2 < array2.getLength(); ++i2) {
            block.yield(context, (IRubyObject)array2.eltOk(i2));
        }
        return this;
    }

    public RubyArray split(ThreadContext context, IRubyObject pattern, IRubyObject limit2) {
        return this.splitCommon(context, pattern, Convert.toInt(context, limit2));
    }

    @JRubyMethod(name={"split"})
    public IRubyObject splitWithBlock(ThreadContext context, IRubyObject pattern, IRubyObject limit2, Block block) {
        RubyArray array2 = this.split(context, pattern, limit2);
        if (!block.isGiven()) {
            return array2;
        }
        for (int i2 = 0; i2 < array2.getLength(); ++i2) {
            block.yield(context, (IRubyObject)array2.eltOk(i2));
        }
        return this;
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray split(RubyRegexp delimiter) {
        return this.splitCommon(this.getCurrentContext(), delimiter, 0);
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray split(RubyRegexp delimiter, int limit2) {
        return this.split(this.getCurrentContext(), delimiter, limit2);
    }

    @JRubyAPI
    public RubyArray split(ThreadContext context, RubyRegexp delimiter, int limit2) {
        return this.splitCommon(context, delimiter, limit2);
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray split(RubyString delimiter) {
        return this.splitCommon(this.getCurrentContext(), delimiter, 0);
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray split(RubyString delimiter, int limit2) {
        return this.split(this.getCurrentContext(), delimiter, limit2);
    }

    @JRubyAPI
    public RubyArray split(ThreadContext context, RubyString delimiter, int limit2) {
        return this.splitCommon(context, delimiter, limit2);
    }

    private RubyArray splitCommon(ThreadContext context, IRubyObject pat, int lim) {
        RubyArray result2;
        if (lim == 1) {
            return this.value.isEmpty() ? Create.newArray(context) : Create.newArray(context, (IRubyObject)Create.dupString(context, this));
        }
        boolean limit2 = lim > 0;
        Object splitPattern = this.determineSplitPattern(context, pat);
        if (splitPattern == context.nil) {
            result2 = this.awkSplit(context, limit2, lim);
        } else if (splitPattern instanceof ByteList) {
            ByteList bytelist = (ByteList)splitPattern;
            switch (bytelist.realSize()) {
                case 0: {
                    RubyRegexp pattern = RubyRegexp.newRegexp(context.runtime, (ByteList)splitPattern, 0);
                    result2 = this.regexSplit(context, pattern, limit2, lim);
                    break;
                }
                case 1: {
                    result2 = this.asciiStringSplitOne(context, (byte)((ByteList)splitPattern).charAt(0), limit2, lim);
                    break;
                }
                default: {
                    result2 = this.asciiStringSplit(context, (ByteList)splitPattern, limit2, lim);
                    break;
                }
            }
        } else if (splitPattern instanceof RubyRegexp) {
            RubyRegexp regexp2 = (RubyRegexp)splitPattern;
            result2 = this.regexSplit(context, regexp2, limit2, lim);
        } else {
            RubyString splitString = (RubyString)splitPattern;
            ((RubyString)splitPattern).mustnotBroken(context);
            if (splitString.isEmpty()) {
                RubyRegexp pattern = RubyRegexp.newRegexpFromStr(context.runtime, splitString, 0);
                result2 = this.regexSplit(context, pattern, limit2, lim);
            } else {
                ByteList spatValue = ((RubyString)splitPattern).value;
                int len = spatValue.getRealSize();
                Encoding spatEnc = spatValue.getEncoding();
                byte[] bytes2 = spatValue.getUnsafeBytes();
                int p2 = spatValue.getBegin();
                int c = spatEnc.isAsciiCompatible() ? (len == 1 ? bytes2[p2] & 0xFF : -1) : (len == StringSupport.preciseLength(spatEnc, bytes2, p2, p2 + len) ? spatEnc.mbcToCode(bytes2, p2, p2 + len) : -1);
                result2 = c == 32 ? this.awkSplit(context, limit2, lim) : this.stringSplit(context, splitString, limit2, lim);
            }
        }
        if (!limit2 && lim == 0) {
            while (!result2.isEmpty() && ((RubyString)result2.eltInternal((int)(result2.size() - 1))).value.getRealSize() == 0) {
                result2.pop(context);
            }
        }
        return result2;
    }

    private Object determineSplitPattern(ThreadContext context, IRubyObject pat) {
        IRubyObject pattern;
        if (!pat.isNil()) {
            pattern = RubyString.getPatternQuoted(context, pat);
        } else {
            IRubyObject splitPattern = Access.globalVariables(context).get("$;");
            if (splitPattern.isNil()) {
                return context.nil;
            }
            Warn.warnDeprecated(context, "$; is set to non-nil value");
            pattern = splitPattern;
        }
        if (pattern instanceof RubyRegexp) {
            RubyRegexp regexp2 = (RubyRegexp)pattern;
            if (regexp2.isSimpleString(context)) {
                return regexp2.rawSource();
            }
            return regexp2;
        }
        RubyString stringPattern = (RubyString)pattern;
        if (this.isAsciiOnly() && stringPattern.isAsciiOnly() && (stringPattern.length() != 1 || stringPattern.getByteList().charAt(0) != ' ')) {
            return stringPattern.getByteList();
        }
        return stringPattern;
    }

    /*
     * Enabled aggressive block sorting
     */
    private RubyArray regexSplit(ThreadContext context, RubyRegexp pattern, boolean limit2, int lim) {
        RubyArray<?> result2 = Create.newArray(context);
        int ptr = this.value.getBegin();
        int len = this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        Encoding enc = this.value.getEncoding();
        boolean captures2 = pattern.getPattern(context).numberOfCaptures() != 0;
        int beg = 0;
        boolean lastNull = false;
        int start2 = beg;
        int i2 = 1;
        while (pattern.searchString(context, this, start2, false) >= 0) {
            RubyMatchData match2;
            block7: {
                match2 = context.getLocalMatch();
                int end2 = match2.begin(0);
                if (start2 == end2 && match2.begin(0) == match2.end(0)) {
                    if (len == 0 && start2 != 0) {
                        result2.append(context, RubyString.newEmptyString(context.runtime, this.metaClass));
                        break;
                    }
                    if (lastNull) {
                        result2.append(context, this.makeSharedString(context.runtime, beg, StringSupport.length(enc, bytes2, ptr + beg, ptr + len)));
                        beg = start2;
                        break block7;
                    } else {
                        start2 = ptr + start2 == ptr + len ? ++start2 : (start2 += StringSupport.length(enc, bytes2, ptr + start2, ptr + len));
                        lastNull = true;
                        continue;
                    }
                }
                result2.append(context, this.makeSharedString(context.runtime, beg, end2 - beg));
                start2 = beg = match2.end(0);
            }
            lastNull = false;
            if (captures2) {
                this.populateCapturesForSplit(context, result2, match2);
            }
            if (!limit2 || lim > ++i2) continue;
        }
        if (len > 0 && (limit2 || len > beg || lim < 0)) {
            result2.append(context, this.makeSharedString(context.runtime, beg, len - beg));
        }
        return result2;
    }

    private RubyArray awkSplit(ThreadContext context, boolean limit2, int lim) {
        int p2;
        RubyArray<?> result2 = Create.newArray(context);
        byte[] bytes2 = this.value.getUnsafeBytes();
        int ptr = p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int end2 = p2 + len;
        Encoding enc = this.value.getEncoding();
        boolean skip2 = true;
        int i2 = 1;
        int e = 0;
        int b2 = 0;
        boolean singlebyte = this.singleByteOptimizable(enc);
        while (p2 < end2) {
            int c;
            if (singlebyte) {
                c = bytes2[p2++] & 0xFF;
            } else {
                c = StringSupport.codePoint(context, enc, bytes2, p2, end2);
                p2 += StringSupport.length(enc, bytes2, p2, end2);
            }
            if (skip2) {
                if (ASCII.isSpace(c)) {
                    b2 = p2 - ptr;
                    continue;
                }
                e = p2 - ptr;
                skip2 = false;
                if (!limit2 || lim > i2) continue;
                break;
            }
            if (ASCII.isSpace(c)) {
                result2.append(context, this.makeSharedString(context.runtime, b2, e - b2));
                skip2 = true;
                b2 = p2 - ptr;
                if (!limit2) continue;
                ++i2;
                continue;
            }
            e = p2 - ptr;
        }
        if (len > 0 && (limit2 || len > b2 || lim < 0)) {
            result2.append(context, this.makeSharedString(context.runtime, b2, len - b2));
        }
        return result2;
    }

    private RubyArray asciiStringSplitOne(ThreadContext context, byte pat, boolean limit2, int lim) {
        int index2;
        RubyArray<?> result2 = Create.newArray(context);
        int realSize = this.value.getRealSize();
        if (realSize == 0) {
            return result2;
        }
        byte[] bytes2 = this.value.getUnsafeBytes();
        int begin2 = this.value.getBegin();
        int startSegment = 0;
        int i2 = 1;
        for (index2 = 0; index2 < realSize; ++index2) {
            if (bytes2[begin2 + index2] != pat) continue;
            result2.append(context, this.makeSharedString(context.runtime, startSegment, index2 - startSegment));
            startSegment = index2 + 1;
            if (limit2 && lim <= ++i2) break;
        }
        if (limit2) {
            result2.append(context, this.makeSharedString(context.runtime, startSegment, realSize - startSegment));
        } else if (index2 > startSegment || lim < 0) {
            result2.append(context, this.makeSharedString(context.runtime, startSegment, index2 - startSegment));
        }
        return result2;
    }

    private RubyArray asciiStringSplit(ThreadContext context, ByteList pattern, boolean limit2, int lim) {
        int e;
        RubyArray<?> result2 = Create.newArray(context);
        byte[] patternBytes = pattern.getUnsafeBytes();
        int patternBegin = pattern.getBegin();
        int patternRealSize = pattern.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        int begin2 = this.value.getBegin();
        int realSize = this.value.getRealSize();
        int p2 = 0;
        int i2 = 1;
        while (p2 < realSize && (e = RubyString.asciiIndexOf(bytes2, begin2, realSize, patternBytes, patternBegin, patternRealSize, p2)) >= 0) {
            result2.append(context, this.makeSharedString(context.runtime, p2, e - p2));
            p2 = e + pattern.getRealSize();
            if (!limit2 || lim > ++i2) continue;
        }
        if (realSize > 0 && (limit2 || realSize > p2 || lim < 0)) {
            result2.append(context, this.makeSharedString(context.runtime, p2, realSize - p2));
        }
        return result2;
    }

    private RubyArray stringSplit(ThreadContext context, RubyString spat, boolean limit2, int lim) {
        int e;
        this.mustnotBroken(context);
        RubyArray<?> result2 = Create.newArray(context);
        Encoding enc = this.checkEncoding(spat);
        ByteList pattern = spat.value;
        byte[] patternBytes = pattern.getUnsafeBytes();
        int patternBegin = pattern.getBegin();
        int patternRealSize = pattern.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        int begin2 = this.value.getBegin();
        int realSize = this.value.getRealSize();
        int p2 = 0;
        int i2 = 1;
        while (p2 < realSize && (e = RubyString.indexOf(bytes2, begin2, realSize, patternBytes, patternBegin, patternRealSize, p2, enc)) >= 0) {
            int t = enc.rightAdjustCharHead(bytes2, p2 + begin2, e + begin2, begin2 + realSize) - begin2;
            if (t != e) {
                p2 = t;
                continue;
            }
            result2.append(context, this.makeSharedString(context.runtime, p2, e - p2));
            p2 = e + pattern.getRealSize();
            if (!limit2 || lim > ++i2) continue;
            break;
        }
        if (realSize > 0 && (limit2 || realSize > p2 || lim < 0)) {
            result2.append(context, this.makeSharedString(context.runtime, p2, realSize - p2));
        }
        return result2;
    }

    static int asciiIndexOf(byte[] source2, int sourceOffset, int sourceCount, byte[] target2, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        byte first2 = target2[targetOffset];
        int max2 = sourceOffset + (sourceCount - targetCount);
        int i2 = sourceOffset + fromIndex;
        while (i2 <= max2) {
            while (i2 <= max2 && source2[i2] != first2) {
                ++i2;
            }
            if (i2 > max2) continue;
            int j = i2 + 1;
            int end2 = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end2 && source2[j] == target2[k]) {
                ++j;
                ++k;
            }
            if (j == end2) {
                return i2 - sourceOffset;
            }
            ++i2;
        }
        return -1;
    }

    static int indexOf(byte[] source2, int sourceOffset, int sourceCount, byte[] target2, int targetOffset, int targetCount, int fromIndex, Encoding enc) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        byte first2 = target2[targetOffset];
        int max2 = sourceOffset + (sourceCount - targetCount);
        int i2 = sourceOffset + fromIndex;
        while (i2 <= max2) {
            while (i2 <= max2 && source2[i2] != first2) {
                i2 += StringSupport.length(enc, source2, i2, sourceOffset + sourceCount);
            }
            if (i2 > max2) continue;
            int j = i2 + 1;
            int end2 = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end2 && source2[j] == target2[k]) {
                ++j;
                ++k;
            }
            if (j == end2) {
                return i2 - sourceOffset;
            }
            i2 += StringSupport.length(enc, source2, i2, sourceOffset + sourceCount);
        }
        return -1;
    }

    private static RubyString getStringForPattern(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubyString) {
            RubyString str = (RubyString)obj;
            return str;
        }
        IRubyObject val = obj.checkStringType();
        if (val.isNil()) {
            throw Error.typeError(context, obj, "Regexp");
        }
        return (RubyString)val;
    }

    private static RubyRegexp getPattern(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubyRegexp) {
            RubyRegexp regexp2 = (RubyRegexp)obj;
            return regexp2;
        }
        return RubyRegexp.newRegexpFromStr(context.runtime, RubyString.getStringForPattern(context, obj), 0);
    }

    private static IRubyObject getPatternQuoted(ThreadContext context, IRubyObject pat) {
        if (pat instanceof RubyRegexp) {
            RubyRegexp regexp2 = (RubyRegexp)pat;
            return regexp2;
        }
        if (pat instanceof RubyString) {
            return pat;
        }
        IRubyObject val = pat.checkStringType();
        if (val == context.nil) {
            TypeConverter.checkType(context, pat, Access.regexpClass(context));
        }
        return val;
    }

    @Override
    public RubyClass singletonClass(ThreadContext context) {
        if (this.isChilled()) {
            this.mutateChilledString();
        } else if (this.isFrozen()) {
            throw Error.typeError(context, "can't define singleton");
        }
        return super.singletonClass(context);
    }

    private static Object getScanPatternQuoted(ThreadContext context, IRubyObject pat) {
        RubyString str;
        if ((pat = RubyString.getPatternQuoted(context, pat)) instanceof RubyString && (str = (RubyString)pat).isBrokenString()) {
            throw context.runtime.newRegexpError("invalid byte sequence in " + String.valueOf(str.getEncoding()));
        }
        return pat;
    }

    @JRubyMethod(name={"scan"}, writes={FrameField.BACKREF})
    public IRubyObject scan(ThreadContext context, IRubyObject pat, Block block) {
        IRubyObject result2;
        RubyString str = this;
        int last2 = -1;
        int prev = 0;
        int[] startp = new int[]{0};
        pat = (IRubyObject)RubyString.getScanPatternQuoted(context, pat);
        this.mustnotBroken(context);
        if (!block.isGiven()) {
            IRubyObject result3;
            RubyArray<?> ary = null;
            while ((result3 = RubyString.scanOnce(context, str, pat, startp)) != context.nil) {
                last2 = prev;
                prev = startp[0];
                if (ary == null) {
                    ary = Create.allocArray(context, 4);
                }
                ary.append(context, result3);
            }
            if (last2 >= 0) {
                RubyString.patternSearch(context, pat, str, last2);
            }
            return ary == null ? Create.newEmptyArray(context) : ary;
        }
        byte[] pBytes = this.value.unsafeBytes();
        int len = this.value.realSize();
        while ((result2 = RubyString.scanOnce(context, str, pat, startp)) != context.nil) {
            last2 = prev;
            prev = startp[0];
            block.yieldSpecific(context, result2);
            str.modifyCheck(pBytes, len);
        }
        if (last2 >= 0) {
            RubyString.patternSearch(context, pat, str, last2);
        }
        return this;
    }

    private void mustnotBroken(ThreadContext context) {
        if (this.scanForCodeRange() == 48) {
            throw Error.argumentError(context, "invalid byte sequence in " + String.valueOf(this.getEncoding()));
        }
    }

    private static IRubyObject scanOnce(ThreadContext context, RubyString str, IRubyObject pat, int[] startp) {
        if (RubyString.patternSearch(context, pat, str, startp[0]) >= 0) {
            RubyMatchData match2 = context.getLocalMatch();
            int matchEnd = match2.end(0);
            if (match2.begin(0) == matchEnd) {
                Encoding enc = str.getEncoding();
                if (str.size() > matchEnd) {
                    ByteList strValue = str.value;
                    startp[0] = matchEnd + StringSupport.encFastMBCLen(strValue.unsafeBytes(), strValue.begin() + matchEnd, strValue.begin() + strValue.realSize(), enc);
                } else {
                    startp[0] = matchEnd + 1;
                }
            } else {
                startp[0] = matchEnd;
            }
            if (match2.numRegs() == 1) {
                return RubyRegexp.nth_match(context, 0, match2);
            }
            int size2 = match2.numRegs();
            RubyArray result2 = RubyArray.newBlankArrayInternal(context.runtime, size2 - 1);
            for (int i2 = 1; i2 < size2; ++i2) {
                result2.eltInternalSet(i2 - 1, RubyRegexp.nth_match(context, i2, match2));
            }
            result2.realLength = size2 - 1;
            return result2;
        }
        return context.nil;
    }

    private static int patternSearch(ThreadContext context, IRubyObject pattern, RubyString str, int pos2) {
        if (pattern instanceof RubyString) {
            RubyString strPattern = (RubyString)pattern;
            int beg = str.strseqIndex(strPattern, pos2, true);
            if (beg >= 0) {
                context.setLocalMatch(RubyString.setBackRefString(context, str, beg, strPattern));
            } else {
                context.clearLocalMatch();
                context.clearBackRef();
            }
            return beg;
        }
        int result2 = ((RubyRegexp)pattern).searchString(context, str, pos2, false);
        if (result2 >= 0) {
            context.setBackRef(context.getLocalMatch());
        } else {
            context.clearBackRef();
        }
        return result2;
    }

    private static RubyMatchData setBackRefString(ThreadContext context, RubyString str, int pos2, RubyString pattern) {
        RubyMatchData match2 = RubyRegexp.createMatchData(context, str, pos2, pattern);
        context.setBackRef(match2);
        return match2;
    }

    @JRubyMethod(name={"start_with?"})
    public IRubyObject start_with_p(ThreadContext context) {
        return context.fals;
    }

    @JRubyMethod(name={"start_with?"})
    public IRubyObject start_with_p(ThreadContext context, IRubyObject arg2) {
        boolean bl;
        if (arg2 instanceof RubyRegexp) {
            RubyRegexp regexp2 = (RubyRegexp)arg2;
            bl = regexp2.startsWith(context, this);
        } else {
            bl = this.startsWith(arg2.convertToString());
        }
        return Convert.asBoolean(context, bl);
    }

    @JRubyMethod(name={"start_with?"}, rest=true)
    public IRubyObject start_with_p(ThreadContext context, IRubyObject[] args2) {
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if (!this.start_with_p(context, args2[i2]).isTrue()) continue;
            return context.tru;
        }
        return context.fals;
    }

    public boolean startsWith(RubyString str) {
        this.checkEncoding(str);
        int otherLength = str.value.getRealSize();
        if (otherLength == 0) {
            return true;
        }
        if (this.value.getRealSize() < otherLength) {
            return false;
        }
        return this.value.startsWith(str.value);
    }

    @JRubyMethod(name={"end_with?"})
    public IRubyObject end_with_p(ThreadContext context) {
        return context.fals;
    }

    @JRubyMethod(name={"end_with?"})
    public IRubyObject end_with_p(ThreadContext context, IRubyObject arg2) {
        return Convert.asBoolean(context, this.endWith(arg2));
    }

    @JRubyMethod(name={"end_with?"}, rest=true)
    public IRubyObject end_with_p(ThreadContext context, IRubyObject[] args2) {
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if (!this.endWith(args2[i2])) continue;
            return context.tru;
        }
        return context.fals;
    }

    protected boolean endWith(IRubyObject tmp) {
        tmp = tmp.convertToString();
        ByteList tmpBL = ((RubyString)tmp).value;
        if (tmpBL.getRealSize() == 0) {
            return true;
        }
        Encoding enc = this.checkEncoding((RubyString)tmp);
        if (this.value.realSize() < tmpBL.realSize()) {
            return false;
        }
        int p2 = this.value.begin();
        int e = p2 + this.value.realSize();
        int s2 = e - tmpBL.realSize();
        if (!RubyString.atCharacterBoundary(this.value.unsafeBytes(), p2, e, s2, enc)) {
            return false;
        }
        return ByteList.memcmp(this.value.unsafeBytes(), s2, tmpBL.unsafeBytes(), tmpBL.begin(), tmpBL.realSize()) == 0;
    }

    private static boolean atCharacterBoundary(byte[] bytes2, int p2, int e, int s2, Encoding enc) {
        return s2 == e || enc.leftAdjustCharHead(bytes2, p2, s2, e) == s2;
    }

    public boolean endsWithAsciiChar(char c) {
        int size2;
        ByteList value2 = this.value;
        return value2.getEncoding().isAsciiCompatible() && (size2 = value2.realSize()) > 0 && value2.get(size2 - 1) == c;
    }

    @JRubyMethod(name={"delete_prefix"})
    public IRubyObject delete_prefix(ThreadContext context, IRubyObject prefix) {
        int prefixlen = this.deletedPrefixLength(prefix);
        return prefixlen <= 0 ? Create.dupString(context, this) : this.makeSharedString(context.runtime, prefixlen, this.size() - prefixlen);
    }

    @JRubyMethod(name={"delete_suffix"})
    public IRubyObject delete_suffix(ThreadContext context, IRubyObject suffix) {
        int suffixlen = this.deletedSuffixLength(suffix);
        return suffixlen <= 0 ? Create.dupString(context, this) : this.makeSharedString(context.runtime, 0, this.size() - suffixlen);
    }

    @JRubyMethod(name={"delete_prefix!"})
    public IRubyObject delete_prefix_bang(ThreadContext context, IRubyObject prefix) {
        this.modifyAndKeepCodeRange();
        int prefixlen = this.deletedPrefixLength(prefix);
        if (prefixlen <= 0) {
            return context.nil;
        }
        this.dropBytes(prefixlen);
        return this;
    }

    private void dropBytes(int prefixlen) {
        this.modify();
        this.value.view(prefixlen, this.value.realSize() - prefixlen);
        this.clearCodeRange();
    }

    @JRubyMethod(name={"delete_suffix!"})
    public IRubyObject delete_suffix_bang(ThreadContext context, IRubyObject suffix) {
        this.checkFrozen();
        int suffixlen = this.deletedSuffixLength(suffix);
        if (suffixlen <= 0) {
            return context.nil;
        }
        int olen = this.size();
        this.modifyAndKeepCodeRange();
        int len = olen - suffixlen;
        this.value.realSize(len);
        if (!this.isCodeRangeAsciiOnly()) {
            this.clearCodeRange();
        }
        return this;
    }

    private int deletedPrefixLength(IRubyObject _prefix) {
        int prefixptr;
        byte[] prefixBytes;
        int strptr;
        RubyString prefix = _prefix.convertToString();
        if (prefix.isBrokenString()) {
            return 0;
        }
        this.checkEncoding(prefix);
        int prefixlen = prefix.size();
        if (prefixlen <= 0) {
            return 0;
        }
        int olen = this.size();
        if (olen < prefixlen) {
            return 0;
        }
        byte[] strBytes = this.value.unsafeBytes();
        if (ByteList.memcmp(strBytes, strptr = this.value.begin(), prefixBytes = prefix.value.unsafeBytes(), prefixptr = prefix.value.begin(), prefixlen) != 0) {
            return 0;
        }
        return prefixlen;
    }

    private int deletedSuffixLength(IRubyObject _suffix) {
        int suffixptr;
        byte[] suffixBytes;
        int strptr;
        int s2;
        RubyString suffix = _suffix.convertToString();
        if (suffix.isBrokenString()) {
            return 0;
        }
        Encoding enc = this.checkEncoding(suffix);
        int suffixlen = suffix.size();
        if (suffixlen <= 0) {
            return 0;
        }
        int olen = this.size();
        if (olen < suffixlen) {
            return 0;
        }
        byte[] strBytes = this.value.unsafeBytes();
        if (ByteList.memcmp(strBytes, s2 = (strptr = this.value.begin()) + olen - suffixlen, suffixBytes = suffix.value.unsafeBytes(), suffixptr = suffix.value.begin(), suffixlen) != 0) {
            return 0;
        }
        if (enc.leftAdjustCharHead(strBytes, strptr, s2, strptr + olen) != s2) {
            return 0;
        }
        return suffixlen;
    }

    private IRubyObject justify(ThreadContext context, IRubyObject arg0, int jflag) {
        RubyString result2 = this.justifyCommon(context, SPACE_BYTELIST, 1, true, EncodingUtils.STR_ENC_GET(this), Convert.toInt(context, arg0), jflag);
        if (this.getCodeRange() != 48) {
            result2.setCodeRange(this.getCodeRange());
        }
        return result2;
    }

    private IRubyObject justify(ThreadContext context, IRubyObject arg0, IRubyObject arg1, int jflag) {
        int cr;
        RubyString padStr = arg1.convertToString();
        ByteList pad = padStr.value;
        Encoding enc = this.checkEncoding(padStr);
        int padCharLen = StringSupport.strLengthFromRubyString(padStr, enc);
        if (pad.getRealSize() == 0 || padCharLen == 0) {
            throw Error.argumentError(context, "zero width padding");
        }
        int width = Convert.toInt(context, arg0);
        RubyString result2 = this.justifyCommon(context, pad, padCharLen, padStr.singleByteOptimizable(), enc, width, jflag);
        if (result2.strLength() > this.strLength()) {
            // empty if block
        }
        if ((cr = CodeRangeSupport.codeRangeAnd(this.getCodeRange(), padStr.getCodeRange())) != 48) {
            result2.setCodeRange(cr);
        }
        return result2;
    }

    private RubyString justifyCommon(ThreadContext context, ByteList pad, int padCharLen, boolean padSinglebyte, Encoding enc, int width, int jflag) {
        int padPP;
        int len = StringSupport.strLengthFromRubyString(this, enc);
        if (width < 0 || len >= width) {
            return Create.dupString(context, this);
        }
        int n = width - len;
        int llen = jflag == 108 ? 0 : (jflag == 114 ? n : n / 2);
        int rlen = n - llen;
        int padP = pad.getBegin();
        int padLen = pad.getRealSize();
        byte[] padBytes = pad.getUnsafeBytes();
        ByteList res = new ByteList(this.value.getRealSize() + n * padLen / padCharLen + 2);
        int p2 = res.getBegin();
        byte[] bytes2 = res.getUnsafeBytes();
        while (llen > 0) {
            if (padLen <= 1) {
                bytes2[p2++] = padBytes[padP];
                --llen;
                continue;
            }
            if (llen > padCharLen) {
                System.arraycopy(padBytes, padP, bytes2, p2, padLen);
                p2 += padLen;
                llen -= padCharLen;
                continue;
            }
            padPP = padSinglebyte ? padP + llen : StringSupport.nth(enc, padBytes, padP, padP + padLen, llen);
            n = padPP - padP;
            System.arraycopy(padBytes, padP, bytes2, p2, n);
            p2 += n;
            break;
        }
        System.arraycopy(this.value.getUnsafeBytes(), this.value.getBegin(), bytes2, p2, this.value.getRealSize());
        p2 += this.value.getRealSize();
        while (rlen > 0) {
            if (padLen <= 1) {
                bytes2[p2++] = padBytes[padP];
                --rlen;
                continue;
            }
            if (rlen > padCharLen) {
                System.arraycopy(padBytes, padP, bytes2, p2, padLen);
                p2 += padLen;
                rlen -= padCharLen;
                continue;
            }
            padPP = padSinglebyte ? padP + rlen : StringSupport.nth(enc, padBytes, padP, padP + padLen, rlen);
            n = padPP - padP;
            System.arraycopy(padBytes, padP, bytes2, p2, n);
            p2 += n;
            break;
        }
        res.setRealSize(p2);
        RubyString result2 = Create.newString(context, res);
        if (result2.strLength() > this.strLength()) {
            // empty if block
        }
        result2.associateEncoding(enc);
        return result2;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject ljust(IRubyObject arg0) {
        return this.ljust(this.getCurrentContext(), arg0);
    }

    @JRubyMethod(name={"ljust"})
    public IRubyObject ljust(ThreadContext context, IRubyObject arg0) {
        return this.justify(context, arg0, 108);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject ljust(IRubyObject arg0, IRubyObject arg1) {
        return this.ljust(this.getCurrentContext(), arg0, arg1);
    }

    @JRubyMethod(name={"ljust"})
    public IRubyObject ljust(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.justify(context, arg0, arg1, 108);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject rjust(IRubyObject arg0) {
        return this.rjust(this.getCurrentContext(), arg0);
    }

    @JRubyMethod(name={"rjust"})
    public IRubyObject rjust(ThreadContext context, IRubyObject arg0) {
        return this.justify(context, arg0, 114);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject rjust(IRubyObject arg0, IRubyObject arg1) {
        return this.rjust(this.getCurrentContext(), arg0, arg1);
    }

    @JRubyMethod(name={"rjust"})
    public IRubyObject rjust(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.justify(context, arg0, arg1, 114);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject center(IRubyObject arg0) {
        return this.center(this.getCurrentContext(), arg0);
    }

    @JRubyMethod(name={"center"})
    public IRubyObject center(ThreadContext context, IRubyObject arg0) {
        return this.justify(context, arg0, 99);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject center(IRubyObject arg0, IRubyObject arg1) {
        return this.center(this.getCurrentContext(), arg0, arg1);
    }

    @JRubyMethod(name={"center"})
    public IRubyObject center(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.justify(context, arg0, arg1, 99);
    }

    @JRubyMethod(reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject partition(ThreadContext context, Block block) {
        return RubyEnumerable.partition(context, this, block);
    }

    @JRubyMethod(reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject partition(ThreadContext context, IRubyObject arg2, Block block) {
        RubyString sep;
        int pos2;
        if (arg2 instanceof RubyRegexp) {
            RubyRegexp regexp2 = (RubyRegexp)arg2;
            if (regexp2.search(context, this, 0, false) < 0) {
                return this.partitionMismatch(context);
            }
            RubyMatchData match2 = context.getLocalMatch();
            pos2 = match2.begin(0);
            sep = this.makeSharedString(context.runtime, pos2, match2.end(0) - pos2);
        } else {
            IRubyObject tmp = arg2.checkStringType();
            if (tmp.isNil()) {
                throw Error.typeError(context, "type mismatch: ", arg2, " given");
            }
            sep = (RubyString)tmp;
            pos2 = StringSupport.index(this, sep, 0, this.checkEncoding(sep));
            if (pos2 < 0) {
                return this.partitionMismatch(context);
            }
        }
        return Create.newArrayNoCopy(context, this.makeSharedString(context.runtime, 0, pos2), sep, this.makeSharedString(context.runtime, pos2 + sep.value.getRealSize(), this.value.getRealSize() - pos2 - sep.value.getRealSize()));
    }

    private RubyArray partitionMismatch(ThreadContext context) {
        Encoding enc = this.getEncoding();
        return RubyArray.newArrayMayCopy(context.runtime, Create.dupString(context, this), RubyString.newEmptyString(context.runtime, enc), RubyString.newEmptyString(context.runtime, enc));
    }

    @JRubyMethod(name={"rpartition"}, writes={FrameField.BACKREF})
    public IRubyObject rpartition(ThreadContext context, IRubyObject arg2) {
        RubyString sep;
        int pos2;
        if (arg2 instanceof RubyRegexp) {
            tmp = this.rindex(context, arg2);
            if (tmp.isNil()) {
                return this.rpartitionMismatch(context);
            }
            pos2 = Convert.toInt(context, tmp);
            sep = (RubyString)RubyRegexp.nth_match(context, 0, context.getLocalMatchOrNil());
        } else {
            tmp = arg2.checkStringType();
            if (tmp.isNil()) {
                throw Error.typeError(context, "type mismatch: ", arg2, " given");
            }
            sep = (RubyString)tmp;
            pos2 = StringSupport.rindex(this.value, StringSupport.strLengthFromRubyString(this, this.checkEncoding(sep)), StringSupport.strLengthFromRubyString(sep, this.checkEncoding(sep)), this.subLength(this.value.getRealSize()), sep, this.checkEncoding(sep));
            if (pos2 < 0) {
                return this.rpartitionMismatch(context);
            }
        }
        int beg = pos2 + sep.strLength();
        int len = this.value.getRealSize();
        return Create.newArrayNoCopy(context, this.substrEnc(context, 0, pos2), sep, this.substrEnc(context, beg, len));
    }

    private IRubyObject rpartitionMismatch(ThreadContext context) {
        Encoding enc = this.getEncoding();
        return Create.newArrayNoCopy(context, RubyString.newEmptyString(context.runtime, enc), RubyString.newEmptyString(context.runtime, enc), Create.dupString(context, this));
    }

    @JRubyMethod(rest=true)
    public IRubyObject append_as_bytes(ThreadContext context, IRubyObject[] args2) {
        int neededCapacity = 0;
        for (IRubyObject arg2 : args2) {
            neededCapacity += RubyString.byteCapacityFor(context, arg2);
        }
        this.ensureAvailable(context, neededCapacity);
        for (IRubyObject arg2 : args2) {
            this.appendBytes(context, arg2);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject append_as_bytes(ThreadContext context) {
        this.ensureAvailable(context, 0);
        return this;
    }

    @JRubyMethod
    public IRubyObject append_as_bytes(ThreadContext context, IRubyObject arg0) {
        this.ensureAvailable(context, RubyString.byteCapacityFor(context, arg0));
        this.appendBytes(context, arg0);
        return this;
    }

    private static int byteCapacityFor(ThreadContext context, IRubyObject arg2) {
        IRubyObject iRubyObject = arg2;
        Objects.requireNonNull(iRubyObject);
        IRubyObject iRubyObject2 = iRubyObject;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RubyInteger.class, RubyString.class}, (Object)iRubyObject2, n)) {
            case 0 -> {
                RubyInteger ignored = (RubyInteger)iRubyObject2;
                yield 1;
            }
            case 1 -> {
                RubyString str = (RubyString)iRubyObject2;
                yield str.getByteList().realSize();
            }
            default -> throw Error.typeError(context, RubyStringBuilder.str(context.runtime, "wrong argument type ", RubyStringBuilder.types(context.runtime, (RubyModule)arg2.getType()), " (expected String or Integer)"));
        };
    }

    private void appendBytes(ThreadContext context, IRubyObject arg2) {
        IRubyObject iRubyObject = arg2;
        Objects.requireNonNull(iRubyObject);
        IRubyObject iRubyObject2 = iRubyObject;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RubyFixnum.class, RubyBignum.class, RubyString.class}, (Object)iRubyObject2, n)) {
            case 0: {
                RubyFixnum fix2 = (RubyFixnum)iRubyObject2;
                this.cat(fix2.asInt(context) & 0xFF);
                break;
            }
            case 1: {
                RubyBignum big = (RubyBignum)iRubyObject2;
                this.cat(big.asBigInteger(context).intValue() & 0xFF);
                break;
            }
            case 2: {
                RubyString str = (RubyString)iRubyObject2;
                this.value.append(str.getByteList());
                break;
            }
            default: {
                throw Error.runtimeError(context, "BUG: append_as_bytes arguments should have been validated");
            }
        }
    }

    @JRubyMethod(name={"chop"})
    public IRubyObject chop(ThreadContext context) {
        return this.value.isEmpty() ? RubyString.newEmptyString(context.runtime, Access.stringClass(context), this.value.getEncoding()) : this.makeSharedString(context.runtime, 0, StringSupport.choppedLength(this));
    }

    @JRubyMethod(name={"chop!"})
    public IRubyObject chop_bang(ThreadContext context) {
        this.modifyAndKeepCodeRange();
        if (this.size() > 0) {
            int len = StringSupport.choppedLength(this);
            this.value.realSize(len);
            if (this.getCodeRange() != 16) {
                this.clearCodeRange();
            }
            return this;
        }
        return context.nil;
    }

    @Deprecated(since="10.0.0.0")
    public RubyString chomp19(ThreadContext context) {
        return this.chomp(context);
    }

    @Deprecated(since="10.0.0.0")
    public RubyString chomp19(ThreadContext context, IRubyObject arg0) {
        return this.chomp(context, arg0);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject chomp_bang19(ThreadContext context) {
        return this.chomp_bang(context);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject chomp_bang19(ThreadContext context, IRubyObject arg0) {
        return this.chomp_bang(context, arg0);
    }

    @JRubyMethod(name={"chomp"})
    public RubyString chomp(ThreadContext context) {
        RubyString str = Create.dupString(context, this);
        str.chomp_bang(context);
        return str;
    }

    @JRubyMethod(name={"chomp"})
    public RubyString chomp(ThreadContext context, IRubyObject arg0) {
        RubyString str = Create.dupString(context, this);
        str.chomp_bang(context, arg0);
        return str;
    }

    @JRubyMethod(name={"chomp!"})
    public IRubyObject chomp_bang(ThreadContext context) {
        this.modifyCheck();
        if (this.value.isEmpty()) {
            return context.nil;
        }
        GlobalVariables globalVariables = Access.globalVariables(context);
        IRubyObject rsObj = globalVariables.get("$/");
        return rsObj == globalVariables.getDefaultSeparator() ? this.smartChopBangCommon(context) : this.chompBangCommon(context, rsObj);
    }

    @JRubyMethod(name={"chomp!"})
    public IRubyObject chomp_bang(ThreadContext context, IRubyObject arg0) {
        this.modifyCheck();
        if (this.value.isEmpty()) {
            return context.nil;
        }
        return this.chompBangCommon(context, arg0);
    }

    private IRubyObject chompBangCommon(ThreadContext context, IRubyObject rsObj) {
        if (rsObj.isNil()) {
            return rsObj;
        }
        RubyString rs = rsObj.convertToString();
        int p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int end2 = p2 + len;
        byte[] bytes2 = this.value.getUnsafeBytes();
        int rslen = rs.value.getRealSize();
        if (rslen == 0) {
            while (len > 0 && bytes2[p2 + len - 1] == 10) {
                if (--len <= 0 || bytes2[p2 + len - 1] != 13) continue;
                --len;
            }
            if (len < this.value.getRealSize()) {
                this.keepCodeRange();
                this.view(0, len);
                return this;
            }
            return context.nil;
        }
        if (rslen > len) {
            return context.nil;
        }
        byte newline = rs.value.getUnsafeBytes()[rslen - 1];
        if (rslen == 1 && newline == 10) {
            return this.smartChopBangCommon(context);
        }
        Encoding enc = this.checkEncoding(rs);
        if (rs.scanForCodeRange() == 48) {
            return context.nil;
        }
        int pp = end2 - rslen;
        if (bytes2[p2 + len - 1] == newline && rslen <= 1 || this.value.endsWith(rs.value)) {
            if (enc.leftAdjustCharHead(bytes2, p2, pp, end2) != pp) {
                return context.nil;
            }
            if (this.getCodeRange() != 16) {
                this.clearCodeRange();
            }
            this.view(0, this.value.getRealSize() - rslen);
            return this;
        }
        return context.nil;
    }

    private IRubyObject smartChopBangCommon(ThreadContext context) {
        int p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int end2 = p2 + len;
        byte[] bytes2 = this.value.getUnsafeBytes();
        Encoding enc = this.value.getEncoding();
        this.keepCodeRange();
        if (enc.minLength() > 1) {
            int pp = enc.leftAdjustCharHead(bytes2, p2, end2 - enc.minLength(), end2);
            if (enc.isNewLine(bytes2, pp, end2)) {
                end2 = pp;
            }
            if ((pp = end2 - enc.minLength()) >= p2 && StringSupport.preciseLength(enc, bytes2, pp = enc.leftAdjustCharHead(bytes2, p2, pp, end2), end2) > 0 && enc.mbcToCode(bytes2, pp, end2) == 13) {
                end2 = pp;
            }
            if (end2 == p2 + this.value.getRealSize()) {
                this.modifyCheck();
                return context.nil;
            }
            len = end2 - p2;
            this.view(0, len);
        } else if (bytes2[p2 + len - 1] == 10) {
            if (--len > 0 && bytes2[p2 + len - 1] == 13) {
                --len;
            }
            this.view(0, len);
        } else if (bytes2[p2 + len - 1] == 13) {
            this.view(0, --len);
        } else {
            this.modifyCheck();
            return context.nil;
        }
        return this;
    }

    @JRubyMethod(name={"lstrip"})
    public IRubyObject lstrip(ThreadContext context) {
        RubyString str = Create.dupString(context, this);
        str.lstrip_bang(context);
        return str;
    }

    @JRubyMethod(name={"lstrip!"})
    public IRubyObject lstrip_bang(ThreadContext context) {
        this.modifyCheck();
        ByteList value2 = this.value;
        if (value2.getRealSize() == 0) {
            return context.nil;
        }
        int s2 = value2.getBegin();
        int end2 = s2 + value2.getRealSize();
        byte[] bytes2 = value2.getUnsafeBytes();
        Encoding enc = EncodingUtils.STR_ENC_GET(this);
        IRubyObject result2 = this.singleByteOptimizable(enc) ? this.singleByteLStrip(context, bytes2, s2, end2) : this.multiByteLStrip(context, enc, bytes2, s2, end2);
        this.keepCodeRange();
        return result2;
    }

    private IRubyObject singleByteLStrip(ThreadContext context, byte[] bytes2, int s2, int end2) {
        int p2;
        for (p2 = s2; p2 < end2 && (bytes2[p2] == 0 || ASCII.isSpace(bytes2[p2] & 0xFF)); ++p2) {
        }
        if (p2 > s2) {
            this.view(p2 - s2, end2 - p2);
            return this;
        }
        return context.nil;
    }

    private IRubyObject multiByteLStrip(ThreadContext context, Encoding enc, byte[] bytes2, int s2, int end2) {
        int p2;
        int c;
        for (p2 = s2; p2 < end2 && (ASCII.isSpace(c = StringSupport.codePoint(context, enc, bytes2, p2, end2)) || c == 0); p2 += StringSupport.codeLength(enc, c)) {
        }
        if (p2 > s2) {
            this.view(p2 - s2, end2 - p2);
            return this;
        }
        return context.nil;
    }

    @JRubyMethod(name={"rstrip"})
    public IRubyObject rstrip(ThreadContext context) {
        RubyString str = Create.dupString(context, this);
        str.rstrip_bang(context);
        return str;
    }

    @JRubyMethod(name={"rstrip!"})
    public IRubyObject rstrip_bang(ThreadContext context) {
        this.modifyCheck();
        if (this.value.getRealSize() == 0) {
            return context.nil;
        }
        this.checkDummyEncoding();
        Encoding enc = EncodingUtils.STR_ENC_GET(this);
        IRubyObject result2 = this.singleByteOptimizable(enc) ? this.singleByteRStrip(context) : this.multiByteRStrip(context);
        this.keepCodeRange();
        return result2;
    }

    private IRubyObject singleByteRStrip(ThreadContext context) {
        int endp;
        byte[] bytes2 = this.value.getUnsafeBytes();
        int start2 = this.value.getBegin();
        int end2 = start2 + this.value.getRealSize();
        for (endp = end2 - 1; endp >= start2 && (bytes2[endp] == 0 || ASCII.isSpace(bytes2[endp] & 0xFF)); --endp) {
        }
        if (endp < end2 - 1) {
            this.view(0, endp - start2 + 1);
            return this;
        }
        return context.nil;
    }

    private IRubyObject multiByteRStrip(ThreadContext context) {
        int prev;
        byte[] bytes2 = this.value.getUnsafeBytes();
        int start2 = this.value.getBegin();
        int end2 = start2 + this.value.getRealSize();
        Encoding enc = EncodingUtils.STR_ENC_GET(this);
        int endp = end2;
        while ((prev = enc.prevCharHead(bytes2, start2, endp, end2)) != -1) {
            int point;
            try {
                point = StringSupport.codePoint(enc, bytes2, prev, end2);
            }
            catch (IllegalArgumentException e) {
                throw context.runtime.newEncodingCompatibilityError(e.getMessage());
            }
            if (point != 0 && !ASCII.isSpace(point)) break;
            endp = prev;
        }
        if (endp < end2) {
            this.view(0, endp - start2);
            return this;
        }
        return context.nil;
    }

    @JRubyMethod(name={"strip"})
    public IRubyObject strip(ThreadContext context) {
        RubyString str = Create.dupString(context, this);
        str.strip_bang(context);
        return str;
    }

    @JRubyMethod(name={"strip!"})
    public IRubyObject strip_bang(ThreadContext context) {
        this.modifyCheck();
        IRubyObject left2 = this.lstrip_bang(context);
        IRubyObject right = this.rstrip_bang(context);
        return left2 == context.nil && right == context.nil ? context.nil : this;
    }

    @JRubyMethod(name={"count"})
    public IRubyObject count(ThreadContext context) {
        throw Error.argumentError(context, "wrong number of arguments");
    }

    @JRubyMethod(name={"count"})
    public IRubyObject count(ThreadContext context, IRubyObject arg2) {
        int size2;
        int begin2;
        byte[] countBytes;
        RubyString countStr = arg2.convertToString();
        ByteList countValue = countStr.getByteList();
        Encoding enc = this.checkEncoding(countStr);
        if (countValue.length() == 1 && enc.isAsciiCompatible() && enc.isReverseMatchAllowed(countBytes = countValue.unsafeBytes(), begin2 = countValue.begin(), begin2 + (size2 = countValue.length())) && !this.isCodeRangeBroken()) {
            if (this.value.isEmpty()) {
                return Convert.asFixnum(context, 0);
            }
            int n = 0;
            int[] len_p = new int[]{0};
            int c = EncodingUtils.encCodepointLength(context, countBytes, begin2, begin2 + size2, len_p, enc);
            byte[] bytes2 = this.value.unsafeBytes();
            int i2 = this.value.begin();
            int end2 = i2 + this.value.length();
            while (i2 < end2) {
                if ((bytes2[i2++] & 0xFF) != c) continue;
                ++n;
            }
            return Convert.asFixnum(context, n);
        }
        boolean[] table = new boolean[257];
        StringSupport.TrTables tables = StringSupport.trSetupTable(context, countValue, table, null, true, enc);
        return Convert.asFixnum(context, StringSupport.strCount(context, this.value, table, tables, enc));
    }

    @JRubyMethod(name={"count"}, required=1, rest=true, checkArity=false)
    public IRubyObject count(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 1, -1);
        if (this.value.isEmpty()) {
            return Convert.asFixnum(context, 0);
        }
        RubyString countStr = args2[0].convertToString();
        Encoding enc = this.checkEncoding(countStr);
        boolean[] table = new boolean[257];
        StringSupport.TrTables tables = StringSupport.trSetupTable(context, countStr.value, table, null, true, enc);
        for (int i2 = 1; i2 < argc; ++i2) {
            countStr = args2[i2].convertToString();
            enc = this.checkEncoding(countStr);
            tables = StringSupport.trSetupTable(context, countStr.value, table, tables, false, enc);
        }
        return Convert.asFixnum(context, StringSupport.strCount(context, this.value, table, tables, enc));
    }

    @JRubyMethod(name={"delete"})
    public IRubyObject delete(ThreadContext context) {
        throw Error.argumentError(context, "wrong number of arguments");
    }

    @JRubyMethod(name={"delete"})
    public IRubyObject delete(ThreadContext context, IRubyObject arg2) {
        RubyString str = Create.dupString(context, this);
        str.delete_bang(context, arg2);
        return str;
    }

    @JRubyMethod(name={"delete"}, required=1, rest=true, checkArity=false)
    public IRubyObject delete(ThreadContext context, IRubyObject[] args2) {
        RubyString str = Create.dupString(context, this);
        str.delete_bang(context, args2);
        return str;
    }

    @JRubyMethod(name={"delete!"})
    public IRubyObject delete_bang(ThreadContext context) {
        throw Error.argumentError(context, "wrong number of arguments");
    }

    @JRubyMethod(name={"delete!"})
    public IRubyObject delete_bang(ThreadContext context, IRubyObject arg2) {
        if (this.value.isEmpty()) {
            return context.nil;
        }
        boolean[] squeeze2 = new boolean[257];
        RubyString otherStr = arg2.convertToString();
        Encoding enc = this.checkEncoding(otherStr);
        StringSupport.TrTables tables = StringSupport.trSetupTable(context, otherStr.value, squeeze2, null, true, enc);
        return StringSupport.strDeleteBang(context, this, squeeze2, tables, enc) == null ? context.nil : this;
    }

    @JRubyMethod(name={"delete!"}, required=1, rest=true, checkArity=false)
    public IRubyObject delete_bang(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 1, -1);
        if (this.value.isEmpty()) {
            return context.nil;
        }
        Encoding enc = null;
        boolean[] squeeze2 = new boolean[257];
        StringSupport.TrTables tables = null;
        for (int i2 = 0; i2 < argc; ++i2) {
            RubyString otherStr = args2[i2].convertToString();
            enc = this.checkEncoding(otherStr);
            tables = StringSupport.trSetupTable(context, otherStr.value, squeeze2, tables, i2 == 0, enc);
        }
        return StringSupport.strDeleteBang(context, this, squeeze2, tables, enc) == null ? context.nil : this;
    }

    @JRubyMethod(name={"squeeze"})
    public IRubyObject squeeze(ThreadContext context) {
        RubyString str = Create.dupString(context, this);
        str.squeeze_bang(context);
        return str;
    }

    @JRubyMethod(name={"squeeze"})
    public IRubyObject squeeze(ThreadContext context, IRubyObject arg2) {
        RubyString str = Create.dupString(context, this);
        str.squeeze_bang(context, arg2);
        return str;
    }

    @JRubyMethod(name={"squeeze"}, required=1, rest=true, checkArity=false)
    public IRubyObject squeeze(ThreadContext context, IRubyObject[] args2) {
        RubyString str = Create.dupString(context, this);
        str.squeeze_bang(context, args2);
        return str;
    }

    @JRubyMethod(name={"squeeze!"})
    public IRubyObject squeeze_bang(ThreadContext context) {
        if (this.value.isEmpty()) {
            this.modifyCheck();
            return context.nil;
        }
        boolean[] squeeze2 = new boolean[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            squeeze2[i2] = true;
        }
        this.modifyAndKeepCodeRange();
        if (this.singleByteOptimizable() ? !StringSupport.singleByteSqueeze(this.value, squeeze2) : !StringSupport.multiByteSqueeze(context, this.value, squeeze2, null, this.value.getEncoding(), false)) {
            return context.nil;
        }
        return this;
    }

    @JRubyMethod(name={"squeeze!"})
    public IRubyObject squeeze_bang(ThreadContext context, IRubyObject arg2) {
        RubyString otherStr = arg2.convertToString();
        boolean[] squeeze2 = new boolean[257];
        StringSupport.TrTables tables = StringSupport.trSetupTable(context, otherStr.value, squeeze2, null, true, this.checkEncoding(otherStr));
        this.modifyAndKeepCodeRange();
        if (this.singleByteOptimizable() && otherStr.singleByteOptimizable() ? !StringSupport.singleByteSqueeze(this.value, squeeze2) : !StringSupport.multiByteSqueeze(context, this.value, squeeze2, tables, this.value.getEncoding(), true)) {
            return context.nil;
        }
        return this;
    }

    @JRubyMethod(name={"squeeze!"}, required=1, rest=true, checkArity=false)
    public IRubyObject squeeze_bang(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 1, -1);
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return context.nil;
        }
        RubyString otherStr = args2[0].convertToString();
        Encoding enc = this.checkEncoding(otherStr);
        boolean[] squeeze2 = new boolean[257];
        StringSupport.TrTables tables = StringSupport.trSetupTable(context, otherStr.value, squeeze2, null, true, enc);
        boolean singleByte = this.singleByteOptimizable() && otherStr.singleByteOptimizable();
        for (int i2 = 1; i2 < argc; ++i2) {
            otherStr = args2[i2].convertToString();
            enc = this.checkEncoding(otherStr);
            singleByte = singleByte && otherStr.singleByteOptimizable();
            tables = StringSupport.trSetupTable(context, otherStr.value, squeeze2, tables, false, enc);
        }
        this.modifyAndKeepCodeRange();
        if (singleByte ? !StringSupport.singleByteSqueeze(this.value, squeeze2) : !StringSupport.multiByteSqueeze(context, this.value, squeeze2, tables, enc, true)) {
            return context.nil;
        }
        return this;
    }

    @Deprecated(since="9.2.0.0")
    public IRubyObject tr19(ThreadContext context, IRubyObject src, IRubyObject repl) {
        return this.tr(context, src, repl);
    }

    @Deprecated(since="9.2.0.0")
    public IRubyObject tr_bang19(ThreadContext context, IRubyObject src, IRubyObject repl) {
        return this.tr_bang(context, src, repl);
    }

    @JRubyMethod(name={"tr"})
    public IRubyObject tr(ThreadContext context, IRubyObject src, IRubyObject repl) {
        RubyString str = Create.dupString(context, this);
        str.trTrans(context, src, repl, false);
        return str;
    }

    @JRubyMethod(name={"tr!"})
    public IRubyObject tr_bang(ThreadContext context, IRubyObject src, IRubyObject repl) {
        return this.trTrans(context, src, repl, false);
    }

    private IRubyObject trTrans(ThreadContext context, IRubyObject src, IRubyObject repl, boolean sflag) {
        RubyString replStr = repl.convertToString();
        ByteList replList = replStr.value;
        RubyString srcStr = src.convertToString();
        if (this.value.getRealSize() == 0) {
            return context.nil;
        }
        if (replList.getRealSize() == 0) {
            return this.delete_bang(context, src);
        }
        CodeRangeable ret = this.trTransHelper(context, srcStr, replStr, sflag);
        return ret == null ? context.nil : (IRubyObject)((Object)ret);
    }

    private CodeRangeable trTransHelper(ThreadContext context, CodeRangeable srcStr, CodeRangeable replStr, boolean sflag) {
        try {
            return StringSupport.trTransHelper(this, srcStr, replStr, sflag);
        }
        catch (IllegalArgumentException e) {
            throw Error.argumentError(context, e.getMessage());
        }
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject tr_s19(ThreadContext context, IRubyObject src, IRubyObject repl) {
        return this.tr_s(context, src, repl);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject tr_s_bang19(ThreadContext context, IRubyObject src, IRubyObject repl) {
        return this.tr_s_bang(context, src, repl);
    }

    @JRubyMethod(name={"tr_s"})
    public IRubyObject tr_s(ThreadContext context, IRubyObject src, IRubyObject repl) {
        RubyString str = Create.dupString(context, this);
        str.trTrans(context, src, repl, true);
        return str;
    }

    @JRubyMethod(name={"tr_s!"})
    public IRubyObject tr_s_bang(ThreadContext context, IRubyObject src, IRubyObject repl) {
        return this.trTrans(context, src, repl, true);
    }

    @JRubyMethod(name={"each_line"})
    public IRubyObject each_line(ThreadContext context, Block block) {
        return StringSupport.rbStrEnumerateLines(this, context, "each_line", Access.globalVariables(context).get("$/"), block, false);
    }

    @JRubyMethod(name={"each_line"})
    public IRubyObject each_line(ThreadContext context, IRubyObject arg2, Block block) {
        return StringSupport.rbStrEnumerateLines(this, context, "each_line", arg2, block, false);
    }

    @JRubyMethod(name={"each_line"})
    public IRubyObject each_line(ThreadContext context, IRubyObject arg2, IRubyObject opts, Block block) {
        return StringSupport.rbStrEnumerateLines(this, context, "each_line", arg2, opts, block, false);
    }

    @Deprecated
    public IRubyObject each_lineCommon(ThreadContext context, IRubyObject sep, Block block) {
        if (sep == context.nil) {
            block.yield(context, this);
            return this;
        }
        RubyString sepStr = sep.convertToString();
        ByteList sepValue = sepStr.value;
        int rslen = sepValue.getRealSize();
        byte newline = rslen == 0 ? (byte)10 : sepValue.getUnsafeBytes()[sepValue.getBegin() + rslen - 1];
        int p2 = this.value.getBegin();
        int end2 = p2 + this.value.getRealSize();
        int ptr = p2;
        int s2 = p2;
        int len = this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        p2 += rslen;
        while (p2 < end2) {
            if (rslen == 0 && bytes2[p2] == 10) {
                if (++p2 != end2 && bytes2[p2] == 10) {
                    while (p2 < end2 && bytes2[p2] == 10) {
                        ++p2;
                    }
                }
            } else if (ptr < p2 && bytes2[p2 - 1] == newline && (rslen <= 1 || ByteList.memcmp(sepValue.getUnsafeBytes(), sepValue.getBegin(), rslen, bytes2, p2 - rslen, rslen) == 0)) {
                block.yield(context, this.makeShared(context.runtime, s2 - ptr, p2 - s2));
                this.modifyCheck(bytes2, len);
                s2 = p2;
            }
            ++p2;
        }
        if (s2 != end2) {
            if (p2 > end2) {
                p2 = end2;
            }
            block.yield(context, this.makeShared(context.runtime, s2 - ptr, p2 - s2));
        }
        return this;
    }

    @JRubyMethod(name={"lines"})
    public IRubyObject lines(ThreadContext context, Block block) {
        return StringSupport.rbStrEnumerateLines(this, context, "lines", Access.globalVariables(context).get("$/"), block, true);
    }

    @JRubyMethod(name={"lines"})
    public IRubyObject lines(ThreadContext context, IRubyObject arg2, Block block) {
        return StringSupport.rbStrEnumerateLines(this, context, "lines", arg2, block, true);
    }

    @JRubyMethod(name={"lines"})
    public IRubyObject lines(ThreadContext context, IRubyObject arg2, IRubyObject opts, Block block) {
        return StringSupport.rbStrEnumerateLines(this, context, "lines", arg2, opts, block, true);
    }

    @JRubyMethod(name={"each_byte"})
    public IRubyObject each_byte(ThreadContext context, Block block) {
        return this.enumerateBytes(context, "each_byte", block, false);
    }

    @JRubyMethod
    public IRubyObject bytes(ThreadContext context, Block block) {
        return this.enumerateBytes(context, "bytes", block, true);
    }

    @JRubyMethod(name={"each_char"})
    public IRubyObject each_char(ThreadContext context, Block block) {
        return this.enumerateChars(context, "each_char", block, false);
    }

    @JRubyMethod(name={"chars"})
    public IRubyObject chars(ThreadContext context, Block block) {
        return this.enumerateChars(context, "chars", block, true);
    }

    private static IRubyObject eachCharSize(ThreadContext context, RubyString recv2, IRubyObject[] args2) {
        return recv2.rubyLength(context);
    }

    @JRubyMethod
    public IRubyObject each_codepoint(ThreadContext context, Block block) {
        return this.enumerateCodepoints(context, "each_codepoint", block, false);
    }

    @JRubyMethod
    public IRubyObject codepoints(ThreadContext context, Block block) {
        return this.enumerateCodepoints(context, "codepoints", block, true);
    }

    private IRubyObject enumerateChars(ThreadContext context, String name2, Block block, boolean wantarray) {
        RubyString str = this;
        if (block.isGiven()) {
            if (wantarray) {
                wantarray = false;
            }
        } else if (!wantarray) {
            return RubyEnumerator.enumeratorizeWithSize(context, str, name2, RubyString::eachCharSize);
        }
        str = str.newFrozen();
        ByteList strByteList = str.value;
        byte[] ptrBytes = strByteList.unsafeBytes();
        int ptr = strByteList.begin();
        int len = strByteList.getRealSize();
        Encoding enc = str.getEncoding();
        IRubyObject[] ary = wantarray ? new IRubyObject[str.strLength()] : null;
        int a = 0;
        switch (this.getCodeRange()) {
            case 16: 
            case 32: {
                int n;
                for (int i2 = 0; i2 < len; i2 += n) {
                    n = StringSupport.encFastMBCLen(ptrBytes, ptr + i2, ptr + len, enc);
                    IRubyObject substr = str.substr(context, i2, n);
                    if (wantarray) {
                        ary[a++] = substr;
                        continue;
                    }
                    block.yield(context, substr);
                }
                break;
            }
            default: {
                int n;
                for (int i3 = 0; i3 < len; i3 += n) {
                    n = StringSupport.length(enc, ptrBytes, ptr + i3, ptr + len);
                    IRubyObject substr = str.substr(context, i3, n);
                    if (wantarray) {
                        ary[a++] = substr;
                        continue;
                    }
                    block.yield(context, substr);
                }
            }
        }
        assert (!wantarray || a == ary.length);
        return wantarray ? Create.newArrayNoCopy(context, ary) : this;
    }

    private IRubyObject enumerateCodepoints(ThreadContext context, String name2, Block block, boolean wantarray) {
        RubyObject ary;
        RubyString str = this;
        if (this.singleByteOptimizable()) {
            return this.enumerateBytes(context, name2, block, wantarray);
        }
        if (block.isGiven()) {
            if (wantarray) {
                wantarray = false;
            }
        } else if (!wantarray) {
            return RubyEnumerator.enumeratorizeWithSize(context, str, name2, RubyString::codepointSize);
        }
        if (!str.isFrozen()) {
            str.setByteListShared();
        }
        ByteList strByteList = str.value;
        byte[] ptrBytes = strByteList.unsafeBytes();
        int ptr = strByteList.begin();
        int end2 = ptr + strByteList.getRealSize();
        Encoding enc = EncodingUtils.getEncoding(strByteList);
        if (wantarray) {
            int len = str.strLength(strByteList, enc);
            ary = Create.allocArray(context, len);
        } else {
            ary = null;
        }
        while (ptr < end2) {
            int c = StringSupport.codePoint(context, enc, ptrBytes, ptr, end2);
            int n = StringSupport.codeLength(enc, c);
            if (wantarray) {
                ((RubyArray)ary).append(context, Convert.asFixnum(context, c));
            } else {
                block.yield(context, Convert.asFixnum(context, c));
            }
            ptr += n;
        }
        return wantarray ? ary : this;
    }

    private IRubyObject enumerateBytes(ThreadContext context, String name2, Block block, boolean wantarray) {
        if (block.isGiven()) {
            if (wantarray) {
                wantarray = false;
            }
        } else if (!wantarray) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, name2, RubyString::byteSize);
        }
        IRubyObject[] ary = wantarray ? new IRubyObject[this.value.getRealSize()] : null;
        for (int i2 = 0; i2 < this.value.getRealSize(); ++i2) {
            RubyFixnum bite = Convert.asFixnum(context, this.value.get(i2) & 0xFF);
            if (wantarray) {
                ary[i2] = bite;
                continue;
            }
            block.yield(context, bite);
        }
        return wantarray ? Create.newArrayNoCopy(context, ary) : this;
    }

    private static IRubyObject codepointSize(ThreadContext context, RubyString recv2, IRubyObject[] args2) {
        return recv2.rubyLength(context);
    }

    private static IRubyObject eachGraphemeClusterSize(ThreadContext context, RubyString self2, IRubyObject[] args2) {
        int len;
        int beg;
        ByteList value2 = self2.getByteList();
        Encoding enc = value2.getEncoding();
        if (!enc.isUnicode()) {
            return self2.rubyLength(context);
        }
        Regex reg = RubyRegexp.getRegexpFromCache(context.runtime, GRAPHEME_CLUSTER_PATTERN, enc, RegexpOptions.NULL_OPTIONS);
        int end2 = beg + value2.getRealSize();
        Matcher matcher = reg.matcher(value2.getUnsafeBytes(), beg, end2);
        int count2 = 0;
        for (beg = value2.getBegin(); beg < end2 && (len = matcher.match(beg, end2, 0)) > 0; beg += len) {
            ++count2;
        }
        return Convert.asFixnum(context, count2);
    }

    private IRubyObject enumerateGraphemeClusters(ThreadContext context, String name2, Block block, boolean wantarray) {
        int len;
        int ptr;
        RubyString str = this;
        Encoding enc = str.getEncoding();
        if (!enc.isUnicode()) {
            return this.enumerateChars(context, name2, block, wantarray);
        }
        if (block.isGiven()) {
            if (wantarray) {
                wantarray = false;
            }
        } else if (!wantarray) {
            return RubyEnumerator.enumeratorizeWithSize(context, str, name2, RubyString::eachGraphemeClusterSize);
        }
        Regex reg = RubyRegexp.getRegexpFromCache(context.runtime, GRAPHEME_CLUSTER_PATTERN, enc, RegexpOptions.NULL_OPTIONS);
        if (!wantarray) {
            str = str.newFrozen();
        }
        ByteList strByteList = str.value;
        byte[] ptrBytes = strByteList.unsafeBytes();
        int end2 = ptr + strByteList.getRealSize();
        Matcher matcher = reg.matcher(ptrBytes, ptr, end2);
        RubyArray<?> ary = wantarray ? Create.allocArray(context, end2 - ptr) : null;
        for (ptr = strByteList.begin(); ptr < end2 && (len = matcher.match(ptr, end2, 0)) > 0; ptr += len) {
            RubyString result2 = RubyString.newStringShared(context.runtime, ptrBytes, ptr, len, enc);
            if (wantarray) {
                ary.append(context, result2);
                continue;
            }
            block.yield(context, result2);
        }
        return wantarray ? ary : this;
    }

    @JRubyMethod
    public IRubyObject grapheme_clusters(ThreadContext context, Block block) {
        return this.enumerateGraphemeClusters(context, "grapheme_clusters", block, true);
    }

    @JRubyMethod
    public IRubyObject each_grapheme_cluster(ThreadContext context, Block block) {
        return this.enumerateGraphemeClusters(context, "each_grapheme_cluster", block, false);
    }

    @Deprecated(since="10.0.0.0")
    public RubySymbol intern() {
        return this.intern(this.getCurrentContext());
    }

    @JRubyMethod(name={"to_sym", "intern"})
    public RubySymbol intern(ThreadContext context) {
        if (this.scanForCodeRange() == 48) {
            throw context.runtime.newEncodingError("invalid symbol in encoding " + String.valueOf(this.getEncoding()) + " :" + String.valueOf(this.inspect(context)));
        }
        RubySymbol symbol = context.runtime.getSymbolTable().getSymbol(this.value);
        if (symbol.getBytes() == this.value) {
            this.shareLevel = 2;
        }
        return symbol;
    }

    @JRubyMethod
    public IRubyObject ord(ThreadContext context) {
        return Convert.asFixnum(context, StringSupport.codePoint(context, this.value));
    }

    @JRubyMethod
    public IRubyObject sum(ThreadContext context) {
        return this.sumCommon(context, 16L);
    }

    @JRubyMethod
    public IRubyObject sum(ThreadContext context, IRubyObject arg2) {
        return this.sumCommon(context, Convert.toLong(context, arg2));
    }

    public IRubyObject sumCommon(ThreadContext context, long bits) {
        byte[] bytes2 = this.value.getUnsafeBytes();
        int p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int end2 = p2 + len;
        if (bits >= 64L) {
            RubyFixnum one = Convert.asFixnum(context, 0);
            IRubyObject sum2 = Convert.asFixnum(context, 1);
            JavaSites.StringSites sites = RubyString.sites(context);
            CallSite op_plus2 = sites.op_plus;
            while (p2 < end2) {
                this.modifyCheck(bytes2, len);
                sum2 = op_plus2.call(context, sum2, sum2, (IRubyObject)Convert.asFixnum(context, bytes2[p2++] & 0xFF));
            }
            if (bits != 0L) {
                IRubyObject mod = sites.op_lshift.call(context, (IRubyObject)one, (IRubyObject)one, (IRubyObject)Convert.asFixnum(context, bits));
                sum2 = sites.op_and.call(context, sum2, sum2, sites.op_minus.call(context, mod, mod, (IRubyObject)one));
            }
            return sum2;
        }
        long sum3 = 0L;
        while (p2 < end2) {
            this.modifyCheck(bytes2, len);
            sum3 += (long)(bytes2[p2++] & 0xFF);
        }
        return Convert.asFixnum(context, bits == 0L ? sum3 : sum3 & (1L << (int)bits) - 1L);
    }

    @JRubyMethod
    public IRubyObject to_c(ThreadContext context) {
        this.verifyAsciiCompatible();
        RubyRegexp underscore_pattern = RubyRegexp.newDummyRegexp(context.runtime, Numeric.ComplexPatterns.underscores_pat);
        RubyString s2 = this.gsubFast(context, underscore_pattern, Create.newString(context, UNDERSCORE), Block.NULL_BLOCK);
        IRubyObject[] ary = RubyComplex.str_to_c_internal(context, s2);
        IRubyObject first2 = ary[0];
        return first2 != context.nil ? first2 : RubyComplex.newComplexCanonicalize(context, Convert.asFixnum(context, 0));
    }

    @JRubyMethod
    public IRubyObject to_r(ThreadContext context) {
        IRubyObject first2 = RubyRational.str_to_r_internal(context, this, true)[0];
        return first2 != context.nil ? first2 : RubyRational.newRationalNoReduce(context, Convert.asFixnum(context, 0), Convert.asFixnum(context, 1));
    }

    @Deprecated(since="10.0.0.0", forRemoval=true)
    public static RubyString unmarshalFrom(UnmarshalStream input) throws IOException {
        return RubyString.newString(input.getRuntime(), input.unmarshalString());
    }

    public static RubyString unmarshalFrom(ThreadContext context, RubyInputStream in, MarshalLoader input) {
        return Create.newString(context, input.unmarshalString(context, in));
    }

    @JRubyMethod
    public RubyArray unpack(ThreadContext context, IRubyObject obj, Block block) {
        return Pack.unpackWithBlock(context, this, RubyString.stringValue((IRubyObject)obj).value, block);
    }

    @JRubyMethod
    public RubyArray unpack(ThreadContext context, IRubyObject obj, IRubyObject opt, Block block) {
        long offset2 = RubyString.unpackOffset(context, opt);
        return Pack.unpackWithBlock(context, this, RubyString.stringValue((IRubyObject)obj).value, offset2, block);
    }

    @JRubyMethod
    public IRubyObject unpack1(ThreadContext context, IRubyObject obj, Block block) {
        return Pack.unpack1WithBlock(context, this, RubyString.stringValue((IRubyObject)obj).value, block);
    }

    @JRubyMethod
    public IRubyObject unpack1(ThreadContext context, IRubyObject obj, IRubyObject opt, Block block) {
        long offset2 = RubyString.unpackOffset(context, opt);
        return Pack.unpack1WithBlock(context, this, RubyString.stringValue((IRubyObject)obj).value, offset2, block);
    }

    private static long unpackOffset(ThreadContext context, IRubyObject opt) {
        if (!(opt instanceof RubyHash)) {
            throw Error.argumentError(context, 2, 1);
        }
        RubyHash options2 = (RubyHash)opt;
        long offset2 = 0L;
        if (options2.size() == 1) {
            IRubyObject offsetArg = options2.fastARef(Convert.asSymbol(context, "offset"));
            if (offsetArg == null) {
                throw Error.argumentError(context, "unknown keyword: " + String.valueOf(options2.keys().first(context).inspect(context)));
            }
            offset2 = Convert.toLong(context, offsetArg);
        }
        return offset2;
    }

    public void empty() {
        this.value = ByteList.EMPTY_BYTELIST;
        this.shareLevel = 2;
    }

    @JRubyMethod
    public IRubyObject encoding(ThreadContext context) {
        return Access.encodingService(context).getEncoding(this.value.getEncoding());
    }

    @JRubyMethod(name={"encode!"})
    public IRubyObject encode_bang(ThreadContext context) {
        this.modifyAndClearCodeRange();
        return EncodingUtils.strTranscode(context, this, RubyString::updateFromTranscode);
    }

    @JRubyMethod(name={"encode!"})
    public IRubyObject encode_bang(ThreadContext context, IRubyObject arg0) {
        this.modifyAndClearCodeRange();
        return EncodingUtils.strTranscode(context, arg0, this, RubyString::updateFromTranscode);
    }

    @JRubyMethod(name={"encode!"})
    public IRubyObject encode_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        this.modifyAndClearCodeRange();
        return EncodingUtils.strTranscode(context, arg0, arg1, this, RubyString::updateFromTranscode);
    }

    @JRubyMethod(name={"encode!"})
    public IRubyObject encode_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        this.modifyAndClearCodeRange();
        return EncodingUtils.strTranscode(context, arg0, arg1, arg2, this, RubyString::updateFromTranscode);
    }

    private static RubyString updateFromTranscode(ThreadContext context, RubyString self2, Encoding encindex, RubyString newstr) {
        if (encindex == null) {
            return self2;
        }
        if (newstr == self2) {
            self2.setEncoding(encindex);
            return self2;
        }
        self2.replace(context, newstr);
        self2.setEncoding(encindex);
        return self2;
    }

    @JRubyMethod
    public IRubyObject encode(ThreadContext context) {
        return EncodingUtils.strEncode(context, this);
    }

    @JRubyMethod
    public IRubyObject encode(ThreadContext context, IRubyObject arg2) {
        return EncodingUtils.strEncode(context, this, arg2);
    }

    @JRubyMethod
    public IRubyObject encode(ThreadContext context, IRubyObject toEncoding, IRubyObject arg2) {
        return EncodingUtils.strEncode(context, this, toEncoding, arg2);
    }

    @JRubyMethod
    public IRubyObject encode(ThreadContext context, IRubyObject toEncoding, IRubyObject forcedEncoding, IRubyObject opts) {
        return EncodingUtils.strEncode(context, this, toEncoding, forcedEncoding, opts);
    }

    @JRubyMethod
    public IRubyObject force_encoding(ThreadContext context, IRubyObject enc) {
        return this.force_encoding(EncodingUtils.rbToEncoding(context, enc));
    }

    private IRubyObject force_encoding(Encoding encoding2) {
        this.modifyCheck();
        this.modifyAndClearCodeRange();
        this.associateEncoding(encoding2);
        this.clearCodeRange();
        return this;
    }

    @JRubyMethod(name={"valid_encoding?"})
    public IRubyObject valid_encoding_p(ThreadContext context) {
        return Convert.asBoolean(context, this.scanForCodeRange() != 48);
    }

    @JRubyMethod(name={"ascii_only?"})
    public IRubyObject ascii_only_p(ThreadContext context) {
        return Convert.asBoolean(context, this.scanForCodeRange() == 16);
    }

    @JRubyMethod
    public IRubyObject b(ThreadContext context) {
        ASCIIEncoding encoding2 = ASCIIEncoding.INSTANCE;
        RubyString dup2 = Create.dupString(context, this);
        dup2.clearCodeRange();
        dup2.setEncoding(encoding2);
        return dup2;
    }

    @JRubyMethod
    public IRubyObject scrub(ThreadContext context, Block block) {
        return this.scrub(context, context.nil, block);
    }

    @JRubyMethod
    public IRubyObject scrub(ThreadContext context, IRubyObject repl, Block block) {
        IRubyObject newStr = this.strScrub(context, repl, block);
        if (newStr.isNil()) {
            return Create.dupString(context, this);
        }
        return newStr;
    }

    @JRubyMethod(name={"scrub!"})
    public IRubyObject scrub_bang(ThreadContext context, Block block) {
        return this.scrub_bang(context, context.nil, block);
    }

    @JRubyMethod(name={"scrub!"})
    public IRubyObject scrub_bang(ThreadContext context, IRubyObject repl, Block block) {
        IRubyObject newStr = this.strScrub(context, repl, block);
        if (!newStr.isNil()) {
            return this.replace(context, newStr);
        }
        return this;
    }

    @Override
    @JRubyMethod
    @JRubyAPI
    public IRubyObject freeze(ThreadContext context) {
        if (this.isChilled()) {
            this.flags &= ~(ObjectFlags.CHILLED_LITERAL_F | ObjectFlags.CHILLED_SYMBOL_TO_S_F);
        }
        if (this.isFrozen()) {
            return this;
        }
        this.resize(this.size());
        return super.freeze(context);
    }

    public RubyString chill() {
        this.flags |= ObjectFlags.CHILLED_LITERAL_F;
        return this;
    }

    public RubyString chill_symbol_string() {
        this.flags |= ObjectFlags.CHILLED_SYMBOL_TO_S_F;
        return this;
    }

    @Deprecated(since="10.0.0.0")
    public void setValue(CharSequence value2) {
        this.view(ByteList.plain(value2), false);
    }

    public void setValue(ByteList value2) {
        this.view(value2);
    }

    public CharSequence getValue() {
        return this.toString();
    }

    public byte[] getBytes() {
        return this.value.bytes();
    }

    @Override
    @JRubyAPI
    public ByteList getByteList() {
        return this.value;
    }

    public String getUnicodeValue() {
        return RubyEncoding.decodeUTF8(this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getRealSize());
    }

    public static ByteList encodeBytelist(CharSequence value2, Encoding encoding2) {
        if (encoding2 == UTF8) {
            return RubyEncoding.doEncodeUTF8(value2);
        }
        Charset charset = EncodingUtils.charsetForEncoding(encoding2);
        if (charset == null) {
            return EncodingUtils.transcodeString(value2.toString(), encoding2, 0);
        }
        if (charset == RubyEncoding.UTF16) {
            byte[] bytes2 = RubyEncoding.encodeUTF16(value2);
            return new ByteList(bytes2, encoding2, false);
        }
        return RubyEncoding.doEncode(value2, charset, encoding2);
    }

    static ByteList encodeBytelist(String value2, Encoding encoding2) {
        if (encoding2 == UTF8) {
            return RubyEncoding.doEncodeUTF8(value2);
        }
        Charset charset = EncodingUtils.charsetForEncoding(encoding2);
        if (charset == null) {
            return EncodingUtils.transcodeString(value2, encoding2, 0);
        }
        if (charset == RubyEncoding.UTF16) {
            byte[] bytes2 = RubyEncoding.encodeUTF16(value2);
            return new ByteList(bytes2, encoding2, false);
        }
        return RubyEncoding.doEncode(value2, charset, encoding2);
    }

    @Override
    public <T> T toJava(Class<T> target2) {
        if (target2 == String.class || target2 == Comparable.class || target2 == Object.class) {
            return target2.cast(this.decodeString());
        }
        if (target2 == CharSequence.class) {
            return (T)this;
        }
        if (target2 == ByteList.class) {
            return target2.cast(this.value);
        }
        if (target2 == Character.class || target2 == Character.TYPE) {
            return (T)Character.valueOf((char)StringSupport.codePoint(this.getRuntime().getCurrentContext(), this.value));
        }
        return super.toJava(target2);
    }

    public IRubyObject strScrub(ThreadContext context, IRubyObject repl, Block block) {
        Encoding enc = EncodingUtils.STR_ENC_GET(this);
        return this.encStrScrub(context, enc, repl, this.getCodeRange(), block);
    }

    public IRubyObject encStrScrub(ThreadContext context, Encoding enc, IRubyObject repl, Block block) {
        int cr = 0;
        if (enc == EncodingUtils.STR_ENC_GET(this)) {
            cr = this.getCodeRange();
        }
        return this.encStrScrub(context, enc, repl, cr, block);
    }

    public IRubyObject encStrScrub(ThreadContext context, Encoding enc, IRubyObject repl, int cr, Block block) {
        IRubyObject buf = context.nil;
        if (block.isGiven() && repl != context.nil) {
            throw Error.argumentError(context, "both of block and replacement given");
        }
        if (cr == 16 || cr == 32) {
            return context.nil;
        }
        if (repl != context.nil) {
            repl = EncodingUtils.strCompatAndValid(context, repl, enc);
        }
        if (enc.isDummy()) {
            return context.nil;
        }
        Encoding encidx = enc;
        if (enc.isAsciiCompatible()) {
            int ret;
            boolean rep7bit_p;
            int replen;
            int rep;
            byte[] repBytes;
            byte[] pBytes = this.value.unsafeBytes();
            int p2 = this.value.begin();
            int e = p2 + this.value.getRealSize();
            int p1 = p2;
            if (block.isGiven()) {
                repBytes = null;
                rep = 0;
                replen = 0;
                rep7bit_p = false;
            } else if (!repl.isNil()) {
                repBytes = ((RubyString)repl).value.unsafeBytes();
                rep = ((RubyString)repl).value.begin();
                replen = ((RubyString)repl).value.getRealSize();
                rep7bit_p = ((RubyString)repl).getCodeRange() == 16;
            } else if (encidx == UTF8Encoding.INSTANCE) {
                repBytes = SCRUB_REPL_UTF8;
                rep = 0;
                replen = repBytes.length;
                rep7bit_p = false;
            } else {
                repBytes = SCRUB_REPL_ASCII;
                rep = 0;
                replen = repBytes.length;
                rep7bit_p = false;
            }
            cr = 16;
            p2 = StringSupport.searchNonAscii(pBytes, p2, e);
            if (p2 == -1) {
                p2 = e;
            }
            while (p2 < e && !StringSupport.MBCLEN_NEEDMORE_P(ret = StringSupport.preciseLength(enc, pBytes, p2, e))) {
                if (StringSupport.MBCLEN_CHARFOUND_P(ret)) {
                    cr = 32;
                    p2 += StringSupport.MBCLEN_CHARFOUND_LEN(ret);
                    continue;
                }
                if (!StringSupport.MBCLEN_INVALID_P(ret)) continue;
                int clen = enc.maxLength();
                if (buf.isNil()) {
                    buf = RubyString.newStringLight(context.runtime, this.value.getRealSize());
                }
                if (p2 > p1) {
                    ((RubyString)buf).cat(pBytes, p1, p2 - p1);
                }
                if (e - p2 < clen) {
                    clen = e - p2;
                }
                if (clen <= 2) {
                    clen = 1;
                } else {
                    int q = p2;
                    --clen;
                    while (clen > 1 && !StringSupport.MBCLEN_NEEDMORE_P(ret = enc.length(pBytes, q, q + clen))) {
                        if (StringSupport.MBCLEN_INVALID_P(ret)) {
                            // empty if block
                        }
                        --clen;
                    }
                }
                if (repBytes != null) {
                    ((RubyString)buf).cat(repBytes, rep, replen);
                    if (!rep7bit_p) {
                        cr = 32;
                    }
                } else {
                    repl = block.yieldSpecific(context, RubyString.newString(context.runtime, pBytes, p2, clen, enc));
                    repl = EncodingUtils.strCompatAndValid(context, repl, enc);
                    ((RubyString)buf).cat((RubyString)repl);
                    if (((RubyString)repl).getCodeRange() == 32) {
                        cr = 32;
                    }
                }
                p1 = p2 += clen;
                if ((p2 = StringSupport.searchNonAscii(pBytes, p2, e)) != -1) continue;
                p2 = e;
                break;
            }
            if (buf.isNil()) {
                if (p2 == e) {
                    this.setCodeRange(cr);
                    return context.nil;
                }
                buf = RubyString.newStringLight(context.runtime, this.value.getRealSize());
            }
            if (p1 < p2) {
                ((RubyString)buf).cat(pBytes, p1, p2 - p1);
            }
            if (p2 < e) {
                if (repBytes != null) {
                    ((RubyString)buf).cat(repBytes, rep, replen);
                    if (!rep7bit_p) {
                        cr = 32;
                    }
                } else {
                    repl = block.yieldSpecific(context, RubyString.newString(context.runtime, pBytes, p2, e - p2, enc));
                    repl = EncodingUtils.strCompatAndValid(context, repl, enc);
                    ((RubyString)buf).cat((RubyString)repl);
                    if (((RubyString)repl).getCodeRange() == 32) {
                        cr = 32;
                    }
                }
            }
        } else {
            int ret;
            int replen;
            int rep;
            byte[] repBytes;
            byte[] pBytes = this.value.unsafeBytes();
            int p3 = this.value.begin();
            int e = p3 + this.value.getRealSize();
            int p1 = p3;
            int mbminlen = enc.minLength();
            if (block.isGiven()) {
                repBytes = null;
                rep = 0;
                replen = 0;
            } else if (!repl.isNil()) {
                repBytes = ((RubyString)repl).value.unsafeBytes();
                rep = ((RubyString)repl).value.begin();
                replen = ((RubyString)repl).value.getRealSize();
            } else if (encidx == UTF16BEEncoding.INSTANCE) {
                repBytes = SCRUB_REPL_UTF16BE;
                rep = 0;
                replen = repBytes.length;
            } else if (encidx == UTF16LEEncoding.INSTANCE) {
                repBytes = SCRUB_REPL_UTF16LE;
                rep = 0;
                replen = repBytes.length;
            } else if (encidx == UTF32BEEncoding.INSTANCE) {
                repBytes = SCRUB_REPL_UTF32BE;
                rep = 0;
                replen = repBytes.length;
            } else if (encidx == UTF32LEEncoding.INSTANCE) {
                repBytes = SCRUB_REPL_UTF32LE;
                rep = 0;
                replen = repBytes.length;
            } else {
                repBytes = SCRUB_REPL_ASCII;
                rep = 0;
                replen = repBytes.length;
            }
            while (p3 < e && !StringSupport.MBCLEN_NEEDMORE_P(ret = StringSupport.preciseLength(enc, pBytes, p3, e))) {
                if (StringSupport.MBCLEN_CHARFOUND_P(ret)) {
                    p3 += StringSupport.MBCLEN_CHARFOUND_LEN(ret);
                    continue;
                }
                if (!StringSupport.MBCLEN_INVALID_P(ret)) continue;
                int q = p3;
                int clen = enc.maxLength();
                if (buf.isNil()) {
                    buf = RubyString.newStringLight(context.runtime, this.value.getRealSize());
                }
                if (p3 > p1) {
                    ((RubyString)buf).cat(pBytes, p1, p3 - p1);
                }
                if (e - p3 < clen) {
                    clen = e - p3;
                }
                if (clen <= mbminlen * 2) {
                    clen = mbminlen;
                } else {
                    clen -= mbminlen;
                    while (clen > mbminlen && !StringSupport.MBCLEN_NEEDMORE_P(ret = enc.length(pBytes, q, q + clen))) {
                        if (StringSupport.MBCLEN_INVALID_P(ret)) {
                            // empty if block
                        }
                        clen -= mbminlen;
                    }
                }
                if (repBytes != null) {
                    ((RubyString)buf).cat(repBytes, rep, replen);
                } else {
                    repl = block.yieldSpecific(context, RubyString.newString(context.runtime, pBytes, p3, clen, enc));
                    repl = EncodingUtils.strCompatAndValid(context, repl, enc);
                    ((RubyString)buf).cat((RubyString)repl);
                }
                p1 = p3 += clen;
            }
            if (buf.isNil()) {
                if (p3 == e) {
                    this.setCodeRange(32);
                    return context.nil;
                }
                buf = RubyString.newStringLight(context.runtime, this.value.getRealSize());
            }
            if (p1 < p3) {
                ((RubyString)buf).cat(pBytes, p1, p3 - p1);
            }
            if (p3 < e) {
                if (repBytes != null) {
                    ((RubyString)buf).cat(repBytes, rep, replen);
                } else {
                    repl = block.yieldSpecific(context, RubyString.newString(context.runtime, pBytes, p3, e - p3, enc));
                    repl = EncodingUtils.strCompatAndValid(context, repl, enc);
                    ((RubyString)buf).cat((RubyString)repl);
                }
            }
            cr = 32;
        }
        ((RubyString)buf).setEncodingAndCodeRange(enc, cr);
        return buf;
    }

    public int rbStrOffset(int pos2) {
        return this.strOffset(pos2, StringSupport.isSingleByteOptimizable(this, this.getEncoding()));
    }

    private int strOffset(int nth, boolean singlebyte) {
        int p2 = this.value.begin();
        int size2 = this.value.realSize();
        int e = p2 + size2;
        int pp = StringSupport.nth(this.value.getEncoding(), this.value.unsafeBytes(), p2, e, nth, singlebyte);
        if (pp == -1) {
            return size2;
        }
        return pp - p2;
    }

    public static IRubyObject includeRange(ThreadContext context, RubyString _beg, RubyString _end, IRubyObject _val, boolean exclusive) {
        if (_val.isNil()) {
            return context.fals;
        }
        if ((_val = TypeConverter.checkStringType(context.runtime, _val)).isNil()) {
            return context.fals;
        }
        RubyString val = _val.convertToString();
        RubyString beg = _beg.newFrozen();
        RubyString end2 = _end.newFrozen();
        if (EncodingUtils.encAsciicompat(beg.getEncoding()) && EncodingUtils.encAsciicompat(end2.getEncoding()) && EncodingUtils.encAsciicompat(val.getEncoding())) {
            ByteList bByteList = beg.getByteList();
            ByteList eByteList = end2.getByteList();
            ByteList vByteList = val.getByteList();
            if (beg.length() == 1 && end2.length() == 1) {
                int v;
                int e;
                if (val.length() != 1) {
                    return context.fals;
                }
                int b2 = bByteList.get(0);
                if (b2 < 128 && (e = eByteList.get(0)) < 128 && (v = vByteList.get(0)) < 128) {
                    if (b2 <= v && v < e) {
                        return context.tru;
                    }
                    if (!exclusive && v == e) {
                        return context.tru;
                    }
                    return context.fals;
                }
            }
        }
        try {
            beg.uptoCommon(context, end2, exclusive, CallBlock19.newCallClosure((IRubyObject)beg, (RubyModule)beg.getMetaClass(), Signature.ONE_ARGUMENT, (BlockCallback)new IncludeUpToCallback(val), context), false);
        }
        catch (JumpException.SpecialJump e) {
            return context.tru;
        }
        return context.fals;
    }

    @Deprecated(since="10.0.0.0")
    public boolean isBare(Ruby runtime2) {
        return this.isBare(this.getCurrentContext());
    }

    public boolean isBare(ThreadContext context) {
        return !this.hasInstanceVariables() && this.metaClass == Access.stringClass(context);
    }

    private static JavaSites.StringSites sites(ThreadContext context) {
        return context.sites.String;
    }

    @Deprecated(since="9.0.0.0")
    public final RubyString strDup() {
        return this.strDup(this.getRuntime(), this.getMetaClass().getRealClass());
    }

    @Deprecated
    public RubyArray unpack(IRubyObject obj) {
        return Pack.unpack(this.getRuntime(), this.value, RubyString.stringValue((IRubyObject)obj).value);
    }

    @Deprecated(since="9.4.6.0")
    public IRubyObject encode_bang(ThreadContext context, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 0, 2);
        this.modifyAndClearCodeRange();
        return EncodingUtils.strTranscode(context, args2, this, RubyString::updateFromTranscode);
    }

    static class DebugChilledString
    extends RubyString {
        private final String file;
        private final int line;

        protected DebugChilledString(Ruby runtime2, RubyClass rubyClass, ByteList value2, int cr, String file2, int line) {
            super(runtime2, rubyClass, value2, cr, false);
            this.file = file2;
            this.line = line;
            this.shareLevel = 2;
            this.chill();
        }

        @Override
        protected void mutateChilledString() {
            int savedFlags = this.flags;
            this.flags &= ~(ObjectFlags.CHILLED_LITERAL_F | ObjectFlags.CHILLED_SYMBOL_TO_S_F);
            if ((savedFlags & ObjectFlags.CHILLED_LITERAL_F) != 0) {
                this.getRuntime().getWarnings().warn("literal string will be frozen in the future, the string was created here: " + this.file + ":" + this.line);
            } else {
                super.mutateChilledString();
            }
        }
    }

    public static final class EmptyByteListHolder {
        public final ByteList bytes;
        public final int cr;

        EmptyByteListHolder(Encoding enc) {
            this.bytes = new ByteList(ByteList.NULL_ARRAY, enc);
            this.cr = this.bytes.getEncoding().isAsciiCompatible() ? 16 : 32;
        }
    }

    public static class FString
    extends RubyString {
        private IRubyObject converted;

        protected FString(Ruby runtime2, ByteList value2, int cr) {
            super(runtime2, runtime2.getString(), value2, cr, false);
            this.shareLevel = 2;
            this.flags |= ObjectFlags.FSTRING | FROZEN_F;
        }

        protected FString(Ruby runtime2, String string2) {
            super(runtime2, runtime2.getString(), string2, (Encoding)UTF8, false);
            this.shareLevel = 2;
            this.flags |= ObjectFlags.FSTRING | FROZEN_F;
        }

        @Override
        protected void frozenCheck() {
            Ruby runtime2 = this.getRuntime();
            throw runtime2.newFrozenError("String", this);
        }

        @Override
        public RubySymbol intern() {
            IRubyObject symbol = this.converted;
            if (symbol == null) {
                this.converted = super.intern();
                return this.converted;
            }
            if (symbol instanceof RubySymbol) {
                RubySymbol sym = (RubySymbol)symbol;
                return sym;
            }
            return super.intern();
        }

        @Override
        public IRubyObject to_i(ThreadContext context) {
            IRubyObject integer = this.converted;
            if (integer == null) {
                this.converted = super.to_i(context);
                return this.converted;
            }
            return integer instanceof RubyInteger ? integer : super.to_i(context);
        }

        @Override
        public IRubyObject to_f(ThreadContext context) {
            IRubyObject flote = this.converted;
            if (flote == null) {
                this.converted = super.to_f(context);
                return this.converted;
            }
            return flote instanceof RubyFloat ? flote : super.to_f(context);
        }

        @Override
        public FString dupAsFString(Ruby runtime2) {
            return this;
        }
    }

    static class DebugFrozenString
    extends RubyString {
        private final String file;
        private final int line;

        protected DebugFrozenString(Ruby runtime2, RubyClass rubyClass, ByteList value2, int cr, String file2, int line) {
            super(runtime2, rubyClass, value2, cr, false);
            this.file = file2;
            this.line = line;
            this.setFrozen(true);
        }

        @Override
        public boolean isFrozen() {
            return true;
        }

        @Override
        public void setFrozen(boolean frozen) {
        }

        @Override
        protected void frozenCheck() {
            Ruby runtime2 = this.getRuntime();
            throw runtime2.newRaiseException(runtime2.getFrozenError(), "can't modify frozen String, created at " + this.file + ":" + this.line);
        }
    }

    private static class IncludeUpToCallback
    implements BlockCallback {
        private final IRubyObject beg;

        IncludeUpToCallback(IRubyObject beg) {
            this.beg = beg;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
            return this.call(context, args2[0]);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject arg0) {
            if (this.beg.op_equal(context, arg0).isTrue()) {
                throw JumpException.SPECIAL_JUMP;
            }
            return arg0;
        }
    }
}

