/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.api.Access;
import org.jruby.api.Check;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.exceptions.RaiseException;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.DataType;
import org.jruby.util.ConvertBytes;
import org.jruby.util.RubyStringBuilder;

public class TypeConverter {
    private static final String[] IMPLICIT_CONVERTED_METHODS = new String[]{"to_int", "to_ary", "to_str", "to_sym", "to_hash", "to_proc", "to_io", "to_a", "to_s", "to_i", "to_r"};

    public static IRubyObject convertToType(IRubyObject obj, RubyClass target2, String convertMethod, boolean raise2) {
        return TypeConverter.convertToType(target2.getClassRuntime().getCurrentContext(), obj, target2, convertMethod, raise2);
    }

    public static IRubyObject convertToType(ThreadContext context, IRubyObject obj, RubyClass target2, String convertMethod, boolean raise2) {
        IRubyObject r = obj.checkCallMethod(context, convertMethod);
        return r == null ? TypeConverter.handleUncoercibleObject(context.runtime, obj, target2, raise2) : r;
    }

    public static IRubyObject convertToTypeUnchecked(ThreadContext context, IRubyObject obj, RubyClass target2, String convertMethod, boolean raise2) {
        IRubyObject r = obj.callMethod(context, convertMethod);
        return r == null ? TypeConverter.handleUncoercibleObject(context.runtime, obj, target2, raise2) : r;
    }

    public static IRubyObject convertToType(ThreadContext context, IRubyObject obj, RubyClass target2, JavaSites.CheckedSites sites, boolean raise2) {
        IRubyObject r = obj.checkCallMethod(context, sites);
        return r == null ? TypeConverter.handleUncoercibleObject(context.runtime, obj, target2, raise2) : r;
    }

    public static IRubyObject convertToType(IRubyObject obj, RubyClass target2, String convertMethod) {
        if (target2.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target2, convertMethod, true);
        if (!target2.isInstance(val)) {
            throw TypeConverter.newTypeErrorMismatch(obj.getRuntime(), obj, target2, convertMethod, val);
        }
        return val;
    }

    public static IRubyObject convertToType(ThreadContext context, IRubyObject obj, RubyClass target2, JavaSites.CheckedSites sites) {
        if (target2.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(context, obj, target2, sites, true);
        if (!target2.isInstance(val)) {
            throw TypeConverter.newTypeErrorMismatch(context.runtime, obj, target2, sites.methodName, val);
        }
        return val;
    }

    public static RubyFloat toFloat(Ruby runtime2, IRubyObject obj) {
        if (obj instanceof RubyNumeric) {
            return obj.convertToFloat();
        }
        if (obj instanceof RubyString || obj.isNil()) {
            throw Error.typeError(runtime2.getCurrentContext(), obj, "Float");
        }
        if (!(obj instanceof JavaProxy) && !obj.getMetaClass().isKindOfModule(runtime2.getNumeric())) {
            throw Error.typeError(runtime2.getCurrentContext(), RubyStringBuilder.str(runtime2, "can't convert ", RubyStringBuilder.types(runtime2, (RubyModule)obj.getMetaClass()), " into Float"));
        }
        return (RubyFloat)TypeConverter.convertToType(obj, runtime2.getFloat(), "to_f", true);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject checkData(IRubyObject obj) {
        if (obj instanceof DataType) {
            return obj;
        }
        Ruby runtime2 = obj.getRuntime();
        throw Error.typeError(runtime2.getCurrentContext(), RubyStringBuilder.str(runtime2, "wrong argument type ", TypeConverter.typeAsString(obj), " (expected Data)"));
    }

    public static RubyString typeAsString(IRubyObject obj) {
        ThreadContext context = obj.getRuntime().getCurrentContext();
        if (obj.isNil()) {
            return Create.newString(context, "nil");
        }
        if (obj instanceof RubyBoolean) {
            return Create.newString(context, obj.isTrue() ? "true" : "false");
        }
        return obj.getMetaClass().getRealClass().rubyName(context);
    }

    @Deprecated(since="10.0.0.0")
    public static RubySymbol checkID(IRubyObject obj) {
        return Check.checkID(obj.getRuntime().getCurrentContext(), obj);
    }

    @Deprecated(since="10.0.0.0")
    public static RubySymbol checkID(Ruby runtime2, String name2) {
        return RubySymbol.newHardSymbol(runtime2, name2.intern());
    }

    public static IRubyObject convertToTypeWithCheck(IRubyObject obj, RubyClass target2, String convertMethod) {
        if (target2.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target2, convertMethod, false);
        if (val.isNil()) {
            return val;
        }
        if (!target2.isInstance(val)) {
            throw TypeConverter.newTypeErrorMismatch(obj.getRuntime(), obj, target2, convertMethod, val);
        }
        return val;
    }

    public static IRubyObject convertToTypeWithCheck(ThreadContext context, IRubyObject obj, RubyClass target2, JavaSites.CheckedSites sites) {
        if (target2.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(context, obj, target2, sites, false);
        if (val == context.nil) {
            return val;
        }
        if (!target2.isInstance(val)) {
            throw TypeConverter.newTypeErrorMismatch(context.runtime, obj, target2, sites.methodName, val);
        }
        return val;
    }

    public static RaiseException newTypeError(IRubyObject obj, RubyClass target2, String convertMethod, IRubyObject val) {
        return TypeConverter.newTypeError(obj.getRuntime(), obj, target2, convertMethod, val);
    }

    public static RaiseException newTypeError(Ruby runtime2, IRubyObject obj, RubyClass target2, String methodName, IRubyObject val) {
        RubyString className = RubyStringBuilder.types(runtime2, (RubyModule)obj.getType());
        String message2 = TypeConverter.isImplicitTypeError(methodName) ? "no implicit conversion of" : "can't convert ";
        return Error.typeError(runtime2.getCurrentContext(), RubyStringBuilder.str(runtime2, message2, className, " to ", RubyStringBuilder.types(runtime2, (RubyModule)target2)));
    }

    public static RaiseException newTypeErrorMismatch(Ruby runtime2, IRubyObject obj, RubyClass target2, String methodName, IRubyObject val) {
        RubyString className = RubyStringBuilder.types(runtime2, (RubyModule)obj.getType());
        return Error.typeError(runtime2.getCurrentContext(), RubyStringBuilder.str(runtime2, "can't convert ", className, " to ", RubyStringBuilder.types(runtime2, (RubyModule)target2), " (", className, "#" + methodName + " gives ", RubyStringBuilder.types(runtime2, (RubyModule)val.getType()), ")"));
    }

    public static IRubyObject checkIntegerType(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubyInteger) {
            return obj;
        }
        JavaSites.TypeConverterSites sites = TypeConverter.sites(context);
        IRubyObject conv = TypeConverter.convertToType(context, obj, context.runtime.getInteger(), sites.to_int_checked, false);
        if (conv.isNil()) {
            return context.nil;
        }
        if (!(conv instanceof RubyInteger)) {
            throw TypeConverter.newTypeErrorMismatch(context.runtime, obj, context.runtime.getInteger(), "to_int", conv);
        }
        return conv;
    }

    @Deprecated
    public static IRubyObject checkToInteger(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubyFixnum) {
            return obj;
        }
        JavaSites.TypeConverterSites sites = TypeConverter.sites(context);
        IRubyObject conv = TypeConverter.convertToTypeWithCheck(context, obj, context.runtime.getInteger(), sites.to_int_checked);
        return conv instanceof RubyInteger ? conv : context.nil;
    }

    @Deprecated
    public static IRubyObject checkToInteger(Ruby runtime2, IRubyObject obj, String method2) {
        if (method2.equals("to_int")) {
            return Convert.checkToInteger(runtime2.getCurrentContext(), obj);
        }
        if (obj instanceof RubyFixnum) {
            return obj;
        }
        if (method2.equals("to_i")) {
            ThreadContext context = runtime2.getCurrentContext();
            JavaSites.TypeConverterSites sites = TypeConverter.sites(context);
            IRubyObject conv = TypeConverter.convertToTypeWithCheck(context, obj, runtime2.getInteger(), sites.to_i_checked);
            return conv instanceof RubyInteger ? conv : runtime2.getNil();
        }
        IRubyObject conv = TypeConverter.convertToType(obj, runtime2.getInteger(), method2, false);
        return conv instanceof RubyInteger ? conv : runtime2.getNil();
    }

    public static IRubyObject checkFloatType(Ruby runtime2, IRubyObject obj) {
        if (obj instanceof RubyFloat) {
            return obj;
        }
        if (!(obj instanceof RubyNumeric)) {
            return runtime2.getNil();
        }
        ThreadContext context = runtime2.getCurrentContext();
        JavaSites.TypeConverterSites sites = TypeConverter.sites(context);
        return TypeConverter.convertToTypeWithCheck(context, obj, runtime2.getFloat(), sites.to_f_checked);
    }

    public static IRubyObject checkHashType(Ruby runtime2, IRubyObject obj) {
        return TypeConverter.checkHashType(runtime2, obj, true);
    }

    public static IRubyObject checkHashType(Ruby runtime2, IRubyObject obj, boolean raise2) {
        if (obj instanceof RubyHash) {
            return obj;
        }
        if (raise2) {
            return TypeConverter.convertToTypeWithCheck(obj, runtime2.getHash(), "to_hash");
        }
        return TypeConverter.convertToType(obj, runtime2.getHash(), "to_hash", false);
    }

    public static IRubyObject checkHashType(ThreadContext context, JavaSites.CheckedSites sites, IRubyObject obj) {
        if (obj instanceof RubyHash) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(context, obj, Access.hashClass(context), sites);
    }

    public static IRubyObject checkStringType(Ruby runtime2, IRubyObject obj) {
        if (obj instanceof RubyString) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(obj, runtime2.getString(), "to_str");
    }

    public static IRubyObject checkStringType(ThreadContext context, JavaSites.CheckedSites sites, IRubyObject obj) {
        if (obj instanceof RubyString) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(context, obj, Access.stringClass(context), sites);
    }

    public static IRubyObject checkStringType(ThreadContext context, JavaSites.CheckedSites sites, IRubyObject obj, RubyClass target2) {
        if (obj instanceof RubyString) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(context, obj, target2, sites);
    }

    public static IRubyObject checkArrayType(Ruby runtime2, IRubyObject obj) {
        if (obj instanceof RubyArray) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(obj, runtime2.getArray(), "to_ary");
    }

    public static IRubyObject checkArrayType(ThreadContext context, JavaSites.CheckedSites sites, IRubyObject obj) {
        if (obj instanceof RubyArray) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(context, obj, Access.arrayClass(context), sites);
    }

    public static IRubyObject ioCheckIO(Ruby runtime2, IRubyObject obj) {
        if (obj instanceof RubyIO) {
            return obj;
        }
        return TypeConverter.convertToTypeWithCheck(obj, runtime2.getIO(), "to_io");
    }

    public static RubyIO ioGetIO(Ruby runtime2, IRubyObject obj) {
        return (RubyIO)TypeConverter.convertToType(obj, runtime2.getIO(), "to_io");
    }

    public static IRubyObject checkArrayType(ThreadContext context, IRubyObject obj) {
        return TypeConverter.convertToTypeWithCheck(context, obj, Access.arrayClass(context), TypeConverter.sites((ThreadContext)context).to_ary_checked);
    }

    @Deprecated
    public static IRubyObject checkArrayType(IRubyObject obj) {
        return TypeConverter.checkArrayType(obj.getRuntime().getCurrentContext(), obj);
    }

    public static IRubyObject handleUncoercibleObject(boolean raise2, IRubyObject obj, RubyClass target2) {
        return TypeConverter.handleUncoercibleObject(obj.getRuntime(), obj, target2, raise2);
    }

    public static IRubyObject handleUncoercibleObject(Ruby runtime2, IRubyObject obj, RubyClass target2, boolean raise2) {
        if (raise2) {
            throw Error.typeError(runtime2.getCurrentContext(), RubyStringBuilder.str(runtime2, "no implicit conversion of ", TypeConverter.typeAsString(obj), " into ", target2));
        }
        return runtime2.getNil();
    }

    @Deprecated
    public static IRubyObject handleImplicitlyUncoercibleObject(boolean raise2, IRubyObject obj, RubyClass target2) {
        return TypeConverter.handleUncoercibleObject(obj.getRuntime(), obj, target2, raise2);
    }

    public static void checkType(ThreadContext context, IRubyObject x, RubyModule type2) {
        assert (x != RubyBasicObject.UNDEF);
        ClassIndex xt = x.getMetaClass().getClassIndex();
        if (xt != type2.getClassIndex() && !type2.isInstance(x)) {
            Ruby runtime2 = context.runtime;
            throw Error.typeError(context, RubyStringBuilder.str(runtime2, "wrong argument type ", RubyStringBuilder.types(runtime2, (RubyModule)x.getMetaClass()), " (expected ", RubyStringBuilder.types(runtime2, type2), ")"));
        }
    }

    public static IRubyObject convertToInteger(ThreadContext context, IRubyObject val, int base, boolean exception2) {
        IRubyObject tmp;
        if (base != 0) {
            tmp = TypeConverter.checkStringType(context.runtime, val);
            if (!tmp.isNil()) {
                val = tmp;
            } else {
                if (!exception2) {
                    return context.nil;
                }
                return TypeConverter.raiseIntegerBaseError(context, true);
            }
        }
        if (val instanceof RubyFloat) {
            RubyFloat f = (RubyFloat)val;
            if (!exception2 && !Double.isFinite(f.asDouble(context))) {
                return context.nil;
            }
            return Convert.asInteger(context, f.getValue());
        }
        if (val instanceof RubyInteger) {
            return val;
        }
        if (val instanceof RubyString) {
            RubyString str = (RubyString)val;
            return RubyNumeric.str2inum(context.runtime, str, base, true, exception2);
        }
        if (val.isNil()) {
            if (!exception2) {
                return context.nil;
            }
            throw Error.typeError(context, "can't convert nil into Integer");
        }
        try {
            tmp = TypeConverter.convertToType(context, val, Access.integerClass(context), TypeConverter.sites((ThreadContext)context).to_int_checked, false);
            if (tmp instanceof RubyInteger) {
                return tmp;
            }
        }
        catch (RaiseException re) {
            context.clearErrorInfo();
        }
        tmp = TypeConverter.checkStringType(context.runtime, val);
        if (!tmp.isNil()) {
            return ConvertBytes.byteListToInum(context.runtime, ((RubyString)tmp).getByteList(), base, exception2);
        }
        if (!exception2) {
            block18: {
                try {
                    IRubyObject ret = TypeConverter.convertToType(context, val, Access.integerClass(context), TypeConverter.sites((ThreadContext)context).to_i_checked, false);
                    if (ret instanceof RubyInteger) {
                        return ret;
                    }
                }
                catch (RaiseException re) {
                    if (!exception2) break block18;
                    throw re;
                }
            }
            return context.nil;
        }
        return val.convertToInteger("to_i");
    }

    public static IRubyObject convertToInteger(ThreadContext context, IRubyObject val, int base) {
        return TypeConverter.convertToInteger(context, val, base, true);
    }

    public static RubyArray rb_Array(ThreadContext context, IRubyObject val) {
        IRubyObject tmp = TypeConverter.checkArrayType(context, val);
        if (tmp == context.nil) {
            JavaSites.TypeConverterSites sites = TypeConverter.sites(context);
            tmp = TypeConverter.convertToTypeWithCheck(context, val, Access.arrayClass(context), sites.to_a_checked);
            if (tmp == context.nil) {
                return Create.newArray(context, val);
            }
        }
        return (RubyArray)tmp;
    }

    public static RubyArray to_ary(ThreadContext context, IRubyObject ary) {
        return (RubyArray)TypeConverter.convertToType(context, ary, Access.arrayClass(context), TypeConverter.sites((ThreadContext)context).to_ary_checked);
    }

    private static IRubyObject raiseIntegerBaseError(ThreadContext context, boolean exception2) {
        if (!exception2) {
            return context.nil;
        }
        throw Error.argumentError(context, "base specified for non string value");
    }

    public static JavaSites.TypeConverterSites sites(ThreadContext context) {
        return context.sites.TypeConverter;
    }

    @Deprecated(since="9.0.0.0")
    public static IRubyObject convertToType(IRubyObject obj, RubyClass target2, int convertMethodIndex, String convertMethod, boolean raise2) {
        if (!obj.respondsTo(convertMethod)) {
            return TypeConverter.handleUncoercibleObject(raise2, obj, target2);
        }
        return obj.callMethod(obj.getRuntime().getCurrentContext(), convertMethod);
    }

    @Deprecated(since="9.0.0.0")
    public static IRubyObject convertToType(IRubyObject obj, RubyClass target2, int convertMethodIndex, String convertMethod) {
        if (target2.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target2, convertMethod, true);
        if (!target2.isInstance(val)) {
            Ruby runtime2 = obj.getRuntime();
            throw Error.typeError(runtime2.getCurrentContext(), RubyStringBuilder.str(runtime2, RubyStringBuilder.types(runtime2, (RubyModule)obj.getMetaClass()), "#" + convertMethod + " should return ", RubyStringBuilder.types(runtime2, (RubyModule)target2)));
        }
        return val;
    }

    @Deprecated(since="9.0.0.0")
    public static IRubyObject convertToTypeWithCheck(IRubyObject obj, RubyClass target2, int convertMethodIndex, String convertMethod) {
        if (target2.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target2, convertMethod, false);
        if (val.isNil()) {
            return val;
        }
        if (!target2.isInstance(val)) {
            Ruby runtime2 = obj.getRuntime();
            throw Error.typeError(runtime2.getCurrentContext(), RubyStringBuilder.str(runtime2, RubyStringBuilder.types(runtime2, (RubyModule)obj.getMetaClass()), "#" + convertMethod + " should return ", RubyStringBuilder.types(runtime2, (RubyModule)target2)));
        }
        return val;
    }

    @Deprecated(since="9.0.3.0")
    public static String convertToIdentifier(IRubyObject obj) {
        if (obj instanceof RubyString) {
            return RubyEncoding.decodeRaw(((RubyString)obj).getByteList()).intern();
        }
        return obj.asJavaString().intern();
    }

    @Deprecated
    public static IRubyObject convertToTypeOrRaise(IRubyObject obj, RubyClass target2, String convertMethod) {
        if (target2.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target2, convertMethod, true);
        if (val.isNil()) {
            return val;
        }
        if (!target2.isInstance(val)) {
            Ruby runtime2 = obj.getRuntime();
            throw Error.typeError(runtime2.getCurrentContext(), RubyStringBuilder.str(runtime2, RubyStringBuilder.types(runtime2, (RubyModule)obj.getMetaClass()), "#" + convertMethod + " should return ", RubyStringBuilder.types(runtime2, (RubyModule)target2)));
        }
        return val;
    }

    private static boolean isImplicitTypeError(String methodID) {
        for (int i2 = 0; i2 < IMPLICIT_CONVERTED_METHODS.length; ++i2) {
            if (!IMPLICIT_CONVERTED_METHODS[i2].equals(methodID)) continue;
            return true;
        }
        return false;
    }

    public static boolean booleanExpected(ThreadContext context, IRubyObject object, String id2) {
        if (object == context.tru) {
            return true;
        }
        if (object == context.fals) {
            return false;
        }
        throw Error.argumentError(context, RubyStringBuilder.str(context.runtime, "true or false is expected as ", Convert.asSymbol(context, id2), ": ", object));
    }
}

