/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubySymbol;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.exceptions.Unrescuable;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class MRIRecursionGuard {
    private final Ruby runtime;
    private final RubySymbol recursiveKey;
    private final ThreadLocal<Map<String, RubyHash>> recursive = new ThreadLocal();
    private final ThreadLocal<Boolean> inRecursiveListOperation = new ThreadLocal();

    @Deprecated(since="9.1.7.0")
    public MRIRecursionGuard(Ruby runtime2) {
        this.runtime = runtime2;
        this.recursiveKey = runtime2.newSymbol("__recursive_key__");
    }

    @Deprecated(since="9.1.7.0")
    public IRubyObject execRecursive(RecursiveFunction func, IRubyObject obj) {
        if (!this.inRecursiveListOperation.get().booleanValue()) {
            throw this.runtime.newThreadError("BUG: execRecursive called outside recursiveListOperation");
        }
        return this.execRecursiveInternal(func, obj, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(since="9.1.7.0")
    public IRubyObject execRecursiveOuter(RecursiveFunction func, IRubyObject obj) {
        try {
            IRubyObject iRubyObject = this.execRecursiveInternal(func, obj, null, true);
            return iRubyObject;
        }
        finally {
            this.recursiveListClear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(since="9.1.7.0")
    public <T extends IRubyObject> T recursiveListOperation(Callable<T> body) {
        try {
            this.inRecursiveListOperation.set(true);
            IRubyObject iRubyObject = (IRubyObject)body.call();
            return (T)iRubyObject;
        }
        catch (Exception e) {
            Helpers.throwException(e);
            T t = null;
            return t;
        }
        finally {
            this.recursiveListClear();
            this.inRecursiveListOperation.set(false);
        }
    }

    @Deprecated(since="9.1.7.0")
    private IRubyObject execRecursiveInternal(RecursiveFunction func, IRubyObject obj, IRubyObject pairid, boolean outer) {
        IRubyObject result2;
        boolean outermost;
        ThreadContext context = this.runtime.getCurrentContext();
        ExecRecursiveParams p2 = new ExecRecursiveParams();
        p2.list = this.recursiveListAccess(context);
        p2.objid = obj.id();
        boolean bl = outermost = outer && !this.recursiveCheck(p2.list, this.recursiveKey, null);
        if (this.recursiveCheck(p2.list, p2.objid, pairid)) {
            if (outer && !outermost) {
                throw new RecursiveError(p2.list);
            }
            return func.call(obj, true);
        }
        p2.func = func;
        p2.obj = obj;
        p2.pairid = pairid;
        if (outermost) {
            this.recursivePush(context, p2.list, this.recursiveKey, null);
            try {
                result2 = this.execRecursiveI(context, p2);
            }
            catch (RecursiveError e) {
                if (e.tag != p2.list) {
                    throw e;
                }
                result2 = p2.list;
            }
            this.recursivePop(context, p2.list, this.recursiveKey, null);
            if (result2 == p2.list) {
                result2 = func.call(obj, true);
            }
        } else {
            result2 = this.execRecursiveI(context, p2);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject execRecursiveI(ThreadContext context, ExecRecursiveParams p2) {
        IRubyObject result2 = null;
        this.recursivePush(context, p2.list, p2.objid, p2.pairid);
        try {
            result2 = p2.func.call(p2.obj, false);
        }
        finally {
            this.recursivePop(context, p2.list, p2.objid, p2.pairid);
        }
        return result2;
    }

    private IRubyObject recursiveListAccess(ThreadContext context) {
        Map<String, RubyHash> hash2 = this.recursive.get();
        String sym = context.getFrameName();
        IRubyObject list2 = context.nil;
        if (hash2 == null) {
            hash2 = new HashMap<String, RubyHash>();
            this.recursive.set(hash2);
        } else {
            list2 = hash2.get(sym);
        }
        if (list2 == null || list2.isNil()) {
            list2 = Create.newHash(context);
            hash2.put(sym, (RubyHash)list2);
        }
        return list2;
    }

    private void recursiveListClear() {
        Map<String, RubyHash> hash2 = this.recursive.get();
        if (hash2 != null) {
            hash2.clear();
        }
    }

    private void recursivePush(ThreadContext context, IRubyObject list2, IRubyObject obj, IRubyObject paired_obj) {
        if (paired_obj == null) {
            ((RubyHash)list2).op_aset(context, obj, context.tru);
        } else {
            IRubyObject pair_list = ((RubyHash)list2).fastARef(obj);
            if (pair_list == null) {
                ((RubyHash)list2).op_aset(context, obj, paired_obj);
            } else {
                if (!(pair_list instanceof RubyHash)) {
                    IRubyObject other_paired_obj = pair_list;
                    pair_list = Create.newHash(context);
                    ((RubyHash)pair_list).op_aset(context, other_paired_obj, context.tru);
                    ((RubyHash)list2).op_aset(context, obj, pair_list);
                }
                ((RubyHash)pair_list).op_aset(context, paired_obj, context.tru);
            }
        }
    }

    private void recursivePop(ThreadContext context, IRubyObject list2, IRubyObject obj, IRubyObject paired_obj) {
        if (paired_obj != null) {
            IRubyObject pair_list = ((RubyHash)list2).fastARef(obj);
            if (pair_list == null) {
                throw Error.typeError(context, "invalid inspect_tbl pair_list for " + context.getFrameName());
            }
            if (pair_list instanceof RubyHash) {
                RubyHash pairHash = (RubyHash)pair_list;
                pairHash.delete(context, paired_obj, Block.NULL_BLOCK);
                if (!pairHash.isEmpty()) {
                    return;
                }
            }
        }
        ((RubyHash)list2).delete(context, obj, Block.NULL_BLOCK);
    }

    private boolean recursiveCheck(IRubyObject list2, IRubyObject obj_id, IRubyObject paired_obj_id) {
        IRubyObject paired_result;
        IRubyObject pair_list = ((RubyHash)list2).fastARef(obj_id);
        if (pair_list == null) {
            return false;
        }
        return paired_obj_id == null || !(!(pair_list instanceof RubyHash) ? pair_list != paired_obj_id : (paired_result = ((RubyHash)pair_list).fastARef(paired_obj_id)) == null || paired_result.isNil());
    }

    @Deprecated(since="9.1.7.0")
    public static interface RecursiveFunction {
        public IRubyObject call(IRubyObject var1, boolean var2);
    }

    private static class ExecRecursiveParams {
        public RecursiveFunction func;
        public IRubyObject list;
        public IRubyObject obj;
        public IRubyObject objid;
        public IRubyObject pairid;
    }

    private static class RecursiveError
    extends java.lang.Error
    implements Unrescuable {
        public final Object tag;

        public RecursiveError(Object tag2) {
            this.tag = tag2;
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

