/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyDir;
import org.jruby.RubyFile;
import org.jruby.RubyString;
import org.jruby.api.Access;
import org.jruby.api.Create;
import org.jruby.ir.IRScope;
import org.jruby.platform.Platform;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.ClassExtensionLibrary;
import org.jruby.runtime.load.CompiledScriptLoader;
import org.jruby.runtime.load.DebugLog;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadService;
import org.jruby.runtime.load.LoadServiceResourceInputStream;
import org.jruby.util.ByteList;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.URLResource;
import org.jruby.util.cli.Options;
import org.jruby.util.collections.StringArraySet;
import org.jruby.util.func.TriFunction;

public class LibrarySearcher {
    public static final char EXTENSION_TYPE = 's';
    public static final char SOURCE_TYPE = 'r';
    public static final char UNKNOWN_TYPE = 'u';
    public static final char NOT_FOUND = '\u0000';
    private final LoadService loadService;
    private final Ruby runtime;
    private final PathEntry cwdPathEntry;
    private final PathEntry classloaderPathEntry;
    private final PathEntry nullPathEntry;
    private final PathEntry homePathEntry;
    protected ExpandedLoadPath expandedLoadPath;
    protected RubyArray loadPath;
    protected RubyArray loadedFeaturesSnapshot;
    private final Map<StringWrapper, Feature> loadedFeaturesIndex = new ConcurrentHashMap<StringWrapper, Feature>(64);
    private final ThreadLocal<StringWrapper> keyWrapper = ThreadLocal.withInitial(() -> new StringWrapper(null, 0, 0));
    private final ThreadLocal<StringWrapper> rangeWrapper = ThreadLocal.withInitial(() -> new StringWrapper(null, 0, 0));

    public LibrarySearcher(LoadService loadService) {
        this.runtime = loadService.runtime;
        ThreadContext context = this.runtime.getCurrentContext();
        this.loadPath = Create.newArray(context);
        this.loadService = loadService;
        this.cwdPathEntry = new NormalPathEntry(Create.newString(context, "."));
        this.classloaderPathEntry = new NormalPathEntry(Create.newString(context, "uri:classloader:"));
        this.nullPathEntry = new NullPathEntry();
        this.homePathEntry = new HomePathEntry();
        this.loadedFeaturesSnapshot = Create.newArray(context);
    }

    public List<PathEntry> getExpandedLoadPath() {
        ExpandedLoadPath expandedLoadPath = this.expandedLoadPath;
        if (expandedLoadPath == null || !expandedLoadPath.isCurrent()) {
            expandedLoadPath = this.expandedLoadPath = new ExpandedLoadPath(this, this.loadService.loadPath);
        }
        return expandedLoadPath.pathEntries;
    }

    public synchronized char findLibraryForRequire(String file2, FoundLibrary[] path2) {
        FoundLibrary tmp;
        char ft = '\u0000';
        String[] loading = new String[]{null};
        path2[0] = null;
        int ext2 = file2.lastIndexOf(46);
        if (ext2 != -1 && file2.indexOf(47, ext2) == -1) {
            if (LibrarySearcher.isSourceExt(file2)) {
                if (this.isFeature(file2, ext2, true, false, loading) != '\u0000') {
                    if (loading[0] != null) {
                        path2[0] = new FoundLibrary(file2, loading[0], Suffix.RUBY.constructLibrary(file2, loading[0], JRubyFile.createResourceAsFile(this.runtime, loading[0])));
                    }
                    return 'r';
                }
                FoundLibrary tmp2 = this.findLibrary(file2.substring(0, ext2), LoadService.SuffixType.Source);
                if (tmp2 != null) {
                    String tmpPath = tmp2.loadName;
                    ext2 = tmpPath.lastIndexOf(46);
                    if (this.isFeature(tmpPath, ext2, true, true, loading) == '\u0000' || loading[0] != null) {
                        path2[0] = tmp2;
                    }
                    return 'r';
                }
                return '\u0000';
            }
            if (LibrarySearcher.isLibraryExt(file2)) {
                if (this.isFeature(file2, ext2, true, false, loading) != '\u0000') {
                    if (loading[0] != null) {
                        path2[0] = new FoundLibrary(file2, loading[0], Suffix.JAR.constructLibrary(file2, loading[0], JRubyFile.createResourceAsFile(this.runtime, loading[0])));
                    }
                    return 's';
                }
                tmp = this.findLibrary(file2.substring(0, ext2), LoadService.SuffixType.Extension);
                if (tmp != null) {
                    ext2 = tmp.loadName.lastIndexOf(46);
                    if (this.isFeature(tmp.loadName, ext2, false, true, loading) == '\u0000' || loading[0] != null) {
                        path2[0] = tmp;
                    }
                    return 's';
                }
            }
        } else {
            ft = this.isFeature(file2, -1, false, false, loading);
            if (ft == 'r') {
                if (loading[0] != null) {
                    path2[0] = new FoundLibrary(file2, loading[0], Suffix.RUBY.constructLibrary(file2, loading[0], JRubyFile.createResourceAsFile(this.runtime, loading[0])));
                }
                return 'r';
            }
        }
        if ((tmp = this.findLibrary(file2, LoadService.SuffixType.Both)) == null) {
            if (ft != '\u0000') {
                if (loading[0] != null) {
                    path2[0] = tmp;
                }
                return ft;
            }
            return this.isFeature(file2, -1, false, true, null);
        }
        boolean rb = true;
        if (tmp.loadName.endsWith(".jar")) {
            if (ft != '\u0000') {
                if (loading[0] != null) {
                    path2[0] = tmp;
                }
                return ft;
            }
            rb = false;
        }
        if (this.isFeature(tmp.loadName, ext2 = tmp.loadName.lastIndexOf(46), rb, true, loading) == '\u0000' || loading[0] != null) {
            path2[0] = tmp;
        }
        return tmp.loadName.endsWith(".jar") ? (char)'s' : 'r';
    }

    public FoundLibrary findLibraryForLoad(String file2) {
        if (file2.endsWith(".rb")) {
            return this.findLibrary(file2.substring(0, file2.length() - 3), LoadService.SuffixType.Source);
        }
        FoundLibrary library2 = this.findResourceLibrary(file2, f -> f, ResourceLibrary::create);
        if (library2 != null) {
            return library2;
        }
        return this.findServiceLibrary(file2);
    }

    public FoundLibrary findLibrary(String baseName, LoadService.SuffixType suffixType) {
        for (Suffix suffix : suffixType.getSuffixSet()) {
            FoundLibrary library2 = this.findResourceLibrary(baseName, suffix::forTarget, suffix.libraryFactory);
            if (library2 == null) continue;
            return library2;
        }
        return this.findServiceLibrary(baseName);
    }

    public static LoadService.SuffixType getSuffixTypeForRequire(String[] fileHolder) {
        LoadService.SuffixType suffixType;
        int lastDot;
        String file2 = fileHolder[0];
        if (Platform.IS_WINDOWS) {
            file2 = file2.replace('\\', '/');
        }
        if ((lastDot = file2.lastIndexOf(46)) != -1 && file2.indexOf(47, lastDot) == -1) {
            if (LibrarySearcher.isSourceExt(file2)) {
                suffixType = LoadService.SuffixType.Source;
                fileHolder[0] = file2.substring(0, lastDot);
            } else if (LibrarySearcher.isLibraryExt(file2)) {
                suffixType = LoadService.SuffixType.Extension;
                fileHolder[0] = file2.substring(0, lastDot);
            } else {
                suffixType = file2.endsWith(".class") ? LoadService.SuffixType.Neither : LoadService.SuffixType.Both;
            }
        } else {
            suffixType = LoadService.SuffixType.Both;
        }
        return suffixType;
    }

    public static LoadService.SuffixType getSuffixTypeForLoad(String[] fileHolder) {
        LoadService.SuffixType suffixType;
        String file2 = fileHolder[0];
        int lastDot = file2.lastIndexOf(46);
        if (lastDot != -1 && file2.indexOf(47, lastDot) == -1) {
            if (LibrarySearcher.isSourceExt(file2)) {
                suffixType = LoadService.SuffixType.Source;
                fileHolder[0] = file2.substring(0, lastDot);
            } else {
                suffixType = LoadService.SuffixType.Neither;
            }
        } else {
            suffixType = LoadService.SuffixType.Neither;
        }
        return suffixType;
    }

    public static boolean isSourceExt(String file2) {
        for (Suffix suffix : Suffix.SOURCES) {
            if (!file2.endsWith(suffix.extension)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLibraryExt(String file2) {
        return file2.endsWith(".so") || file2.endsWith(".o") || file2.endsWith(".jar");
    }

    public synchronized boolean featureAlreadyLoaded(String feature, String[] loading) {
        int ext2 = feature.lastIndexOf(46);
        if (feature.charAt(0) == '.' && (feature.charAt(1) == '/' || feature.regionMatches(1, "./", 0, 2))) {
            ThreadContext context = this.runtime.getCurrentContext();
            feature = RubyFile.expand_path(context, (IRubyObject)Access.fileClass(context), (IRubyObject)Create.newString(context, feature)).asJavaString();
        }
        if (ext2 != -1 && feature.indexOf(47, ext2) == -1) {
            if (LibrarySearcher.isSourceExt(feature)) {
                return this.isFeature(feature, ext2, true, false, loading) != '\u0000';
            }
            if (LibrarySearcher.isLibraryExt(feature)) {
                return this.isFeature(feature, ext2, false, false, loading) != '\u0000';
            }
        }
        return this.isFeature(feature, -1, true, false, loading) != '\u0000';
    }

    protected synchronized void provideFeature(RubyString name2) {
        StringArraySet loadedFeatures = this.loadService.loadedFeatures;
        if (loadedFeatures.isFrozen()) {
            throw this.runtime.newRuntimeError("$LOADED_FEATURES is frozen; cannot append feature");
        }
        name2.setFrozen(true);
        loadedFeatures.append(this.runtime.getCurrentContext(), name2);
        this.snapshotLoadedFeatures();
        this.addFeatureToIndex(name2.toString(), name2);
    }

    protected synchronized RubyArray snapshotLoadedFeatures() {
        return (RubyArray)this.loadedFeaturesSnapshot.replace(this.runtime.getCurrentContext(), this.loadService.loadedFeatures);
    }

    protected synchronized void addFeatureToIndex(String name2, IRubyObject featurePath) {
        int ext2;
        int featureEnd = name2.length();
        for (ext2 = featureEnd - 1; ext2 > 0 && name2.charAt(ext2) != '.' && name2.charAt(ext2) != '/'; --ext2) {
        }
        if (name2.charAt(ext2) != '.') {
            ext2 = -1;
        }
        int p2 = ext2 != -1 ? ext2 : featureEnd;
        while (true) {
            --p2;
            while (p2 >= 0 && name2.charAt(p2) != '/') {
                --p2;
            }
            if (p2 < 0) break;
            this.addSingleFeatureToIndex(name2, p2 + 1, featureEnd, featurePath);
            if (ext2 == -1) continue;
            this.addSingleFeatureToIndex(name2, p2 + 1, ext2, featurePath);
        }
        this.addSingleFeatureToIndex(name2, 0, name2.length(), featurePath);
        if (ext2 != -1) {
            this.addSingleFeatureToIndex(name2, 0, ext2, featurePath);
        }
    }

    protected synchronized void addSingleFeatureToIndex(String key2, int beg, int end2, IRubyObject featurePath) {
        Map<StringWrapper, Feature> featuresIndex = this.loadedFeaturesIndex;
        this.withRangeWrapper(key2, beg, end2 - beg, wrapper -> {
            Feature thisFeature = (Feature)featuresIndex.get(wrapper);
            if (thisFeature == null) {
                StringWrapper clone2 = wrapper.dup();
                featuresIndex.put(clone2, new Feature(clone2, featurePath));
            } else {
                thisFeature.addFeaturePath(featurePath);
            }
            return thisFeature;
        });
    }

    private synchronized void releaseWrapper(StringWrapper wrapper) {
        wrapper.clear();
    }

    private synchronized StringWrapper keyWrapper(String key2) {
        StringWrapper wrapper = this.keyWrapper.get();
        wrapper.rewrap(key2, 0, key2.length());
        return wrapper;
    }

    private synchronized StringWrapper rangeWrapper(String key2, int beg, int len) {
        StringWrapper wrapper = this.rangeWrapper.get();
        wrapper.rewrap(key2, beg, len);
        return wrapper;
    }

    private synchronized <R> R withKeyWrapper(String key2, Function<StringWrapper, R> body) {
        StringWrapper wrapper = this.keyWrapper(key2);
        R result2 = body.apply(wrapper);
        this.releaseWrapper(wrapper);
        return result2;
    }

    private synchronized <R> R withRangeWrapper(String key2, int beg, int len, Function<StringWrapper, R> body) {
        StringWrapper wrapper = this.rangeWrapper(key2, beg, len);
        R result2 = body.apply(wrapper);
        this.releaseWrapper(wrapper);
        return result2;
    }

    protected char isFeature(String feature, int ext2, boolean rb, boolean expanded, String[] fn) {
        char matches;
        Suffix suffix;
        int len;
        boolean suffixGiven;
        List<PathEntry> loadPath = null;
        if (fn != null) {
            fn[0] = null;
        }
        boolean bl = suffixGiven = ext2 != -1;
        if (suffixGiven) {
            len = ext2;
            suffix = rb ? Suffix.RUBY : Suffix.JAR;
        } else {
            len = feature.length();
            suffix = null;
        }
        Feature matchingFeature = this.getLoadedFeature(feature);
        if (matchingFeature != null && (matches = matchingFeature.matches(feature, suffix, len, rb, expanded, suffixGiven)) != '\u0000') {
            return matches;
        }
        ConcurrentHashMap<String, LoadService.RequireLocks.RequireLock> loadingTable = this.loadService.requireLocks.pool;
        if (!expanded) {
            loadPath = this.lazyLoadPath(loadPath);
            for (Map.Entry entry : loadingTable.entrySet()) {
                if (LibrarySearcher.loadedFeatureWithPath((String)entry.getKey(), feature, suffix, loadPath) == null) continue;
                return this.setLoadingAndReturn(feature, fn, suffixGiven, (String)entry.getKey());
            }
        }
        if (loadingTable.containsKey(feature)) {
            return this.setLoadingAndReturn(feature, fn, suffixGiven, feature);
        }
        if (suffixGiven && ext2 == feature.length()) {
            return '\u0000';
        }
        String baseName = feature.substring(0, len);
        for (Suffix suffix2 : Suffix.ALL_ARY) {
            String withExt = suffix2.forTarget(baseName);
            if (!loadingTable.containsKey(withExt)) continue;
            if (fn != null) {
                fn[0] = withExt;
            }
            return suffix2 != Suffix.RUBY ? (char)'s' : 'r';
        }
        return '\u0000';
    }

    private char setLoadingAndReturn(String feature, String[] fn, boolean suffixGiven, String key2) {
        if (fn != null) {
            fn[0] = key2;
        }
        if (!suffixGiven) {
            return 'u';
        }
        return !LibrarySearcher.isSourceExt(feature) ? (char)'s' : 'r';
    }

    private List<PathEntry> lazyLoadPath(List<PathEntry> loadPath) {
        return loadPath == null ? this.getExpandedLoadPath() : loadPath;
    }

    synchronized Map<StringWrapper, Feature> getLoadedFeaturesIndex() {
        StringArraySet loadedFeatures = this.loadService.loadedFeatures;
        if (!this.loadedFeaturesSnapshot.isSharedJavaArray(loadedFeatures)) {
            this.loadedFeaturesIndex.clear();
            Ruby runtime2 = this.runtime;
            RubyArray features = this.snapshotLoadedFeatures();
            boolean modified = false;
            for (int i2 = 0; i2 < features.size(); ++i2) {
                Object entry = features.eltOk(i2);
                RubyString asStr = runtime2.freezeAndDedupString(entry.convertToString());
                if (asStr != entry) {
                    modified = true;
                    loadedFeatures.eltSetOk(i2, asStr);
                }
                this.addFeatureToIndex(asStr.toString(), asStr);
            }
            if (modified) {
                this.snapshotLoadedFeatures();
            }
        }
        return this.loadedFeaturesIndex;
    }

    Feature getLoadedFeature(String feature) {
        return this.withKeyWrapper(feature, wrapper -> this.getLoadedFeaturesIndex().get(wrapper));
    }

    static String loadedFeatureWithPath(String name2, String feature, Suffix suffix, List<PathEntry> loadPath) {
        int plen;
        int featureLength;
        int nameLength = name2.length();
        if (nameLength <= (featureLength = feature.length())) {
            return null;
        }
        if (feature.indexOf(46) != -1 && name2.endsWith(feature)) {
            plen = nameLength - featureLength;
        } else {
            int e;
            for (e = nameLength - 1; e > 0 && name2.charAt(e) != '.' && name2.charAt(e) != '/'; --e) {
            }
            if (name2.charAt(e) != '.' || e < featureLength || !name2.regionMatches(e - featureLength, feature, 0, featureLength)) {
                return null;
            }
            plen = e - featureLength;
        }
        if (plen > 0 && name2.charAt(plen - 1) != '/') {
            return null;
        }
        if (suffix == Suffix.JAR && !LibrarySearcher.isLibraryExt(name2) || suffix == Suffix.RUBY && !LibrarySearcher.isSourceExt(name2)) {
            return null;
        }
        if (plen > 0) {
            --plen;
        }
        for (int i2 = 0; i2 < loadPath.size(); ++i2) {
            PathEntry pathEntry = loadPath.get(i2);
            String path2 = pathEntry.path();
            int n = path2.length();
            if (n != plen || n > 0 && !name2.startsWith(path2)) continue;
            return path2;
        }
        return null;
    }

    private FoundLibrary findServiceLibrary(String name2) {
        DebugLog.JarExtension.logTry(name2);
        ClassExtensionLibrary extensionLibrary = ClassExtensionLibrary.tryFind(this.runtime, name2);
        if (extensionLibrary != null) {
            DebugLog.JarExtension.logFound(name2);
            return new FoundLibrary(name2, name2, extensionLibrary);
        }
        return null;
    }

    private FoundLibrary findResourceLibrary(String baseName, FilenameFactory pathMaker, LibraryFactory libraryMaker) {
        FoundLibrary library2;
        if (baseName.startsWith("./") || baseName.startsWith("../") || LibrarySearcher.isAbsolute(baseName)) {
            return this.nullPathEntry.findFile(baseName, pathMaker, libraryMaker);
        }
        if (baseName.startsWith("~/")) {
            return this.homePathEntry.findFile(baseName.substring(2), pathMaker, libraryMaker);
        }
        for (PathEntry loadPathEntry : this.getExpandedLoadPath()) {
            FoundLibrary library3 = loadPathEntry.findFile(baseName, pathMaker, libraryMaker);
            if (library3 == null) continue;
            return library3;
        }
        if (!this.runtime.getCurrentDirectory().startsWith("uri:classloader:") && (library2 = this.cwdPathEntry.findFile(baseName, pathMaker, libraryMaker)) != null) {
            return null;
        }
        return this.classloaderPathEntry.findFile(baseName, pathMaker, libraryMaker);
    }

    private static boolean isAbsolute(String path2) {
        return LibrarySearcher.isURI(path2) || new File(path2).isAbsolute();
    }

    private static boolean isURI(String path2) {
        if (path2.startsWith("jar:")) {
            path2 = path2.substring(4);
        }
        if (path2.startsWith("file:")) {
            return true;
        }
        if (path2.startsWith("uri:")) {
            return true;
        }
        return path2.startsWith("classpath:");
    }

    public void tearDown() {
        this.loadedFeaturesIndex.clear();
        this.loadedFeaturesSnapshot.clear();
    }

    class NormalPathEntry
    extends PathEntry {
        final IRubyObject path;
        final boolean cacheExpanded;
        FileResource expanded;

        NormalPathEntry(IRubyObject path2) {
            this.path = path2;
            this.cacheExpanded = this.isCachable(LibrarySearcher.this.runtime, path2);
        }

        @Override
        protected String path() {
            return this.expandPathCached().path();
        }

        @Override
        protected FileResource fullPath(String searchFile, Function<String, String> pathMaker) {
            FileResource loadPath = this.expandPathCached();
            String fullPath = loadPath.path() + "/" + pathMaker.apply(searchFile);
            DebugLog.Resource.logTry(fullPath);
            return JRubyFile.createResourceAsFile(LibrarySearcher.this.runtime, fullPath);
        }

        private FileResource expandPathCached() {
            if (this.cacheExpanded) {
                FileResource expanded = this.expanded;
                if (expanded != null) {
                    return expanded;
                }
                expanded = this.expanded = this.expandPath();
                return expanded;
            }
            FileResource expanded = this.expandPath();
            return expanded;
        }

        private FileResource expandPath() {
            FileResource resource = JRubyFile.createResourceAsFile(LibrarySearcher.this.runtime, Helpers.javaStringFromPath(LibrarySearcher.this.runtime, this.path));
            return JRubyFile.createResourceAsFile(LibrarySearcher.this.runtime, resource.canonicalPath());
        }

        private boolean isCachable(Ruby runtime2, IRubyObject path2) {
            if (!(path2 instanceof RubyString)) {
                return false;
            }
            String pathAsString = path2.asJavaString();
            if (pathAsString.length() == 0) {
                return false;
            }
            if (LibrarySearcher.isURI(pathAsString)) {
                return false;
            }
            if (!new File(pathAsString).isAbsolute()) {
                return false;
            }
            FileResource resource = JRubyFile.createResourceAsFile(runtime2, pathAsString);
            return !resource.isFile();
        }
    }

    abstract class PathEntry {
        PathEntry() {
        }

        protected FoundLibrary findFile(String target2, FilenameFactory pathMaker, LibraryFactory libraryMaker) {
            Ruby runtime2 = LibrarySearcher.this.runtime;
            FileResource fullPath = this.fullPath(target2, pathMaker);
            if (fullPath == null) {
                return null;
            }
            if (fullPath.exists()) {
                FileResource expandedResource;
                String canonicalPath = fullPath.canonicalPath();
                String absolutePath = fullPath.absolutePath();
                if (!absolutePath.equals(canonicalPath) && (expandedResource = JRubyFile.createResourceAsFile(runtime2, canonicalPath)).exists()) {
                    String expandedAbsolute = expandedResource.absolutePath();
                    DebugLog.Resource.logFound(fullPath);
                    return new FoundLibrary(target2, expandedAbsolute, (Library)libraryMaker.apply(target2, expandedAbsolute, fullPath));
                }
                DebugLog.Resource.logFound(fullPath);
                String resolvedName = absolutePath;
                return new FoundLibrary(target2, resolvedName, (Library)libraryMaker.apply(target2, resolvedName, fullPath));
            }
            return null;
        }

        protected abstract String path();

        protected abstract FileResource fullPath(String var1, Function<String, String> var2);
    }

    class NullPathEntry
    extends PathEntry {
        NullPathEntry() {
        }

        @Override
        protected String path() {
            return "";
        }

        @Override
        protected FileResource fullPath(String searchFile, Function<String, String> pathMaker) {
            return JRubyFile.createResourceAsFile(LibrarySearcher.this.runtime, pathMaker.apply(searchFile));
        }
    }

    class HomePathEntry
    extends PathEntry {
        HomePathEntry() {
        }

        @Override
        protected String path() {
            return this.resolveHome();
        }

        @Override
        protected FileResource fullPath(String searchFile, Function<String, String> pathMaker) {
            String fullPath = this.resolveHome();
            if (fullPath == null) {
                return null;
            }
            DebugLog.Resource.logTry(fullPath);
            return JRubyFile.createResourceAsFile(LibrarySearcher.this.runtime, fullPath + "/" + pathMaker.apply(searchFile));
        }

        private String resolveHome() {
            Optional<String> home2 = RubyDir.getHomeFromEnv(LibrarySearcher.this.runtime);
            if (!home2.isPresent()) {
                return null;
            }
            String fullPath = home2.get();
            return fullPath;
        }
    }

    class ExpandedLoadPath {
        final RubyArray loadPath;
        final RubyArray loadPathSnapshot;
        final List<PathEntry> pathEntries;

        ExpandedLoadPath(LibrarySearcher this$0, RubyArray loadPath) {
            this.loadPath = loadPath;
            RubyArray loadPathSnapshot = loadPath.aryDup();
            ArrayList<PathEntry> pathEntries = new ArrayList<PathEntry>(loadPathSnapshot.size());
            for (int i2 = 0; i2 < loadPathSnapshot.size(); ++i2) {
                Object path2 = loadPathSnapshot.eltOk(i2);
                pathEntries.add(this$0.new NormalPathEntry((IRubyObject)path2));
            }
            this.loadPathSnapshot = loadPathSnapshot;
            this.pathEntries = pathEntries;
        }

        boolean isCurrent() {
            return this.loadPathSnapshot.isSharedJavaArray(this.loadPath);
        }
    }

    public static class FoundLibrary
    implements Library {
        private final Library delegate;
        private final String searchName;
        private final String loadName;

        public FoundLibrary(String searchName, String loadName, Library delegate) {
            this.searchName = searchName;
            this.loadName = loadName;
            this.delegate = delegate;
        }

        @Override
        public void load(Ruby runtime2, boolean wrap2) throws IOException {
            this.delegate.load(runtime2, wrap2);
        }

        public String getLoadName() {
            return this.loadName;
        }

        public String getSearchName() {
            return this.searchName;
        }
    }

    static enum Suffix {
        RUBY(".rb", ResourceLibrary::new),
        CLASS(".class", ClassResourceLibrary::new),
        JAR(".jar", JarResourceLibrary::new);

        static final EnumSet<Suffix> SOURCES;
        static final EnumSet<Suffix> EXTENSIONS;
        static final EnumSet<Suffix> ALL;
        static final Suffix[] ALL_ARY;
        private final String extension;
        private final byte[] extensionBytes;
        private final LibraryFactory libraryFactory;

        private Suffix(String extension, LibraryFactory libraryFactory) {
            this.extension = extension;
            this.extensionBytes = extension.getBytes();
            this.libraryFactory = libraryFactory;
        }

        public Library constructLibrary(String target2, String name2, FileResource fullPath) {
            return (Library)this.libraryFactory.apply(target2, name2, fullPath);
        }

        public String forTarget(String targetName) {
            return targetName + this.extension;
        }

        public ByteList forTarget(ByteList targetName) {
            ByteList dup2 = targetName.shallowDup();
            dup2.append(this.extensionBytes);
            return dup2;
        }

        public static Suffix forString(String withSuffix) {
            int last2 = withSuffix.lastIndexOf(46);
            if (last2 > -1) {
                switch (withSuffix.substring(last2)) {
                    case ".rb": {
                        return RUBY;
                    }
                    case ".jar": {
                        return JAR;
                    }
                    case ".class": {
                        return CLASS;
                    }
                }
            }
            throw new RuntimeException("invalid suffix in LoadService (missing '.'?): " + withSuffix);
        }

        static {
            SOURCES = Options.AOT_LOADCLASSES.load() != false ? EnumSet.of(RUBY, CLASS) : EnumSet.of(RUBY);
            EXTENSIONS = EnumSet.of(JAR);
            ALL = Options.AOT_LOADCLASSES.load() != false ? EnumSet.of(RUBY, CLASS, JAR) : EnumSet.of(RUBY, JAR);
            ALL_ARY = (Suffix[])ALL.stream().toArray(Suffix[]::new);
        }
    }

    static interface FilenameFactory
    extends Function<String, String> {
    }

    static interface LibraryFactory
    extends TriFunction<String, String, FileResource, Library> {
    }

    protected static class StringWrapper
    implements CharSequence {
        private String str;
        private int beg;
        private int len;
        private int hash;

        StringWrapper(String str, int beg, int len) {
            this.str = str;
            this.beg = beg;
            this.len = len;
        }

        void rewrap(String str, int beg, int len) {
            this.str = str;
            this.beg = beg;
            this.len = len;
            this.hash = 0;
        }

        void clear() {
            this.str = null;
            this.beg = 0;
            this.len = 0;
            this.hash = 0;
        }

        StringWrapper dup() {
            return new StringWrapper(this.str, this.beg, this.len);
        }

        @Override
        public int length() {
            return this.len;
        }

        @Override
        public char charAt(int index2) {
            return this.str.charAt(this.beg + index2);
        }

        @Override
        public CharSequence subSequence(int start2, int end2) {
            return new StringWrapper(this.str, this.beg + start2, end2 - start2);
        }

        @Override
        public String toString() {
            return "StringWrapper(" + (this.str == null ? "" : this.str.substring(this.beg, this.beg + this.len)) + ")";
        }

        public boolean equals(Object other) {
            String otherStr;
            String str;
            int otherBeg;
            int otherLen;
            int beg = this.beg;
            int len = this.len;
            if (other instanceof StringWrapper) {
                StringWrapper otherWrapper = (StringWrapper)other;
                otherLen = otherWrapper.len;
                if (len != otherLen) {
                    return false;
                }
                otherBeg = otherWrapper.beg;
                str = this.str;
                otherStr = otherWrapper.str;
            } else if (other instanceof String) {
                otherStr = (String)other;
                otherLen = otherStr.length();
                if (len != otherLen) {
                    return false;
                }
                otherBeg = 0;
                str = this.str;
            } else {
                return false;
            }
            if (str == otherStr && beg == otherBeg) {
                return true;
            }
            return str.regionMatches(beg, otherStr, otherBeg, otherLen);
        }

        public int hashCode() {
            int h = this.hash;
            int len = this.len;
            if (h == 0 && len > 0) {
                String str = this.str;
                int beg = this.beg;
                for (int i2 = 0; i2 < len; ++i2) {
                    h = 31 * h + str.charAt(beg + i2);
                }
                this.hash = h;
            }
            return h;
        }
    }

    class Feature {
        final StringWrapper key;
        private final List<IRubyObject> featurePaths;

        Feature(StringWrapper key2, IRubyObject featurePath) {
            this.key = key2;
            this.featurePaths = new ArrayList<IRubyObject>();
            this.featurePaths.add(featurePath);
        }

        synchronized void addFeaturePath(IRubyObject offset2) {
            this.featurePaths.add(offset2);
        }

        public synchronized void clear() {
            this.featurePaths.clear();
        }

        public synchronized char matches(String feature, Suffix suffix, int len, boolean rb, boolean expanded, boolean suffixGiven) {
            List<IRubyObject> featurePaths = this.featurePaths;
            for (int i2 = 0; i2 < featurePaths.size(); ++i2) {
                int e;
                IRubyObject featurePath = featurePaths.get(i2);
                RubyString loadedFeaturePath = featurePath.convertToString();
                if (loadedFeaturePath.length() < len) continue;
                String featureString = loadedFeaturePath.asJavaString();
                int expandedPathLength = 0;
                if (!featureString.regionMatches(0, feature, 0, len)) {
                    List<PathEntry> loadPath;
                    String withPath;
                    if (expanded || (withPath = LibrarySearcher.loadedFeatureWithPath(featureString, feature, suffix, loadPath = LibrarySearcher.this.getExpandedLoadPath())) == null) continue;
                    expanded = true;
                    expandedPathLength = withPath.length() + 1;
                }
                if ((e = expandedPathLength + len) == featureString.length()) {
                    if (suffixGiven) continue;
                    return 'u';
                }
                if (featureString.charAt(e) != '.') continue;
                if (!(rb && suffixGiven || !LibrarySearcher.isLibraryExt(featureString))) {
                    return 's';
                }
                if (!rb && suffixGiven || !LibrarySearcher.isSourceExt(featureString)) continue;
                return 'r';
            }
            return '\u0000';
        }
    }

    static class JarResourceLibrary
    extends ResourceLibrary {
        public JarResourceLibrary(String searchName, String scriptName, FileResource resource) {
            super(searchName, scriptName, resource);
        }

        @Override
        public void load(Ruby runtime2, boolean wrap2) {
            try {
                URL url;
                if (this.location.startsWith("uri:")) {
                    url = URLResource.getResourceURL(runtime2, this.location);
                } else {
                    File f = new File(this.location);
                    if (f.exists() || this.location.contains("!")) {
                        url = f.toURI().toURL();
                        if (this.location.contains("!")) {
                            url = new URL("jar:" + String.valueOf(url));
                        }
                    } else {
                        url = new URL(this.location);
                    }
                }
                runtime2.getJRubyClassLoader().addURL(url);
            }
            catch (MalformedURLException badUrl) {
                throw runtime2.newIOErrorFromException(badUrl);
            }
            ClassExtensionLibrary serviceExtension = ClassExtensionLibrary.tryFind(runtime2, this.searchName);
            if (serviceExtension != null) {
                serviceExtension.load(runtime2, wrap2);
            }
        }
    }

    static class ClassResourceLibrary
    extends ResourceLibrary {
        public ClassResourceLibrary(String searchName, String scriptName, FileResource resource) {
            super(searchName, scriptName, resource);
        }

        @Override
        public void load(Ruby runtime2, boolean wrap2) {
            try (InputStream ris = this.resource.openInputStream();){
                BufferedInputStream is = new BufferedInputStream(ris, 32768);
                IRScope script = CompiledScriptLoader.loadScriptFromFile(runtime2, is, null, this.scriptName, false);
                if (script == null) {
                    return;
                }
                script.setFileName(this.scriptName);
                runtime2.loadScope(script, wrap2);
            }
            catch (IOException e) {
                String name2 = this.searchName;
                throw LoadService.loadFailed(runtime2, name2);
            }
        }
    }

    static class ResourceLibrary
    implements Library {
        protected final String searchName;
        protected final String scriptName;
        protected final FileResource resource;
        protected final String location;

        public static ResourceLibrary create(String searchName, String scriptName, FileResource resource) {
            String location = resource.absolutePath();
            if (location.endsWith(".class")) {
                return new ClassResourceLibrary(searchName, scriptName, resource);
            }
            if (location.endsWith(".jar")) {
                return new JarResourceLibrary(searchName, scriptName, resource);
            }
            return new ResourceLibrary(searchName, scriptName, resource);
        }

        public ResourceLibrary(String searchName, String scriptName, FileResource resource) {
            this.searchName = searchName;
            this.scriptName = scriptName;
            this.location = resource.absolutePath();
            this.resource = resource;
        }

        @Override
        public void load(Ruby runtime2, boolean wrap2) {
            LoadServiceResourceInputStream ris = this.prepareInputStream(runtime2);
            if (runtime2.getInstanceConfig().getCompileMode().shouldPrecompileAll()) {
                runtime2.compileAndLoadFile(this.scriptName, ris, wrap2);
            } else {
                runtime2.loadFile(this.scriptName, ris, wrap2);
            }
        }

        private LoadServiceResourceInputStream prepareInputStream(Ruby runtime2) {
            LoadServiceResourceInputStream loadServiceResourceInputStream;
            block8: {
                InputStream is = this.resource.openInputStream();
                try {
                    loadServiceResourceInputStream = new LoadServiceResourceInputStream(is);
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        throw runtime2.newLoadError("failure to load file: " + ioe.getLocalizedMessage(), this.searchName);
                    }
                }
                is.close();
            }
            return loadServiceResourceInputStream;
        }
    }
}

