/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import org.jruby.RubyThread;
import org.jruby.internal.runtime.ThreadLike;

public class RubyNativeThread
implements ThreadLike {
    private final Thread thread;
    public final RubyThread rubyThread;
    public String rubyName;
    private static final String RUBY_THREAD_PREFIX = "Ruby-";

    public RubyNativeThread(RubyThread rubyThread, Thread nativeThread) {
        this.rubyThread = rubyThread;
        this.thread = nativeThread;
        this.rubyName = null;
    }

    @Override
    public void interrupt() {
        this.thread.interrupt();
    }

    @Override
    public boolean isAlive() {
        return this.thread.isAlive();
    }

    @Override
    public void join() throws InterruptedException {
        this.thread.join();
    }

    @Override
    public void join(long timeoutMillis) throws InterruptedException {
        this.thread.join(timeoutMillis);
    }

    @Override
    public int getPriority() {
        return this.thread.getPriority();
    }

    @Override
    public void setPriority(int priority2) {
        this.thread.setPriority(priority2);
    }

    @Override
    public boolean isCurrent() {
        return this.thread == Thread.currentThread();
    }

    @Override
    public boolean isInterrupted() {
        return this.thread.isInterrupted();
    }

    public String toString() {
        return String.valueOf(this.thread);
    }

    @Override
    public Thread nativeThread() {
        return this.thread;
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return this.thread.getStackTrace();
    }

    @Override
    public void setRubyName(String id2) {
        this.rubyName = id2;
        this.updateName();
    }

    @Override
    @Deprecated(since="9.2.0.0")
    public String getRubyName() {
        return this.rubyName;
    }

    @Override
    public String getReportName() {
        String nativeName = "";
        nativeName = this.thread.getName();
        if (this.rubyName == null || this.rubyName.length() == 0) {
            return nativeName.equals("") ? "(unnamed)" : nativeName;
        }
        return nativeName.equals("") ? this.rubyName : this.rubyName + " (" + nativeName + ")";
    }

    void updateName() {
        String newName;
        String setName2 = this.rubyName;
        String currentName = this.thread.getName();
        if (currentName != null && currentName.startsWith(RUBY_THREAD_PREFIX)) {
            int i2 = currentName.indexOf(64);
            if (i2 == -1) {
                int end2 = currentName.indexOf(58);
                if (end2 == -1) {
                    end2 = currentName.length();
                }
                String prefix = currentName.substring(0, end2);
                newName = currentName.replace(prefix, prefix + "@" + setName2);
            } else {
                String prefix = currentName.substring(0, i2);
                int end3 = currentName.indexOf(58, i2);
                if (end3 == -1) {
                    end3 = currentName.length();
                }
                String prefixWithName = currentName.substring(0, end3);
                newName = currentName.replace(prefixWithName, (CharSequence)(setName2 == null ? prefix : prefix + "@" + setName2));
            }
        } else {
            return;
        }
        try {
            this.thread.setName(newName);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

