/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.util.KeyValuePair;

public class HashNode
extends Node
implements ILiteralNode {
    private final List<KeyValuePair<Node, Node>> pairs = new ArrayList<KeyValuePair<Node, Node>>();
    private boolean hasRestKwarg = false;
    private boolean hasOnlySymbolKeys = true;
    private boolean isLiteral = false;

    public HashNode(int line) {
        super(line, false);
    }

    public HashNode(int line, KeyValuePair<Node, Node> pair) {
        this(line);
        this.add(pair);
    }

    public void setIsLiteral() {
        this.isLiteral = true;
    }

    public boolean isLiteral() {
        return this.isLiteral;
    }

    public boolean hasRestKwarg() {
        return this.hasRestKwarg;
    }

    public boolean hasOnlyRestKwargs() {
        if (!this.hasRestKwarg) {
            return false;
        }
        for (KeyValuePair<Node, Node> pair : this.pairs) {
            if (pair.getKey() == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.HASHNODE;
    }

    public HashNode add(KeyValuePair<Node, Node> pair) {
        Node key2 = pair.getKey();
        if (key2 != null && key2.containsVariableAssignment() || pair.getValue() != null && pair.getValue().containsVariableAssignment()) {
            this.containsVariableAssignment = true;
        }
        if (key2 == null) {
            this.hasRestKwarg = true;
            this.hasOnlySymbolKeys = false;
        } else if (!(pair.getKey() instanceof SymbolNode)) {
            this.hasOnlySymbolKeys = false;
        }
        this.pairs.add(pair);
        return this;
    }

    public boolean removeAll(Collection<KeyValuePair<Node, Node>> pairsToRemove) {
        boolean changed = this.pairs.removeAll(pairsToRemove);
        if (changed) {
            this.hasRestKwarg = false;
            this.isLiteral = false;
            this.hasOnlySymbolKeys = true;
            Object[] pairsCopy = this.pairs.toArray();
            this.pairs.clear();
            for (int i2 = 0; i2 < pairsCopy.length; ++i2) {
                this.add((KeyValuePair)pairsCopy[i2]);
            }
            return true;
        }
        return false;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitHashNode(this);
    }

    public boolean isEmpty() {
        return this.pairs.isEmpty();
    }

    public List<KeyValuePair<Node, Node>> getPairs() {
        return this.pairs;
    }

    @Override
    public List<Node> childNodes() {
        ArrayList<Node> children2 = new ArrayList<Node>();
        for (KeyValuePair<Node, Node> pair : this.pairs) {
            children2.add(pair.getKey());
            children2.add(pair.getValue());
        }
        return children2;
    }

    @Override
    public String toStringExtraInfo() {
        return this.isLiteral() ? "literal" : (this.hasRestKwarg() ? (this.hasOnlyRestKwargs() ? "onlykwrest" : "mixedkwrest") : "kwarg");
    }

    public boolean hasOnlySymbolKeys() {
        return this.hasOnlySymbolKeys;
    }

    @Deprecated(since="9.4.0.0")
    public boolean isMaybeKwargs() {
        return !this.isLiteral;
    }

    public Node[] getKeys() {
        int length2 = this.pairs.size();
        Node[] keys2 = new Node[length2];
        for (int i2 = 0; i2 < length2; ++i2) {
            keys2[i2] = this.pairs.get(i2).getKey();
        }
        return keys2;
    }
}

