/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.api.Warn;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.IRBlockBody;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.MethodBlockBody;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.DataType;
import org.jruby.util.RubyStringBuilder;

@JRubyClass(name={"Proc"})
public class RubyProc
extends RubyObject
implements DataType {
    private Block block = Block.NULL_BLOCK;
    private final Block.Type type;
    private String file = null;
    private int line = -1;
    private boolean fromMethod;

    protected RubyProc(Ruby runtime2, RubyClass rubyClass, Block.Type type2) {
        super(runtime2, rubyClass);
        this.type = type2;
    }

    @Deprecated(since="9.0.0.0")
    protected RubyProc(Ruby runtime2, RubyClass rubyClass, Block.Type type2, ISourcePosition sourcePosition) {
        this(runtime2, rubyClass, type2, sourcePosition.getFile(), sourcePosition.getLine());
    }

    protected RubyProc(Ruby runtime2, RubyClass rubyClass, Block.Type type2, String file2, int line) {
        this(runtime2, rubyClass, type2);
        this.file = file2;
        this.line = line;
    }

    public RubyProc(Ruby runtime2, RubyClass rubyClass, Block block, String file2, int line) {
        this(runtime2, rubyClass, block.type, file2, line);
        this.block = block;
    }

    public static RubyClass createProcClass(ThreadContext context, RubyClass Object2) {
        return (RubyClass)((RubyModule)((RubyModule)Define.defineClass(context, "Proc", Object2, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR).reifiedClass(RubyProc.class)).classIndex(ClassIndex.PROC)).defineMethods(context, RubyProc.class);
    }

    public Block getBlock() {
        return this.block;
    }

    @Deprecated(since="1.6.0")
    public static RubyProc newProc(Ruby runtime2, Block.Type type2) {
        throw runtime2.newRuntimeError("deprecated RubyProc.newProc with no block; do not use");
    }

    public static RubyProc newProc(Ruby runtime2, Block block, Block.Type type2) {
        if (type2 == Block.Type.NORMAL) {
            type2 = Block.Type.PROC;
        }
        RubyProc proc2 = new RubyProc(runtime2, runtime2.getProc(), type2);
        proc2.setup(runtime2, block);
        return proc2;
    }

    @Deprecated(since="9.0.0.0")
    public static RubyProc newProc(Ruby runtime2, Block block, Block.Type type2, ISourcePosition sourcePosition) {
        RubyProc proc2 = new RubyProc(runtime2, runtime2.getProc(), type2, sourcePosition);
        proc2.setup(runtime2, block);
        return proc2;
    }

    public static RubyProc newProc(Ruby runtime2, Block block, Block.Type type2, String file2, int line) {
        RubyClass clazz = runtime2.getProc();
        return RubyProc.newProc(runtime2, clazz, block, type2, file2, line);
    }

    public static RubyProc newProc(Ruby runtime2, RubyClass clazz, Block block, Block.Type type2, String file2, int line) {
        RubyProc proc2 = new RubyProc(runtime2, clazz, type2, file2, line);
        proc2.setup(runtime2, block);
        return proc2;
    }

    @JRubyMethod(name={"new"}, rest=true, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            throw Error.argumentError(context, "tried to create Proc object without a block");
        }
        if (block.isGiven() && block.getProcObject() != null && block.getProcObject().metaClass == recv2) {
            return block.getProcObject();
        }
        RubyProc obj = new RubyProc(context.runtime, (RubyClass)recv2, Block.Type.PROC);
        obj.setup(context.runtime, block);
        obj.callMethod(context, "initialize", args2, block);
        return obj;
    }

    private void setup(Ruby runtime2, Block procBlock) {
        if (!procBlock.isGiven()) {
            throw Error.argumentError(runtime2.getCurrentContext(), "tried to create Proc object without a block");
        }
        if (this.isLambda()) {
            // empty if block
        }
        if (this.isThread()) {
            Binding oldBinding = procBlock.getBinding();
            Binding newBinding = new Binding(oldBinding.getSelf(), oldBinding.getFrame().duplicate(), oldBinding.getVisibility(), oldBinding.getDynamicScope(), oldBinding.getMethod(), oldBinding.getFile(), oldBinding.getLine());
            this.block = new Block(procBlock.getBody(), newBinding, this.type);
            this.block.escape();
            StaticScope oldScope = this.block.getBody().getStaticScope();
            StaticScope newScope = oldScope.duplicate();
            this.block.getBody().setStaticScope(newScope);
        } else {
            this.block = this.type != procBlock.type ? procBlock.cloneBlockAsType(this.type) : procBlock;
        }
        this.block.getBinding().setFile(this.block.getBody().getFile());
        this.block.getBinding().setLine(this.block.getBody().getLine());
        this.block.setProcObject(this);
        this.block.getBinding().getDummyScope(this.block.getBody().getStaticScope());
    }

    @JRubyMethod(name={"clone"})
    public IRubyObject rbClone(ThreadContext context) {
        return this.cloneSetup(context, this.procDup(), context.nil);
    }

    @Override
    @JRubyMethod(name={"dup"})
    public IRubyObject dup(ThreadContext context) {
        return this.dupSetup(context, this.procDup());
    }

    private RubyProc procDup() {
        return RubyProc.newProc(this.getRuntime(), this.getMetaClass(), this.block, this.type, this.file, this.line);
    }

    @Override
    @JRubyMethod(name={"to_s"}, alias={"inspect"})
    public IRubyObject to_s(ThreadContext context) {
        RubyString string2 = Create.newString(context, "#<");
        string2.setEncoding(RubyString.ASCII);
        string2.append(RubyStringBuilder.types(context.runtime, (RubyModule)this.type()));
        string2.catStringUnsafe(":0x" + Integer.toString(System.identityHashCode(this.block), 16));
        boolean isSymbolProc = this.block.getBody() instanceof RubySymbol.SymbolProcBody;
        if (isSymbolProc) {
            string2.catStringUnsafe("(&:" + ((RubySymbol.SymbolProcBody)this.block.getBody()).getId() + ")");
        } else {
            this.file = this.block.getBody().getFile();
            if (this.file != null) {
                string2.catStringUnsafe(" " + this.file + ":" + (this.block.getBody().getLine() + 1));
            }
        }
        if (this.isLambda()) {
            string2.catStringUnsafe(" (lambda)");
        }
        string2.catStringUnsafe(">");
        return string2;
    }

    @JRubyMethod
    public IRubyObject ruby2_keywords(ThreadContext context) {
        this.checkFrozen();
        if (this.fromMethod) {
            Warn.warn(context, "Skipping set of ruby2_keywords flag for proc (proc created from method)");
            return this;
        }
        BlockBody body = this.block.getBody();
        if (body.isRubyBlock()) {
            Signature signature = body.getSignature();
            if (signature.hasRest() && !signature.hasKwargs()) {
                ((IRBlockBody)body).getScope().setRuby2Keywords();
            } else {
                Warn.warn(context, "Skipping set of ruby2_keywords flag for proc (proc accepts keywords or proc does not accept argument splat)");
            }
        } else {
            Warn.warn(context, "Skipping set of ruby2_keywords flag for proc (proc not defined in Ruby)");
        }
        return this;
    }

    @JRubyMethod(name={"binding"})
    public IRubyObject binding() {
        return this.getRuntime().newBinding(this.block.getBinding());
    }

    @Override
    @JRubyMethod(name={"==", "eql?"})
    public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
        if (this.getMetaClass() != obj.getMetaClass()) {
            return context.fals;
        }
        RubyProc other = (RubyProc)obj;
        if (this.isFromMethod() != other.isFromMethod() && this.isLambda() != other.isLambda()) {
            return context.fals;
        }
        if (this.type != other.type) {
            return context.fals;
        }
        return Convert.asBoolean(context, this.getBlock().equals(other.block));
    }

    @Deprecated(since="9.3.0.0")
    public static IRubyObject[] prepareArgs(ThreadContext context, Block.Type type2, BlockBody blockBody, IRubyObject[] args2) {
        if (type2 == Block.Type.LAMBDA) {
            return args2;
        }
        int arityValue = blockBody.getSignature().arityValue();
        if (args2.length == 1 && (arityValue < -1 || arityValue > 1)) {
            args2 = IRRuntimeHelpers.toAry(context, args2);
        }
        return args2;
    }

    private static IRubyObject[] checkArityForLambda(ThreadContext context, Block.Type type2, BlockBody blockBody, IRubyObject ... args2) {
        if (type2 == Block.Type.LAMBDA) {
            blockBody.getSignature().checkArity(context, args2);
        }
        return args2;
    }

    @JRubyMethod(name={"call", "[]", "yield", "==="}, rest=true, omit=true, keywords=true)
    public final IRubyObject call(ThreadContext context, IRubyObject[] args2, Block blockCallArg) {
        return this.block.call(context, args2, blockCallArg);
    }

    @JRubyMethod(name={"call", "[]", "yield", "==="}, omit=true, keywords=true)
    public final IRubyObject call(ThreadContext context, Block blockCallArg) {
        return this.block.call(context, RubyProc.checkArityForLambda(context, this.type, this.block.getBody(), NULL_ARRAY), blockCallArg);
    }

    @JRubyMethod(name={"call", "[]", "yield", "==="}, omit=true, keywords=true)
    public final IRubyObject call(ThreadContext context, IRubyObject arg0, Block blockCallArg) {
        return this.block.call(context, new IRubyObject[]{arg0}, blockCallArg);
    }

    @JRubyMethod(name={"call", "[]", "yield", "==="}, omit=true, keywords=true)
    public final IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block blockCallArg) {
        return this.block.call(context, RubyProc.checkArityForLambda(context, this.type, this.block.getBody(), arg0, arg1), blockCallArg);
    }

    @JRubyMethod(name={"call", "[]", "yield", "==="}, omit=true, keywords=true)
    public final IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block blockCallArg) {
        return this.block.call(context, RubyProc.checkArityForLambda(context, this.type, this.block.getBody(), arg0, arg1, arg2), blockCallArg);
    }

    public final IRubyObject call(ThreadContext context, IRubyObject arg2) {
        return this.block.call(context, arg2);
    }

    public final IRubyObject call(ThreadContext context, IRubyObject ... args2) {
        return this.block.call(context, args2);
    }

    public final IRubyObject call(ThreadContext context, IRubyObject[] args2, IRubyObject self2, RubyModule sourceModule, Block passedBlock) {
        Block newBlock;
        assert (args2 != null);
        if (self2 == null || sourceModule == null) {
            newBlock = this.block;
        } else {
            newBlock = this.block.cloneBlockAndFrame();
            if (self2 != null) {
                newBlock.getBinding().setSelf(self2);
            }
            if (sourceModule != null) {
                newBlock.getFrame().setKlazz(sourceModule);
            }
        }
        return newBlock.call(context, args2, passedBlock);
    }

    @Deprecated(since="10.0.0.0")
    public RubyFixnum arity() {
        return this.arity(this.getCurrentContext());
    }

    @JRubyMethod(name={"arity"})
    public RubyFixnum arity(ThreadContext context) {
        Signature signature = this.block.getSignature();
        int min2 = signature.min();
        int max2 = signature.max();
        boolean test2 = this.isLambda() ? min2 == max2 : max2 != -1;
        return Convert.asFixnum(context, test2 ? min2 : -min2 - 1);
    }

    @JRubyMethod(name={"to_proc"})
    public RubyProc to_proc() {
        return this;
    }

    @JRubyMethod
    public IRubyObject source_location(ThreadContext context) {
        Binding binding2;
        if (this.file != null) {
            return Create.newArray(context, (IRubyObject)Create.newString(context, this.file), (IRubyObject)Convert.asFixnum(context, this.line + 1));
        }
        if (this.block != null && (binding2 = this.block.getBinding()).getFile() != null) {
            return Create.newArray(context, (IRubyObject)Create.newString(context, binding2.getFile()), (IRubyObject)Convert.asFixnum(context, binding2.getLine() + 1));
        }
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject parameters(ThreadContext context) {
        return this.parametersCommon(context, this.isLambda());
    }

    @JRubyMethod(keywords=true)
    public IRubyObject parameters(ThreadContext context, IRubyObject opts) {
        int callInfo = ThreadContext.resetCallInfo(context);
        boolean isLambda = this.isLambda();
        IRubyObject lambdaOpt = ArgsUtil.extractKeywordArg(context, (RubyHash)opts, "lambda");
        if (!lambdaOpt.isNil()) {
            isLambda = (callInfo & 2) != 0 ? lambdaOpt.isTrue() : this.isLambda();
        }
        return this.parametersCommon(context, isLambda);
    }

    private IRubyObject parametersCommon(ThreadContext context, boolean isLambda) {
        BlockBody body = this.getBlock().getBody();
        return Helpers.argumentDescriptorsToParameters(context, body.getArgumentDescriptors(), isLambda);
    }

    @JRubyMethod(name={"lambda?"})
    public IRubyObject lambda_p(ThreadContext context) {
        return Convert.asBoolean(context, this.isLambda());
    }

    private boolean isLambda() {
        return this.type.equals((Object)Block.Type.LAMBDA);
    }

    private boolean isFromMethod() {
        return this.getBlock().getBody() instanceof MethodBlockBody;
    }

    private boolean isThread() {
        return this.type.equals((Object)Block.Type.THREAD);
    }

    private static JavaSites.ProcSites sites(ThreadContext context) {
        return context.sites.Proc;
    }

    @Deprecated(since="9.2.10.0")
    public final IRubyObject call(ThreadContext context, IRubyObject[] args2, IRubyObject self2, Block passedBlock) {
        return this.block.call(context, args2, passedBlock);
    }

    @Override
    @Deprecated(since="10.0.0.0")
    public IRubyObject rbClone() {
        return this.rbClone(this.getRuntime().getCurrentContext());
    }

    @Override
    @Deprecated(since="10.0.0.0")
    public IRubyObject dup() {
        return this.dup(this.getRuntime().getCurrentContext());
    }

    public void setFromMethod() {
        this.fromMethod = true;
    }
}

