/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.marshal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.api.Access;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.util.ByteList;
import org.jruby.util.RegexpOptions;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.StringSupport;
import org.jruby.util.io.RubyInputStream;

public class MarshalLoader {
    private final List<IRubyObject> links = new ArrayList<IRubyObject>();
    private final List<RubySymbol> symbols = new ArrayList<RubySymbol>();
    private final Map<IRubyObject, IRubyObject> partials = new IdentityHashMap<IRubyObject, IRubyObject>();
    private final IRubyObject proc;
    private final boolean freeze;

    public MarshalLoader(ThreadContext context, IRubyObject proc2) {
        this(context, false, proc2);
    }

    public MarshalLoader(ThreadContext context, boolean freeze2, IRubyObject proc2) {
        if (proc2 == null) {
            proc2 = context.nil;
        }
        this.proc = proc2;
        this.freeze = freeze2;
    }

    public void start(ThreadContext context, RubyInputStream in) {
        int major = in.read();
        int minor = in.read();
        if (major == -1 || minor == -1) {
            throw Error.eofError(context, "marshal data too short");
        }
        if (major != 4 || minor > 8) {
            throw Error.typeError(context, String.format("incompatible marshal file format (can't be read)\n\tformat version %d.%d required; %d.%d given", 4, 8, major, minor));
        }
    }

    public IRubyObject unmarshalObject(ThreadContext context, RubyInputStream in) {
        return this.object0(context, in, new MarshalState(false), false, null);
    }

    public static RubyModule getModuleFromPath(ThreadContext context, String path2) {
        Ruby runtime2 = context.runtime;
        RubyModule value2 = runtime2.getClassFromPath(path2, runtime2.getArgumentError(), false);
        if (value2 == null) {
            throw Error.argumentError(context, "undefined class/module " + path2);
        }
        if (!value2.isModule()) {
            throw Error.argumentError(context, path2 + " does not refer module");
        }
        return value2;
    }

    public static RubyClass getClassFromPath(ThreadContext context, String path2) {
        Ruby runtime2 = context.runtime;
        RubyModule value2 = runtime2.getClassFromPath(path2, runtime2.getArgumentError(), false);
        if (!value2.isClass()) {
            throw Error.argumentError(context, path2 + " does not refer class");
        }
        return (RubyClass)value2;
    }

    private IRubyObject doCallProcForObj(ThreadContext context, IRubyObject result2) {
        if (this.proc == null || this.proc.isNil()) {
            return result2;
        }
        return Helpers.invoke(context, this.proc, "call", result2);
    }

    private int r_byte(ThreadContext context, RubyInputStream in) {
        return this.readUnsignedByte(context, in);
    }

    public void ivar(ThreadContext context, RubyInputStream in, MarshalState state2, IRubyObject object, boolean[] hasEncoding) {
        int count2 = this.unmarshalInt(context, in);
        RubyClass clazz = object.getMetaClass().getRealClass();
        for (int i2 = 0; i2 < count2; ++i2) {
            RubySymbol key2 = this.symbol(context, in);
            String id2 = key2.idString();
            IRubyObject value2 = this.object0(context, in, state2, false, null);
            Encoding encoding2 = this.symbolToEncoding(context, key2, value2);
            if (encoding2 != null) {
                if (object instanceof EncodingCapable) {
                    ((EncodingCapable)((Object)object)).setEncoding(encoding2);
                } else if (!(object instanceof RubyEncoding)) {
                    throw Error.argumentError(context, RubyStringBuilder.str(context.runtime, object, " is not enc_capable"));
                }
                if (hasEncoding == null) continue;
                hasEncoding[0] = true;
                continue;
            }
            if (id2.equals("K")) {
                if (object instanceof RubyHash) {
                    ((RubyHash)object).setRuby2KeywordHash(true);
                    continue;
                }
                throw Error.argumentError(context, RubyStringBuilder.str(context.runtime, "ruby2_keywords flag is given but ", object, " is not a Hash"));
            }
            clazz.getVariableAccessorForWrite(key2.idString()).set(object, value2);
        }
    }

    public IRubyObject entry(IRubyObject value2) {
        this.registerDataLink(value2);
        this.markAsPartialObject(value2);
        return value2;
    }

    private IRubyObject leave(ThreadContext context, IRubyObject value2, boolean partial) {
        if (!partial) {
            this.noLongerPartial(value2);
            if (this.freeze) {
                RubyClass metaClass = value2.getMetaClass();
                if (metaClass == Access.stringClass(context)) {
                    IRubyObject original = value2;
                    if ((value2 = context.runtime.freezeAndDedupString((RubyString)value2)) != original) {
                        original.setFrozen(value2.isFrozen());
                    }
                } else if (!value2.isModule() && !value2.isClass()) {
                    value2.setFrozen(true);
                }
            }
            value2 = this.postProc(context, value2);
        }
        return value2;
    }

    private RubyModule mustBeModule(ThreadContext context, IRubyObject value2, IRubyObject path2) {
        if (!value2.isModule()) {
            throw Error.argumentError(context, RubyStringBuilder.str(context.runtime, path2, " does not refer to module"));
        }
        return (RubyModule)value2;
    }

    private IRubyObject object0(ThreadContext context, RubyInputStream in, MarshalState state2, boolean partial, List<RubyModule> extendedModules) {
        return this.objectFor(context, in, this.r_byte(context, in), state2, partial, extendedModules);
    }

    private IRubyObject objectFor(ThreadContext context, RubyInputStream in, int type2, MarshalState state2, boolean partial, List<RubyModule> extendedModules) {
        return switch (type2) {
            case 64 -> this.objectForLink(context, in);
            case 73 -> this.objectForIVar(context, in, state2, partial, extendedModules);
            case 101 -> this.objectForExtended(context, in, extendedModules);
            case 67 -> this.objectForUClass(context, in, partial, extendedModules);
            case 48 -> this.objectForNil(context);
            case 84 -> this.objectForTrue(context);
            case 70 -> this.objectForFalse(context);
            case 105 -> this.objectForFixnum(context, in);
            case 102 -> this.objectForFloat(context, in);
            case 108 -> this.objectForBignum(context, in);
            case 34 -> this.objectForString(context, in, partial);
            case 47 -> this.objectForRegexp(context, in, state2, partial);
            case 91 -> this.objectForArray(context, in, partial);
            case 123 -> this.objectForHash(context, in, partial, false);
            case 125 -> this.objectForHashDefault(context, in, partial, false);
            case 83 -> this.objectForStruct(context, in, partial);
            case 117 -> this.objectForUserDef(context, in, state2, partial);
            case 85 -> this.objectForUsrMarshal(context, in, extendedModules);
            case 111 -> this.objectForObject(context, in, partial);
            case 100 -> this.objectForData(context, in, state2, partial, extendedModules);
            case 77 -> this.objectForModuleOld(context, in, state2, partial);
            case 99 -> this.objectForClass(context, in, partial);
            case 109 -> this.objectForModule(context, in, partial);
            case 58 -> this.objectForSymbol(context, in, state2, partial);
            case 59 -> this.objectForSymlink(context, in);
            default -> throw Error.argumentError(context, "dump format error(" + (char)type2 + ")");
        };
    }

    private IRubyObject objectForModuleOld(ThreadContext context, RubyInputStream in, MarshalState state2, boolean partial) {
        String name2 = RubyString.byteListToString(this.unmarshalString(context, in));
        RubyModule mod = MarshalLoader.getModuleFromPath(context, name2);
        this.prohibitIVar(context, state2, name2);
        return this.leave(context, this.entry(mod), partial);
    }

    private void prohibitIVar(ThreadContext context, MarshalState state2, String name2) {
        if (state2 != null && state2.isIvarWaiting()) {
            throw Error.typeError(context, "can't override instance variable of class/module '" + name2 + "'");
        }
    }

    private RubySymbol objectForSymlink(ThreadContext context, RubyInputStream in) {
        return this.symlink(context, in);
    }

    private IRubyObject objectForSymbol(ThreadContext context, RubyInputStream in, MarshalState state2, boolean partial) {
        RubySymbol obj = this.symreal(context, in, state2);
        if (state2 != null && state2.isIvarWaiting()) {
            state2.setIvarWaiting(false);
        }
        return this.leave(context, obj, partial);
    }

    private IRubyObject objectForModule(ThreadContext context, RubyInputStream in, boolean partial) {
        return this.leave(context, this.entry(RubyModule.unmarshalFrom(context, in, this)), partial);
    }

    private IRubyObject objectForClass(ThreadContext context, RubyInputStream in, boolean partial) {
        return this.leave(context, this.entry(RubyClass.unmarshalFrom(context, in, this)), partial);
    }

    private IRubyObject objectForData(ThreadContext context, RubyInputStream in, MarshalState state2, boolean partial, List<RubyModule> extendedModules) {
        RubySymbol name2 = this.unique(context, in);
        RubyClass klass = MarshalLoader.getClassFromPath(context, name2.asJavaString());
        IRubyObject obj = this.entry(klass.allocate(context));
        if (!obj.respondsTo("_load_data")) {
            throw Error.typeError(context, RubyStringBuilder.str(context.runtime, name2, " needs to have instance method _load_data"));
        }
        IRubyObject arg2 = this.object0(context, in, state2, partial, extendedModules);
        obj.callMethod(context, "_load_data", arg2);
        return this.leave(context, obj, partial);
    }

    private IRubyObject objectForObject(ThreadContext context, RubyInputStream in, boolean partial) {
        RubySymbol className = this.symbol(context, in);
        RubyClass type2 = MarshalLoader.getClassFromPath(context, className.idString());
        IRubyObject obj = (IRubyObject)type2.unmarshal(context, in, this);
        return this.leave(context, obj, partial);
    }

    private IRubyObject objectForUserDef(ThreadContext context, RubyInputStream in, MarshalState state2, boolean partial) {
        IRubyObject obj = this.userUnmarshal(context, in, state2);
        if (!partial) {
            obj = this.postProc(context, obj);
        }
        return obj;
    }

    private IRubyObject objectForStruct(ThreadContext context, RubyInputStream in, boolean partial) {
        return this.leave(context, RubyStruct.unmarshalFrom(context, in, this), partial);
    }

    private IRubyObject objectForHashDefault(ThreadContext context, RubyInputStream in, boolean partial, boolean identity) {
        return this.leave(context, RubyHash.unmarshalFrom(context, in, this, true, identity), partial);
    }

    private IRubyObject objectForHash(ThreadContext context, RubyInputStream in, boolean partial, boolean identity) {
        return this.leave(context, RubyHash.unmarshalFrom(context, in, this, false, identity), partial);
    }

    private IRubyObject objectForArray(ThreadContext context, RubyInputStream in, boolean partial) {
        return this.leave(context, RubyArray.unmarshalFrom(context, in, this), partial);
    }

    private IRubyObject objectForRegexp(ThreadContext context, RubyInputStream in, MarshalState state2, boolean partial) {
        return this.leave(context, this.entry(this.unmarshalRegexp(context, in, state2)), partial);
    }

    private IRubyObject objectForString(ThreadContext context, RubyInputStream in, boolean partial) {
        return this.leave(context, this.entry(RubyString.unmarshalFrom(context, in, this)), partial);
    }

    private IRubyObject objectForBignum(ThreadContext context, RubyInputStream in) {
        return this.leave(context, this.entry(RubyBignum.unmarshalFrom(context, in, this)), false);
    }

    private IRubyObject objectForFloat(ThreadContext context, RubyInputStream in) {
        return this.leave(context, this.entry(RubyFloat.unmarshalFrom(context, in, this)), false);
    }

    private IRubyObject objectForFixnum(ThreadContext context, RubyInputStream in) {
        return this.leave(context, RubyFixnum.unmarshalFrom(context, in, this), false);
    }

    private IRubyObject objectForFalse(ThreadContext context) {
        return this.leave(context, context.fals, false);
    }

    private IRubyObject objectForTrue(ThreadContext context) {
        return this.leave(context, context.tru, false);
    }

    private IRubyObject objectForNil(ThreadContext context) {
        return this.leave(context, context.nil, false);
    }

    private IRubyObject objectForUClass(ThreadContext context, RubyInputStream in, boolean partial, List<RubyModule> extendedModules) {
        RubyClass c = MarshalLoader.getClassFromPath(context, this.unique(context, in).asJavaString());
        if (c.isSingleton()) {
            throw Error.typeError(context, "singleton can't be loaded");
        }
        int type2 = this.r_byte(context, in);
        if (c == Access.hashClass(context) && (type2 == 123 || type2 == 125)) {
            return type2 == 123 ? this.objectForHash(context, in, partial, true) : this.objectForHashDefault(context, in, partial, true);
        }
        IRubyObject obj = this.objectFor(context, in, type2, null, partial, extendedModules);
        if (!(obj.getMetaClass() != Access.moduleClass(context) && c.isKindOfModule(obj.getMetaClass()) || c.getAllocator() == obj.getMetaClass().getRealClass().getAllocator())) {
            throw Error.argumentError(context, "dump format error (user class)");
        }
        ((RubyObject)obj).setMetaClass(c);
        return obj;
    }

    private IRubyObject objectForExtended(ThreadContext context, RubyInputStream in, List<RubyModule> extendedModules) {
        IRubyObject obj;
        RubySymbol path2 = this.unique(context, in);
        RubyModule m = MarshalLoader.getModuleFromPath(context, path2.asJavaString());
        if (extendedModules == null) {
            extendedModules = new ArrayList<RubyModule>();
        }
        if (m instanceof RubyClass) {
            obj = this.object0(context, in, null, true, null);
            RubyClass cls = obj.getMetaClass();
            if (cls != m || cls.isSingleton()) {
                throw Error.argumentError(context, RubyStringBuilder.str(context.runtime, "prepended class ", path2, " differs from class ", cls));
            }
            cls = obj.singletonClass(context);
            for (RubyModule mod : extendedModules) {
                cls.prependModule(context, mod);
            }
        } else {
            extendedModules.add(this.mustBeModule(context, m, path2));
            obj = this.object0(context, in, null, true, extendedModules);
            this.appendExtendedModules(context, obj, extendedModules);
        }
        return obj;
    }

    private IRubyObject objectForIVar(ThreadContext context, RubyInputStream in, MarshalState state2, boolean partial, List<RubyModule> extendedModules) {
        MarshalState state1 = new MarshalState(true);
        IRubyObject obj = this.object0(context, in, state1, true, extendedModules);
        if (state1.ivarWaiting) {
            this.ivar(context, in, state2, obj, null);
        }
        return this.leave(context, obj, partial);
    }

    private IRubyObject objectForLink(ThreadContext context, RubyInputStream in) {
        IRubyObject obj = this.readDataLink(context, in, this);
        if (!this.isPartialObject(obj)) {
            obj = this.postProc(context, obj);
        }
        return obj;
    }

    private IRubyObject postProc(ThreadContext context, IRubyObject value2) {
        return this.doCallProcForObj(context, value2);
    }

    public RubySymbol symbol(ThreadContext context, RubyInputStream in) {
        int type2;
        boolean ivar = false;
        block5: while (true) {
            type2 = this.r_byte(context, in);
            switch (type2) {
                case 73: {
                    ivar = true;
                    continue block5;
                }
                case 58: {
                    MarshalState state1 = new MarshalState(ivar);
                    return this.symreal(context, in, state1);
                }
                case 59: {
                    if (ivar) {
                        throw Error.argumentError(context, "dump format error (symlink with encoding)");
                    }
                    return this.symlink(context, in);
                }
            }
            break;
        }
        throw Error.argumentError(context, "dump format error for symbol(0x" + Integer.toHexString(type2) + ")");
    }

    private RubySymbol symlink(ThreadContext context, RubyInputStream in) {
        return (RubySymbol)this.readSymbolLink(context, in, this);
    }

    private RubySymbol symreal(ThreadContext context, RubyInputStream in, MarshalState state2) {
        ByteList byteList = this.unmarshalString(context, in);
        byteList.setEncoding(ASCIIEncoding.INSTANCE);
        MarshalLoader input = this;
        return RubySymbol.newSymbol(context.runtime, byteList, (sym, newSym) -> {
            Encoding encoding2 = null;
            this.registerSymbolLink((RubySymbol)sym);
            if (state2 != null && state2.isIvarWaiting()) {
                int num = input.unmarshalInt(context, in);
                for (int i2 = 0; i2 < num; ++i2) {
                    RubySymbol sym2 = input.symbol(context, in);
                    encoding2 = this.symbolToEncoding(context, sym2, input.unmarshalObject(context, in));
                }
            }
            if (encoding2 != null) {
                sym.getBytes().setEncoding(encoding2);
                if (StringSupport.codeRangeScan(encoding2, sym.getBytes()) == 48) {
                    throw Error.argumentError(context, RubyStringBuilder.str(context.runtime, "invalid byte sequence in " + String.valueOf(encoding2) + ": ", RubyStringBuilder.inspectIdentifierByteList(context.runtime, sym.getBytes())));
                }
            }
        });
    }

    public RubySymbol unique(ThreadContext context, RubyInputStream in) {
        return this.symbol(context, in);
    }

    private IRubyObject unmarshalRegexp(ThreadContext context, RubyInputStream in, MarshalState state2) {
        ByteList byteList = this.unmarshalString(context, in);
        byte opts = this.readSignedByte(context, in);
        RegexpOptions reOpts = RegexpOptions.fromJoniOptions(opts);
        RubyRegexp regexp2 = (RubyRegexp)context.runtime.getRegexp().allocate(context);
        IRubyObject ivarHolder = null;
        boolean[] hasEncoding = new boolean[]{false};
        if (state2 != null && state2.isIvarWaiting()) {
            RubyString tmpStr = RubyString.newString(context.runtime, byteList);
            this.ivar(context, in, state2, tmpStr, hasEncoding);
            byteList = tmpStr.getByteList();
            state2.setIvarWaiting(false);
            ivarHolder = tmpStr;
        }
        if (!hasEncoding[0]) {
            int ptr;
            byte[] ptrBytes = byteList.unsafeBytes();
            int dst = ptr = byteList.begin();
            int src = ptr;
            int len = byteList.realSize();
            long bs = 0L;
            while (len-- > 0) {
                switch (ptrBytes[src]) {
                    case 92: {
                        ++bs;
                        break;
                    }
                    case 69: 
                    case 70: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 88: 
                    case 89: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 117: 
                    case 121: {
                        if ((bs & 1L) != 0L) {
                            // empty if block
                        }
                    }
                    default: {
                        bs = 0L;
                    }
                }
                int n = --dst;
                ++dst;
                ptrBytes[n] = ptrBytes[src++];
            }
            byteList.setRealSize(dst - ptr);
        }
        regexp2.regexpInitialize(byteList, byteList.getEncoding(), reOpts, null);
        if (ivarHolder != null) {
            ivarHolder.getInstanceVariables().copyInstanceVariablesInto(regexp2);
        }
        return regexp2;
    }

    public int readUnsignedByte(ThreadContext context, RubyInputStream in) {
        int result2 = in.read();
        if (result2 == -1) {
            throw Error.argumentError(context, "marshal data too short");
        }
        return result2;
    }

    public byte readSignedByte(ThreadContext context, RubyInputStream in) {
        int b2 = this.readUnsignedByte(context, in);
        if (b2 > 127) {
            return (byte)(b2 - 256);
        }
        return (byte)b2;
    }

    public ByteList unmarshalString(ThreadContext context, RubyInputStream in) {
        int read2;
        int length2 = this.unmarshalInt(context, in);
        byte[] buffer = new byte[length2];
        for (int readLength = 0; readLength < length2; readLength += read2) {
            read2 = in.read(buffer, readLength, length2 - readLength);
            if (read2 != -1) continue;
            throw Error.argumentError(context, "marshal data too short");
        }
        return new ByteList(buffer, false);
    }

    public int unmarshalInt(ThreadContext context, RubyInputStream in) {
        long result2;
        int c = this.readSignedByte(context, in);
        if (c == 0) {
            return 0;
        }
        if (4 < c) {
            return c - 5;
        }
        if (c < -4) {
            return c + 5;
        }
        if (c > 0) {
            result2 = 0L;
            for (int i2 = 0; i2 < c; ++i2) {
                result2 |= (long)this.readUnsignedByte(context, in) << 8 * i2;
            }
        } else {
            c = -c;
            result2 = -1L;
            for (int i3 = 0; i3 < c; ++i3) {
                result2 &= 255L << 8 * i3 ^ 0xFFFFFFFFFFFFFFFFL;
                result2 |= (long)this.readUnsignedByte(context, in) << 8 * i3;
            }
        }
        return (int)result2;
    }

    private Encoding symbolToEncoding(ThreadContext context, RubySymbol symbol, IRubyObject value2) {
        if (symbol.getEncoding() != USASCIIEncoding.INSTANCE) {
            return null;
        }
        String id2 = symbol.idString();
        if (id2.equals("encoding")) {
            String encodingNameStr = value2.asJavaString();
            ByteList encodingName = new ByteList(ByteList.plain(encodingNameStr));
            EncodingDB.Entry entry = context.runtime.getEncodingService().findEncodingOrAliasEntry(encodingName);
            if (entry == null) {
                throw Error.argumentError(context, RubyStringBuilder.str(context.runtime, "encoding ", value2, " is not registered"));
            }
            return entry.getEncoding();
        }
        if (id2.equals("E")) {
            return value2.isTrue() ? UTF8Encoding.INSTANCE : USASCIIEncoding.INSTANCE;
        }
        return null;
    }

    private IRubyObject userUnmarshal(ThreadContext context, RubyInputStream in, MarshalState state2) {
        IRubyObject unmarshaled;
        String className = this.unique(context, in).asJavaString();
        RubyClass classInstance = MarshalLoader.getClassFromPath(context, className);
        RubyString data2 = Create.newString(context, this.unmarshalString(context, in));
        if (classInstance == context.runtime.getEncoding()) {
            unmarshaled = RubyEncoding.find(context, classInstance, data2);
        } else {
            if (state2 != null && state2.isIvarWaiting()) {
                this.ivar(context, in, state2, data2, null);
                state2.setIvarWaiting(false);
            }
            unmarshaled = classInstance.smartLoadOldUser(data2);
        }
        return this.entry(unmarshaled);
    }

    private IRubyObject objectForUsrMarshal(ThreadContext context, RubyInputStream in, List<RubyModule> extendedModules) {
        RubyClass classInstance = MarshalLoader.getClassFromPath(context, this.unique(context, in).asJavaString());
        IRubyObject obj = classInstance.allocate(context);
        if (extendedModules != null) {
            this.appendExtendedModules(context, obj, extendedModules);
        }
        obj = this.entry(obj);
        IRubyObject marshaled = this.unmarshalObject(context, in);
        obj = classInstance.smartLoadNewUser(obj, marshaled);
        obj = this.fixupCompat(obj);
        obj = this.postProc(context, obj);
        if (extendedModules != null) {
            extendedModules.clear();
        }
        return obj;
    }

    private IRubyObject fixupCompat(IRubyObject obj) {
        return obj;
    }

    private void appendExtendedModules(ThreadContext context, IRubyObject obj, List<RubyModule> extendedModules) {
        Collections.reverse(extendedModules);
        for (RubyModule module : extendedModules) {
            module.extend_object(context, obj);
        }
    }

    private boolean isPartialObject(IRubyObject value2) {
        return this.partials.containsKey(value2);
    }

    private void markAsPartialObject(IRubyObject value2) {
        this.partials.put(value2, value2);
    }

    private void noLongerPartial(IRubyObject value2) {
        this.partials.remove(value2);
    }

    private IRubyObject readSymbolLink(ThreadContext context, RubyInputStream in, MarshalLoader input) {
        try {
            return this.symbols.get(input.unmarshalInt(context, in));
        }
        catch (IndexOutOfBoundsException e) {
            throw Error.typeError(context, "bad symbol");
        }
    }

    private IRubyObject readDataLink(ThreadContext context, RubyInputStream in, MarshalLoader input) {
        int index2 = input.unmarshalInt(context, in);
        try {
            return this.links.get(index2);
        }
        catch (IndexOutOfBoundsException e) {
            throw Error.argumentError(context, "dump format error (unlinked, index: " + index2 + ")");
        }
    }

    private void registerDataLink(IRubyObject value2) {
        this.links.add(value2);
    }

    private void registerSymbolLink(RubySymbol value2) {
        this.symbols.add(value2);
    }

    private static class MarshalState {
        private boolean ivarWaiting;

        MarshalState(boolean ivarWaiting) {
            this.ivarWaiting = ivarWaiting;
        }

        boolean isIvarWaiting() {
            return this.ivarWaiting;
        }

        void setIvarWaiting(boolean ivarWaiting) {
            this.ivarWaiting = ivarWaiting;
        }
    }
}

