/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.date;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.jcodings.specific.USASCIIEncoding;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.GJChronology;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Define;
import org.jruby.ext.date.RubyDate;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"DateTime"})
public class RubyDateTime
extends RubyDate {
    private static final ByteList TO_S_FORMAT = new ByteList(ByteList.plain("%.4d-%02d-%02dT%02d:%02d:%02d%s"), false);
    private static final ByteList STRF_FORMAT_BYTES;
    private static final String DEFAULT_FORMAT = "%FT%T%z";

    static void createDateTimeClass(ThreadContext context, RubyClass Date2) {
        ((RubyModule)Define.defineClass(context, "DateTime", Date2, RubyDateTime::new).reifiedClass(RubyDateTime.class)).defineMethods(context, RubyDateTime.class);
    }

    protected RubyDateTime(Ruby runtime2, RubyClass klass) {
        this(runtime2, klass, defaultDateTime);
    }

    public RubyDateTime(Ruby runtime2, RubyClass klass, DateTime dt) {
        super(runtime2, klass, dt);
        this.off = dt.getZone().getOffset(dt.getMillis()) / 1000;
    }

    @Deprecated(since="10.0.0.0")
    public RubyDateTime(Ruby runtime2, DateTime dt) {
        this(runtime2, RubyDateTime.getDateTime(runtime2.getCurrentContext()), dt);
    }

    public RubyDateTime(Ruby runtime2, long millis, Chronology chronology) {
        super(runtime2, RubyDateTime.getDateTime(runtime2.getCurrentContext()), new DateTime(millis, chronology));
    }

    RubyDateTime(ThreadContext context, RubyClass klass, IRubyObject ajd2, int off, long start2) {
        super(context, klass, ajd2, off, start2);
    }

    private RubyDateTime(ThreadContext context, RubyClass klass, IRubyObject ajd2, long[] rest, int off, long start2) {
        super(context, klass, ajd2, rest, off, start2);
    }

    private RubyDateTime(Ruby runtime2, RubyClass klass, DateTime dt, int off) {
        super(runtime2, klass);
        this.dt = dt;
        this.off = off;
    }

    RubyDateTime(Ruby runtime2, RubyClass klass, DateTime dt, int off, long start2) {
        super(runtime2, klass);
        this.dt = dt;
        this.off = off;
        this.start = start2;
    }

    RubyDateTime(Ruby runtime2, RubyClass klass, DateTime dt, int off, long start2, long subMillisNum, long subMillisDen) {
        super(runtime2, klass);
        this.dt = dt;
        this.off = off;
        this.start = start2;
        this.subMillisNum = subMillisNum;
        this.subMillisDen = subMillisDen;
    }

    RubyDateTime(ThreadContext context, RubyClass klass, IRubyObject ajd2, Chronology chronology, int off) {
        super(context, klass, ajd2, chronology, off);
    }

    @Override
    RubyDate newInstance(ThreadContext context, DateTime dt, int off, long start2, long subNum, long subDen) {
        return new RubyDateTime(context.runtime, this.getMetaClass(), dt, off, start2, subNum, subDen);
    }

    @JRubyMethod(name={"civil"}, alias={"new"}, meta=true)
    public static RubyDateTime civil(ThreadContext context, IRubyObject self2) {
        return new RubyDateTime(context.runtime, (RubyClass)self2, defaultDateTime, 0);
    }

    @JRubyMethod(name={"civil"}, alias={"new"}, meta=true)
    public static RubyDateTime civil(ThreadContext context, IRubyObject self2, IRubyObject year2) {
        return new RubyDateTime(context.runtime, (RubyClass)self2, RubyDateTime.civilImpl(context, year2), 0);
    }

    @JRubyMethod(name={"civil"}, alias={"new"}, meta=true)
    public static RubyDateTime civil(ThreadContext context, IRubyObject self2, IRubyObject year2, IRubyObject month2) {
        return new RubyDateTime(context.runtime, (RubyClass)self2, RubyDateTime.civilImpl(context, year2, month2), 0);
    }

    @JRubyMethod(name={"civil"}, alias={"new"}, meta=true, optional=8, checkArity=false)
    public static RubyDateTime civil(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 0, 8);
        int hour2 = 0;
        int minute2 = 0;
        int second2 = 0;
        long millis = 0L;
        long subMillisNum = 0L;
        long subMillisDen = 1L;
        int off = 0;
        long sg = 2299161L;
        if (argc == 8) {
            sg = RubyDateTime.val2sg(context, args2[7]);
        }
        if (argc >= 7) {
            off = RubyDateTime.val2off(context, args2[6]);
        }
        int year2 = sg > 0L ? RubyDateTime.getYear(context, args2[0]) : Convert.toInt(context, args2[0]);
        int month2 = RubyDateTime.getMonth(context, args2[1]);
        long[] rest = new long[]{0L, 1L};
        int day = (int)RubyDateTime.getDay(context, args2[2], rest);
        if (argc >= 4 || rest[0] != 0L) {
            hour2 = RubyDateTime.getHour(context, argc >= 4 ? args2[3] : Convert.asFixnum(context, 0), rest);
        }
        if (argc >= 5 || rest[0] != 0L) {
            minute2 = RubyDateTime.getMinute(context, argc >= 5 ? args2[4] : Convert.asFixnum(context, 0), rest);
        }
        if (argc >= 6 || rest[0] != 0L) {
            IRubyObject sec2 = argc >= 6 ? args2[5] : Convert.asFixnum(context, 0);
            second2 = RubyDateTime.getSecond(context, sec2, rest);
            long r0 = rest[0];
            long r1 = rest[1];
            if (r0 != 0L) {
                millis = 1000L * r0 / r1;
                subMillisNum = 1000L * r0 - millis * r1;
                subMillisDen = r1;
            }
        }
        if (hour2 == 24 && (minute2 != 0 || second2 != 0 || millis != 0L)) {
            throw RubyDateTime.newDateError(context, "invalid date");
        }
        Chronology chronology = RubyDateTime.getChronology(context, sg, off);
        DateTime dt = RubyDateTime.civilDate(context, year2, month2, day, chronology);
        try {
            long ms = dt.getMillis();
            ms = chronology.hourOfDay().set(ms, hour2 == 24 ? 0 : hour2);
            ms = chronology.minuteOfHour().set(ms, minute2);
            ms = chronology.secondOfMinute().set(ms, second2);
            dt = dt.withMillis(ms + millis);
            if (hour2 == 24) {
                dt = dt.plusDays(1);
            }
        }
        catch (IllegalArgumentException ex) {
            RubyDateTime.debug(context, "invalid date", ex);
            throw RubyDateTime.newDateError(context, "invalid date");
        }
        return (RubyDateTime)new RubyDateTime(context.runtime, (RubyClass)self2, dt, off, sg, subMillisNum, subMillisDen).normalizeSubMillis();
    }

    static long getDay(ThreadContext context, IRubyObject day, long[] rest) {
        long d = Convert.toLong(context, day);
        if (!(day instanceof RubyInteger) && day instanceof RubyNumeric) {
            RubyNumeric daynum = (RubyNumeric)day;
            RubyRational rat = daynum.convertToRational(context);
            if (rat.getNumerator() instanceof RubyBignum || rat.getDenominator() instanceof RubyBignum) {
                RubyDateTime.calcBigIntDayRest(context, rat, d, rest);
            } else {
                long num = rat.getNumerator().asLong(context);
                long den = rat.getDenominator().asLong(context);
                rest[0] = num - d * den;
                rest[1] = den;
            }
        }
        return d;
    }

    private static void calcBigIntDayRest(ThreadContext context, RubyRational day, long d, long[] rest) {
        BigInteger num = day.getNumerator().asBigInteger(context);
        BigInteger den = day.getDenominator().asBigInteger(context);
        BigInteger r0 = num.subtract(den.multiply(BigInteger.valueOf(d)));
        BigInteger r1 = den;
        BigInteger gcd2 = r0.gcd(r1);
        r0 = r0.divide(gcd2);
        r1 = r1.divide(gcd2);
        try {
            rest[0] = r0.longValueExact();
            rest[1] = r1.longValueExact();
        }
        catch (ArithmeticException e) {
            BigDecimal r = new BigDecimal(r0).divide(new BigDecimal(r1), 18, RoundingMode.HALF_UP);
            r = r.setScale(18, RoundingMode.HALF_UP);
            rest[0] = r.unscaledValue().longValue();
            rest[1] = (long)Math.pow(10.0, r.scale());
        }
    }

    static int getHour(ThreadContext context, IRubyObject hour2, long[] rest) {
        long h = Convert.toLong(context, hour2);
        long i2 = 0L;
        long r0 = rest[0];
        long r1 = rest[1];
        if (r0 != 0L) {
            i2 = 24L * r0 / r1;
            rest[0] = 24L * r0 - i2 * r1;
        }
        RubyDateTime.addRationalModToRest(context, hour2, h, rest);
        return (int)((h += i2) < 0L ? h + 24L : h);
    }

    static int getMinute(ThreadContext context, IRubyObject val, long[] rest) {
        long v = Convert.toLong(context, val);
        long i2 = 0L;
        long r0 = rest[0];
        long r1 = rest[1];
        if (r0 != 0L) {
            i2 = 60L * r0 / r1;
            rest[0] = 60L * r0 - i2 * r1;
        }
        RubyDateTime.addRationalModToRest(context, val, v, rest);
        return (int)((v += i2) < 0L ? v + 60L : v);
    }

    private static boolean isSecondAWholeNumber(ThreadContext context, IRubyObject val) {
        if (val instanceof RubyRational) {
            RubyFixnum denf;
            RubyRational rat = (RubyRational)val;
            RubyInteger den = rat.getDenominator();
            return den instanceof RubyFixnum && (denf = (RubyFixnum)den).getValue() == 1L;
        }
        if (val instanceof RubyFloat) {
            RubyFloat flote = (RubyFloat)val;
            double v = flote.asDouble(context);
            return v == (double)Math.round(v);
        }
        return true;
    }

    static int getSecond(ThreadContext context, IRubyObject val, long[] rest) {
        long v;
        boolean wholeNum = RubyDateTime.isSecondAWholeNumber(context, val);
        long i2 = 0L;
        long r0 = rest[0];
        long r1 = rest[1];
        if (r0 != 0L) {
            i2 = 60L * r0 / r1;
            rest[0] = 60L * r0 - i2 * r1;
        }
        if (wholeNum) {
            v = Convert.toLong(context, val);
        } else {
            val = ((RubyNumeric)val).divmod(context, Convert.asFixnum(context, 1));
            v = ((RubyInteger)((RubyArray)val).eltInternal(0)).asLong(context);
            RubyNumeric fr = (RubyNumeric)((RubyArray)val).eltInternal(1);
            RubyDateTime.addFraction(context, rest, fr, true);
        }
        return (int)((v += i2) < 0L ? v + 60L : v);
    }

    private static void addRationalModToRest(ThreadContext context, IRubyObject val, long ival, long[] rest) {
        if (!(val instanceof RubyInteger) && val instanceof RubyNumeric) {
            RubyDateTime.addRationalModToRest(context, ((RubyNumeric)val).convertToRational(context), ival, rest);
        }
    }

    private static void addRationalModToRest(ThreadContext context, RubyRational rat, long ival, long[] rest) {
        long num = rat.getNumerator().asLong(context);
        long den = rat.getDenominator().asLong(context);
        if ((num -= ival * den) != 0L) {
            RubyDateTime.addFraction(context, rest, RubyRational.newRational(context.runtime, num, den), false);
        }
    }

    private static void addFraction(ThreadContext context, long[] rest, RubyNumeric fr, boolean roundFloat) {
        RubyNumeric res = (RubyNumeric)RubyRational.newRational(context.runtime, rest[0], rest[1]).op_plus(context, fr);
        if (res instanceof RubyRational) {
            RubyRational rat = (RubyRational)res;
            rest[0] = rat.getNumerator().asLong(context);
            rest[1] = rat.getDenominator().asLong(context);
        } else if (roundFloat && res instanceof RubyFloat) {
            RubyFloat flote = (RubyFloat)res;
            RubyRational rat = RubyDateTime.roundToPrecision(context, flote, 1000000000000L).convertToRational(context);
            rest[0] = rat.getNumerator().asLong(context);
            rest[1] = rat.getDenominator().asLong(context);
        } else {
            rest[0] = Convert.toLong(context, res);
            rest[1] = 1L;
        }
    }

    private static void assertValidFraction(ThreadContext context, IRubyObject val, long ival) {
        IRubyObject eql2;
        if (val instanceof RubyRational && (eql2 = ((RubyRational)val).op_equal(context, Convert.asFixnum(context, ival))) != context.tru) {
            throw RubyDateTime.newDateError(context, "invalid fraction");
        }
    }

    @JRubyMethod(name={"jd"}, meta=true)
    public static RubyDateTime jd(ThreadContext context, IRubyObject self2) {
        return new RubyDateTime(context.runtime, (RubyClass)self2, defaultDateTime, 0);
    }

    @JRubyMethod(name={"jd"}, meta=true, optional=6, checkArity=false)
    public static RubyDateTime jd(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        RubyNumeric fr;
        RubyFixnum sec2;
        int argc = Arity.checkArgumentCount(context, args2, 0, 6);
        RubyFixnum zero = RubyFixnum.zero(context.runtime);
        long[] rest = new long[]{0L, 1L};
        long jd2 = RubyDateTime.getDay(context, args2[0], rest);
        RubyFixnum hour2 = argc > 1 ? args2[1] : zero;
        RubyFixnum min2 = argc > 2 ? args2[2] : zero;
        IRubyObject iRubyObject = sec2 = argc > 3 ? args2[3] : zero;
        if (hour2 != zero || min2 != zero || sec2 != zero) {
            IRubyObject tmp = RubyDateTime._valid_time_p(context, self2, hour2, min2, sec2);
            if (tmp == context.nil) {
                throw RubyDateTime.newDateError(context, "invalid date");
            }
            fr = (RubyNumeric)tmp;
        } else {
            fr = zero;
        }
        int off = 0;
        long sg = 2299161L;
        if (argc > 4) {
            off = RubyDateTime.val2off(context, args2[4]);
        }
        if (argc > 5) {
            sg = RubyDateTime.val2sg(context, args2[5]);
        }
        RubyNumeric ajd2 = RubyDateTime.jd_to_ajd(context, jd2, fr, off);
        return new RubyDateTime(context, (RubyClass)self2, ajd2, rest, off, sg);
    }

    @JRubyMethod(meta=true)
    public static RubyDateTime now(ThreadContext context, IRubyObject self2) {
        DateTimeZone zone2 = RubyTime.getLocalTimeZone(context);
        if (zone2 == DateTimeZone.UTC) {
            return new RubyDateTime(context.runtime, (RubyClass)self2, new DateTime(CHRONO_ITALY_UTC), 0);
        }
        DateTime dt = new DateTime(GJChronology.getInstance(zone2));
        int off = zone2.getOffset(dt.getMillis()) / 1000;
        return new RubyDateTime(context.runtime, (RubyClass)self2, dt, off, 2299161L);
    }

    @JRubyMethod(meta=true)
    public static RubyDateTime now(ThreadContext context, IRubyObject self2, IRubyObject sg) {
        long start2 = RubyDateTime.val2sg(context, sg);
        DateTimeZone zone2 = RubyTime.getLocalTimeZone(context);
        DateTime dt = new DateTime(RubyDateTime.getChronology(context, start2, zone2));
        int off = zone2.getOffset(dt.getMillis()) / 1000;
        return new RubyDateTime(context.runtime, (RubyClass)self2, dt, off, start2);
    }

    @Override
    public IRubyObject prev_day(ThreadContext context, IRubyObject n) {
        return this.prevNextDay(context, n, true);
    }

    @Override
    public IRubyObject next_day(ThreadContext context, IRubyObject n) {
        return this.prevNextDay(context, n, false);
    }

    private RubyDate prevNextDay(ThreadContext context, IRubyObject n, boolean negate2) {
        long seconds = RubyDateTime.timesIntDiff(context, n, 86400);
        if (negate2) {
            seconds = -seconds;
        }
        int days = RubyNumeric.checkInt(context.runtime, seconds / 86400L);
        return this.newInstance(context, this.dt.plusDays(days).plusSeconds((int)(seconds % 86400L)), this.off, this.start);
    }

    @Override
    @JRubyMethod
    public RubyString to_s(ThreadContext context) {
        return RubyDateTime.format(context, TO_S_FORMAT, this.year(context), this.mon(context), this.mday(context), this.hour(context), this.minute(context), this.second(context), this.zone(context));
    }

    @JRubyMethod
    public RubyDate to_date(ThreadContext context) {
        return new RubyDate(context.runtime, RubyDateTime.getDate(context), RubyDateTime.withTimeAt0InZone(this.dt, DateTimeZone.UTC), 0, this.start);
    }

    static DateTime withTimeAt0InZone(DateTime dt, DateTimeZone zone2) {
        long millis = dt.getZone().getMillisKeepLocal(zone2, dt.getMillis());
        Chronology chronology = dt.getChronology().withZone(zone2);
        millis = chronology.millisOfDay().set(millis, 0);
        return new DateTime(millis, chronology);
    }

    @JRubyMethod
    public RubyDateTime to_datetime() {
        return this;
    }

    @Override
    @JRubyMethod
    public RubyTime to_time(ThreadContext context) {
        DateTime dt = this.dt;
        dt = new DateTime(this.adjustJodaYear(dt.getYear()), dt.getMonthOfYear(), dt.getDayOfMonth(), dt.getHourOfDay(), dt.getMinuteOfHour(), dt.getSecondOfMinute(), dt.getMillisOfSecond(), RubyTime.getTimeZone(context, (long)this.off));
        RubyTime time = new RubyTime(context.runtime, Access.timeClass(context), dt, true);
        if (this.subMillisNum != 0L) {
            RubyNumeric usec2 = (RubyNumeric)this.subMillis(context).op_mul(context, Convert.asFixnum(context, 1000000));
            time.setNSec(usec2.asLong(context));
        }
        return time;
    }

    @Override
    @JRubyMethod
    public RubyString strftime(ThreadContext context) {
        return super.strftime(context, RubyString.newStringLight(context.runtime, STRF_FORMAT_BYTES));
    }

    @Override
    @JRubyMethod
    public RubyString strftime(ThreadContext context, IRubyObject fmt) {
        return super.strftime(context, fmt);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject _strptime(ThreadContext context, IRubyObject self2, IRubyObject string2) {
        return RubyDateTime.parse(context, string2, DEFAULT_FORMAT);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject _strptime(ThreadContext context, IRubyObject self2, IRubyObject string2, IRubyObject format) {
        return RubyDate._strptime(context, self2, string2, format);
    }

    public LocalDateTime toLocalDateTime() {
        return LocalDateTime.of(this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond(), this.getNanos());
    }

    public ZonedDateTime toZonedDateTime() {
        return ZonedDateTime.of(this.toLocalDateTime(), ZoneId.of(this.dt.getZone().getID()));
    }

    public OffsetDateTime toOffsetDateTime() {
        int offset2 = this.dt.getZone().getOffset(this.dt.getMillis()) / 1000;
        return OffsetDateTime.of(this.toLocalDateTime(), ZoneOffset.ofTotalSeconds(offset2));
    }

    @Override
    public <T> T toJava(Class<T> target2) {
        if (target2 == Comparable.class || target2 == Object.class) {
            return super.toJava(target2);
        }
        if (target2 != Serializable.class) {
            if (target2.isAssignableFrom(Instant.class)) {
                return (T)this.toInstant();
            }
            if (target2.isAssignableFrom(LocalDateTime.class)) {
                return (T)this.toLocalDateTime();
            }
            if (target2.isAssignableFrom(ZonedDateTime.class)) {
                return (T)this.toZonedDateTime();
            }
            if (target2.isAssignableFrom(OffsetDateTime.class)) {
                return (T)this.toOffsetDateTime();
            }
        }
        return super.toJava(target2);
    }

    static {
        TO_S_FORMAT.setEncoding(USASCIIEncoding.INSTANCE);
        STRF_FORMAT_BYTES = ByteList.create("%FT%T%:z");
        STRF_FORMAT_BYTES.setEncoding(USASCIIEncoding.INSTANCE);
    }
}

