/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.bigdecimal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyConstant;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.api.JRubyAPI;
import org.jruby.api.Warn;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.bigdecimal.Multiplication;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Numeric;
import org.jruby.util.StringSupport;

public class RubyBigDecimal
extends RubyNumeric {
    @JRubyConstant
    public static final int ROUND_DOWN = 2;
    @JRubyConstant
    public static final int ROUND_CEILING = 5;
    @JRubyConstant
    public static final int ROUND_UP = 1;
    @JRubyConstant
    public static final int ROUND_HALF_DOWN = 4;
    @JRubyConstant
    public static final int ROUND_HALF_EVEN = 7;
    @JRubyConstant
    public static final int ROUND_HALF_UP = 3;
    @JRubyConstant
    public static final int ROUND_FLOOR = 6;
    @JRubyConstant
    public static final int SIGN_POSITIVE_INFINITE = 3;
    @JRubyConstant
    public static final int SIGN_POSITIVE_ZERO = 1;
    @JRubyConstant
    public static final int SIGN_NEGATIVE_FINITE = -2;
    @JRubyConstant
    public static final int SIGN_NaN = 0;
    @JRubyConstant
    public static final int BASE = 10000;
    @JRubyConstant
    public static final int ROUND_MODE = 256;
    @JRubyConstant
    public static final int SIGN_POSITIVE_FINITE = 2;
    @JRubyConstant
    public static final int SIGN_NEGATIVE_INFINITE = -3;
    @JRubyConstant
    public static final int SIGN_NEGATIVE_ZERO = -1;
    @JRubyConstant
    public static final int EXCEPTION_INFINITY = 1;
    @JRubyConstant
    public static final int EXCEPTION_OVERFLOW = 1;
    @JRubyConstant
    public static final int EXCEPTION_NaN = 2;
    @JRubyConstant
    public static final int EXCEPTION_UNDERFLOW = 4;
    @JRubyConstant
    public static final int EXCEPTION_ZERODIVIDE = 16;
    @JRubyConstant
    public static final int EXCEPTION_ALL = 255;
    private static final ByteList VERSION = ByteList.create("3.1.4");
    private static final short VP_DOUBLE_FIG = 16;
    private static final short RMPD_COMPONENT_FIGURES = 9;
    private static final short BASE_FIG = 9;
    private static final double SQRT_10 = 3.1622776601683795;
    private static final long NEGATIVE_ZERO_LONG_BITS = Double.doubleToLongBits(-0.0);
    private boolean isNaN;
    private int infinitySign;
    private int zeroSign;
    private BigDecimal value;
    private transient BigDecimal absStripTrailingZeros;
    private static final BigDecimal MAX_FIX = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal MIN_FIX = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final Pattern FRACTIONAL_DIGIT_GROUPS = Pattern.compile("(\\+| )?(\\d+)(E|F|f)?");

    public static RubyClass createBigDecimal(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        RubyClass bigDecimal = (RubyClass)((RubyModule)((RubyModule)((RubyModule)Define.defineClass(context, "BigDecimal", runtime2.getNumeric(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR).reifiedClass(RubyBigDecimal.class)).defineMethods(context, RubyBigDecimal.class)).defineConstants(context, RubyBigDecimal.class)).defineConstant(context, "VERSION", Create.newSharedString(context, VERSION));
        Access.kernelModule(context).defineMethods(context, BigDecimalKernelMethods.class);
        bigDecimal.setInternalModuleVariable("vpPrecLimit", Convert.asFixnum(context, 0));
        bigDecimal.setInternalModuleVariable("vpExceptionMode", Convert.asFixnum(context, 0));
        bigDecimal.setInternalModuleVariable("vpRoundingMode", Convert.asFixnum(context, 3));
        RubyBigDecimal POSITIVE_ZERO = new RubyBigDecimal(runtime2, BigDecimal.ZERO, 0, 1);
        RubyBigDecimal NEGATIVE_ZERO = new RubyBigDecimal(runtime2, BigDecimal.ZERO, 0, -1);
        RubyBigDecimal NAN = new RubyBigDecimal(runtime2, BigDecimal.ZERO, true);
        RubyBigDecimal POSITIVE_INFINITY = new RubyBigDecimal(runtime2, BigDecimal.ZERO, 1, 0);
        RubyBigDecimal NEGATIVE_INFINITY = new RubyBigDecimal(runtime2, BigDecimal.ZERO, -1, 0);
        ((RubyModule)((RubyModule)((RubyModule)((RubyModule)bigDecimal.defineConstant(context, "POSITIVE_ZERO", POSITIVE_ZERO, true)).defineConstant(context, "NEGATIVE_ZERO", NEGATIVE_ZERO, true)).defineConstant(context, "NAN", NAN)).defineConstant(context, "INFINITY", POSITIVE_INFINITY)).defineConstant(context, "NEGATIVE_INFINITY", NEGATIVE_INFINITY, true);
        return bigDecimal;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public RubyBigDecimal(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
        this.isNaN = false;
        this.infinitySign = 0;
        this.zeroSign = 0;
        this.value = BigDecimal.ZERO;
        this.flags |= FROZEN_F;
    }

    public RubyBigDecimal(Ruby runtime2, BigDecimal value2) {
        super(runtime2, Access.getClass(runtime2.getCurrentContext(), "BigDecimal"));
        this.isNaN = false;
        this.infinitySign = 0;
        this.zeroSign = 0;
        this.value = value2;
        this.flags |= FROZEN_F;
    }

    public RubyBigDecimal(Ruby runtime2, RubyClass klass, BigDecimal value2) {
        super(runtime2, klass);
        this.isNaN = false;
        this.infinitySign = 0;
        this.zeroSign = 0;
        this.value = value2;
        this.flags |= FROZEN_F;
    }

    public RubyBigDecimal(Ruby runtime2, BigDecimal value2, int infinitySign) {
        this(runtime2, value2, infinitySign, 0);
    }

    public RubyBigDecimal(Ruby runtime2, BigDecimal value2, int infinitySign, int zeroSign) {
        super(runtime2, Access.getClass(runtime2.getCurrentContext(), "BigDecimal"));
        this.isNaN = false;
        this.infinitySign = infinitySign;
        this.zeroSign = zeroSign;
        this.value = value2;
        this.flags |= FROZEN_F;
    }

    public RubyBigDecimal(Ruby runtime2, BigDecimal value2, boolean isNan) {
        super(runtime2, Access.getClass(runtime2.getCurrentContext(), "BigDecimal"));
        this.isNaN = isNan;
        this.infinitySign = 0;
        this.zeroSign = 0;
        this.value = value2;
        this.flags |= FROZEN_F;
    }

    RubyBigDecimal(Ruby runtime2, RubyClass klass, BigDecimal value2, int zeroSign, int infinitySign, boolean isNaN) {
        super(runtime2, klass);
        this.isNaN = isNaN;
        this.infinitySign = infinitySign;
        this.zeroSign = zeroSign;
        this.value = value2;
        this.flags |= FROZEN_F;
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.BIGDECIMAL;
    }

    @JRubyMethod
    public IRubyObject _dump(ThreadContext context) {
        return RubyString.newUnicodeString(context.runtime, "0:").append(this.asString());
    }

    @JRubyMethod
    public IRubyObject _dump(ThreadContext context, IRubyObject unused2) {
        return RubyString.newUnicodeString(context.runtime, "0:").append(this.asString());
    }

    @JRubyMethod(meta=true)
    public static RubyBigDecimal _load(ThreadContext context, IRubyObject recv2, IRubyObject from) {
        String precisionAndValue = from.convertToString().asJavaString();
        long m = 0L;
        for (int i2 = 0; i2 != precisionAndValue.length() && precisionAndValue.charAt(i2) != ':'; ++i2) {
            if (!Character.isDigit(precisionAndValue.charAt(i2))) {
                throw Error.typeError(context, "load failed: invalid character in the marshaled string");
            }
            m = m * 10L + (long)(precisionAndValue.charAt(i2) - 48);
        }
        String value2 = precisionAndValue.substring(precisionAndValue.indexOf(58) + 1);
        return (RubyBigDecimal)RubyBigDecimal.newInstance(context, recv2, (IRubyObject)Create.newString(context, value2), Convert.asFixnum(context, m), true, true);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject double_fig(ThreadContext context, IRubyObject recv2) {
        return Convert.asFixnum(context, 16);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject limit(ThreadContext context, IRubyObject recv2) {
        return ((RubyModule)recv2).searchInternalModuleVariable("vpPrecLimit");
    }

    @JRubyMethod(meta=true)
    public static IRubyObject limit(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        IRubyObject old = RubyBigDecimal.limit(context, recv2);
        if (arg2 == context.nil) {
            return old;
        }
        if (Convert.castAsFixnum(context, arg2).getValue() < 0L) {
            throw Error.argumentError(context, "argument must be positive");
        }
        ((RubyModule)recv2).setInternalModuleVariable("vpPrecLimit", arg2);
        return old;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject save_limit(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyBigDecimal.modeExecute(context, (RubyModule)recv2, block, "vpPrecLimit");
    }

    @JRubyMethod(meta=true)
    public static IRubyObject save_exception_mode(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyBigDecimal.modeExecute(context, (RubyModule)recv2, block, "vpExceptionMode");
    }

    @JRubyMethod(meta=true)
    public static IRubyObject save_rounding_mode(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyBigDecimal.modeExecute(context, (RubyModule)recv2, block, "vpRoundingMode");
    }

    @JRubyMethod(meta=true)
    public static IRubyObject interpret_loosely(ThreadContext context, IRubyObject recv2, IRubyObject str) {
        return RubyBigDecimal.newInstance(context, recv2, str, Convert.asFixnum(context, Integer.MAX_VALUE), false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject modeExecute(ThreadContext context, RubyModule BigDecimal2, Block block, String intVariableName) {
        IRubyObject current2 = BigDecimal2.searchInternalModuleVariable(intVariableName);
        try {
            IRubyObject iRubyObject = block.yieldSpecific(context);
            return iRubyObject;
        }
        finally {
            BigDecimal2.setInternalModuleVariable(intVariableName, current2);
        }
    }

    @JRubyMethod(required=1, optional=1, checkArity=false, meta=true)
    public static IRubyObject mode(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        RubyModule c = (RubyModule)recv2;
        args2 = Arity.scanArgs(context, args2, 1, 1);
        long mode2 = Convert.castAsFixnum(context, args2[0]).getValue();
        IRubyObject value2 = args2[1];
        if ((mode2 & 0xFFL) != 0L) {
            if (value2.isNil()) {
                return c.searchInternalModuleVariable("vpExceptionMode");
            }
            if (!(value2 instanceof RubyBoolean)) {
                throw Error.argumentError(context, "second argument must be true or false");
            }
            long newExceptionMode = Convert.toLong(context, c.searchInternalModuleVariable("vpExceptionMode"));
            boolean enable2 = value2.isTrue();
            if ((mode2 & 1L) != 0L) {
                long l = newExceptionMode = enable2 ? newExceptionMode | 1L : newExceptionMode & 0xFFFFFFFFFFFFFFFEL;
            }
            if ((mode2 & 2L) != 0L) {
                long l = newExceptionMode = enable2 ? newExceptionMode | 2L : newExceptionMode & 0xFFFFFFFFFFFFFFFDL;
            }
            if ((mode2 & 4L) != 0L) {
                long l = newExceptionMode = enable2 ? newExceptionMode | 4L : newExceptionMode & 0xFFFFFFFFFFFFFFFBL;
            }
            if ((mode2 & 0x10L) != 0L) {
                newExceptionMode = enable2 ? newExceptionMode | 0x10L : newExceptionMode & 0xFFFFFFFFFFFFFFEFL;
            }
            RubyFixnum fixnumMode = Convert.asFixnum(context, newExceptionMode);
            c.setInternalModuleVariable("vpExceptionMode", fixnumMode);
            return fixnumMode;
        }
        if (mode2 == 256L) {
            if (value2 == context.nil) {
                return c.searchInternalModuleVariable("vpRoundingMode");
            }
            RoundingMode javaRoundingMode = RubyBigDecimal.javaRoundingModeFromRubyRoundingMode(context, value2);
            RubyFixnum roundingMode = Convert.asFixnum(context, RubyBigDecimal.rubyRoundingModeFromJavaRoundingMode(context, javaRoundingMode));
            c.setInternalModuleVariable("vpRoundingMode", roundingMode);
            return roundingMode;
        }
        throw Error.typeError(context, "first argument for BigDecimal#mode invalid");
    }

    private static long bigDecimalVar(ThreadContext context, String variableName) {
        return ((RubyFixnum)Access.getClass(context, "BigDecimal").searchInternalModuleVariable(variableName)).asLong(context);
    }

    private static RoundingMode getRoundingMode(ThreadContext context) {
        IRubyObject mode2 = Access.getClass(context, "BigDecimal").searchInternalModuleVariable("vpRoundingMode");
        return RubyBigDecimal.javaRoundingModeFromRubyRoundingMode(context, mode2);
    }

    private static boolean isNaNExceptionMode(ThreadContext context) {
        return (RubyBigDecimal.bigDecimalVar(context, "vpExceptionMode") & 2L) != 0L;
    }

    private static boolean isInfinityExceptionMode(ThreadContext context) {
        return (RubyBigDecimal.bigDecimalVar(context, "vpExceptionMode") & 1L) != 0L;
    }

    private static boolean isOverflowExceptionMode(ThreadContext context) {
        return (RubyBigDecimal.bigDecimalVar(context, "vpExceptionMode") & 1L) != 0L;
    }

    private static boolean isUnderflowExceptionMode(ThreadContext context) {
        return (RubyBigDecimal.bigDecimalVar(context, "vpExceptionMode") & 4L) != 0L;
    }

    private static boolean isZeroDivideExceptionMode(ThreadContext context) {
        return (RubyBigDecimal.bigDecimalVar(context, "vpExceptionMode") & 0x10L) != 0L;
    }

    private static RubyBigDecimal cannotBeCoerced(ThreadContext context, IRubyObject value2, boolean must) {
        if (must) {
            throw Error.typeError(context, RubyBigDecimal.errMessageType(context, value2) + " can't be coerced into BigDecimal");
        }
        return null;
    }

    private static String errMessageType(ThreadContext context, IRubyObject value2) {
        if (value2 == null || value2 == context.nil) {
            return "nil";
        }
        return value2.isImmediate() ? RubyObject.inspect(context, value2).toString() : value2.getMetaClass().getBaseName();
    }

    private static BigDecimal toBigDecimal(ThreadContext context, RubyInteger value2) {
        BigDecimal bigDecimal;
        if (value2 instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)value2;
            bigDecimal = BigDecimal.valueOf(fixnum.getValue());
        } else {
            bigDecimal = new BigDecimal(value2.asBigInteger(context));
        }
        return bigDecimal;
    }

    private static RubyBigDecimal getVpRubyObjectWithPrecInner(ThreadContext context, RubyRational value2, RoundingMode mode2) {
        BigDecimal numerator2 = RubyBigDecimal.toBigDecimal(context, value2.getNumerator());
        BigDecimal denominator2 = RubyBigDecimal.toBigDecimal(context, value2.getDenominator());
        int len = numerator2.precision() + denominator2.precision();
        int pow2 = len / 4;
        MathContext mathContext = new MathContext((pow2 + 1) * 4, mode2);
        return new RubyBigDecimal(context.runtime, numerator2.divide(denominator2, mathContext));
    }

    private RubyBigDecimal getVpValueWithPrec(ThreadContext context, IRubyObject value2, boolean must) {
        if (value2 instanceof RubyFloat) {
            RubyFloat flote = (RubyFloat)value2;
            double doubleValue = flote.asDouble(context);
            if (Double.isInfinite(doubleValue)) {
                throw context.runtime.newFloatDomainError(doubleValue < 0.0 ? "-Infinity" : "Infinity");
            }
            if (Double.isNaN(doubleValue)) {
                throw context.runtime.newFloatDomainError("NaN");
            }
            MathContext mathContext = new MathContext(16, RubyBigDecimal.getRoundingMode(context));
            return new RubyBigDecimal(context.runtime, new BigDecimal(value2.toString(), mathContext));
        }
        if (value2 instanceof RubyRational) {
            return RubyBigDecimal.div2Impl(context, ((RubyRational)value2).getNumerator(), ((RubyRational)value2).getDenominator(), this.getPrec(context) * 9);
        }
        return RubyBigDecimal.getVpValue(context, value2, must);
    }

    private static RubyBigDecimal getVpValue(ThreadContext context, IRubyObject value2, boolean must) {
        return switch (((RubyBasicObject)value2).getNativeClassIndex()) {
            case ClassIndex.BIGDECIMAL -> (RubyBigDecimal)value2;
            case ClassIndex.FIXNUM -> RubyBigDecimal.newInstance(context, (IRubyObject)Access.getClass(context, "BigDecimal"), (RubyFixnum)value2, MathContext.UNLIMITED);
            case ClassIndex.BIGNUM -> RubyBigDecimal.newInstance(context, (IRubyObject)Access.getClass(context, "BigDecimal"), (RubyBignum)value2, MathContext.UNLIMITED);
            case ClassIndex.FLOAT -> RubyBigDecimal.newInstance(context, (IRubyObject)Access.getClass(context, "BigDecimal"), (RubyFloat)value2, new MathContext(15));
            case ClassIndex.RATIONAL -> RubyBigDecimal.newInstance(context, (IRubyObject)Access.getClass(context, "BigDecimal"), (RubyRational)value2, new MathContext(15));
            default -> RubyBigDecimal.cannotBeCoerced(context, value2, must);
        };
    }

    @JRubyMethod(meta=true)
    public static IRubyObject induced_from(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyBigDecimal.getVpValue(context, arg2, true);
    }

    private static RubyBigDecimal newInstance(Ruby runtime2, IRubyObject recv2, RubyBigDecimal arg2) {
        return new RubyBigDecimal(runtime2, (RubyClass)recv2, arg2.value, arg2.zeroSign, arg2.infinitySign, arg2.isNaN);
    }

    private static RubyBigDecimal newInstance(ThreadContext context, IRubyObject recv2, RubyFixnum arg2, MathContext mathContext) {
        long value2 = arg2.getValue();
        return value2 == 0L ? RubyBigDecimal.getZero(context, 1) : new RubyBigDecimal(context.runtime, (RubyClass)recv2, new BigDecimal(value2, mathContext));
    }

    private static RubyBigDecimal newInstance(ThreadContext context, IRubyObject recv2, RubyRational arg2, MathContext mathContext) {
        BigDecimal value2;
        if (arg2.getNumerator().isZero(context)) {
            return RubyBigDecimal.getZero(context, 1);
        }
        BigDecimal num = RubyBigDecimal.toBigDecimal(context, arg2.getNumerator());
        BigDecimal den = RubyBigDecimal.toBigDecimal(context, arg2.getDenominator());
        try {
            value2 = num.divide(den, mathContext);
        }
        catch (ArithmeticException e) {
            value2 = num.divide(den, MathContext.DECIMAL64);
        }
        return new RubyBigDecimal(context.runtime, (RubyClass)recv2, value2);
    }

    private static RubyBigDecimal newInstance(ThreadContext context, IRubyObject recv2, RubyFloat arg2, MathContext mathContext) {
        if (mathContext.getPrecision() > 16) {
            throw Error.argumentError(context, "precision too large");
        }
        RubyBigDecimal res = RubyBigDecimal.newFloatSpecialCases(context, arg2);
        if (res != null) {
            return res;
        }
        return new RubyBigDecimal(context.runtime, (RubyClass)recv2, new BigDecimal(arg2.toString(), mathContext));
    }

    private static RubyBigDecimal newFloatSpecialCases(ThreadContext context, RubyFloat val) {
        if (val.isNaN()) {
            return RubyBigDecimal.getNaN(context);
        }
        if (val.isInfinite()) {
            return RubyBigDecimal.getInfinity(context, val.asDouble(context) == Double.POSITIVE_INFINITY ? 1 : -1);
        }
        if (val.isZero(context)) {
            return RubyBigDecimal.getZero(context, Double.doubleToLongBits(val.asDouble(context)) == NEGATIVE_ZERO_LONG_BITS ? -1 : 1);
        }
        return null;
    }

    private static RubyBigDecimal newInstance(ThreadContext context, IRubyObject recv2, RubyBignum arg2, MathContext mathContext) {
        BigInteger value2 = arg2.asBigInteger(context);
        if (value2.equals(BigInteger.ZERO)) {
            return RubyBigDecimal.getZero(context, 1);
        }
        return new RubyBigDecimal(context.runtime, (RubyClass)recv2, new BigDecimal(value2, mathContext));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IRubyObject newInstance(ThreadContext context, RubyClass recv2, RubyString arg2, MathContext mathContext, boolean strict, boolean exception2) {
        BigDecimal decimal;
        char[] str = arg2.decodeString().toCharArray();
        int s2 = 0;
        int e = str.length - 1;
        if (e == 0) {
            switch (str[0]) {
                case '0': {
                    return RubyBigDecimal.getZero(context, 1);
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return new RubyBigDecimal(context.runtime, recv2, BigDecimal.valueOf(str[0] - 48));
                }
            }
        }
        while (s2 <= e && str[s2] <= ' ') {
            ++s2;
        }
        while (s2 <= e && str[e] <= ' ') {
            --e;
        }
        int sign2 = 1;
        switch (s2 <= e ? str[s2] : 32) {
            case 95: {
                if (strict) throw RubyBigDecimal.invalidArgumentError(context, arg2);
                return context.nil;
            }
            case 78: {
                if (!RubyBigDecimal.contentEquals("NaN", str, s2, e)) break;
                return RubyBigDecimal.getNaN(context);
            }
            case 73: {
                if (!RubyBigDecimal.contentEquals("Infinity", str, s2, e)) break;
                return RubyBigDecimal.getInfinity(context, 1);
            }
            case 45: {
                if (RubyBigDecimal.contentEquals("-Infinity", str, s2, e)) {
                    return RubyBigDecimal.getInfinity(context, -1);
                }
                sign2 = -1;
                break;
            }
            case 43: {
                if (!RubyBigDecimal.contentEquals("+Infinity", str, s2, e)) break;
                return RubyBigDecimal.getInfinity(context, 1);
            }
        }
        int i2 = s2;
        int off = 0;
        boolean dD = false;
        int exp2 = -1;
        int lastSign = -1;
        boolean dotFound = false;
        block24: while (i2 + off <= e) {
            switch (str[i2 + off]) {
                case 'D': 
                case 'd': {
                    if (dD) {
                        e = i2 - 1;
                        continue block24;
                    }
                    str[i2] = 69;
                    dD = true;
                    if (exp2 != -1) {
                        e = i2 - 1;
                        continue block24;
                    }
                    exp2 = i2++;
                    continue block24;
                }
                case '_': {
                    if (i2 + off == e || Character.isDigit(str[i2 + off + 1])) {
                        str[i2] = str[i2 + off];
                        ++off;
                        continue block24;
                    }
                    if (strict) throw RubyBigDecimal.invalidArgumentError(context, arg2);
                    e = i2 + off - 1;
                    break block24;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                case '.': {
                    if (dotFound) {
                        e = i2 + off - 1;
                        break block24;
                    }
                    dotFound = true;
                    if (i2 + off + 1 > e || Character.isDigit(str[i2 + off + 1])) break;
                    e = i2 + off - 1;
                    break block24;
                }
                case '+': 
                case '-': {
                    lastSign = i2;
                    break;
                }
                case 'E': 
                case 'e': {
                    char c;
                    if (exp2 != -1) {
                        e = i2 - 1;
                        continue block24;
                    }
                    exp2 = i2;
                    if (i2 + off + 1 > e || (c = str[i2 + off + 1]) == '-' || c == '+' || Character.isDigit(c)) break;
                    e = i2 + off - 1;
                    break block24;
                }
                default: {
                    e = i2 - 1;
                    continue block24;
                }
            }
            str[i2] = str[i2 + off];
            ++i2;
        }
        if ((i2 = e + 1) < str.length) {
            while (i2 < str.length && Character.isWhitespace(str[i2++])) {
            }
            if (i2 < str.length && strict) {
                throw RubyBigDecimal.invalidArgumentError(context, arg2);
            }
        }
        e -= off;
        if (exp2 != -1) {
            if (exp2 == e || exp2 + 1 == e && (str[exp2 + 1] == '-' || str[exp2 + 1] == '+')) {
                if (strict) throw RubyBigDecimal.invalidArgumentError(context, arg2);
                if (exp2 == e) {
                    --e;
                }
                if (exp2 + 1 == e) {
                    e -= 2;
                }
            } else if (RubyBigDecimal.isExponentOutOfRange(str, exp2 + 1, e)) {
                if (!RubyBigDecimal.isZeroBase(str, s2, exp2) && str[exp2 + 1] != '-') return RubyBigDecimal.getInfinity(context, sign2);
                return RubyBigDecimal.getZero(context, sign2);
            }
        } else if (lastSign > s2) {
            e = lastSign - 1;
        }
        try {
            decimal = new BigDecimal(str, s2, e - s2 + 1, mathContext);
        }
        catch (ArithmeticException ex) {
            return RubyBigDecimal.checkOverUnderFlow(context, ex, false, strict, exception2);
        }
        catch (NumberFormatException ex) {
            return RubyBigDecimal.handleInvalidArgument(context, arg2, strict, exception2);
        }
        if (decimal.signum() != 0) return new RubyBigDecimal(context.runtime, recv2, decimal);
        return RubyBigDecimal.getZero(context, sign2);
    }

    private static IRubyObject handleInvalidArgument(ThreadContext context, RubyString arg2, boolean strict, boolean exception2) {
        if (!strict) {
            return RubyBigDecimal.getZero(context, 1);
        }
        if (!exception2) {
            return context.nil;
        }
        throw RubyBigDecimal.invalidArgumentError(context, arg2);
    }

    private static RaiseException invalidArgumentError(ThreadContext context, RubyString arg2) {
        return Error.argumentError(context, "invalid value for BigDecimal(): \"" + String.valueOf(arg2) + "\"");
    }

    private static boolean contentEquals(String str1, char[] str2, int s2, int e2) {
        int len = str1.length();
        if (len == e2 - s2 + 1) {
            for (int i2 = 0; i2 < len; ++i2) {
                if (str1.charAt(i2) == str2[s2 + i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isZeroBase(char[] str, int off, int end2) {
        for (int i2 = off; i2 < end2; ++i2) {
            if (str[i2] == '0') continue;
            return false;
        }
        return true;
    }

    private static boolean isExponentOutOfRange(char[] str, int off, int end2) {
        int num = 0;
        int sign2 = 1;
        char ch0 = str[off];
        if (ch0 == '-') {
            sign2 = -1;
        } else if (ch0 != '+') {
            num = 48 - ch0;
        }
        int i2 = off + 1;
        int max2 = sign2 == 1 ? -2147483647 : -2147483647;
        int multmax = max2 / 10;
        while (i2 <= end2) {
            int d = str[i2++] - 48;
            if (num < multmax) {
                return true;
            }
            if ((num *= 10) < max2 + d) {
                return true;
            }
            num -= d;
        }
        return false;
    }

    private static IRubyObject handleMissingPrecision(ThreadContext context, String name2, boolean strict, boolean exception2) {
        if (!strict) {
            return RubyBigDecimal.getZero(context, 1);
        }
        if (!exception2) {
            return context.nil;
        }
        throw Error.argumentError(context, "can't omit precision for a " + name2 + ".");
    }

    @Deprecated(since="9.4.7.0")
    public static RubyBigDecimal newInstance(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return (RubyBigDecimal)RubyBigDecimal.newInstance(context, recv2, arg2, true, true);
    }

    @Deprecated(since="9.4.7.0")
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject arg2, boolean strict, boolean exception2) {
        switch (((RubyBasicObject)arg2).getNativeClassIndex()) {
            case RATIONAL: {
                return RubyBigDecimal.handleMissingPrecision(context, "Rational", strict, exception2);
            }
            case FLOAT: {
                RubyBigDecimal res = RubyBigDecimal.newFloatSpecialCases(context, (RubyFloat)arg2);
                if (res != null) {
                    return res;
                }
                return RubyBigDecimal.handleMissingPrecision(context, "Float", strict, exception2);
            }
            case FIXNUM: {
                return RubyBigDecimal.newInstance(context, recv2, (RubyFixnum)arg2, MathContext.UNLIMITED);
            }
            case BIGNUM: {
                return RubyBigDecimal.newInstance(context, recv2, (RubyBignum)arg2, MathContext.UNLIMITED);
            }
            case BIGDECIMAL: {
                return arg2;
            }
            case COMPLEX: {
                RubyComplex c = (RubyComplex)arg2;
                if (((RubyNumeric)c.image(context)).isZero(context)) break;
                throw Error.argumentError(context, "Unable to make a BigDecimal from non-zero imaginary number");
            }
        }
        IRubyObject maybeString = arg2.checkStringType();
        if (maybeString.isNil()) {
            if (!strict) {
                return RubyBigDecimal.getZero(context, 1);
            }
            if (!exception2) {
                return context.nil;
            }
            throw Error.typeError(context, "no implicit conversion of " + String.valueOf(arg2.inspect(context)) + "into to String");
        }
        return RubyBigDecimal.newInstance(context, (RubyClass)recv2, maybeString.convertToString(), MathContext.UNLIMITED, strict, exception2);
    }

    public static RubyBigDecimal newInstance(ThreadContext context, IRubyObject recv2, IRubyObject arg2, IRubyObject mathArg) {
        return (RubyBigDecimal)RubyBigDecimal.newInstance(context, recv2, arg2, mathArg, true, true);
    }

    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject arg2, IRubyObject mathArg, boolean strict, boolean exception2) {
        if (arg2.isNil() || arg2 instanceof RubyBoolean) {
            if (!exception2) {
                return context.nil;
            }
            throw Error.typeError(context, "can't convert " + String.valueOf(arg2.inspect(context)) + " into BigDecimal");
        }
        int digits2 = Convert.toInt(context, mathArg);
        if (digits2 < 0) {
            if (!strict) {
                return RubyBigDecimal.getZero(context, 1);
            }
            if (!exception2) {
                return context.nil;
            }
            throw Error.argumentError(context, "argument must be positive");
        }
        MathContext mathContext = new MathContext(digits2, RubyBigDecimal.getRoundingMode(context));
        switch (((RubyBasicObject)arg2).getNativeClassIndex()) {
            case RATIONAL: {
                if (digits2 == Integer.MAX_VALUE) {
                    return RubyBigDecimal.handleMissingPrecision(context, "Rational", strict, exception2);
                }
                return RubyBigDecimal.newInstance(context, recv2, (RubyRational)arg2, mathContext);
            }
            case FLOAT: {
                RubyBigDecimal res = RubyBigDecimal.newFloatSpecialCases(context, (RubyFloat)arg2);
                if (res != null) {
                    return res;
                }
                if (digits2 == Integer.MAX_VALUE) {
                    return RubyBigDecimal.handleMissingPrecision(context, "Float", strict, exception2);
                }
                return RubyBigDecimal.newInstance(context, recv2, (RubyFloat)arg2, mathContext);
            }
            case FIXNUM: {
                return RubyBigDecimal.newInstance(context, recv2, (RubyFixnum)arg2, mathContext);
            }
            case BIGNUM: {
                return RubyBigDecimal.newInstance(context, recv2, (RubyBignum)arg2, mathContext);
            }
            case BIGDECIMAL: {
                if (digits2 == Integer.MAX_VALUE) {
                    return arg2;
                }
                return RubyBigDecimal.newInstance(context.runtime, recv2, (RubyBigDecimal)arg2);
            }
            case COMPLEX: {
                RubyComplex c = (RubyComplex)arg2;
                if (!((RubyNumeric)c.image(context)).isZero(context)) {
                    throw Error.argumentError(context, "Unable to make a BigDecimal from non-zero imaginary number");
                }
                return RubyBigDecimal.newInstance(context, recv2, c.real(context), mathArg, strict, exception2);
            }
        }
        IRubyObject maybeString = arg2.checkStringType();
        if (maybeString.isNil()) {
            if (!exception2) {
                return context.nil;
            }
            throw Error.typeError(context, "can't convert " + String.valueOf(arg2.getMetaClass()) + " into BigDecimal");
        }
        return RubyBigDecimal.newInstance(context, (RubyClass)recv2, (RubyString)maybeString, MathContext.UNLIMITED, strict, exception2);
    }

    private static RubyBigDecimal getZero(ThreadContext context, int sign2) {
        String constantName = sign2 < 0 ? "NEGATIVE_ZERO" : "POSITIVE_ZERO";
        return (RubyBigDecimal)Access.getClass(context, "BigDecimal").getConstant(context, constantName);
    }

    private static RubyBigDecimal getNaN(ThreadContext context) {
        if (RubyBigDecimal.isNaNExceptionMode(context)) {
            throw RubyBigDecimal.newNaNFloatDomainError(context);
        }
        return (RubyBigDecimal)Access.getClass(context, "BigDecimal").getConstant(context, "NAN");
    }

    private static RaiseException newNaNFloatDomainError(ThreadContext context) {
        return context.runtime.newFloatDomainError("Computation results to 'NaN'(Not a Number)");
    }

    private static RubyBigDecimal getInfinity(ThreadContext context, int sign2) {
        return RubyBigDecimal.getInfinity(context, sign2, InfinityErrorMsgType.To);
    }

    private static RubyBigDecimal getInfinity(ThreadContext context, int sign2, InfinityErrorMsgType type2) {
        if (RubyBigDecimal.isInfinityExceptionMode(context)) {
            throw RubyBigDecimal.newInfinityFloatDomainError(context, sign2, type2);
        }
        String constantName = sign2 < 0 ? "NEGATIVE_INFINITY" : "INFINITY";
        return (RubyBigDecimal)Access.getClass(context, "BigDecimal").getConstant(context, constantName);
    }

    private static RaiseException newInfinityFloatDomainError(ThreadContext context, int sign2) {
        return RubyBigDecimal.newInfinityFloatDomainError(context, sign2, InfinityErrorMsgType.To);
    }

    private static RaiseException newInfinityFloatDomainError(ThreadContext context, int sign2, InfinityErrorMsgType type2) {
        if (type2 == InfinityErrorMsgType.To) {
            return context.runtime.newFloatDomainError("Computation results to " + (sign2 < 0 ? "'-Infinity'" : "'Infinity'"));
        }
        return context.runtime.newFloatDomainError("Computation results in " + (sign2 < 0 ? "'-Infinity'" : "'Infinity'"));
    }

    private RubyBigDecimal setResult(ThreadContext context) {
        return this.setResult(context, 0);
    }

    private RubyBigDecimal setResult(ThreadContext context, int prec) {
        if (prec == 0) {
            prec = RubyBigDecimal.getPrecLimit(context);
        }
        if (prec > 0) {
            int exponent2 = this.getExponent(context);
            if (this.value.scale() > prec - exponent2) {
                this.value = this.value.setScale(prec - exponent2, RoundingMode.HALF_UP);
                this.absStripTrailingZeros = null;
            }
        }
        return this;
    }

    private BigDecimal absStripTrailingZeros() {
        BigDecimal absStripTrailingZeros = this.absStripTrailingZeros;
        if (absStripTrailingZeros == null) {
            this.absStripTrailingZeros = this.value.abs().stripTrailingZeros();
            return this.absStripTrailingZeros;
        }
        return absStripTrailingZeros;
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        return Convert.asFixnum(context, this.absStripTrailingZeros().hashCode() * this.value.signum());
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject original) {
        if (this == original) {
            return this;
        }
        this.checkFrozen();
        if (original instanceof RubyBigDecimal) {
            RubyBigDecimal orig = (RubyBigDecimal)original;
            this.isNaN = orig.isNaN;
            this.infinitySign = orig.infinitySign;
            this.zeroSign = orig.zeroSign;
            this.value = orig.value;
            return this;
        }
        throw Error.typeError(context, "wrong argument class");
    }

    @JRubyMethod(name={"%", "modulo"})
    public IRubyObject op_mod(ThreadContext context, IRubyObject other) {
        RubyBigDecimal val = this.getVpValueWithPrec(context, other, false);
        if (val == null) {
            return this.callCoerced(context, RubyBigDecimal.sites((ThreadContext)context).op_mod, other, true);
        }
        if (this.isNaN() || val.isNaN() || this.isInfinity() && val.isInfinity()) {
            return RubyBigDecimal.getNaN(context);
        }
        if (val.isZero(context)) {
            throw context.runtime.newZeroDivisionError();
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.getNaN(context);
        }
        if (val.isInfinity()) {
            return this;
        }
        if (this.isZero(context)) {
            return RubyBigDecimal.getZero(context, this.value.signum());
        }
        BigDecimal modulo2 = this.value.remainder(val.value);
        if (modulo2.signum() * val.value.signum() < 0) {
            modulo2 = modulo2.add(val.value);
        }
        return new RubyBigDecimal(context.runtime, modulo2).setResult(context);
    }

    @Override
    @JRubyMethod(name={"remainder"})
    public IRubyObject remainder(ThreadContext context, IRubyObject arg2) {
        return this.remainderInternal(context, this.getVpValueWithPrec(context, arg2, false), arg2);
    }

    private IRubyObject remainderInternal(ThreadContext context, RubyBigDecimal val, IRubyObject arg2) {
        if (this.isInfinity() || this.isNaN()) {
            return RubyBigDecimal.getNaN(context);
        }
        if (val == null) {
            return this.callCoerced(context, RubyBigDecimal.sites((ThreadContext)context).remainder, arg2, true);
        }
        if (val.isInfinity()) {
            return this;
        }
        if (val.isNaN() || val.isZero(context)) {
            return RubyBigDecimal.getNaN(context);
        }
        return new RubyBigDecimal(context.runtime, this.value.remainder(val.value)).setResult(context);
    }

    @JRubyMethod(name={"*"})
    public IRubyObject op_mul(ThreadContext context, IRubyObject arg2) {
        RubyBigDecimal val = this.getVpValueWithPrec(context, arg2, false);
        if (val == null) {
            return this.callCoerced(context, RubyBigDecimal.sites((ThreadContext)context).op_times, arg2, true);
        }
        return this.multImpl(context, val);
    }

    @JRubyMethod(name={"mult"})
    public IRubyObject mult2(ThreadContext context, IRubyObject b2, IRubyObject n) {
        int mx = RubyBigDecimal.getPrecisionInt(context, n);
        if (mx == 0) {
            return this.op_mul(context, b2);
        }
        RubyBigDecimal val = this.getVpValueWithPrec(context, b2, false);
        if (val == null) {
            return this.callCoerced(context, RubyBigDecimal.sites((ThreadContext)context).op_times, b2, true);
        }
        return this.multImpl(context, val).setResult(context, mx);
    }

    private RubyBigDecimal multImpl(ThreadContext context, RubyBigDecimal val) {
        BigDecimal result2;
        if (this.isNaN() || val.isNaN()) {
            return RubyBigDecimal.getNaN(context);
        }
        boolean isZero = this.isZero(context);
        if (isZero || val.isZero(context)) {
            if (this.isInfinity() && val.isZero(context) || isZero && val.isInfinity()) {
                return RubyBigDecimal.getNaN(context);
            }
            int sign1 = isZero ? this.zeroSign : this.value.signum();
            int sign2 = val.isZero(context) ? val.zeroSign : val.value.signum();
            return RubyBigDecimal.getZero(context, sign1 * sign2);
        }
        if (this.isInfinity() || val.isInfinity()) {
            int sign1 = this.isInfinity() ? this.infinitySign : this.value.signum();
            int sign2 = val.isInfinity() ? val.infinitySign : val.value.signum();
            return RubyBigDecimal.getInfinity(context, sign1 * sign2);
        }
        int mx = this.value.precision() + val.value.precision();
        MathContext mathContext = new MathContext(mx, RubyBigDecimal.getRoundingMode(context));
        try {
            result2 = this.value.multiply(val.value, mathContext);
        }
        catch (ArithmeticException ex) {
            return (RubyBigDecimal)RubyBigDecimal.checkOverUnderFlow(context, ex, false, true, true);
        }
        return new RubyBigDecimal(context.runtime, result2).setResult(context);
    }

    private static IRubyObject checkOverUnderFlow(ThreadContext context, ArithmeticException ex, boolean nullDefault, boolean strict, boolean exception2) {
        String message2 = ex.getMessage();
        if (message2 == null) {
            message2 = "";
        }
        if ((message2 = message2.toLowerCase(Locale.ENGLISH)).contains("underflow")) {
            return RubyBigDecimal.isUnderflowExceptionMode(context) ? RubyBigDecimal.handleFloatDomainError(context, message2, strict, exception2) : RubyBigDecimal.getZero(context, 1);
        }
        if (message2.contains("overflow")) {
            return RubyBigDecimal.isOverflowExceptionMode(context) ? RubyBigDecimal.handleFloatDomainError(context, message2, strict, exception2) : RubyBigDecimal.getInfinity(context, 1);
        }
        return nullDefault ? null : RubyBigDecimal.handleFloatDomainError(context, message2, strict, exception2);
    }

    private static IRubyObject handleFloatDomainError(ThreadContext context, String message2, boolean strict, boolean exception2) {
        if (!strict) {
            return RubyBigDecimal.getZero(context, 1);
        }
        if (!exception2) {
            return context.nil;
        }
        throw context.runtime.newFloatDomainError(message2);
    }

    private RubyBigDecimal newPowOfInfinity(ThreadContext context, RubyNumeric exp2) {
        if (Numeric.f_negative_p(context, exp2)) {
            if (this.infinitySign >= 0) {
                return RubyBigDecimal.getZero(context, 0);
            }
            if (Numeric.f_integer_p(context, exp2)) {
                return RubyBigDecimal.getZero(context, RubyBigDecimal.isEven(context, exp2) ? 1 : -1);
            }
            return RubyBigDecimal.getZero(context, -1);
        }
        if (this.infinitySign >= 0) {
            return RubyBigDecimal.getInfinity(context, 1);
        }
        if (Numeric.f_integer_p(context, exp2)) {
            return RubyBigDecimal.getInfinity(context, RubyBigDecimal.isEven(context, exp2) ? 1 : -1);
        }
        throw context.runtime.newMathDomainError("a non-integral exponent for a negative base");
    }

    private RubyBigDecimal newPowOfZero(ThreadContext context, RubyNumeric exp2) {
        if (Numeric.f_negative_p(context, exp2)) {
            if (this.zeroSign >= 0) {
                return RubyBigDecimal.getInfinity(context, 1);
            }
            if (Numeric.f_integer_p(context, exp2)) {
                return RubyBigDecimal.getInfinity(context, RubyBigDecimal.isEven(context, exp2) ? 1 : -1);
            }
            return RubyBigDecimal.getInfinity(context, -1);
        }
        return Numeric.f_zero_p(context, exp2) ? new RubyBigDecimal(context.runtime, BigDecimal.ONE) : RubyBigDecimal.getZero(context, 1);
    }

    private static IRubyObject vpPrecLimit(ThreadContext context) {
        return Access.getClass(context, "BigDecimal").searchInternalModuleVariable("vpPrecLimit");
    }

    private static int getPrecLimit(ThreadContext context) {
        return Convert.toInt(context, RubyBigDecimal.vpPrecLimit(context));
    }

    @JRubyMethod(name={"**"})
    public IRubyObject op_pow(ThreadContext context, IRubyObject exp2) {
        return this.op_power(context, exp2, context.nil);
    }

    @JRubyMethod(name={"power"})
    public IRubyObject op_power(ThreadContext context, IRubyObject exp2) {
        return this.op_power(context, exp2, context.nil);
    }

    @JRubyMethod(name={"power"})
    public IRubyObject op_power(ThreadContext context, IRubyObject exp2, IRubyObject prec) {
        BigDecimal pow2;
        double rem;
        int times2;
        int nx;
        if (this.isNaN()) {
            return RubyBigDecimal.getNaN(context);
        }
        if (!(exp2 instanceof RubyNumeric)) {
            throw Error.typeError(context, exp2, "scalar Numeric");
        }
        if (!(exp2 instanceof RubyBignum) && !(exp2 instanceof RubyFixnum)) {
            RubyFixnum zero;
            IRubyObject rounded;
            RubyBigDecimal bigExp;
            if (exp2 instanceof RubyFloat) {
                RubyFloat floatExp = (RubyFloat)exp2;
                double d = floatExp.asLong(context);
                if (d == (double)Math.round(d)) {
                    exp2 = RubyNumeric.fixable(context.runtime, d) ? Convert.asFixnum(context, (long)d) : RubyBignum.newBignorm(context.runtime, d);
                }
            } else if (exp2 instanceof RubyRational) {
                if (!Numeric.f_zero_p(context, Numeric.f_numerator(context, exp2)) && Numeric.f_one_p(context, Numeric.f_denominator(context, exp2))) {
                    exp2 = Numeric.f_numerator(context, exp2);
                }
            } else if (exp2 instanceof RubyBigDecimal && (bigExp = (RubyBigDecimal)exp2).eql_p(context, rounded = bigExp.round(context, new IRubyObject[]{zero = Convert.asFixnum(context, 0)})).isTrue()) {
                exp2 = bigExp.to_int();
            }
        }
        if (this.isZero(context)) {
            return this.newPowOfZero(context, (RubyNumeric)exp2);
        }
        if (Numeric.f_zero_p(context, exp2)) {
            return new RubyBigDecimal(context.runtime, BigDecimal.ONE);
        }
        if (this.isInfinity()) {
            return this.newPowOfInfinity(context, (RubyNumeric)exp2);
        }
        int n = nx = prec.isNil() ? this.getPrec(context) * 9 : Convert.toInt(context, prec);
        if (exp2 instanceof RubyBigDecimal) {
            RubyBigDecimal bdExp = (RubyBigDecimal)exp2;
            int ny = bdExp.getPrec(context) * 9;
            return this.bigdecimal_power_by_bigdecimal(context, exp2, prec.isNil() ? nx + ny : nx);
        }
        if (exp2 instanceof RubyFloat) {
            int ny = 16;
            return this.bigdecimal_power_by_bigdecimal(context, exp2, prec.isNil() ? nx + ny : nx);
        }
        if (exp2 instanceof RubyRational) {
            int ny = nx;
            return this.bigdecimal_power_by_bigdecimal(context, exp2, prec.isNil() ? nx + ny : nx);
        }
        if (exp2 instanceof RubyBignum) {
            RubyBignum bexp = (RubyBignum)exp2;
            BigDecimal absValue = this.value.abs();
            if (absValue.equals(BigDecimal.ONE)) {
                return new RubyBigDecimal(context.runtime, BigDecimal.ONE, 0, 1);
            }
            if (absValue.compareTo(BigDecimal.ONE) == -1) {
                if (Numeric.f_negative_p(context, exp2)) {
                    return RubyBigDecimal.getInfinity(context, (RubyBigDecimal.isEven(context, bexp) ? 1 : -1) * this.value.signum());
                }
                if (Numeric.f_negative_p(context, this) && RubyBigDecimal.isEven(context, bexp)) {
                    return RubyBigDecimal.getZero(context, -1);
                }
                return RubyBigDecimal.getZero(context, 1);
            }
            if (!Numeric.f_negative_p(context, exp2)) {
                return RubyBigDecimal.getInfinity(context, (RubyBigDecimal.isEven(context, bexp) ? 1 : -1) * this.value.signum());
            }
            if (this.value.signum() == -1 && RubyBigDecimal.isEven(context, bexp)) {
                return RubyBigDecimal.getZero(context, -1);
            }
            return RubyBigDecimal.getZero(context, 1);
        }
        if (!(exp2 instanceof RubyInteger)) {
            BigDecimal expVal = BigDecimal.valueOf(((RubyNumeric)exp2).asDouble(context));
            BigDecimal[] divAndRem = expVal.divideAndRemainder(BigDecimal.ONE);
            times2 = divAndRem[0].intValueExact();
            rem = divAndRem[1].doubleValue();
        } else {
            times2 = Convert.toInt(context, exp2);
            rem = 0.0;
        }
        if (times2 < 0) {
            if (this.isZero(context)) {
                return RubyBigDecimal.getInfinity(context, this.value.signum());
            }
            pow2 = this.powNegative(context, times2);
        } else {
            pow2 = this.value.pow(times2);
        }
        if (rem > 0.0) {
            double remPow = Math.pow(this.value.doubleValue(), rem);
            pow2 = pow2.multiply(BigDecimal.valueOf(remPow));
        }
        if (!prec.isNil()) {
            pow2 = pow2.setScale(nx, RubyBigDecimal.getRoundingMode(context));
        }
        return new RubyBigDecimal(context.runtime, pow2);
    }

    private IRubyObject bigdecimal_power_by_bigdecimal(ThreadContext context, IRubyObject exp2, int precision2) {
        RubyModule bigMath = Access.getModule(context, "BigMath");
        RubyBigDecimal log_x = (RubyBigDecimal)bigMath.callMethod(context, "log", new IRubyObject[]{this, Convert.asFixnum(context, precision2 + 1)});
        RubyBigDecimal multipled = (RubyBigDecimal)log_x.mult2(context, exp2, Convert.asFixnum(context, precision2 + 1));
        return bigMath.callMethod(context, "exp", new IRubyObject[]{multipled, Convert.asFixnum(context, precision2)});
    }

    private BigDecimal powNegative(ThreadContext context, int times2) {
        int mp = this.getPrec(context) * 10 * (-times2 + 1);
        int precision2 = (mp + 8) / 9 * 9;
        BigDecimal pow2 = this.value.pow(times2, new MathContext(precision2 * 2, RoundingMode.DOWN));
        BigDecimal tmp = pow2.abs().stripTrailingZeros();
        int exponent2 = tmp.precision() - tmp.scale();
        precision2 = exponent2 < 0 ? (precision2 += Math.abs(exponent2) / 9 * 9) : (precision2 -= (exponent2 + 8) / 9 * 9);
        return pow2.setScale(precision2, RoundingMode.DOWN);
    }

    @Override
    @JRubyMethod(name={"+"})
    public IRubyObject op_plus(ThreadContext context, IRubyObject b2) {
        return this.addInternal(context, this.getVpValueWithPrec(context, b2, false), b2, RubyBigDecimal.vpPrecLimit(context));
    }

    @JRubyMethod(name={"add"})
    public IRubyObject add2(ThreadContext context, IRubyObject b2, IRubyObject digits2) {
        return this.addInternal(context, this.getVpValueWithPrec(context, b2, false), b2, digits2);
    }

    private IRubyObject addInternal(ThreadContext context, RubyBigDecimal val, IRubyObject b2, IRubyObject digits2) {
        int prec = RubyBigDecimal.getPositiveInt(context, digits2);
        if (val == null) {
            RubyBigDecimal ret = (RubyBigDecimal)this.callCoerced(context, RubyBigDecimal.sites((ThreadContext)context).op_plus, b2, true);
            if (ret != null) {
                ret.setResult(context, prec);
            }
            return ret;
        }
        RubyBigDecimal res = this.addSpecialCases(context, val);
        if (res != null) {
            return res;
        }
        MathContext mathContext = new MathContext(prec, RubyBigDecimal.getRoundingMode(context));
        return new RubyBigDecimal(context.runtime, this.value.add(val.value, mathContext)).setResult(context, prec);
    }

    private static int getPositiveInt(ThreadContext context, IRubyObject arg2) {
        int value2 = Convert.castAsFixnum(context, arg2).asInt(context);
        if (value2 < 0) {
            throw Error.argumentError(context, "argument must be positive");
        }
        return value2;
    }

    private RubyBigDecimal addSpecialCases(ThreadContext context, RubyBigDecimal val) {
        if (this.isNaN() || val.isNaN) {
            return RubyBigDecimal.getNaN(context);
        }
        if (this.isZero(context)) {
            if (val.isZero(context)) {
                return RubyBigDecimal.getZero(context, this.zeroSign == val.zeroSign ? this.zeroSign : 1);
            }
            if (val.isInfinity()) {
                return RubyBigDecimal.getInfinity(context, val.infinitySign);
            }
            return new RubyBigDecimal(context.runtime, val.value);
        }
        int sign2 = this.infinitySign * val.infinitySign;
        if (sign2 > 0) {
            return RubyBigDecimal.getInfinity(context, this.infinitySign);
        }
        if (sign2 < 0) {
            return RubyBigDecimal.getNaN(context);
        }
        if (sign2 == 0 && (sign2 = this.infinitySign + val.infinitySign) != 0) {
            return RubyBigDecimal.getInfinity(context, sign2);
        }
        return null;
    }

    @Override
    @JRubyMethod(name={"+@"})
    public IRubyObject op_uplus(ThreadContext context) {
        return this;
    }

    @Override
    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus(ThreadContext context) {
        if (this.isNaN()) {
            return RubyBigDecimal.getNaN(context);
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.getInfinity(context, -this.infinitySign);
        }
        if (this.isZero(context)) {
            return RubyBigDecimal.getZero(context, -this.zeroSign);
        }
        return new RubyBigDecimal(context.runtime, this.value.negate());
    }

    @Override
    @JRubyMethod(name={"-"})
    public IRubyObject op_minus(ThreadContext context, IRubyObject b2) {
        return this.subInternal(context, this.getVpValueWithPrec(context, b2, false), b2, 0);
    }

    @JRubyMethod(name={"sub"})
    public IRubyObject sub2(ThreadContext context, IRubyObject b2, IRubyObject n) {
        return this.subInternal(context, this.getVpValueWithPrec(context, b2, false), b2, RubyBigDecimal.getPositiveInt(context, n));
    }

    private IRubyObject subInternal(ThreadContext context, RubyBigDecimal val, IRubyObject b2, int prec) {
        if (val == null) {
            return ((RubyBigDecimal)this.callCoerced(context, RubyBigDecimal.sites((ThreadContext)context).op_minus, b2, true)).setResult(context, prec);
        }
        RubyBigDecimal res = this.subSpecialCases(context, val);
        return res != null ? res : new RubyBigDecimal(context.runtime, this.value.subtract(val.value)).setResult(context, prec);
    }

    private RubyBigDecimal subSpecialCases(ThreadContext context, RubyBigDecimal val) {
        if (this.isNaN() || val.isNaN()) {
            return RubyBigDecimal.getNaN(context);
        }
        if (this.isZero(context)) {
            if (val.isZero(context)) {
                return RubyBigDecimal.getZero(context, this.zeroSign * val.zeroSign);
            }
            if (val.isInfinity()) {
                return RubyBigDecimal.getInfinity(context, val.infinitySign * -1);
            }
            return new RubyBigDecimal(context.runtime, val.value.negate());
        }
        int sign2 = this.infinitySign * val.infinitySign;
        if (sign2 > 0) {
            return RubyBigDecimal.getNaN(context);
        }
        if (sign2 < 0) {
            return RubyBigDecimal.getInfinity(context, this.infinitySign);
        }
        if (sign2 == 0) {
            if (this.isInfinity()) {
                return this;
            }
            if (val.isInfinity()) {
                return RubyBigDecimal.getInfinity(context, val.infinitySign * -1);
            }
            sign2 = this.infinitySign + val.infinitySign;
            if (sign2 != 0) {
                return RubyBigDecimal.getInfinity(context, sign2);
            }
        }
        return null;
    }

    @JRubyMethod(name={"/"})
    public IRubyObject op_divide(ThreadContext context, IRubyObject other) {
        RubyBigDecimal val = this.getVpValueWithPrec(context, other, false);
        if (val == null) {
            return this.callCoerced(context, RubyBigDecimal.sites((ThreadContext)context).op_quo, other, true);
        }
        if (this.isNaN() || val.isNaN()) {
            return RubyBigDecimal.getNaN(context);
        }
        RubyBigDecimal div2 = this.divSpecialCases(context, val);
        if (div2 != null) {
            return div2;
        }
        return this.quoImpl(context, val);
    }

    @JRubyMethod(name={"quo"})
    public IRubyObject op_quo(ThreadContext context, IRubyObject other) {
        return this.op_divide(context, other);
    }

    @JRubyMethod(name={"quo"})
    public IRubyObject op_quo(ThreadContext context, IRubyObject object, IRubyObject digits2) {
        int n = Convert.toInt(context, digits2);
        if (n > 0) {
            return this.op_div(context, object, digits2);
        }
        return this.op_divide(context, object);
    }

    private RubyBigDecimal quoImpl(ThreadContext context, RubyBigDecimal that) {
        int limit2;
        int mxb;
        int mx = this.getPrecisionScale()[0];
        if (mx < (mxb = that.getPrecisionScale()[0])) {
            mx = mxb;
        }
        if (32 > (mx *= 2)) {
            mx = 32;
        }
        if ((limit2 = RubyBigDecimal.getPrecLimit(context)) > 0 && limit2 < mx) {
            mx = limit2;
        }
        mx = (mx + 8) / 9 * 9;
        RoundingMode mode2 = RubyBigDecimal.getRoundingMode(context);
        MathContext mathContext = new MathContext(mx * 2, mode2);
        BigDecimal ret = RubyBigDecimal.divide(this.value, that.value, mathContext).setScale(mx, mode2);
        return new RubyBigDecimal(context.runtime, ret).setResult(context, limit2);
    }

    private static BigDecimal divide(BigDecimal target2, BigDecimal divisor, MathContext mc) {
        long diffScale;
        assert (mc.getPrecision() != 0);
        long trailingZeros = (long)mc.getPrecision() + 1L + (long)divisor.precision() - (long)target2.precision();
        long newScale = diffScale = (long)target2.scale() - (long)divisor.scale();
        BigInteger[] quotAndRem = new BigInteger[]{target2.unscaledValue()};
        BigInteger divScaled = divisor.unscaledValue();
        if (trailingZeros > 0L) {
            quotAndRem[0] = quotAndRem[0].multiply(Multiplication.powerOf10(trailingZeros));
            newScale += trailingZeros;
        }
        quotAndRem = quotAndRem[0].divideAndRemainder(divScaled);
        BigInteger integerQuot = quotAndRem[0];
        if (quotAndRem[1].signum() != 0) {
            int compRem = RubyBigDecimal.shiftLeftOneBit(quotAndRem[1]).compareTo(divScaled);
            integerQuot = integerQuot.multiply(BigInteger.TEN).add(BigInteger.valueOf(quotAndRem[0].signum() * (5 + compRem)));
            ++newScale;
        }
        return new BigDecimal(integerQuot, RubyBigDecimal.safeLongToInt(newScale), mc);
    }

    private static BigInteger shiftLeftOneBit(BigInteger i2) {
        return i2.shiftLeft(1);
    }

    private static int safeLongToInt(long longValue) {
        if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) {
            throw new ArithmeticException("Out of int range: " + longValue);
        }
        return (int)longValue;
    }

    private static RubyBigDecimal div2Impl(ThreadContext context, RubyNumeric a, RubyNumeric b2, int ix) {
        RubyBigDecimal thiz = RubyBigDecimal.getVpValue(context, a, true);
        RubyBigDecimal that = RubyBigDecimal.getVpValue(context, b2, true);
        if (thiz.isNaN() || that.isNaN()) {
            return RubyBigDecimal.getNaN(context);
        }
        RubyBigDecimal div2 = thiz.divSpecialCases(context, that);
        if (div2 != null) {
            return div2;
        }
        int mx = thiz.value.precision() + that.value.precision() + 2;
        MathContext mathContext = new MathContext((mx * 2 + 2) * 9, RubyBigDecimal.getRoundingMode(context));
        return new RubyBigDecimal(context.runtime, thiz.value.divide(that.value, mathContext)).setResult(context, ix);
    }

    @JRubyMethod(name={"div"})
    public IRubyObject op_div(ThreadContext context, IRubyObject other) {
        return this.op_div(context, other, context.nil);
    }

    private RubyInteger idiv(ThreadContext context, RubyRational val) {
        if (this.isNaN()) {
            throw RubyBigDecimal.newNaNFloatDomainError(context);
        }
        if (this.isInfinity()) {
            throw RubyBigDecimal.newInfinityFloatDomainError(context, this.infinitySign);
        }
        if (val.isZero(context)) {
            throw context.runtime.newZeroDivisionError();
        }
        BigDecimal result2 = this.value.multiply(RubyBigDecimal.toBigDecimal(context, val.getDenominator())).divideToIntegralValue(RubyBigDecimal.toBigDecimal(context, val.getNumerator()));
        return RubyBigDecimal.toInteger(context, result2);
    }

    private static RubyInteger toInteger(ThreadContext context, BigDecimal result2) {
        return result2.compareTo(MAX_FIX) <= 0 && result2.compareTo(MIN_FIX) >= 0 ? Convert.asFixnum(context, result2.longValue()) : RubyBignum.newBignum(context.runtime, result2.toBigInteger());
    }

    @JRubyMethod(name={"div"})
    public IRubyObject op_div(ThreadContext context, IRubyObject other, IRubyObject digits2) {
        RubyBigDecimal val = RubyBigDecimal.getVpValue(context, other, false);
        if (digits2.isNil()) {
            if (val == null) {
                return this.callCoerced(context, RubyBigDecimal.sites((ThreadContext)context).div, other, true);
            }
            if (this.isNaN() || val.isNaN()) {
                throw RubyBigDecimal.newNaNFloatDomainError(context);
            }
            if (this.isInfinity()) {
                if (val.isInfinity()) {
                    throw RubyBigDecimal.newNaNFloatDomainError(context);
                }
                throw RubyBigDecimal.newInfinityFloatDomainError(context, this.infinitySign);
            }
            if (val.isZero(context)) {
                throw context.runtime.newZeroDivisionError();
            }
            if (val.isInfinity()) {
                return RubyFixnum.zero(context.runtime);
            }
            return RubyBigDecimal.toInteger(context, this.value.divideToIntegralValue(val.value));
        }
        int scale2 = Convert.toInt(context, digits2);
        if (scale2 == 0) {
            return this.op_divide(context, other);
        }
        val = RubyBigDecimal.getVpValue(context, other, true);
        if (this.isNaN() || val.isNaN()) {
            return RubyBigDecimal.getNaN(context);
        }
        RubyBigDecimal div2 = this.divSpecialCases(context, val);
        if (div2 != null) {
            return div2;
        }
        MathContext mathContext = new MathContext(scale2, RubyBigDecimal.getRoundingMode(context));
        return new RubyBigDecimal(context.runtime, this.value.divide(val.value, mathContext)).setResult(context, scale2);
    }

    private RubyBigDecimal divSpecialCases(ThreadContext context, RubyBigDecimal val) {
        if (this.isInfinity()) {
            return val.isInfinity() ? RubyBigDecimal.getNaN(context) : RubyBigDecimal.getInfinity(context, this.infinitySign * val.value.signum());
        }
        if (val.isInfinity()) {
            return RubyBigDecimal.getZero(context, this.value.signum() * val.infinitySign);
        }
        if (val.isZero(context)) {
            if (this.isZero(context)) {
                return RubyBigDecimal.getNaN(context);
            }
            if (RubyBigDecimal.isZeroDivideExceptionMode(context)) {
                throw context.runtime.newFloatDomainError("Divide by zero");
            }
            int sign1 = this.isInfinity() ? this.infinitySign : this.value.signum();
            return RubyBigDecimal.getInfinity(context, sign1 * val.zeroSign, InfinityErrorMsgType.In);
        }
        if (this.isZero(context)) {
            return RubyBigDecimal.getZero(context, this.zeroSign * val.value.signum());
        }
        return null;
    }

    private IRubyObject cmp(ThreadContext context, IRubyObject arg2, char op) {
        RubyBigDecimal rb;
        RubyBigDecimal rubyBigDecimal = rb = arg2 instanceof RubyRational ? this.getVpValueWithPrec(context, arg2, false) : RubyBigDecimal.getVpValue(context, arg2, false);
        if (rb == null) {
            String id2 = "!=";
            switch (op) {
                case '*': {
                    if (RubyBigDecimal.falsyEqlCheck(context, arg2)) {
                        return context.nil;
                    }
                    return this.callCoerced(context, RubyBigDecimal.sites((ThreadContext)context).op_cmp, arg2, false);
                }
                case '=': {
                    if (RubyBigDecimal.falsyEqlCheck(context, arg2)) {
                        return context.fals;
                    }
                    IRubyObject res = this.callCoerced(context, RubyBigDecimal.sites((ThreadContext)context).op_eql, arg2, false);
                    return Convert.asBoolean(context, res != context.nil && res != context.fals);
                }
                case '!': {
                    if (!RubyBigDecimal.falsyEqlCheck(context, arg2)) break;
                    return context.tru;
                }
                case 'G': {
                    id2 = ">=";
                    break;
                }
                case 'L': {
                    id2 = "<=";
                    break;
                }
                case '<': {
                    id2 = "<";
                    break;
                }
                case '>': {
                    id2 = ">";
                }
            }
            IRubyObject cmp2 = this.callCoerced(context, id2, arg2);
            if (cmp2 == context.nil) {
                throw Error.argumentError(context, "comparison of BigDecimal with " + RubyBigDecimal.errMessageType(context, arg2) + " failed");
            }
            return cmp2;
        }
        if (this.isNaN() || rb.isNaN()) {
            return op == '*' ? context.nil : context.fals;
        }
        int e = this.infinitySign != 0 || rb.infinitySign != 0 ? this.infinitySign - rb.infinitySign : this.value.compareTo(rb.value);
        switch (op) {
            case '*': {
                return Convert.asFixnum(context, e);
            }
            case '=': {
                return Convert.asBoolean(context, e == 0);
            }
            case '!': {
                return Convert.asBoolean(context, e != 0);
            }
            case 'G': {
                return Convert.asBoolean(context, e >= 0);
            }
            case '>': {
                return Convert.asBoolean(context, e > 0);
            }
            case 'L': {
                return Convert.asBoolean(context, e <= 0);
            }
            case '<': {
                return Convert.asBoolean(context, e < 0);
            }
        }
        return context.nil;
    }

    private static boolean falsyEqlCheck(ThreadContext context, IRubyObject arg2) {
        return arg2 == context.nil || arg2 == context.fals || arg2 == context.tru;
    }

    @Override
    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, '*');
    }

    @Override
    @JRubyMethod(name={"eql?", "=="})
    public IRubyObject eql_p(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, '=');
    }

    @Override
    @JRubyMethod(name={"==="})
    public IRubyObject op_eqq(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, '=');
    }

    @JRubyMethod(name={"<"})
    public IRubyObject op_lt(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, '<');
    }

    @JRubyMethod(name={"<="})
    public IRubyObject op_le(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, 'L');
    }

    @JRubyMethod(name={">"})
    public IRubyObject op_gt(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, '>');
    }

    @JRubyMethod(name={">="})
    public IRubyObject op_ge(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, 'G');
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject abs() {
        return this.abs(this.getCurrentContext());
    }

    @Override
    @JRubyMethod
    public IRubyObject abs(ThreadContext context) {
        if (this.isNaN()) {
            return RubyBigDecimal.getNaN(context);
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.getInfinity(context, 1);
        }
        return new RubyBigDecimal(context.runtime, this.value.abs()).setResult(context);
    }

    @JRubyMethod
    public IRubyObject ceil(ThreadContext context, IRubyObject arg2) {
        this.checkFloatDomain();
        int n = Convert.toInt(context, arg2);
        if (this.value.scale() <= n) {
            return this;
        }
        return new RubyBigDecimal(context.runtime, this.value.setScale(n, RoundingMode.CEILING));
    }

    @Override
    @JRubyMethod
    public IRubyObject ceil(ThreadContext context) {
        this.checkFloatDomain();
        BigInteger ceil2 = this.value.setScale(0, RoundingMode.CEILING).toBigInteger();
        if (ceil2.compareTo(BigInteger.valueOf(ceil2.intValue())) == 0) {
            return Convert.asFixnum(context, ceil2.intValue());
        }
        return RubyBignum.newBignum(context.runtime, ceil2);
    }

    @Override
    @JRubyMethod
    public RubyArray coerce(ThreadContext context, IRubyObject other) {
        return Create.newArray(context, (IRubyObject)RubyBigDecimal.getVpValue(context, other, true), (IRubyObject)this);
    }

    @Override
    @JRubyAPI
    public BigInteger asBigInteger(ThreadContext context) {
        return this.value.toBigInteger();
    }

    @Override
    @JRubyAPI
    public double asDouble(ThreadContext context) {
        return this.value.doubleValue();
    }

    @Override
    @JRubyAPI
    public int asInt(ThreadContext context) {
        return this.value.intValue();
    }

    @Override
    @JRubyAPI
    public long asLong(ThreadContext context) {
        return this.value.longValue();
    }

    public BigDecimal getBigDecimalValue() {
        return this.value;
    }

    public RubyNumeric multiplyWith(ThreadContext context, RubyInteger value2) {
        return (RubyNumeric)this.op_mul(context, value2);
    }

    public RubyNumeric multiplyWith(ThreadContext context, RubyFloat value2) {
        return (RubyNumeric)this.op_mul(context, value2);
    }

    public RubyNumeric multiplyWith(ThreadContext context, RubyBignum value2) {
        return (RubyNumeric)this.op_mul(context, value2);
    }

    @Override
    @JRubyMethod(name={"divmod"})
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.runtime;
        RubyBigDecimal val = this.getVpValueWithPrec(context, other, false);
        if (val == null) {
            return this.callCoerced(context, RubyBigDecimal.sites((ThreadContext)context).divmod, other, true);
        }
        if (this.isNaN() || val.isNaN() || this.isInfinity() && val.isInfinity()) {
            return Create.newArray(context, (IRubyObject)RubyBigDecimal.getNaN(context), (IRubyObject)RubyBigDecimal.getNaN(context));
        }
        if (val.isZero(context)) {
            throw runtime2.newZeroDivisionError();
        }
        if (this.isInfinity()) {
            int sign2 = this.infinitySign == val.value.signum() ? 1 : -1;
            return Create.newArray(context, (IRubyObject)RubyBigDecimal.getInfinity(context, sign2), (IRubyObject)RubyBigDecimal.getNaN(context));
        }
        if (val.isInfinity()) {
            return Create.newArray(context, (IRubyObject)RubyBigDecimal.getZero(context, val.value.signum()), (IRubyObject)this);
        }
        if (this.isZero(context)) {
            return Create.newArray(context, (IRubyObject)RubyBigDecimal.getZero(context, this.value.signum()), (IRubyObject)RubyBigDecimal.getZero(context, this.value.signum()));
        }
        BigDecimal[] divmod2 = this.value.divideAndRemainder(val.value);
        BigDecimal div2 = divmod2[0];
        BigDecimal mod = divmod2[1];
        if (mod.signum() * val.value.signum() < 0) {
            div2 = div2.subtract(BigDecimal.ONE);
            mod = mod.add(val.value);
        }
        return Create.newArray(context, (IRubyObject)new RubyBigDecimal(runtime2, div2), (IRubyObject)new RubyBigDecimal(runtime2, mod));
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject exponent() {
        return this.exponent(this.getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject exponent(ThreadContext context) {
        return Convert.asFixnum(context, this.getExponent(context));
    }

    @Override
    @JRubyMethod(name={"finite?"})
    public IRubyObject finite_p(ThreadContext context) {
        return Convert.asBoolean(context, !this.isNaN() && !this.isInfinity());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject finite_p() {
        return this.finite_p(this.getCurrentContext());
    }

    private RubyBigDecimal floorNaNInfinityCheck(ThreadContext context) {
        if (this.isNaN()) {
            throw RubyBigDecimal.newNaNFloatDomainError(context);
        }
        if (this.isInfinity()) {
            throw RubyBigDecimal.newInfinityFloatDomainError(context, this.infinitySign);
        }
        return null;
    }

    private RubyBigDecimal floorImpl(ThreadContext context, int n) {
        return this.value.scale() > n ? new RubyBigDecimal(context.runtime, this.value.setScale(n, RoundingMode.FLOOR)) : this;
    }

    @Override
    @JRubyMethod
    public IRubyObject floor(ThreadContext context) {
        RubyBigDecimal res = this.floorNaNInfinityCheck(context);
        return res != null ? res : this.floorImpl(context, 0).to_int(context);
    }

    @JRubyMethod
    public IRubyObject floor(ThreadContext context, IRubyObject arg2) {
        RubyBigDecimal res = this.floorNaNInfinityCheck(context);
        return res != null ? res : this.floorImpl(context, Convert.toInt(context, arg2));
    }

    @JRubyMethod
    public IRubyObject frac(ThreadContext context) {
        if (this.isNaN()) {
            return RubyBigDecimal.getNaN(context);
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.getInfinity(context, this.infinitySign);
        }
        return this.value.scale() > 0 && this.value.precision() < this.value.scale() ? new RubyBigDecimal(context.runtime, this.value) : new RubyBigDecimal(context.runtime, this.value.subtract(((RubyBigDecimal)this.fix()).value));
    }

    @Override
    @JRubyMethod(name={"infinite?"})
    public IRubyObject infinite_p(ThreadContext context) {
        return this.infinitySign == 0 ? context.nil : Convert.asFixnum(context, this.infinitySign);
    }

    @Override
    @JRubyMethod
    public IRubyObject inspect(ThreadContext context) {
        return this.toStringImpl(context, null);
    }

    @JRubyMethod(name={"nan?"})
    public IRubyObject nan_p(ThreadContext context) {
        return Convert.asBoolean(context, this.isNaN());
    }

    @Override
    @JRubyMethod(name={"nonzero?"})
    public IRubyObject nonzero_p(ThreadContext context) {
        return this.isZero(context) ? context.nil : this;
    }

    @Deprecated(since="9.2.0.0")
    public IRubyObject nonzero_p() {
        return this.nonzero_p(this.getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject n_significant_digits(ThreadContext context) {
        return this.value.equals(BigDecimal.ZERO) ? RubyFixnum.zero(context.runtime) : Convert.asFixnum(context, this.value.stripTrailingZeros().precision());
    }

    @JRubyMethod
    public IRubyObject precision(ThreadContext context) {
        return this.precision_scale(context).aref(context, (IRubyObject)RubyFixnum.zero(context.runtime));
    }

    @JRubyMethod
    public IRubyObject scale(ThreadContext context) {
        return this.precision_scale(context).aref(context, (IRubyObject)RubyFixnum.one(context.runtime));
    }

    @JRubyMethod
    public RubyArray precision_scale(ThreadContext context) {
        int[] ary = this.getPrecisionScale();
        return Create.newArray(context, (IRubyObject)Convert.asFixnum(context, ary[0]), (IRubyObject)Convert.asFixnum(context, ary[1]));
    }

    private int[] getPrecisionScale() {
        int precision2 = 0;
        int scale2 = 0;
        String plainString = this.value.toPlainString();
        if (!this.value.equals(BigDecimal.ZERO)) {
            if (!plainString.contains(".")) {
                precision2 = plainString.replace("-", "").length();
            } else {
                String[] params2 = plainString.split("\\.");
                if (new BigDecimal(params2[1]).equals(BigDecimal.ZERO)) {
                    precision2 = params2[0].replace("-", "").length();
                } else {
                    precision2 = Math.max(this.value.precision(), this.value.scale());
                    scale2 = this.value.scale();
                }
            }
        }
        return new int[]{precision2, scale2};
    }

    private int getPrec(ThreadContext context) {
        int[] precisionScale = this.getPrecisionScale();
        if (precisionScale[0] > precisionScale[1]) {
            return (precisionScale[0] + (9 - (precisionScale[0] - precisionScale[1])) + 8) / 9;
        }
        if (this.getExponent(context) > -9) {
            return (this.value.toString().length() - 2 + 8) / 9;
        }
        return (this.value.unscaledValue().toString().length() + 8) / 9;
    }

    @Deprecated(since="9.4.3.0")
    @JRubyMethod
    public IRubyObject precs(ThreadContext context) {
        Warn.warnDeprecated(context, "BigDecimal#precs is deprecated and will be removed in the future; use BigDecimal#precision instead.");
        return Create.newArray(context, (IRubyObject)Convert.asFixnum(context, this.getSignificantDigits().length()), (IRubyObject)Convert.asFixnum(context, (this.getAllDigits().length() / 4 + 1) * 4));
    }

    @JRubyMethod(name={"round"}, optional=2, checkArity=false)
    public IRubyObject round(ThreadContext context, IRubyObject[] args2) {
        RubyBigDecimal bigDecimal;
        int argc = Arity.checkArgumentCount(context, args2, 0, 2);
        if (this.isNaN()) {
            if (argc == 0) {
                throw RubyBigDecimal.newNaNFloatDomainError(context);
            }
            return RubyBigDecimal.getNaN(context);
        }
        if (this.isInfinity()) {
            if (argc == 0) {
                throw RubyBigDecimal.newInfinityFloatDomainError(context, this.infinitySign);
            }
            return RubyBigDecimal.getInfinity(context, this.infinitySign);
        }
        RoundingMode mode2 = RubyBigDecimal.getRoundingMode(context);
        int scale2 = 0;
        boolean roundToInt = false;
        switch (argc) {
            case 2: {
                mode2 = RubyBigDecimal.javaRoundingModeFromRubyRoundingMode(context, args2[1]);
                scale2 = Convert.toInt(context, args2[0]);
                break;
            }
            case 1: {
                if (ArgsUtil.getOptionsArg(context, args2[0]) == context.nil) {
                    scale2 = Convert.toInt(context, args2[0]);
                    if (scale2 >= 1) break;
                    roundToInt = true;
                    break;
                }
                mode2 = RubyBigDecimal.javaRoundingModeFromRubyRoundingMode(context, args2[0]);
                break;
            }
            case 0: {
                roundToInt = true;
            }
        }
        if (scale2 < 0) {
            BigDecimal normalized = this.value.movePointRight(scale2);
            BigDecimal rounded = normalized.setScale(0, mode2);
            bigDecimal = new RubyBigDecimal(context.runtime, rounded.movePointLeft(scale2));
        } else {
            bigDecimal = new RubyBigDecimal(context.runtime, this.value.setScale(scale2, mode2));
        }
        return roundToInt ? bigDecimal.to_int(context) : bigDecimal;
    }

    public IRubyObject round(ThreadContext context, IRubyObject scale2, IRubyObject mode2) {
        return this.round(context, new IRubyObject[]{scale2, mode2});
    }

    private static int rubyRoundingModeFromJavaRoundingMode(ThreadContext context, RoundingMode mode2) {
        if (mode2.equals((Object)RoundingMode.UP)) {
            return 1;
        }
        if (mode2.equals((Object)RoundingMode.DOWN)) {
            return 2;
        }
        if (mode2.equals((Object)RoundingMode.HALF_UP)) {
            return 3;
        }
        if (mode2.equals((Object)RoundingMode.HALF_DOWN)) {
            return 4;
        }
        if (mode2.equals((Object)RoundingMode.CEILING)) {
            return 5;
        }
        if (mode2.equals((Object)RoundingMode.FLOOR)) {
            return 6;
        }
        if (mode2.equals((Object)RoundingMode.HALF_EVEN)) {
            return 7;
        }
        throw Error.argumentError(context, "invalid rounding mode");
    }

    private static RoundingMode javaRoundingModeFromRubyRoundingMode(ThreadContext context, IRubyObject arg2) {
        if (arg2 == context.nil) {
            return RubyBigDecimal.getRoundingMode(context);
        }
        IRubyObject opts = ArgsUtil.getOptionsArg(context, arg2);
        if (opts != context.nil) {
            String roundingMode;
            arg2 = ArgsUtil.extractKeywordArg(context, (RubyHash)opts, "half");
            if (arg2 == null || arg2 == context.nil) {
                return RubyBigDecimal.getRoundingMode(context);
            }
            return switch (roundingMode = arg2 instanceof RubySymbol ? arg2.asJavaString() : arg2.toString()) {
                case "up" -> RoundingMode.HALF_UP;
                case "down" -> RoundingMode.HALF_DOWN;
                case "even" -> RoundingMode.HALF_EVEN;
                default -> throw Error.argumentError(context, "invalid rounding mode (" + roundingMode + ")");
            };
        }
        if (arg2 instanceof RubySymbol) {
            String roundingMode;
            return switch (roundingMode = arg2.asJavaString()) {
                case "up" -> RoundingMode.UP;
                case "down", "truncate" -> RoundingMode.DOWN;
                case "half_up", "default" -> RoundingMode.HALF_UP;
                case "half_down" -> RoundingMode.HALF_DOWN;
                case "half_even", "even", "banker" -> RoundingMode.HALF_EVEN;
                case "ceiling", "ceil" -> RoundingMode.CEILING;
                case "floor" -> RoundingMode.FLOOR;
                default -> throw Error.argumentError(context, "invalid rounding mode (" + roundingMode + ")");
            };
        }
        return switch (Convert.toInt(context, arg2)) {
            case 1 -> RoundingMode.UP;
            case 2 -> RoundingMode.DOWN;
            case 3 -> RoundingMode.HALF_UP;
            case 4 -> RoundingMode.HALF_DOWN;
            case 5 -> RoundingMode.CEILING;
            case 6 -> RoundingMode.FLOOR;
            case 7 -> RoundingMode.HALF_EVEN;
            default -> throw Error.argumentError(context, "invalid rounding mode");
        };
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject sign() {
        return this.sign(this.getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject sign(ThreadContext context) {
        if (this.isNaN()) {
            return this.getMetaClass().getConstant(context, "SIGN_NaN");
        }
        if (this.isInfinity()) {
            return this.getMetaClass().getConstant(context, this.infinitySign < 0 ? "SIGN_NEGATIVE_INFINITE" : "SIGN_POSITIVE_INFINITE");
        }
        if (this.isZero(context)) {
            return this.getMetaClass().getConstant(context, this.zeroSign < 0 ? "SIGN_NEGATIVE_ZERO" : "SIGN_POSITIVE_ZERO");
        }
        return this.getMetaClass().getConstant(context, this.value.signum() < 0 ? "SIGN_NEGATIVE_FINITE" : "SIGN_POSITIVE_FINITE");
    }

    private RubyFixnum signValue(ThreadContext context) {
        if (this.isNaN()) {
            return RubyFixnum.zero(context.runtime);
        }
        if (this.isInfinity()) {
            return Convert.asFixnum(context, this.infinitySign);
        }
        if (this.isZero(context)) {
            return Convert.asFixnum(context, this.zeroSign);
        }
        return Convert.asFixnum(context, this.value.signum());
    }

    @JRubyMethod
    public RubyArray split(ThreadContext context) {
        return RubyArray.newArray(context.runtime, this.signValue(context), Create.newString(context, this.splitDigits(context)), Convert.asFixnum(context, 10), this.exponent());
    }

    private String splitDigits(ThreadContext context) {
        if (this.isNaN()) {
            return "NaN";
        }
        if (this.isInfinity()) {
            return "Infinity";
        }
        if (this.isZero(context)) {
            return "0";
        }
        return this.getSignificantDigits();
    }

    private String getSignificantDigits() {
        return this.absStripTrailingZeros().unscaledValue().toString();
    }

    private String getAllDigits() {
        return this.value.unscaledValue().abs().toString();
    }

    private int getExponent(ThreadContext context) {
        if (this.isZero(context) || this.isNaN() || this.isInfinity()) {
            return 0;
        }
        BigDecimal val = this.absStripTrailingZeros();
        return val.precision() - val.scale();
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject sqrt(IRubyObject arg2) {
        return this.sqrt(this.getCurrentContext(), arg2);
    }

    @JRubyMethod
    public IRubyObject sqrt(ThreadContext context, IRubyObject arg2) {
        if (this.isNaN()) {
            throw context.runtime.newFloatDomainError("sqrt of 'NaN'(Not a Number)");
        }
        if (this.isInfinity() && this.infinitySign < 0 || this.value.signum() < 0) {
            throw context.runtime.newFloatDomainError("sqrt of negative value");
        }
        if (this.isInfinity() && this.infinitySign > 0) {
            return RubyBigDecimal.getInfinity(context, 1);
        }
        int n = Convert.toInt(context, this.precision(context)) * (RubyBigDecimal.getPrecisionInt(context, arg2) + 1);
        return new RubyBigDecimal(context.runtime, RubyBigDecimal.bigSqrt(this.value, new MathContext(n, RoundingMode.HALF_UP))).setResult(context);
    }

    private static int getPrecisionInt(ThreadContext context, IRubyObject v) {
        int n = Convert.toInt(context, v);
        if (n < 0) {
            throw Error.argumentError(context, "negative precision");
        }
        return n;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject to_f() {
        return this.toFloat(this.getCurrentContext(), true);
    }

    @JRubyMethod
    public IRubyObject to_f(ThreadContext context) {
        return this.toFloat(context, true);
    }

    private RubyFloat toFloat(ThreadContext context, boolean checkFlow) {
        if (this.isNaN()) {
            return Convert.asFloat(context, Double.NaN);
        }
        if (this.isInfinity()) {
            return Convert.asFloat(context, this.infinitySign < 0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
        }
        if (this.isZero(context)) {
            return Convert.asFloat(context, this.zeroSign < 0 ? -0.0 : 0.0);
        }
        int exponent2 = this.getExponent(context);
        if (exponent2 > 324) {
            if (checkFlow && RubyBigDecimal.isOverflowExceptionMode(context)) {
                throw context.runtime.newFloatDomainError("BigDecimal to Float conversion");
            }
            return Convert.asFloat(context, this.value.signum() > 0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY);
        }
        if (exponent2 < -323) {
            if (checkFlow && RubyBigDecimal.isUnderflowExceptionMode(context)) {
                throw context.runtime.newFloatDomainError("BigDecimal to Float conversion");
            }
            return Convert.asFloat(context, 0L);
        }
        return Convert.asFloat(context, this.value.doubleValue());
    }

    @Override
    public RubyFloat convertToFloat() {
        return this.toFloat(this.getRuntime().getCurrentContext(), false);
    }

    @Deprecated(since="10.0.0.0")
    public final IRubyObject to_int() {
        return this.to_int(this.getCurrentContext());
    }

    @Override
    @JRubyMethod(name={"to_i", "to_int"})
    public IRubyObject to_int(ThreadContext context) {
        this.checkFloatDomain();
        try {
            return Convert.asFixnum(context, this.value.longValueExact());
        }
        catch (ArithmeticException ex) {
            return RubyBignum.bignorm(context.runtime, this.value.toBigInteger());
        }
    }

    @Deprecated(since="10.0.0.0")
    final RubyInteger to_int(Ruby runtime2) {
        return (RubyInteger)this.to_int(this.getCurrentContext());
    }

    @Override
    @Deprecated(since="10.0.0.0")
    public RubyInteger convertToInteger() {
        return (RubyInteger)this.to_int(this.getCurrentContext());
    }

    @JRubyMethod(name={"to_r"})
    public IRubyObject to_r(ThreadContext context) {
        this.checkFloatDomain();
        int scale2 = Math.abs(this.value.scale());
        BigInteger numerator2 = this.value.scaleByPowerOfTen(scale2).toBigInteger();
        BigInteger denominator2 = BigInteger.TEN.pow(scale2);
        return RubyRational.newInstance(context, RubyBignum.newBignum(context.runtime, numerator2), RubyBignum.newBignum(context.runtime, denominator2));
    }

    private static String removeTrailingZeroes(String str) {
        int l;
        for (l = str.length(); l > 0 && str.charAt(l - 1) == '0'; --l) {
        }
        return str.substring(0, l);
    }

    public static boolean formatHasLeadingPlus(String format) {
        return !format.isEmpty() && format.charAt(0) == '+';
    }

    public static boolean formatHasLeadingSpace(String format) {
        return !format.isEmpty() && format.charAt(0) == ' ';
    }

    public static boolean formatHasFloatingPointNotation(String format) {
        return !format.isEmpty() && (format.charAt(format.length() - 1) == 'F' || format.charAt(format.length() - 1) == 'f');
    }

    public static int formatFractionalDigitGroups(String format) {
        Matcher match2 = FRACTIONAL_DIGIT_GROUPS.matcher(format);
        return match2.matches() ? Integer.parseInt(match2.group(2)) : 0;
    }

    private static boolean posSpace(String arg2) {
        return arg2 != null && RubyBigDecimal.formatHasLeadingSpace(arg2);
    }

    private static boolean posSign(String arg2) {
        return arg2 != null && (RubyBigDecimal.formatHasLeadingPlus(arg2) || RubyBigDecimal.posSpace(arg2));
    }

    private static int groups(String arg2) {
        return arg2 == null ? 0 : RubyBigDecimal.formatFractionalDigitGroups(arg2);
    }

    @Override
    public final boolean isZero(ThreadContext context) {
        return !this.isNaN() && !this.isInfinity() && this.value.signum() == 0;
    }

    private boolean isNaN() {
        return this.isNaN;
    }

    private boolean isInfinity() {
        return this.infinitySign != 0;
    }

    private String unscaledValue() {
        return this.value.abs().unscaledValue().toString();
    }

    private static StringBuilder appendSign(StringBuilder buff, String str, int signum) {
        if (signum == -1) {
            buff.append('-');
        } else if (signum == 1 && RubyBigDecimal.posSign(str)) {
            buff.append(RubyBigDecimal.posSpace(str) ? (char)' ' : '+');
        }
        return buff;
    }

    private CharSequence engineeringValue(ThreadContext context, String arg2) {
        String s2 = RubyBigDecimal.removeTrailingZeroes(this.unscaledValue());
        StringBuilder build = new StringBuilder();
        RubyBigDecimal.appendSign(build, arg2, this.value.signum()).append('0').append('.');
        int groups2 = RubyBigDecimal.groups(arg2);
        if (groups2 == 0) {
            build.append(s2.isEmpty() ? "0" : s2);
        } else {
            int len = s2.length();
            String sep = "";
            for (int index2 = 0; index2 < len; index2 += groups2) {
                int next2 = index2 + groups2;
                build.append(sep).append(s2.substring(index2, next2 > len ? len : next2));
                sep = " ";
            }
        }
        build.append('e').append(this.getExponent(context));
        return build;
    }

    private CharSequence floatingPointValue(String arg2) {
        List<String> values2 = StringSupport.split(this.absStripTrailingZeros().toPlainString(), '.');
        String whole = !values2.isEmpty() ? values2.get(0) : "0";
        String after = values2.size() > 1 ? values2.get(1) : "0";
        StringBuilder build = new StringBuilder();
        RubyBigDecimal.appendSign(build, arg2, this.value.signum());
        int groups2 = RubyBigDecimal.groups(arg2);
        if (groups2 == 0) {
            build.append(whole);
            if (after != null) {
                build.append('.').append(after);
            }
        } else {
            int next2;
            int index2;
            int len = whole.length();
            String sep = "";
            for (index2 = 0; index2 < len; index2 += groups2) {
                next2 = index2 + groups2;
                if (next2 > len) {
                    next2 = len;
                }
                build.append(sep).append(whole.substring(index2, next2));
                sep = " ";
            }
            if (after != null) {
                build.append('.');
                len = after.length();
                sep = "";
                for (index2 = 0; index2 < len; index2 += groups2) {
                    next2 = index2 + groups2;
                    if (next2 > len) {
                        next2 = len;
                    }
                    build.append(sep).append(after.substring(index2, next2));
                    sep = " ";
                }
            }
        }
        return build;
    }

    @Override
    @JRubyMethod
    public RubyString to_s(ThreadContext context) {
        return this.toStringImpl(context, null);
    }

    @JRubyMethod
    public RubyString to_s(ThreadContext context, IRubyObject arg2) {
        return this.toStringImpl(context, arg2 == context.nil ? null : arg2.toString());
    }

    private RubyString toStringImpl(ThreadContext context, String arg2) {
        if (this.isNaN()) {
            return RubyString.newUSASCIIString(context.runtime, "NaN");
        }
        if (this.isInfinity()) {
            if (arg2 != null && this.infinitySign >= 0) {
                if (RubyBigDecimal.formatHasLeadingSpace(arg2)) {
                    return RubyString.newUSASCIIString(context.runtime, " Infinity");
                }
                if (RubyBigDecimal.formatHasLeadingPlus(arg2)) {
                    return RubyString.newUSASCIIString(context.runtime, "+Infinity");
                }
            }
            return RubyString.newUSASCIIString(context.runtime, RubyBigDecimal.infinityString(this.infinitySign));
        }
        if (this.isZero(context)) {
            if (this.zeroSign < 0) {
                return RubyString.newUSASCIIString(context.runtime, "-0.0");
            }
            if (arg2 != null && RubyBigDecimal.formatHasLeadingSpace(arg2)) {
                return RubyString.newUSASCIIString(context.runtime, " 0.0");
            }
            if (arg2 != null && RubyBigDecimal.formatHasLeadingPlus(arg2)) {
                return RubyString.newUSASCIIString(context.runtime, "+0.0");
            }
            return RubyString.newUSASCIIString(context.runtime, "0.0");
        }
        boolean asEngineering = arg2 == null || !RubyBigDecimal.formatHasFloatingPointNotation(arg2);
        return RubyString.newUSASCIIString(context.runtime, (asEngineering ? this.engineeringValue(context, arg2) : this.floatingPointValue(arg2)).toString());
    }

    @Override
    public String toString() {
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (this.isNaN()) {
            return "NaN";
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.infinityString(this.infinitySign);
        }
        if (this.isZero(context)) {
            return this.zeroSign < 0 ? "-0.0" : "0.0";
        }
        return this.engineeringValue(context, null).toString();
    }

    @Deprecated(since="9.2.0.0")
    public IRubyObject to_s(IRubyObject[] args2) {
        return this.toStringImpl(this.getCurrentContext(), args2.length == 0 ? null : (args2[0].isNil() ? null : args2[0].toString()));
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject fix() {
        return this.fix(this.getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject fix(ThreadContext context) {
        return this.truncateInternal(context, 0);
    }

    private RubyBigDecimal truncateInternal(ThreadContext context, int arg2) {
        if (this.isNaN()) {
            return RubyBigDecimal.getNaN(context);
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.getInfinity(context, this.infinitySign);
        }
        int precision2 = this.value.precision() - this.value.scale() + arg2;
        return precision2 > 0 ? new RubyBigDecimal(context.runtime, this.value.round(new MathContext(precision2, RoundingMode.DOWN))) : RubyBigDecimal.getZero(context, this.zeroSign);
    }

    @Override
    @JRubyMethod
    public IRubyObject truncate(ThreadContext context) {
        return this.truncateInternal(context, 0).to_int(context);
    }

    @JRubyMethod
    public IRubyObject truncate(ThreadContext context, IRubyObject arg2) {
        return this.truncateInternal(context, Convert.toInt(context, arg2));
    }

    @Override
    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p(ThreadContext context) {
        return Convert.asBoolean(context, this.isZero(context));
    }

    @Deprecated(since="9.2.0.0")
    public IRubyObject zero_p() {
        return this.zero_p(this.getCurrentContext());
    }

    @Override
    public <T> T toJava(Class<T> target2) {
        if (target2 == BigDecimal.class || target2 == Number.class) {
            return (T)this.value;
        }
        return super.toJava(target2);
    }

    public static BigDecimal bigSqrt(BigDecimal squarD, MathContext rootMC) {
        int biLen;
        int sign2 = squarD.signum();
        if (sign2 == -1) {
            throw new ArithmeticException("Square root of a negative number: " + String.valueOf(squarD));
        }
        if (sign2 == 0) {
            return squarD.round(rootMC);
        }
        int prec = rootMC.getPrecision();
        if (prec == 0) {
            throw new IllegalArgumentException("Most roots won't have infinite precision = 0");
        }
        int BITS = 62;
        int nInit = 16;
        MathContext nMC = new MathContext(18, RoundingMode.HALF_DOWN);
        BigInteger bi = squarD.unscaledValue();
        int shift2 = Math.max(0, biLen - BITS + ((biLen = bi.bitLength()) % 2 == 0 ? 0 : 1));
        bi = bi.shiftRight(shift2);
        double root = Math.sqrt(bi.doubleValue());
        BigDecimal halfBack = new BigDecimal(BigInteger.ONE.shiftLeft(shift2 / 2));
        int scale2 = squarD.scale();
        if (scale2 % 2 == 1) {
            root *= 3.1622776601683795;
        }
        scale2 = (int)Math.ceil((double)scale2 / 2.0);
        BigDecimal x = new BigDecimal(root, nMC);
        x = x.multiply(halfBack, nMC);
        if (scale2 != 0) {
            x = x.movePointLeft(scale2);
        }
        if (prec < nInit) {
            return x.round(rootMC);
        }
        BigDecimal TWO = BigDecimal.valueOf(2L);
        BigDecimal v = BigDecimal.ONE.divide(TWO.multiply(x), nMC);
        ArrayList<Integer> nPrecs = new ArrayList<Integer>();
        assert (nInit > 3) : "Never ending loop!";
        int m = prec + 1;
        while (m > nInit) {
            nPrecs.add(m);
            m = m / 2 + (m > 100 ? 1 : 2);
        }
        for (int i2 = nPrecs.size() - 1; i2 > -1; --i2) {
            nMC = new MathContext((Integer)nPrecs.get(i2), i2 % 2 == 1 ? RoundingMode.HALF_UP : RoundingMode.HALF_DOWN);
            BigDecimal e = squarD.subtract(x.multiply(x, nMC), nMC);
            if (i2 == 0) {
                x = x.add(e.multiply(v, rootMC), rootMC);
                break;
            }
            x = x.add(e.multiply(v, nMC));
            BigDecimal g = BigDecimal.ONE.subtract(TWO.multiply(x).multiply(v, nMC));
            v = v.add(g.multiply(v, nMC));
        }
        return x;
    }

    private void checkFloatDomain() {
        if (this.isNaN()) {
            throw this.getRuntime().newFloatDomainError("NaN");
        }
        if (this.isInfinity()) {
            throw this.getRuntime().newFloatDomainError(RubyBigDecimal.infinityString(this.infinitySign));
        }
    }

    static String infinityString(int infinitySign) {
        return infinitySign == -1 ? "-Infinity" : "Infinity";
    }

    private static boolean isEven(ThreadContext context, RubyNumeric x) {
        if (x instanceof RubyFixnum) {
            RubyFixnum fix2 = (RubyFixnum)x;
            return (fix2.getValue() & 1L) == 0L;
        }
        if (x instanceof RubyBignum) {
            RubyBignum bignum = (RubyBignum)x;
            return !bignum.asBigInteger(context).testBit(0);
        }
        return false;
    }

    @Deprecated
    public RubyBigDecimal(Ruby runtime2, RubyBigDecimal rbd) {
        this(runtime2, Access.getClass(runtime2.getCurrentContext(), "BigDecimal"), rbd);
    }

    @Deprecated
    public RubyBigDecimal(Ruby runtime2, RubyClass klass, RubyBigDecimal rbd) {
        super(runtime2, klass);
        this.isNaN = rbd.isNaN;
        this.infinitySign = rbd.infinitySign;
        this.zeroSign = rbd.zeroSign;
        this.value = rbd.value;
        this.flags |= FROZEN_F;
    }

    private static JavaSites.BigDecimalSites sites(ThreadContext context) {
        return context.sites.BigDecimal;
    }

    public static class BigDecimalKernelMethods {
        @JRubyMethod(name={"BigDecimal"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject newBigDecimal(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
            return BigDecimalKernelMethods.newBigDecimal(context, recv2, arg2, Convert.asFixnum(context, Integer.MAX_VALUE));
        }

        @JRubyMethod(name={"BigDecimal"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject newBigDecimal(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
            RubyClass bigDecimal = Access.getClass(context, "BigDecimal");
            IRubyObject maybeOpts = ArgsUtil.getOptionsArg(context.runtime, arg1, false);
            if (maybeOpts.isNil()) {
                return RubyBigDecimal.newInstance(context, (IRubyObject)bigDecimal, arg0, arg1, true, true);
            }
            IRubyObject exObj = ArgsUtil.extractKeywordArg(context, "exception", maybeOpts);
            boolean exception2 = exObj.isNil() || exObj.isTrue();
            return RubyBigDecimal.newInstance(context, (IRubyObject)bigDecimal, arg0, Convert.asFixnum(context, Integer.MAX_VALUE), true, exception2);
        }

        @JRubyMethod(name={"BigDecimal"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject newBigDecimal(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject opts) {
            IRubyObject maybeOpts = ArgsUtil.getOptionsArg(context.runtime, opts, false);
            if (maybeOpts.isNil()) {
                throw Error.argumentError(context, 3, 1, 2);
            }
            IRubyObject exObj = ArgsUtil.extractKeywordArg(context, "exception", maybeOpts);
            boolean exception2 = exObj.isNil() || exObj.isTrue();
            return RubyBigDecimal.newInstance(context, (IRubyObject)Access.getClass(context, "BigDecimal"), arg0, arg1, true, exception2);
        }
    }

    private static enum InfinityErrorMsgType {
        To,
        In;

    }
}

