/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.jruby.RubyBasicObject;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalDumper;
import org.jruby.runtime.marshal.MarshalLoader;
import org.jruby.util.ByteList;
import org.jruby.util.IOInputStream;
import org.jruby.util.IOOutputStream;
import org.jruby.util.io.RubyInputStream;
import org.jruby.util.io.RubyOutputStream;
import org.jruby.util.io.TransparentByteArrayOutputStream;

@JRubyModule(name={"Marshal"})
public class RubyMarshal {
    public static RubyModule createMarshalModule(ThreadContext context) {
        return ((RubyModule)((RubyModule)Define.defineModule(context, "Marshal").defineMethods(context, RubyMarshal.class)).defineConstant(context, "MAJOR_VERSION", Convert.asFixnum(context, 4))).defineConstant(context, "MINOR_VERSION", Convert.asFixnum(context, 8));
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject dump(ThreadContext context, IRubyObject recv2, IRubyObject object) {
        return RubyMarshal.dumpCommon(context, object, null, -1);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject dump(ThreadContext context, IRubyObject recv2, IRubyObject object, IRubyObject ioOrLimit) {
        IRubyObject io2 = null;
        int depthLimit = -1;
        if (ioOrLimit instanceof RubyIO || RubyMarshal.sites((ThreadContext)context).respond_to_write.respondsTo(context, ioOrLimit, ioOrLimit)) {
            io2 = ioOrLimit;
        } else if (ioOrLimit instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)ioOrLimit;
            depthLimit = fixnum.asInt(context);
        } else {
            throw Error.typeError(context, "Instance of IO needed");
        }
        return RubyMarshal.dumpCommon(context, object, io2, depthLimit);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject dump(ThreadContext context, IRubyObject recv2, IRubyObject object, IRubyObject io2, IRubyObject limit2) {
        if (!(io2 instanceof RubyIO) && !RubyMarshal.sites((ThreadContext)context).respond_to_write.respondsTo(context, io2, io2)) {
            throw Error.typeError(context, "Instance of IO needed");
        }
        int depthLimit = Convert.toInt(context, limit2);
        return RubyMarshal.dumpCommon(context, object, io2, depthLimit);
    }

    private static IRubyObject dumpCommon(ThreadContext context, IRubyObject objectToDump, IRubyObject io2, int depthLimit) {
        OutputStream outputStream;
        TransparentByteArrayOutputStream stringOutput = null;
        if (io2 != null) {
            if (io2 instanceof RubyIO) {
                RubyIO rubyIO = (RubyIO)io2;
                outputStream = rubyIO.getOutStream();
            } else {
                outputStream = RubyMarshal.outputStream(context, io2);
            }
        } else {
            outputStream = stringOutput = new TransparentByteArrayOutputStream();
        }
        RubyMarshal.dumpToStream(context, objectToDump, outputStream, depthLimit);
        return io2 != null ? io2 : Create.newString(context, new ByteList(stringOutput.getRawBytes(), 0, stringOutput.size(), false));
    }

    @JRubyMethod(name={"load", "restore"}, required=1, optional=2, checkArity=false, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject load(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        InputStream rawInput;
        IRubyObject str;
        int argc = Arity.checkArgumentCount(context, args2, 1, 3);
        IRubyObject in = args2[0];
        boolean freeze2 = false;
        IRubyObject proc2 = null;
        if (argc > 1) {
            RubyHash kwargs = ArgsUtil.extractKeywords(args2[argc - 1]);
            if (kwargs != null) {
                IRubyObject freezeOpt = ArgsUtil.getFreezeOpt(context, kwargs);
                boolean bl = freeze2 = freezeOpt != null && freezeOpt.isTrue();
                if (argc > 2) {
                    proc2 = args2[1];
                }
            } else {
                proc2 = args2[1];
            }
        }
        if ((str = in.checkStringType()) instanceof RubyString) {
            RubyString string2 = (RubyString)str;
            if (string2.size() == 0) {
                throw Error.argumentError(context, "marshal data too short");
            }
            ByteList bytes2 = string2.getByteList();
            rawInput = new ByteArrayInputStream(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
        } else if (RubyMarshal.sites((ThreadContext)context).respond_to_getc.respondsTo(context, in, in) && RubyMarshal.sites((ThreadContext)context).respond_to_read.respondsTo(context, in, in)) {
            rawInput = RubyMarshal.inputStream(context, in);
        } else {
            throw Error.typeError(context, "instance of IO needed");
        }
        MarshalLoader loader = new MarshalLoader(context, freeze2, proc2);
        RubyInputStream rubyIn = new RubyInputStream(context.runtime, rawInput);
        loader.start(context, rubyIn);
        return loader.unmarshalObject(context, rubyIn);
    }

    private static InputStream inputStream(ThreadContext context, IRubyObject in) {
        RubyMarshal.setBinmodeIfPossible(context, in);
        return new IOInputStream(in, false);
    }

    private static OutputStream outputStream(ThreadContext context, IRubyObject out) {
        RubyMarshal.setBinmodeIfPossible(context, out);
        return new IOOutputStream(out, true, false);
    }

    private static void dumpToStream(ThreadContext context, IRubyObject object, OutputStream rawOutput, int depthLimit) {
        MarshalDumper output = new MarshalDumper(depthLimit);
        RubyOutputStream out = new RubyOutputStream(context.runtime, rawOutput);
        output.start(out);
        output.dumpObject(context, out, object);
    }

    private static void setBinmodeIfPossible(ThreadContext context, IRubyObject io2) {
        if (RubyMarshal.sites((ThreadContext)context).respond_to_binmode.respondsTo(context, io2, io2)) {
            RubyMarshal.sites((ThreadContext)context).binmode.call(context, io2, io2);
        }
    }

    public static IRubyObject undumpable(ThreadContext context, RubyObject self2) {
        throw Error.typeError(context, "can't dump ", self2, "");
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject dump(IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        return RubyMarshal.dump(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2, unusedBlock);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject dump(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        int argc = Arity.checkArgumentCount(context, args2, 1, 3);
        IRubyObject objectToDump = args2[0];
        int depthLimit = -1;
        return switch (argc) {
            case 1 -> RubyMarshal.dump(context, recv2, args2[0]);
            case 2 -> RubyMarshal.dump(context, recv2, args2[0], args2[1]);
            case 3 -> RubyMarshal.dump(context, recv2, args2[0], args2[1], args2[2]);
            default -> RubyMarshal.dumpCommon(context, objectToDump, null, depthLimit);
        };
    }

    private static JavaSites.MarshalSites sites(ThreadContext context) {
        return context.sites.Marshal;
    }
}

