/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Appendable;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.compiler.Constantizable;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.opto.OptoFactory;
import org.jruby.util.ByteList;

@JRubyClass(name={"TrueClass", "FalseClass"})
public class RubyBoolean
extends RubyObject
implements Constantizable,
Appendable {
    private final int hashCode;
    private final transient Object constant;
    private final RubyString toS;
    public static final ByteList FALSE_BYTES = new ByteList(new byte[]{102, 97, 108, 115, 101}, (Encoding)USASCIIEncoding.INSTANCE);
    public static final ByteList TRUE_BYTES = new ByteList(new byte[]{116, 114, 117, 101}, (Encoding)USASCIIEncoding.INSTANCE);

    RubyBoolean(Ruby runtime2, boolean value2) {
        super(runtime2, value2 ? runtime2.getTrueClass() : runtime2.getFalseClass(), false);
        if (!value2) {
            this.flags = FALSE_F;
        }
        this.hashCode = RubyInstanceConfig.CONSISTENT_HASHING_ENABLED ? (value2 ? 155 : -48) : System.identityHashCode(this);
        this.constant = OptoFactory.newConstantWrapper(IRubyObject.class, this);
        this.toS = RubyString.newString(runtime2, value2 ? TRUE_BYTES : FALSE_BYTES);
        this.toS.setFrozen(true);
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return (this.flags & FALSE_F) == 0 ? ClassIndex.TRUE : ClassIndex.FALSE;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public RubyClass singletonClass(ThreadContext context) {
        return this.metaClass;
    }

    @Override
    public Class<?> getJavaClass() {
        return Boolean.TYPE;
    }

    @Override
    public Object constant() {
        return this.constant;
    }

    public static void finishFalseClass(ThreadContext context, RubyClass False2) {
        ((RubyModule)((RubyModule)False2.reifiedClass(RubyBoolean.class)).classIndex(ClassIndex.FALSE)).defineMethods(context, False.class, RubyBoolean.class).tap(c -> c.getMetaClass().undefMethods(context, "new"));
    }

    public static void finishTrueClass(ThreadContext context, RubyClass True2) {
        ((RubyModule)((RubyModule)True2.reifiedClass(RubyBoolean.class)).classIndex(ClassIndex.TRUE)).defineMethods(context, True.class, RubyBoolean.class).tap(c -> c.getMetaClass().undefMethods(context, "new"));
    }

    @Deprecated(since="10.0.0.0")
    public static RubyBoolean newBoolean(Ruby runtime2, boolean value2) {
        return value2 ? runtime2.getTrue() : runtime2.getFalse();
    }

    @Deprecated(since="10.0.0.0")
    public static RubyBoolean newBoolean(ThreadContext context, boolean value2) {
        return value2 ? context.tru : context.fals;
    }

    @Override
    public void appendIntoString(RubyString target2) {
        target2.append(this.toS);
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        return Convert.asFixnum(context, this.hashCode());
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public RubyFixnum id() {
        if ((this.flags & FALSE_F) == 0) {
            return RubyFixnum.newFixnum(this.metaClass.runtime, 20);
        }
        return RubyFixnum.zero(this.metaClass.runtime);
    }

    @Deprecated(since="10.0.0.0", forRemoval=true)
    public void marshalTo(MarshalStream output) throws IOException {
        output.write(this.isTrue() ? 84 : 70);
    }

    @Override
    @Deprecated(since="9.4.0.0")
    public IRubyObject taint(ThreadContext context) {
        return this;
    }

    public static class False
    extends RubyBoolean {
        False(Ruby runtime2) {
            super(runtime2, false);
            this.flags = FALSE_F | FROZEN_F;
        }

        @JRubyMethod(name={"&"})
        public static IRubyObject false_and(IRubyObject fals, IRubyObject oth) {
            return fals;
        }

        @JRubyMethod(name={"|"})
        public static IRubyObject false_or(ThreadContext context, IRubyObject fals, IRubyObject oth) {
            return oth.isTrue() ? context.tru : fals;
        }

        @JRubyMethod(name={"^"})
        public static IRubyObject false_xor(ThreadContext context, IRubyObject fals, IRubyObject oth) {
            return oth.isTrue() ? context.tru : fals;
        }

        @Deprecated(since="10.0.0.0")
        public static RubyString false_to_s(ThreadContext context, IRubyObject fals) {
            return context.runtime.getFalseString();
        }

        @Override
        @Deprecated(since="10.0.0.0")
        public RubyString inspect() {
            return this.getRuntime().getFalseString();
        }

        @Override
        @JRubyMethod(name={"to_s"}, alias={"inspect"})
        public RubyString inspect(ThreadContext context) {
            return context.runtime.getFalseString();
        }

        @Override
        public <T> T toJava(Class<T> target2) {
            if (target2.isAssignableFrom(Boolean.class) || target2 == Boolean.TYPE) {
                return (T)Boolean.FALSE;
            }
            return super.toJava(target2);
        }
    }

    public static class True
    extends RubyBoolean {
        True(Ruby runtime2) {
            super(runtime2, true);
            this.flags |= FROZEN_F;
        }

        @JRubyMethod(name={"&"})
        public static IRubyObject true_and(ThreadContext context, IRubyObject tru, IRubyObject oth) {
            return oth.isTrue() ? tru : context.fals;
        }

        @JRubyMethod(name={"|"})
        public static IRubyObject true_or(IRubyObject tru, IRubyObject oth) {
            return tru;
        }

        @JRubyMethod(name={"^"})
        public static IRubyObject true_xor(ThreadContext context, IRubyObject tru, IRubyObject oth) {
            return oth.isTrue() ? context.fals : tru;
        }

        @Deprecated(since="10.0.0.0")
        public static RubyString true_to_s(ThreadContext context, IRubyObject tru) {
            return context.runtime.getTrueString();
        }

        @Override
        @Deprecated(since="10.0.0.0")
        public RubyString inspect() {
            return this.getRuntime().getTrueString();
        }

        @Override
        @JRubyMethod(name={"to_s"}, alias={"inspect"})
        public RubyString inspect(ThreadContext context) {
            return context.runtime.getTrueString();
        }

        @Override
        public <T> T toJava(Class<T> target2) {
            if (target2.isAssignableFrom(Boolean.class) || target2 == Boolean.TYPE) {
                return (T)Boolean.TRUE;
            }
            return super.toJava(target2);
        }
    }
}

