/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Objects;
import org.jruby.RubySymbol;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NoOperandResultBaseInstr;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.callsite.VariableCachingCallSite;

public class FrameNameCallInstr
extends NoOperandResultBaseInstr
implements FixedArityInstr {
    private final VariableCachingCallSite frameNameSite;
    private final boolean callee;

    public FrameNameCallInstr(Variable result2, String methodName) {
        super(Operation.FRAME_NAME_CALL, Objects.requireNonNull(result2, "FrameNameCallInstr result is null"));
        this.frameNameSite = new VariableCachingCallSite(Objects.requireNonNull(methodName, "FrameNameCallInstr methodName is null"));
        this.callee = methodName.equals("__callee__");
    }

    public String getMethodName() {
        return this.frameNameSite.getMethodName();
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new FrameNameCallInstr(ii.getRenamedVariable(this.result), this.frameNameSite.getMethodName());
    }

    public static FrameNameCallInstr decode(IRReaderDecoder d) {
        return new FrameNameCallInstr(d.decodeVariable(), d.decodeString());
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.frameNameSite.getMethodName());
    }

    public IRubyObject getFrameName(ThreadContext context, IRubyObject self2, String compositeName) {
        CacheEntry frameNameEntry = this.frameNameSite.retrieveCache(self2);
        if (!frameNameEntry.method.getRealMethod().isBuiltin()) {
            return this.frameNameSite.call(context, self2, self2);
        }
        return this.callee ? RubySymbol.newCalleeSymbolFromCompound(context.runtime, compositeName) : RubySymbol.newMethodSymbolFromCompound(context.runtime, compositeName);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.FrameNameCallInstr(this);
    }
}

