/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.exceptions.StopIteration;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Enumerator::Producer"})
public class RubyProducer
extends RubyObject {
    private IRubyObject init;
    private Block producerBlock;

    public static RubyClass createProducerClass(ThreadContext context, RubyClass Object2, RubyClass Enumerator, RubyModule Enumerable) {
        return (RubyClass)((RubyModule)((RubyModule)Enumerator.defineClassUnder(context, "Producer", Object2, RubyProducer::new)).include(context, Enumerable)).defineMethods(context, RubyProducer.class);
    }

    public RubyProducer(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    public RubyProducer(Ruby runtime2, RubyClass klass, IRubyObject init, Block block) {
        super(runtime2, klass);
        this.init = init;
        this.producerBlock = block;
    }

    public static RubyProducer newProducer(ThreadContext context, IRubyObject init, Block block) {
        return new RubyProducer(context.runtime, context.runtime.getProducer(), init, block);
    }

    public static IRubyObject size(ThreadContext context, RubyProducer self2, IRubyObject[] args2) {
        return Convert.asFloat(context, Double.POSITIVE_INFINITY);
    }

    @JRubyMethod(rest=true)
    public IRubyObject each(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject cur;
        if (this.init == null) {
            cur = context.nil;
        } else {
            cur = this.init;
            block.yield(context, cur);
        }
        try {
            while (true) {
                cur = this.producerBlock.call(context, cur);
                block.yield(context, cur);
            }
        }
        catch (StopIteration si) {
            return this;
        }
    }
}

