/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import com.headius.backport9.buffer.Buffers;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jnr.posix.util.Platform;
import org.jruby.Main;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.api.Access;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.api.Warn;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.ext.rbconfig.RbConfigLibrary;
import org.jruby.javasupport.Java;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.LoadService;
import org.jruby.util.ByteList;
import org.jruby.util.Dir;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.WindowsFFI;
import org.jruby.util.io.ChannelHelper;
import org.jruby.util.io.IOOptions;
import org.jruby.util.io.ModeFlags;

public class ShellLauncher {
    private static final boolean DEBUG = false;
    private static final String PATH_ENV = "PATH";
    private static final String[] DEFAULT_PATH = new String[]{"/usr/local/bin", "/usr/ucb", "/usr/bin", "/bin"};
    private static final String[] WINDOWS_EXE_SUFFIXES = new String[]{".exe", ".com", ".bat", ".cmd"};
    private static final String[] WINDOWS_INTERNAL_CMDS = new String[]{"assoc", "break", "call", "cd", "chcp", "chdir", "cls", "color", "copy", "ctty", "date", "del", "dir", "echo", "endlocal", "erase", "exit", "for", "ftype", "goto", "if", "lfnfor", "lh", "lock", "md", "mkdir", "move", "path", "pause", "popd", "prompt", "pushd", "rd", "rem", "ren", "rename", "rmdir", "set", "setlocal", "shift", "start", "time", "title", "truename", "type", "unlock", "ver", "verify", "vol"};
    private static final Pattern SHELL_METACHARACTER_PATTERN = Pattern.compile("[*?{}\\[\\]<>()~&|$;'`\\\\\"\\n]");
    private static final Pattern WIN_ENVVAR_PATTERN = Pattern.compile("%\\w+%");
    private static final Class UNIXProcess;
    private static final Field UNIXProcess_pid;
    private static final Class ProcessImpl;
    private static final Field ProcessImpl_handle;
    private static final Method ProcessImpl_pid;
    private static final PidGetter PID_GETTER;

    public static String[] getCurrentEnv(Ruby runtime2) {
        return ShellLauncher.getModifiedEnv(runtime2, (Collection)Collections.EMPTY_LIST, false);
    }

    private static String[] getCurrentEnv(Ruby runtime2, Map mergeEnv) {
        return ShellLauncher.getModifiedEnv(runtime2, (Collection)(mergeEnv == null ? Collections.EMPTY_LIST : mergeEnv.entrySet()), false);
    }

    @Deprecated(since="10.0.0.0")
    public static String[] getModifiedEnv(Ruby runtime2, Collection mergeEnv, boolean clearEnv) {
        return ShellLauncher.getModifiedEnv(runtime2.getCurrentContext(), mergeEnv, clearEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getModifiedEnv(ThreadContext context, Collection mergeEnv, boolean clearEnv) {
        boolean traceEnabled = context.isEventHooksEnabled();
        context.setEventHooksEnabled(false);
        try {
            RubyHash hash2;
            RubyHash rubyHash = hash2 = clearEnv ? Create.newHash(context) : (RubyHash)Access.objectClass(context).getConstant(context, "ENV").dup();
            if (mergeEnv != null) {
                if (mergeEnv instanceof Set) {
                    for (Object e : (Set)mergeEnv) {
                        key = e.getKey();
                        if (key == null) {
                            throw Error.typeError(context, context.nil, "Struct");
                        }
                        value = e.getValue();
                        if (value == null) {
                            hash2.remove(key.toString());
                            continue;
                        }
                        hash2.put(key.toString(), value.toString());
                    }
                } else if (mergeEnv instanceof RubyArray) {
                    for (int j = 0; j < mergeEnv.size(); ++j) {
                        Object e;
                        e = ((RubyArray)mergeEnv).eltOk(j).convertToArray();
                        if (((RubyArray)e).size() != 2) {
                            throw Error.argumentError(context, "env assignments must come in pairs");
                        }
                        key = ((RubyArray)e).eltOk(0L);
                        if (key == null || key.isNil()) {
                            throw Error.typeError(context, context.nil, "Struct");
                        }
                        value = ((RubyArray)e).eltOk(1L);
                        if (value == null || value.isNil()) {
                            hash2.remove(key.toString());
                            continue;
                        }
                        hash2.put(key.toString(), value.toString());
                    }
                }
            }
            String[] ret = new String[hash2.size()];
            int i2 = 0;
            for (Map.Entry e : hash2.entrySet()) {
                if (e.getKey() == null) {
                    throw Error.typeError(context, context.nil, "Struct");
                }
                if (e.getValue() == null) continue;
                ret[i2] = (String)e.getKey() + "=" + (String)e.getValue();
                ++i2;
            }
            String[] stringArray = ShellLauncher.arrayOfLength(ret, i2);
            return stringArray;
        }
        finally {
            context.setEventHooksEnabled(traceEnabled);
        }
    }

    private static String[] arrayOfLength(String[] ary, int len) {
        return len == ary.length ? ary : Arrays.copyOf(ary, len);
    }

    private static boolean filenameIsPathSearchable(String fname, boolean forExec) {
        if (fname.startsWith("/") || fname.startsWith("./") || fname.startsWith("../") || forExec && fname.indexOf(47) != -1) {
            return false;
        }
        return !Platform.IS_WINDOWS || !fname.startsWith("\\") && !fname.startsWith(".\\") && !fname.startsWith("..\\") && (fname.length() <= 2 || fname.charAt(1) != ':') && (!forExec || fname.indexOf(92) == -1);
    }

    private static File tryFile(Ruby runtime2, String fdir, String fname) {
        File pathFile = fdir == null ? new File(fname) : new File(fdir, fname);
        if (!pathFile.isAbsolute()) {
            pathFile = new File(runtime2.getCurrentDirectory(), pathFile.getPath());
        }
        ShellLauncher.log(runtime2, "Trying file " + String.valueOf(pathFile));
        if (pathFile.exists()) {
            return pathFile;
        }
        return null;
    }

    private static boolean withExeSuffix(String fname) {
        String lowerCaseFname = fname.toLowerCase();
        for (String suffix : WINDOWS_EXE_SUFFIXES) {
            if (!lowerCaseFname.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private static File isValidFile(Ruby runtime2, String fdir, String fname, boolean isExec) {
        File validFile = null;
        if (isExec && Platform.IS_WINDOWS) {
            if (ShellLauncher.withExeSuffix(fname)) {
                validFile = ShellLauncher.tryFile(runtime2, fdir, fname);
            } else {
                String suffix;
                String[] stringArray = WINDOWS_EXE_SUFFIXES;
                int n = stringArray.length;
                for (int j = 0; j < n && (validFile = ShellLauncher.tryFile(runtime2, fdir, fname + (suffix = stringArray[j]))) == null; ++j) {
                }
            }
        } else {
            validFile = ShellLauncher.tryFile(runtime2, fdir, fname);
            if (validFile != null) {
                if (validFile.isDirectory()) {
                    return null;
                }
                if (isExec && !runtime2.getPosix().stat(validFile.getAbsolutePath()).isExecutable()) {
                    throw runtime2.newErrnoEACCESError(validFile.getAbsolutePath());
                }
            }
        }
        return validFile;
    }

    private static File isValidFile(Ruby runtime2, String fname, boolean isExec) {
        String fdir = null;
        return ShellLauncher.isValidFile(runtime2, fdir, fname, isExec);
    }

    private static File findPathFile(Ruby runtime2, String fname, String[] path2, boolean isExec) {
        boolean doPathSearch;
        File pathFile = null;
        if (Platform.IS_WINDOWS && fname.startsWith("\"") && fname.endsWith("\"")) {
            fname = fname.substring(1, fname.length() - 1);
        }
        if (doPathSearch = ShellLauncher.filenameIsPathSearchable(fname, isExec)) {
            for (String fdir : path2) {
                try {
                    pathFile = ShellLauncher.isValidFile(runtime2, fdir, fname, isExec);
                    if (pathFile == null) continue;
                    break;
                }
                catch (SecurityException se) {
                    // empty catch block
                }
            }
        } else {
            pathFile = ShellLauncher.isValidFile(runtime2, fname, isExec);
        }
        return pathFile;
    }

    public static File findPathExecutable(Ruby runtime2, String fname) {
        ThreadContext context = runtime2.getCurrentContext();
        RubyHash env = (RubyHash)Access.objectClass(context).getConstant(context, "ENV");
        IRubyObject pathObject = env.op_aref(context, Create.newString(context, PATH_ENV));
        return ShellLauncher.findPathExecutable(context, fname, pathObject);
    }

    @Deprecated(since="10.0.0.0")
    public static File findPathExecutable(Ruby runtime2, String fname, IRubyObject pathObject) {
        return ShellLauncher.findPathExecutable(runtime2.getCurrentContext(), fname, pathObject);
    }

    public static File findPathExecutable(ThreadContext context, String fname, IRubyObject pathObject) {
        String[] pathNodes;
        if (pathObject == null || pathObject.isNil()) {
            RubyHash env = (RubyHash)Access.objectClass(context).getConstant(context, "ENV");
            pathObject = env.op_aref(context, Create.newString(context, PATH_ENV));
        }
        if (pathObject.isNil() || pathObject.convertToString().size() == 0) {
            pathNodes = DEFAULT_PATH;
        } else {
            String pathSeparator = System.getProperty("path.separator");
            Object path2 = pathObject.toString();
            if (Platform.IS_WINDOWS) {
                path2 = "." + pathSeparator + (String)path2;
            }
            pathNodes = ((String)path2).split(pathSeparator);
        }
        return ShellLauncher.findPathFile(context.runtime, fname, pathNodes, true);
    }

    public static int runAndWait(Ruby runtime2, IRubyObject[] rawArgs) {
        return ShellLauncher.runAndWait(runtime2, rawArgs, runtime2.getOutputStream());
    }

    public static long[] runAndWaitPid(Ruby runtime2, IRubyObject[] rawArgs) {
        return ShellLauncher.runAndWaitPid(runtime2, rawArgs, runtime2.getOutputStream(), true);
    }

    public static long runWithoutWait(Ruby runtime2, IRubyObject[] rawArgs) {
        return ShellLauncher.runWithoutWait(runtime2, rawArgs, runtime2.getOutputStream());
    }

    public static int runExternalAndWait(Ruby runtime2, IRubyObject[] rawArgs, Map mergeEnv) {
        PrintStream output = runtime2.getOutputStream();
        PrintStream error2 = runtime2.getErrorStream();
        InputStream input = runtime2.getInputStream();
        File pwd = new File(runtime2.getCurrentDirectory());
        LaunchConfig cfg = new LaunchConfig(runtime2, rawArgs, true);
        try {
            Process process;
            try {
                if (cfg.shouldRunInShell()) {
                    ShellLauncher.log(runtime2, "Launching with shell");
                    cfg.verifyExecutableForShell();
                } else {
                    ShellLauncher.log(runtime2, "Launching directly (no shell)");
                    cfg.verifyExecutableForDirect();
                }
                String[] execArgs = cfg.getExecArgs();
                if (ShellLauncher.changeDirInsideJar(runtime2, execArgs)) {
                    pwd = new File(System.getProperty("user.dir"));
                }
                process = ShellLauncher.buildProcess(runtime2, execArgs, ShellLauncher.getCurrentEnv(runtime2, mergeEnv), pwd);
            }
            catch (SecurityException se) {
                throw runtime2.newSecurityError(se.getLocalizedMessage());
            }
            ShellLauncher.handleStreams(runtime2, process, input, output, error2);
            return process.waitFor();
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
        catch (InterruptedException e) {
            throw runtime2.newThreadError("unexpected interrupt");
        }
    }

    public static long runExternalWithoutWait(Ruby runtime2, IRubyObject env, IRubyObject prog, IRubyObject options2, IRubyObject args2) {
        return ShellLauncher.runExternal(runtime2, env, prog, options2, args2, false);
    }

    public static long runExternal(Ruby runtime2, IRubyObject env, IRubyObject prog, IRubyObject options2, IRubyObject args2, boolean wait3) {
        if (env.isNil() || !(env instanceof Map)) {
            env = null;
        }
        IRubyObject[] rawArgs = args2.convertToArray().toJavaArray(runtime2.getCurrentContext());
        PrintStream output = runtime2.getOutputStream();
        PrintStream error2 = runtime2.getErrorStream();
        InputStream input = runtime2.getInputStream();
        File pwd = new File(runtime2.getCurrentDirectory());
        LaunchConfig cfg = new LaunchConfig(runtime2, rawArgs, true);
        try {
            Process process;
            try {
                if (cfg.shouldRunInShell()) {
                    ShellLauncher.log(runtime2, "Launching with shell");
                    cfg.verifyExecutableForShell();
                } else {
                    ShellLauncher.log(runtime2, "Launching directly (no shell)");
                    cfg.verifyExecutableForDirect();
                }
                String[] execArgs = cfg.getExecArgs();
                if (ShellLauncher.changeDirInsideJar(runtime2, execArgs)) {
                    pwd = new File(".");
                }
                process = ShellLauncher.buildProcess(runtime2, execArgs, ShellLauncher.getCurrentEnv(runtime2, (Map)((Object)env)), pwd);
            }
            catch (SecurityException se) {
                throw runtime2.newSecurityError(se.getLocalizedMessage());
            }
            if (wait3) {
                ShellLauncher.handleStreams(runtime2, process, input, output, error2);
                try {
                    return process.waitFor();
                }
                catch (InterruptedException e) {
                    throw runtime2.newThreadError("unexpected interrupt");
                }
            }
            ShellLauncher.handleStreamsNonblocking(runtime2, process, runtime2.getOutputStream(), error2);
            return ShellLauncher.getPidFromProcess(process);
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
    }

    private static boolean changeDirInsideJar(Ruby runtime2, String[] args2) {
        String arg2 = ShellLauncher.changeDirInsideJar(runtime2, args2[args2.length - 1]);
        if (arg2 != null) {
            args2[args2.length - 1] = arg2;
            return true;
        }
        return false;
    }

    public static String changeDirInsideJar(Ruby runtime2, String arg2) {
        if (runtime2.getCurrentDirectory().startsWith("uri:classloader:") && arg2.contains("org.jruby.Main")) {
            return StringSupport.replaceFirst(arg2, "org.jruby.Main", "org.jruby.Main -C " + runtime2.getCurrentDirectory()).toString();
        }
        return null;
    }

    public static Process buildProcess(Ruby runtime2, String[] args2, String[] env, File pwd) throws IOException {
        return runtime2.getPosix().newProcessMaker(args2).environment(env).directory(pwd).start();
    }

    public static long runExternalWithoutWait(Ruby runtime2, IRubyObject[] rawArgs) {
        return ShellLauncher.runWithoutWait(runtime2, rawArgs, runtime2.getOutputStream());
    }

    public static int execAndWait(Ruby runtime2, IRubyObject[] rawArgs) {
        return ShellLauncher.execAndWait(runtime2, rawArgs, Collections.EMPTY_MAP);
    }

    public static int execAndWait(Ruby runtime2, IRubyObject[] rawArgs, Map mergeEnv) {
        File pwd = new File(runtime2.getCurrentDirectory());
        LaunchConfig cfg = new LaunchConfig(runtime2, rawArgs, true);
        if (cfg.shouldRunInProcess()) {
            ShellLauncher.log(runtime2, "ExecAndWait in-process");
            try {
                ScriptThreadProcess ipScript = new ScriptThreadProcess(runtime2, cfg.getExecArgs(), ShellLauncher.getCurrentEnv(runtime2, mergeEnv), pwd, false);
                ipScript.start();
                return ipScript.waitFor();
            }
            catch (IOException e) {
                throw runtime2.newIOErrorFromException(e);
            }
            catch (InterruptedException e) {
                throw runtime2.newThreadError("unexpected interrupt");
            }
        }
        return ShellLauncher.runExternalAndWait(runtime2, rawArgs, mergeEnv);
    }

    public static int runAndWait(Ruby runtime2, IRubyObject[] rawArgs, OutputStream output) {
        return ShellLauncher.runAndWait(runtime2, rawArgs, output, true);
    }

    public static int runAndWait(Ruby runtime2, IRubyObject[] rawArgs, OutputStream output, boolean doExecutableSearch) {
        return (int)ShellLauncher.runAndWaitPid(runtime2, rawArgs, output, doExecutableSearch)[0];
    }

    public static long[] runAndWaitPid(Ruby runtime2, IRubyObject[] rawArgs, OutputStream output, boolean doExecutableSearch) {
        PrintStream error2 = runtime2.getErrorStream();
        InputStream input = runtime2.getInputStream();
        try {
            Process aProcess = ShellLauncher.run(runtime2, rawArgs, doExecutableSearch);
            ShellLauncher.handleStreams(runtime2, aProcess, input, output, error2);
            return new long[]{aProcess.waitFor(), ShellLauncher.getPidFromProcess(aProcess)};
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
        catch (InterruptedException e) {
            throw runtime2.newThreadError("unexpected interrupt");
        }
    }

    private static long runWithoutWait(Ruby runtime2, IRubyObject[] rawArgs, OutputStream output) {
        PrintStream error2 = runtime2.getErrorStream();
        try {
            Process aProcess = ShellLauncher.run(runtime2, rawArgs, true);
            ShellLauncher.handleStreamsNonblocking(runtime2, aProcess, output, error2);
            return ShellLauncher.getPidFromProcess(aProcess);
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
    }

    public static long getPidFromProcess(Process process) {
        if (process instanceof ScriptThreadProcess) {
            return process.hashCode();
        }
        if (process instanceof POpenProcess) {
            return ShellLauncher.reflectPidFromProcess(((POpenProcess)process).getChild());
        }
        return ShellLauncher.reflectPidFromProcess(process);
    }

    public static long reflectPidFromProcess(Process process) {
        return PID_GETTER.getPid(process);
    }

    private static long getPidBoth(Process process) {
        try {
            if (UNIXProcess.isInstance(process)) {
                return ShellLauncher.getPidUnix(process);
            }
            if (ProcessImpl.isInstance(process)) {
                return ShellLauncher.getPidWindows(process);
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return process.hashCode();
    }

    private static long getPidWindows(Process process) {
        long pid2 = -1L;
        if (ProcessImpl_handle != null) {
            try {
                if (ProcessImpl.isInstance(process)) {
                    Long hproc = (Long)ProcessImpl_handle.get(process);
                    return WindowsFFI.getKernel32().GetProcessId(hproc);
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        if (pid2 == -1L && ProcessImpl_pid != null) {
            try {
                return (Long)ProcessImpl_pid.invoke((Object)process, new Object[0]);
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        return process.hashCode();
    }

    private static long getPidUnix(Process process) {
        try {
            if (UNIXProcess.isInstance(process)) {
                return ((Integer)UNIXProcess_pid.get(process)).intValue();
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return process.hashCode();
    }

    public static Process run(Ruby runtime2, IRubyObject string2) throws IOException {
        return ShellLauncher.run(runtime2, new IRubyObject[]{string2}, false);
    }

    public static POpenProcess popen(Ruby runtime2, IRubyObject string2, ModeFlags modes) throws IOException {
        return new POpenProcess(ShellLauncher.popenShared(runtime2, new IRubyObject[]{string2}, null, true), runtime2, modes);
    }

    public static POpenProcess popen(Ruby runtime2, IRubyObject[] strings, Map env, ModeFlags modes) throws IOException {
        return new POpenProcess(ShellLauncher.popenShared(runtime2, strings, env), runtime2, modes);
    }

    public static POpenProcess popen(Ruby runtime2, IRubyObject string2, Map env, ModeFlags modes) throws IOException {
        return new POpenProcess(ShellLauncher.popenShared(runtime2, new IRubyObject[]{string2}, env, true), runtime2, modes);
    }

    @Deprecated(since="1.7.4")
    public static POpenProcess popen(Ruby runtime2, IRubyObject string2, IOOptions modes) throws IOException {
        return new POpenProcess(ShellLauncher.popenShared(runtime2, new IRubyObject[]{string2}, null, true), runtime2, modes);
    }

    @Deprecated(since="1.7.4")
    public static POpenProcess popen(Ruby runtime2, IRubyObject[] strings, Map env, IOOptions modes) throws IOException {
        return new POpenProcess(ShellLauncher.popenShared(runtime2, strings, env), runtime2, modes);
    }

    @Deprecated(since="9.0.0.0")
    public static POpenProcess popen3(Ruby runtime2, IRubyObject[] strings) throws IOException {
        return new POpenProcess(ShellLauncher.popenShared(runtime2, strings));
    }

    @Deprecated(since="9.0.0.0")
    public static POpenProcess popen3(Ruby runtime2, IRubyObject[] strings, boolean addShell) throws IOException {
        return new POpenProcess(ShellLauncher.popenShared(runtime2, strings, null, addShell));
    }

    private static Process popenShared(Ruby runtime2, IRubyObject[] strings) throws IOException {
        return ShellLauncher.popenShared(runtime2, strings, null);
    }

    private static Process popenShared(Ruby runtime2, IRubyObject[] strings, Map env) throws IOException {
        return ShellLauncher.popenShared(runtime2, strings, env, false);
    }

    private static Process popenShared(Ruby runtime2, IRubyObject[] strings, Map env, boolean addShell) throws IOException {
        ThreadContext context = runtime2.getCurrentContext();
        String shell = ShellLauncher.getShell(runtime2);
        File pwd = new File(runtime2.getCurrentDirectory());
        try {
            boolean useShell;
            IRubyObject envHash;
            if (env == null && strings.length > 0 && !(envHash = TypeConverter.checkHashType(runtime2, strings[0])).isNil()) {
                strings = Arrays.copyOfRange(strings, 1, strings.length);
                env = (Map)((Object)envHash);
            }
            if (strings.length > 1 && !(envHash = TypeConverter.checkHashType(runtime2, strings[strings.length - 1])).isNil()) {
                if (!((RubyHash)envHash).isEmpty()) {
                    Warn.warn(context, "popen3 does not support spawn options in JRuby 1.7");
                }
                strings = Arrays.copyOfRange(strings, 0, strings.length - 1);
            }
            String[] args2 = ShellLauncher.parseCommandLine(context, runtime2, strings);
            LaunchConfig cfg = new LaunchConfig(runtime2, strings, true);
            boolean bl = useShell = Platform.IS_WINDOWS ? cfg.shouldRunInShell() : false;
            if (addShell) {
                for (String arg2 : args2) {
                    useShell |= ShellLauncher.shouldUseShell(arg2);
                }
            }
            if (useShell) {
                cfg.verifyExecutableForShell();
            } else {
                cfg.verifyExecutableForDirect();
            }
            return ShellLauncher.buildProcess(runtime2, cfg.execArgs, ShellLauncher.getCurrentEnv(runtime2, env), pwd);
        }
        catch (SecurityException se) {
            throw runtime2.newSecurityError(se.getLocalizedMessage());
        }
    }

    public static Process run(Ruby runtime2, IRubyObject[] rawArgs, boolean doExecutableSearch) throws IOException {
        RubyHash env = null;
        RubyHash opts = null;
        String dir = runtime2.getCurrentDirectory();
        if (rawArgs.length > 0 && rawArgs[0] instanceof RubyHash) {
            env = (RubyHash)rawArgs[0];
            rawArgs = Arrays.copyOfRange(rawArgs, 1, rawArgs.length);
        }
        if (rawArgs.length > 0 && rawArgs[rawArgs.length - 1] instanceof RubyHash) {
            opts = (RubyHash)rawArgs[rawArgs.length - 1];
            rawArgs = Arrays.copyOfRange(rawArgs, 0, rawArgs.length - 1);
            IRubyObject chdir2 = ArgsUtil.extractKeywordArg(runtime2.getCurrentContext(), "chdir", opts);
            if (!chdir2.isNil()) {
                dir = chdir2.asJavaString();
            }
        }
        return ShellLauncher.run(runtime2, env, dir, rawArgs, doExecutableSearch, false);
    }

    private static boolean hasGlobCharacter(String word) {
        return word.contains("*") || word.contains("?") || word.contains("[") || word.contains("{");
    }

    private static String[] expandGlobs(Ruby runtime2, String[] originalArgs) {
        ArrayList<String> expandedList = new ArrayList<String>(originalArgs.length);
        for (int i2 = 0; i2 < originalArgs.length; ++i2) {
            if (ShellLauncher.hasGlobCharacter(originalArgs[i2])) {
                List<ByteList> globs = Dir.push_glob(runtime2, runtime2.getCurrentDirectory(), new ByteList(originalArgs[i2].getBytes()), 0, true);
                for (ByteList glob2 : globs) {
                    expandedList.add(glob2.toString());
                }
                continue;
            }
            expandedList.add(originalArgs[i2]);
        }
        String[] args2 = new String[expandedList.size()];
        expandedList.toArray(args2);
        return args2;
    }

    public static Process run(Ruby runtime2, IRubyObject[] rawArgs, boolean doExecutableSearch, boolean forceExternalProcess) throws IOException {
        return ShellLauncher.run(runtime2, Collections.EMPTY_MAP, runtime2.getCurrentDirectory(), rawArgs, doExecutableSearch, forceExternalProcess);
    }

    public static Process run(Ruby runtime2, Map env, String dir, IRubyObject[] rawArgs, boolean doExecutableSearch, boolean forceExternalProcess) throws IOException {
        Process aProcess;
        File pwd = new File(dir);
        LaunchConfig cfg = new LaunchConfig(runtime2, rawArgs, doExecutableSearch);
        try {
            if (!forceExternalProcess && cfg.shouldRunInProcess()) {
                ShellLauncher.log(runtime2, "Launching in-process");
                ScriptThreadProcess ipScript = new ScriptThreadProcess(runtime2, ShellLauncher.expandGlobs(runtime2, cfg.getExecArgs()), ShellLauncher.getCurrentEnv(runtime2, env), pwd);
                ipScript.start();
                return ipScript;
            }
            if (cfg.shouldRunInShell()) {
                ShellLauncher.log(runtime2, "Launching with shell");
                cfg.verifyExecutableForShell();
            } else {
                ShellLauncher.log(runtime2, "Launching directly (no shell)");
                cfg.verifyExecutableForDirect();
            }
            String[] args2 = cfg.getExecArgs();
            if (dir.startsWith("uri:classloader:")) {
                pwd = new File(System.getProperty("user.dir"));
                if (args2[args2.length - 1].contains("org.jruby.Main")) {
                    args2[args2.length - 1] = args2[args2.length - 1].replace("org.jruby.Main", "org.jruby.Main -C " + dir);
                }
            }
            aProcess = ShellLauncher.buildProcess(runtime2, args2, ShellLauncher.getCurrentEnv(runtime2, env), pwd);
        }
        catch (SecurityException se) {
            throw runtime2.newSecurityError(se.getLocalizedMessage());
        }
        return aProcess;
    }

    private static void handleStreams(Ruby runtime2, Process p2, InputStream in, OutputStream out, OutputStream err) throws IOException {
        InputStream pOut = p2.getInputStream();
        InputStream pErr = p2.getErrorStream();
        OutputStream pIn = p2.getOutputStream();
        StreamPumper t1 = new StreamPumper(runtime2, pOut, out, false, Pumper.Slave.IN, p2);
        StreamPumper t2 = new StreamPumper(runtime2, pErr, err, false, Pumper.Slave.IN, p2);
        StreamPumper t3 = new StreamPumper(runtime2, in, pIn, true, Pumper.Slave.OUT, p2);
        t1.start();
        t2.start();
        t3.start();
        try {
            t1.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            t2.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        t3.quit();
        try {
            err.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            pIn.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            pOut.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            pErr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            t1.quit();
            t2.quit();
            t3.quit();
            t1.interrupt();
            t2.interrupt();
            t3.interrupt();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            t1.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            t2.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            t3.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void handleStreamsNonblocking(Ruby runtime2, Process p2, OutputStream out, OutputStream err) throws IOException {
        InputStream pOut = p2.getInputStream();
        InputStream pErr = p2.getErrorStream();
        StreamPumper t1 = new StreamPumper(runtime2, pOut, out, false, Pumper.Slave.IN, p2);
        StreamPumper t2 = new StreamPumper(runtime2, pErr, err, false, Pumper.Slave.IN, p2);
        t1.start();
        t2.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] parseCommandLine(ThreadContext context, Ruby runtime2, IRubyObject[] rawArgs) {
        String[] args2;
        if (rawArgs.length == 1) {
            if (ShellLauncher.hasLeadingArgvArray(rawArgs)) {
                args2 = new String[]{ShellLauncher.getPathEntry((RubyArray)rawArgs[0])};
            } else {
                LoadService loadService;
                LoadService loadService2 = loadService = Access.loadService(context);
                synchronized (loadService2) {
                    loadService.require("jruby/path_helper");
                }
                RubyModule pathHelper = runtime2.getClassFromPath("JRuby::PathHelper");
                RubyArray parts = (RubyArray)Helpers.invoke(context, (IRubyObject)pathHelper, "smart_split_command", rawArgs);
                args2 = new String[parts.getLength()];
                for (int i2 = 0; i2 < parts.getLength(); ++i2) {
                    args2[i2] = parts.entry(i2).toString();
                }
            }
        } else {
            args2 = new String[rawArgs.length];
            int start2 = 0;
            if (ShellLauncher.hasLeadingArgvArray(rawArgs)) {
                start2 = 1;
                args2[0] = ShellLauncher.getPathEntry((RubyArray)rawArgs[0]);
            }
            for (int i3 = start2; i3 < rawArgs.length; ++i3) {
                args2[i3] = rawArgs[i3].toString();
            }
        }
        return args2;
    }

    private static boolean hasLeadingArgvArray(IRubyObject[] rawArgs) {
        return rawArgs.length >= 1 && rawArgs[0] instanceof RubyArray && ((RubyArray)rawArgs[0]).getLength() == 2;
    }

    private static String getPathEntry(RubyArray initArray) {
        return initArray.entry(0).toString();
    }

    private static String getShell(Ruby runtime2) {
        return ShellLauncher.findPathExecutable(runtime2, RbConfigLibrary.jrubyShell()).getAbsolutePath();
    }

    public static boolean shouldUseShell(String command) {
        boolean useShell = false;
        for (char c : command.toCharArray()) {
            if (c == ' ' || Character.isLetter(c) || "*?{}[]<>()~&|\\$;'`\"\n".indexOf(c) == -1) continue;
            useShell = true;
        }
        if (Platform.IS_WINDOWS && command.length() >= 1 && command.charAt(0) == '@') {
            useShell = true;
        }
        return useShell;
    }

    static void log(Ruby runtime2, String msg) {
        if (RubyInstanceConfig.DEBUG_LAUNCHING) {
            runtime2.getErr().println("ShellLauncher: " + msg);
        }
    }

    @Deprecated(since="9.1.3.0")
    public static OutputStream unwrapBufferedStream(OutputStream filteredStream) {
        return ChannelHelper.unwrapBufferedStream(filteredStream);
    }

    @Deprecated(since="9.1.3.0")
    public static InputStream unwrapBufferedStream(InputStream filteredStream) {
        return ChannelHelper.unwrapBufferedStream(filteredStream);
    }

    @Deprecated(since="9.1.3.0")
    public static OutputStream unwrapFilterOutputStream(OutputStream filteredStream) {
        return ChannelHelper.unwrapFilterOutputStream(filteredStream);
    }

    @Deprecated(since="9.1.3.0")
    public static InputStream unwrapFilterInputStream(InputStream filteredStream) {
        return ChannelHelper.unwrapFilterInputStream(filteredStream);
    }

    static {
        PidGetter pidGetter = null;
        try {
            Method pid2 = Process.class.getMethod("pid", new Class[0]);
            pidGetter = LambdaMetafactory.altMetafactory(MethodHandles.lookup(), "getPid", MethodType.methodType(PidGetter.class), MethodType.methodType(Long.TYPE, Process.class), MethodHandles.lookup().unreflect(pid2), MethodType.methodType(Long.TYPE, Process.class), 0).dynamicInvoker().invoke();
        }
        catch (Throwable pid2) {
            // empty catch block
        }
        Class<?> up = null;
        Field pid3 = null;
        Class<?> pi = null;
        Field handle = null;
        Method pi_pid = null;
        if (pidGetter == null) {
            try {
                up = Class.forName("java.lang.UNIXProcess");
            }
            catch (ClassNotFoundException e) {
                try {
                    up = Class.forName("java.lang.ProcessImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (up != null) {
                try {
                    pid3 = up.getDeclaredField("pid");
                    if (!Java.trySetAccessible(pid3)) {
                        pid3 = null;
                    }
                }
                catch (NoSuchFieldException | SecurityException exception2) {
                    // empty catch block
                }
            }
            try {
                pi = Class.forName("java.lang.ProcessImpl");
                handle = pi.getDeclaredField("handle");
                if (!Java.trySetAccessible(handle)) {
                    handle = null;
                }
            }
            catch (Exception exception3) {
                // empty catch block
            }
            if (pi != null) {
                try {
                    pi_pid = pi.getMethod("pid", new Class[0]);
                    if (!Java.trySetAccessible(pi_pid)) {
                        pi_pid = null;
                        if (handle == null) {
                            pi = null;
                        }
                    }
                }
                catch (Exception exception4) {
                    // empty catch block
                }
            }
            pidGetter = pid3 != null ? (handle != null ? ShellLauncher::getPidBoth : ShellLauncher::getPidUnix) : (handle != null || pi_pid != null ? ShellLauncher::getPidWindows : Object::hashCode);
        }
        UNIXProcess = up;
        UNIXProcess_pid = pid3;
        ProcessImpl = pi;
        ProcessImpl_handle = handle;
        ProcessImpl_pid = pi_pid;
        PID_GETTER = pidGetter;
    }

    public static class LaunchConfig {
        private final Ruby runtime;
        private final boolean doExecutableSearch;
        private final IRubyObject[] rawArgs;
        private final String shell;
        private final String[] args;
        private String[] execArgs;
        private boolean cmdBuiltin = false;
        private String executable;
        private File executableFile;

        public LaunchConfig(Ruby runtime2, IRubyObject[] rawArgs, boolean doExecutableSearch) {
            this.runtime = runtime2;
            this.rawArgs = rawArgs;
            this.doExecutableSearch = doExecutableSearch;
            this.shell = ShellLauncher.getShell(runtime2);
            this.args = ShellLauncher.parseCommandLine(runtime2.getCurrentContext(), runtime2, rawArgs);
        }

        public boolean shouldRunInProcess() {
            int startIndex;
            String[] slashDelimitedTokens;
            String finalToken;
            boolean inProc;
            if (!this.runtime.getInstanceConfig().isRunRubyInProcess() || RubyInstanceConfig.hasLoadedNativeExtensions()) {
                return false;
            }
            for (int i2 = 0; i2 < this.args.length; ++i2) {
                String c = this.args[i2];
                if (c.trim().length() == 0) continue;
                char[] firstLast = new char[]{c.charAt(0), c.charAt(c.length() - 1)};
                block5: for (int j = 0; j < firstLast.length; ++j) {
                    switch (firstLast[j]) {
                        case '\n': 
                        case '\"': 
                        case '$': 
                        case '&': 
                        case '\'': 
                        case '(': 
                        case ')': 
                        case ';': 
                        case '<': 
                        case '>': 
                        case '\\': 
                        case '`': 
                        case '|': 
                        case '~': {
                            return false;
                        }
                        case '2': {
                            if (c.length() <= 1 || c.charAt(1) != '>') continue block5;
                            return false;
                        }
                    }
                }
            }
            String command = this.args[0];
            if (Platform.IS_WINDOWS) {
                command = command.toLowerCase();
            }
            boolean bl = inProc = (finalToken = (slashDelimitedTokens = command.split("[/\\\\]"))[slashDelimitedTokens.length - 1]).endsWith("ruby") || Platform.IS_WINDOWS && finalToken.endsWith("ruby.exe") || finalToken.endsWith(".rb") || finalToken.endsWith("irb");
            if (!inProc) {
                return false;
            }
            int n = startIndex = command.endsWith(".rb") ? 0 : 1;
            if (command.trim().endsWith("irb")) {
                startIndex = 0;
                this.args[0] = this.runtime.getJRubyHome() + File.separator + "bin" + File.separator + "jirb";
            }
            this.execArgs = new String[this.args.length - startIndex];
            System.arraycopy(this.args, startIndex, this.execArgs, 0, this.execArgs.length);
            return true;
        }

        public boolean shouldRunInShell() {
            if (this.rawArgs.length != 1) {
                return false;
            }
            if (!Platform.IS_WINDOWS) {
                return true;
            }
            if (this.shell == null) {
                return false;
            }
            for (String arg2 : this.args) {
                if (LaunchConfig.shouldVerifyPathExecutable(arg2.trim())) continue;
                return true;
            }
            this.executable = this.args[0].trim();
            this.executableFile = ShellLauncher.findPathExecutable(this.runtime, this.executable);
            if (this.executableFile != null) {
                ShellLauncher.log(this.runtime, "Got it: " + String.valueOf(this.executableFile));
                if (this.isBatch(this.executableFile)) {
                    ShellLauncher.log(this.runtime, "This is a BAT/CMD file, will start in shell");
                    return true;
                }
                return false;
            }
            ShellLauncher.log(this.runtime, "Didn't find executable: " + this.executable);
            if (this.isCmdBuiltin(this.executable)) {
                this.cmdBuiltin = true;
                return true;
            }
            return false;
        }

        private boolean isBatch(File executableFile) {
            return executableFile.getName().toLowerCase().endsWith(".bat");
        }

        public void verifyExecutableForShell() {
            String cmdline = this.rawArgs[0].toString().trim();
            if (this.doExecutableSearch && this.args.length == this.rawArgs.length && LaunchConfig.shouldVerifyPathExecutable(cmdline) && !this.cmdBuiltin) {
                this.verifyExecutable();
                cmdline = this.executableFile.getAbsolutePath();
            }
            this.execArgs = new String[3];
            this.execArgs[0] = this.shell;
            this.execArgs[1] = this.shell.endsWith("sh") ? "-c" : "/c";
            this.execArgs[2] = cmdline;
        }

        public void verifyExecutableForDirect() {
            if (this.isCmdBuiltin(this.args[0].trim())) {
                this.execArgs = new String[this.args.length + 2];
                this.execArgs[0] = this.shell;
                this.execArgs[1] = "/c";
                this.execArgs[2] = this.args[0].trim();
                System.arraycopy(this.args, 1, this.execArgs, 3, this.args.length - 1);
            } else {
                this.verifyExecutable();
                this.execArgs = this.args;
                this.execArgs[0] = this.executableFile.getAbsolutePath();
            }
        }

        private void verifyExecutable() {
            if (this.executableFile == null) {
                if (this.executable == null) {
                    this.executable = this.args[0].trim();
                }
                this.executableFile = ShellLauncher.findPathExecutable(this.runtime, this.executable);
            }
            if (this.executableFile == null) {
                throw this.runtime.newErrnoENOENTError(this.executable);
            }
        }

        public String[] getExecArgs() {
            return this.execArgs;
        }

        private boolean isCmdBuiltin(String cmd) {
            int idx;
            if (!this.shell.endsWith("sh") && (idx = Arrays.binarySearch(WINDOWS_INTERNAL_CMDS, cmd.toLowerCase())) >= 0) {
                ShellLauncher.log(this.runtime, "Found Windows shell's built-in command: " + cmd);
                return true;
            }
            return false;
        }

        private static boolean hasRedirection(String cmdline) {
            if (Platform.IS_WINDOWS) {
                char quote2 = '\u0000';
                int idx = 0;
                block6: while (idx < cmdline.length()) {
                    char ptr = cmdline.charAt(idx);
                    switch (ptr) {
                        case '\"': 
                        case '\'': {
                            if (quote2 == '\u0000') {
                                quote2 = ptr;
                            } else if (quote2 == ptr) {
                                quote2 = '\u0000';
                            }
                            ++idx;
                            continue block6;
                        }
                        case '\n': 
                        case '<': 
                        case '>': 
                        case '|': {
                            if (quote2 == '\u0000') {
                                return true;
                            }
                            ++idx;
                            continue block6;
                        }
                        case '%': {
                            Matcher envVarMatcher = WIN_ENVVAR_PATTERN.matcher(cmdline.substring(idx));
                            if (envVarMatcher.find()) {
                                return true;
                            }
                            ++idx;
                            continue block6;
                        }
                        case '\\': {
                            ++idx;
                        }
                    }
                    ++idx;
                }
                return false;
            }
            Matcher metaMatcher = SHELL_METACHARACTER_PATTERN.matcher(cmdline);
            return metaMatcher.find();
        }

        private static boolean shouldVerifyPathExecutable(String cmdline) {
            boolean verifyPathExecutable = true;
            if (LaunchConfig.hasRedirection(cmdline)) {
                return false;
            }
            return verifyPathExecutable;
        }
    }

    private static class ScriptThreadProcess
    extends Process
    implements Runnable {
        private final String[] argArray;
        private final String[] env;
        private final File pwd;
        private final boolean pipedStreams;
        private final PipedInputStream processOutput;
        private final PipedInputStream processError;
        private final PipedOutputStream processInput;
        private RubyInstanceConfig config;
        private Thread processThread;
        private int result;
        private final Ruby parentRuntime;

        public ScriptThreadProcess(Ruby parentRuntime, String[] argArray, String[] env, File dir) {
            this(parentRuntime, argArray, env, dir, true);
        }

        public ScriptThreadProcess(Ruby parentRuntime, String[] argArray, String[] env, File dir, boolean pipedStreams) {
            this.parentRuntime = parentRuntime;
            this.argArray = argArray;
            this.env = env;
            this.pwd = dir;
            this.pipedStreams = pipedStreams;
            if (pipedStreams) {
                this.processOutput = new PipedInputStream();
                this.processError = new PipedInputStream();
                this.processInput = new PipedOutputStream();
            } else {
                this.processError = null;
                this.processOutput = null;
                this.processInput = null;
            }
        }

        @Override
        public void run() {
            try {
                this.result = new Main(this.config).run(this.argArray).getStatus();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(this.config.getError());
                this.result = -1;
            }
            finally {
                this.config.getOutput().close();
                this.config.getError().close();
                try {
                    this.config.getInput().close();
                }
                catch (IOException iOException) {}
            }
        }

        private static Map<String, String> environmentMap(String[] env) {
            HashMap<String, String> map2 = new HashMap<String, String>(env.length + 2, 1.0f);
            for (int i2 = 0; i2 < env.length; ++i2) {
                List<String> kv = StringSupport.split(env[i2], '=', 2);
                map2.put(kv.get(0), kv.get(1));
            }
            return map2;
        }

        public void start() throws IOException {
            this.config = new RubyInstanceConfig(this.parentRuntime.getInstanceConfig());
            this.config.setCurrentDirectory(this.pwd.toString());
            this.config.setEnvironment(ScriptThreadProcess.environmentMap(this.env));
            if (this.pipedStreams) {
                this.config.setInput(new PipedInputStream(this.processInput));
                this.config.setOutput(new PrintStream(new PipedOutputStream(this.processOutput)));
                this.config.setError(new PrintStream(new PipedOutputStream(this.processError)));
            }
            String procName = "piped";
            if (this.argArray.length > 0) {
                procName = this.argArray[0];
            }
            this.processThread = new Thread((Runnable)this, "ScriptThreadProcess: " + procName);
            this.processThread.setDaemon(true);
            this.processThread.start();
        }

        @Override
        public OutputStream getOutputStream() {
            return this.processInput;
        }

        @Override
        public InputStream getInputStream() {
            return this.processOutput;
        }

        @Override
        public InputStream getErrorStream() {
            return this.processError;
        }

        @Override
        public long pid() {
            return -1L;
        }

        @Override
        public int waitFor() throws InterruptedException {
            this.processThread.join();
            return this.result;
        }

        @Override
        public int exitValue() {
            return this.result;
        }

        @Override
        public void destroy() {
            if (this.pipedStreams) {
                this.closeStreams();
            }
            this.processThread.interrupt();
        }

        private void closeStreams() {
            try {
                this.processInput.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.processOutput.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.processError.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class POpenProcess
    extends Process {
        private final Process child;
        private final boolean waitForChild;
        private InputStream realInput;
        private OutputStream realOutput;
        private InputStream realInerr;
        private InputStream input;
        private OutputStream output;
        private InputStream inerr;
        private FileChannel inputChannel;
        private FileChannel outputChannel;
        private FileChannel inerrChannel;
        private Pumper inputPumper;
        private Pumper inerrPumper;

        @Deprecated(since="1.7.4")
        public POpenProcess(Process child, Ruby runtime2, IOOptions modes) {
            this(child, runtime2, modes.getModeFlags());
        }

        public POpenProcess(Process child, Ruby runtime2, ModeFlags modes) {
            this.child = child;
            if (modes.isWritable()) {
                this.waitForChild = true;
                this.prepareOutput(child);
            } else {
                this.waitForChild = false;
                try {
                    child.getOutputStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (modes.isReadable()) {
                this.prepareInput(child);
            } else {
                this.pumpInput(child, runtime2);
            }
            this.pumpInerr(child, runtime2);
        }

        public POpenProcess(Process child) {
            this.child = child;
            this.waitForChild = false;
            this.prepareOutput(child);
            this.prepareInput(child);
            this.prepareInerr(child);
        }

        @Override
        public OutputStream getOutputStream() {
            return this.output;
        }

        @Override
        public InputStream getInputStream() {
            return this.input;
        }

        @Override
        public InputStream getErrorStream() {
            return this.inerr;
        }

        public FileChannel getInput() {
            return this.inputChannel;
        }

        public FileChannel getOutput() {
            return this.outputChannel;
        }

        @Override
        public long pid() {
            return PID_GETTER.getPid(this.child);
        }

        public FileChannel getError() {
            return this.inerrChannel;
        }

        public boolean hasOutput() {
            return this.output != null || this.outputChannel != null;
        }

        public Process getChild() {
            return this.child;
        }

        @Override
        public int waitFor() throws InterruptedException {
            return this.child.waitFor();
        }

        @Override
        public int exitValue() {
            return this.child.exitValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroy() {
            try {
                try {
                    if (this.input != null) {
                        this.input.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    if (this.inerr != null) {
                        this.inerr.close();
                    }
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                try {
                    if (this.output != null) {
                        this.output.close();
                    }
                }
                catch (Exception exception4) {
                    // empty catch block
                }
                try {
                    if (this.inputChannel != null) {
                        this.inputChannel.close();
                    }
                }
                catch (Exception exception5) {
                    // empty catch block
                }
                try {
                    if (this.inerrChannel != null) {
                        this.inerrChannel.close();
                    }
                }
                catch (Exception exception6) {
                    // empty catch block
                }
                try {
                    if (this.outputChannel != null) {
                        this.outputChannel.close();
                    }
                }
                catch (Exception exception7) {
                    // empty catch block
                }
                POpenProcess pOpenProcess = this;
                synchronized (pOpenProcess) {
                    Pumper pumper;
                    if (this.inputPumper != null) {
                        pumper = this.inputPumper;
                        synchronized (pumper) {
                            this.inputPumper.quit();
                        }
                    }
                    if (this.inerrPumper != null) {
                        pumper = this.inerrPumper;
                        synchronized (pumper) {
                            this.inerrPumper.quit();
                        }
                    }
                    if (this.waitForChild) {
                        this.waitFor();
                    } else {
                        RubyIO.obliterateProcess(this.child);
                    }
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }

        private void prepareInput(Process child) {
            this.input = this.realInput = child.getInputStream();
            this.inputChannel = null;
            this.inputPumper = null;
        }

        private void prepareInerr(Process child) {
            this.inerr = this.realInerr = child.getErrorStream();
            this.inerrChannel = null;
            this.inerrPumper = null;
        }

        private void prepareOutput(Process child) {
            this.realOutput = child.getOutputStream();
            this.output = ChannelHelper.unwrapBufferedStream(this.realOutput);
            this.outputChannel = this.output instanceof FileOutputStream ? ((FileOutputStream)this.output).getChannel() : null;
        }

        private void pumpInput(Process child, Ruby runtime2) {
            InputStream childIn = ChannelHelper.unwrapBufferedStream(child.getInputStream());
            FileChannel childInChannel = null;
            if (childIn instanceof FileInputStream) {
                childInChannel = ((FileInputStream)childIn).getChannel();
            }
            OutputStream parentOut = ChannelHelper.unwrapBufferedStream(runtime2.getOut());
            FileChannel parentOutChannel = null;
            if (parentOut instanceof FileOutputStream) {
                parentOutChannel = ((FileOutputStream)parentOut).getChannel();
            }
            this.inputPumper = childInChannel != null && parentOutChannel != null ? new ChannelPumper(runtime2, childInChannel, parentOutChannel, Pumper.Slave.IN, this) : new StreamPumper(runtime2, childIn, parentOut, false, Pumper.Slave.IN, this);
            this.inputPumper.start();
            this.input = null;
            this.inputChannel = null;
        }

        private void pumpInerr(Process child, Ruby runtime2) {
            InputStream childIn = ChannelHelper.unwrapBufferedStream(child.getErrorStream());
            FileChannel childInChannel = null;
            if (childIn instanceof FileInputStream) {
                childInChannel = ((FileInputStream)childIn).getChannel();
            }
            OutputStream parentOut = ChannelHelper.unwrapBufferedStream(runtime2.getOut());
            FileChannel parentOutChannel = null;
            if (parentOut instanceof FileOutputStream) {
                parentOutChannel = ((FileOutputStream)parentOut).getChannel();
            }
            this.inerrPumper = childInChannel != null && parentOutChannel != null ? new ChannelPumper(runtime2, childInChannel, parentOutChannel, Pumper.Slave.IN, this) : new StreamPumper(runtime2, childIn, parentOut, false, Pumper.Slave.IN, this);
            this.inerrPumper.start();
            this.inerr = null;
            this.inerrChannel = null;
        }
    }

    private static interface PidGetter {
        public long getPid(Process var1);
    }

    private static class StreamPumper
    extends Thread
    implements Pumper {
        private final InputStream in;
        private final OutputStream out;
        private final boolean onlyIfAvailable;
        private final Object waitLock = new Object();
        private final Object sync;
        private final Pumper.Slave slave;
        private volatile boolean quit;
        private final Ruby runtime;

        StreamPumper(Ruby runtime2, InputStream in, OutputStream out, boolean avail, Pumper.Slave slave, Object sync2) {
            this.in = ChannelHelper.unwrapBufferedStream(in);
            this.out = ChannelHelper.unwrapBufferedStream(out);
            this.onlyIfAvailable = avail;
            this.slave = slave;
            this.sync = sync2;
            this.runtime = runtime2;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block30: {
                Object object;
                this.runtime.getCurrentContext().setEventHooksEnabled(false);
                byte[] buf = new byte[1024];
                boolean hasReadSomething = false;
                try {
                    while (!this.quit) {
                        int numRead;
                        if (this.onlyIfAvailable && !hasReadSomething) {
                            if (this.in.available() == 0) {
                                object = this.waitLock;
                                synchronized (object) {
                                    this.waitLock.wait(10L);
                                    continue;
                                }
                            }
                            hasReadSomething = true;
                        }
                        if ((numRead = this.in.read(buf)) == -1) {
                            break;
                        }
                        this.out.write(buf, 0, numRead);
                    }
                }
                catch (Exception exception2) {
                    if (!this.onlyIfAvailable) break block30;
                    Object object2 = this.sync;
                    synchronized (object2) {
                        if (this.slave == Pumper.Slave.OUT) {
                            try {
                                this.out.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
                finally {
                    if (this.onlyIfAvailable) {
                        object = this.sync;
                        synchronized (object) {
                            if (this.slave == Pumper.Slave.OUT) {
                                try {
                                    this.out.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void quit() {
            this.quit = true;
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.notify();
            }
            this.interrupt();
        }
    }

    private static interface Pumper
    extends Runnable {
        public void start();

        public void quit();

        public static enum Slave {
            IN,
            OUT;

        }
    }

    private static class ChannelPumper
    extends Thread
    implements Pumper {
        private final FileChannel inChannel;
        private final FileChannel outChannel;
        private final Pumper.Slave slave;
        private final Object sync;
        private volatile boolean quit;
        private final Ruby runtime;

        ChannelPumper(Ruby runtime2, FileChannel inChannel, FileChannel outChannel, Pumper.Slave slave, Object sync2) {
            this.inChannel = inChannel;
            this.outChannel = outChannel;
            this.slave = slave;
            this.sync = sync2;
            this.runtime = runtime2;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.runtime.getCurrentContext().setEventHooksEnabled(false);
            ByteBuffer buf = ByteBuffer.allocateDirect(1024);
            Buffers.clearBuffer(buf);
            try {
                while (!this.quit && this.inChannel.isOpen() && this.outChannel.isOpen()) {
                    int read2 = this.inChannel.read(buf);
                    if (read2 == -1) {
                        break;
                    }
                    Buffers.flipBuffer(buf);
                    this.outChannel.write(buf);
                    Buffers.clearBuffer(buf);
                }
            }
            catch (Exception exception2) {
                Object object = this.sync;
                synchronized (object) {
                    switch (this.slave.ordinal()) {
                        case 1: {
                            try {
                                this.outChannel.close();
                            }
                            catch (IOException iOException) {}
                            break;
                        }
                        case 0: {
                            try {
                                this.inChannel.close();
                                break;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            finally {
                Object object = this.sync;
                synchronized (object) {
                    switch (this.slave.ordinal()) {
                        case 1: {
                            try {
                                this.outChannel.close();
                            }
                            catch (IOException iOException) {}
                            break;
                        }
                        case 0: {
                            try {
                                this.inChannel.close();
                                break;
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
        }

        @Override
        public void quit() {
            this.quit = true;
            this.interrupt();
        }
    }
}

