/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.util.KCode;

public class ParserConfiguration {
    private int lineNumber = 0;
    private boolean inlineSource = false;
    private boolean isEvalParse = true;
    private boolean saveData = false;
    private Encoding defaultEncoding;
    private final Ruby runtime;

    public ParserConfiguration(Ruby runtime2, int lineNumber, boolean inlineSource, boolean isFileParse, boolean saveData) {
        this.runtime = runtime2;
        this.inlineSource = inlineSource;
        this.lineNumber = lineNumber;
        this.isEvalParse = !isFileParse;
        this.saveData = saveData;
    }

    @Deprecated(since="9.4.6.0")
    public ParserConfiguration(Ruby runtime2, int lineNumber, boolean inlineSource, boolean isFileParse, RubyInstanceConfig config) {
        this(runtime2, lineNumber, inlineSource, isFileParse, false, config);
    }

    public ParserConfiguration(Ruby runtime2, int lineNumber, boolean inlineSource, boolean isFileParse, boolean saveData, RubyInstanceConfig config) {
        this(runtime2, lineNumber, inlineSource, isFileParse, saveData);
    }

    public void setDefaultEncoding(Encoding encoding2) {
        this.defaultEncoding = encoding2;
    }

    public Encoding getDefaultEncoding() {
        if (this.defaultEncoding == null) {
            this.defaultEncoding = UTF8Encoding.INSTANCE;
        }
        return this.defaultEncoding;
    }

    public EncodingService getEncodingService() {
        return this.runtime.getEncodingService();
    }

    public boolean isDebug() {
        return this.runtime.getInstanceConfig().isDebug();
    }

    public boolean isEvalParse() {
        return this.isEvalParse;
    }

    public KCode getKCode() {
        return this.runtime.getKCode();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void parseAsBlock(DynamicScope existingScope) {
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public boolean isSaveData() {
        return this.saveData;
    }

    public boolean isInlineSource() {
        return this.inlineSource;
    }
}

