/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.zlib;

import com.jcraft.jzlib.Deflater;
import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.ext.zlib.RubyZlib;
import org.jruby.ext.zlib.ZStream;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"Zlib::Deflate"}, parent="Zlib::ZStream")
public class JZlibDeflate
extends ZStream {
    public static final int BASE_SIZE = 100;
    private int level;
    private int windowBits;
    private int strategy;
    private byte[] collected;
    private int collectedIdx;
    private Deflater flater = null;
    private int flush = 0;

    @Deprecated(since="10.0.0.0")
    public static IRubyObject s_deflate(IRubyObject recv2, IRubyObject[] args2) {
        return JZlibDeflate.s_deflate(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(name={"deflate"}, required=1, optional=1, checkArity=false, meta=true)
    public static IRubyObject s_deflate(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        args2 = Arity.scanArgs(context, args2, 1, 1);
        int level2 = -1;
        if (!args2[1].isNil()) {
            level2 = JZlibDeflate.checkLevel(context, Convert.toInt(context, args2[1]));
        }
        RubyClass klass = (RubyClass)(recv2.isClass() ? recv2 : context.runtime.getClassFromPath("Zlib::Deflate"));
        JZlibDeflate deflate2 = (JZlibDeflate)klass.allocate(context);
        deflate2.init(context, level2, 15, 8, 0);
        try {
            IRubyObject result2 = deflate2.deflate(context, args2[0].convertToString().getByteList(), 4);
            deflate2.close(context);
            return result2;
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
    }

    public JZlibDeflate(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject _initialize(IRubyObject[] args2) {
        return this._initialize(this.getCurrentContext(), args2);
    }

    @JRubyMethod(name={"initialize"}, optional=4, checkArity=false, visibility=Visibility.PRIVATE)
    public IRubyObject _initialize(ThreadContext context, IRubyObject[] args2) {
        this.level = !(args2 = Arity.scanArgs(context, args2, 0, 4))[0].isNil() ? JZlibDeflate.checkLevel(context, Convert.toInt(context, args2[0])) : -1;
        this.windowBits = !args2[1].isNil() ? JZlibDeflate.checkWindowBits(context, Convert.toInt(context, args2[1]), false) : 15;
        int memlevel = !args2[2].isNil() ? Convert.toInt(context, args2[2]) : 8;
        this.strategy = !args2[3].isNil() ? Convert.toInt(context, args2[3]) : 0;
        this.init(context, this.level, this.windowBits, memlevel, this.strategy);
        return this;
    }

    private void init(ThreadContext context, int level2, int windowBits, int memlevel, int strategy) {
        this.flush = 0;
        this.flater = new Deflater();
        int err = this.flater.init(level2, windowBits, memlevel);
        if (err == -2) {
            throw RubyZlib.newStreamError(context, "stream error");
        }
        err = this.flater.params(level2, strategy);
        if (err == -2) {
            throw RubyZlib.newStreamError(context, "stream error");
        }
        this.collected = new byte[100];
        this.collectedIdx = 0;
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject _other) {
        if (!(_other instanceof JZlibDeflate)) {
            throw Error.typeError(context, "Expecting an instance of class JZlibDeflate");
        }
        JZlibDeflate other = (JZlibDeflate)_other;
        if (this == _other) {
            return this;
        }
        this.level = other.level;
        this.windowBits = other.windowBits;
        this.strategy = other.strategy;
        this.collected = new byte[other.collected.length];
        System.arraycopy(other.collected, 0, this.collected, 0, other.collected.length);
        this.collectedIdx = other.collectedIdx;
        this.flush = other.flush;
        this.flater = new Deflater();
        int ret = this.flater.copy(other.flater);
        if (ret != 0) {
            throw RubyZlib.newStreamError(context, "stream error");
        }
        return this;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject append(IRubyObject arg2) {
        return this.append(this.getCurrentContext(), arg2);
    }

    @JRubyMethod(name={"<<"})
    public IRubyObject append(ThreadContext context, IRubyObject arg2) {
        this.checkClosed(context);
        try {
            this.append(context, arg2.convertToString().getByteList());
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
        return this;
    }

    @JRubyMethod(name={"params"})
    public IRubyObject params(ThreadContext context, IRubyObject level2, IRubyObject strategy) {
        int err;
        int l = Convert.toInt(context, level2);
        JZlibDeflate.checkLevel(context, l);
        int s2 = Convert.toInt(context, strategy);
        JZlibDeflate.checkStrategy(context, s2);
        if (this.flater.next_out == null) {
            this.flater.setOutput(ByteList.NULL_ARRAY);
        }
        if ((err = this.flater.params(l, s2)) == -2) {
            throw RubyZlib.newStreamError(context, "stream error");
        }
        if (this.collectedIdx != this.flater.next_out_index) {
            this.collectedIdx = this.flater.next_out_index;
        }
        this.run(context);
        return context.nil;
    }

    @JRubyMethod(name={"set_dictionary"})
    public IRubyObject set_dictionary(ThreadContext context, IRubyObject arg2) {
        try {
            byte[] tmp = arg2.convertToString().getBytes();
            int err = this.flater.setDictionary(tmp, tmp.length);
            if (err == -2) {
                throw RubyZlib.newStreamError(context, "stream error: ");
            }
            this.run(context);
            return arg2;
        }
        catch (IllegalArgumentException iae) {
            throw RubyZlib.newStreamError(context, "stream error: " + iae.getMessage());
        }
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject flush(IRubyObject[] args2) {
        return this.flush(this.getCurrentContext(), args2);
    }

    @JRubyMethod(name={"flush"}, optional=1, checkArity=false)
    public IRubyObject flush(ThreadContext context, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        int flush2 = args2.length == 1 && !args2[0].isNil() ? Convert.toInt(context, args2[0]) : 2;
        return this.flush(context, flush2);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject deflate(IRubyObject[] args2) {
        return this.deflate(this.getCurrentContext(), args2);
    }

    @JRubyMethod(name={"deflate"}, required=1, optional=1, checkArity=false)
    public IRubyObject deflate(ThreadContext context, IRubyObject[] args2) {
        args2 = Arity.scanArgs(context, args2, 1, 1);
        if (this.internalFinished()) {
            throw RubyZlib.newStreamError(context, "stream error");
        }
        ByteList data2 = !args2[0].isNil() ? args2[0].convertToString().getByteList() : null;
        int flush2 = !args2[1].isNil() ? Convert.toInt(context, args2[1]) : 0;
        try {
            return this.deflate(context, data2, flush2);
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
    }

    @Override
    protected int internalTotalIn() {
        return (int)this.flater.total_in;
    }

    @Override
    protected int internalTotalOut() {
        return (int)this.flater.total_out;
    }

    @Override
    protected boolean internalStreamEndP() {
        return this.flater.finished();
    }

    @Override
    protected void internalReset(ThreadContext context) {
        this.init(context, this.level, this.windowBits, 8, this.strategy);
    }

    @Override
    public boolean internalFinished() {
        return this.flater.finished();
    }

    @Override
    protected long internalAdler() {
        return this.flater.getAdler();
    }

    @Override
    protected IRubyObject internalFinish(ThreadContext context, Block block) {
        return this.finish(context);
    }

    @Override
    protected void internalClose() {
        this.flater.end();
    }

    private void append(ThreadContext context, ByteList obj) throws IOException {
        this.flater.setInput(obj.getUnsafeBytes(), obj.getBegin(), obj.getRealSize(), true);
        this.run(context);
    }

    private IRubyObject flush(ThreadContext context, int flush2) {
        int last_flush = this.flush;
        this.flush = flush2;
        if (flush2 == 0) {
            return RubyString.newEmptyBinaryString(context.runtime);
        }
        this.run(context);
        this.flush = last_flush;
        RubyString obj = Create.newString(context, this.collected, 0, this.collectedIdx);
        this.collectedIdx = 0;
        this.flater.setOutput(this.collected);
        return obj;
    }

    private IRubyObject deflate(ThreadContext context, ByteList str, int flush2) throws IOException {
        if (null != str) {
            this.append(context, str);
        }
        return this.flush(context, flush2);
    }

    private IRubyObject finish(ThreadContext context) {
        return this.flush(context, 4);
    }

    private void run(ThreadContext context) {
        if (this.internalFinished()) {
            return;
        }
        while (!this.internalFinished()) {
            this.flater.setOutput(this.collected, this.collectedIdx, this.collected.length - this.collectedIdx);
            int err = this.flater.deflate(this.flush);
            if (err == -2) {
                throw RubyZlib.newStreamError(context, "stream error: ");
            }
            if (this.collectedIdx == this.flater.next_out_index) break;
            this.collectedIdx = this.flater.next_out_index;
            if (this.collected.length != this.collectedIdx || this.internalFinished()) continue;
            byte[] tmp = new byte[this.collected.length * 3];
            System.arraycopy(this.collected, 0, tmp, 0, this.collected.length);
            this.collected = tmp;
        }
    }
}

