/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.jruby;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.ParseResult;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObjectSpace;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.ext.jruby.CoreExt;
import org.jruby.ext.jruby.JRubyExecutionContextLocal;
import org.jruby.ext.jruby.JRubyFiberLocal;
import org.jruby.ext.jruby.JRubyThreadLocal;
import org.jruby.ext.jruby.JRubyUtilLibrary;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.builder.IRBuilder;
import org.jruby.ir.targets.JVMVisitor;
import org.jruby.ir.targets.JVMVisitorMethodContext;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaUtil;
import org.jruby.parser.ParserType;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.JavaInternalBlockBody;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.ByteList;

@JRubyModule(name={"JRuby"})
public class JRubyLibrary
implements Library {
    @Override
    public void load(Ruby runtime2, boolean wrap2) {
        ThreadContext context = runtime2.getCurrentContext();
        RubyClass Object2 = Access.objectClass(context);
        Access.loadService(context).loadFromClassLoader(runtime2.getJRubyClassLoader(), "jruby/jruby.rb", false);
        Object JRuby = ((RubyModule)Define.defineModule(context, "JRuby").defineMethods(context, JRubyLibrary.class)).defineMethods(context, JRubyUtilLibrary.class);
        ((RubyModule)((RubyModule)JRuby).defineClassUnder(context, "ThreadLocal", Object2, JRubyThreadLocal::new)).defineMethods(context, JRubyExecutionContextLocal.class);
        ((RubyModule)((RubyModule)JRuby).defineClassUnder(context, "FiberLocal", Object2, JRubyFiberLocal::new)).defineMethods(context, JRubyExecutionContextLocal.class);
        ((RubyModule)JRuby).defineModuleUnder(context, "CONFIG").tap(m -> m.singletonClass(context).defineMethods(context, JRubyConfig.class));
    }

    @JRubyMethod(module=true, name={"reference", "ref"})
    public static IRubyObject reference(ThreadContext context, IRubyObject recv2, IRubyObject obj) {
        return Java.getInstance(context.runtime, obj, false);
    }

    @JRubyMethod(module=true)
    public static IRubyObject reference0(ThreadContext context, IRubyObject recv2, IRubyObject obj) {
        return Java.wrapJavaObject(context, (Object)obj);
    }

    @JRubyMethod(module=true)
    public static IRubyObject runtime(ThreadContext context, IRubyObject recv2) {
        return Java.wrapJavaObject(context, (Object)context.runtime);
    }

    @JRubyMethod(module=true, name={"dereference", "deref"})
    public static IRubyObject dereference(ThreadContext context, IRubyObject recv2, IRubyObject obj) {
        Object unwrapped = JavaUtil.unwrapIfJavaObject(obj);
        if (unwrapped == obj) {
            throw Error.typeError(context, "got " + String.valueOf(obj.inspect(context)) + ", expected wrapped Java object");
        }
        if (unwrapped instanceof IRubyObject) {
            IRubyObject robj = (IRubyObject)unwrapped;
            return robj;
        }
        throw Error.typeError(context, "got " + String.valueOf(obj.inspect(context)) + ", expected Java-wrapped Ruby object");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(module=true)
    public static IRubyObject with_current_runtime_as_global(ThreadContext context, IRubyObject recv2, Block block) {
        Ruby current2 = context.runtime;
        Ruby global = Ruby.getGlobalRuntime();
        try {
            if (current2 != global) {
                current2.useAsGlobalRuntime();
            }
            IRubyObject iRubyObject = block.yield(context, JRubyLibrary.runtime(context, recv2));
            return iRubyObject;
        }
        finally {
            if (Ruby.getGlobalRuntime() != global) {
                global.useAsGlobalRuntime();
            }
        }
    }

    @JRubyMethod(module=true, rest=true)
    public static IRubyObject set_context_class_loader(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        ClassLoader loader = args2.length == 0 || args2[0] == context.nil ? context.runtime.getJRubyClassLoader() : (ClassLoader)JavaUtil.unwrapJavaObject(args2[0]);
        Thread.currentThread().setContextClassLoader(loader);
        return Java.wrapJavaObject(context, (Object)loader);
    }

    @JRubyMethod(name={"security_restricted?"}, module=true)
    public static RubyBoolean is_security_restricted(ThreadContext context, IRubyObject recv2) {
        return Convert.asBoolean(context, Ruby.isSecurityRestricted());
    }

    @Deprecated(since="10.0.0.0")
    public static RubyBoolean is_security_restricted(IRubyObject recv2) {
        return JRubyLibrary.is_security_restricted(((RubyBasicObject)recv2).getCurrentContext(), recv2);
    }

    @JRubyMethod(name={"security_restricted="}, module=true)
    public static IRubyObject set_security_restricted(IRubyObject recv2, IRubyObject arg2) {
        Ruby.setSecurityRestricted(arg2.isTrue());
        return JRubyLibrary.is_security_restricted(recv2);
    }

    @JRubyMethod(module=true)
    public static IRubyObject identity_hash(ThreadContext context, IRubyObject recv2, IRubyObject obj) {
        return Convert.asFixnum(context, System.identityHashCode(obj));
    }

    @JRubyMethod(module=true, name={"parse"}, alias={"ast_for"}, required=1, optional=3, checkArity=false)
    public static IRubyObject parse(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return Java.wrapJavaObject(context, JRubyLibrary.parseImpl(context, args2, block).getAST());
    }

    @JRubyMethod(module=true, name={"parse_result"}, required=1, optional=3, checkArity=false)
    public static IRubyObject parse_result(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return Java.wrapJavaObject(context, (Object)JRubyLibrary.parseImpl(context, args2, block));
    }

    private static ParseResult parseImpl(ThreadContext context, IRubyObject[] args2, Block block) {
        Encoding encoding2;
        String filename2;
        if (block.isGiven()) {
            throw context.runtime.newNotImplementedError("JRuby.parse with block returning AST no longer supported");
        }
        RubyString content = args2[0].convertToString();
        boolean inlineSource = false;
        int lineno2 = 0;
        switch (args2.length) {
            case 1: {
                filename2 = "";
                break;
            }
            case 2: {
                filename2 = args2[1].convertToString().toString();
                break;
            }
            case 3: {
                filename2 = args2[1].convertToString().toString();
                inlineSource = args2[2].isTrue();
                break;
            }
            case 4: {
                filename2 = args2[1].convertToString().toString();
                inlineSource = args2[2].isTrue();
                lineno2 = Convert.toInt(context, args2[3]);
                break;
            }
            default: {
                throw new AssertionError((Object)("unexpected arguments: " + Arrays.toString(args2)));
            }
        }
        ByteList bytes2 = content.getByteList();
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getRealSize());
        Encoding encoding3 = encoding2 = content.getEncoding() == ASCIIEncoding.INSTANCE ? context.runtime.setupSourceEncoding(UTF8Encoding.INSTANCE) : bytes2.getEncoding();
        if (inlineSource) {
            return context.runtime.getParserManager().parseMainFile(filename2, lineno2, stream, encoding2, context.getCurrentScope(), ParserType.INLINE);
        }
        return context.runtime.getParserManager().parseFile(filename2, lineno2, stream, encoding2);
    }

    @JRubyMethod(module=true, name={"compile_ir"}, required=1, optional=3, checkArity=false)
    public static IRubyObject compile_ir(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return Java.wrapJavaObject(context, (Object)JRubyLibrary.compileIR(context, args2, block));
    }

    private static IRScriptBody compileIR(ThreadContext context, IRubyObject[] args2, Block block) {
        ParseResult result2 = JRubyLibrary.parseImpl(context, args2, block);
        IRManager manager = new IRManager(context.runtime, Access.instanceConfig(context));
        manager.setBuilderFactory(context.runtime.getIRManager().getBuilderFactory());
        IRScriptBody scope = (IRScriptBody)IRBuilder.buildRoot(manager, result2).getScope();
        scope.setScriptDynamicScope(result2.getDynamicScope());
        scope.getStaticScope().setIRScope(scope);
        return scope;
    }

    @JRubyMethod(module=true, name={"compile"}, required=1, optional=3, checkArity=false)
    public static IRubyObject compile(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        int argc = Arity.checkArgumentCount(context, args2, 1, 4);
        Ruby runtime2 = context.runtime;
        RubyString content = args2[0].convertToString();
        args2[0] = content;
        RubyString filename2 = argc > 1 ? args2[1].convertToString() : Create.newEmptyString(context);
        IRScriptBody scope = JRubyLibrary.compileIR(context, args2, block);
        JVMVisitor visitor = JVMVisitor.newForJIT(runtime2);
        JVMVisitorMethodContext methodContext = new JVMVisitorMethodContext();
        byte[] bytes2 = visitor.compileToBytecode(scope, methodContext);
        scope.getStaticScope().setModule(runtime2.getTopSelf().getMetaClass());
        RubyClass CompiledScript = Access.getClass(context, "JRuby", "CompiledScript");
        return CompiledScript.newInstance(context, new IRubyObject[]{filename2, Convert.asSymbol(context, scope.getId()), content, Java.getInstance(runtime2, bytes2)}, Block.NULL_BLOCK);
    }

    @Deprecated
    public static IRubyObject load_string_ext(ThreadContext context, IRubyObject recv2) {
        CoreExt.loadStringExtensions(context);
        return context.nil;
    }

    @JRubyMethod(module=true)
    public static IRubyObject subclasses(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return JRubyLibrary.subclasses(context, recv2, arg2 instanceof RubyClass ? (RubyClass)arg2 : arg2.getMetaClass(), false);
    }

    @JRubyMethod(module=true)
    public static IRubyObject subclasses(ThreadContext context, IRubyObject recv2, IRubyObject arg2, IRubyObject opts) {
        IRubyObject all;
        boolean recurseAll = false;
        if ((opts = ArgsUtil.getOptionsArg(context, opts)) != context.nil && (all = ((RubyHash)opts).fastARef(Convert.asSymbol(context, "all"))) != null) {
            recurseAll = all.isTrue();
        }
        return JRubyLibrary.subclasses(context, recv2, arg2 instanceof RubyClass ? (RubyClass)arg2 : arg2.getMetaClass(), recurseAll);
    }

    private static RubyArray subclasses(ThreadContext context, IRubyObject recv2, final RubyClass klass, final boolean recurseAll) {
        final RubyArray<?> subclasses2 = Create.newArray(context);
        RubyClass singletonClass = klass.singletonClass(context);
        RubyObjectSpace.each_objectInternal(context, recv2, new IRubyObject[]{singletonClass}, new Block(new JavaInternalBlockBody(context.runtime, Signature.ONE_ARGUMENT){

            @Override
            public IRubyObject yield(ThreadContext context, IRubyObject[] args2) {
                return this.doYield(context, null, args2[0]);
            }

            @Override
            protected IRubyObject doYield(ThreadContext context, Block block, IRubyObject value2) {
                if (klass != value2) {
                    if (recurseAll) {
                        return subclasses2.append(context, value2);
                    }
                    if (((RubyClass)value2).superclass(context) == klass) {
                        return subclasses2.append(context, value2);
                    }
                }
                return context.nil;
            }
        }));
        return subclasses2;
    }

    public static class JRubyConfig {
        @JRubyMethod(name={"rubygems_disabled?"})
        public static IRubyObject rubygems_disabled_p(ThreadContext context, IRubyObject self2) {
            return Convert.asBoolean(context, Access.instanceConfig(context).isDisableGems());
        }

        @JRubyMethod(name={"did_you_mean_disabled?"})
        public static IRubyObject did_you_mean_disabled_p(ThreadContext context, IRubyObject self2) {
            return Convert.asBoolean(context, Access.instanceConfig(context).isDisableDidYouMean());
        }
    }
}

