/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Error;
import org.jruby.ext.ffi.AbstractInvoker;
import org.jruby.ext.ffi.Enums;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.jffi.CodeMemoryIO;
import org.jruby.ext.ffi.jffi.FFIUtil;
import org.jruby.ext.ffi.jffi.MethodFactory;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JFFIInvoker
extends AbstractInvoker {
    private final Function function;
    private final Type returnType;
    private final Type[] parameterTypes;
    private final CallingConvention convention;
    private final IRubyObject enums;

    public static RubyClass createInvokerClass(ThreadContext context, RubyModule FFI2) {
        return (RubyClass)((RubyModule)((RubyModule)FFI2.defineClassUnder(context, "Invoker", FFI2.getClass(context, "AbstractInvoker"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR)).defineMethods(context, AbstractInvoker.class, JFFIInvoker.class)).defineConstants(context, JFFIInvoker.class);
    }

    @Deprecated(since="10.0.0.0")
    JFFIInvoker(Ruby runtime2, long address2, Type returnType, Type[] parameterTypes, CallingConvention convention) {
        this(runtime2, Access.getClass(runtime2.getCurrentContext(), "FFI", "Invoker"), new CodeMemoryIO(runtime2, address2), returnType, parameterTypes, convention, null);
    }

    JFFIInvoker(Ruby runtime2, RubyClass klass, MemoryIO fptr, Type returnType, Type[] parameterTypes, CallingConvention convention, IRubyObject enums) {
        super(runtime2, klass, parameterTypes.length, fptr);
        ThreadContext context = runtime2.getCurrentContext();
        com.kenai.jffi.Type jffiReturnType = FFIUtil.getFFIType(returnType);
        if (jffiReturnType == null) {
            throw Error.argumentError(context, "Invalid return type " + String.valueOf(returnType));
        }
        com.kenai.jffi.Type[] jffiParamTypes = new com.kenai.jffi.Type[parameterTypes.length];
        for (int i2 = 0; i2 < jffiParamTypes.length; ++i2) {
            jffiParamTypes[i2] = FFIUtil.getFFIType(parameterTypes[i2]);
            if (jffiParamTypes[i2] != null) continue;
            throw Error.argumentError(context, "Invalid parameter type " + String.valueOf(parameterTypes[i2]));
        }
        this.function = new Function(fptr.address(), jffiReturnType, jffiParamTypes);
        this.parameterTypes = (Type[])parameterTypes.clone();
        this.returnType = returnType;
        this.convention = convention;
        this.enums = enums;
        RubyClass singleton = this.singletonClass(context);
        singleton.addMethod(context, "call", this.createDynamicMethod(singleton));
    }

    @JRubyMethod(name={"new"}, meta=true, required=4)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        if (!(args2[0] instanceof Pointer)) {
            throw Error.typeError(context, "Invalid function address ", args2[0], " (expected FFI::Pointer)");
        }
        if (!(args2[1] instanceof RubyArray)) {
            throw Error.typeError(context, "Invalid parameter array ", args2[1], " (expected Array)");
        }
        if (!(args2[2] instanceof Type)) {
            throw Error.typeError(context, "Invalid return type " + String.valueOf(args2[2]));
        }
        Pointer ptr = (Pointer)args2[0];
        RubyArray paramTypes = (RubyArray)args2[1];
        Type returnType = (Type)args2[2];
        String convention = "default";
        IRubyObject enums = null;
        if (args2[3] instanceof RubyHash) {
            RubyHash options2 = (RubyHash)args2[3];
            convention = options2.fastARef(Convert.asSymbol(context, "convention")).asJavaString();
            enums = options2.fastARef(Convert.asSymbol(context, "enums"));
            if (!(enums == null || enums.isNil() || enums instanceof RubyHash || enums instanceof Enums)) {
                throw Error.typeError(context, "wrong type for options[:enum] ", enums, " (expected Hash or Enums)");
            }
        } else {
            convention = args2[3].asJavaString();
        }
        Type[] parameterTypes = new Type[paramTypes.size()];
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            IRubyObject type2 = paramTypes.entry(i2);
            if (!(type2 instanceof Type)) {
                throw Error.argumentError(context, "Invalid parameter type");
            }
            Type te = (Type)type2;
            parameterTypes[i2] = te;
        }
        return new JFFIInvoker(context.runtime, (RubyClass)recv2, ptr.getMemoryIO(), returnType, parameterTypes, "stdcall".equals(convention) ? CallingConvention.STDCALL : CallingConvention.DEFAULT, enums);
    }

    @Override
    public DynamicMethod createDynamicMethod(RubyModule module) {
        return MethodFactory.createDynamicMethod(this.getRuntime(), module, this.function, this.returnType, this.parameterTypes, this.convention, this.enums, false);
    }
}

