/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyObject;
import org.jruby.RubySymbol;
import org.jruby.api.Access;
import org.jruby.api.Error;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.Enums;
import org.jruby.ext.ffi.MappedType;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.jffi.CallbackManager;
import org.jruby.ext.ffi.jffi.CodeMemoryIO;
import org.jruby.ext.ffi.jffi.Function;
import org.jruby.ext.ffi.jffi.NativeCallbackFactory;
import org.jruby.ext.ffi.jffi.NativeDataConverter;
import org.jruby.ext.ffi.jffi.NativeFunctionInfo;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;
import org.jruby.util.WeakIdentityHashMap;

public class DataConverters {
    private static final Map<IRubyObject, NativeDataConverter> enumConverters = Collections.synchronizedMap(new WeakIdentityHashMap());

    @Deprecated(since="1.7.17")
    static boolean isEnumConversionRequired(Type type2, RubyHash enums) {
        if (type2 instanceof Type.Builtin && enums != null && !enums.isEmpty()) {
            switch (type2.getNativeType()) {
                case CHAR: 
                case UCHAR: 
                case SHORT: 
                case USHORT: 
                case INT: 
                case UINT: 
                case LONG: 
                case ULONG: 
                case LONG_LONG: 
                case ULONG_LONG: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    static boolean isEnumConversionRequired(Type type2, Enums enums) {
        if (type2 instanceof Type.Builtin && enums != null && !enums.isEmpty()) {
            switch (type2.getNativeType()) {
                case CHAR: 
                case UCHAR: 
                case SHORT: 
                case USHORT: 
                case INT: 
                case UINT: 
                case LONG: 
                case ULONG: 
                case LONG_LONG: 
                case ULONG_LONG: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    static NativeDataConverter getResultConverter(Type type2) {
        if (type2 instanceof Type.Builtin) {
            return null;
        }
        if (type2 instanceof MappedType) {
            return new MappedDataConverter((MappedType)type2);
        }
        if (type2 instanceof CallbackInfo) {
            return new CallbackDataConverter((CallbackInfo)type2);
        }
        return null;
    }

    static NativeDataConverter getParameterConverter(Type type2) {
        if (type2 instanceof MappedType) {
            return new MappedDataConverter((MappedType)type2);
        }
        if (type2 instanceof CallbackInfo) {
            return new CallbackDataConverter((CallbackInfo)type2);
        }
        return null;
    }

    @Deprecated(since="1.7.17")
    static NativeDataConverter getParameterConverter(Type type2, RubyHash enums) {
        if (DataConverters.isEnumConversionRequired(type2, enums)) {
            NativeDataConverter converter = enumConverters.get(enums);
            if (converter != null) {
                return converter;
            }
            converter = new IntOrEnumConverter(NativeType.INT, enums);
            enumConverters.put(enums, converter);
            return converter;
        }
        return DataConverters.getParameterConverter(type2);
    }

    static NativeDataConverter getParameterConverter(Type type2, Enums enums) {
        if (DataConverters.isEnumConversionRequired(type2, enums)) {
            NativeDataConverter converter = enumConverters.get(enums);
            if (converter != null) {
                return converter;
            }
            converter = new IntOrEnumConverter(NativeType.INT, enums);
            enumConverters.put(enums, converter);
            return converter;
        }
        return DataConverters.getParameterConverter(type2);
    }

    public static final class MappedDataConverter
    extends NativeDataConverter {
        private final MappedType converter;

        public MappedDataConverter(MappedType converter) {
            super(converter.isReferenceRequired(), converter.isPostInvokeRequired());
            this.converter = converter;
        }

        @Override
        public NativeType nativeType() {
            return this.converter.getRealType().getNativeType();
        }

        @Override
        public IRubyObject fromNative(ThreadContext context, IRubyObject obj) {
            return this.converter.fromNative(context, obj);
        }

        @Override
        public IRubyObject toNative(ThreadContext context, IRubyObject obj) {
            return this.converter.toNative(context, obj);
        }
    }

    public static final class CallbackDataConverter
    extends NativeDataConverter {
        private final CachingCallSite callSite = new FunctionalCachingCallSite("call");
        private final NativeCallbackFactory callbackFactory;
        private final NativeFunctionInfo functionInfo;

        public CallbackDataConverter(CallbackInfo cbInfo) {
            this.callbackFactory = CallbackManager.getInstance().getCallbackFactory(cbInfo.getRuntime(), cbInfo);
            this.functionInfo = new NativeFunctionInfo(cbInfo.getRuntime(), cbInfo.getReturnType(), cbInfo.getParameterTypes(), cbInfo.isStdcall() ? CallingConvention.STDCALL : CallingConvention.DEFAULT);
        }

        @Override
        public NativeType nativeType() {
            return NativeType.POINTER;
        }

        @Override
        public IRubyObject fromNative(ThreadContext context, IRubyObject obj) {
            if (obj instanceof Pointer) {
                Pointer ptr = (Pointer)obj;
                if (ptr.getAddress() == 0L) {
                    return context.nil;
                }
                return new Function(context.runtime, Access.getClass(context, "FFI", "Function"), (MemoryIO)new CodeMemoryIO(context.runtime, ptr), this.functionInfo, null);
            }
            throw Error.typeError(context, "internal error: non-pointer");
        }

        @Override
        public IRubyObject toNative(ThreadContext context, IRubyObject obj) {
            if (obj instanceof Pointer || obj.isNil()) {
                return obj;
            }
            if (obj instanceof RubyObject) {
                RubyObject rubyObj = (RubyObject)obj;
                return this.callbackFactory.getCallback(rubyObj, this.callSite);
            }
            throw Error.typeError(context, "wrong argument type.  Expected callable object");
        }
    }

    public static final class IntOrEnumConverter
    extends NativeDataConverter {
        private final NativeType nativeType;
        private final IRubyObject enums;
        private volatile IdentityHashMap<RubySymbol, RubyInteger> symbolToValue = new IdentityHashMap();

        public IntOrEnumConverter(NativeType nativeType, IRubyObject enums) {
            this.nativeType = nativeType;
            this.enums = enums;
        }

        @Override
        public NativeType nativeType() {
            return this.nativeType;
        }

        @Override
        public IRubyObject fromNative(ThreadContext context, IRubyObject obj) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public IRubyObject toNative(ThreadContext context, IRubyObject obj) {
            if (obj instanceof RubyFixnum) {
                return obj;
            }
            return this.lookupOrConvert(context, obj);
        }

        IRubyObject lookupOrConvert(ThreadContext context, IRubyObject obj) {
            if (obj instanceof RubySymbol) {
                IRubyObject value2 = this.symbolToValue.get(obj);
                if (value2 != null) {
                    return value2;
                }
                return this.lookupAndCacheValue(context, obj);
            }
            return obj.convertToInteger();
        }

        private synchronized IRubyObject lookupAndCacheValue(ThreadContext context, IRubyObject obj) {
            IRubyObject value2;
            IRubyObject iRubyObject = value2 = this.enums instanceof Enums ? ((Enums)this.enums).mapSymbol(context, obj) : ((RubyHash)this.enums).fastARef(obj);
            if (value2.isNil() || !(value2 instanceof RubyInteger)) {
                throw Error.argumentError(context, "invalid enum value, " + String.valueOf(obj.inspect(context)));
            }
            RubyInteger integer = (RubyInteger)value2;
            IdentityHashMap<RubySymbol, RubyInteger> s2v = new IdentityHashMap<RubySymbol, RubyInteger>(this.symbolToValue);
            s2v.put((RubySymbol)obj, integer);
            this.symbolToValue = new IdentityHashMap<RubySymbol, RubyInteger>(s2v);
            return value2;
        }
    }

    public static final class ChainedDataConverter
    extends NativeDataConverter {
        private final NativeDataConverter upper;
        private final NativeDataConverter lower;

        public ChainedDataConverter(NativeDataConverter first2, NativeDataConverter second2) {
            super(first2.isReferenceRequired() || second2.isReferenceRequired(), first2.isPostInvokeRequired() || second2.isPostInvokeRequired());
            this.upper = first2;
            this.lower = second2;
        }

        @Override
        public NativeType nativeType() {
            return this.lower.nativeType();
        }

        @Override
        public IRubyObject fromNative(ThreadContext context, IRubyObject obj) {
            return this.upper.fromNative(context, this.lower.fromNative(context, obj));
        }

        @Override
        public IRubyObject toNative(ThreadContext context, IRubyObject obj) {
            return this.lower.toNative(context, this.upper.toNative(context, obj));
        }
    }
}

