#version 330
#define PI  3.14159265358
#define TAU 6.28318530718

#ifdef GL_ES
precision lowp float;
#endif

uniform float borderSize;
uniform float nodeBorderDarkenFactor;
uniform vec4 backgroundColor;
uniform float colorLightenFactor;

uniform float globalTime;
uniform float selectionTime;

#define _animationSlope(x) (1.-exp(-9.*x))
float animationTime = globalTime-selectionTime;
float animationCurve = _animationSlope(animationTime);

struct VertexData {
    vec4 color;
};

void borderColor(inout vec4 color, vec2 position) {
    float r2 = dot(position, position);
    float t = 1.0 - borderSize;
    float t2 = t * t;

    color.rgb = r2 < t2 ? color.rgb : color.rgb * nodeBorderDarkenFactor;
}in vec2 vLocal;

flat in VertexData vertexData;
out vec4 fragColor;

void main(void) {
    vec4 color = vertexData.color;
    borderColor(color, vLocal);

    
    color.rgb = mix(color.rgb, backgroundColor.rgb, colorLightenFactor * animationCurve);

    fragColor = color;
}
