#version 330
#define PI  3.14159265358
#define TAU 6.28318530718


uniform mat4 mvp;

uniform float globalTime;
uniform float selectionTime;

#define _animationSlope(x) (1.-exp(-9.*x))
float animationTime = globalTime-selectionTime;
float animationCurve = _animationSlope(animationTime);

in vec2 vert;
in vec2 position;
in vec4 elementColor;
in float size;

struct VertexData {
    vec4 color;
};

flat out VertexData vertexData;
out vec2 vLocal;

void main() {
    vLocal = vert;

    vec2 instancePosition = size * vert + position;
    gl_Position = mvp * vec4(instancePosition, 0.0, 1.0);

    
    vec4 color = elementColor.bgra / 255.0;

    color.rgb = color.rgb;
    color = mix(color, color * 1.1, animationCurve);

    vertexData.color = color;
}
