#version 330
#define PI  3.14159265358
#define TAU 6.28318530718
float edge_thickness(float edgeScaleMin,
float edgeScaleMax,
float size,
float minWeight,
float weightDifferenceDivisor) {
    if (edgeScaleMin == edgeScaleMax) {
        return size * edgeScaleMin;
    }
    return mix(edgeScaleMin, edgeScaleMax, (size - minWeight) / weightDifferenceDivisor);
}

in vec2 vert;
in vec2 position;
in vec4 elementColor;
in float size;
in float nodeSize;

uniform float globalTime;
uniform float selectionTime;

#define _animationSlope(x) (1.-exp(-9.*x))
float animationTime = globalTime-selectionTime;
float animationCurve = _animationSlope(animationTime);

uniform mat4 mvp;
uniform float colorLightenFactor;
uniform float minWeight;
uniform float weightDifferenceDivisor;
uniform float edgeScaleMin;
uniform float edgeScaleMax;
uniform float nodeScale;

struct VertexData {
    vec4 color;
    float innerRadiusSq; 
};
flat out VertexData vertexData;
out vec2 vLocal;


const float STROKE_MULTIPLIER = 1.3;

void main() {
    vLocal = vert;

    float thickness = edge_thickness(edgeScaleMin, edgeScaleMax, size, minWeight, weightDifferenceDivisor);
    float strokeWidth = thickness * STROKE_MULTIPLIER;
    float scaledNodeSize = nodeSize * nodeScale;
    float loopRadius = scaledNodeSize * 0.5 + strokeWidth * 0.33;
    vec2 instancePosition = loopRadius * vert + position + vec2(loopRadius);
    gl_Position = mvp * vec4(instancePosition, 0.0, 1.0);

    
    float innerRadius = max(0.0, 1.0 - strokeWidth / loopRadius);
    vertexData.innerRadiusSq = innerRadius * innerRadius;

    
    vec4 color = elementColor.bgra / 255.0;

    vertexData.color = color;
}
