#version 330
#define PI  3.14159265358
#define TAU 6.28318530718
float edge_thickness(float edgeScaleMin,
float edgeScaleMax,
float size,
float minWeight,
float weightDifferenceDivisor) {
    if (edgeScaleMin == edgeScaleMax) {
        return size * edgeScaleMin;
    }
    return mix(edgeScaleMin, edgeScaleMax, (size - minWeight) / weightDifferenceDivisor);
}

uniform mat4 mvp;

uniform float minWeight;
uniform float weightDifferenceDivisor;
uniform float edgeScaleMin;
uniform float edgeScaleMax;
uniform float nodeScale;

in vec3 vert;
in vec2 position;
in vec2 targetPosition;
in float size;
in vec4 elementColor;
in float sourceSize;
in float targetSize;

struct VertexData {
    vec4 color;
};
flat out VertexData vertexData;

void main() {
    float thickness = edge_thickness(edgeScaleMin, edgeScaleMax, size, minWeight, weightDifferenceDivisor);

    vec2 direction = targetPosition - position;
    vec2 directionNormalized = normalize(direction);

    vec2 sideVector = vec2(-directionNormalized.y, directionNormalized.x) * thickness * 0.5;

    vec2 lineStart = directionNormalized * (sourceSize * nodeScale);
    vec2 lineLength = (direction - lineStart) - directionNormalized * (targetSize * nodeScale);

    vec2 edgeVert = lineStart + lineLength * vert.x + sideVector * vert.y;

    gl_Position = mvp * vec4(edgeVert + position, 0.0, 1.0);

    
    vec4 color = elementColor.bgra / 255.0;

    vertexData.color = color;
}
