/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.timeline;

import java.awt.Point;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JComponent;
import org.gephi.timeline.api.TimelineChart;
import org.gephi.timeline.api.TimelineModel;
import org.gephi.ui.components.richtooltip.RichTooltip;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class TimelineTooltip {
    private static final int DELAY = 500;
    private TimelineModel model;
    private String position;
    private String min;
    private String max;
    private String y;
    private Timer timer;
    private RichTooltip tooltip;
    private final Lock lock = new ReentrantLock();

    public void setModel(TimelineModel model) {
        this.model = model;
    }

    public void start(final double currentPosition, final Point mousePosition, final JComponent component) {
        this.stop();
        if (this.model == null) {
            return;
        }
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                TimelineTooltip.this.lock.lock();
                try {
                    if (TimelineTooltip.this.tooltip != null) {
                        TimelineTooltip.this.tooltip.hideTooltip();
                    }
                    TimelineTooltip.this.buildData(currentPosition);
                    TimelineTooltip.this.tooltip = TimelineTooltip.this.buildTooltip();
                    TimelineTooltip.this.tooltip.showTooltip(component, mousePosition);
                }
                finally {
                    TimelineTooltip.this.lock.unlock();
                }
            }
        }, 500L);
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.lock.lock();
        try {
            if (this.tooltip != null) {
                this.tooltip.hideTooltip();
            }
        }
        finally {
            this.lock.unlock();
        }
        this.timer = null;
        this.tooltip = null;
    }

    private void buildData(double currentPosition) {
        TimelineChart chart;
        Number yNumber;
        switch (this.model.getTimeFormat()) {
            case DOUBLE: {
                int exponentMin = (int)Math.round(Math.log10(this.model.getCustomMin()));
                DecimalFormat decimalFormat = new DecimalFormat();
                decimalFormat.setRoundingMode(RoundingMode.HALF_EVEN);
                if (exponentMin > 0) {
                    this.min = String.valueOf(this.model.getCustomMin());
                    this.max = String.valueOf(this.model.getCustomMax());
                    this.position = String.valueOf(currentPosition);
                    break;
                }
                decimalFormat.setMaximumFractionDigits(Math.abs(exponentMin) + 2);
                this.min = decimalFormat.format(this.model.getCustomMin());
                this.max = decimalFormat.format(this.model.getCustomMax());
                this.position = decimalFormat.format(currentPosition);
                break;
            }
            case DATE: {
                LocalDateTime minDate = Instant.ofEpochMilli((long)this.model.getCustomMin()).atZone(ZoneId.systemDefault()).toLocalDateTime();
                LocalDateTime maxDate = Instant.ofEpochMilli((long)this.model.getCustomMax()).atZone(ZoneId.systemDefault()).toLocalDateTime();
                LocalDateTime posDate = Instant.ofEpochMilli((long)currentPosition).atZone(ZoneId.systemDefault()).toLocalDateTime();
                DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE;
                this.min = formatter.format(minDate);
                this.max = formatter.format(maxDate);
                this.position = formatter.format(posDate);
                break;
            }
            default: {
                LocalDateTime minDate = Instant.ofEpochMilli((long)this.model.getCustomMin()).atZone(ZoneId.systemDefault()).toLocalDateTime();
                LocalDateTime maxDate = Instant.ofEpochMilli((long)this.model.getCustomMax()).atZone(ZoneId.systemDefault()).toLocalDateTime();
                LocalDateTime posDate = Instant.ofEpochMilli((long)currentPosition).atZone(ZoneId.systemDefault()).toLocalDateTime();
                DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
                this.min = formatter.format(minDate);
                this.max = formatter.format(maxDate);
                this.position = formatter.format(posDate);
                break;
            }
        }
        this.y = this.model.getChart() != null ? ((yNumber = (chart = this.model.getChart()).getY((Number)currentPosition)) != null ? yNumber.toString() : null) : null;
    }

    private RichTooltip buildTooltip() {
        RichTooltip richTooltip = new RichTooltip();
        richTooltip.addDescriptionSection(NbBundle.getMessage(TimelineTooltip.class, (String)"TimelineTooltip.min") + ": " + this.getMin());
        richTooltip.addDescriptionSection(NbBundle.getMessage(TimelineTooltip.class, (String)"TimelineTooltip.max") + ": " + this.getMax());
        richTooltip.setTitle(this.getPosition());
        richTooltip.setMainImage(ImageUtilities.loadImage((String)"DesktopTimeline/info.svg", (boolean)false));
        if (this.getY() != null) {
            richTooltip.addFooterSection(this.model.getChart().getColumn());
            richTooltip.addFooterSection(NbBundle.getMessage(TimelineTooltip.class, (String)"TimelineTooltip.chart") + ": " + this.getY());
            richTooltip.setFooterImage(ImageUtilities.loadImage((String)"DesktopTimeline/chart.svg", (boolean)false));
        }
        return richTooltip;
    }

    public String getY() {
        return this.y;
    }

    public String getPosition() {
        return this.position;
    }

    public String getMin() {
        return this.min;
    }

    public String getMax() {
        return this.max;
    }
}

