/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.timeline;

import java.awt.Component;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.gephi.desktop.timeline.TimelineTopComponent;
import org.gephi.graph.api.TimeFormat;
import org.gephi.timeline.api.TimelineController;
import org.gephi.timeline.api.TimelineModel;
import org.jdesktop.swingx.JXHeader;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class TimeFormatDialog
extends JPanel {
    private TimelineController timelineController;
    private ButtonGroup buttonGroup;
    private JRadioButton dateRadio;
    private JRadioButton dateTimeRadio;
    private JXHeader headerTitle;
    private JRadioButton numericRadio;

    public TimeFormatDialog() {
        this.initComponents();
    }

    public void setup(TimelineModel model) {
        this.timelineController = (TimelineController)Lookup.getDefault().lookup(TimelineController.class);
        TimeFormat timeFormat = model.getTimeFormat();
        switch (timeFormat) {
            case DATE: {
                this.dateRadio.setSelected(true);
                break;
            }
            case DATETIME: {
                this.dateTimeRadio.setSelected(true);
                break;
            }
            case DOUBLE: {
                this.numericRadio.setSelected(true);
            }
        }
    }

    public void unsetup() {
        if (this.dateRadio.isSelected()) {
            this.timelineController.setTimeFormat(TimeFormat.DATE);
        } else if (this.dateTimeRadio.isSelected()) {
            this.timelineController.setTimeFormat(TimeFormat.DATETIME);
        } else {
            this.timelineController.setTimeFormat(TimeFormat.DOUBLE);
        }
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.headerTitle = new JXHeader();
        this.dateRadio = new JRadioButton();
        this.numericRadio = new JRadioButton();
        this.dateTimeRadio = new JRadioButton();
        this.headerTitle.setDescription(NbBundle.getMessage(TimelineTopComponent.class, (String)"TimeFormatDialog.headerTitle.description"));
        this.headerTitle.setIcon((Icon)ImageUtilities.loadImageIcon((String)"DesktopTimeline/time_format.svg", (boolean)false));
        this.headerTitle.setTitle(NbBundle.getMessage(TimelineTopComponent.class, (String)"TimeFormatDialog.headerTitle.title"));
        this.buttonGroup.add(this.dateRadio);
        this.dateRadio.setText(NbBundle.getMessage(TimelineTopComponent.class, (String)"TimeFormatDialog.dateRadio.text"));
        this.buttonGroup.add(this.numericRadio);
        this.numericRadio.setText(NbBundle.getMessage(TimelineTopComponent.class, (String)"TimeFormatDialog.numericRadio.text"));
        this.buttonGroup.add(this.dateTimeRadio);
        this.dateTimeRadio.setText(NbBundle.getMessage(TimeFormatDialog.class, (String)"TimeFormatDialog.dateTimeRadio.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.headerTitle, -1, 422, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(23, 23, 23).addComponent(this.numericRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dateTimeRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dateRadio).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.headerTitle, -2, 69, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numericRadio).addComponent(this.dateRadio).addComponent(this.dateTimeRadio)).addGap(0, 22, Short.MAX_VALUE)));
    }
}

