/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.timeline;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.List;
import org.gephi.desktop.timeline.DateTick;
import org.gephi.desktop.timeline.RealTick;
import org.gephi.desktop.timeline.StartEndTick;
import org.gephi.desktop.timeline.TickParameters;
import org.gephi.graph.api.TimeFormat;
import org.gephi.timeline.api.TimelineModel;

public class TickGraph {
    private static final int MIN_PIXEL_MARGIN_BETWEEN_TICKS = 5;
    private double min;
    private double max;
    private TickParameters parameters;
    private BufferedImage image;

    public BufferedImage getImage(TimelineModel model, int width, int height) {
        TickParameters.TickType timeFormat;
        double newMin = model.getCustomMin();
        double newMax = model.getCustomMax();
        TickParameters.TickType tickType = timeFormat = model.getTimeFormat().equals((Object)TimeFormat.DOUBLE) ? TickParameters.TickType.DOUBLE : TickParameters.TickType.DATE;
        if (this.parameters == null || newMax != this.max || newMin != this.min || this.parameters.getWidth() != width || this.parameters.getHeight() != height || !this.parameters.getType().equals((Object)timeFormat)) {
            this.min = newMin;
            this.max = newMax;
            this.parameters = new TickParameters(timeFormat);
            this.parameters.setWidth(width);
            this.parameters.setHeight(height);
            this.image = this.draw();
        }
        return this.image;
    }

    private BufferedImage draw() {
        BufferedImage img = new BufferedImage(this.parameters.getWidth(), this.parameters.getHeight(), 2);
        Graphics2D g = img.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.parameters.getType().equals((Object)TickParameters.TickType.DATE)) {
            this.drawDate(g);
        } else {
            this.drawReal(g);
        }
        return img;
    }

    private void drawDate(Graphics2D g) {
        int previousXLabelEnd;
        List<DateTick.Interval> intervals;
        Font bigFont;
        int width = this.parameters.getWidth();
        int height = this.parameters.getHeight();
        int fontSize = Math.min(this.parameters.getFontSize(), (int)((double)height / 4.0));
        fontSize = fontSize > this.parameters.getFontSize() / 4 && fontSize <= this.parameters.getFontSize() / 2 ? this.parameters.getFontSize() / 2 : fontSize;
        FontMetrics smallMetrics = null;
        Font smallFont = this.parameters.getFont();
        FontMetrics bigMetrics = null;
        if (smallFont != null && fontSize > this.parameters.getFontSize() / 4) {
            smallFont = smallFont.deriveFont(0, fontSize);
            smallMetrics = g.getFontMetrics(smallFont);
            bigFont = smallFont.deriveFont(0, (int)((double)fontSize * 2.5));
            bigMetrics = g.getFontMetrics(bigFont);
        } else {
            smallFont = null;
            bigFont = null;
        }
        DateTick dateTick = DateTick.create(this.min, this.max, width);
        int TOP_TICK = 0;
        int LOWER_TICK = 1;
        if (dateTick.getTypeCount() > 1) {
            g.setFont(smallFont);
            g.setColor(this.parameters.getDateColor(LOWER_TICK));
            intervals = dateTick.getIntervals(LOWER_TICK);
            previousXLabelEnd = Integer.MIN_VALUE;
            int labelWidth = smallMetrics != null ? smallMetrics.stringWidth("0000") : 0;
            for (DateTick.Interval interval : intervals) {
                long ms = interval.getStart().toEpochMilli();
                int x = dateTick.getTickPixelPosition(ms, width);
                if (x < 0) continue;
                int h = Math.min(40, (int)((double)height / 15.0));
                boolean noTickOverlap = x >= previousXLabelEnd + 5;
                if (!noTickOverlap) continue;
                g.setColor(this.parameters.getDateColor(LOWER_TICK));
                g.drawLine(x, 0, x, h);
                if (smallFont == null || width / intervals.size() <= labelWidth) continue;
                String label = dateTick.getTickValue(LOWER_TICK, interval.getStart());
                int xLabel = x + 4;
                int yLabel = (int)((double)fontSize * 1.2);
                g.setColor(this.parameters.getDateColor(TOP_TICK));
                g.drawString(label, xLabel, yLabel);
                previousXLabelEnd = x + smallMetrics.stringWidth(label);
            }
        }
        if (dateTick.getTypeCount() > 0 && bigFont != null) {
            g.setFont(bigFont);
            g.setColor(this.parameters.getDateColor(TOP_TICK));
            intervals = dateTick.getIntervals(TOP_TICK);
            previousXLabelEnd = Integer.MIN_VALUE;
            for (DateTick.Interval interval : intervals) {
                boolean noTickOverlap;
                long ms = interval.getStart().toEpochMilli();
                int x = dateTick.getTickPixelPosition(ms, width);
                String label = dateTick.getTickValue(TOP_TICK, interval.getStart());
                boolean bl = noTickOverlap = x >= previousXLabelEnd + 5;
                if (noTickOverlap && x >= 0) {
                    g.drawLine(x, 0, x, height);
                }
                int xLabel = -1;
                int yLabel = fontSize * 4;
                if (x >= 0) {
                    xLabel = x + 4;
                } else if (x > (dateTick.getTickPixelPosition(interval.getEnd().toEpochMilli(), width) - x) / -2) {
                    xLabel = 4;
                }
                if (xLabel < 0 || !noTickOverlap) continue;
                g.drawString(label, xLabel, yLabel);
                previousXLabelEnd = x + bigMetrics.stringWidth(label);
            }
        }
    }

    private void drawStartEnd(Graphics2D g) {
        int width = this.parameters.getWidth();
        int height = this.parameters.getHeight();
        Font font = this.parameters.getFont();
        FontMetrics fontMetrics = null;
        int fontSize = Math.min(this.parameters.getFontSize(), (int)((double)height / 4.0));
        int n = fontSize = fontSize > this.parameters.getFontSize() / 4 && fontSize <= this.parameters.getFontSize() / 2 ? this.parameters.getFontSize() / 2 : fontSize;
        if (font != null && fontSize > this.parameters.getFontSize() / 4) {
            font = font.deriveFont(0, fontSize);
            fontMetrics = g.getFontMetrics(font);
            g.setFont(font);
        } else {
            font = null;
        }
        if (font != null) {
            g.setColor(this.parameters.getRealColor(2));
            StartEndTick startEnd = StartEndTick.create(this.min, this.max);
            String labelStart = startEnd.getStartValue();
            String labelEnd = startEnd.getEndValue();
            int xEnd = width - fontMetrics.stringWidth(labelEnd) - (int)((double)fontSize * 0.3);
            g.drawString(labelStart, (int)((double)fontSize * 0.3), (int)((double)fontSize * 1.2));
            g.drawString(labelEnd, xEnd, (int)((double)fontSize * 1.2));
        }
    }

    private void drawReal(Graphics2D g) {
        int width = this.parameters.getWidth();
        int height = this.parameters.getHeight();
        Font font = this.parameters.getFont();
        FontMetrics fontMetrics = null;
        double factor = this.parameters.getFontFactor();
        int fontSize = Math.min(this.parameters.getFontSize(), (int)((double)height / factor));
        int n = fontSize = (double)fontSize > (double)this.parameters.getFontSize() / (factor * 2.0) && (double)fontSize <= (double)this.parameters.getFontSize() / (factor / 4.0) ? (int)((double)this.parameters.getFontSize() / (factor / 4.0)) : fontSize;
        if (font != null && (double)fontSize > (double)this.parameters.getFontSize() / (factor / 2.0)) {
            font = font.deriveFont(0, fontSize);
            fontMetrics = g.getFontMetrics(font);
            g.setFont(font);
        } else {
            font = null;
        }
        RealTick graduation = RealTick.create(this.min, this.max, width);
        int numberTicks = graduation.getNumberTicks();
        for (int i = 0; i <= numberTicks; ++i) {
            int x = graduation.getTickPixelPosition(i, width);
            int rank = graduation.getTickRank(i);
            int h = Math.min(40, (int)((double)height / 15.0));
            int n2 = rank == 2 ? h + h : (h = rank == 1 ? (int)((double)h + (double)h / 2.0) : h);
            if (x <= 0) continue;
            g.setColor(this.parameters.getRealColor(rank));
            g.drawLine(x, 0, x, h);
            if (font == null || rank < 1) continue;
            String label = graduation.getTickValue(i);
            int xLabel = x - fontMetrics.stringWidth(label) / 2;
            g.drawString(label, xLabel, (int)((double)h + (double)fontSize * 1.2));
        }
    }
}

