/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.timeline;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.HashMap;
import javax.swing.UIManager;

public class DrawerSettings {
    public Background background = new Background();
    public SelectionBox selection = new SelectionBox();
    public Stroke defaultStroke;
    public Color defaultStrokeColor;
    public Color shadowColor;
    public int hookLength;
    public RenderingHints renderingHints;
    public Kernel convolutionKernel;
    public ConvolveOp blurOperator;
    public int tmMarginTop;
    public int tmMarginBottom;
    public int topChartMargin;
    private int lastWidth = 0;
    private int lastHeight = 0;

    public DrawerSettings() {
        this.background.top = UIManager.getColor("NbExplorerView.background");
        this.background.bottom = new Color(97, 95, 93, 0);
        this.selection.top = new Color(108, 151, 194, 50);
        this.selection.bottom = new Color(57, 97, 131, 50);
        this.selection.paint = new GradientPaint(0.0f, 0.0f, this.selection.top, 0.0f, 20.0f, this.selection.bottom, true);
        this.selection.visibleHookWidth = 6;
        this.selection.invisibleHookMargin = 1;
        this.selection.minimalWidth = 16;
        this.selection.mouseOverTopColor = new Color(102, 195, 145, 50);
        this.selection.activatedTopColor = new Color(188, 118, 114, 50);
        this.selection.mouseOverBottomColor = new Color(60, 143, 96, 50);
        this.selection.activatedBottomColor = new Color(151, 79, 79, 50);
        this.selection.mouseOverPaint = new GradientPaint(0.0f, 0.0f, this.selection.mouseOverTopColor, 0.0f, 20.0f, this.selection.mouseOverBottomColor, true);
        this.selection.activatedPaint = new GradientPaint(0.0f, 0.0f, this.selection.activatedTopColor, 0.0f, 20.0f, this.selection.activatedBottomColor, true);
        this.shadowColor = new Color(35, 35, 35, 105);
        this.defaultStroke = new BasicStroke(1.0f);
        this.defaultStrokeColor = Color.black;
        this.hookLength = 8;
        this.tmMarginTop = 0;
        this.tmMarginBottom = 0;
        this.topChartMargin = 16;
        HashMap<RenderingHints.Key, Object> map = new HashMap<RenderingHints.Key, Object>();
        map.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        map.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        map.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        map.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.renderingHints = new RenderingHints(map);
    }

    void update(int width, int height) {
        if (this.lastWidth == width && this.lastHeight == height) {
            return;
        }
        this.lastWidth = width;
        this.lastHeight = height;
        this.selection.paint = new GradientPaint(0.0f, 0.0f, this.selection.top, 0.0f, height, this.selection.bottom, true);
        this.selection.mouseOverPaint = new GradientPaint(0.0f, 0.0f, this.selection.mouseOverTopColor, 0.0f, height, this.selection.mouseOverBottomColor, true);
        this.selection.activatedPaint = new GradientPaint(0.0f, 0.0f, this.selection.activatedTopColor, 0.0f, height, this.selection.activatedBottomColor, true);
    }

    public class Background {
        public Color top;
        public Color bottom;
        public Paint paint;
    }

    public class SelectionBox {
        public Color top;
        public Color bottom;
        public Paint paint;
        public int visibleHookWidth;
        public int invisibleHookMargin;
        public int minimalWidth;
        public Color mouseOverTopColor;
        public Color activatedTopColor;
        public Color mouseOverBottomColor;
        public Color activatedBottomColor;
        public Paint mouseOverPaint;
        public Paint activatedPaint;
    }
}

