/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.timeline;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;

public class DateTick {
    protected static final int MIN_PIXELS = 10;
    private final Instant min;
    private final Instant max;
    private final TickPeriod[] tickPeriods;

    public DateTick(Instant min, Instant max, ChronoUnit[] units) {
        this.min = min;
        this.max = max;
        this.tickPeriods = new TickPeriod[units.length];
        for (int i = 0; i < units.length; ++i) {
            this.tickPeriods[i] = new TickPeriod(min, max, units[i]);
        }
    }

    public static DateTick create(double min, double max, int width) {
        Instant minInstant = Instant.ofEpochMilli((long)min);
        Instant maxInstant = Instant.ofEpochMilli((long)max);
        Duration duration = Duration.between(minInstant, maxInstant);
        long days = duration.toDays();
        long hours = duration.toHours();
        long minutes = duration.toMinutes();
        long seconds = duration.getSeconds();
        ChronoUnit topUnit = days > 0L ? ChronoUnit.DAYS : (hours > 0L ? ChronoUnit.HOURS : (minutes > 0L ? ChronoUnit.MINUTES : (seconds > 0L ? ChronoUnit.SECONDS : ChronoUnit.MILLIS)));
        if (topUnit != ChronoUnit.MILLIS) {
            int intervalSize;
            ChronoUnit bottomUnit = topUnit == ChronoUnit.DAYS ? ChronoUnit.HOURS : (topUnit == ChronoUnit.HOURS ? ChronoUnit.MINUTES : (topUnit == ChronoUnit.MINUTES ? ChronoUnit.SECONDS : ChronoUnit.MILLIS));
            long intervals = duration.toMillis() / bottomUnit.getDuration().toMillis();
            if (intervals > 0L && (intervalSize = width / (int)intervals) >= 10) {
                return new DateTick(minInstant, maxInstant, new ChronoUnit[]{topUnit, bottomUnit});
            }
        }
        return new DateTick(minInstant, maxInstant, new ChronoUnit[]{topUnit});
    }

    public int getTypeCount() {
        return this.tickPeriods.length;
    }

    public List<Interval> getIntervals(int type) {
        return this.tickPeriods[type].getIntervals();
    }

    public String getTickValue(int type, Instant instant) {
        return this.tickPeriods[type].getTickValue(instant);
    }

    public ChronoUnit getDurationType(int type) {
        return this.tickPeriods[type].getDurationType();
    }

    public int getTickPixelPosition(long ms, int width) {
        long minMs = this.min.toEpochMilli();
        long maxMs = this.max.toEpochMilli();
        long duration = maxMs - minMs;
        return (int)((ms - minMs) * (long)width / duration);
    }

    private static class TickPeriod {
        protected final Instant min;
        protected final Instant max;
        protected final Duration period;
        protected final Instant interval;
        protected final ChronoUnit unit;

        public TickPeriod(Instant min, Instant max, ChronoUnit unit) {
            this.min = min;
            this.max = max;
            this.period = Duration.between(min, max);
            this.interval = min;
            this.unit = unit;
        }

        public List<Interval> getIntervals() {
            long totalIntervals = this.period.toMillis() / this.unit.getDuration().toMillis() + 2L;
            ArrayList<Interval> intervals = new ArrayList<Interval>();
            int i = 0;
            while ((long)i < totalIntervals) {
                Instant currentInterval = i == 0 ? this.min : this.min.plus((long)i, this.unit);
                intervals.add(new Interval(currentInterval, currentInterval.plus(1L, this.unit)));
                ++i;
            }
            return intervals;
        }

        public int getIntervalCount() {
            return (int)(this.period.toMillis() / this.unit.getDuration().toMillis());
        }

        public String getTickValue(Instant instant) {
            return instant.toString();
        }

        public ChronoUnit getDurationType() {
            return this.unit;
        }
    }

    public static class Interval {
        private final Instant start;
        private final Instant end;

        public Interval(Instant start, Instant end) {
            this.start = start;
            this.end = end;
        }

        public Instant getStart() {
            return this.start;
        }

        public Instant getEnd() {
            return this.end;
        }
    }
}

