/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.colorchooser;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.nimbus.NimbusLookAndFeel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import net.java.dev.colorchooser.AlphaPalette;
import net.java.dev.colorchooser.ColorChooserUI;
import net.java.dev.colorchooser.ColorParser;
import net.java.dev.colorchooser.DefaultColorChooserUI;
import net.java.dev.colorchooser.NamedColor;
import net.java.dev.colorchooser.Palette;
import net.java.dev.colorchooser.PredefinedPalette;
import net.java.dev.colorchooser.RecentColors;

public final class ColorChooser
extends JComponent {
    public static final String UI_CLASS_ID = "nbColorChooserUI";
    private transient Palette[] palettes = null;
    private Color color = Color.BLUE;
    private transient Color transientColor = null;
    private transient List actionListenerList;
    public static final String PROP_COLOR = "color";
    public static final String PROP_TRANSIENT_COLOR = "transientColor";
    public static final String PROP_CONTINUOUS_PALETTE = "continuousPalette";
    public static final String PROP_PICKER_VISIBLE = "pickerVisible";
    private boolean continuousPalette = true;
    private float preservedHue;
    private float preservedSaturation;
    private final float[] componentsScratch = new float[3];
    private boolean dragDrop;

    public ColorChooser() {
        this((Color)null);
    }

    public ColorChooser(Color initialColor) {
        this(null, initialColor);
    }

    public ColorChooser(Palette[] palettes, Color initialColor) {
        this.setPalettes(palettes);
        if (initialColor != null) {
            this.color = initialColor;
        }
        this.updateUI();
    }

    public ColorChooser(Palette[] palettes) {
        this(palettes, null);
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    @Override
    public void updateUI() {
        if (UIManager.get(UI_CLASS_ID) != null) {
            this.setUI((ColorChooserUI)UIManager.getUI(this));
        } else {
            this.setUI(DefaultColorChooserUI.createUI(this));
        }
    }

    public Color getColor() {
        return this.color;
    }

    public String getColorAsText() {
        return ColorParser.toMinimalString(this.getColor());
    }

    public boolean setAsText(String colorAsText) {
        Color c = ColorParser.parse(colorAsText);
        if (c != null) {
            this.setColor(c);
            return true;
        }
        return false;
    }

    public void setColor(Color c) {
        if (c.getClass() != Color.class) {
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
        }
        if (!Objects.equals(this.color, c)) {
            Color old = this.color;
            this.color = c;
            if (this.color != null) {
                this.updatePreservedHueAndSaturation(this.color);
            }
            this.repaint();
            this.firePropertyChange(PROP_COLOR, old, c);
        }
    }

    private void updatePreservedHueAndSaturation(Color c) {
        int red = c.getRed();
        int green = c.getGreen();
        int blue = c.getBlue();
        if (Math.abs(red - green) > 2 || Math.abs(red - blue) > 2) {
            Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), this.componentsScratch);
            this.preservedHue = this.componentsScratch[0];
            this.preservedSaturation = this.componentsScratch[1];
        }
    }

    void setTransientColor(Color c) {
        Color old = this.transientColor;
        this.transientColor = c;
        if (c != null && !this.color.equals(old) || old == null && c != null) {
            this.firePropertyChange(PROP_TRANSIENT_COLOR, old, this.getTransientColor());
            this.repaint();
        } else if (c == null) {
            this.firePropertyChange(PROP_TRANSIENT_COLOR, old, this.getColor());
            this.repaint();
        }
    }

    public Color getTransientColor() {
        return this.transientColor == null ? null : new Color(this.transientColor.getRed(), this.transientColor.getGreen(), this.transientColor.getBlue(), this.transientColor.getAlpha());
    }

    public static String colorToString(Color c) {
        NamedColor named = RecentColors.findNamedColor(c);
        if (named == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(c.getRed());
            sb.append(',');
            sb.append(c.getGreen());
            sb.append(',');
            sb.append(c.getBlue());
            return sb.toString();
        }
        return named.getDisplayName();
    }

    Color transientColor() {
        return this.transientColor;
    }

    public static String getColorName(Color color) {
        return PredefinedPalette.getColorName(color);
    }

    public void setContinuousPalettePreferred(boolean val) {
        if (val != this.continuousPalette) {
            this.continuousPalette = val;
            this.setPalettes(null);
            this.firePropertyChange(PROP_CONTINUOUS_PALETTE, !val, val);
        }
    }

    public boolean isContinuousPalettePreferred() {
        return this.continuousPalette;
    }

    public void setPalettes(Palette[] palettes) {
        if (palettes != null && palettes.length > 9) {
            throw new IllegalArgumentException("Must be <= 8 palettes");
        }
        Palette[] old = this.palettes;
        if (palettes == null) {
            palettes = Palette.getDefaultPalettes(this.continuousPalette);
            palettes = Arrays.copyOf(palettes, palettes.length + 1);
            palettes[palettes.length - 1] = new AlphaPalette(this);
        }
        this.palettes = palettes;
        this.firePropertyChange("palettes", old, palettes.clone());
    }

    public Palette[] getPalettes() {
        Palette[] result = new Palette[this.palettes.length];
        System.arraycopy(this.palettes, 0, result, 0, this.palettes.length);
        return result;
    }

    static String getString(String key) {
        String BUNDLE = "net.java.dev.colorchooser.resources.Bundle";
        try {
            return ResourceBundle.getBundle(BUNDLE).getString(key);
        }
        catch (MissingResourceException mre) {
            mre.printStackTrace();
            return key;
        }
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (this.actionListenerList == null) {
            this.actionListenerList = new ArrayList();
        }
        this.actionListenerList.add(listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        if (this.actionListenerList != null) {
            this.actionListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireActionPerformed(ActionEvent event) {
        List list;
        ColorChooser colorChooser = this;
        synchronized (colorChooser) {
            if (this.actionListenerList == null) {
                return;
            }
            list = (List)((ArrayList)this.actionListenerList).clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((ActionListener)list.get(i)).actionPerformed(event);
        }
    }

    void firePickerVisible(boolean val) {
        this.firePropertyChange(PROP_PICKER_VISIBLE, !val, val);
    }

    public boolean isDragDropEnabled() {
        return this.dragDrop;
    }

    public void setDragDropEnabled(boolean val) {
        if (this.dragDrop != val) {
            this.dragDrop = val;
            if (val) {
                DropTarget dt = new DropTarget(this, new DTL());
                this.setDropTarget(dt);
            } else {
                this.setDropTarget(null);
            }
            this.firePropertyChange("dragDropEnabled", !val, val);
        }
    }

    public boolean adjustColor(float hueBy, float saturationBy, float brightnessBy) {
        boolean changed;
        Color color = this.getColor();
        if (color == null) {
            color = new Color(128, 128, 180);
        }
        float[] components = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), components);
        if (ColorChooser.isNoSaturation(color)) {
            components[0] = this.preservedHue;
            components[1] = this.preservedSaturation;
        }
        float hue = ColorChooser.clamp(ColorChooser.rotate(components[0] + hueBy));
        float saturation = ColorChooser.clamp(components[1] + saturationBy);
        float brightness = ColorChooser.clamp(components[2] + brightnessBy);
        Color nue = new Color(Color.HSBtoRGB(hue, saturation, brightness));
        if (color.getAlpha() != 255) {
            nue = new Color(nue.getRed(), nue.getGreen(), nue.getBlue(), color.getAlpha());
        }
        boolean bl = changed = !color.equals(nue);
        if (changed) {
            this.setColor(nue);
        }
        return changed;
    }

    private static boolean isNoSaturation(Color color) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        return red == green && red == blue;
    }

    private static float rotate(float value) {
        if (value < 0.0f) {
            return 1.0f - value;
        }
        if (value > 1.0f) {
            return value - 1.0f;
        }
        return value;
    }

    private static float clamp(float value) {
        return Math.max(0.0f, Math.min(1.0f, value));
    }

    public static void main(String[] args) {
        System.setProperty("awt.useSystemAAFontSettings", "lcd_hrgb");
        try {
            UIManager.setLookAndFeel(new NimbusLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        JLabel jb1 = new JLabel("Choose a color (combine Shift/Ctrl/Alt to switch palettes)");
        JButton jb = new JButton("GC");
        final ColorChooser cc = new ColorChooser();
        cc.setFont(new Font("Arial", 0, 48));
        final boolean[] updating = new boolean[1];
        JTextField area = new JTextField(ColorParser.toMinimalString(cc.getColor()));
        cc.addActionListener(ae -> {
            jb1.setForeground(cc.getColor());
            if (!updating[0]) {
                area.setText(ColorParser.toMinimalString(cc.getColor()));
            }
        });
        area.getDocument().addDocumentListener(new DocumentListener(){
            Segment s = new Segment();

            private void updateAsText(Document doc) {
                if (updating[0]) {
                    return;
                }
                updating[0] = true;
                try {
                    doc.render(() -> {
                        try {
                            doc.getText(0, doc.getLength(), this.s);
                        }
                        catch (BadLocationException ex) {
                            ex.printStackTrace();
                        }
                    });
                    String txt = this.s.toString();
                    if (!txt.isEmpty()) {
                        cc.setAsText(txt);
                    }
                }
                finally {
                    updating[0] = false;
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateAsText(e.getDocument());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateAsText(e.getDocument());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        ColorChooser cc2 = new ColorChooser();
        cc2.addActionListener(e -> jb.setForeground(cc2.getColor()));
        cc.setDragDropEnabled(true);
        cc2.setDragDropEnabled(true);
        area.setDragEnabled(true);
        JFrame jf = new JFrame();
        jf.setDefaultCloseOperation(3);
        jf.getContentPane().setLayout(new FlowLayout());
        jf.getContentPane().add(cc);
        jb1.setBorder(null);
        jf.getContentPane().add(jb1);
        jf.getContentPane().add(cc2);
        jf.getContentPane().add(area);
        jf.setSize(500, 160);
        jf.setLocation(20, 20);
        jb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    for (int i = 0; i < 5; ++i) {
                        System.gc();
                        System.runFinalization();
                        Thread.yield();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        jf.getContentPane().add(jb);
        jf.setVisible(true);
        cc.requestFocus();
    }

    private class DTL
    implements DropTargetListener {
        private DTL() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            for (DataFlavor flavor : dtde.getCurrentDataFlavors()) {
                if (flavor != DataFlavor.stringFlavor) continue;
                try {
                    String data = (String)dtde.getTransferable().getTransferData(DataFlavor.stringFlavor);
                    if (!ColorParser.canParse(data)) {
                        dtde.rejectDrag();
                        continue;
                    }
                    dtde.acceptDrag(3);
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    Logger.getLogger(ColorChooser.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            for (DataFlavor flavor : dtde.getCurrentDataFlavors()) {
                if (flavor != DataFlavor.stringFlavor) continue;
                try {
                    Color c;
                    String data = (String)dtde.getTransferable().getTransferData(DataFlavor.stringFlavor);
                    if (!ColorParser.canParse(data) || (c = ColorParser.parse(data)) == null) continue;
                    ColorChooser.this.setColor(c);
                    dtde.dropComplete(true);
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    Logger.getLogger(ColorChooser.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

