/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.colorchooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.text.DecimalFormat;
import javax.swing.UIManager;
import net.java.dev.colorchooser.ColorChooser;
import net.java.dev.colorchooser.Palette;

public class AlphaPalette
extends Palette {
    private final ColorChooser chooser;
    private static final DecimalFormat FMT = new DecimalFormat("##0.##%" + ColorChooser.getString("alpha"));
    private final Color gray1 = new Color(164, 164, 164);
    private final Color gray2 = new Color(128, 128, 128);

    AlphaPalette(ColorChooser chooser) {
        this.chooser = chooser;
    }

    @Override
    public Color getColorAt(int x, int y) {
        Color base = this.chooser.getColor();
        int alpha = this.alphaAt(y);
        return new Color(base.getRed(), base.getGreen(), base.getBlue(), alpha);
    }

    @Override
    public String getNameAt(int x, int y) {
        float fact = Math.max(0.0f, Math.min(1.0f, this.alphaFactorAt(y)));
        return FMT.format(fact);
    }

    private float alphaFactorAt(int y) {
        float h = this.getSize().height;
        float factor = (float)y / h;
        return 1.0f - factor;
    }

    private int alphaAt(int y) {
        int result = (int)(255.0f * this.alphaFactorAt(y));
        return Math.min(255, Math.max(0, result));
    }

    @Override
    public void paintTo(Graphics g) {
        Dimension sz = this.getSize();
        for (int x = 0; x < sz.width; x += 12) {
            int xix = x / 12;
            boolean evenX = xix % 2 == 0;
            for (int y = 0; y < sz.height; y += 12) {
                boolean evenY;
                int yix = y / 12;
                boolean bl = evenY = yix % 2 == 0;
                if (evenX == evenY) {
                    g.setColor(this.gray1);
                } else {
                    g.setColor(this.gray2);
                }
                g.fillRect(x, y, 12, 12);
            }
        }
        Color c1 = this.getColorAt(0, 0);
        Color c2 = this.getColorAt(0, sz.height);
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, c1, 0.0f, sz.height, c2);
        Graphics2D gg = (Graphics2D)g;
        gg.setPaint(gp);
        gg.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        gg.fillRect(1, 1, sz.width - 2, sz.height - 2);
        gg.setColor(UIManager.getColor("controlShadow"));
        gg.drawRect(0, 0, sz.width - 1, sz.height - 1);
    }

    @Override
    public Dimension getSize() {
        return new Dimension(120, 360);
    }

    @Override
    public String getDisplayName() {
        return ColorChooser.getString("alpha");
    }
}

