/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.layout;

import java.util.ArrayList;
import java.util.List;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutProperty;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Preset {
    protected final List<String> propertyNames = new ArrayList<String>();
    protected final List<Object> propertyValues = new ArrayList<Object>();
    protected String layoutClassName;
    protected String name;

    Preset(String name, Layout layout) {
        this.name = name;
        this.layoutClassName = layout.getClass().getName();
        for (LayoutProperty p : layout.getProperties()) {
            try {
                Object value = p.getProperty().getValue();
                if (value == null) continue;
                this.propertyNames.add(p.getCanonicalName());
                this.propertyValues.add(value);
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    Preset(Document document) {
        this.readXML(document);
    }

    public void readXML(Document document) {
        NodeList propertiesList = document.getDocumentElement().getElementsByTagName("properties");
        if (propertiesList.getLength() > 0) {
            for (int j = 0; j < propertiesList.getLength(); ++j) {
                Node m = propertiesList.item(j);
                if (m.getNodeType() != 1) continue;
                Element propertiesE = (Element)m;
                this.layoutClassName = propertiesE.getAttribute("layoutClassName");
                this.name = propertiesE.getAttribute("name");
                NodeList propertyList = propertiesE.getElementsByTagName("property");
                for (int i = 0; i < propertyList.getLength(); ++i) {
                    String valStr;
                    Node n = propertyList.item(i);
                    if (n.getNodeType() != 1) continue;
                    Element propertyE = (Element)n;
                    String propStr = propertyE.getAttribute("property");
                    String classStr = propertyE.getAttribute("class");
                    Object value = this.parse(classStr, valStr = propertyE.getTextContent());
                    if (value == null) continue;
                    this.propertyNames.add(propStr);
                    this.propertyValues.add(value);
                }
                break;
            }
        }
    }

    private Object parse(String classStr, String str) {
        try {
            Class<?> c = Class.forName(classStr);
            if (c.equals(Boolean.class)) {
                return Boolean.parseBoolean(str);
            }
            if (c.equals(Integer.class)) {
                return Integer.parseInt(str);
            }
            if (c.equals(Float.class)) {
                return Float.valueOf(Float.parseFloat(str));
            }
            if (c.equals(Double.class)) {
                return Double.parseDouble(str);
            }
            if (c.equals(Long.class)) {
                return Long.parseLong(str);
            }
            if (c.equals(String.class)) {
                return str;
            }
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        return null;
    }

    public void writeXML(Document document) {
        Element rootE = document.createElement("layoutproperties");
        Element propertiesE = document.createElement("properties");
        propertiesE.setAttribute("layoutClassName", this.layoutClassName);
        propertiesE.setAttribute("name", this.name);
        propertiesE.setAttribute("version", "0.7");
        for (int i = 0; i < this.propertyNames.size(); ++i) {
            Element propertyE = document.createElement("property");
            propertyE.setAttribute("property", this.propertyNames.get(i));
            propertyE.setAttribute("class", this.propertyValues.get(i).getClass().getName());
            propertyE.setTextContent(this.propertyValues.get(i).toString());
            propertiesE.appendChild(propertyE);
        }
        rootE.appendChild(propertiesE);
        document.appendChild(rootE);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Preset other = (Preset)obj;
        return this.name == null ? other.name == null : this.name.equals(other.name);
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }
}

