/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.layout;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gephi.desktop.layout.Preset;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutProperty;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbPreferences;
import org.w3c.dom.Document;

public class LayoutPresetPersistence {
    private final Map<String, List<Preset>> presets = new HashMap<String, List<Preset>>();
    private final Map<String, String> defaultPresets = new HashMap<String, String>();

    public LayoutPresetPersistence() {
        this.loadPresets();
        for (String layoutClassName : this.presets.keySet()) {
            String defaultPreset = NbPreferences.forModule(LayoutPresetPersistence.class).get("LayoutPresetPersistence_defaultPreset_" + layoutClassName, null);
            if (defaultPreset == null || !this.hasPreset(defaultPreset, layoutClassName)) continue;
            this.defaultPresets.put(layoutClassName, defaultPreset);
            Logger.getLogger(LayoutPresetPersistence.class.getName()).log(Level.INFO, "Default preset for {0} loaded: {1}", new Object[]{layoutClassName, defaultPreset});
        }
    }

    public boolean hasPreset(String name, String layoutClassName) {
        List<Preset> layoutPresets = this.presets.get(layoutClassName);
        return layoutPresets != null && layoutPresets.stream().anyMatch(p -> p.name.equals(name));
    }

    public Preset getPreset(String name, Layout layout) {
        List<Preset> layoutPresets = this.presets.get(layout.getClass().getName());
        if (layoutPresets == null) {
            return null;
        }
        Optional<Preset> preset = layoutPresets.stream().filter(p -> p.name.equals(name)).findFirst();
        return preset.orElse(null);
    }

    public void setDefaultPresent(String name, Layout layout) {
        if (name == null) {
            this.defaultPresets.remove(layout.getClass().getName());
            NbPreferences.forModule(LayoutPresetPersistence.class).remove("LayoutPresetPersistence_defaultPreset_" + layout.getClass().getName());
        } else {
            this.defaultPresets.put(layout.getClass().getName(), name);
            NbPreferences.forModule(LayoutPresetPersistence.class).put("LayoutPresetPersistence_defaultPreset_" + layout.getClass().getName(), name);
        }
    }

    public boolean hasDefaultPreset(Layout layout) {
        return this.defaultPresets.containsKey(layout.getClass().getName());
    }

    public boolean isDefaultPreset(String name, Layout layout) {
        String defaultPreset = this.defaultPresets.get(layout.getClass().getName());
        return defaultPreset != null && defaultPreset.equals(name);
    }

    public void savePreset(String name, Layout layout) {
        Preset preset = this.addPreset(new Preset(name, layout));
        Object fos = null;
        try {
            FileObject presetFile;
            FileObject folder = FileUtil.getConfigFile((String)"layoutpresets");
            if (folder == null) {
                folder = FileUtil.getConfigRoot().createFolder("layoutpresets");
            }
            if ((presetFile = folder.getFileObject(name + ".xml")) == null) {
                presetFile = folder.createData(name, "xml");
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            document.setXmlVersion("1.0");
            document.setXmlStandalone(true);
            preset.writeXML(document);
            try (OutputStream outputStream = presetFile.getOutputStream();){
                DOMSource source = new DOMSource(document);
                StreamResult result = new StreamResult(outputStream);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.transform(source, result);
            }
        }
        catch (Exception e) {
            Logger.getLogger(LayoutPresetPersistence.class.getName()).log(Level.SEVERE, "Error while writing preset file", e);
        }
    }

    public void deletePreset(Preset preset) {
        FileObject file;
        if (this.defaultPresets.containsKey(preset.layoutClassName) && this.defaultPresets.get(preset.layoutClassName).equals(preset.name)) {
            this.defaultPresets.remove(preset.layoutClassName);
        }
        List<Preset> layoutPresets = this.presets.get(preset.layoutClassName);
        layoutPresets.remove(preset);
        FileObject folder = FileUtil.getConfigFile((String)"layoutpresets");
        if (folder != null && (file = folder.getFileObject(preset.name + ".xml")) != null) {
            try {
                file.delete();
            }
            catch (IOException ex) {
                Logger.getLogger(LayoutPresetPersistence.class.getName()).log(Level.SEVERE, "Error while deleting preset file", ex);
            }
        }
    }

    public Preset loadDefaultPreset(Layout layout) {
        String defaultPreset = this.defaultPresets.get(layout.getClass().getName());
        if (defaultPreset != null) {
            Preset preset = this.getPreset(defaultPreset, layout);
            if (preset != null) {
                return this.loadPreset(preset, layout);
            }
        } else {
            layout.resetPropertiesValues();
        }
        return null;
    }

    public Preset loadPreset(Preset preset, Layout layout) {
        for (LayoutProperty p : layout.getProperties()) {
            for (int i = 0; i < preset.propertyNames.size(); ++i) {
                if (!p.getCanonicalName().equalsIgnoreCase(preset.propertyNames.get(i)) && !p.getProperty().getName().equalsIgnoreCase(preset.propertyNames.get(i))) continue;
                try {
                    p.getProperty().setValue(preset.propertyValues.get(i));
                    continue;
                }
                catch (Exception e) {
                    Logger.getLogger(LayoutPresetPersistence.class.getName()).log(Level.SEVERE, "Error while setting preset property", e);
                }
            }
        }
        return preset;
    }

    public List<Preset> getPresets(Layout layout) {
        return this.presets.get(layout.getClass().getName());
    }

    private void loadPresets() {
        FileObject folder = FileUtil.getConfigFile((String)"layoutpresets");
        if (folder != null) {
            for (FileObject child : folder.getChildren()) {
                if (!child.isValid() || !child.hasExt("xml")) continue;
                try {
                    InputStream stream = child.getInputStream();
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document document = builder.parse(stream);
                    Preset preset = new Preset(document);
                    this.addPreset(preset);
                }
                catch (Exception e) {
                    Logger.getLogger(LayoutPresetPersistence.class.getName()).log(Level.SEVERE, "Error while reading preset file", e);
                }
            }
        }
    }

    private Preset addPreset(Preset preset) {
        List layoutPresets = this.presets.computeIfAbsent(preset.layoutClassName, k -> new ArrayList());
        for (Preset p : layoutPresets) {
            if (!p.equals(preset)) continue;
            return p;
        }
        layoutPresets.add(preset);
        return preset;
    }

    protected void reset() {
        for (String layoutClassName : this.presets.keySet()) {
            for (Preset preset : this.presets.get(layoutClassName).toArray(new Preset[0])) {
                this.deletePreset(preset);
            }
        }
    }
}

