/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.layout;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import org.gephi.desktop.layout.LayoutNode;
import org.gephi.desktop.layout.LayoutPresetPersistence;
import org.gephi.desktop.layout.Preset;
import org.gephi.layout.api.LayoutController;
import org.gephi.layout.api.LayoutModel;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutUI;
import org.gephi.ui.components.richtooltip.RichTooltip;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class LayoutPanel
extends JPanel
implements PropertyChangeListener {
    private final String NO_SELECTION = NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.choose.text");
    private LayoutModel model;
    private final LayoutController controller = (LayoutController)Lookup.getDefault().lookup(LayoutController.class);
    private final LayoutPresetPersistence layoutPresetPersistence;
    private JLabel infoLabel;
    private JComboBox layoutCombobox;
    private JPanel layoutProvidedPanel;
    private JToolBar layoutToolbar;
    private JButton presetsButton;
    private JPanel propertySheet;
    private JButton resetButton;
    private JButton runButton;

    public LayoutPanel() {
        this.initComponents();
        this.layoutPresetPersistence = new LayoutPresetPersistence();
        this.initEvents();
    }

    private void initEvents() {
        this.layoutCombobox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (LayoutPanel.this.layoutCombobox.getSelectedItem().equals(LayoutPanel.this.NO_SELECTION) && LayoutPanel.this.model.getSelectedLayout() != null) {
                    LayoutPanel.this.setSelectedLayout(null);
                } else if (LayoutPanel.this.layoutCombobox.getSelectedItem() instanceof LayoutBuilderWrapper) {
                    LayoutBuilder builder = ((LayoutBuilderWrapper)LayoutPanel.this.layoutCombobox.getSelectedItem()).getLayoutBuilder();
                    if (LayoutPanel.this.model.getSelectedLayout() == null || LayoutPanel.this.model.getSelectedBuilder() != builder) {
                        LayoutPanel.this.setSelectedLayout(builder);
                    }
                }
            }
        });
        this.infoLabel.addMouseListener(new MouseAdapter(){
            RichTooltip richTooltip;

            @Override
            public void mouseEntered(MouseEvent e) {
                if (LayoutPanel.this.infoLabel.isEnabled() && LayoutPanel.this.model != null && LayoutPanel.this.model.getSelectedLayout() != null) {
                    this.richTooltip = LayoutPanel.this.buildTooltip(LayoutPanel.this.model.getSelectedBuilder());
                    this.richTooltip.showTooltip((JComponent)LayoutPanel.this.infoLabel, e.getLocationOnScreen());
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (this.richTooltip != null) {
                    this.richTooltip.hideTooltip();
                    this.richTooltip = null;
                }
            }
        });
        this.presetsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu menu = new JPopupMenu();
                List<Preset> presets = LayoutPanel.this.layoutPresetPersistence.getPresets(LayoutPanel.this.model.getSelectedLayout());
                if (presets != null && !presets.isEmpty()) {
                    JMenuItem item;
                    for (final Preset p : presets) {
                        JMenuItem item2 = new JMenuItem(p.toString());
                        item2.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Preset appliedPreset = LayoutPanel.this.layoutPresetPersistence.loadPreset(p, LayoutPanel.this.model.getSelectedLayout());
                                LayoutPanel.this.refreshProperties();
                                if (appliedPreset != null) {
                                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.status.loadPreset", (Object)LayoutPanel.this.model.getSelectedBuilder().getName(), (Object)p.toString()));
                                }
                            }
                        });
                        menu.add(item2);
                    }
                    JMenu setDefault = new JMenu(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.presetsButton.setDefault"));
                    if (LayoutPanel.this.layoutPresetPersistence.hasDefaultPreset(LayoutPanel.this.model.getSelectedLayout())) {
                        JMenuItem item3 = new JMenuItem(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.presetsButton.setDefault.remove"));
                        item3.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                LayoutPanel.this.layoutPresetPersistence.setDefaultPresent(null, LayoutPanel.this.model.getSelectedLayout());
                                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.status.removeDefaultPreset", (Object)LayoutPanel.this.model.getSelectedBuilder().getName()));
                            }
                        });
                        setDefault.add(item3);
                    }
                    for (final Preset p : presets) {
                        boolean isDefault = LayoutPanel.this.layoutPresetPersistence.isDefaultPreset(p.toString(), LayoutPanel.this.model.getSelectedLayout());
                        item = new JCheckBoxMenuItem(p.toString(), isDefault);
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                LayoutPanel.this.layoutPresetPersistence.setDefaultPresent(p.toString(), LayoutPanel.this.model.getSelectedLayout());
                                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.status.setDefaultPreset", (Object)LayoutPanel.this.model.getSelectedBuilder().getName(), (Object)p.toString()));
                            }
                        });
                        setDefault.add(item);
                    }
                    menu.add(new JSeparator());
                    menu.add(setDefault);
                    JMenu deletePresets = new JMenu(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.presetsButton.deletePresets"));
                    for (final Preset p : presets) {
                        item = new JMenuItem(p.toString());
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                LayoutPanel.this.layoutPresetPersistence.deletePreset(p);
                                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.status.deletePreset", (Object)LayoutPanel.this.model.getSelectedBuilder().getName(), (Object)p.toString()));
                            }
                        });
                        deletePresets.add(item);
                    }
                    menu.add(new JSeparator());
                    menu.add(deletePresets);
                } else {
                    menu.add("<html><i>" + NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.presetsButton.nopreset") + "</i></html>");
                }
                JMenuItem saveItem = new JMenuItem(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.presetsButton.savePreset"));
                saveItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String input;
                        String lastPresetName = NbPreferences.forModule(LayoutPanel.class).get("LayoutPanel.lastPresetName", "");
                        NotifyDescriptor.InputLine question = new NotifyDescriptor.InputLine(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.presetsButton.savePreset.input"), NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.presetsButton.savePreset.input.name"));
                        question.setInputText(lastPresetName);
                        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)question) == NotifyDescriptor.OK_OPTION && (input = question.getInputText()) != null && !input.isEmpty()) {
                            if (LayoutPanel.this.layoutPresetPersistence.hasPreset(input, LayoutPanel.this.model.getSelectedLayout().getClass().getName())) {
                                String message = NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.presetsButton.savePresetReplace.text");
                                String title = NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.presetsButton.savePresetReplace.title");
                                NotifyDescriptor dd = new NotifyDescriptor((Object)message, title, 0, 3, null, null);
                                Object retType = DialogDisplayer.getDefault().notify(dd);
                                if (retType == NotifyDescriptor.NO_OPTION) {
                                    return;
                                }
                            }
                            LayoutPanel.this.layoutPresetPersistence.savePreset(input, LayoutPanel.this.model.getSelectedLayout());
                            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.status.savePreset", (Object)LayoutPanel.this.model.getSelectedBuilder().getName(), (Object)input));
                            NbPreferences.forModule(LayoutPanel.class).put("LayoutPanel.lastPresetName", input);
                        }
                    }
                });
                menu.add(new JSeparator());
                menu.add(saveItem);
                menu.show(LayoutPanel.this.layoutToolbar, 0, -menu.getPreferredSize().height);
            }
        });
    }

    public void refreshModel(LayoutModel layoutModel) {
        this.model = layoutModel;
        if (this.model != null) {
            this.model.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.refreshEnable();
        this.refreshModel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("selectedLayout")) {
            this.refreshModel();
        } else if (evt.getPropertyName().equals("running")) {
            this.refreshModel();
        } else if (evt.getPropertyName().equals("defaultsApplied")) {
            this.loadDefaultProperties();
        }
    }

    private void loadDefaultProperties() {
        Layout layout = this.model.getSelectedLayout();
        if (layout != null) {
            Preset appliedPreset = this.layoutPresetPersistence.loadDefaultPreset(layout);
            if (appliedPreset != null) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.status.loadPreset", (Object)this.model.getSelectedBuilder().getName(), (Object)appliedPreset.toString()));
            }
            this.refreshProperties();
        }
    }

    private void refreshModel() {
        this.refreshChooser();
        this.refreshProperties();
        if (this.model == null || !this.model.isRunning()) {
            this.runButton.setText(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.runButton.text"));
            this.runButton.setIcon(ImageUtilities.loadImageIcon((String)"DesktopLayout/run.svg", (boolean)false));
            this.runButton.setToolTipText(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.runButton.tooltip"));
        } else if (this.model.isRunning()) {
            this.runButton.setText(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.stopButton.text"));
            this.runButton.setIcon(ImageUtilities.loadImageIcon((String)"DesktopLayout/stop.svg", (boolean)false));
            this.runButton.setToolTipText(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.stopButton.tooltip"));
        }
        boolean enabled = this.model != null && this.model.getSelectedLayout() != null;
        this.runButton.setEnabled(enabled);
        this.resetButton.setEnabled(enabled);
        this.infoLabel.setEnabled(enabled);
        this.propertySheet.setEnabled(enabled);
        this.presetsButton.setEnabled(enabled);
    }

    private void refreshChooser() {
        DefaultComboBoxModel<Object> comboBoxModel = new DefaultComboBoxModel<Object>();
        comboBoxModel.addElement(this.NO_SELECTION);
        comboBoxModel.setSelectedItem(this.NO_SELECTION);
        if (this.model != null) {
            ArrayList builders = new ArrayList(Lookup.getDefault().lookupAll(LayoutBuilder.class));
            Collections.sort(builders, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((LayoutBuilder)o1).getName().compareTo(((LayoutBuilder)o2).getName());
                }
            });
            for (LayoutBuilder builder : builders) {
                LayoutBuilderWrapper item = new LayoutBuilderWrapper(builder);
                comboBoxModel.addElement(item);
                if (this.model.getSelectedLayout() == null || builder != this.model.getSelectedBuilder()) continue;
                comboBoxModel.setSelectedItem(item);
            }
        }
        this.layoutCombobox.setModel(comboBoxModel);
        if (this.model != null) {
            this.layoutCombobox.setEnabled(!this.model.isRunning());
        }
    }

    private void refreshProperties() {
        if (this.model == null || this.model.getSelectedLayout() == null) {
            ((PropertySheet)this.propertySheet).setNodes(new Node[0]);
            this.layoutProvidedPanel.setVisible(false);
            this.propertySheet.setVisible(true);
            this.layoutProvidedPanel.removeAll();
        } else {
            LayoutNode layoutNode = new LayoutNode(this.model.getSelectedLayout());
            JPanel simplePanel = null;
            try {
                simplePanel = layoutNode.getLayout().getBuilder().getUI().getSimplePanel(layoutNode.getLayout());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null != simplePanel) {
                this.propertySheet.setVisible(false);
                this.layoutProvidedPanel.setVisible(true);
                this.layoutProvidedPanel.removeAll();
                this.layoutProvidedPanel.add(simplePanel);
            } else {
                this.layoutProvidedPanel.setVisible(false);
                this.propertySheet.setVisible(true);
                this.layoutProvidedPanel.removeAll();
            }
            ((PropertySheet)this.propertySheet).setNodes(new Node[]{layoutNode});
        }
    }

    private void refreshEnable() {
        boolean enabled = this.model != null;
        this.layoutCombobox.setEnabled(enabled);
        this.runButton.setEnabled(enabled);
        this.propertySheet.setEnabled(enabled);
        this.resetButton.setEnabled(enabled);
        this.presetsButton.setEnabled(enabled);
    }

    private void setSelectedLayout(LayoutBuilder builder) {
        Layout layout = builder != null ? builder.buildLayout() : null;
        this.controller.setLayout(layout);
    }

    private void reset() {
        if (this.model.getSelectedLayout() != null) {
            this.layoutPresetPersistence.loadDefaultPreset(this.model.getSelectedLayout());
            this.refreshProperties();
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.status.reset", (Object)this.model.getSelectedBuilder().getName()));
        }
    }

    private void run() {
        this.controller.executeLayout();
    }

    private void stop() {
        this.controller.stopLayout();
    }

    private void initComponents() {
        this.layoutCombobox = new JComboBox();
        this.infoLabel = new JLabel();
        this.runButton = new JButton();
        this.layoutToolbar = new JToolBar();
        this.presetsButton = new JButton();
        this.resetButton = new JButton();
        this.layoutProvidedPanel = new JPanel();
        this.propertySheet = new PropertySheet();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.layoutCombobox, gridBagConstraints);
        this.infoLabel.setHorizontalAlignment(0);
        this.infoLabel.setIcon(ImageUtilities.loadImageIcon((String)"DesktopLayout/layoutInfo.svg", (boolean)false));
        this.infoLabel.setText(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.infoLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 7, 0, 0);
        this.add((Component)this.infoLabel, gridBagConstraints);
        this.runButton.setIcon(ImageUtilities.loadImageIcon((String)"DesktopLayout/run.svg", (boolean)false));
        this.runButton.setText(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.runButton.text"));
        this.runButton.setIconTextGap(5);
        this.runButton.setMargin(new Insets(2, 7, 2, 14));
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.runButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.add((Component)this.runButton, gridBagConstraints);
        this.layoutToolbar.setFloatable(false);
        this.layoutToolbar.setRollover(true);
        this.layoutToolbar.setOpaque(false);
        this.presetsButton.setIcon(ImageUtilities.loadImageIcon((String)"DesktopLayout/preset.svg", (boolean)false));
        this.presetsButton.setText(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.presetsButton.text"));
        this.presetsButton.setFocusable(false);
        this.presetsButton.setIconTextGap(4);
        this.layoutToolbar.add(this.presetsButton);
        this.resetButton.setText(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.resetButton.text"));
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.resetButtonActionPerformed(evt);
            }
        });
        this.layoutToolbar.add(this.resetButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.layoutToolbar, gridBagConstraints);
        this.layoutProvidedPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.layoutProvidedPanel, gridBagConstraints);
        this.propertySheet.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.propertySheet, gridBagConstraints);
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        this.reset();
    }

    private void runButtonActionPerformed(ActionEvent evt) {
        if (this.model.isRunning()) {
            this.stop();
        } else {
            this.run();
        }
    }

    private RichTooltip buildTooltip(LayoutBuilder builder) {
        String description = "";
        LayoutUI layoutUI = null;
        try {
            layoutUI = builder.getUI();
            if (layoutUI.getDescription() != null) {
                description = layoutUI.getDescription();
            }
            if (layoutUI.getQualityRank() < 0 || layoutUI.getSpeedRank() < 0) {
                layoutUI = null;
            }
        }
        catch (Exception e) {
            layoutUI = null;
        }
        RichTooltip richTooltip = new RichTooltip(builder.getName(), description);
        if (layoutUI != null) {
            LayoutDescriptionImage layoutDescriptionImage = new LayoutDescriptionImage(layoutUI);
            richTooltip.setMainImage(layoutDescriptionImage.getImage());
        }
        return richTooltip;
    }

    private static class LayoutBuilderWrapper {
        private final LayoutBuilder layoutBuilder;

        public LayoutBuilderWrapper(LayoutBuilder layoutBuilder) {
            this.layoutBuilder = layoutBuilder;
        }

        public LayoutBuilder getLayoutBuilder() {
            return this.layoutBuilder;
        }

        public String toString() {
            return this.layoutBuilder.getName();
        }
    }

    private static class LayoutDescriptionImage {
        private static final int STAR_WIDTH = 16;
        private static final int STAR_HEIGHT = 16;
        private static final int STAR_MAX = 5;
        private static final int TEXT_GAP = 5;
        private static final int LINE_GAP = 4;
        private static final int Y_BEGIN = 10;
        private static final int IMAGE_RIGHT_MARIN = 10;
        private final Image greenIcon;
        private final Image grayIcon;
        private final String qualityStr;
        private final String speedStr;
        private int textMaxSize;
        private final LayoutUI layoutUI;

        public LayoutDescriptionImage(LayoutUI layoutUI) {
            this.layoutUI = layoutUI;
            this.greenIcon = ImageUtilities.loadImage((String)"DesktopLayout/yellow.svg", (boolean)false);
            this.grayIcon = ImageUtilities.loadImage((String)"DesktopLayout/grey.svg", (boolean)false);
            this.qualityStr = NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.tooltip.quality");
            this.speedStr = NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.tooltip.speed");
        }

        public void paint(Graphics g) {
            g.setColor(Color.BLACK);
            g.drawString(this.qualityStr, 0, 24);
            this.paintStarPanel(g, this.textMaxSize + 5, 10, 5, this.layoutUI.getQualityRank());
            g.drawString(this.speedStr, 0, 44);
            this.paintStarPanel(g, this.textMaxSize + 5, 30, 5, this.layoutUI.getSpeedRank());
        }

        public Image getImage() {
            BufferedImage im = new BufferedImage(100, 100, 2);
            this.textMaxSize = 0;
            this.textMaxSize = Math.max(im.getGraphics().getFontMetrics().stringWidth(this.qualityStr), this.textMaxSize);
            this.textMaxSize = Math.max(im.getGraphics().getFontMetrics().stringWidth(this.speedStr), this.textMaxSize);
            int imageWidth = 85 + this.textMaxSize + 10;
            BufferedImage img = new BufferedImage(imageWidth, 100, 2);
            Graphics g = img.getGraphics();
            this.paint(g);
            return img;
        }

        public void paintStarPanel(Graphics g, int x, int y, int max, int value) {
            for (int i = 0; i < max; ++i) {
                if (i < value) {
                    g.drawImage(this.greenIcon, x + i * 16, y, null);
                    continue;
                }
                g.drawImage(this.grayIcon, x + i * 16, y, null);
            }
        }
    }
}

