/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.math3.special.Gamma;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.UndirectedGraph;
import org.gephi.statistics.plugin.ChartUtils;
import org.gephi.statistics.plugin.ColumnUtils;
import org.gephi.statistics.spi.Statistics;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class StatisticalInferenceClustering
implements Statistics,
LongTask {
    public static final String STAT_INF_CLASS = "stat_inf_class";
    private final boolean useWeight = false;
    private boolean isCanceled;
    private CommunityStructure structure;
    private ProgressTicket progress;
    private double descriptionLength;

    private static double lBinom(double n, double m) {
        return Gamma.logGamma((double)(n + 1.0)) - Gamma.logGamma((double)(n - m + 1.0)) - Gamma.logGamma((double)(m + 1.0));
    }

    public boolean cancel() {
        this.isCanceled = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }

    public void execute(GraphModel graphModel) {
        UndirectedGraph graph = graphModel.getUndirectedGraphVisible();
        this.execute((Graph)graph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Graph graph) {
        this.isCanceled = false;
        Table nodeTable = graph.getModel().getNodeTable();
        ColumnUtils.cleanUpColumns(nodeTable, new String[]{STAT_INF_CLASS}, Integer.class);
        Column modCol = nodeTable.getColumn(STAT_INF_CLASS);
        if (modCol == null) {
            nodeTable.addColumn(STAT_INF_CLASS, "Inferred Class", Integer.class, (Object)0);
        }
        graph.readLock();
        try {
            this.structure = new CommunityStructure(graph);
            int[] comStructure = new int[graph.getNodeCount()];
            if (graph.getNodeCount() > 0) {
                HashMap<String, Double> computedStatInfMetrics = this.computePartition(graph, this.structure, comStructure, false);
                this.descriptionLength = computedStatInfMetrics.getOrDefault("descriptionLength", 0.0);
            } else {
                this.descriptionLength = 0.0;
            }
            this.saveValues(comStructure, graph, this.structure);
        }
        finally {
            graph.readUnlock();
        }
    }

    protected HashMap<String, Double> computePartition(Graph graph, CommunityStructure theStructure, int[] comStructure, boolean weighted) {
        this.isCanceled = false;
        Progress.start((ProgressTicket)this.progress);
        Random rand = new Random();
        HashMap<String, Double> results = new HashMap<String, Double>();
        if (this.isCanceled) {
            return results;
        }
        boolean someChange = true;
        boolean initRound = true;
        while (someChange) {
            someChange = false;
            boolean localChange = true;
            while (localChange) {
                localChange = false;
                int start = 0;
                start = Math.abs(rand.nextInt()) % theStructure.N;
                int step = 0;
                int i = start;
                while (step < theStructure.N) {
                    ++step;
                    Community bestCommunity = this.updateBestCommunity(theStructure, i, initRound);
                    if (theStructure.nodeCommunities[i] != bestCommunity && bestCommunity != null) {
                        theStructure.moveNodeTo(i, bestCommunity);
                        localChange = true;
                    }
                    if (this.isCanceled) {
                        return results;
                    }
                    i = (i + 1) % theStructure.N;
                }
                someChange = localChange || someChange;
                initRound = false;
                if (!this.isCanceled) continue;
                return results;
            }
            if (!someChange) continue;
            theStructure.zoomOut();
        }
        this.fillComStructure(graph, theStructure, comStructure);
        double computedDescriptionLength = this.computeDescriptionLength(graph, theStructure);
        results.put("descriptionLength", computedDescriptionLength);
        return results;
    }

    public double delta(int node, Community community, CommunityStructure theStructure, Double e_in, Double e_out, Double E, Double B, Double N) {
        double k = theStructure.weights[node];
        double nodeWeight = theStructure.graphNodeCount[node];
        double e_r_target = community.weightSum;
        Double e_rr_target = community.internalWeightSum;
        int n_r_target = community.graphNodeCount;
        double e_r_current = theStructure.nodeCommunities[node].weightSum;
        Double e_rr_current = theStructure.nodeCommunities[node].internalWeightSum;
        int n_r_current = theStructure.nodeCommunities[node].graphNodeCount;
        double S_b = 0.0;
        S_b -= Gamma.logGamma((double)(e_out + 1.0));
        if (e_out > 0.0) {
            S_b += e_out * StatisticalInferenceClustering.lBinom(B, 2.0);
        }
        S_b += Gamma.logGamma((double)(e_r_current + 1.0));
        S_b += Gamma.logGamma((double)(e_r_target + 1.0));
        S_b -= e_rr_current * Math.log(2.0) + Gamma.logGamma((double)(e_rr_current + 1.0));
        S_b -= e_rr_target * Math.log(2.0) + Gamma.logGamma((double)(e_rr_target + 1.0));
        S_b -= Gamma.logGamma((double)(n_r_current + 1));
        S_b -= Gamma.logGamma((double)(n_r_target + 1));
        S_b += StatisticalInferenceClustering.lBinom((double)n_r_current + e_r_current - 1.0, e_r_current);
        S_b += StatisticalInferenceClustering.lBinom((double)n_r_target + e_r_target - 1.0, e_r_target);
        S_b += StatisticalInferenceClustering.lBinom(B + e_in - 1.0, e_in);
        if (B > 1.0) {
            S_b += Math.log(E + 1.0);
        }
        S_b += StatisticalInferenceClustering.lBinom(N - 1.0, B - 1.0);
        double delta_e_out = 0.0;
        double delta_e_in = 0.0;
        double delta_e_r_current = -k;
        double delta_e_r_target = k;
        double delta_e_rr_current = 0.0;
        double delta_e_rr_target = 0.0;
        for (ComputationEdge e : theStructure.topology[node]) {
            int nei = e.target;
            Float w = Float.valueOf(e.weight);
            if (nei == node) {
                delta_e_rr_current -= (double)w.floatValue();
                delta_e_rr_target += (double)w.floatValue();
                continue;
            }
            if (theStructure.nodeCommunities[node] == theStructure.nodeCommunities[nei]) {
                delta_e_rr_current -= (double)w.floatValue();
                delta_e_in -= (double)w.floatValue();
            } else {
                delta_e_out -= (double)w.floatValue();
            }
            if (community == theStructure.nodeCommunities[nei]) {
                delta_e_rr_target += (double)w.floatValue();
                delta_e_in += (double)w.floatValue();
                continue;
            }
            delta_e_out += (double)w.floatValue();
        }
        Double delta_B = 0.0;
        if (theStructure.nodeCommunities[node].weightSum == theStructure.weights[node]) {
            delta_B = -1.0;
        }
        double S_a = 0.0;
        S_a -= Gamma.logGamma((double)(e_out + delta_e_out + 1.0));
        if (e_out + delta_e_out > 0.0) {
            S_a += (e_out + delta_e_out) * StatisticalInferenceClustering.lBinom(B + delta_B, 2.0);
        }
        S_a += Gamma.logGamma((double)(e_r_target + delta_e_r_target + 1.0));
        S_a -= (e_rr_target + delta_e_rr_target) * Math.log(2.0) + Gamma.logGamma((double)(e_rr_target + delta_e_rr_target + 1.0));
        S_a -= Gamma.logGamma((double)((double)n_r_target + nodeWeight + 1.0));
        S_a += StatisticalInferenceClustering.lBinom((double)n_r_target + nodeWeight + e_r_target + delta_e_r_target - 1.0, e_r_target + delta_e_r_target);
        if (delta_B == 0.0) {
            S_a += Gamma.logGamma((double)(e_r_current + delta_e_r_current + 1.0));
            S_a -= (e_rr_current + delta_e_rr_current) * Math.log(2.0) + Gamma.logGamma((double)(e_rr_current + delta_e_rr_current + 1.0));
            S_a -= Gamma.logGamma((double)((double)n_r_current - nodeWeight + 1.0));
            S_a += StatisticalInferenceClustering.lBinom((double)n_r_current - nodeWeight + e_r_current + delta_e_r_current - 1.0, e_r_current + delta_e_r_current);
        }
        S_a += StatisticalInferenceClustering.lBinom(B + delta_B + e_in + delta_e_in - 1.0, e_in + delta_e_in);
        if (B + delta_B > 1.0) {
            S_a += Math.log(E + 1.0);
        }
        return (S_a += StatisticalInferenceClustering.lBinom(N - 1.0, B + delta_B - 1.0)) - S_b;
    }

    private Community updateBestCommunity(CommunityStructure theStructure, int node_id, boolean initialization) {
        Double E = theStructure.graphWeightSum;
        Double e_in = theStructure.communities.stream().mapToDouble(c -> c.internalWeightSum).sum();
        Double e_out = E - e_in;
        Double B = theStructure.communities.size();
        Double N = theStructure.graph.getNodeCount();
        double best = Double.MAX_VALUE;
        Community bestCommunity = null;
        Set<Community> iter = theStructure.nodeConnectionsWeight[node_id].keySet();
        for (Community com : iter) {
            if (com == theStructure.nodeCommunities[node_id]) continue;
            double deltaValue = this.delta(node_id, com, theStructure, e_in, e_out, E, B, N);
            if (Double.isNaN(deltaValue)) {
                System.out.println("WARNING - ALGO ERROR - Statistical inference - DELTA is NaN (this is not supposed to happen)");
            }
            if (!(deltaValue < 0.0) && (!initialization || !(Math.exp(-deltaValue) < Math.random())) || !(deltaValue < best)) continue;
            best = deltaValue;
            bestCommunity = com;
        }
        if (bestCommunity == null) {
            bestCommunity = theStructure.nodeCommunities[node_id];
        }
        return bestCommunity;
    }

    double computeDescriptionLength(Graph graph, CommunityStructure theStructure) {
        double E = theStructure.graphWeightSum;
        double e_in = theStructure.communities.stream().mapToDouble(c -> c.internalWeightSum).sum();
        double e_out = E - e_in;
        Double B = theStructure.communities.size();
        Double N = theStructure.graph.getNodeCount();
        double S = 0.0;
        S -= Gamma.logGamma((double)(e_out + 1.0));
        if (e_out > 0.0) {
            S += e_out * StatisticalInferenceClustering.lBinom(B, 2.0);
        }
        for (Community community : theStructure.communities) {
            double e_r = community.weightSum;
            double e_rr = community.internalWeightSum;
            int n_r = community.graphNodeCount;
            S += Gamma.logGamma((double)(e_r + 1.0));
            S -= e_rr * Math.log(2.0) + Gamma.logGamma((double)(e_rr + 1.0));
            S -= Gamma.logGamma((double)(n_r + 1));
            S += StatisticalInferenceClustering.lBinom((double)n_r + e_r - 1.0, e_r);
        }
        S += StatisticalInferenceClustering.lBinom(B + e_in - 1.0, e_in);
        if (B > 1.0) {
            S += Math.log(E + 1.0);
        }
        S += StatisticalInferenceClustering.lBinom(N - 1.0, B - 1.0);
        S += Gamma.logGamma((double)(N + 1.0));
        S += Math.log(N);
        for (Node n : graph.getNodes()) {
            double k = graph.getDegree(n);
            S -= Gamma.logGamma((double)(k + 1.0));
        }
        return S;
    }

    private int[] fillComStructure(Graph graph, CommunityStructure theStructure, int[] comStructure) {
        int count = 0;
        for (Community com : theStructure.communities) {
            for (Integer node : com.nodes) {
                Community hidden = theStructure.invMap.get(node);
                for (Integer nodeInt : hidden.nodes) {
                    comStructure[nodeInt.intValue()] = count;
                }
            }
            ++count;
        }
        return comStructure;
    }

    private void saveValues(int[] struct, Graph graph, CommunityStructure theStructure) {
        Table nodeTable = graph.getModel().getNodeTable();
        Column modCol = nodeTable.getColumn(STAT_INF_CLASS);
        for (Node n : graph.getNodes()) {
            int n_index = theStructure.map.get(n);
            n.setAttribute(modCol, (Object)struct[n_index]);
        }
    }

    public String getReport() {
        HashMap<Integer, Integer> sizeDist = new HashMap<Integer, Integer>();
        for (Node n : this.structure.graph.getNodes()) {
            Integer v = (Integer)n.getAttribute(STAT_INF_CLASS);
            if (!sizeDist.containsKey(v)) {
                sizeDist.put(v, 0);
            }
            sizeDist.put(v, (Integer)sizeDist.get(v) + 1);
        }
        XYSeries dSeries = ChartUtils.createXYSeries(sizeDist, "Size Distribution");
        XYSeriesCollection dataset1 = new XYSeriesCollection();
        dataset1.addSeries(dSeries);
        JFreeChart chart = ChartFactory.createXYLineChart((String)"Size Distribution", (String)"Stat Inf Class", (String)"Size (number of nodes)", (XYDataset)dataset1, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        chart.removeLegend();
        ChartUtils.decorateChart(chart);
        ChartUtils.scaleChart(chart, dSeries, false);
        String imageFile = ChartUtils.renderChart(chart, "communities-size-distribution.png");
        DecimalFormat f = new DecimalFormat("#0.000");
        String report = "<HTML> <BODY> <h1>Statistical Inference Report </h1> <hr><br> <h2> Results: </h2>Description Length: " + f.format(this.descriptionLength) + "<br>Number of Communities: " + this.structure.communities.size() + "<br /><br />" + imageFile + "<br /><br /><h2> Algorithm: </h2>Statistical inference of assortative community structures<br />Lizhi Zhang, Tiago P. Peixoto<br />Phys. Rev. Research 2 043271 (2020)<br />https://dx.doi.org/10.1103/PhysRevResearch.2.043271<br /><br /><br /><br />Bayesian stochastic blockmodeling<br />Tiago P. Peixoto<br />Chapter in \u201cAdvances in Network Clustering and Blockmodeling,\u201d edited by<br />P. Doreian, V. Batagelj, A. Ferligoj (Wiley, 2019)<br />https://dx.doi.org/10.1002/9781119483298.ch11<br /></BODY> </HTML>";
        return report;
    }

    public double getDescriptionLength() {
        return this.descriptionLength;
    }

    class CommunityStructure {
        HashMap<Community, Float>[] nodeConnectionsWeight;
        HashMap<Community, Integer>[] nodeConnectionsCount;
        HashMap<Node, Integer> map;
        Community[] nodeCommunities;
        Graph graph;
        double[] graphNodeCount;
        double[] weights;
        double[] internalWeights;
        double graphWeightSum;
        List<ComputationEdge>[] topology;
        List<Community> communities;
        int N;
        HashMap<Integer, Community> invMap;

        CommunityStructure(Graph graph) {
            this.graph = graph;
            this.N = graph.getNodeCount();
            this.invMap = new HashMap();
            this.nodeConnectionsWeight = new HashMap[this.N];
            this.nodeConnectionsCount = new HashMap[this.N];
            this.graphNodeCount = new double[this.N];
            this.nodeCommunities = new Community[this.N];
            this.map = new HashMap();
            this.topology = new ArrayList[this.N];
            this.communities = new ArrayList<Community>();
            int index = 0;
            this.weights = new double[this.N];
            this.internalWeights = new double[this.N];
            NodeIterable nodesIterable = graph.getNodes();
            for (Node node : nodesIterable) {
                this.map.put(node, index);
                this.nodeCommunities[index] = new Community(this);
                this.nodeConnectionsWeight[index] = new HashMap();
                this.nodeConnectionsCount[index] = new HashMap();
                this.weights[index] = 0.0;
                this.graphNodeCount[index] = 1.0;
                this.internalWeights[index] = 0.0;
                this.nodeCommunities[index].seed(index);
                Community hidden = new Community(StatisticalInferenceClustering.this.structure);
                hidden.nodes.add(index);
                this.invMap.put(index, hidden);
                this.communities.add(this.nodeCommunities[index]);
                ++index;
                if (!StatisticalInferenceClustering.this.isCanceled) continue;
                nodesIterable.doBreak();
                return;
            }
            int[] edgeTypes = graph.getModel().getEdgeTypes();
            nodesIterable = graph.getNodes();
            for (Node node : nodesIterable) {
                int node_index = this.map.get(node);
                Community com = this.nodeCommunities[node_index];
                this.topology[node_index] = new ArrayList<ComputationEdge>();
                HashSet uniqueNeighbors = new HashSet(graph.getNeighbors(node).toCollection());
                for (Node neighbor : uniqueNeighbors) {
                    if (node == neighbor) continue;
                    int neighbor_index = this.map.get(neighbor);
                    float weight = 0.0f;
                    for (int edgeType : edgeTypes) {
                        for (Edge edge : graph.getEdges(node, neighbor, edgeType)) {
                            weight += 1.0f;
                        }
                    }
                    int n = node_index;
                    this.weights[n] = this.weights[n] + (double)weight;
                    com.weightSum += (double)weight;
                    if (node_index == neighbor_index) {
                        int n2 = node_index;
                        this.internalWeights[n2] = this.internalWeights[n2] + (double)weight;
                    }
                    ComputationEdge ce = new ComputationEdge(node_index, neighbor_index, weight);
                    this.topology[node_index].add(ce);
                    Community adjCom = this.nodeCommunities[neighbor_index];
                    this.nodeConnectionsWeight[node_index].put(adjCom, Float.valueOf(weight));
                    this.nodeConnectionsCount[node_index].put(adjCom, 1);
                    Community nodeCom = this.nodeCommunities[node_index];
                    nodeCom.connectionsWeight.put(adjCom, Float.valueOf(weight));
                    nodeCom.connectionsCount.put(adjCom, 1);
                    this.nodeConnectionsWeight[neighbor_index].put(nodeCom, Float.valueOf(weight));
                    this.nodeConnectionsCount[neighbor_index].put(nodeCom, 1);
                    adjCom.connectionsWeight.put(nodeCom, Float.valueOf(weight));
                    adjCom.connectionsCount.put(nodeCom, 1);
                    this.graphWeightSum += (double)weight;
                }
                if (!StatisticalInferenceClustering.this.isCanceled) continue;
                nodesIterable.doBreak();
                return;
            }
            this.graphWeightSum /= 2.0;
        }

        private void addNodeTo(int node, Community to) {
            to.add(node);
            this.nodeCommunities[node] = to;
            for (ComputationEdge e : this.topology[node]) {
                int neighbor = e.target;
                this.nodeConnectionsWeight[neighbor].merge(to, Float.valueOf(e.weight), Float::sum);
                this.nodeConnectionsCount[neighbor].merge(to, 1, Integer::sum);
                Community adjCom = this.nodeCommunities[neighbor];
                adjCom.connectionsWeight.merge(to, Float.valueOf(e.weight), Float::sum);
                adjCom.connectionsCount.merge(to, 1, Integer::sum);
                if (node == neighbor) continue;
                this.nodeConnectionsWeight[node].merge(adjCom, Float.valueOf(e.weight), Float::sum);
                this.nodeConnectionsCount[node].merge(adjCom, 1, Integer::sum);
                if (to == adjCom) continue;
                to.connectionsWeight.merge(adjCom, Float.valueOf(e.weight), Float::sum);
                to.connectionsCount.merge(adjCom, 1, Integer::sum);
            }
            to.internalWeightSum += (double)this.nodeConnectionsWeight[node].getOrDefault(to, Float.valueOf(0.0f)).floatValue();
        }

        private void removeNodeFromItsCommunity(int node) {
            Community community = this.nodeCommunities[node];
            community.internalWeightSum -= (double)this.nodeConnectionsWeight[node].getOrDefault(community, Float.valueOf(0.0f)).floatValue();
            for (ComputationEdge e : this.topology[node]) {
                int neighbor = e.target;
                Float edgesTo = this.nodeConnectionsWeight[neighbor].get(community);
                Integer countEdgesTo = this.nodeConnectionsCount[neighbor].get(community);
                if (countEdgesTo - 1 == 0) {
                    this.nodeConnectionsWeight[neighbor].remove(community);
                    this.nodeConnectionsCount[neighbor].remove(community);
                } else {
                    this.nodeConnectionsWeight[neighbor].put(community, Float.valueOf(edgesTo.floatValue() - e.weight));
                    this.nodeConnectionsCount[neighbor].put(community, countEdgesTo - 1);
                }
                Community adjCom = this.nodeCommunities[neighbor];
                Float oEdgesto = adjCom.connectionsWeight.get(community);
                Integer oCountEdgesto = adjCom.connectionsCount.get(community);
                if (oCountEdgesto - 1 == 0) {
                    adjCom.connectionsWeight.remove(community);
                    adjCom.connectionsCount.remove(community);
                } else {
                    adjCom.connectionsWeight.put(community, Float.valueOf(oEdgesto.floatValue() - e.weight));
                    adjCom.connectionsCount.put(community, oCountEdgesto - 1);
                }
                if (node == neighbor) continue;
                if (adjCom != community) {
                    Float comEdgesto = community.connectionsWeight.get(adjCom);
                    Integer comCountEdgesto = community.connectionsCount.get(adjCom);
                    if (comCountEdgesto - 1 == 0) {
                        community.connectionsWeight.remove(adjCom);
                        community.connectionsCount.remove(adjCom);
                    } else {
                        community.connectionsWeight.put(adjCom, Float.valueOf(comEdgesto.floatValue() - e.weight));
                        community.connectionsCount.put(adjCom, comCountEdgesto - 1);
                    }
                }
                Float nodeEgesTo = this.nodeConnectionsWeight[node].get(adjCom);
                Integer nodeCountEgesTo = this.nodeConnectionsCount[node].get(adjCom);
                if (nodeCountEgesTo - 1 == 0) {
                    this.nodeConnectionsWeight[node].remove(adjCom);
                    this.nodeConnectionsCount[node].remove(adjCom);
                    continue;
                }
                this.nodeConnectionsWeight[node].put(adjCom, Float.valueOf(nodeEgesTo.floatValue() - e.weight));
                this.nodeConnectionsCount[node].put(adjCom, nodeCountEgesTo - 1);
            }
            community.remove(node);
        }

        private void moveNodeTo(int node, Community to) {
            this.removeNodeFromItsCommunity(node);
            this.addNodeTo(node, to);
        }

        protected void _moveNodeTo(int node, Community to) {
            this.moveNodeTo(node, to);
        }

        protected void _zoomOut() {
            this.zoomOut();
        }

        private void zoomOut() {
            Community com;
            int i;
            int M = this.communities.size();
            ArrayList[] newTopology = new ArrayList[M];
            int index = 0;
            this.nodeCommunities = new Community[M];
            this.nodeConnectionsWeight = new HashMap[M];
            this.nodeConnectionsCount = new HashMap[M];
            double[] oldGraphNodeCount = (double[])this.graphNodeCount.clone();
            HashMap<Integer, Community> newInvMap = new HashMap<Integer, Community>();
            for (i = 0; i < this.communities.size(); ++i) {
                com = this.communities.get(i);
                this.nodeConnectionsWeight[index] = new HashMap();
                this.nodeConnectionsCount[index] = new HashMap();
                newTopology[index] = new ArrayList();
                this.nodeCommunities[index] = new Community(com);
                Set<Community> iter = com.connectionsWeight.keySet();
                double weightSum = 0.0;
                double graphNodeSum = 0.0;
                Community hidden = new Community(StatisticalInferenceClustering.this.structure);
                for (Integer nodeInt : com.nodes) {
                    graphNodeSum += oldGraphNodeCount[nodeInt];
                    Community oldHidden = this.invMap.get(nodeInt);
                    hidden.nodes.addAll(oldHidden.nodes);
                }
                newInvMap.put(index, hidden);
                for (Community adjCom : iter) {
                    int target = this.communities.indexOf(adjCom);
                    float weight = com.connectionsWeight.get(adjCom).floatValue();
                    weightSum = target == index ? (weightSum += 2.0 * (double)weight) : (weightSum += (double)weight);
                    ComputationEdge e = new ComputationEdge(index, target, weight);
                    newTopology[index].add(e);
                }
                this.weights[index] = weightSum;
                this.graphNodeCount[index] = graphNodeSum;
                this.internalWeights[index] = com.internalWeightSum;
                this.nodeCommunities[index].seed(index);
                ++index;
            }
            this.communities.clear();
            for (i = 0; i < M; ++i) {
                com = this.nodeCommunities[i];
                this.communities.add(com);
                for (ComputationEdge e : newTopology[i]) {
                    this.nodeConnectionsWeight[i].put(this.nodeCommunities[e.target], Float.valueOf(e.weight));
                    this.nodeConnectionsCount[i].put(this.nodeCommunities[e.target], 1);
                    com.connectionsWeight.put(this.nodeCommunities[e.target], Float.valueOf(e.weight));
                    com.connectionsCount.put(this.nodeCommunities[e.target], 1);
                }
            }
            this.N = M;
            this.topology = newTopology;
            this.invMap = newInvMap;
        }

        public String getMonitoring() {
            Object monitoring = "";
            for (Community com : this.communities) {
                monitoring = (String)monitoring + "com" + com.id + "[";
                int count = 0;
                for (Integer node : com.nodes) {
                    Community hidden = this.invMap.get(node);
                    if (count++ > 0) {
                        monitoring = (String)monitoring + " ";
                    }
                    monitoring = (String)monitoring + "n" + node + "(" + hidden.getMonitoring() + ")";
                }
                monitoring = (String)monitoring + "]  ";
            }
            return monitoring;
        }

        public boolean checkIntegrity() {
            boolean integrity = true;
            Double E = this.graphWeightSum;
            Double e_in = this.communities.stream().mapToDouble(c -> c.internalWeightSum).sum();
            Double e_out = E - e_in;
            Double B = this.communities.size();
            Double N = this.graph.getNodeCount();
            double nodeComWeightSum = 0.0;
            for (int node = 0; node < this.nodeConnectionsWeight.length; ++node) {
                HashMap<Community, Float> hm = this.nodeConnectionsWeight[node];
                Collection<Float> values = hm.values();
                nodeComWeightSum += values.stream().mapToDouble(v -> v.floatValue()).sum();
            }
            return integrity;
        }
    }

    static class Community {
        static int count = 0;
        protected int id = count++;
        double weightSum = 0.0;
        double internalWeightSum;
        int graphNodeCount;
        CommunityStructure structure;
        List<Integer> nodes;
        HashMap<Community, Float> connectionsWeight;
        HashMap<Community, Integer> connectionsCount;

        public Community(Community com) {
            this.structure = com.structure;
            this.connectionsWeight = new HashMap();
            this.connectionsCount = new HashMap();
            this.nodes = new ArrayList<Integer>();
        }

        public Community(CommunityStructure structure) {
            this.structure = structure;
            this.connectionsWeight = new HashMap();
            this.connectionsCount = new HashMap();
            this.nodes = new ArrayList<Integer>();
        }

        public int size() {
            return this.nodes.size();
        }

        public void seed(int node) {
            this.nodes.add(node);
            this.weightSum += this.structure.weights[node];
            this.internalWeightSum += this.structure.internalWeights[node];
            this.graphNodeCount = (int)((double)this.graphNodeCount + this.structure.graphNodeCount[node]);
        }

        public boolean add(int node) {
            this.nodes.add(node);
            this.weightSum += this.structure.weights[node];
            this.graphNodeCount = (int)((double)this.graphNodeCount + this.structure.graphNodeCount[node]);
            return true;
        }

        public boolean remove(int node) {
            boolean result = this.nodes.remove((Object)node);
            this.weightSum -= this.structure.weights[node];
            this.graphNodeCount = (int)((double)this.graphNodeCount - this.structure.graphNodeCount[node]);
            if (this.nodes.isEmpty()) {
                this.structure.communities.remove(this);
            }
            return result;
        }

        public String getMonitoring() {
            Object monitoring = "";
            int count = 0;
            for (int nodeIndex : this.nodes) {
                if (count++ > 0) {
                    monitoring = (String)monitoring + " ";
                }
                monitoring = (String)monitoring + nodeIndex;
            }
            return monitoring;
        }
    }

    static class ComputationEdge {
        int source;
        int target;
        float weight;

        public ComputationEdge(int s, int t, float w) {
            this.source = s;
            this.target = t;
            this.weight = w;
        }
    }
}

