/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.ui.components.IconWithArrow;
import org.openide.util.ImageUtilities;

public class JPopupButton
extends JButton {
    private final ArrayList<JPopupButtonItem> items = new ArrayList();
    private JPopupButtonItem selectedItem;
    private ChangeListener listener;

    public JPopupButton() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu menu = JPopupButton.this.createPopup();
                menu.show(JPopupButton.this, 0, JPopupButton.this.getHeight());
            }
        });
    }

    @Override
    public void setIcon(Icon defaultIcon) {
        IconWithArrow iconWithArrow = new IconWithArrow(defaultIcon, false);
        super.setIcon(iconWithArrow);
        Icon disabled = UIManager.getLookAndFeel().getDisabledIcon(this, iconWithArrow);
        if (disabled == null) {
            disabled = new ImageIcon(GrayFilter.createDisabledImage(ImageUtilities.icon2Image((Icon)iconWithArrow)));
        }
        super.setDisabledIcon(disabled);
        super.setDisabledSelectedIcon(disabled);
    }

    public JPopupMenu createPopup() {
        JPopupMenu menu = new JPopupMenu();
        for (final JPopupButtonItem item : this.items) {
            Color selectionBackground;
            final JRadioButtonMenuItem r = new JRadioButtonMenuItem(item.toString(), item.icon, item == this.selectedItem);
            r.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (item != JPopupButton.this.selectedItem) {
                        JPopupButton.this.selectedItem = item;
                        JPopupButton.this.fireChangeEvent();
                    }
                }
            });
            r.setOpaque(true);
            final Color defaultBackground = UIManager.getColor("MenuItem.background") != null ? UIManager.getColor("MenuItem.background") : r.getBackground();
            Color color = selectionBackground = UIManager.getColor("MenuItem.selectionBackground") != null ? UIManager.getColor("MenuItem.selectionBackground") : defaultBackground;
            if (item == this.selectedItem) {
                r.setBackground(selectionBackground);
            }
            final Color defaultForeground = UIManager.getColor("MenuItem.foreground") != null ? UIManager.getColor("MenuItem.foreground") : r.getForeground();
            final Color selectionForeground = UIManager.getColor("MenuItem.selectionForeground") != null ? UIManager.getColor("MenuItem.selectionForeground") : defaultForeground;
            r.setForeground(item == this.selectedItem ? selectionForeground : defaultForeground);
            r.setSelected(item == this.selectedItem);
            r.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    boolean armed = r.getModel().isArmed();
                    boolean active = armed || item == JPopupButton.this.selectedItem;
                    r.setBackground(active ? selectionBackground : defaultBackground);
                    r.setForeground(active ? selectionForeground : defaultForeground);
                }
            });
            menu.add(r);
        }
        return menu;
    }

    public void addItem(Object object, Icon icon) {
        this.items.add(new JPopupButtonItem(object, icon, null));
    }

    public void addItem(Object object, Icon icon, String displayString) {
        this.items.add(new JPopupButtonItem(object, icon, displayString));
    }

    public Object getSelectedItem() {
        return this.selectedItem.object;
    }

    public void setSelectedItem(Object item) {
        for (JPopupButtonItem i : this.items) {
            if (i.object != item) continue;
            this.selectedItem = i;
            return;
        }
        throw new IllegalArgumentException("This element doesn't exist.");
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.listener = changeListener;
    }

    private void fireChangeEvent() {
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this.selectedItem.object));
        }
    }

    private static class JPopupButtonItem {
        private final Object object;
        private final Icon icon;
        private final String displayString;

        public JPopupButtonItem(Object object, Icon icon, String displayString) {
            this.object = object;
            this.icon = icon;
            this.displayString = displayString;
        }

        public String toString() {
            if (this.displayString != null) {
                return this.displayString;
            }
            return this.object.toString();
        }
    }
}

