/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

class JMenuToggleButton
extends JToggleButton {
    private boolean mouseInArrowArea = false;

    public JMenuToggleButton(final Icon regIcon, Icon rollOverIcon, int arrowWidth) {
        assert (null != regIcon);
        assert (null != rollOverIcon);
        final LineIcon lineIcon = new LineIcon(rollOverIcon, arrowWidth);
        this.setIcon(regIcon);
        this.setRolloverIcon(lineIcon);
        this.setRolloverSelectedIcon(lineIcon);
        this.setFocusable(false);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                JMenuToggleButton.this.mouseInArrowArea = JMenuToggleButton.this.isInArrowArea(e.getPoint());
                JMenuToggleButton.this.setRolloverIcon(JMenuToggleButton.this.mouseInArrowArea ? regIcon : lineIcon);
                JMenuToggleButton.this.setRolloverSelectedIcon(JMenuToggleButton.this.mouseInArrowArea ? regIcon : lineIcon);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JPopupMenu popup;
                if (JMenuToggleButton.this.isInArrowArea(e.getPoint()) && null != (popup = JMenuToggleButton.this.getPopupMenu())) {
                    popup.show(JMenuToggleButton.this, 0, JMenuToggleButton.this.getHeight());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                JMenuToggleButton.this.mouseInArrowArea = JMenuToggleButton.this.isInArrowArea(e.getPoint());
                JMenuToggleButton.this.setRolloverIcon(JMenuToggleButton.this.mouseInArrowArea ? regIcon : lineIcon);
                JMenuToggleButton.this.setRolloverSelectedIcon(JMenuToggleButton.this.mouseInArrowArea ? regIcon : lineIcon);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JMenuToggleButton.this.mouseInArrowArea = false;
                JMenuToggleButton.this.setRolloverIcon(regIcon);
                JMenuToggleButton.this.setRolloverSelectedIcon(regIcon);
            }
        });
        this.setModel(new Model());
    }

    protected JPopupMenu getPopupMenu() {
        return null;
    }

    private boolean isInArrowArea(Point p) {
        return p.getLocation().x >= this.getWidth() - 3 - 2 - this.getInsets().right;
    }

    private static class LineIcon
    implements Icon {
        private final Icon origIcon;
        private final int arrowWidth;

        public LineIcon(Icon origIcon, int arrowWidth) {
            this.origIcon = origIcon;
            this.arrowWidth = arrowWidth;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.origIcon.paintIcon(c, g, x, y);
            g.setColor(UIManager.getColor("controlHighlight"));
            g.drawLine(x + this.origIcon.getIconWidth() - this.arrowWidth - 2, y, x + this.origIcon.getIconWidth() - this.arrowWidth - 2, y + this.getIconHeight());
            g.setColor(UIManager.getColor("controlShadow"));
            g.drawLine(x + this.origIcon.getIconWidth() - this.arrowWidth - 3, y, x + this.origIcon.getIconWidth() - this.arrowWidth - 3, y + this.getIconHeight());
        }

        @Override
        public int getIconWidth() {
            return this.origIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.origIcon.getIconHeight();
        }
    }

    private class Model
    extends JToggleButton.ToggleButtonModel {
        private Model() {
        }

        @Override
        public void setPressed(boolean b) {
            if (JMenuToggleButton.this.mouseInArrowArea) {
                return;
            }
            super.setPressed(b);
        }
    }
}

