/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components;

import com.bric.swing.ColorPicker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.openide.windows.WindowManager;

public class JColorButton
extends JButton {
    private static final int ICON_WIDTH = 16;
    private static final int ICON_HEIGHT = 16;
    private static final Color DISABLED_BORDER = new Color(200, 200, 200);
    private static final Color DISABLED_FILL = new Color(220, 220, 220);
    public static String EVENT_COLOR = "color";
    private Color color;
    private boolean includeOpacity;

    public JColorButton(Color originalColor) {
        this(originalColor, false, false);
    }

    public JColorButton(Color originalColor, boolean rightClick, boolean includeOpacity) {
        this.includeOpacity = includeOpacity;
        this.color = originalColor;
        this.setIcon(new Icon(){

            @Override
            public int getIconWidth() {
                return 16;
            }

            @Override
            public int getIconHeight() {
                return 16;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                if (c.isEnabled()) {
                    g.setColor(Color.BLACK);
                    g.drawRect(x + 2, y + 2, 11, 11);
                    if (JColorButton.this.color != null) {
                        g.setColor(JColorButton.this.color);
                        g.fillRect(x + 3, y + 3, 10, 10);
                    }
                } else {
                    g.setColor(DISABLED_BORDER);
                    g.drawRect(x + 2, y + 2, 11, 11);
                    g.setColor(DISABLED_FILL);
                    g.fillRect(x + 3, y + 3, 10, 10);
                }
            }
        });
        if (rightClick) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Color newColor;
                    if (SwingUtilities.isRightMouseButton(e) && (newColor = ColorPicker.showDialog((Window)WindowManager.getDefault().getMainWindow(), (Color)JColorButton.this.color, (boolean)JColorButton.this.includeOpacity)) != null) {
                        JColorButton.this.setColor(newColor);
                    }
                }
            });
        } else {
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color newColor = ColorPicker.showDialog((Window)WindowManager.getDefault().getMainWindow(), (Color)JColorButton.this.color, (boolean)JColorButton.this.includeOpacity);
                    if (newColor != null) {
                        JColorButton.this.setColor(newColor);
                    }
                }
            });
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (!Objects.equals(color, this.color)) {
            Color oldColor = this.color;
            this.color = color;
            this.firePropertyChange(EVENT_COLOR, oldColor, color);
            this.repaint();
        }
    }

    public float[] getColorArray() {
        return new float[]{(float)this.color.getRed() / 255.0f, (float)this.color.getGreen() / 255.0f, (float)this.color.getBlue() / 255.0f, (float)this.color.getAlpha() / 255.0f};
    }

    public void setIncludeOpacity(boolean includeOpacity) {
        this.includeOpacity = includeOpacity;
    }
}

